/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.documentation;

import com.intellij.codeInsight.CodeInsightBundle;
import com.intellij.codeInsight.documentation.DocumentationManager;
import com.intellij.ide.BrowserUtil;
import com.intellij.lang.javascript.DialectDetector;
import com.intellij.lang.javascript.DialectOptionHolder;
import com.intellij.lang.javascript.JSBundle;
import com.intellij.lang.javascript.actions.JSShowTypeInfoAction;
import com.intellij.lang.javascript.documentation.JSDocumentationProcessor;
import com.intellij.lang.javascript.documentation.JSDocumentationProvider;
import com.intellij.lang.javascript.documentation.JSDocumentationUtils;
import com.intellij.lang.javascript.documentation.JSSymbolPresentationUtils;
import com.intellij.lang.javascript.index.JSSymbolUtil;
import com.intellij.lang.javascript.psi.JSAssignmentExpression;
import com.intellij.lang.javascript.psi.JSConstantValueOwner;
import com.intellij.lang.javascript.psi.JSDefinitionExpression;
import com.intellij.lang.javascript.psi.JSDestructuringParameter;
import com.intellij.lang.javascript.psi.JSElement;
import com.intellij.lang.javascript.psi.JSExpression;
import com.intellij.lang.javascript.psi.JSFunction;
import com.intellij.lang.javascript.psi.JSFunctionExpression;
import com.intellij.lang.javascript.psi.JSFunctionItem;
import com.intellij.lang.javascript.psi.JSInitializerOwner;
import com.intellij.lang.javascript.psi.JSNamepathImpl;
import com.intellij.lang.javascript.psi.JSNamespace;
import com.intellij.lang.javascript.psi.JSParameter;
import com.intellij.lang.javascript.psi.JSParameterItem;
import com.intellij.lang.javascript.psi.JSParameterTypeDecorator;
import com.intellij.lang.javascript.psi.JSPsiElementBase;
import com.intellij.lang.javascript.psi.JSQualifiedNameImpl;
import com.intellij.lang.javascript.psi.JSReferenceExpression;
import com.intellij.lang.javascript.psi.JSType;
import com.intellij.lang.javascript.psi.JSTypeUtils;
import com.intellij.lang.javascript.psi.JSVariable;
import com.intellij.lang.javascript.psi.ecmal4.JSAttributeNameValuePair;
import com.intellij.lang.javascript.psi.ecmal4.JSClass;
import com.intellij.lang.javascript.psi.ecmal4.JSPackageStatement;
import com.intellij.lang.javascript.psi.impl.JSFunctionImpl;
import com.intellij.lang.javascript.psi.impl.JSPsiImplUtils;
import com.intellij.lang.javascript.psi.jsdoc.JSDocComment;
import com.intellij.lang.javascript.psi.resolve.JSEvaluateContext;
import com.intellij.lang.javascript.psi.resolve.JSInheritanceUtil;
import com.intellij.lang.javascript.psi.resolve.JSResolveUtil;
import com.intellij.lang.javascript.psi.resolve.context.JSApplyPropertyElement;
import com.intellij.lang.javascript.psi.stubs.JSImplicitElement;
import com.intellij.lang.javascript.psi.types.JSAnyType;
import com.intellij.lang.javascript.psi.types.JSNamedType;
import com.intellij.lang.javascript.psi.types.JSTypeImpl;
import com.intellij.lang.javascript.psi.types.JSTypeSource;
import com.intellij.lang.javascript.psi.types.JSTypeSourceFactory;
import com.intellij.lang.javascript.psi.util.JSDestructuringUtil;
import com.intellij.lang.javascript.psi.util.JSUtils;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiComment;
import com.intellij.psi.PsiElement;
import com.intellij.ui.ColorUtil;
import com.intellij.util.Function;
import com.intellij.util.Processor;
import com.intellij.util.SmartList;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.xml.util.XmlTagUtilBase;
import java.awt.Color;
import java.util.Collection;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JSDocumentationBuilder
implements JSDocumentationProcessor {
    @NonNls
    private static final String SEE_ALSO_DOC_TOKEN = "<tr><td valign='top' class='section'><p>See also:</td><td>";
    public static final String EVENTS = "Events:";
    private static Map<JSDocumentationProcessor.MetaDocType, String> SIMPLE_TAGS = new EnumMap<JSDocumentationProcessor.MetaDocType, String>(JSDocumentationProcessor.MetaDocType.class);
    private SymbolInfo generationInfo;
    private ParameterInfo currentParameterInfo;
    @NonNls
    private StringBuilder result;
    private JSFunctionItem function;
    private JSPsiElementBase namedItem;
    @NotNull
    private final PsiElement myElement;
    private final PsiElement contextElement;
    private int myNewLinesPendingCount;
    private boolean myInTableRow;
    private boolean seenPre;
    private boolean seenSeeAlso;
    private StringBuilder seeAlsoSection;
    @NonNls
    private static final String BR_DELIMITER = "<BR>\n";
    private boolean seenInheritDoc;
    private boolean myExampleStarted;
    private final JSDocumentationProvider myProvider;
    private boolean myPropertyMatched;
    private Map<String, String> mySections;
    private String defaultValue;
    private static final Pattern ourTagStartPattern;
    private final ParameterInfo NULL_PARAMETER_INFO;

    protected JSDocumentationBuilder(@NotNull PsiElement element, PsiElement _contextElement, JSDocumentationProvider provider2) {
        JSExpression initializer;
        if (element == null) {
            JSDocumentationBuilder.$$$reportNull$$$0(0);
        }
        this.mySections = new HashMap<String, String>();
        this.NULL_PARAMETER_INFO = new ParameterInfo();
        this.myElement = element;
        this.contextElement = _contextElement;
        this.myProvider = provider2;
        PsiElement parent = element.getParent();
        if (element instanceof JSVariable && (initializer = JSPsiImplUtils.getAssignedExpression(element)) instanceof JSFunctionExpression) {
            element = initializer;
        }
        if (element instanceof JSFunctionItem) {
            this.initializeByFunction(element);
        } else if (element instanceof JSPsiElementBase) {
            JSFunctionItem resolvedRelatedFunction = JSUtils.resolveRelatedFunction(element, _contextElement);
            if (resolvedRelatedFunction != null) {
                this.initializeByFunction((PsiElement)resolvedRelatedFunction);
            } else {
                this.namedItem = (JSPsiElementBase)element;
                this.generationInfo = new SymbolInfo();
                if (this.namedItem instanceof JSClass && parent instanceof JSPackageStatement) {
                    this.generationInfo.namespace = ((JSPackageStatement)parent).getQualifiedName();
                }
            }
        } else {
            this.generationInfo = new SymbolInfo();
        }
        this.setResult(this.generationInfo.description);
    }

    private void initializeByFunction(@NotNull PsiElement element) {
        if (element == null) {
            JSDocumentationBuilder.$$$reportNull$$$0(1);
        }
        this.function = (JSFunctionItem)element;
        this.generationInfo = new MethodInfo();
        JSClass containingClass = JSUtils.getMemberContainingClass(element);
        if (containingClass != null) {
            this.generationInfo.namespace = containingClass.getQualifiedName();
        }
        for (JSParameterItem parameter : this.function.getParameters()) {
            ParameterInfo paramInfo = new ParameterInfo();
            ((MethodInfo)this.generationInfo).parameterInfoMap.put(parameter, paramInfo);
            paramInfo.type = parameter.getTypeIncludingOverridden();
            paramInfo.optional = parameter.isOptional();
            JSExpression initializer = parameter instanceof JSInitializerOwner ? ((JSInitializerOwner)parameter).getInitializer() : null;
            paramInfo.initialValue = initializer != null ? initializer.getText() : null;
        }
        ((MethodInfo)this.generationInfo).returnInfo.type = JSFunctionImpl.getReturnTypeInContext(this.function, null);
    }

    private void doAppend(@NonNls String str) {
        while (this.myNewLinesPendingCount > 0) {
            this.result.append(this.seenPre ? "\n" : BR_DELIMITER);
            --this.myNewLinesPendingCount;
        }
        if (this.seenInheritDoc && this.generationInfo instanceof MethodInfo && (this.result == ((MethodInfo)this.generationInfo).description || this.result == ((MethodInfo)this.generationInfo).returnInfo.description)) {
            return;
        }
        str = this.seenPre ? str.replace(BR_DELIMITER, "\n") : str.replaceAll("[^<][^B][^R][^>]\n", BR_DELIMITER);
        this.result.append(str);
    }

    @Override
    public boolean needsPlainCommentData() {
        return true;
    }

    @Override
    public boolean onCommentLine(@NotNull String line) {
        if (line == null) {
            JSDocumentationBuilder.$$$reportNull$$$0(2);
        }
        String trimmedLine = line.trim();
        boolean parametersStarted = false;
        boolean parametersEnded = false;
        if (this.generationInfo instanceof MethodInfo) {
            MethodInfo methodInfo = (MethodInfo)this.generationInfo;
            parametersEnded = methodInfo.parameterCount == methodInfo.parameterInfoMap.size() && (this.currentParameterInfo == null || trimmedLine.length() == 0);
            boolean bl = parametersStarted = methodInfo.parameterCount > 0;
            if (parametersEnded) {
                this.currentParameterInfo = null;
            }
        }
        if (trimmedLine.length() == 0) {
            int maxSubsequentBr;
            if (this.result.length() == 0) {
                return true;
            }
            int n = maxSubsequentBr = parametersStarted && !parametersEnded ? 0 : 2;
            if (this.myNewLinesPendingCount < maxSubsequentBr) {
                ++this.myNewLinesPendingCount;
            }
            if (parametersEnded && ((MethodInfo)this.generationInfo).returnInfo.description != this.result) {
                this.setResult(this.generationInfo.description);
                this.myNewLinesPendingCount = 1;
            }
            return true;
        }
        if (line.contains("<pre>")) {
            this.seenPre = true;
        }
        if (!this.seenPre && line.indexOf(60) != -1) {
            Matcher matcher = ourTagStartPattern.matcher(line);
            int offset = 0;
            while (matcher.find()) {
                boolean isTagEnd = matcher.start(1) != matcher.end(1);
                String s = matcher.group(2);
                if ("tr".equalsIgnoreCase(s)) {
                    boolean bl = this.myInTableRow = !isTagEnd;
                }
                if (JSDocumentationBuilder.tagNameThatDoNotNeedEscaping(s)) continue;
                line = line.substring(0, offset + matcher.start(0)) + "&lt;" + (isTagEnd ? "/" : "") + s + line.substring(offset + matcher.end(0));
                offset += "&lt;".length() - "<".length();
            }
        }
        this.doAppend(line);
        int n = this.myNewLinesPendingCount = parametersStarted && !parametersEnded || this.myInTableRow ? 0 : 1;
        if (line.contains("</pre>")) {
            this.seenPre = false;
        }
        return true;
    }

    private static boolean tagNameThatDoNotNeedEscaping(@NonNls String s) {
        return s.equalsIgnoreCase("p") || s.equalsIgnoreCase("i") || s.equalsIgnoreCase("code") || s.equalsIgnoreCase("ul") || s.equalsIgnoreCase("li") || s.equalsIgnoreCase("b") || s.equalsIgnoreCase("a") || s.equalsIgnoreCase("tt") || s.equalsIgnoreCase("table") || s.equalsIgnoreCase("tr") || s.equalsIgnoreCase("th") || s.equalsIgnoreCase("td");
    }

    private void setResult(StringBuilder builder) {
        this.result = builder;
        this.myNewLinesPendingCount = 0;
    }

    @Override
    public boolean onPatternMatch(@NotNull JSDocumentationProcessor.MetaDocType metaDocType, @Nullable String matchName, @Nullable String matchValue, @Nullable String remainingLineContent, @NotNull String line, @NotNull String patternMatched) {
        Object qualifiedName;
        if (metaDocType == null) {
            JSDocumentationBuilder.$$$reportNull$$$0(3);
        }
        if (line == null) {
            JSDocumentationBuilder.$$$reportNull$$$0(4);
        }
        if (patternMatched == null) {
            JSDocumentationBuilder.$$$reportNull$$$0(5);
        }
        if ((metaDocType != JSDocumentationProcessor.MetaDocType.PARAMETER || patternMatched.indexOf(64) < 0) && metaDocType != JSDocumentationProcessor.MetaDocType.OPTIONAL_PARAMETERS && metaDocType != JSDocumentationProcessor.MetaDocType.FIELD && metaDocType != JSDocumentationProcessor.MetaDocType.DEFAULT) {
            if (this.currentParameterInfo != null) {
                this.setResult(this.generationInfo.description);
            }
            this.currentParameterInfo = null;
        }
        if (metaDocType == JSDocumentationProcessor.MetaDocType.DEFAULT) {
            boolean color = remainingLineContent.startsWith("0x") && remainingLineContent.length() == 8;
            String content = remainingLineContent.substring(color ? 2 : 0);
            ParameterInfo parameterInfo = this.getFieldInfo(matchName);
            if (parameterInfo != null) {
                parameterInfo.initialValue = content;
            } else if (this.currentParameterInfo != null) {
                this.currentParameterInfo.defaultValue = content;
            } else {
                this.defaultValue = JSDocumentationBuilder.buildCurrentOrDefaultValue(content, color, true, remainingLineContent, true);
            }
            return true;
        }
        if (metaDocType == JSDocumentationProcessor.MetaDocType.SEE) {
            String linkPart;
            String displayText;
            if (!this.seenSeeAlso) {
                if (this.seeAlsoSection == null) {
                    this.seeAlsoSection = new StringBuilder();
                }
                this.seenSeeAlso = true;
                this.result = this.seeAlsoSection;
                this.result.append(SEE_ALSO_DOC_TOKEN);
            } else {
                this.result.append(", ");
            }
            remainingLineContent = remainingLineContent.trim();
            if (remainingLineContent.startsWith("\"") && remainingLineContent.endsWith("\"")) {
                this.result.append(StringUtil.stripQuotesAroundValue((String)remainingLineContent));
                return true;
            }
            int i = remainingLineContent.indexOf(32);
            if (i == -1) {
                linkPart = displayText = remainingLineContent;
            } else {
                linkPart = remainingLineContent.substring(0, i);
                displayText = remainingLineContent.substring(i + 1, remainingLineContent.length());
            }
            if (BrowserUtil.isAbsoluteURL((String)linkPart)) {
                this.result.append("<a href=\"").append(linkPart).append("\">").append(displayText).append("</a>");
            } else if (JSDocumentationBuilder.looksLikeWebURL(linkPart)) {
                this.result.append("<a href=\"http://").append(linkPart).append("\">").append(displayText).append("</a>");
            } else {
                String link = this.myProvider.tryGetSeeAlsoLink(linkPart, this.myElement);
                if (link != null) {
                    DocumentationManager.createHyperlink((StringBuilder)this.result, (String)link, (String)displayText, (boolean)true);
                } else {
                    this.result.append(remainingLineContent);
                }
            }
        } else if (this.seenSeeAlso) {
            this.seenSeeAlso = false;
            this.result.append("</td>");
        }
        if (metaDocType == JSDocumentationProcessor.MetaDocType.EVENT) {
            if (this.mySections.get(EVENTS) == null) {
                this.mySections.put(EVENTS, "");
            }
            this.mySections.put(EVENTS, this.mySections.get(EVENTS) + "<p>" + matchName + " &ndash; " + remainingLineContent);
            return true;
        }
        if (metaDocType == JSDocumentationProcessor.MetaDocType.EXAMPLE) {
            this.result.append("<div class='section'>Example:</div><p><code>");
            this.myExampleStarted = true;
        } else if (this.myExampleStarted) {
            this.myExampleStarted = false;
            this.result.append("</code>");
        }
        if (SIMPLE_TAGS.containsKey((Object)metaDocType)) {
            this.mySections.put(SIMPLE_TAGS.get((Object)metaDocType), remainingLineContent);
            return true;
        }
        if (metaDocType == JSDocumentationProcessor.MetaDocType.OPTIONAL_PARAMETERS) {
            ParameterInfo parameterInfo = this.getFieldInfo(matchName);
            if (remainingLineContent != null) {
                this.onCommentLine(remainingLineContent);
            }
            if (parameterInfo != null) {
                parameterInfo.optional = true;
                return true;
            }
            return true;
        }
        if (metaDocType == JSDocumentationProcessor.MetaDocType.DEPRECATED) {
            this.generationInfo.deprecated = true;
            if (remainingLineContent != null) {
                this.onCommentLine(remainingLineContent);
            }
            return true;
        }
        if (metaDocType == JSDocumentationProcessor.MetaDocType.DESCRIPTION) {
            if (this.generationInfo.description.length() > 0) {
                this.generationInfo.description.append("<p>");
            }
            this.generationInfo.description.append(remainingLineContent);
            return true;
        }
        JSTypeSource typeSource = JSTypeSourceFactory.createTypeSource(this.myElement, true);
        if (metaDocType == JSDocumentationProcessor.MetaDocType.PRIVATE || metaDocType == JSDocumentationProcessor.MetaDocType.PUBLIC || metaDocType == JSDocumentationProcessor.MetaDocType.PROTECTED || metaDocType == JSDocumentationProcessor.MetaDocType.STATIC) {
            String s = metaDocType.name().toLowerCase();
            this.generationInfo.visibility = this.generationInfo.visibility == null ? s : this.generationInfo.visibility + ", " + s;
            if (matchName != null) {
                this.generationInfo.type = JSTypeUtils.createTypeFromJSDoc(matchName, typeSource);
            }
            return true;
        }
        if (metaDocType == JSDocumentationProcessor.MetaDocType.TYPE) {
            this.generationInfo.type = JSTypeUtils.createTypeFromJSDoc(matchName, typeSource);
            return true;
        }
        if (metaDocType == JSDocumentationProcessor.MetaDocType.FINAL) {
            this.generationInfo.access = "final";
            return true;
        }
        if (metaDocType == JSDocumentationProcessor.MetaDocType.REQUIRES) {
            return true;
        }
        if (metaDocType == JSDocumentationProcessor.MetaDocType.NAMESPACE) {
            this.generationInfo.namespace = matchName;
            return true;
        }
        if (metaDocType == JSDocumentationProcessor.MetaDocType.INHERIT_DOC) {
            this.seenInheritDoc = true;
            return true;
        }
        if (metaDocType == JSDocumentationProcessor.MetaDocType.FIELD && this.namedItem != null) {
            qualifiedName = this.namedItem.getQualifiedName();
            if (qualifiedName != null && ((String)qualifiedName).endsWith("options." + matchName) && !StringUtil.isEmpty((String)remainingLineContent)) {
                if (this.generationInfo.description.length() > 0) {
                    this.generationInfo.description.append("<p>");
                }
                this.generationInfo.description.append(remainingLineContent);
            }
        } else if (metaDocType == JSDocumentationProcessor.MetaDocType.PROPERTY) {
            if (matchName != null) {
                qualifiedName = JSQualifiedNameImpl.fromQualifiedName(matchName);
                if (this.namedItem instanceof JSImplicitElement && StringUtil.equals((CharSequence)this.namedItem.getName(), (CharSequence)((JSQualifiedNameImpl)qualifiedName).getName())) {
                    this.generationInfo.description.delete(0, this.generationInfo.description.length());
                    this.generationInfo.description.append(remainingLineContent);
                    this.generationInfo.type = JSTypeUtils.createTypeFromJSDoc(matchValue, typeSource);
                    this.myPropertyMatched = true;
                    this.generationInfo.myProperties = null;
                } else if (!this.myPropertyMatched && this.namedItem != null && !StringUtil.equals((CharSequence)this.namedItem.getName(), (CharSequence)((JSQualifiedNameImpl)qualifiedName).getName())) {
                    if (this.generationInfo.myProperties == null) {
                        this.generationInfo.myProperties = new LinkedHashMap<String, ParameterInfo>();
                    }
                    ParameterInfo property = new ParameterInfo();
                    if (matchValue != null) {
                        property.type = JSTypeUtils.createTypeFromJSDoc(matchValue, JSTypeSource.EXPLICITLY_DECLARED);
                    }
                    if (((JSQualifiedNameImpl)qualifiedName).getParent() != null) {
                        property.namespace = ((JSQualifiedNameImpl)qualifiedName).getParent().getQualifiedName();
                    }
                    property.description.append(remainingLineContent);
                    this.generationInfo.myProperties.put(((JSQualifiedNameImpl)qualifiedName).getName(), property);
                }
            }
        } else if (metaDocType == JSDocumentationProcessor.MetaDocType.TYPEDEF) {
            this.generationInfo.type = JSTypeUtils.createTypeFromJSDoc(matchValue, typeSource);
        }
        if (this.function != null) {
            SymbolInfo info;
            MethodInfo methodGenerationInfo = (MethodInfo)this.generationInfo;
            if (metaDocType == JSDocumentationProcessor.MetaDocType.THROWS || metaDocType == JSDocumentationProcessor.MetaDocType.FIRES) {
                info = new SymbolInfo();
                (metaDocType == JSDocumentationProcessor.MetaDocType.THROWS ? methodGenerationInfo.throwsInfos : methodGenerationInfo.firesInfos).add(info);
                this.result = info.description;
                if (matchName != null) {
                    if (metaDocType == JSDocumentationProcessor.MetaDocType.FIRES) {
                        info.addEventPrefix = true;
                    }
                    info.type = JSTypeUtils.createTypeFromJSDoc(matchName, typeSource);
                }
                if (remainingLineContent != null) {
                    this.result.append(remainingLineContent);
                }
            } else if (metaDocType == JSDocumentationProcessor.MetaDocType.CONSTRUCTOR) {
                methodGenerationInfo.methodType = "constructor";
            } else if (metaDocType == JSDocumentationProcessor.MetaDocType.METHOD) {
                methodGenerationInfo.methodType = "method";
            } else if (metaDocType == JSDocumentationProcessor.MetaDocType.FIELD) {
                String parameterName;
                ParameterInfo info2;
                if (matchName != null && matchName.indexOf(46) > 0 && (info2 = methodGenerationInfo.getInfoForParameterName(parameterName = matchName.substring(0, matchName.indexOf(".")), this.function)) != null) {
                    this.currentParameterInfo = info2;
                }
                if (this.currentParameterInfo != null) {
                    String fieldName;
                    if (this.currentParameterInfo.optionsMap == null) {
                        this.currentParameterInfo.optionsMap = new LinkedHashMap<String, ParameterInfo>();
                    }
                    if ((fieldName = JSDocumentationBuilder.getFieldName(matchName)) != null) {
                        ParameterInfo parameterInfo = new ParameterInfo();
                        parameterInfo.description.append(remainingLineContent);
                        JSParameterTypeDecorator parameterType = JSTypeUtils.createParameterType(matchValue, typeSource);
                        parameterInfo.type = parameterType != null ? parameterType.getType() : null;
                        parameterInfo.optional = parameterType != null && parameterType.isOptional();
                        this.setResult(parameterInfo.description);
                        this.currentParameterInfo.optionsMap.put(fieldName, parameterInfo);
                    }
                }
            } else if (metaDocType == JSDocumentationProcessor.MetaDocType.PARAMETER) {
                info = methodGenerationInfo.getInfoForParameterName(matchName, this.function);
                if (info != null) {
                    SymbolInfo symbolInfo;
                    int index = 0;
                    Iterator<ParameterInfo> parameterType = methodGenerationInfo.parameterInfoMap.values().iterator();
                    while (parameterType.hasNext() && info != (symbolInfo = (SymbolInfo)parameterType.next())) {
                        ++index;
                    }
                    methodGenerationInfo.parameterCount = index + 1;
                } else if (patternMatched.indexOf(64) != -1) {
                    ++methodGenerationInfo.parameterCount;
                    int index = 0;
                    for (SymbolInfo symbolInfo : methodGenerationInfo.parameterInfoMap.values()) {
                        if (index + 1 == methodGenerationInfo.parameterCount) {
                            info = (ParameterInfo)symbolInfo;
                            break;
                        }
                        ++index;
                    }
                }
                if (info != null) {
                    ((ParameterInfo)info).name = matchName;
                    this.setResult(((ParameterInfo)info).description);
                    ((ParameterInfo)info).description.append(remainingLineContent);
                    this.currentParameterInfo = info;
                } else {
                    this.onCommentLine(line);
                }
            } else if (metaDocType == JSDocumentationProcessor.MetaDocType.RETURN) {
                JSType typeFromCommentsFunction;
                DialectOptionHolder holder;
                this.result = methodGenerationInfo.returnInfo.description;
                boolean addReturnTypeInfoFromComments = true;
                if (this.function instanceof JSFunction && (holder = DialectDetector.dialectOfElement((PsiElement)this.function)) != null && (holder.isTypeScript || holder.isECMA4) && (typeFromCommentsFunction = JSPsiImplUtils.getTypeFromDeclaration((JSElement)this.function)) != null && !typeFromCommentsFunction.getTypeText().equals(matchName)) {
                    addReturnTypeInfoFromComments = false;
                }
                if (matchName != null) {
                    if (addReturnTypeInfoFromComments) {
                        methodGenerationInfo.returnInfo.type = JSTypeUtils.createTypeFromJSDoc(matchName, typeSource);
                    } else {
                        methodGenerationInfo.returnInfo.description.append(matchName).append(" ");
                    }
                }
                if (matchValue != null) {
                    methodGenerationInfo.returnInfo.description.append(matchValue);
                }
                if (remainingLineContent != null) {
                    methodGenerationInfo.returnInfo.description.append(remainingLineContent);
                }
            }
        } else if (!(metaDocType != JSDocumentationProcessor.MetaDocType.PARAMETER || this.myElement instanceof JSImplicitElement && ((JSImplicitElement)this.myElement).getType() == JSImplicitElement.Type.Property)) {
            this.onCommentLine(line);
        }
        return true;
    }

    private static boolean looksLikeWebURL(String linkPart) {
        return linkPart.startsWith("www.") && linkPart.matches("[a-z0-9\\./]+");
    }

    @Override
    public void postProcess() {
        if (this.seenInheritDoc && this.generationInfo instanceof MethodInfo) {
            final MethodInfo methodInfo = (MethodInfo)this.generationInfo;
            new Processor<JSFunction>(){

                public boolean process(JSFunction function) {
                    PsiComment e;
                    if (function != JSDocumentationBuilder.this.myElement && (e = JSDocumentationUtils.findDocComment(function.getNavigationElement())) != null) {
                        JSDocumentationBuilder builder = new JSDocumentationBuilder((PsiElement)function, (PsiElement)function, JSDocumentationBuilder.this.myProvider);
                        JSDocumentationUtils.processDocumentationTextFromComment(e.getNode(), builder);
                        MethodInfo superMethodInfo = (MethodInfo)builder.generationInfo;
                        if (superMethodInfo.description.length() > 0) {
                            if (methodInfo.description.length() > 0) {
                                boolean addTwoBreaks = methodInfo.description.lastIndexOf(JSDocumentationBuilder.this.seenPre ? "\n" : JSDocumentationBuilder.BR_DELIMITER) != methodInfo.description.length() - JSDocumentationBuilder.BR_DELIMITER.length();
                                methodInfo.description.append(JSDocumentationBuilder.this.seenPre ? "\n" : JSDocumentationBuilder.BR_DELIMITER);
                                if (addTwoBreaks) {
                                    methodInfo.description.append(JSDocumentationBuilder.this.seenPre ? "\n" : JSDocumentationBuilder.BR_DELIMITER);
                                }
                            }
                            methodInfo.description.append((CharSequence)superMethodInfo.description);
                        }
                        int index = 0;
                        ParameterInfo[] parameterInfosArray = superMethodInfo.parameterInfoMap.values().toArray(new ParameterInfo[superMethodInfo.parameterInfoMap.size()]);
                        for (Map.Entry<JSParameterItem, ParameterInfo> entry : methodInfo.parameterInfoMap.entrySet()) {
                            if (entry.getValue().description.length() == 0) {
                                ParameterInfo info = superMethodInfo.parameterInfoMap.get(entry.getKey());
                                if (info != null) {
                                    entry.getValue().description.append((CharSequence)info.description);
                                } else if (index < parameterInfosArray.length) {
                                    entry.getValue().description.append((CharSequence)parameterInfosArray[index].description);
                                }
                            }
                            ++index;
                        }
                        if (methodInfo.returnInfo.description.length() == 0) {
                            methodInfo.returnInfo.description.append((CharSequence)superMethodInfo.returnInfo.description);
                        }
                        return false;
                    }
                    for (JSFunction f : JSInheritanceUtil.findImplementedMethods(function)) {
                        if (this.process(f)) continue;
                        return false;
                    }
                    for (JSPsiElementBase m : JSInheritanceUtil.findNearestOverriddenMembers((JSPsiElementBase)function, true)) {
                        JSFunctionItem f = JSPsiImplUtils.calculatePossibleFunction((PsiElement)m);
                        if (!(f instanceof JSFunction) || this.process((JSFunction)f)) continue;
                        return false;
                    }
                    return true;
                }
            }.process((JSFunction)this.myElement);
        } else if (this.seenInheritDoc && this.myElement instanceof JSPsiElementBase) {
            Collection<Object> members = this.myElement instanceof JSClass ? ContainerUtil.newArrayList((Object[])((JSClass)this.myElement).getSuperClasses()) : JSInheritanceUtil.findNearestOverriddenMembers((JSPsiElementBase)this.myElement, false);
            for (JSPsiElementBase jSPsiElementBase : members) {
                PsiComment e = JSDocumentationUtils.findDocComment((PsiElement)jSPsiElementBase);
                if (e == null) continue;
                JSDocumentationBuilder builder = new JSDocumentationBuilder((PsiElement)jSPsiElementBase, (PsiElement)jSPsiElementBase, this.myProvider);
                JSDocumentationUtils.processDocumentationTextFromComment(e.getNode(), builder);
                SymbolInfo superMemberInfo = builder.generationInfo;
                if (superMemberInfo.description.length() <= 0) continue;
                if (this.generationInfo.description.length() > 0) {
                    boolean addTwoBreaks = this.generationInfo.description.lastIndexOf(this.seenPre ? "\n" : BR_DELIMITER) != this.generationInfo.description.length() - BR_DELIMITER.length();
                    this.generationInfo.description.append(this.seenPre ? "\n" : BR_DELIMITER);
                    if (addTwoBreaks) {
                        this.generationInfo.description.append(this.seenPre ? "\n" : BR_DELIMITER);
                    }
                }
                this.generationInfo.description.append((CharSequence)superMemberInfo.description);
            }
        }
    }

    @Nullable
    private ParameterInfo getFieldInfo(String name) {
        Map<String, ParameterInfo> map;
        String fieldName = JSDocumentationBuilder.getFieldName(name);
        if (fieldName == null) {
            return null;
        }
        Map<String, ParameterInfo> map2 = map = this.currentParameterInfo != null ? this.currentParameterInfo.optionsMap : null;
        if (map == null) {
            return this.NULL_PARAMETER_INFO;
        }
        ParameterInfo parameterInfo = map.get(fieldName);
        return parameterInfo != null ? parameterInfo : this.NULL_PARAMETER_INFO;
    }

    private static String getFieldName(String name) {
        if (name == null) {
            return null;
        }
        int dotIndex = name.indexOf(46);
        if (dotIndex == -1) {
            return null;
        }
        return name.substring(dotIndex + 1);
    }

    private static String buildCurrentOrDefaultValue(String remainingLineContent, boolean color, boolean defaultValue, String originalText, boolean needSection) {
        remainingLineContent = color ? "<code style='background-color:#" + remainingLineContent + "; color: #" + JSDocumentationBuilder.contrastColor(remainingLineContent) + "'>" + originalText + "</code>" : "<code>" + remainingLineContent + "</code>";
        String label = (defaultValue ? "Default" : "Value") + ":";
        if (!needSection) {
            return "<p>" + label + remainingLineContent;
        }
        return "<tr><td valign='top' class='section'><p>" + label + "</td><td>" + "<p>" + remainingLineContent;
    }

    private static String contrastColor(String remainingLineContent) {
        try {
            Color color = ColorUtil.fromHex((String)remainingLineContent);
            return ColorUtil.toHex((Color)(ColorUtil.isDark((Color)color) ? Color.WHITE : Color.BLACK));
        }
        catch (IllegalArgumentException illegalArgumentException) {
            return remainingLineContent;
        }
    }

    @Nullable
    String getDoc() {
        if (this.seenSeeAlso) {
            this.seenSeeAlso = false;
            this.seeAlsoSection.append("</td>");
        }
        this.result = new StringBuilder();
        if (this.function != null) {
            this.startFunction(this.function);
            this.addContent();
            MethodInfo methodInfo = (MethodInfo)this.generationInfo;
            this.result.append("<table class='sections'>");
            this.addSections();
            int paramsSectionStart = this.result.length();
            boolean hasParamDoc = false;
            if (methodInfo.parameterInfoMap.size() > 0) {
                this.startNamedSection(CodeInsightBundle.message((String)"javadoc.parameters", (Object[])new Object[0]));
                this.result.append("<td>");
            }
            for (Map.Entry<JSParameterItem, ParameterInfo> parameterInfoEntry : methodInfo.parameterInfoMap.entrySet()) {
                ParameterInfo parameterInfo = parameterInfoEntry.getValue();
                JSDocumentationBuilder.appendConfigOptionsInfoIfNeeded(parameterInfo);
                String description = parameterInfo.description.toString();
                if (parameterInfo.defaultValue != null) {
                    description = description + JSDocumentationBuilder.buildCurrentOrDefaultValue(parameterInfo.defaultValue, false, true, null, false);
                }
                if (description.length() <= 0) continue;
                hasParamDoc = true;
                this.result.append("<p>");
                this.appendSingleNamedDescriptionSection(parameterInfoEntry.getKey().getName(), description);
            }
            if (!hasParamDoc) {
                this.result.setLength(paramsSectionStart);
            }
            if (methodInfo.returnInfo.description.length() > 0) {
                this.startNamedSection(CodeInsightBundle.message((String)"javadoc.returns", (Object[])new Object[0]));
                this.result.append("<td>");
                JSDocumentationBuilder.addDescription(methodInfo.returnInfo.description.toString(), this.result);
                this.result.append("</td>");
            }
            this.appendNamedSectionAndElements(methodInfo.throwsInfos, CodeInsightBundle.message((String)"javadoc.throws", (Object[])new Object[0]));
            this.appendNamedSectionAndElements(methodInfo.firesInfos, JSBundle.message((String)"js.documentation.fires", (Object[])new Object[0]));
        } else {
            String text;
            String value;
            if (this.namedItem != null || this.myElement instanceof JSAttributeNameValuePair) {
                this.result.append("<div class='definition'><pre>");
                this.result.append(this.namedItem != null ? this.namedItem.getName() : ((JSAttributeNameValuePair)this.myElement).getSimpleValue());
                if (this.generationInfo.type != null) {
                    this.result.append(": ");
                    this.result.append(this.generationInfo.getTypeString());
                }
                this.result.append("</pre></div>");
            }
            this.addContent();
            this.result.append("<table class='sections'>");
            this.addSections();
            if (this.defaultValue != null) {
                this.result.append(this.defaultValue);
            }
            if (this.generationInfo.myProperties != null) {
                this.startNamedSection("Properties:");
                this.result.append("<td>");
                for (Map.Entry<String, ParameterInfo> field : this.generationInfo.myProperties.entrySet()) {
                    this.result.append("<p>");
                    JSDocumentationBuilder.appendOptionDescription(field, this.result);
                }
                this.result.append("</td>");
            }
            if (this.myElement instanceof JSConstantValueOwner && (value = ((JSConstantValueOwner)this.myElement).getConstantValueDescription()) != null) {
                this.startNamedSection("Constant value:");
                this.appendSingleNamedDescriptionSection(value, "");
            }
            if (this.contextElement != null && !(this.contextElement instanceof JSImplicitElement) && (text = this.contextElement.getText()).startsWith("#") && text.length() == 7) {
                this.result.append(JSDocumentationBuilder.buildCurrentOrDefaultValue(text.substring(1), true, false, text, true));
            }
        }
        if (this.seeAlsoSection != null) {
            this.result.append((CharSequence)this.seeAlsoSection);
        }
        this.result.append("</table>");
        return this.result.length() > 0 ? this.result.toString() : null;
    }

    private void addSections() {
        for (Map.Entry<String, String> entry : this.mySections.entrySet()) {
            this.startNamedSection(entry.getKey());
            this.result.append("<td>");
            String value = entry.getValue();
            if (!value.startsWith("<p>")) {
                this.result.append("<p>");
            }
            this.result.append(value);
            this.result.append("</td>");
        }
    }

    private void addContent() {
        if (this.generationInfo.description.length() > 0) {
            String description = this.generationInfo.description.toString();
            this.result.append("<div class='content'>");
            JSDocumentationBuilder.addDescription(description, this.result);
            this.result.append("</div>");
        }
    }

    private static void addDescription(String description, StringBuilder builder) {
        builder.append("<p>");
        builder.append(description.replace("<br>", "<p>").replace("<BR>", "<p>"));
    }

    private void appendNamedSectionAndElements(@NotNull Collection<SymbolInfo> infos, @NotNull String sectionName) {
        if (infos == null) {
            JSDocumentationBuilder.$$$reportNull$$$0(6);
        }
        if (sectionName == null) {
            JSDocumentationBuilder.$$$reportNull$$$0(7);
        }
        if (!infos.isEmpty()) {
            this.startNamedSection(sectionName);
            this.result.append("<td>");
            for (SymbolInfo mi : infos) {
                this.result.append("<p>");
                if (mi.hasType()) {
                    this.appendSingleNamedDescriptionSection(mi.getTypeString(), mi.description.toString());
                    continue;
                }
                this.result.append(mi.description.toString());
            }
            this.result.append("</td>");
        }
    }

    private static void appendConfigOptionsInfoIfNeeded(ParameterInfo parameterInfo) {
        if (parameterInfo.optionsMap != null) {
            StringBuilder builder = new StringBuilder();
            builder.append("<table class='sections'>");
            builder.append("<tr><td valign='top' class='section'><p>");
            builder.append("Config options").append(":");
            builder.append("</td><td>");
            for (Map.Entry<String, ParameterInfo> field : parameterInfo.optionsMap.entrySet()) {
                builder.append("<p>");
                JSDocumentationBuilder.appendOptionDescription(field, builder);
            }
            builder.append("</table>");
            JSDocumentationBuilder.insertParameterInfoDescription(parameterInfo.description, builder);
        }
    }

    private static void insertParameterInfoDescription(StringBuilder description, StringBuilder builder) {
        int i = description.indexOf(SEE_ALSO_DOC_TOKEN);
        if (i != -1) {
            description.insert(i, builder);
        } else {
            description.append((CharSequence)builder);
        }
    }

    private void startNamedSection(String sectionName) {
        JSDocumentationBuilder.startNamedSection(sectionName, this.result);
    }

    private static void startNamedSection(String sectionName, StringBuilder result2) {
        result2.append("<tr><td valign='top' class='section'><p>");
        result2.append(sectionName);
        result2.append("</td>");
    }

    private void appendSingleNamedDescriptionSection(String name, String description) {
        this.result.append(name);
        if (description.length() > 0) {
            this.result.append(" &ndash; ");
            this.result.append(description);
        }
    }

    public String getParameterDoc(JSParameter parameter, PsiElement docComment) {
        if (this.function != null) {
            String name = parameter.getName();
            MethodInfo methodInfo = (MethodInfo)this.generationInfo;
            ParameterInfo parameterInfo = methodInfo.parameterInfoMap.get(parameter);
            if (parameterInfo != null && parameterInfo.hasSomeInfo()) {
                return this.buildParameterInfo(name, parameterInfo);
            }
            if (parameterInfo == null && docComment instanceof JSDocComment && this.function instanceof JSFunction && JSDestructuringUtil.isDestructuring(parameter.getParent())) {
                JSEvaluateContext context = new JSEvaluateContext(null);
                JSDestructuringParameter destructuringParameter = (JSDestructuringParameter)JSDestructuringUtil.findDestructuringParent((JSElement)parameter.getParent(), context, (Condition<JSInitializerOwner>)((Condition)JSDestructuringParameter.class::isInstance));
                if (destructuringParameter != null) {
                    String fieldName = context.getJSElementsToApply().stream().reduce("", (s, element) -> {
                        if (s == null) {
                            return null;
                        }
                        if (element instanceof JSApplyPropertyElement) {
                            return (s.isEmpty() ? "" : s + ".") + ((JSApplyPropertyElement)element).getName();
                        }
                        return null;
                    }, String::concat);
                    ParameterInfo containerInfo = methodInfo.parameterInfoMap.get(destructuringParameter);
                    if (containerInfo != null && containerInfo.hasSomeInfo() && fieldName != null) {
                        ParameterInfo fieldInfo = containerInfo.optionsMap != null ? containerInfo.optionsMap.get(fieldName) : null;
                        return this.buildParameterInfo(name, fieldInfo != null ? fieldInfo : containerInfo);
                    }
                }
            }
        }
        return null;
    }

    @NotNull
    private String buildParameterInfo(String name, ParameterInfo parameterInfo) {
        this.result = new StringBuilder();
        this.result.append("<div class='definition'><pre>");
        StringBuilder options = new StringBuilder();
        JSDocumentationBuilder.addVisibilityAndAccess(options, parameterInfo);
        if (options.length() > 0) {
            this.result.append((CharSequence)options).append("<br>");
        }
        if (!StringUtil.isEmpty((String)this.generationInfo.namespace)) {
            this.result.append(this.generationInfo.namespace).append('.');
        }
        this.result.append(name);
        if (parameterInfo.hasType()) {
            this.result.append(": ");
            this.result.append(parameterInfo.getTypeString());
        }
        this.result.append("</pre></div>");
        int contentStart = this.result.length();
        this.result.append("<div class='content'>");
        this.result.append(parameterInfo.description.toString());
        JSDocumentationBuilder.appendConfigOptionsInfoIfNeeded(parameterInfo);
        if (this.result.length() == contentStart + "<div class='content'>".length()) {
            this.result.setLength(contentStart);
        } else {
            this.result.append("</div>");
        }
        String string = this.result.toString();
        if (string == null) {
            JSDocumentationBuilder.$$$reportNull$$$0(8);
        }
        return string;
    }

    private static void appendOptionDescription(Map.Entry<String, ParameterInfo> e, StringBuilder builder) {
        JSDocumentationBuilder.appendParameterInfoInSignature(e.getKey(), e.getValue(), builder);
        builder.append(" &ndash; ");
        builder.append(e.getValue().description.toString());
    }

    private void startFunction(JSFunctionItem function) {
        String functionName = JSPsiImplUtils.findFunctionName(function);
        PsiElement parent = function.getParent();
        if (parent instanceof JSAssignmentExpression) {
            JSExpression qualifierExpression;
            String unqualifiedFunctionName = functionName;
            JSExpression expression = ((JSDefinitionExpression)((JSAssignmentExpression)parent).getLOperand()).getExpression();
            functionName = null;
            if (expression instanceof JSReferenceExpression && (qualifierExpression = ((JSReferenceExpression)expression).getQualifier()) instanceof JSReferenceExpression) {
                JSNamespace ns = JSSymbolUtil.evaluateNamespaceLocally((JSReferenceExpression)qualifierExpression);
                functionName = (ns != null && ns.getQualifiedName() != null ? ns.getQualifiedName().getQualifiedName() : qualifierExpression.getText()) + "." + unqualifiedFunctionName;
            }
            if (functionName == null) {
                functionName = expression.getText();
            }
            if (this.generationInfo.namespace != null && functionName.equals(this.generationInfo.namespace + "." + unqualifiedFunctionName)) {
                this.generationInfo.namespace = null;
            }
        }
        if (functionName == null) {
            functionName = "<anonymous>";
        }
        this.result.append("<div class='definition'><pre>");
        int functionStart = this.result.length();
        StringBuilder options = new StringBuilder();
        JSDocumentationBuilder.addVisibilityAndAccess(options, this.generationInfo);
        if (options.length() > 0) {
            this.result.append((CharSequence)options).append("<br>");
        }
        int lastLineStart = this.result.length();
        if (!StringUtil.isEmpty((String)this.generationInfo.namespace)) {
            this.result.append(this.generationInfo.namespace).append('.');
        }
        this.result.append(functionName);
        this.result.append("(");
        int resultLength = this.result.length();
        int paramsStart = resultLength - functionStart;
        Map<JSParameterItem, ParameterInfo> params = ((MethodInfo)this.generationInfo).parameterInfoMap;
        int alignment = paramsStart >= 10 ? 4 : paramsStart;
        for (Map.Entry<JSParameterItem, ParameterInfo> parameterInfo : params.entrySet()) {
            boolean firstArg;
            boolean bl = firstArg = this.result.length() == resultLength;
            if (!firstArg) {
                lastLineStart = this.result.length();
                this.result.append(",<br>");
                StringUtil.repeatSymbol((Appendable)this.result, (char)' ', (int)alignment);
            } else if (paramsStart >= 10) {
                lastLineStart = this.result.length();
                this.result.append("<br>");
                StringUtil.repeatSymbol((Appendable)this.result, (char)' ', (int)alignment);
            }
            JSDocumentationBuilder.appendParameterInfoInSignature(parameterInfo.getKey().getName(), parameterInfo.getValue(), this.result);
        }
        this.result.append(")");
        if (((MethodInfo)this.generationInfo).returnInfo.hasType()) {
            this.result.append(": ");
            if (this.result.length() - lastLineStart > 80) {
                this.result.append("<br>");
                StringUtil.repeatSymbol((Appendable)this.result, (char)' ', (int)2);
            }
            this.result.append(((MethodInfo)this.generationInfo).returnInfo.getTypeString());
        }
        this.result.append("</pre></div>");
    }

    private static void appendParameterInfoInSignature(String name, ParameterInfo parameterInfo, StringBuilder result2) {
        String initialValue;
        boolean optional = parameterInfo.optional;
        if (!StringUtil.isEmpty((String)parameterInfo.namespace)) {
            result2.append(parameterInfo.namespace).append('.');
        }
        result2.append(name);
        if (optional) {
            result2.append("?");
        }
        if (parameterInfo.hasType()) {
            result2.append(": ");
            result2.append(parameterInfo.getTypeString());
        }
        if ((initialValue = parameterInfo.initialValue) != null) {
            result2.append(" = ").append(initialValue);
        }
    }

    private static void addVisibilityAndAccess(StringBuilder options, SymbolInfo generationInfo) {
        if (generationInfo.visibility != null) {
            if (options.length() > 0) {
                options.append(", ");
            }
            options.append(generationInfo.visibility);
        }
        if (generationInfo.access != null) {
            if (options.length() > 0) {
                options.append(", ");
            }
            options.append(generationInfo.access);
        }
        if (generationInfo.deprecated) {
            if (options.length() > 0) {
                options.append(", ");
            }
            options.append("deprecated");
        }
    }

    public boolean addEvaluatedType() {
        if (this.myElement instanceof JSClass) {
            return false;
        }
        if (this.generationInfo.type == null) {
            JSType declaredType = JSTypeUtils.getTypeOfElement(this.myElement);
            if (declaredType != null) {
                this.generationInfo.type = declaredType;
            } else {
                JSType type;
                JSExpression expressionForTypeEvaluation = JSPsiImplUtils.getAssignedExpression(this.myElement);
                if (expressionForTypeEvaluation != null && !(expressionForTypeEvaluation instanceof JSFunctionExpression) && (type = JSResolveUtil.getExpressionJSType(expressionForTypeEvaluation)) != null && !(type instanceof JSAnyType)) {
                    if (type.getSource().isStrict()) {
                        type = JSTypeUtils.copyWithStrictRecursive(type, false);
                    }
                    this.generationInfo.type = type;
                }
                if (expressionForTypeEvaluation == null) {
                    this.generationInfo.type = JSShowTypeInfoAction.getTypeForDocumentation(this.myElement);
                }
            }
        }
        return this.generationInfo.type != null;
    }

    static {
        SIMPLE_TAGS.put(JSDocumentationProcessor.MetaDocType.NOTE, "Note:");
        SIMPLE_TAGS.put(JSDocumentationProcessor.MetaDocType.AUTHOR, "Author:");
        SIMPLE_TAGS.put(JSDocumentationProcessor.MetaDocType.FILE_OVERVIEW, "File overview:");
        SIMPLE_TAGS.put(JSDocumentationProcessor.MetaDocType.SINCE, "Since:");
        SIMPLE_TAGS.put(JSDocumentationProcessor.MetaDocType.VERSION, "Version:");
        SIMPLE_TAGS.put(JSDocumentationProcessor.MetaDocType.TODO, "To do:");
        ourTagStartPattern = Pattern.compile("<(/)?(\\w+)");
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 8: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 8: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 2: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "line";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "metaDocType";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "patternMatched";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "infos";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sectionName";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/javascript/documentation/JSDocumentationBuilder";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/javascript/documentation/JSDocumentationBuilder";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "buildParameterInfo";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "initializeByFunction";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "onCommentLine";
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "onPatternMatch";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "appendNamedSectionAndElements";
                break;
            }
            case 8: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 8: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class ParameterInfo
    extends SymbolInfo {
        boolean optional;
        String initialValue;
        String defaultValue;
        String name;
        Map<String, ParameterInfo> optionsMap;

        private ParameterInfo() {
        }

        boolean hasSomeInfo() {
            return this.description.length() > 0 || this.optional || this.hasType();
        }
    }

    private static class MethodInfo
    extends SymbolInfo {
        String methodType;
        Map<JSParameterItem, ParameterInfo> parameterInfoMap = new LinkedHashMap<JSParameterItem, ParameterInfo>();
        int parameterCount = 0;
        SymbolInfo returnInfo = new SymbolInfo();
        Set<SymbolInfo> throwsInfos = new LinkedHashSet<SymbolInfo>();
        List<SymbolInfo> firesInfos = new SmartList();

        private MethodInfo() {
        }

        ParameterInfo getInfoForParameterName(String name, JSFunctionItem function) {
            JSParameterItem parameter = null;
            for (JSParameterItem item : function.getParameterVariables()) {
                if (!StringUtil.equals((CharSequence)name, (CharSequence)item.getName())) continue;
                parameter = item;
            }
            ParameterInfo parameterInfo = this.parameterInfoMap.get(parameter);
            if (parameterInfo != null) {
                return parameterInfo;
            }
            for (ParameterInfo info : this.parameterInfoMap.values()) {
                if (!StringUtil.equals((CharSequence)name, (CharSequence)info.name)) continue;
                return info;
            }
            return null;
        }
    }

    private static class SymbolInfo {
        String visibility;
        StringBuilder description = new StringBuilder();
        @Nullable
        JSType type;
        String access;
        boolean deprecated;
        String namespace;
        @Nullable
        Map<String, ParameterInfo> myProperties;
        boolean addEventPrefix;

        private SymbolInfo() {
        }

        @NotNull
        String getTypeString() {
            JSType type = this.type;
            if (type != null) {
                type = JSTypeUtils.applyCompositeMapping(type, new Function<JSType, JSType>(){

                    public JSType fun(JSType type) {
                        if (type instanceof JSTypeImpl) {
                            StringBuilder builder = new StringBuilder("^^");
                            JSNamepathImpl name = JSNamepathImpl.fromNamepath(type.getTypeText());
                            this.appendNamepath(name, builder, true);
                            builder.append("^^");
                            return JSNamedType.createType(builder.toString(), type.getSource(), ((JSTypeImpl)type).isStaticOrInstance());
                        }
                        return type;
                    }

                    private void appendNamepath(@NotNull JSNamepathImpl name, @NotNull StringBuilder builder, boolean outer) {
                        JSNamepathImpl parent;
                        if (name == null) {
                            1.$$$reportNull$$$0(0);
                        }
                        if (builder == null) {
                            1.$$$reportNull$$$0(1);
                        }
                        if ((parent = name.getParent()) != null) {
                            this.appendNamepath(parent, builder, false);
                            builder.append(parent.getForcedContextChar());
                        }
                        String presentableName = name.getName();
                        if (outer && addEventPrefix) {
                            name = name.withName("event:" + presentableName);
                        }
                        DocumentationManager.createHyperlink((StringBuilder)builder, (String)name.getQualifiedName(), (String)presentableName, (boolean)true);
                    }

                    private static /* synthetic */ void $$$reportNull$$$0(int n) {
                        Object[] objectArray;
                        Object[] objectArray2 = new Object[3];
                        switch (n) {
                            default: {
                                objectArray = objectArray2;
                                objectArray2[0] = "name";
                                break;
                            }
                            case 1: {
                                objectArray = objectArray2;
                                objectArray2[0] = "builder";
                                break;
                            }
                        }
                        objectArray[1] = "com/intellij/lang/javascript/documentation/JSDocumentationBuilder$SymbolInfo$1";
                        objectArray[2] = "appendNamepath";
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
                    }
                });
            }
            String unescapedTypeWithLinks = type != null ? type.getTypeText(JSType.TypeTextFormat.PRESENTABLE) : "any";
            StringBuilder escapedBuilder = new StringBuilder();
            boolean needEscaping = !unescapedTypeWithLinks.startsWith("^^");
            for (String typePart : StringUtil.split((String)unescapedTypeWithLinks, (String)"^^")) {
                if (needEscaping) {
                    typePart = XmlTagUtilBase.escapeString((String)typePart, (boolean)false);
                }
                escapedBuilder.append(typePart);
                needEscaping = !needEscaping;
            }
            String string = escapedBuilder.toString();
            if (string == null) {
                SymbolInfo.$$$reportNull$$$0(0);
            }
            return string;
        }

        boolean hasType() {
            if (!JSSymbolPresentationUtils.isPossiblyPresentableType(this.type, null, true)) {
                return false;
            }
            JSTypeSource source = this.type.getSource();
            return source.isStrict();
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/documentation/JSDocumentationBuilder$SymbolInfo", "getTypeString"));
        }
    }
}

