/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.documentation;

import com.intellij.lang.ecmascript6.psi.ES6FunctionProperty;
import com.intellij.lang.ecmascript6.resolve.ES6PsiUtil;
import com.intellij.lang.javascript.JSKeywordSets;
import com.intellij.lang.javascript.documentation.JSSymbolPresentationUtils;
import com.intellij.lang.javascript.psi.JSElement;
import com.intellij.lang.javascript.psi.JSExpression;
import com.intellij.lang.javascript.psi.JSFieldVariable;
import com.intellij.lang.javascript.psi.JSFunction;
import com.intellij.lang.javascript.psi.JSFunctionExpression;
import com.intellij.lang.javascript.psi.JSFunctionItem;
import com.intellij.lang.javascript.psi.JSNamedElementBase;
import com.intellij.lang.javascript.psi.JSObjectLiteralExpression;
import com.intellij.lang.javascript.psi.JSParameter;
import com.intellij.lang.javascript.psi.JSParameterList;
import com.intellij.lang.javascript.psi.JSParameterListElement;
import com.intellij.lang.javascript.psi.JSProperty;
import com.intellij.lang.javascript.psi.JSType;
import com.intellij.lang.javascript.psi.JSTypeDeclarationOwner;
import com.intellij.lang.javascript.psi.JSTypeUtils;
import com.intellij.lang.javascript.psi.JSVarStatement;
import com.intellij.lang.javascript.psi.JSVariable;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptFunctionSignature;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptFunctionType;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptModule;
import com.intellij.lang.javascript.psi.ecmal4.JSAttributeList;
import com.intellij.lang.javascript.psi.ecmal4.JSAttributeListOwner;
import com.intellij.lang.javascript.psi.ecmal4.JSClass;
import com.intellij.lang.javascript.psi.ecmal4.JSQualifiedNamedElement;
import com.intellij.lang.javascript.psi.ecmal4.JSReferenceList;
import com.intellij.lang.javascript.psi.impl.JSFunctionImpl;
import com.intellij.lang.javascript.psi.impl.JSOffsetBasedImplicitElement;
import com.intellij.lang.javascript.psi.impl.JSPsiImplUtils;
import com.intellij.lang.javascript.psi.resolve.JSImportHandlingUtil;
import com.intellij.lang.javascript.psi.resolve.JSResolveUtil;
import com.intellij.lang.javascript.psi.resolve.JSTagContextBuilder;
import com.intellij.lang.javascript.psi.types.JSTypeSubstitutor;
import com.intellij.lang.javascript.psi.util.JSUtils;
import com.intellij.lang.javascript.settings.JSSymbolPresentationProvider;
import com.intellij.lang.javascript.ui.JSFormatUtil;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.editor.colors.CodeInsightColors;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiNamedElement;
import com.intellij.psi.impl.source.tree.LeafPsiElement;
import com.intellij.psi.util.PsiUtilCore;
import com.intellij.psi.xml.XmlAttribute;
import com.intellij.psi.xml.XmlAttributeValue;
import com.intellij.psi.xml.XmlToken;
import com.intellij.ui.ColorUtil;
import com.intellij.util.ui.UIUtil;
import java.awt.Color;
import java.awt.Font;
import java.util.Map;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JSQuickNavigateBuilder {
    @Nullable
    protected String getQuickNavigateInfoForNavigationElement(@NotNull PsiElement element, @NotNull PsiElement originalElement) {
        if (element == null) {
            JSQuickNavigateBuilder.$$$reportNull$$$0(0);
        }
        if (originalElement == null) {
            JSQuickNavigateBuilder.$$$reportNull$$$0(1);
        }
        if (element instanceof JSFunction) {
            return this.createQuickNavigateForFunction((JSFunction)element, originalElement);
        }
        if (element instanceof JSClass) {
            return this.createQuickNavigateForJSClass((JSClass)element, originalElement);
        }
        if (element instanceof JSFieldVariable) {
            return this.createQuickNavigateForVariableOrField((JSFieldVariable)element, originalElement);
        }
        if (element instanceof JSProperty) {
            return this.createQuickNavigateForProperty((JSProperty)element, originalElement);
        }
        if (element instanceof XmlToken) {
            String xmlAttributeDoc = JSQuickNavigateBuilder.checkAndGetXmlAttributeQuickNavigate(element);
            if (xmlAttributeDoc != null) {
                return xmlAttributeDoc;
            }
            JSTagContextBuilder builder = new JSTagContextBuilder(element, "XmlTag");
            return StringUtil.unquoteString((String)element.getText()) + ":" + builder.typeName;
        }
        return null;
    }

    @Nullable
    public final String getQuickNavigateInfo(@Nullable PsiElement element, @Nullable PsiElement originalElement) {
        if (originalElement == null) {
            return null;
        }
        if (element instanceof JSOffsetBasedImplicitElement) {
            element = ((JSOffsetBasedImplicitElement)element).getElementAtOffset();
        }
        return element == null ? null : this.getQuickNavigateInfoForNavigationElement(element.getNavigationElement(), originalElement);
    }

    @Nullable
    protected final String createQuickNavigateForProperty(@NotNull JSProperty element, @NotNull PsiElement originalElement) {
        String name;
        if (element == null) {
            JSQuickNavigateBuilder.$$$reportNull$$$0(2);
        }
        if (originalElement == null) {
            JSQuickNavigateBuilder.$$$reportNull$$$0(3);
        }
        if ((name = JSPsiImplUtils.getNameOrComputedPropertyName((JSNamedElementBase)element, true)) == null) {
            return null;
        }
        JSQualifiedNamedElement parent = element == JSQuickNavigateBuilder.getOriginalElementOrParentIfLeaf(originalElement) ? null : JSQuickNavigateBuilder.getPropertyParent(element);
        StringBuilder text = new StringBuilder();
        if (parent != null) {
            text.append(parent.getQualifiedName()).append(".");
        }
        text.append(name);
        JSTypeSubstitutor substitutor = this.getTypeSubstitutor((JSElement)element, originalElement);
        String typeText = this.getTypeTextForQuickNavigate(this.getPropertyTypeText(element), substitutor);
        this.appendEscapedType((PsiElement)element, typeText, text);
        JSExpression value = element.getValue();
        ObjectKind kind = value instanceof JSFunctionExpression ? ObjectKind.FUNCTION : ObjectKind.PROPERTY;
        return JSQuickNavigateBuilder.buildResult(kind, text.toString(), false, (PsiElement)element, originalElement);
    }

    @Nullable
    protected JSType getPropertyTypeText(@NotNull JSProperty element) {
        if (element == null) {
            JSQuickNavigateBuilder.$$$reportNull$$$0(4);
        }
        return JSTypeUtils.widenLiteralTypes(element.getType());
    }

    @Nullable
    private static JSQualifiedNamedElement getPropertyParent(@NotNull JSProperty property) {
        PsiElement literalContainer;
        PsiElement parent;
        if (property == null) {
            JSQuickNavigateBuilder.$$$reportNull$$$0(5);
        }
        if ((parent = property.getParent()) instanceof JSObjectLiteralExpression && (literalContainer = parent.getParent()) instanceof JSVariable) {
            return (JSVariable)literalContainer;
        }
        return null;
    }

    protected static boolean isFileNameRequired(@NotNull PsiElement element, @NotNull PsiElement originalElement) {
        if (element == null) {
            JSQuickNavigateBuilder.$$$reportNull$$$0(6);
        }
        if (originalElement == null) {
            JSQuickNavigateBuilder.$$$reportNull$$$0(7);
        }
        VirtualFile elementFile = PsiUtilCore.getVirtualFile((PsiElement)element);
        VirtualFile originalFile = PsiUtilCore.getVirtualFile((PsiElement)originalElement);
        return elementFile == null || !elementFile.equals(originalFile);
    }

    @Nullable
    protected String createQuickNavigateForFunction(@NotNull JSFunction function, PsiElement originalElement) {
        boolean isGetterOrSetter;
        if (function == null) {
            JSQuickNavigateBuilder.$$$reportNull$$$0(8);
        }
        PsiElement parent = JSResolveUtil.findParent((PsiElement)function);
        StringBuilder result2 = new StringBuilder();
        JSTypeSubstitutor substitutor = this.getTypeSubstitutor((JSElement)function, originalElement);
        boolean shouldAppendFunctionKeyword = this.shouldAppendFunctionKeyword(function, parent);
        this.appendFunctionAttributesAndName(function, parent, result2, shouldAppendFunctionKeyword, substitutor);
        boolean get = function.isGetProperty();
        boolean set = function.isSetProperty();
        boolean bl = isGetterOrSetter = get || set;
        if (!isGetterOrSetter) {
            this.appendParameterList(function, result2, substitutor);
        }
        String varType = this.getReturnTypeTextForQuickNavigate(function, get, set, substitutor);
        this.appendEscapedType((PsiElement)function, varType, result2);
        ObjectKind kind = this.getFunctionKind(function, isGetterOrSetter, shouldAppendFunctionKeyword);
        return JSQuickNavigateBuilder.buildResult(kind, result2.toString(), false, (PsiElement)function, originalElement);
    }

    @NotNull
    protected ObjectKind getFunctionKind(@NotNull JSFunction function, boolean isGetterOrSetter, boolean shouldAppendKeyword) {
        if (function == null) {
            JSQuickNavigateBuilder.$$$reportNull$$$0(9);
        }
        if (isGetterOrSetter) {
            ObjectKind objectKind = ObjectKind.PROPERTY;
            if (objectKind == null) {
                JSQuickNavigateBuilder.$$$reportNull$$$0(10);
            }
            return objectKind;
        }
        if (function.isConstructor()) {
            ObjectKind objectKind = ObjectKind.SIMPLE_DECLARATION;
            if (objectKind == null) {
                JSQuickNavigateBuilder.$$$reportNull$$$0(11);
            }
            return objectKind;
        }
        ObjectKind objectKind = shouldAppendKeyword ? ObjectKind.SIMPLE_DECLARATION : ObjectKind.FUNCTION;
        if (objectKind == null) {
            JSQuickNavigateBuilder.$$$reportNull$$$0(12);
        }
        return objectKind;
    }

    private void appendParameterList(@NotNull JSFunction function, @NotNull StringBuilder result2, @NotNull JSTypeSubstitutor substitutor) {
        if (function == null) {
            JSQuickNavigateBuilder.$$$reportNull$$$0(13);
        }
        if (result2 == null) {
            JSQuickNavigateBuilder.$$$reportNull$$$0(14);
        }
        if (substitutor == null) {
            JSQuickNavigateBuilder.$$$reportNull$$$0(15);
        }
        result2.append('(');
        JSParameterList jsParameterList = function.getParameterList();
        if (jsParameterList != null) {
            int start = result2.length();
            for (JSParameterListElement p : jsParameterList.getParameters()) {
                String typeText;
                if (start != result2.length()) {
                    result2.append(", ");
                }
                result2.append(p.getName());
                if (p.isOptional()) {
                    result2.append("?");
                }
                if ((typeText = this.getTypeTextForQuickNavigate(p.getType(), substitutor)) == null) continue;
                this.appendEscapedType((PsiElement)p, typeText, result2);
            }
        }
        result2.append(')');
    }

    protected static String buildResult(@NotNull ObjectKind kind, @NotNull String objectText, boolean isInferred, @NotNull PsiElement element, @NotNull PsiElement originalElement) {
        if (kind == null) {
            JSQuickNavigateBuilder.$$$reportNull$$$0(16);
        }
        if (objectText == null) {
            JSQuickNavigateBuilder.$$$reportNull$$$0(17);
        }
        if (element == null) {
            JSQuickNavigateBuilder.$$$reportNull$$$0(18);
        }
        if (originalElement == null) {
            JSQuickNavigateBuilder.$$$reportNull$$$0(19);
        }
        boolean needFileName = JSQuickNavigateBuilder.isFileNameRequired(element, originalElement);
        if (!isInferred && !needFileName) {
            return kind.toPrefix() + objectText;
        }
        VirtualFile file = PsiUtilCore.getVirtualFile((PsiElement)element);
        assert (file != null);
        String inferredText = isInferred ? "inferred" : "";
        String fileNameText = needFileName ? "(" + file.getName() + ")" : "";
        String kindText = kind.toPrefix();
        return kindText + objectText + JSQuickNavigateBuilder.buildAdditionalInformationText(inferredText, true) + JSQuickNavigateBuilder.buildAdditionalInformationText(fileNameText, false);
    }

    protected final String createQuickNavigateForVariableOrField(@NotNull JSFieldVariable variableOrField, PsiElement originalElement) {
        String parentInfo;
        if (variableOrField == null) {
            JSQuickNavigateBuilder.$$$reportNull$$$0(20);
        }
        PsiElement parent = JSResolveUtil.findParent((PsiElement)variableOrField);
        StringBuilder result2 = new StringBuilder();
        JSTypeSubstitutor substitutor = this.getTypeSubstitutor((JSElement)variableOrField, originalElement);
        this.appendAttrList((JSAttributeListOwner)variableOrField, result2);
        if (variableOrField instanceof JSVariable) {
            result2.append(this.getVarPrefix((JSVariable)variableOrField));
        }
        if (!StringUtil.isEmpty((String)(parentInfo = this.getParentInfo(parent, (PsiNamedElement)variableOrField, substitutor)))) {
            result2.append(parentInfo).append(".");
        }
        result2.append(variableOrField.getName());
        String variableOrFieldTypeText = this.getTypeTextForQuickNavigate(this.getVariableOrFieldType((JSTypeDeclarationOwner)variableOrField), substitutor);
        String inferredType = this.getVariableOrFieldInferredTypeText((JSElement)variableOrField, originalElement, substitutor);
        if (variableOrFieldTypeText != null) {
            this.appendEscapedType((PsiElement)variableOrField, inferredType != null ? inferredType : variableOrFieldTypeText, result2);
        }
        if (variableOrField instanceof JSVariable && ((JSVariable)variableOrField).hasInitializer()) {
            this.appendVariableInitializer((JSVariable)variableOrField, result2);
        }
        boolean isInferredType = this.isInferredVariableType(variableOrField, variableOrFieldTypeText, inferredType);
        ObjectKind kind = this.getFieldOrVariableKind(variableOrField);
        return JSQuickNavigateBuilder.buildResult(kind, result2.toString(), isInferredType, (PsiElement)variableOrField, originalElement);
    }

    @NotNull
    protected ObjectKind getFieldOrVariableKind(@NotNull JSFieldVariable variableOrField) {
        if (variableOrField == null) {
            JSQuickNavigateBuilder.$$$reportNull$$$0(21);
        }
        ObjectKind objectKind = variableOrField instanceof JSParameter ? ObjectKind.PARAMETER : ObjectKind.SIMPLE_DECLARATION;
        if (objectKind == null) {
            JSQuickNavigateBuilder.$$$reportNull$$$0(22);
        }
        return objectKind;
    }

    protected boolean isInferredVariableType(@NotNull JSFieldVariable variableOrField, @Nullable String variableOrFieldTypeText, @Nullable String inferredType) {
        if (variableOrField == null) {
            JSQuickNavigateBuilder.$$$reportNull$$$0(23);
        }
        return inferredType != null && !inferredType.equals(variableOrFieldTypeText);
    }

    private static String buildAdditionalInformationText(@NotNull String text, boolean italic) {
        if (text == null) {
            JSQuickNavigateBuilder.$$$reportNull$$$0(24);
        }
        if (StringUtil.isEmpty((String)text)) {
            return "";
        }
        Color color = CodeInsightColors.NOT_USED_ELEMENT_ATTRIBUTES.getDefaultAttributes().getForegroundColor();
        StringBuilder result2 = new StringBuilder();
        result2.append(" <span");
        result2.append(" style=\"");
        Font font = UIUtil.getLabelFont();
        if (!ApplicationManager.getApplication().isUnitTestMode()) {
            if (font != null) {
                result2.append("font-size:").append(font.getSize()).append("pt").append(";");
            }
            if (color != null) {
                result2.append("color:").append(ColorUtil.toHex((Color)color)).append(";");
            }
        }
        result2.append("\">");
        if (italic) {
            result2.append("<i>");
        }
        result2.append(text);
        if (italic) {
            result2.append("</i>");
        }
        result2.append("</span>");
        return result2.toString();
    }

    @Nullable
    protected String createQuickNavigateForJSClass(@NotNull JSClass jsClass, PsiElement originalElement) {
        String qName;
        if (jsClass == null) {
            JSQuickNavigateBuilder.$$$reportNull$$$0(25);
        }
        if ((qName = jsClass.getQualifiedName()) == null) {
            return null;
        }
        StringBuilder result2 = new StringBuilder();
        String packageName = StringUtil.getPackageName((String)qName);
        this.appendClassAttributesAndName(jsClass, originalElement, packageName, result2);
        this.appendClassExtendsAndImplements(jsClass, packageName, result2);
        return JSQuickNavigateBuilder.buildResult(ObjectKind.SIMPLE_DECLARATION, result2.toString(), false, (PsiElement)jsClass, originalElement);
    }

    @Nullable
    protected String getParentInfo(@Nullable PsiElement parent, @NotNull PsiNamedElement element, @NotNull JSTypeSubstitutor substitutor) {
        if (element == null) {
            JSQuickNavigateBuilder.$$$reportNull$$$0(26);
        }
        if (substitutor == null) {
            JSQuickNavigateBuilder.$$$reportNull$$$0(27);
        }
        if (parent instanceof JSClass) {
            return StringUtil.notNullize((String)((JSClass)parent).getQualifiedName(), (String)"default");
        }
        return "";
    }

    @Nullable
    private static String checkAndGetXmlAttributeQuickNavigate(@NotNull PsiElement element) {
        PsiElement xmlAttribute;
        if (element == null) {
            JSQuickNavigateBuilder.$$$reportNull$$$0(28);
        }
        String xmlAttributeDoc = null;
        Object object = element.getParent() instanceof XmlAttribute ? element.getParent() : (xmlAttribute = element.getParent() instanceof XmlAttributeValue && element.getParent().getParent() instanceof XmlAttribute ? element.getParent().getParent() : null);
        if (xmlAttribute != null) {
            String value = StringUtil.unquoteString((String)StringUtil.notNullize((String)((XmlAttribute)xmlAttribute).getValue()));
            xmlAttributeDoc = ((XmlAttribute)xmlAttribute).getName() + " " + value;
        }
        return xmlAttributeDoc;
    }

    @Nullable
    protected String getReturnTypeTextForQuickNavigate(@NotNull JSFunction function, boolean get, boolean set, @NotNull JSTypeSubstitutor substitutor) {
        JSParameterListElement[] jsParameters;
        if (function == null) {
            JSQuickNavigateBuilder.$$$reportNull$$$0(29);
        }
        if (substitutor == null) {
            JSQuickNavigateBuilder.$$$reportNull$$$0(30);
        }
        if (get || !set) {
            JSType type = JSFunctionImpl.getReturnTypeInContext((JSFunctionItem)function, null);
            if (!JSSymbolPresentationUtils.isPossiblyPresentableType(type, (PsiElement)function, true)) {
                return null;
            }
            return this.getTypeTextForQuickNavigate(type, substitutor);
        }
        JSParameterList jsParameterList = function.getParameterList();
        if (jsParameterList != null && (jsParameters = jsParameterList.getParameters()).length > 0) {
            return this.getTypeTextForQuickNavigate(jsParameters[0].getType(), substitutor);
        }
        return null;
    }

    @Nullable
    protected String getTypeTextForQuickNavigate(@Nullable JSType rawType, @NotNull JSTypeSubstitutor substitutor) {
        JSType type;
        if (substitutor == null) {
            JSQuickNavigateBuilder.$$$reportNull$$$0(31);
        }
        return (type = JSTypeUtils.applyGenericArguments(rawType, (Map<String, JSType>)substitutor)) != null ? type.getTypeText(JSType.TypeTextFormat.PRESENTABLE) : null;
    }

    protected void appendFunctionAttributesAndName(@NotNull JSFunction function, @Nullable PsiElement parent, @NotNull StringBuilder result2, boolean shouldAppendKeyword, @NotNull JSTypeSubstitutor substitutor) {
        String parentInfo;
        if (function == null) {
            JSQuickNavigateBuilder.$$$reportNull$$$0(32);
        }
        if (result2 == null) {
            JSQuickNavigateBuilder.$$$reportNull$$$0(33);
        }
        if (substitutor == null) {
            JSQuickNavigateBuilder.$$$reportNull$$$0(34);
        }
        this.appendAttrList((JSAttributeListOwner)function, result2);
        if (shouldAppendKeyword) {
            result2.append("function ");
        }
        if (!StringUtil.isEmpty((String)(parentInfo = this.getParentInfo(parent, (PsiNamedElement)function, substitutor)))) {
            result2.append(parentInfo).append(".");
        }
        result2.append(StringUtil.notNullize((String)function.getName(), (String)"<unknown>"));
    }

    protected boolean shouldAppendFunctionKeyword(@NotNull JSFunction function, @Nullable PsiElement parent) {
        if (function == null) {
            JSQuickNavigateBuilder.$$$reportNull$$$0(35);
        }
        if (JSPsiImplUtils.isGetterOrSetter(function)) {
            return false;
        }
        if (function instanceof ES6FunctionProperty || function instanceof TypeScriptFunctionSignature || function instanceof TypeScriptFunctionType) {
            return false;
        }
        return !(parent instanceof JSClass);
    }

    protected void appendAttrList(@NotNull JSAttributeListOwner owner, @NotNull StringBuilder result2) {
        JSElement exportScope;
        JSAttributeList attributeList;
        if (owner == null) {
            JSQuickNavigateBuilder.$$$reportNull$$$0(36);
        }
        if (result2 == null) {
            JSQuickNavigateBuilder.$$$reportNull$$$0(37);
        }
        if ((attributeList = owner.getAttributeList()) == null) {
            return;
        }
        JSAttributeList.AccessType type = attributeList.getAccessType();
        String visibilityOrExportPart = null;
        JSClass jsClass = JSUtils.getMemberContainingClass((PsiElement)owner);
        if (jsClass != null) {
            visibilityOrExportPart = JSFormatUtil.formatVisibility(type, (PsiElement)owner);
        } else if (owner instanceof JSQualifiedNamedElement && ((exportScope = ES6PsiUtil.getExportScope((PsiElement)owner)) instanceof TypeScriptModule || ES6PsiUtil.isExternalModule((PsiElement)exportScope))) {
            if (((JSQualifiedNamedElement)owner).isExported()) {
                visibilityOrExportPart = "export";
            } else if (((JSQualifiedNamedElement)owner).isExportedWithDefault()) {
                visibilityOrExportPart = "export default";
            }
        }
        if (visibilityOrExportPart != null) {
            result2.append(visibilityOrExportPart);
            result2.append(" ");
        }
        this.appendPlainModifierList(attributeList, result2);
    }

    protected void appendPlainModifierList(@NotNull JSAttributeList attributeList, @NotNull StringBuilder result2) {
        if (attributeList == null) {
            JSQuickNavigateBuilder.$$$reportNull$$$0(38);
        }
        if (result2 == null) {
            JSQuickNavigateBuilder.$$$reportNull$$$0(39);
        }
        JSQuickNavigateBuilder.appendModifierWithSpace(result2, attributeList, JSAttributeList.ModifierType.ASYNC);
        JSQuickNavigateBuilder.appendModifierWithSpace(result2, attributeList, JSAttributeList.ModifierType.STATIC);
        JSQuickNavigateBuilder.appendModifierWithSpace(result2, attributeList, JSAttributeList.ModifierType.GENERATOR);
    }

    @Nullable
    protected String getVariableOrFieldInferredTypeText(@NotNull JSElement resolved, @NotNull PsiElement originalElement, @NotNull JSTypeSubstitutor substitutor) {
        if (resolved == null) {
            JSQuickNavigateBuilder.$$$reportNull$$$0(40);
        }
        if (originalElement == null) {
            JSQuickNavigateBuilder.$$$reportNull$$$0(41);
        }
        if (substitutor == null) {
            JSQuickNavigateBuilder.$$$reportNull$$$0(42);
        }
        return null;
    }

    protected JSType getVariableOrFieldType(@NotNull JSTypeDeclarationOwner variable) {
        if (variable == null) {
            JSQuickNavigateBuilder.$$$reportNull$$$0(43);
        }
        return variable.getType();
    }

    @NotNull
    protected JSTypeSubstitutor getTypeSubstitutor(@NotNull JSElement el, @NotNull PsiElement originalElement) {
        if (el == null) {
            JSQuickNavigateBuilder.$$$reportNull$$$0(44);
        }
        if (originalElement == null) {
            JSQuickNavigateBuilder.$$$reportNull$$$0(45);
        }
        JSTypeSubstitutor jSTypeSubstitutor = JSTypeSubstitutor.EMPTY;
        if (jSTypeSubstitutor == null) {
            JSQuickNavigateBuilder.$$$reportNull$$$0(46);
        }
        return jSTypeSubstitutor;
    }

    protected void appendEscapedType(@NotNull PsiElement context, @Nullable String varType, @NotNull StringBuilder builder) {
        if (context == null) {
            JSQuickNavigateBuilder.$$$reportNull$$$0(47);
        }
        if (builder == null) {
            JSQuickNavigateBuilder.$$$reportNull$$$0(48);
        }
        if (!StringUtil.isEmpty((String)varType)) {
            builder.append(JSSymbolPresentationProvider.getDefaultTypeSeparator(context)).append(StringUtil.escapeXml((String)varType));
        }
    }

    protected void appendClassAttributesAndName(@NotNull JSClass jsClass, @NotNull PsiElement originalElement, @Nullable String packageOrModule, @NotNull StringBuilder result2) {
        if (jsClass == null) {
            JSQuickNavigateBuilder.$$$reportNull$$$0(49);
        }
        if (originalElement == null) {
            JSQuickNavigateBuilder.$$$reportNull$$$0(50);
        }
        if (result2 == null) {
            JSQuickNavigateBuilder.$$$reportNull$$$0(51);
        }
        this.appendAttrList((JSAttributeListOwner)jsClass, result2);
        result2.append(jsClass.isInterface() ? "interface " : "class ");
        this.appendClassNameWithPackage(jsClass, packageOrModule, result2);
    }

    protected void appendClassNameWithPackage(@NotNull JSClass jsClass, @Nullable String packageOrModule, @NotNull StringBuilder result2) {
        if (jsClass == null) {
            JSQuickNavigateBuilder.$$$reportNull$$$0(52);
        }
        if (result2 == null) {
            JSQuickNavigateBuilder.$$$reportNull$$$0(53);
        }
        if (!StringUtil.isEmpty((String)packageOrModule)) {
            result2.append(packageOrModule).append(".");
        }
        result2.append(jsClass.getName());
    }

    protected void appendClassExtendsAndImplements(@NotNull JSClass jsClass, @NotNull String packageNameOrEmptyString, @NotNull StringBuilder result2) {
        String implementsList;
        String extendsList;
        if (jsClass == null) {
            JSQuickNavigateBuilder.$$$reportNull$$$0(54);
        }
        if (packageNameOrEmptyString == null) {
            JSQuickNavigateBuilder.$$$reportNull$$$0(55);
        }
        if (result2 == null) {
            JSQuickNavigateBuilder.$$$reportNull$$$0(56);
        }
        if ((extendsList = JSQuickNavigateBuilder.generateReferenceTargetList(jsClass.getExtendsList(), packageNameOrEmptyString)) == null && this.isIncludeObjectInExtendsList() && !"Object".equals(jsClass.getName())) {
            extendsList = "Object";
        }
        if (extendsList != null) {
            result2.append(" extends ").append(extendsList);
        }
        if ((implementsList = JSQuickNavigateBuilder.generateReferenceTargetList(jsClass.getImplementsList(), packageNameOrEmptyString)) != null) {
            result2.append("\nimplements ").append(implementsList);
        }
    }

    protected boolean isIncludeObjectInExtendsList() {
        return false;
    }

    @Nullable
    private static String generateReferenceTargetList(@Nullable JSReferenceList implementsList, @NotNull String packageName) {
        String[] referenceExpressionTexts;
        if (packageName == null) {
            JSQuickNavigateBuilder.$$$reportNull$$$0(57);
        }
        if (implementsList == null) {
            return null;
        }
        StringBuilder result2 = null;
        for (String refExprText : referenceExpressionTexts = implementsList.getReferenceTexts()) {
            refExprText = JSImportHandlingUtil.resolveTypeName(refExprText, (PsiElement)implementsList);
            if (result2 == null) {
                result2 = new StringBuilder();
            } else {
                result2.append(",");
            }
            refExprText = StringUtil.notNullize((String)refExprText);
            String referencedPackageName = StringUtil.getPackageName((String)refExprText);
            result2.append(referencedPackageName.equals(packageName) ? refExprText.substring(refExprText.lastIndexOf(46) + 1) : refExprText);
        }
        return result2 == null ? null : result2.toString();
    }

    @NotNull
    protected String getVarPrefix(@NotNull JSVariable variable) {
        JSVarStatement statement;
        if (variable == null) {
            JSQuickNavigateBuilder.$$$reportNull$$$0(58);
        }
        JSVarStatement.VarKeyword keyword = (statement = variable.getStatement()) != null ? statement.getVarKeyword() : null;
        String string = keyword != null ? keyword.getText() + " " : "";
        if (string == null) {
            JSQuickNavigateBuilder.$$$reportNull$$$0(59);
        }
        return string;
    }

    protected void appendVariableInitializer(@NotNull JSVariable variable, @NotNull StringBuilder result2) {
        JSExpression initializer;
        String initializerText;
        if (variable == null) {
            JSQuickNavigateBuilder.$$$reportNull$$$0(60);
        }
        if (result2 == null) {
            JSQuickNavigateBuilder.$$$reportNull$$$0(61);
        }
        if ((initializerText = variable.getLiteralOrReferenceInitializerText()) == null && (initializer = variable.getInitializer()) != null) {
            initializerText = initializer.getText();
        }
        if (initializerText != null) {
            int maxInitStringLengthToShow = 50;
            if (initializerText.length() > maxInitStringLengthToShow) {
                initializerText = initializerText.substring(0, maxInitStringLengthToShow) + "...";
            }
            result2.append(" = ").append(StringUtil.escapeXml((String)initializerText));
        }
    }

    protected static void appendModifierWithSpace(@NotNull StringBuilder result2, @NotNull JSAttributeList attributeList, @NotNull JSAttributeList.ModifierType modifier) {
        if (result2 == null) {
            JSQuickNavigateBuilder.$$$reportNull$$$0(62);
        }
        if (attributeList == null) {
            JSQuickNavigateBuilder.$$$reportNull$$$0(63);
        }
        if (modifier == null) {
            JSQuickNavigateBuilder.$$$reportNull$$$0(64);
        }
        if (attributeList.hasModifier(modifier)) {
            result2.append(modifier.keyword).append(" ");
        }
    }

    @Nullable
    protected String createQuickNavigateForJSElement(@NotNull JSElement element, @NotNull PsiElement originalElement, @NotNull String declaration, @NotNull ObjectKind kind) {
        String name;
        if (element == null) {
            JSQuickNavigateBuilder.$$$reportNull$$$0(65);
        }
        if (originalElement == null) {
            JSQuickNavigateBuilder.$$$reportNull$$$0(66);
        }
        if (declaration == null) {
            JSQuickNavigateBuilder.$$$reportNull$$$0(67);
        }
        if (kind == null) {
            JSQuickNavigateBuilder.$$$reportNull$$$0(68);
        }
        String string = name = element instanceof JSQualifiedNamedElement ? ((JSQualifiedNamedElement)element).getQualifiedName() : element.getName();
        if (StringUtil.isEmpty((String)name)) {
            return null;
        }
        StringBuilder result2 = new StringBuilder();
        if (element instanceof JSAttributeListOwner) {
            this.appendAttrList((JSAttributeListOwner)element, result2);
        }
        if (!declaration.isEmpty()) {
            result2.append(declaration);
            result2.append(" ");
        }
        result2.append(name);
        return JSQuickNavigateBuilder.buildResult(kind, result2.toString(), false, (PsiElement)element, originalElement);
    }

    @Contract(value="!null->!null")
    protected static PsiElement getOriginalElementOrParentIfLeaf(@Nullable PsiElement originalElement) {
        if (originalElement instanceof LeafPsiElement && JSKeywordSets.IDENTIFIER_NAMES.contains(originalElement.getNode().getElementType())) {
            originalElement = originalElement.getParent();
        }
        return originalElement;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 10: 
            case 11: 
            case 12: 
            case 22: 
            case 46: 
            case 59: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 10: 
            case 11: 
            case 12: 
            case 22: 
            case 46: 
            case 59: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 1: 
            case 3: 
            case 7: 
            case 19: 
            case 41: 
            case 45: 
            case 50: 
            case 66: {
                objectArray2 = objectArray3;
                objectArray3[0] = "originalElement";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "property";
                break;
            }
            case 8: 
            case 9: 
            case 13: 
            case 29: 
            case 32: 
            case 35: {
                objectArray2 = objectArray3;
                objectArray3[0] = "function";
                break;
            }
            case 10: 
            case 11: 
            case 12: 
            case 22: 
            case 46: 
            case 59: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/javascript/documentation/JSQuickNavigateBuilder";
                break;
            }
            case 14: 
            case 33: 
            case 37: 
            case 39: 
            case 51: 
            case 53: 
            case 56: 
            case 61: 
            case 62: {
                objectArray2 = objectArray3;
                objectArray3[0] = "result";
                break;
            }
            case 15: 
            case 27: 
            case 30: 
            case 31: 
            case 34: 
            case 42: {
                objectArray2 = objectArray3;
                objectArray3[0] = "substitutor";
                break;
            }
            case 16: 
            case 68: {
                objectArray2 = objectArray3;
                objectArray3[0] = "kind";
                break;
            }
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "objectText";
                break;
            }
            case 20: 
            case 21: 
            case 23: {
                objectArray2 = objectArray3;
                objectArray3[0] = "variableOrField";
                break;
            }
            case 24: {
                objectArray2 = objectArray3;
                objectArray3[0] = "text";
                break;
            }
            case 25: 
            case 49: 
            case 52: 
            case 54: {
                objectArray2 = objectArray3;
                objectArray3[0] = "jsClass";
                break;
            }
            case 36: {
                objectArray2 = objectArray3;
                objectArray3[0] = "owner";
                break;
            }
            case 38: 
            case 63: {
                objectArray2 = objectArray3;
                objectArray3[0] = "attributeList";
                break;
            }
            case 40: {
                objectArray2 = objectArray3;
                objectArray3[0] = "resolved";
                break;
            }
            case 43: 
            case 58: 
            case 60: {
                objectArray2 = objectArray3;
                objectArray3[0] = "variable";
                break;
            }
            case 44: {
                objectArray2 = objectArray3;
                objectArray3[0] = "el";
                break;
            }
            case 47: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 48: {
                objectArray2 = objectArray3;
                objectArray3[0] = "builder";
                break;
            }
            case 55: {
                objectArray2 = objectArray3;
                objectArray3[0] = "packageNameOrEmptyString";
                break;
            }
            case 57: {
                objectArray2 = objectArray3;
                objectArray3[0] = "packageName";
                break;
            }
            case 64: {
                objectArray2 = objectArray3;
                objectArray3[0] = "modifier";
                break;
            }
            case 67: {
                objectArray2 = objectArray3;
                objectArray3[0] = "declaration";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/javascript/documentation/JSQuickNavigateBuilder";
                break;
            }
            case 10: 
            case 11: 
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "getFunctionKind";
                break;
            }
            case 22: {
                objectArray = objectArray2;
                objectArray2[1] = "getFieldOrVariableKind";
                break;
            }
            case 46: {
                objectArray = objectArray2;
                objectArray2[1] = "getTypeSubstitutor";
                break;
            }
            case 59: {
                objectArray = objectArray2;
                objectArray2[1] = "getVarPrefix";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getQuickNavigateInfoForNavigationElement";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "createQuickNavigateForProperty";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "getPropertyTypeText";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "getPropertyParent";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "isFileNameRequired";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "createQuickNavigateForFunction";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "getFunctionKind";
                break;
            }
            case 10: 
            case 11: 
            case 12: 
            case 22: 
            case 46: 
            case 59: {
                break;
            }
            case 13: 
            case 14: 
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "appendParameterList";
                break;
            }
            case 16: 
            case 17: 
            case 18: 
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "buildResult";
                break;
            }
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "createQuickNavigateForVariableOrField";
                break;
            }
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "getFieldOrVariableKind";
                break;
            }
            case 23: {
                objectArray = objectArray;
                objectArray[2] = "isInferredVariableType";
                break;
            }
            case 24: {
                objectArray = objectArray;
                objectArray[2] = "buildAdditionalInformationText";
                break;
            }
            case 25: {
                objectArray = objectArray;
                objectArray[2] = "createQuickNavigateForJSClass";
                break;
            }
            case 26: 
            case 27: {
                objectArray = objectArray;
                objectArray[2] = "getParentInfo";
                break;
            }
            case 28: {
                objectArray = objectArray;
                objectArray[2] = "checkAndGetXmlAttributeQuickNavigate";
                break;
            }
            case 29: 
            case 30: {
                objectArray = objectArray;
                objectArray[2] = "getReturnTypeTextForQuickNavigate";
                break;
            }
            case 31: {
                objectArray = objectArray;
                objectArray[2] = "getTypeTextForQuickNavigate";
                break;
            }
            case 32: 
            case 33: 
            case 34: {
                objectArray = objectArray;
                objectArray[2] = "appendFunctionAttributesAndName";
                break;
            }
            case 35: {
                objectArray = objectArray;
                objectArray[2] = "shouldAppendFunctionKeyword";
                break;
            }
            case 36: 
            case 37: {
                objectArray = objectArray;
                objectArray[2] = "appendAttrList";
                break;
            }
            case 38: 
            case 39: {
                objectArray = objectArray;
                objectArray[2] = "appendPlainModifierList";
                break;
            }
            case 40: 
            case 41: 
            case 42: {
                objectArray = objectArray;
                objectArray[2] = "getVariableOrFieldInferredTypeText";
                break;
            }
            case 43: {
                objectArray = objectArray;
                objectArray[2] = "getVariableOrFieldType";
                break;
            }
            case 44: 
            case 45: {
                objectArray = objectArray;
                objectArray[2] = "getTypeSubstitutor";
                break;
            }
            case 47: 
            case 48: {
                objectArray = objectArray;
                objectArray[2] = "appendEscapedType";
                break;
            }
            case 49: 
            case 50: 
            case 51: {
                objectArray = objectArray;
                objectArray[2] = "appendClassAttributesAndName";
                break;
            }
            case 52: 
            case 53: {
                objectArray = objectArray;
                objectArray[2] = "appendClassNameWithPackage";
                break;
            }
            case 54: 
            case 55: 
            case 56: {
                objectArray = objectArray;
                objectArray[2] = "appendClassExtendsAndImplements";
                break;
            }
            case 57: {
                objectArray = objectArray;
                objectArray[2] = "generateReferenceTargetList";
                break;
            }
            case 58: {
                objectArray = objectArray;
                objectArray[2] = "getVarPrefix";
                break;
            }
            case 60: 
            case 61: {
                objectArray = objectArray;
                objectArray[2] = "appendVariableInitializer";
                break;
            }
            case 62: 
            case 63: 
            case 64: {
                objectArray = objectArray;
                objectArray[2] = "appendModifierWithSpace";
                break;
            }
            case 65: 
            case 66: 
            case 67: 
            case 68: {
                objectArray = objectArray;
                objectArray[2] = "createQuickNavigateForJSElement";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 10: 
            case 11: 
            case 12: 
            case 22: 
            case 46: 
            case 59: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    protected static enum ObjectKind {
        SIMPLE_DECLARATION{

            @Override
            @NotNull
            public String toPrefix() {
                if ("" == null) {
                    1.$$$reportNull$$$0(0);
                }
                return "";
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/documentation/JSQuickNavigateBuilder$ObjectKind$1", "toPrefix"));
            }
        }
        ,
        PROPERTY{

            @Override
            @NotNull
            public String toPrefix() {
                if ("(property) " == null) {
                    2.$$$reportNull$$$0(0);
                }
                return "(property) ";
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/documentation/JSQuickNavigateBuilder$ObjectKind$2", "toPrefix"));
            }
        }
        ,
        PARAMETER{

            @Override
            @NotNull
            public String toPrefix() {
                if ("(parameter) " == null) {
                    3.$$$reportNull$$$0(0);
                }
                return "(parameter) ";
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/documentation/JSQuickNavigateBuilder$ObjectKind$3", "toPrefix"));
            }
        }
        ,
        FUNCTION{

            @Override
            @NotNull
            public String toPrefix() {
                if ("(function) " == null) {
                    4.$$$reportNull$$$0(0);
                }
                return "(function) ";
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/documentation/JSQuickNavigateBuilder$ObjectKind$4", "toPrefix"));
            }
        }
        ,
        IMPORT_SPECIFIER{

            @Override
            @NotNull
            public String toPrefix() {
                if ("(named import) " == null) {
                    5.$$$reportNull$$$0(0);
                }
                return "(named import) ";
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/documentation/JSQuickNavigateBuilder$ObjectKind$5", "toPrefix"));
            }
        }
        ,
        IMPORT_DEFAULT{

            @Override
            @NotNull
            public String toPrefix() {
                if ("(default import) " == null) {
                    6.$$$reportNull$$$0(0);
                }
                return "(default import) ";
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/documentation/JSQuickNavigateBuilder$ObjectKind$6", "toPrefix"));
            }
        }
        ,
        IMPORT_ALL{

            @Override
            @NotNull
            public String toPrefix() {
                if ("(namespace import) " == null) {
                    7.$$$reportNull$$$0(0);
                }
                return "(namespace import) ";
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/documentation/JSQuickNavigateBuilder$ObjectKind$7", "toPrefix"));
            }
        }
        ,
        EXPORT{

            @Override
            @NotNull
            public String toPrefix() {
                if ("(export element) " == null) {
                    8.$$$reportNull$$$0(0);
                }
                return "(export element) ";
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/documentation/JSQuickNavigateBuilder$ObjectKind$8", "toPrefix"));
            }
        };


        @NotNull
        public abstract String toPrefix();
    }
}

