/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.editing;

import com.intellij.codeInsight.unwrap.UnwrapDescriptor;
import com.intellij.codeInsight.unwrap.Unwrapper;
import com.intellij.lang.javascript.psi.JSBlockStatement;
import com.intellij.lang.javascript.psi.JSFile;
import com.intellij.lang.javascript.psi.JSForInStatement;
import com.intellij.lang.javascript.psi.JSForStatement;
import com.intellij.lang.javascript.psi.JSFunction;
import com.intellij.lang.javascript.psi.JSIfStatement;
import com.intellij.lang.javascript.psi.JSLoopStatement;
import com.intellij.lang.javascript.psi.JSTryStatement;
import com.intellij.lang.javascript.psi.JSWhileStatement;
import com.intellij.lang.javascript.refactoring.FormatFixer;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.RangeMarker;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.Segment;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.text.CharArrayUtil;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.NotNull;

public class JavaScriptUnwrapDescriptor
implements UnwrapDescriptor {
    @NotNull
    public List<Pair<PsiElement, Unwrapper>> collectUnwrappers(@NotNull Project project, @NotNull Editor editor, @NotNull PsiFile file) {
        if (project == null) {
            JavaScriptUnwrapDescriptor.$$$reportNull$$$0(0);
        }
        if (editor == null) {
            JavaScriptUnwrapDescriptor.$$$reportNull$$$0(1);
        }
        if (file == null) {
            JavaScriptUnwrapDescriptor.$$$reportNull$$$0(2);
        }
        PsiElement element = file.findElementAt(editor.getCaretModel().getOffset());
        PsiElement previous = null;
        List<Pair<PsiElement, Unwrapper>> result2 = null;
        while (element != null) {
            PsiElement parent = element.getParent();
            JSBasicUnwrapper unwrapper = null;
            if (element instanceof JSBlockStatement) {
                if (parent instanceof JSBlockStatement || parent instanceof JSFile) {
                    unwrapper = new JSBlockUnwrapper();
                } else if (parent instanceof JSLoopStatement) {
                    unwrapper = new JSLoopUnwrapper();
                    element = parent;
                    parent = parent.getParent();
                } else if (parent instanceof JSIfStatement) {
                    unwrapper = element == ((JSIfStatement)parent).getThen() ? new JSIfUnwrapper() : new JSElseUnwrapper();
                    element = parent;
                    parent = parent.getParent();
                } else if (parent instanceof JSTryStatement) {
                    unwrapper = new JSTryUnwrapper();
                    element = parent;
                    parent = parent.getParent();
                }
                if (unwrapper != null) {
                    unwrapper.setBlockWithinSingleOperatorParent(parent instanceof JSIfStatement || parent instanceof JSLoopStatement);
                }
            } else if (element instanceof JSIfStatement) {
                JSIfStatement ifstatement = (JSIfStatement)element;
                if (!(previous instanceof JSBlockStatement)) {
                    unwrapper = ifstatement.getElse() == previous ? new JSBasicElseUnwrapper(){

                        @Override
                        protected TextRange getReplacedRangeStart(PsiElement elt) {
                            TextRange range = elt.getTextRange();
                            return new TextRange(range.getStartOffset(), ((JSIfStatement)elt).getElse().getTextRange().getStartOffset());
                        }

                        @Override
                        protected TextRange getReplacedRangeEnd(PsiElement elt) {
                            TextRange range = elt.getTextRange();
                            return new TextRange(((JSIfStatement)elt).getElse().getTextRange().getEndOffset(), range.getEndOffset());
                        }
                    } : (ifstatement.getThen() instanceof JSBlockStatement ? new JSIfUnwrapper() : new JSIfUnwrapper(){

                        @Override
                        protected TextRange getReplacedRangeStart(PsiElement elt) {
                            TextRange range = elt.getTextRange();
                            return new TextRange(range.getStartOffset(), ((JSIfStatement)elt).getThen().getTextRange().getStartOffset());
                        }

                        @Override
                        protected TextRange getReplacedRangeEnd(PsiElement elt) {
                            TextRange range = elt.getTextRange();
                            return new TextRange(((JSIfStatement)elt).getThen().getTextRange().getEndOffset(), range.getEndOffset());
                        }
                    });
                }
            } else if (element instanceof JSLoopStatement) {
                if (!(previous instanceof JSBlockStatement)) {
                    unwrapper = ((JSLoopStatement)element).getBody() instanceof JSBlockStatement ? new JSLoopUnwrapper() : new JSBasicLoopUnwrapper(){

                        @Override
                        protected TextRange getReplacedRangeStart(PsiElement elt) {
                            TextRange range = elt.getTextRange();
                            return new TextRange(range.getStartOffset(), ((JSLoopStatement)elt).getBody().getTextRange().getStartOffset());
                        }

                        @Override
                        protected TextRange getReplacedRangeEnd(PsiElement elt) {
                            TextRange range = elt.getTextRange();
                            return new TextRange(((JSLoopStatement)elt).getBody().getTextRange().getEndOffset(), range.getEndOffset());
                        }
                    };
                }
            } else if (element instanceof JSTryStatement && !(previous instanceof JSBlockStatement)) {
                unwrapper = new JSTryUnwrapper();
            }
            result2 = JavaScriptUnwrapDescriptor.addUnwrapper(element, result2, unwrapper);
            previous = element;
            element = parent;
            if (!(element instanceof JSFunction)) continue;
            break;
        }
        if (result2 == null) {
            List<Pair<PsiElement, Unwrapper>> list = Collections.emptyList();
            if (list == null) {
                JavaScriptUnwrapDescriptor.$$$reportNull$$$0(3);
            }
            return list;
        }
        List<Pair<PsiElement, Unwrapper>> list = result2;
        if (list == null) {
            JavaScriptUnwrapDescriptor.$$$reportNull$$$0(4);
        }
        return list;
    }

    private static List<Pair<PsiElement, Unwrapper>> addUnwrapper(PsiElement element, List<Pair<PsiElement, Unwrapper>> result2, JSBasicUnwrapper unwrapper) {
        if (unwrapper != null) {
            if (result2 == null) {
                result2 = new ArrayList<Pair<PsiElement, Unwrapper>>(2);
            }
            result2.add((Pair<PsiElement, Unwrapper>)new Pair((Object)element, (Object)unwrapper));
        }
        return result2;
    }

    public boolean showOptionsDialog() {
        return true;
    }

    public boolean shouldTryToRestoreCaretPosition() {
        return false;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 3: 
            case 4: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 3: 
            case 4: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "editor";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 3: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/javascript/editing/JavaScriptUnwrapDescriptor";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/javascript/editing/JavaScriptUnwrapDescriptor";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "collectUnwrappers";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "collectUnwrappers";
                break;
            }
            case 3: 
            case 4: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 3: 
            case 4: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class JSTryUnwrapper
    extends JSBasicUnwrapper {
        private JSTryUnwrapper() {
        }

        @Override
        protected String getKind(PsiElement e) {
            return "try";
        }

        @Override
        protected TextRange getReplacedRangeStart(PsiElement elt) {
            JSTryStatement loop = (JSTryStatement)elt;
            return new TextRange(loop.getFirstChild().getTextOffset(), loop.getStatement().getFirstChild().getTextRange().getEndOffset());
        }

        @Override
        protected TextRange getReplacedRangeEnd(PsiElement elt) {
            PsiElement child = ((JSTryStatement)elt).getStatement().getLastChild();
            return new TextRange(child.getTextOffset(), elt.getTextRange().getEndOffset());
        }
    }

    private static class JSLoopUnwrapper
    extends JSBasicLoopUnwrapper {
        private JSLoopUnwrapper() {
        }

        @Override
        protected TextRange getReplacedRangeStart(PsiElement elt) {
            JSLoopStatement loop = (JSLoopStatement)elt;
            return new TextRange(loop.getFirstChild().getTextOffset(), loop.getBody().getFirstChild().getTextRange().getEndOffset());
        }

        @Override
        protected TextRange getReplacedRangeEnd(PsiElement elt) {
            return ((JSLoopStatement)elt).getBody().getLastChild().getTextRange();
        }
    }

    private static abstract class JSBasicLoopUnwrapper
    extends JSBasicUnwrapper {
        private JSBasicLoopUnwrapper() {
        }

        @Override
        protected String getKind(PsiElement e) {
            return e instanceof JSWhileStatement ? "while" : (e instanceof JSForStatement ? "for" : (e instanceof JSForInStatement ? "for-in" : "loop"));
        }
    }

    private static class JSElseUnwrapper
    extends JSBasicElseUnwrapper {
        private JSElseUnwrapper() {
        }

        @Override
        protected TextRange getReplacedRangeStart(PsiElement elt) {
            JSIfStatement ifStatement = (JSIfStatement)elt;
            return new TextRange(ifStatement.getFirstChild().getTextOffset(), ifStatement.getElse().getFirstChild().getTextRange().getEndOffset());
        }

        @Override
        protected TextRange getReplacedRangeEnd(PsiElement elt) {
            return ((JSIfStatement)elt).getElse().getLastChild().getTextRange();
        }
    }

    private static class JSIfUnwrapper
    extends JSBasicIfUnwrapper {
        private JSIfUnwrapper() {
        }

        @Override
        protected TextRange getReplacedRangeStart(PsiElement elt) {
            return new TextRange(elt.getTextRange().getStartOffset(), ((JSIfStatement)elt).getThen().getFirstChild().getTextRange().getEndOffset());
        }

        @Override
        protected TextRange getReplacedRangeEnd(PsiElement elt) {
            PsiElement child = ((JSIfStatement)elt).getThen().getLastChild();
            return new TextRange(child.getTextOffset(), elt.getLastChild().getTextRange().getEndOffset());
        }
    }

    private static class JSBlockUnwrapper
    extends JSBasicUnwrapper {
        private JSBlockUnwrapper() {
        }

        @Override
        protected String getKind(PsiElement e) {
            return "block";
        }
    }

    private static abstract class JSBasicUnwrapper
    implements Unwrapper {
        private boolean myBlockWithinSingleOperatorParent;

        private JSBasicUnwrapper() {
        }

        @NotNull
        public String getDescription(@NotNull PsiElement e) {
            if (e == null) {
                JSBasicUnwrapper.$$$reportNull$$$0(0);
            }
            String string = "Unwrap '" + this.getKind(e) + "...'";
            if (string == null) {
                JSBasicUnwrapper.$$$reportNull$$$0(1);
            }
            return string;
        }

        public boolean isApplicableTo(@NotNull PsiElement e) {
            if (e == null) {
                JSBasicUnwrapper.$$$reportNull$$$0(2);
            }
            return true;
        }

        public void collectElementsToIgnore(@NotNull PsiElement element, @NotNull Set<PsiElement> result2) {
            if (element == null) {
                JSBasicUnwrapper.$$$reportNull$$$0(3);
            }
            if (result2 == null) {
                JSBasicUnwrapper.$$$reportNull$$$0(4);
            }
        }

        public PsiElement collectAffectedElements(@NotNull PsiElement e, @NotNull List<PsiElement> toExtract) {
            if (e == null) {
                JSBasicUnwrapper.$$$reportNull$$$0(5);
            }
            if (toExtract == null) {
                JSBasicUnwrapper.$$$reportNull$$$0(6);
            }
            TextRange codeLeftRange = new TextRange(this.getReplacedRangeStart(e).getEndOffset(), this.getReplacedRangeEnd(e).getStartOffset());
            PsiElement l = PsiTreeUtil.firstChild((PsiElement)e);
            while (l != null) {
                if (codeLeftRange.contains(l.getTextRange())) {
                    toExtract.add(l);
                }
                l = PsiTreeUtil.nextLeaf((PsiElement)l);
            }
            return e;
        }

        @NotNull
        public List<PsiElement> unwrap(@NotNull Editor editor, @NotNull PsiElement element) throws IncorrectOperationException {
            TextRange range;
            int rangeMarkerEndOffset;
            RangeMarker rangeMarker;
            if (editor == null) {
                JSBasicUnwrapper.$$$reportNull$$$0(7);
            }
            if (element == null) {
                JSBasicUnwrapper.$$$reportNull$$$0(8);
            }
            TextRange replacedRangeEnd = this.getReplacedRangeEnd(element);
            TextRange replacedRangeStart = this.getReplacedRangeStart(element);
            PsiFile containingFile = element.getContainingFile();
            Project project = containingFile.getProject();
            Document document = editor.getDocument();
            int rangeMarkerStartOffset = CharArrayUtil.shiftForward((CharSequence)document.getCharsSequence(), (int)replacedRangeStart.getEndOffset(), (String)" \t\n");
            RangeMarker rangeMarker2 = rangeMarker = rangeMarkerStartOffset < (rangeMarkerEndOffset = CharArrayUtil.shiftBackward((CharSequence)document.getCharsSequence(), (int)(replacedRangeEnd.getStartOffset() - 1), (String)" \t\n") + 1) ? document.createRangeMarker(rangeMarkerStartOffset, rangeMarkerEndOffset) : document.createRangeMarker(replacedRangeStart.getStartOffset(), replacedRangeStart.getEndOffset());
            if (this.myBlockWithinSingleOperatorParent) {
                replacedRangeEnd = new TextRange(replacedRangeEnd.getStartOffset() + 1, replacedRangeEnd.getEndOffset());
                replacedRangeStart = new TextRange(replacedRangeStart.getStartOffset(), replacedRangeStart.getEndOffset() - 1);
            }
            document.replaceString(replacedRangeEnd.getStartOffset(), replacedRangeEnd.getEndOffset(), (CharSequence)"");
            document.replaceString(replacedRangeStart.getStartOffset(), replacedRangeStart.getEndOffset(), (CharSequence)"");
            PsiDocumentManager.getInstance((Project)project).commitAllDocuments();
            int startOffset = Math.max(0, CharArrayUtil.shiftBackward((CharSequence)document.getCharsSequence(), (int)replacedRangeStart.getStartOffset(), (String)" \t\n"));
            int endOffset = CharArrayUtil.shiftForward((CharSequence)document.getCharsSequence(), (int)replacedRangeEnd.getEndOffset(), (String)" \t\n");
            FormatFixer.doReformat(containingFile, startOffset, endOffset);
            PsiDocumentManager.getInstance((Project)project).commitAllDocuments();
            PsiElement at = rangeMarker.isValid() ? containingFile.findElementAt(rangeMarker.getStartOffset()) : null;
            ArrayList<PsiElement> elements = new ArrayList<PsiElement>();
            TextRange changedRange = TextRange.create((Segment)rangeMarker);
            while (at != null && (range = at.getTextRange()).getStartOffset() <= changedRange.getEndOffset()) {
                if (changedRange.contains(range)) {
                    elements.add(at);
                }
                at = PsiTreeUtil.nextLeaf((PsiElement)at);
            }
            ArrayList<PsiElement> arrayList = elements;
            if (arrayList == null) {
                JSBasicUnwrapper.$$$reportNull$$$0(9);
            }
            return arrayList;
        }

        protected TextRange getReplacedRangeStart(PsiElement elt) {
            return elt.getFirstChild().getTextRange();
        }

        protected TextRange getReplacedRangeEnd(PsiElement elt) {
            return elt.getLastChild().getTextRange();
        }

        protected abstract String getKind(PsiElement var1);

        void setBlockWithinSingleOperatorParent(boolean blockWithinSingleOperatorParent) {
            this.myBlockWithinSingleOperatorParent = blockWithinSingleOperatorParent;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 1: 
                case 9: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 1: 
                case 9: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "e";
                    break;
                }
                case 1: 
                case 9: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/lang/javascript/editing/JavaScriptUnwrapDescriptor$JSBasicUnwrapper";
                    break;
                }
                case 3: 
                case 8: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "element";
                    break;
                }
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "result";
                    break;
                }
                case 6: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "toExtract";
                    break;
                }
                case 7: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "editor";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/lang/javascript/editing/JavaScriptUnwrapDescriptor$JSBasicUnwrapper";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getDescription";
                    break;
                }
                case 9: {
                    objectArray = objectArray2;
                    objectArray2[1] = "unwrap";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "getDescription";
                    break;
                }
                case 1: 
                case 9: {
                    break;
                }
                case 2: {
                    objectArray = objectArray;
                    objectArray[2] = "isApplicableTo";
                    break;
                }
                case 3: 
                case 4: {
                    objectArray = objectArray;
                    objectArray[2] = "collectElementsToIgnore";
                    break;
                }
                case 5: 
                case 6: {
                    objectArray = objectArray;
                    objectArray[2] = "collectAffectedElements";
                    break;
                }
                case 7: 
                case 8: {
                    objectArray = objectArray;
                    objectArray[2] = "unwrap";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 1: 
                case 9: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    private static abstract class JSBasicElseUnwrapper
    extends JSBasicUnwrapper {
        private JSBasicElseUnwrapper() {
        }

        @Override
        protected String getKind(PsiElement e) {
            return "else";
        }
    }

    private static abstract class JSBasicIfUnwrapper
    extends JSBasicUnwrapper {
        private JSBasicIfUnwrapper() {
        }

        @Override
        protected String getKind(PsiElement e) {
            return "if";
        }
    }
}

