/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.flow;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.intellij.lang.javascript.flow.FlowJSServerService;
import com.intellij.lang.javascript.flow.Location;
import com.intellij.lang.javascript.integration.JSAnnotationError;
import com.intellij.lang.javascript.service.JSLanguageServiceAnnotationResult;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.xml.util.XmlUtil;
import java.util.ArrayList;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 9}, bv={1, 0, 2}, k=2, d1={"\u0000P\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\u001a\u001c\u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u00032\n\u0010\u0004\u001a\u00060\u0005j\u0002`\u0006H\u0002\u001a>\u0010\u0007\u001a\u0004\u0018\u00010\b2\u000e\u0010\t\u001a\n\u0018\u00010\u0005j\u0004\u0018\u0001`\u00062\n\u0010\u0004\u001a\u00060\u0005j\u0002`\u00062\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\rH\u0002\u001a\u001c\u0010\u000f\u001a\u0004\u0018\u00010\u00102\b\u0010\u0011\u001a\u0004\u0018\u00010\u00122\u0006\u0010\u0013\u001a\u00020\u000bH\u0002\u001a\u001e\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u00160\u00152\u0006\u0010\u0017\u001a\u00020\u000b2\b\u0010\u0018\u001a\u0004\u0018\u00010\u0019\u001a\u0012\u0010\u001a\u001a\u0004\u0018\u00010\b2\u0006\u0010\n\u001a\u00020\u000bH\u0002\u00a8\u0006\u001b"}, d2={"addChildren", "", "extra", "Lcom/google/gson/JsonArray;", "errorDetails", "Ljava/lang/StringBuilder;", "Lkotlin/text/StringBuilder;", "addMessage", "Lcom/intellij/lang/javascript/flow/Location;", "errorText", "messageObject", "Lcom/google/gson/JsonObject;", "isFirstMessage", "", "severalMessagesInRow", "parseFlowError", "Lcom/intellij/lang/javascript/service/JSLanguageServiceAnnotationResult;", "targetFile", "Lcom/intellij/openapi/vfs/VirtualFile;", "errorObject", "parseFlowErrors", "", "Lcom/intellij/lang/javascript/integration/JSAnnotationError;", "json", "filePath", "", "parseLocation", "intellij.javascript.impl"})
public final class FlowJSErrorsParserKt {
    @NotNull
    public static final List<JSAnnotationError> parseFlowErrors(@NotNull JsonObject json, @Nullable String filePath) {
        JsonElement hasErrors;
        Intrinsics.checkParameterIsNotNull((Object)json, (String)"json");
        ArrayList<JSLanguageServiceAnnotationResult> listOfErrors = new ArrayList<JSLanguageServiceAnnotationResult>();
        VirtualFile targetFile = null;
        if (filePath != null) {
            targetFile = LocalFileSystem.getInstance().findFileByPath(filePath);
        }
        if ((hasErrors = json.get("passed")) != null && !hasErrors.getAsBoolean()) {
            try {
                JsonArray errorArray = json.getAsJsonArray("errors");
                for (JsonElement error : errorArray) {
                    JsonObject errorObject;
                    if (!error.isJsonObject()) continue;
                    JsonObject jsonObject = errorObject = error.getAsJsonObject();
                    Intrinsics.checkExpressionValueIsNotNull((Object)jsonObject, (String)"errorObject");
                    JSLanguageServiceAnnotationResult annotationResult = FlowJSErrorsParserKt.parseFlowError(targetFile, jsonObject);
                    if (annotationResult == null) continue;
                    listOfErrors.add(annotationResult);
                }
            }
            catch (Exception e) {
                FlowJSServerService.LOGGER.debug(e.getMessage(), (Throwable)e);
            }
        }
        return listOfErrors;
    }

    private static final JSLanguageServiceAnnotationResult parseFlowError(VirtualFile targetFile, JsonObject errorObject) {
        VirtualFile virtualFile;
        StringBuilder errorText = new StringBuilder();
        StringBuilder errorDetails = new StringBuilder();
        String errorCategory = errorObject.get("level").getAsString();
        Location mainLocation = null;
        JsonArray messageArray = errorObject.getAsJsonArray("message");
        boolean isFirstMessage = true;
        for (JsonElement message : messageArray) {
            JsonObject messageObject;
            if (isFirstMessage) {
                errorDetails.append("Flow: ");
            }
            JsonObject jsonObject = messageObject = message.getAsJsonObject();
            Intrinsics.checkExpressionValueIsNotNull((Object)jsonObject, (String)"messageObject");
            Location location = FlowJSErrorsParserKt.addMessage(errorText, errorDetails, jsonObject, isFirstMessage, messageArray.size() > 1);
            if (Intrinsics.areEqual((Object)messageObject.get("type").getAsString(), (Object)"Blame") && mainLocation == null && location != null) {
                mainLocation = location;
            }
            isFirstMessage = false;
        }
        if (targetFile != null && mainLocation != null && (virtualFile = LocalFileSystem.getInstance().findFileByPath(mainLocation.getFilePath())) != null && Intrinsics.areEqual((Object)targetFile, (Object)virtualFile) ^ true) {
            return null;
        }
        JsonArray extra = errorObject.getAsJsonArray("extra");
        if (extra != null) {
            errorDetails.append("<br/>");
            FlowJSErrorsParserKt.addChildren(extra, errorDetails);
        }
        Location location = mainLocation;
        Location location2 = mainLocation;
        Location location3 = mainLocation;
        Location location4 = mainLocation;
        Location location5 = mainLocation;
        return new JSLanguageServiceAnnotationResult(errorText.toString(), errorDetails.toString(), location != null ? location.getFilePath() : null, errorCategory, location2 != null ? location2.getLine() : 0, location3 != null ? location3.getColumn() : 0, location4 != null ? location4.getLineEnd() : 0, location5 != null ? location5.getColumnEnd() : 0);
    }

    private static final Location addMessage(StringBuilder errorText, StringBuilder errorDetails, JsonObject messageObject, boolean isFirstMessage, boolean severalMessagesInRow) {
        Location location;
        block6: {
            String descr = messageObject.get("descr").getAsString();
            location = FlowJSErrorsParserKt.parseLocation(messageObject);
            if (!isFirstMessage) {
                errorDetails.append(' ');
                StringBuilder stringBuilder = errorText;
                if (stringBuilder != null) {
                    stringBuilder.append(' ');
                }
            }
            if (location != null) {
                errorDetails.append("<a href='#navigation_logical/").append(location.getFilePath()).append(":").append(location.getLine()).append(":").append(location.getColumn()).append("'>");
            }
            errorDetails.append(XmlUtil.escape((String)descr));
            StringBuilder stringBuilder = errorText;
            if (stringBuilder != null) {
                stringBuilder.append(descr);
            }
            if (location != null) {
                errorDetails.append("</a>");
            }
            if (!isFirstMessage || !severalMessagesInRow) break block6;
            errorDetails.append('.');
            StringBuilder stringBuilder2 = errorText;
            if (stringBuilder2 != null) {
                stringBuilder2.append('.');
            }
        }
        return location;
    }

    private static final void addChildren(JsonArray extra, StringBuilder errorDetails) {
        for (JsonElement element : extra) {
            if (!(element instanceof JsonObject)) continue;
            JsonArray messageArray = ((JsonObject)element).getAsJsonArray("message");
            boolean isFirst = true;
            errorDetails.append("<br/>");
            for (JsonElement message : messageArray) {
                JsonObject jsonObject = message.getAsJsonObject();
                Intrinsics.checkExpressionValueIsNotNull((Object)jsonObject, (String)"message.asJsonObject");
                FlowJSErrorsParserKt.addMessage(null, errorDetails, jsonObject, isFirst, messageArray.size() > 1);
                isFirst = false;
            }
            JsonArray children = ((JsonObject)element).getAsJsonArray("children");
            if (children == null) continue;
            FlowJSErrorsParserKt.addChildren(children, errorDetails);
        }
    }

    private static final Location parseLocation(JsonObject messageObject) {
        try {
            String string = messageObject.get("path").getAsString();
            if (string == null) {
                return null;
            }
            String filePath = string;
            JsonObject loc = messageObject.get("loc").getAsJsonObject();
            JsonObject start = loc.get("start").getAsJsonObject();
            JsonObject end = loc.get("end").getAsJsonObject();
            int line = start.get("line").getAsInt();
            int column = start.get("column").getAsInt();
            int offset = start.get("offset").getAsInt();
            int lineEnd = end.get("line").getAsInt();
            int columnEnd = end.get("column").getAsInt() + 1;
            return new Location(filePath, line, column, lineEnd, columnEnd, offset);
        }
        catch (RuntimeException runtimeException) {
            return null;
        }
    }
}

