/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.flow.psi;

import com.intellij.lang.PsiBuilder;
import com.intellij.lang.ecmascript6.parsing.ES6ExpressionParser;
import com.intellij.lang.ecmascript6.parsing.ES6FunctionParser;
import com.intellij.lang.javascript.JSBundle;
import com.intellij.lang.javascript.JSElementTypes;
import com.intellij.lang.javascript.JSKeywordSets;
import com.intellij.lang.javascript.JSTokenTypes;
import com.intellij.lang.javascript.flow.FlowJSElementTypes;
import com.intellij.lang.javascript.flow.psi.FlowJSParser;
import com.intellij.lang.javascript.flow.psi.FlowJSPsiTypeParser;
import com.intellij.psi.tree.IElementType;

public class FlowJSExpressionParser
extends ES6ExpressionParser<FlowJSParser> {
    public FlowJSExpressionParser(FlowJSParser parser) {
        super(parser);
    }

    @Override
    public boolean parseQualifiedTypeName() {
        if (this.builder.getTokenType() == JSTokenTypes.FUNCTION_KEYWORD) {
            PsiBuilder.Marker marker = this.builder.mark();
            this.builder.advanceLexer();
            return this.parseQualifiedTypeNameTail(marker);
        }
        return super.parseQualifiedTypeName();
    }

    @Override
    public void parseParenthesizedExpression() {
        LOG.assertTrue(this.builder.getTokenType() == JSTokenTypes.LPAR);
        PsiBuilder.Marker expr = this.builder.mark();
        this.builder.advanceLexer();
        if (!this.parseExpressionOptional(true, true)) {
            this.builder.error(JSBundle.message((String)"javascript.parser.message.expected.expression", (Object[])new Object[0]));
        }
        IElementType elementType = JSElementTypes.PARENTHESIZED_EXPRESSION;
        if (this.builder.getTokenType() == JSTokenTypes.COLON) {
            this.builder.advanceLexer();
            ((FlowJSPsiTypeParser)((FlowJSParser)this.myJavaScriptParser).getTypeParser()).parseType();
            elementType = FlowJSElementTypes.TYPE_CAST;
        }
        FlowJSExpressionParser.checkMatches(this.builder, JSTokenTypes.RPAR, "javascript.parser.message.expected.rparen");
        expr.done(elementType);
    }

    @Override
    protected boolean parseUnaryExpression() {
        if (this.builder.getTokenType() == JSTokenTypes.LT && ((ES6FunctionParser)((FlowJSParser)this.myJavaScriptParser).getFunctionParser()).parseArrowFunction()) {
            return true;
        }
        return super.parseUnaryExpression();
    }

    @Override
    protected int getCurrentBinarySignPriority(boolean allowIn, boolean advance) {
        int x = FlowJSExpressionParser.getUncollapsedComparisonOperatorsPriority(advance, this.builder);
        if (x > 0) {
            return x;
        }
        return super.getCurrentBinarySignPriority(allowIn, advance);
    }

    @Override
    protected boolean isFunctionPropertyStart() {
        return JSKeywordSets.PROPERTY_NAMES.contains(this.builder.getTokenType()) && this.builder.lookAhead(1) == JSTokenTypes.LT || super.isFunctionPropertyStart();
    }
}

