/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.frameworks.react;

import com.intellij.lang.javascript.frameworks.react.ReactAttributeDescriptor;
import com.intellij.lang.javascript.psi.JSRecordType;
import com.intellij.lang.javascript.psi.JSType;
import com.intellij.lang.javascript.psi.JSTypeUtils;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptPropertySignature;
import com.intellij.lang.javascript.psi.stubs.JSImplicitElement;
import com.intellij.lang.javascript.psi.types.JSStringLiteralTypeImpl;
import com.intellij.lang.javascript.psi.types.primitives.JSBooleanType;
import com.intellij.psi.PsiElement;
import com.intellij.psi.impl.source.html.dtd.HtmlAttributeDescriptorImpl;
import com.intellij.psi.meta.PsiPresentableMetaData;
import com.intellij.psi.xml.XmlElement;
import com.intellij.util.ArrayUtil;
import com.intellij.util.Processor;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.xml.XmlAttributeDescriptor;
import com.intellij.xml.impl.BasicXmlAttributeDescriptor;
import icons.JavaScriptLanguageIcons;
import java.util.ArrayList;
import java.util.Collection;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ReactAttributeDescriptorImpl
extends BasicXmlAttributeDescriptor {
    private final String myAttributeName;
    @Nullable
    private final PsiElement myDeclaration;
    private boolean myForceOptional;

    private ReactAttributeDescriptorImpl(String attributeName, @Nullable PsiElement declaration, boolean forceOptional) {
        this.myAttributeName = attributeName;
        this.myDeclaration = declaration;
        this.myForceOptional = forceOptional;
    }

    @NotNull
    public static XmlAttributeDescriptor create(String name, PsiElement declaration, boolean forceOptional) {
        ReactHtmlAttributeDescriptorImpl reactHtmlAttributeDescriptorImpl = new ReactHtmlAttributeDescriptorImpl(name, declaration, forceOptional);
        if (reactHtmlAttributeDescriptorImpl == null) {
            ReactAttributeDescriptorImpl.$$$reportNull$$$0(0);
        }
        return reactHtmlAttributeDescriptorImpl;
    }

    public boolean isRequired() {
        if (this.myForceOptional) {
            return false;
        }
        PsiElement declaration = this.getDeclaration();
        if (declaration instanceof JSImplicitElement) {
            return "r".equals(((JSImplicitElement)declaration).getUserString());
        }
        if (declaration instanceof JSRecordType.PropertySignature) {
            return !((JSRecordType.PropertySignature)declaration).isOptional();
        }
        return false;
    }

    public boolean hasIdType() {
        return false;
    }

    public boolean hasIdRefType() {
        return false;
    }

    public boolean isEnumerated() {
        String[] values = this.getEnumeratedValues();
        return values != null && values.length > 0;
    }

    protected PsiElement getEnumeratedValueDeclaration(XmlElement xmlElement, String value) {
        return xmlElement;
    }

    @Nullable
    public PsiElement getDeclaration() {
        return this.myDeclaration;
    }

    public String getName() {
        return this.myAttributeName;
    }

    public void init(PsiElement element) {
    }

    @NotNull
    public Object[] getDependences() {
        if (ArrayUtil.EMPTY_OBJECT_ARRAY == null) {
            ReactAttributeDescriptorImpl.$$$reportNull$$$0(1);
        }
        return ArrayUtil.EMPTY_OBJECT_ARRAY;
    }

    public boolean isFixed() {
        return false;
    }

    public String getDefaultValue() {
        return null;
    }

    public String[] getEnumeratedValues() {
        PsiElement declaration = this.getDeclaration();
        if (declaration instanceof JSImplicitElement && "Boolean".equals(((JSImplicitElement)declaration).getTypeString())) {
            return new String[]{this.myAttributeName};
        }
        if (declaration instanceof TypeScriptPropertySignature) {
            JSType type = ((TypeScriptPropertySignature)declaration).getType();
            if (type instanceof JSBooleanType) {
                return new String[]{this.myAttributeName};
            }
            ArrayList results = ContainerUtil.newArrayList();
            JSTypeUtils.processExpandedType((Processor<JSType>)((Processor)t -> {
                if (t instanceof JSStringLiteralTypeImpl) {
                    results.add(((JSStringLiteralTypeImpl)t).getLiteral());
                }
                return true;
            }), type, false, true, true);
            if (results.size() > 0) {
                return ArrayUtil.toStringArray((Collection)results);
            }
        }
        return ArrayUtil.EMPTY_STRING_ARRAY;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[2];
        objectArray2[0] = "com/intellij/lang/javascript/frameworks/react/ReactAttributeDescriptorImpl";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "create";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getDependences";
                break;
            }
        }
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
    }

    private static class ReactHtmlAttributeDescriptorImpl
    extends HtmlAttributeDescriptorImpl
    implements ReactAttributeDescriptor,
    PsiPresentableMetaData {
        public ReactHtmlAttributeDescriptorImpl(String name, PsiElement declaration, boolean forceOptional) {
            super((XmlAttributeDescriptor)new ReactAttributeDescriptorImpl(name, declaration, forceOptional), true);
        }

        public String getTypeName() {
            return null;
        }

        @Nullable
        public Icon getIcon() {
            return JavaScriptLanguageIcons.Logos.Jsx_16;
        }
    }
}

