/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.highlighting;

import com.intellij.codeInsight.daemon.DaemonCodeAnalyzerSettings;
import com.intellij.codeInsight.daemon.GutterIconNavigationHandler;
import com.intellij.codeInsight.daemon.LineMarkerInfo;
import com.intellij.codeInsight.daemon.LineMarkerProvider;
import com.intellij.codeInsight.daemon.impl.LineMarkersPass;
import com.intellij.codeInsight.daemon.impl.PsiElementListNavigator;
import com.intellij.icons.AllIcons;
import com.intellij.lang.ASTNode;
import com.intellij.lang.Language;
import com.intellij.lang.javascript.DialectDetector;
import com.intellij.lang.javascript.JSBundle;
import com.intellij.lang.javascript.JSDocTokenTypes;
import com.intellij.lang.javascript.JavaScriptSupportLoader;
import com.intellij.lang.javascript.index.JSSymbolUtil;
import com.intellij.lang.javascript.navigation.JavaScriptGotoSuperHandler;
import com.intellij.lang.javascript.psi.JSAssignmentExpression;
import com.intellij.lang.javascript.psi.JSBlockStatement;
import com.intellij.lang.javascript.psi.JSCallExpression;
import com.intellij.lang.javascript.psi.JSDefinitionExpression;
import com.intellij.lang.javascript.psi.JSElement;
import com.intellij.lang.javascript.psi.JSEmbeddedContent;
import com.intellij.lang.javascript.psi.JSExpression;
import com.intellij.lang.javascript.psi.JSExpressionStatement;
import com.intellij.lang.javascript.psi.JSField;
import com.intellij.lang.javascript.psi.JSFile;
import com.intellij.lang.javascript.psi.JSFunction;
import com.intellij.lang.javascript.psi.JSFunctionExpression;
import com.intellij.lang.javascript.psi.JSNamedElement;
import com.intellij.lang.javascript.psi.JSProperty;
import com.intellij.lang.javascript.psi.JSPsiElementBase;
import com.intellij.lang.javascript.psi.JSPsiNamedElementBase;
import com.intellij.lang.javascript.psi.JSReferenceExpression;
import com.intellij.lang.javascript.psi.JSVarStatement;
import com.intellij.lang.javascript.psi.JSVariable;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptFunction;
import com.intellij.lang.javascript.psi.ecmal4.JSAttributeList;
import com.intellij.lang.javascript.psi.ecmal4.JSAttributeListOwner;
import com.intellij.lang.javascript.psi.ecmal4.JSClass;
import com.intellij.lang.javascript.psi.ecmal4.JSQualifiedNamedElement;
import com.intellij.lang.javascript.psi.ecmal4.XmlBackedJSClass;
import com.intellij.lang.javascript.psi.ecmal4.XmlBackedJSClassFactory;
import com.intellij.lang.javascript.psi.impl.JSPsiImplUtils;
import com.intellij.lang.javascript.psi.resolve.JSInheritanceUtil;
import com.intellij.lang.javascript.psi.resolve.JSResolveUtil;
import com.intellij.lang.javascript.psi.util.JSClassUtils;
import com.intellij.lang.javascript.psi.util.JSUtils;
import com.intellij.lang.javascript.search.JSClassSearch;
import com.intellij.lang.javascript.search.JSDefinitionsSearchExecutor;
import com.intellij.lang.javascript.search.JSGotoTargetRendererProvider;
import com.intellij.lang.javascript.search.JSMembersSearch;
import com.intellij.lang.javascript.ui.JSFormatUtil;
import com.intellij.lang.javascript.validation.JSAnnotatingVisitor;
import com.intellij.lang.xml.XMLLanguage;
import com.intellij.navigation.NavigationItem;
import com.intellij.openapi.editor.colors.CodeInsightColors;
import com.intellij.openapi.editor.colors.EditorColorsManager;
import com.intellij.openapi.editor.colors.EditorColorsScheme;
import com.intellij.openapi.editor.markup.GutterIconRenderer;
import com.intellij.openapi.editor.markup.SeparatorPlacement;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.NavigatablePsiElement;
import com.intellij.psi.PsiComment;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiNameIdentifierOwner;
import com.intellij.psi.PsiWhiteSpace;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.xml.XmlDocument;
import com.intellij.psi.xml.XmlTag;
import com.intellij.util.CollectionQuery;
import com.intellij.util.ConstantFunction;
import com.intellij.util.EmptyQuery;
import com.intellij.util.Function;
import com.intellij.util.FunctionUtil;
import com.intellij.util.MergeQuery;
import com.intellij.util.Processor;
import com.intellij.util.Query;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.xml.util.XmlTagUtil;
import gnu.trove.THashMap;
import gnu.trove.THashSet;
import java.awt.event.MouseEvent;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.swing.Icon;
import javax.swing.ListCellRenderer;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JavaScriptLineMarkerProvider
implements LineMarkerProvider {
    private final DaemonCodeAnalyzerSettings myDaemonSettings;
    private final EditorColorsManager myColorsManager;
    public static final Function<PsiElement, String> ourClassInheritorsTooltipProvider = new ConstantFunction((Object)"Has subclasses");
    private static final Function<PsiElement, String> ourImplementedInterfacesTooltipProvider = new ConstantFunction((Object)"Has implementations");
    private static final Function<PsiElement, String> ourOverriddenFunctionsTooltipProvider = new ConstantFunction((Object)"Is overridden");
    private static final Function<PsiElement, String> ourOverriddenFunctionsTooltipProvider2 = new ConstantFunction((Object)"Has subtypes");
    private static final Function<PsiElement, String> ourImplementingFunctionsTooltipProvider = new ConstantFunction((Object)"Is implemented");
    public static final BasicGutterIconNavigationHandler<JSClass> ourClassInheritorsNavHandler = new BasicGutterIconNavigationHandler<JSClass>(){

        @Override
        protected String getTitle(JSClass elt, int size) {
            String name = JSFormatUtil.formatClass(elt, 1);
            return JSBundle.message((String)"choose.subclass", (Object[])new Object[]{name, size});
        }

        @Override
        public Query<JSClass> search(JSClass elt) {
            return JSClassSearch.searchClassInheritors(elt, true);
        }
    };
    public static final BasicGutterIconNavigationHandler<JSClass> ourInterfaceImplementationsNavHandler = new BasicGutterIconNavigationHandler<JSClass>(){

        @Override
        protected String getTitle(JSClass elt, int size) {
            String name = JSFormatUtil.formatClass(elt, 1);
            return JSBundle.message((String)"choose.implementing.class", (Object[])new Object[]{name, size});
        }

        @Override
        public Query<JSClass> search(JSClass elt) {
            return JSDefinitionsSearchExecutor.query((PsiElement)elt, JSClass.class);
        }
    };
    private static final BasicGutterIconNavigationHandler<JSPsiElementBase> ourOverriddenMembersNavHandler = new BasicGutterIconNavigationHandler<JSPsiElementBase>(){

        @Override
        protected String getTitle(JSPsiElementBase elt, int size) {
            if (elt instanceof JSFunction) {
                String name = JSFormatUtil.formatMember(elt, 1);
                return JSBundle.message((String)(JavaScriptLineMarkerProvider.isClassMember(elt) ? "choose.overridden.method" : "choose.overridden.function"), (Object[])new Object[]{name, size});
            }
            return JSBundle.message((String)"choose.overridden.function", (Object[])new Object[]{elt.getName(), size});
        }

        @Override
        public Query<JSPsiElementBase> search(JSPsiElementBase elt) {
            return JSDefinitionsSearchExecutor.query((PsiElement)elt, JSPsiElementBase.class);
        }
    };
    private static final BasicGutterIconNavigationHandler<JSPsiElementBase> ourImplementingMembersNavHandler = new BasicGutterIconNavigationHandler<JSPsiElementBase>(){

        @Override
        protected String getTitle(JSPsiElementBase elt, int size) {
            String name = JSFormatUtil.formatMember(elt, 1);
            return JSBundle.message((String)"choose.implementing.method", (Object[])new Object[]{name, size});
        }

        @Override
        public Query<JSPsiElementBase> search(JSPsiElementBase elt) {
            return JSDefinitionsSearchExecutor.query((PsiElement)elt, JSPsiElementBase.class);
        }
    };

    public JavaScriptLineMarkerProvider(DaemonCodeAnalyzerSettings daemonSettings, EditorColorsManager colorsManager) {
        this.myDaemonSettings = daemonSettings;
        this.myColorsManager = colorsManager;
    }

    private static boolean isClassMember(@Nullable JSPsiElementBase elt) {
        return JSUtils.getMemberContainingClass((PsiElement)elt) != null;
    }

    private static PsiElement findPrev(PsiElement element, Class ... classes) {
        PsiElement startFrom = element.getFirstChild();
        PsiElement prev = element.getPrevSibling();
        if (prev instanceof PsiWhiteSpace) {
            prev = prev.getPrevSibling();
        }
        if (prev instanceof PsiComment) {
            startFrom = prev;
        }
        if (startFrom != null) {
            PsiElement cur = element.getPrevSibling();
            while (cur != null) {
                cur = cur.getPrevSibling();
                for (Class cls : classes) {
                    if (!cls.isInstance(cur)) continue;
                    return cur;
                }
            }
        }
        return null;
    }

    @NotNull
    private static LineMarkerInfo createBottomMethodSeparatorLineMarker(@NotNull PsiElement startFrom, @NotNull EditorColorsManager colorsManager) {
        if (startFrom == null) {
            JavaScriptLineMarkerProvider.$$$reportNull$$$0(0);
        }
        if (colorsManager == null) {
            JavaScriptLineMarkerProvider.$$$reportNull$$$0(1);
        }
        LineMarkerInfo info = new LineMarkerInfo(startFrom, startFrom.getTextRange(), null, 11, (Function)FunctionUtil.nullConstant(), null, GutterIconRenderer.Alignment.RIGHT);
        EditorColorsScheme scheme = colorsManager.getGlobalScheme();
        info.separatorColor = scheme.getColor(CodeInsightColors.METHOD_SEPARATORS_COLOR);
        info.separatorPlacement = SeparatorPlacement.BOTTOM;
        LineMarkerInfo lineMarkerInfo = info;
        if (lineMarkerInfo == null) {
            JavaScriptLineMarkerProvider.$$$reportNull$$$0(2);
        }
        return lineMarkerInfo;
    }

    public LineMarkerInfo getLineMarkerInfo(@NotNull PsiElement element) {
        VirtualFile file;
        if (element == null) {
            JavaScriptLineMarkerProvider.$$$reportNull$$$0(3);
        }
        if ((file = element.getContainingFile().getVirtualFile()) != null && file.getFileType().isBinary()) {
            return null;
        }
        LineMarkerInfo elementParent = this.createSeparatorMarker(element);
        if (elementParent != null) {
            return elementParent;
        }
        JSPsiElementBase namedElement = JavaScriptLineMarkerProvider.getElementFromLineMarker(element, false);
        if (JSClassUtils.isPossibleHierarchyMember((PsiElement)namedElement) && JavaScriptLineMarkerProvider.getPlaceForLineMarker(namedElement) == element) {
            if (namedElement.getName() == null) {
                return null;
            }
            Ref className = new Ref();
            Ref isInterface = Ref.create((Object)Boolean.FALSE);
            JSInheritanceUtil.iterateOverriddenMembersUp(namedElement, true, (possibleOverriddenMember, s) -> {
                isInterface.set((Object)(s != null && JSSymbolUtil.isInterface(s, (PsiElement)namedElement) ? 1 : 0));
                className.set(s);
                return false;
            }, namedElement instanceof JSFunction);
            if (!className.isNull()) {
                String tooltip = JSBundle.message((String)((Boolean)isInterface.get() != false ? "linemarker.implements.method.in" : "linemarker.overrides.method.in"), (Object[])new Object[]{className.get()});
                return JavaScriptLineMarkerProvider.createOverridingOrImplementingMarker(namedElement, (Ref<Boolean>)isInterface, tooltip);
            }
        }
        return null;
    }

    @Nullable
    private LineMarkerInfo createSeparatorMarker(@NotNull PsiElement element) {
        if (element == null) {
            JavaScriptLineMarkerProvider.$$$reportNull$$$0(4);
        }
        if (this.myDaemonSettings.SHOW_METHOD_SEPARATORS) {
            PsiElement parent;
            if (element instanceof JSProperty) {
                PsiElement prev = JavaScriptLineMarkerProvider.findPrev(element, JSProperty.class);
                if (JavaScriptLineMarkerProvider.propertyContainsFunction((JSProperty)element) || prev instanceof JSProperty && JavaScriptLineMarkerProvider.propertyContainsFunction((JSProperty)prev)) {
                    return LineMarkersPass.createMethodSeparatorLineMarker((PsiElement)JavaScriptLineMarkerProvider.findElementToStartMethodSeparator(element), (EditorColorsManager)this.myColorsManager);
                }
            }
            if (element instanceof JSFunction && !(element instanceof JSFunctionExpression)) {
                PsiElement prev;
                parent = JSResolveUtil.findParent(element);
                if (!(!JavaScriptLineMarkerProvider.isContainer(parent) || (prev = JavaScriptLineMarkerProvider.findPrev(element, JSNamedElement.class, JSVarStatement.class)) == null || prev instanceof TypeScriptFunction && ((TypeScriptFunction)prev).isOverloadDeclaration())) {
                    return LineMarkersPass.createMethodSeparatorLineMarker((PsiElement)JavaScriptLineMarkerProvider.findElementToStartMethodSeparator(element), (EditorColorsManager)this.myColorsManager);
                }
            } else if (element instanceof JSAssignmentExpression) {
                JSAssignmentExpression assignmentExpression = (JSAssignmentExpression)element;
                PsiElement elementParent = element.getParent();
                PsiElement prev = JavaScriptLineMarkerProvider.findPrev(elementParent, JSExpressionStatement.class);
                if (prev instanceof JSExpressionStatement) {
                    JSExpression rOperand = assignmentExpression.getROperand();
                    JSExpression prevExpression = ((JSExpressionStatement)prev).getExpression();
                    if (JavaScriptLineMarkerProvider.isNonArrowFunctionExpression(rOperand) || prevExpression instanceof JSAssignmentExpression && JavaScriptLineMarkerProvider.isNonArrowFunctionExpression(((JSAssignmentExpression)prevExpression).getROperand())) {
                        return LineMarkersPass.createMethodSeparatorLineMarker((PsiElement)JavaScriptLineMarkerProvider.findElementToStartMethodSeparator(elementParent), (EditorColorsManager)this.myColorsManager);
                    }
                }
            } else if (element instanceof JSVariable) {
                PsiElement identifier;
                JSExpression initializer = ((JSVariable)element).getInitializer();
                if (JavaScriptLineMarkerProvider.isNonArrowFunctionExpression(initializer) && (identifier = ((JSVariable)element).getNameIdentifier()) != null) {
                    return LineMarkersPass.createMethodSeparatorLineMarker((PsiElement)JavaScriptLineMarkerProvider.findElementToStartMethodSeparator(identifier), (EditorColorsManager)this.myColorsManager);
                }
            } else if ((element instanceof JSFunctionExpression || element instanceof JSBlockStatement) && (parent = element.getParent()) instanceof JSProperty && PsiTreeUtil.getNextSiblingOfType((PsiElement)parent, JSProperty.class) == null) {
                return JavaScriptLineMarkerProvider.createBottomMethodSeparatorLineMarker(element.getFirstChild(), this.myColorsManager);
            }
        }
        return null;
    }

    private static boolean propertyContainsFunction(@NotNull JSProperty element) {
        if (element == null) {
            JavaScriptLineMarkerProvider.$$$reportNull$$$0(5);
        }
        return element instanceof JSFunction || element.tryGetFunctionInitializer() != null;
    }

    private static boolean isNonArrowFunctionExpression(@Nullable JSExpression expression) {
        return expression instanceof JSFunctionExpression && !JSPsiImplUtils.isArrowFunction((JSFunction)((JSFunctionExpression)expression));
    }

    private static LineMarkerInfo<PsiElement> createOverridingOrImplementingMarker(final JSPsiElementBase member, Ref<Boolean> isInterface, String tooltip) {
        return JavaScriptLineMarkerProvider.createLineMarkerInfo(member, (Boolean)isInterface.get() != false ? AllIcons.Gutter.ImplementingMethod : AllIcons.Gutter.OverridingMethod, (Function<? super PsiElement, String>)new ParameterizedFunction<String>(tooltip){

            public String fun(PsiElement element) {
                return (String)this.myParam;
            }
        }, new BasicGutterIconNavigationHandler<JSPsiElementBase>(){

            @Override
            protected String getTitle(JSPsiElementBase elt, int size) {
                String name = JSFormatUtil.formatMember(elt, 1);
                return JSBundle.message((String)(JavaScriptLineMarkerProvider.isClassMember(elt) ? "choose.super.method" : "choose.super.function"), (Object[])new Object[]{name, size});
            }

            @Override
            @Nullable
            public Query<JSPsiElementBase> search(JSPsiElementBase elt) {
                if (!member.isValid()) {
                    return EmptyQuery.getEmptyQuery();
                }
                THashSet results = new THashSet();
                JSInheritanceUtil.iterateOverriddenMembersUp(member, true, (arg_0, arg_1) -> 6.lambda$search$0((Collection)results, arg_0, arg_1), elt instanceof JSFunction);
                return new CollectionQuery((Collection)results);
            }

            private static /* synthetic */ Boolean lambda$search$0(Collection results, List functions, String s) {
                results.addAll(functions);
                return true;
            }
        }, 11);
    }

    private static boolean isContainer(PsiElement parent) {
        return parent instanceof JSClass || parent instanceof JSBlockStatement && parent.getParent() instanceof JSFunction || parent instanceof JSFile || parent instanceof JSEmbeddedContent;
    }

    private static PsiElement findElementToStartMethodSeparator(@NotNull PsiElement parent) {
        PsiElement deepestFirst;
        ASTNode commentNode;
        if (parent == null) {
            JavaScriptLineMarkerProvider.$$$reportNull$$$0(6);
        }
        if ((commentNode = (deepestFirst = PsiTreeUtil.getDeepestFirst((PsiElement)parent)).getNode()) != null && commentNode.getElementType() == JSDocTokenTypes.DOC_COMMENT_START) {
            return deepestFirst;
        }
        PsiElement leaf = PsiTreeUtil.prevLeaf((PsiElement)deepestFirst);
        PsiElement comment = null;
        while (!(!(leaf instanceof PsiWhiteSpace) && !(leaf instanceof PsiComment) || leaf instanceof PsiComment && (commentNode = (comment = leaf).getNode()) != null && commentNode.getElementType() == JSDocTokenTypes.DOC_COMMENT_START)) {
            leaf = PsiTreeUtil.prevLeaf((PsiElement)leaf);
        }
        if (comment != null) {
            return comment;
        }
        return deepestFirst;
    }

    public void collectSlowLineMarkers(@NotNull List<PsiElement> elements, @NotNull Collection<LineMarkerInfo> result2) {
        if (elements == null) {
            JavaScriptLineMarkerProvider.$$$reportNull$$$0(7);
        }
        if (result2 == null) {
            JavaScriptLineMarkerProvider.$$$reportNull$$$0(8);
        }
        THashMap jsFunctionsToProcess = new THashMap();
        THashMap classMembersToProcess = new THashMap();
        JavaScriptLineMarkerProvider.fillElementsToCheckMarkers(elements, (Map<String, Set<JSPsiElementBase>>)jsFunctionsToProcess, (Map<JSClass, Set<JSQualifiedNamedElement>>)classMembersToProcess);
        JavaScriptLineMarkerProvider.addFunctionMarkers(elements, (Map<String, Set<JSPsiElementBase>>)jsFunctionsToProcess, result2);
        JavaScriptLineMarkerProvider.addMemberMarkers((Map<JSClass, Set<JSQualifiedNamedElement>>)classMembersToProcess, result2);
    }

    private static void addMemberMarkers(@NotNull Map<JSClass, Set<JSQualifiedNamedElement>> jsMembersToProcess, @NotNull Collection<LineMarkerInfo> result2) {
        if (jsMembersToProcess == null) {
            JavaScriptLineMarkerProvider.$$$reportNull$$$0(9);
        }
        if (result2 == null) {
            JavaScriptLineMarkerProvider.$$$reportNull$$$0(10);
        }
        for (Map.Entry<JSClass, Set<JSQualifiedNamedElement>> entry : jsMembersToProcess.entrySet()) {
            ProgressManager.checkCanceled();
            JSClass clazz = entry.getKey();
            Set<JSQualifiedNamedElement> members = entry.getValue();
            JavaScriptLineMarkerProvider.addLineMarkersForClass(clazz, members, result2);
        }
    }

    private static void addLineMarkersForClass(final @NotNull JSClass clazz, final @Nullable Set<JSQualifiedNamedElement> members, final @NotNull Collection<LineMarkerInfo> result2) {
        Object inheritorsAndImplementationsClassQuery;
        boolean classCanBeImplemented;
        if (clazz == null) {
            JavaScriptLineMarkerProvider.$$$reportNull$$$0(11);
        }
        if (result2 == null) {
            JavaScriptLineMarkerProvider.$$$reportNull$$$0(12);
        }
        Query<JSClass> inheritorsClassQuery = JSClassSearch.searchClassInheritors(clazz, members != null);
        final boolean isInterface = clazz.isInterface();
        inheritorsClassQuery.forEach((Processor)new Processor<JSClass>(){
            private boolean addedClassMarker;
            private final Set<JSQualifiedNamedElement> membersClone;
            {
                this.membersClone = members == null || clazz.isInterface() ? null : new THashSet((Collection)members);
            }

            public boolean process(JSClass jsClassInheritor) {
                if (!(clazz instanceof XmlBackedJSClass || isInterface || this.addedClassMarker)) {
                    result2.add(JavaScriptLineMarkerProvider.createClassHasInheritorsMarker(clazz));
                    this.addedClassMarker = true;
                }
                if (this.membersClone != null) {
                    Iterator<JSQualifiedNamedElement> membersIterator = this.membersClone.iterator();
                    while (membersIterator.hasNext()) {
                        JSQualifiedNamedElement member = membersIterator.next();
                        JSField possibleOverrideMember = null;
                        if (member instanceof JSFunction) {
                            JSFunction function = (JSFunction)member;
                            possibleOverrideMember = jsClassInheritor.findFunctionByNameAndKind(function.getName(), function.getKind());
                        } else if (member instanceof JSField) {
                            possibleOverrideMember = jsClassInheritor.findFieldByName(member.getName());
                        }
                        if (!JavaScriptLineMarkerProvider.isOverrideMember(possibleOverrideMember, (JSAttributeListOwner)member)) continue;
                        result2.add(JavaScriptLineMarkerProvider.createOverriddenMemberMarker(member));
                        membersIterator.remove();
                    }
                }
                return this.membersClone != null && !this.membersClone.isEmpty();
            }
        });
        boolean bl = classCanBeImplemented = isInterface || DialectDetector.isTypeScript((PsiElement)clazz);
        if (classCanBeImplemented && (inheritorsAndImplementationsClassQuery = JavaScriptLineMarkerProvider.createSearchImplementationsQuery(clazz, false)).findFirst() != null) {
            result2.add(JavaScriptLineMarkerProvider.createClassHasImplementationsMarker(clazz));
        }
        if (members == null) {
            return;
        }
        ProgressManager.checkCanceled();
        for (JSQualifiedNamedElement member : members) {
            Collection<JSPsiElementBase> implementedMembers;
            Query<JSPsiElementBase> query;
            if (classCanBeImplemented && (query = JavaScriptLineMarkerProvider.createSearchImplementedMemberQuery(isInterface, (JSPsiElementBase)member)).findFirst() != null) {
                result2.add(JavaScriptLineMarkerProvider.createImplementedMemberMarker(member));
            }
            if (isInterface) continue;
            ProgressManager.checkCanceled();
            if (member instanceof JSFunction && JavaScriptLineMarkerProvider.hasOverrideModifier((JSFunction)member) || (implementedMembers = JSInheritanceUtil.findImplementedMembers(member)).isEmpty()) continue;
            result2.add(JavaScriptLineMarkerProvider.createImplementingMemberMarker((JSPsiElementBase)member, implementedMembers));
        }
        String classQName = clazz.getQualifiedName();
        if (DialectDetector.isJavaScript((PsiElement)clazz) && !StringUtil.isEmpty((String)classQName) && JSSymbolUtil.isInterface(classQName, (PsiElement)clazz)) {
            JavaScriptLineMarkerProvider.addLineMarkersForJSDocInterface(clazz, members, result2);
        }
    }

    private static void addLineMarkersForJSDocInterface(@NotNull JSClass clazz, @NotNull Set<JSQualifiedNamedElement> members, @NotNull Collection<LineMarkerInfo> result2) {
        if (clazz == null) {
            JavaScriptLineMarkerProvider.$$$reportNull$$$0(13);
        }
        if (members == null) {
            JavaScriptLineMarkerProvider.$$$reportNull$$$0(14);
        }
        if (result2 == null) {
            JavaScriptLineMarkerProvider.$$$reportNull$$$0(15);
        }
        ProgressManager.checkCanceled();
        JSPsiElementBase implementation = (JSPsiElementBase)JSResolveUtil.findOverridingFunctionsByNamespaces((JSPsiElementBase)clazz).findFirst();
        if (implementation != null) {
            result2.add(JavaScriptLineMarkerProvider.createClassHasImplementationsMarker(clazz));
        }
        for (JSQualifiedNamedElement member : members) {
            ProgressManager.checkCanceled();
            JSPsiElementBase implementingMethod = (JSPsiElementBase)JSResolveUtil.findOverridingFunctionsByNamespaces((JSPsiElementBase)member).findFirst();
            if (implementingMethod == null) continue;
            result2.add(JavaScriptLineMarkerProvider.createImplementedMemberMarker(member));
        }
    }

    @NotNull
    private static Query<JSPsiElementBase> createSearchImplementedMemberQuery(boolean isInterface, JSPsiElementBase member) {
        MergeQuery query = JSMembersSearch.searchImplementingMembers(member, false);
        if (isInterface) {
            query = new MergeQuery(query, JSMembersSearch.searchOverridingMembers(member, false));
        }
        MergeQuery mergeQuery = query;
        if (mergeQuery == null) {
            JavaScriptLineMarkerProvider.$$$reportNull$$$0(16);
        }
        return mergeQuery;
    }

    private static boolean isOverrideMember(JSAttributeListOwner possibleOverrideMember, JSAttributeListOwner member) {
        return possibleOverrideMember != null && JSInheritanceUtil.canHaveSuperMember(possibleOverrideMember) && JSInheritanceUtil.isRealOverride(possibleOverrideMember, JSResolveUtil.getNamespaceValue(member.getAttributeList()), (PsiElement)member);
    }

    @NotNull
    private static Query<JSClass> createSearchImplementationsQuery(@NotNull JSClass clazz, boolean deep) {
        if (clazz == null) {
            JavaScriptLineMarkerProvider.$$$reportNull$$$0(17);
        }
        if (!clazz.isInterface()) {
            Query<JSClass> query = JSClassSearch.searchInterfaceImplementations(clazz, deep);
            if (query == null) {
                JavaScriptLineMarkerProvider.$$$reportNull$$$0(18);
            }
            return query;
        }
        MergeQuery mergeQuery = new MergeQuery(JSClassSearch.searchInterfaceImplementations(clazz, deep), JSClassSearch.searchClassInheritors(clazz, deep));
        if (mergeQuery == null) {
            JavaScriptLineMarkerProvider.$$$reportNull$$$0(19);
        }
        return mergeQuery;
    }

    private static boolean hasOverrideModifier(@NotNull JSFunction function) {
        JSAttributeList attributeList;
        if (function == null) {
            JavaScriptLineMarkerProvider.$$$reportNull$$$0(20);
        }
        return (attributeList = function.getAttributeList()) != null && attributeList.hasModifier(JSAttributeList.ModifierType.OVERRIDE);
    }

    @NotNull
    private static LineMarkerInfo<PsiElement> createClassHasInheritorsMarker(@NotNull JSClass clazz) {
        if (clazz == null) {
            JavaScriptLineMarkerProvider.$$$reportNull$$$0(21);
        }
        LineMarkerInfo<PsiElement> lineMarkerInfo = JavaScriptLineMarkerProvider.createLineMarkerInfo((JSPsiElementBase)clazz, AllIcons.Gutter.OverridenMethod, ourClassInheritorsTooltipProvider, ourClassInheritorsNavHandler);
        if (lineMarkerInfo == null) {
            JavaScriptLineMarkerProvider.$$$reportNull$$$0(22);
        }
        return lineMarkerInfo;
    }

    @NotNull
    private static LineMarkerInfo<PsiElement> createClassHasImplementationsMarker(@NotNull JSClass clazz) {
        if (clazz == null) {
            JavaScriptLineMarkerProvider.$$$reportNull$$$0(23);
        }
        LineMarkerInfo<PsiElement> lineMarkerInfo = JavaScriptLineMarkerProvider.createLineMarkerInfo((JSPsiElementBase)clazz, AllIcons.Gutter.ImplementedMethod, ourImplementedInterfacesTooltipProvider, ourInterfaceImplementationsNavHandler);
        if (lineMarkerInfo == null) {
            JavaScriptLineMarkerProvider.$$$reportNull$$$0(24);
        }
        return lineMarkerInfo;
    }

    @NotNull
    private static LineMarkerInfo<PsiElement> createOverriddenMemberMarker(@NotNull JSQualifiedNamedElement member) {
        if (member == null) {
            JavaScriptLineMarkerProvider.$$$reportNull$$$0(25);
        }
        LineMarkerInfo<PsiElement> lineMarkerInfo = JavaScriptLineMarkerProvider.createLineMarkerInfo((JSPsiElementBase)member, AllIcons.Gutter.OverridenMethod, ourOverriddenFunctionsTooltipProvider, ourOverriddenMembersNavHandler);
        if (lineMarkerInfo == null) {
            JavaScriptLineMarkerProvider.$$$reportNull$$$0(26);
        }
        return lineMarkerInfo;
    }

    @NotNull
    private static LineMarkerInfo<PsiElement> createImplementedMemberMarker(@NotNull JSQualifiedNamedElement member) {
        if (member == null) {
            JavaScriptLineMarkerProvider.$$$reportNull$$$0(27);
        }
        LineMarkerInfo<PsiElement> lineMarkerInfo = JavaScriptLineMarkerProvider.createLineMarkerInfo((JSPsiElementBase)member, AllIcons.Gutter.ImplementedMethod, ourImplementingFunctionsTooltipProvider, ourImplementingMembersNavHandler);
        if (lineMarkerInfo == null) {
            JavaScriptLineMarkerProvider.$$$reportNull$$$0(28);
        }
        return lineMarkerInfo;
    }

    @NotNull
    private static LineMarkerInfo<PsiElement> createImplementingMemberMarker(@NotNull JSPsiElementBase member, @NotNull Collection<? extends JSPsiElementBase> implementedMembers) {
        if (member == null) {
            JavaScriptLineMarkerProvider.$$$reportNull$$$0(29);
        }
        if (implementedMembers == null) {
            JavaScriptLineMarkerProvider.$$$reportNull$$$0(30);
        }
        LineMarkerInfo<PsiElement> lineMarkerInfo = JavaScriptLineMarkerProvider.createLineMarkerInfo(member, AllIcons.Gutter.ImplementingMethod, (Function<? super PsiElement, String>)new ParameterizedFunction<PsiElement>(implementedMembers.size() == 1 ? (PsiElement)ContainerUtil.getFirstItem(implementedMembers) : null){

            public String fun(PsiElement place) {
                PsiElement implementedMethodIfOnly = (PsiElement)this.myParam;
                if (implementedMethodIfOnly != null) {
                    String name;
                    PsiElement element;
                    String in = JSBundle.message((String)"linemarker.implements.invalid", (Object[])new Object[0]);
                    if (implementedMethodIfOnly.isValid() && (element = PsiTreeUtil.getParentOfType((PsiElement)implementedMethodIfOnly, JSClass.class)) != null && (name = ((NavigationItem)element).getName()) != null) {
                        in = name;
                    }
                    return JSBundle.message((String)"linemarker.implements.text", (Object[])new Object[]{JavaScriptLineMarkerProvider.getElementFromLineMarker(place, true).getName(), in});
                }
                return JSBundle.message((String)"linemarker.implements.several", (Object[])new Object[0]);
            }
        }, (GutterIconNavigationHandler<PsiElement>)((GutterIconNavigationHandler)(e, place) -> {
            JSQualifiedNamedElement elt = (JSQualifiedNamedElement)JavaScriptLineMarkerProvider.getElementFromLineMarker(place, true);
            Collection<JSPsiElementBase> results = JSInheritanceUtil.findImplementedMembers(elt);
            String name = JSFormatUtil.formatMember((JSPsiElementBase)elt, 1);
            JavaScriptLineMarkerProvider.doNavigate(results, JSBundle.message((String)"choose.super.method", (Object[])new Object[]{name, results.size()}), e);
        }));
        if (lineMarkerInfo == null) {
            JavaScriptLineMarkerProvider.$$$reportNull$$$0(31);
        }
        return lineMarkerInfo;
    }

    private static void addFunctionMarkers(@NotNull List<PsiElement> elements, @NotNull Map<String, Set<JSPsiElementBase>> jsFunctionsToProcess, final @NotNull Collection<LineMarkerInfo> result2) {
        if (elements == null) {
            JavaScriptLineMarkerProvider.$$$reportNull$$$0(32);
        }
        if (jsFunctionsToProcess == null) {
            JavaScriptLineMarkerProvider.$$$reportNull$$$0(33);
        }
        if (result2 == null) {
            JavaScriptLineMarkerProvider.$$$reportNull$$$0(34);
        }
        for (Map.Entry<String, Set<JSPsiElementBase>> entry : jsFunctionsToProcess.entrySet()) {
            ProgressManager.checkCanceled();
            final boolean isInterface = JSSymbolUtil.isInterface(entry.getKey(), (PsiElement)entry.getValue().iterator().next());
            final HashSet processed = new HashSet();
            JSResolveUtil.MyNamespaceProcessor processor = new JSResolveUtil.MyNamespaceProcessor(entry.getValue(), false){

                @Override
                protected boolean doProcess(PsiElement elt) {
                    Icon icon;
                    if (processed.contains(this.function)) {
                        return false;
                    }
                    boolean isClassOverride = JSSymbolUtil.isConstructorSymbol(this.function);
                    Icon icon2 = icon = isInterface ? AllIcons.Gutter.ImplementedMethod : AllIcons.Gutter.OverridenMethod;
                    Function tooltipProvider = isClassOverride && isInterface ? ourImplementedInterfacesTooltipProvider : (isClassOverride ? ourOverriddenFunctionsTooltipProvider2 : (isInterface ? ourImplementingFunctionsTooltipProvider : ourOverriddenFunctionsTooltipProvider));
                    result2.add(JavaScriptLineMarkerProvider.createLineMarkerInfo(this.function, icon, (Function<? super PsiElement, String>)tooltipProvider, (GutterIconNavigationHandler<PsiElement>)ourOverriddenMembersNavHandler));
                    processed.add(this.function);
                    return false;
                }
            };
            processor.processDescendantsOf(entry.getKey(), elements.get(0));
        }
    }

    private static void fillElementsToCheckMarkers(@NotNull List<PsiElement> elements, @NotNull Map<String, Set<JSPsiElementBase>> jsFunctionsToProcess, @NotNull Map<JSClass, Set<JSQualifiedNamedElement>> classMembersToProcess) {
        if (elements == null) {
            JavaScriptLineMarkerProvider.$$$reportNull$$$0(35);
        }
        if (jsFunctionsToProcess == null) {
            JavaScriptLineMarkerProvider.$$$reportNull$$$0(36);
        }
        if (classMembersToProcess == null) {
            JavaScriptLineMarkerProvider.$$$reportNull$$$0(37);
        }
        for (PsiElement place : elements) {
            ProgressManager.checkCanceled();
            JSPsiElementBase el = JavaScriptLineMarkerProvider.getElementFromLineMarker(place, false);
            if (el == null) continue;
            if (JSClassUtils.isPossibleHierarchyMember((PsiElement)el)) {
                JSQualifiedNamedElement member = (JSQualifiedNamedElement)el;
                if (member instanceof JSFunction && JavaScriptLineMarkerProvider.isNativeFunction((JSFunction)member)) continue;
                JSClass parentClass = JSUtils.getMemberContainingClass((PsiElement)member);
                if (!JSInheritanceUtil.canBeSuperMember((JSAttributeListOwner)member) && (member instanceof JSFunction && !((JSFunction)member).isConstructor() || parentClass != null)) continue;
                if (parentClass != null) {
                    THashSet members = classMembersToProcess.get(parentClass);
                    if (members == null) {
                        members = new THashSet();
                        classMembersToProcess.put(parentClass, (Set<JSQualifiedNamedElement>)members);
                    }
                    members.add((JSQualifiedNamedElement)member);
                    continue;
                }
                PsiElement parent = member.getParent();
                if (!(parent instanceof JSFile) && !(member instanceof JSFunctionExpression)) continue;
                JavaScriptLineMarkerProvider.addJSSymbolToSearch(jsFunctionsToProcess, (JSPsiElementBase)member);
                continue;
            }
            if (el instanceof JSClass) {
                JSClass clazz = (JSClass)el;
                if (classMembersToProcess.containsKey(clazz)) continue;
                classMembersToProcess.put(clazz, null);
                continue;
            }
            if (!(el instanceof JSDefinitionExpression) && !(el instanceof JSVariable) || !JavaScriptLineMarkerProvider.isExtension((JSElement)el)) continue;
            JavaScriptLineMarkerProvider.addJSSymbolToSearch(jsFunctionsToProcess, el);
        }
    }

    private static boolean isNativeFunction(JSFunction function) {
        JSAttributeList attrList;
        return function.getContainingFile().getLanguage() != JavaScriptSupportLoader.ECMA_SCRIPT_L4 && (attrList = function.getAttributeList()) != null && attrList.hasModifier(JSAttributeList.ModifierType.NATIVE);
    }

    @NotNull
    private static PsiElement getPlaceForLineMarker(@NotNull JSPsiElementBase element) {
        PsiElement nameIdentifier;
        if (element == null) {
            JavaScriptLineMarkerProvider.$$$reportNull$$$0(38);
        }
        if (element instanceof PsiNameIdentifierOwner && (nameIdentifier = JSAnnotatingVisitor.getPlaceForNamedElementProblem((PsiNameIdentifierOwner)element)) != element) {
            PsiElement psiElement = nameIdentifier;
            if (psiElement == null) {
                JavaScriptLineMarkerProvider.$$$reportNull$$$0(39);
            }
            return psiElement;
        }
        PsiElement child = element.getFirstChild();
        Object object = child != null ? child : element;
        if (object == null) {
            JavaScriptLineMarkerProvider.$$$reportNull$$$0(40);
        }
        return object;
    }

    @Contract(value="_, true -> !null")
    @Nullable
    public static JSPsiElementBase getElementFromLineMarker(@NotNull PsiElement place, boolean withAssertion) {
        JSFunction function;
        JSPsiElementBase parent;
        PsiElement parent2;
        if (place == null) {
            JavaScriptLineMarkerProvider.$$$reportNull$$$0(41);
        }
        if (place.getLanguage().isKindOf((Language)XMLLanguage.INSTANCE) && (parent2 = place.getParent()) instanceof XmlTag && XmlTagUtil.getStartTagNameElement((XmlTag)((XmlTag)parent2)) == place && parent2.getParent() instanceof XmlDocument && parent2.getContainingFile() != null && JavaScriptSupportLoader.isFlexMxmFile(parent2.getContainingFile())) {
            return XmlBackedJSClassFactory.getInstance().getXmlBackedClass((XmlTag)parent2);
        }
        JSNamedElement namedElement = JSPsiImplUtils.findElementFromNameIdentifier(place);
        JSPsiElementBase jSPsiElementBase = parent = namedElement instanceof JSPsiElementBase ? (JSPsiElementBase)namedElement : (JSPsiElementBase)PsiTreeUtil.getParentOfType((PsiElement)place, JSPsiElementBase.class, (boolean)false);
        if (!JavaScriptLineMarkerProvider.isClassMember(parent) && (function = JSPsiImplUtils.getPossibleFunction((PsiElement)parent)) != null) {
            parent = function;
        }
        if (withAssertion) {
            assert (parent != null && JavaScriptLineMarkerProvider.getPlaceForLineMarker(parent) == place) : "named element wasn't found for " + parent;
            return parent;
        }
        return parent != null && JavaScriptLineMarkerProvider.getPlaceForLineMarker(parent) == place ? parent : null;
    }

    private static boolean isExtension(JSElement def) {
        JSCallExpression callExpression;
        JSExpression methodExpression;
        JSExpression rOperand = null;
        if (def instanceof JSDefinitionExpression) {
            rOperand = ((JSDefinitionExpression)def).getInitializer();
        } else if (def instanceof JSVariable) {
            rOperand = ((JSVariable)def).getInitializer();
        }
        if (rOperand instanceof JSCallExpression && (methodExpression = (callExpression = (JSCallExpression)rOperand).getMethodExpression()) instanceof JSReferenceExpression) {
            JSReferenceExpression refExpr = (JSReferenceExpression)methodExpression;
            return JSSymbolUtil.isExtendCall(refExpr.getQualifier(), refExpr.getReferenceName(), null);
        }
        return false;
    }

    private static void addJSSymbolToSearch(Map<String, Set<JSPsiElementBase>> jsFunctionsToProcess, JSPsiElementBase function) {
        String qName = JSResolveUtil.getQNameToStartHierarchySearch(function);
        if (qName != null) {
            THashSet functions = jsFunctionsToProcess.get(qName);
            if (functions == null) {
                functions = new THashSet();
                jsFunctionsToProcess.put(qName, (Set<JSPsiElementBase>)functions);
            }
            functions.add((JSPsiElementBase)function);
        }
    }

    private static void doNavigate(Collection<? extends JSPsiNamedElementBase> items, String popupTitle, MouseEvent e) {
        JSGotoTargetRendererProvider.JSClassListCellRenderer renderer = new JSGotoTargetRendererProvider.JSClassListCellRenderer();
        items = JavaScriptGotoSuperHandler.sort(items, renderer);
        PsiElementListNavigator.openTargets((MouseEvent)e, (NavigatablePsiElement[])items.toArray(new NavigatablePsiElement[0]), (String)popupTitle, null, (ListCellRenderer)((Object)renderer));
    }

    @NotNull
    private static LineMarkerInfo<PsiElement> createLineMarkerInfo(@NotNull JSPsiElementBase element, Icon icon, @Nullable Function<? super PsiElement, String> tooltipProvider, @NotNull GutterIconNavigationHandler<PsiElement> navHandler) {
        if (element == null) {
            JavaScriptLineMarkerProvider.$$$reportNull$$$0(42);
        }
        if (navHandler == null) {
            JavaScriptLineMarkerProvider.$$$reportNull$$$0(43);
        }
        LineMarkerInfo<PsiElement> lineMarkerInfo = JavaScriptLineMarkerProvider.createLineMarkerInfo(element, icon, tooltipProvider, navHandler, 11);
        if (lineMarkerInfo == null) {
            JavaScriptLineMarkerProvider.$$$reportNull$$$0(44);
        }
        return lineMarkerInfo;
    }

    @NotNull
    private static LineMarkerInfo<PsiElement> createLineMarkerInfo(@NotNull JSPsiElementBase element, Icon icon, @Nullable Function<? super PsiElement, String> tooltipProvider, @NotNull GutterIconNavigationHandler<PsiElement> navHandler, int updatePass) {
        if (element == null) {
            JavaScriptLineMarkerProvider.$$$reportNull$$$0(45);
        }
        if (navHandler == null) {
            JavaScriptLineMarkerProvider.$$$reportNull$$$0(46);
        }
        PsiElement place = JavaScriptLineMarkerProvider.getPlaceForLineMarker(element);
        LineMarkerInfo lineMarkerInfo = new LineMarkerInfo(place, place.getTextRange(), icon, updatePass, tooltipProvider, navHandler, GutterIconRenderer.Alignment.RIGHT);
        if (lineMarkerInfo == null) {
            JavaScriptLineMarkerProvider.$$$reportNull$$$0(47);
        }
        return lineMarkerInfo;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 16: 
            case 18: 
            case 19: 
            case 22: 
            case 24: 
            case 26: 
            case 28: 
            case 31: 
            case 39: 
            case 40: 
            case 44: 
            case 47: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 16: 
            case 18: 
            case 19: 
            case 22: 
            case 24: 
            case 26: 
            case 28: 
            case 31: 
            case 39: 
            case 40: 
            case 44: 
            case 47: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "startFrom";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "colorsManager";
                break;
            }
            case 2: 
            case 16: 
            case 18: 
            case 19: 
            case 22: 
            case 24: 
            case 26: 
            case 28: 
            case 31: 
            case 39: 
            case 40: 
            case 44: 
            case 47: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/javascript/highlighting/JavaScriptLineMarkerProvider";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 38: 
            case 42: 
            case 45: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parent";
                break;
            }
            case 7: 
            case 32: 
            case 35: {
                objectArray2 = objectArray3;
                objectArray3[0] = "elements";
                break;
            }
            case 8: 
            case 10: 
            case 12: 
            case 15: 
            case 34: {
                objectArray2 = objectArray3;
                objectArray3[0] = "result";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "jsMembersToProcess";
                break;
            }
            case 11: 
            case 13: 
            case 17: 
            case 21: 
            case 23: {
                objectArray2 = objectArray3;
                objectArray3[0] = "clazz";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "members";
                break;
            }
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "function";
                break;
            }
            case 25: 
            case 27: 
            case 29: {
                objectArray2 = objectArray3;
                objectArray3[0] = "member";
                break;
            }
            case 30: {
                objectArray2 = objectArray3;
                objectArray3[0] = "implementedMembers";
                break;
            }
            case 33: 
            case 36: {
                objectArray2 = objectArray3;
                objectArray3[0] = "jsFunctionsToProcess";
                break;
            }
            case 37: {
                objectArray2 = objectArray3;
                objectArray3[0] = "classMembersToProcess";
                break;
            }
            case 41: {
                objectArray2 = objectArray3;
                objectArray3[0] = "place";
                break;
            }
            case 43: 
            case 46: {
                objectArray2 = objectArray3;
                objectArray3[0] = "navHandler";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/javascript/highlighting/JavaScriptLineMarkerProvider";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "createBottomMethodSeparatorLineMarker";
                break;
            }
            case 16: {
                objectArray = objectArray2;
                objectArray2[1] = "createSearchImplementedMemberQuery";
                break;
            }
            case 18: 
            case 19: {
                objectArray = objectArray2;
                objectArray2[1] = "createSearchImplementationsQuery";
                break;
            }
            case 22: {
                objectArray = objectArray2;
                objectArray2[1] = "createClassHasInheritorsMarker";
                break;
            }
            case 24: {
                objectArray = objectArray2;
                objectArray2[1] = "createClassHasImplementationsMarker";
                break;
            }
            case 26: {
                objectArray = objectArray2;
                objectArray2[1] = "createOverriddenMemberMarker";
                break;
            }
            case 28: {
                objectArray = objectArray2;
                objectArray2[1] = "createImplementedMemberMarker";
                break;
            }
            case 31: {
                objectArray = objectArray2;
                objectArray2[1] = "createImplementingMemberMarker";
                break;
            }
            case 39: 
            case 40: {
                objectArray = objectArray2;
                objectArray2[1] = "getPlaceForLineMarker";
                break;
            }
            case 44: 
            case 47: {
                objectArray = objectArray2;
                objectArray2[1] = "createLineMarkerInfo";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "createBottomMethodSeparatorLineMarker";
                break;
            }
            case 2: 
            case 16: 
            case 18: 
            case 19: 
            case 22: 
            case 24: 
            case 26: 
            case 28: 
            case 31: 
            case 39: 
            case 40: 
            case 44: 
            case 47: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "getLineMarkerInfo";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "createSeparatorMarker";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "propertyContainsFunction";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "findElementToStartMethodSeparator";
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "collectSlowLineMarkers";
                break;
            }
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "addMemberMarkers";
                break;
            }
            case 11: 
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "addLineMarkersForClass";
                break;
            }
            case 13: 
            case 14: 
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "addLineMarkersForJSDocInterface";
                break;
            }
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "createSearchImplementationsQuery";
                break;
            }
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "hasOverrideModifier";
                break;
            }
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "createClassHasInheritorsMarker";
                break;
            }
            case 23: {
                objectArray = objectArray;
                objectArray[2] = "createClassHasImplementationsMarker";
                break;
            }
            case 25: {
                objectArray = objectArray;
                objectArray[2] = "createOverriddenMemberMarker";
                break;
            }
            case 27: {
                objectArray = objectArray;
                objectArray[2] = "createImplementedMemberMarker";
                break;
            }
            case 29: 
            case 30: {
                objectArray = objectArray;
                objectArray[2] = "createImplementingMemberMarker";
                break;
            }
            case 32: 
            case 33: 
            case 34: {
                objectArray = objectArray;
                objectArray[2] = "addFunctionMarkers";
                break;
            }
            case 35: 
            case 36: 
            case 37: {
                objectArray = objectArray;
                objectArray[2] = "fillElementsToCheckMarkers";
                break;
            }
            case 38: {
                objectArray = objectArray;
                objectArray[2] = "getPlaceForLineMarker";
                break;
            }
            case 41: {
                objectArray = objectArray;
                objectArray[2] = "getElementFromLineMarker";
                break;
            }
            case 42: 
            case 43: 
            case 45: 
            case 46: {
                objectArray = objectArray;
                objectArray[2] = "createLineMarkerInfo";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 16: 
            case 18: 
            case 19: 
            case 22: 
            case 24: 
            case 26: 
            case 28: 
            case 31: 
            case 39: 
            case 40: 
            case 44: 
            case 47: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static abstract class ParameterizedFunction<P>
    implements Function<PsiElement, String> {
        @Nullable
        final P myParam;

        ParameterizedFunction(@Nullable P param) {
            this.myParam = param;
        }

        public boolean equals(Object obj) {
            if (obj == null) {
                return false;
            }
            if (!(obj instanceof ParameterizedFunction)) {
                return false;
            }
            P otherParam = ((ParameterizedFunction)obj).myParam;
            return this.myParam != null ? this.myParam.equals(otherParam) : otherParam == null;
        }

        public int hashCode() {
            return this.myParam != null ? this.myParam.hashCode() : 0;
        }
    }

    public static abstract class BasicGutterIconNavigationHandler<T extends JSPsiNamedElementBase>
    implements GutterIconNavigationHandler<PsiElement> {
        public void navigate(MouseEvent e, PsiElement place) {
            JSPsiElementBase elt = JavaScriptLineMarkerProvider.getElementFromLineMarker(place, true);
            Query<JSPsiElementBase> elementQuery = this.search(elt);
            if (elementQuery == null) {
                return;
            }
            Collection navElements = elementQuery.findAll();
            JavaScriptLineMarkerProvider.doNavigate(navElements, this.getTitle(elt, navElements.size()), e);
        }

        protected abstract String getTitle(T var1, int var2);

        @Nullable
        public abstract Query<T> search(T var1);
    }
}

