/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.inspections;

import com.intellij.codeInspection.LocalInspectionToolSession;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.lang.ecmascript6.psi.impl.ES6FieldStatementImpl;
import com.intellij.lang.javascript.JSBundle;
import com.intellij.lang.javascript.inspections.JSInspection;
import com.intellij.lang.javascript.inspections.JSRecursiveWalkingElementSkippingNestedFunctionsVisitor;
import com.intellij.lang.javascript.psi.JSElementVisitor;
import com.intellij.lang.javascript.psi.JSExpression;
import com.intellij.lang.javascript.psi.JSField;
import com.intellij.lang.javascript.psi.JSReferenceExpression;
import com.intellij.lang.javascript.psi.JSThisExpression;
import com.intellij.lang.javascript.psi.JSVariable;
import com.intellij.lang.javascript.psi.ecmal4.JSAttributeList;
import com.intellij.lang.javascript.psi.ecmal4.JSAttributeListOwner;
import com.intellij.lang.javascript.psi.ecmal4.JSClass;
import com.intellij.lang.javascript.psi.impl.JSPsiImplUtils;
import com.intellij.openapi.util.Pair;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.MultiMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ES6ClassMemberInitializationOrderInspection
extends JSInspection {
    @Override
    @NotNull
    protected PsiElementVisitor createVisitor(final ProblemsHolder holder, LocalInspectionToolSession session) {
        JSElementVisitor jSElementVisitor = new JSElementVisitor(){

            public void visitJSClass(JSClass aClass) {
                MultiMap referenced = MultiMap.createLinked();
                MultiMap nodes = MultiMap.createLinked();
                String className = aClass.getName();
                ArrayList allVarNames = ContainerUtil.newArrayList();
                HashSet statics = ContainerUtil.newHashSet();
                for (PsiElement child : aClass.getChildren()) {
                    JSExpression initializer;
                    JSVariable[] allVars;
                    if (!(child instanceof ES6FieldStatementImpl) || (allVars = ((ES6FieldStatementImpl)child).getVariables()).length != 1 || !(allVars[0] instanceof JSField)) continue;
                    JSField element = (JSField)allVars[0];
                    String fieldName = element.getName();
                    allVarNames.add(fieldName);
                    boolean isStatic = JSPsiImplUtils.hasModifier((JSAttributeListOwner)element, JSAttributeList.ModifierType.STATIC);
                    if (isStatic) {
                        statics.add(fieldName);
                    }
                    if ((initializer = element.getInitializer()) == null) continue;
                    JSFieldUsagesCollector collector = new JSFieldUsagesCollector(fieldName, className, (MultiMap<Pair<String, String>, PsiElement>)nodes, isStatic);
                    initializer.accept((PsiElementVisitor)collector);
                    referenced.put((Object)fieldName, (Collection)collector.referencedFields);
                }
                for (int i = 0; i < allVarNames.size(); ++i) {
                    String key = (String)allVarNames.get(i);
                    if (!referenced.containsKey((Object)key)) continue;
                    Collection strings = referenced.get((Object)key);
                    for (int j = i; j < allVarNames.size(); ++j) {
                        String otherVar = (String)allVarNames.get(j);
                        if (statics.contains(key) && !statics.contains(otherVar) || !strings.contains(otherVar)) continue;
                        Collection elements = nodes.get((Object)Pair.create((Object)key, (Object)otherVar));
                        for (PsiElement element : elements) {
                            holder.registerProblem(element, i == j ? JSBundle.message((String)"js.class.member.initialization.inspection.text.id", (Object[])new Object[]{key}) : JSBundle.message((String)"js.class.member.initialization.inspection.text", (Object[])new Object[]{key, otherVar}), new LocalQuickFix[0]);
                        }
                    }
                }
            }
        };
        if (jSElementVisitor == null) {
            ES6ClassMemberInitializationOrderInspection.$$$reportNull$$$0(0);
        }
        return jSElementVisitor;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/inspections/ES6ClassMemberInitializationOrderInspection", "createVisitor"));
    }

    private static class JSFieldUsagesCollector
    extends JSRecursiveWalkingElementSkippingNestedFunctionsVisitor {
        private final String myName;
        @Nullable
        private final String myClassName;
        private final MultiMap<Pair<String, String>, PsiElement> myNodes;
        private final boolean myIsStatic;
        private Set<String> referencedFields = ContainerUtil.newHashSet();

        public JSFieldUsagesCollector(String name, @Nullable String className, MultiMap<Pair<String, String>, PsiElement> nodes, boolean isStatic) {
            this.myName = name;
            this.myClassName = className;
            this.myNodes = nodes;
            this.myIsStatic = isStatic;
        }

        public void visitJSReferenceExpression(JSReferenceExpression node) {
            JSExpression qualifier = node.getQualifier();
            if (qualifier instanceof JSThisExpression) {
                String referenceName = node.getReferenceName();
                this.referencedFields.add(referenceName);
                this.myNodes.putValue((Object)Pair.create((Object)this.myName, (Object)referenceName), (Object)node);
            } else if (this.myIsStatic && this.myClassName != null) {
                if (!(qualifier instanceof JSReferenceExpression) || ((JSReferenceExpression)qualifier).getQualifier() != null) {
                    return;
                }
                String qualifierName = ((JSReferenceExpression)qualifier).getReferenceName();
                if (this.myClassName.equals(qualifierName)) {
                    String referenceName = node.getReferenceName();
                    this.referencedFields.add(referenceName);
                    this.myNodes.putValue((Object)Pair.create((Object)this.myName, (Object)referenceName), (Object)node);
                }
            }
        }

        @Override
        protected boolean skipLambdas() {
            return true;
        }
    }
}

