/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.inspections;

import com.intellij.codeInspection.LocalInspectionToolSession;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.LocalQuickFixAndIntentionActionOnPsiElement;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.lang.javascript.JSBundle;
import com.intellij.lang.javascript.documentation.JSDocumentationUtils;
import com.intellij.lang.javascript.inspections.JSInspection;
import com.intellij.lang.javascript.psi.JSNamedElement;
import com.intellij.lang.javascript.psi.ecmal4.JSAttributeList;
import com.intellij.lang.javascript.psi.jsdoc.JSDocComment;
import com.intellij.lang.javascript.psi.jsdoc.JSDocTag;
import com.intellij.lang.javascript.refactoring.JSVisibilityUtil;
import com.intellij.lang.javascript.validation.JSReferenceInspectionProblemReporterAdapter;
import com.intellij.lang.javascript.validation.JSReferenceInspectionVisitor;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiComment;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiFile;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JSAccessibilityCheckInspection
extends JSInspection {
    public static final String SHORT_NAME = JSAccessibilityCheckInspection.calcShortNameFromClass(JSAccessibilityCheckInspection.class);

    @NotNull
    public String getDisplayName() {
        String string = JSBundle.message((String)"js.accessibility.check.inspection.name", (Object[])new Object[0]);
        if (string == null) {
            JSAccessibilityCheckInspection.$$$reportNull$$$0(0);
        }
        return string;
    }

    @Override
    @NotNull
    protected PsiElementVisitor createVisitor(final ProblemsHolder holder, LocalInspectionToolSession session) {
        JSReferenceInspectionVisitor jSReferenceInspectionVisitor = new JSReferenceInspectionVisitor(new JSReferenceInspectionProblemReporterAdapter(holder){

            @Override
            public void reportAccessibilityError(@NotNull PsiElement identifier, ProblemHighlightType highlightType, @NotNull String message, @NotNull List<LocalQuickFix> fixes) {
                if (identifier == null) {
                    1.$$$reportNull$$$0(0);
                }
                if (message == null) {
                    1.$$$reportNull$$$0(1);
                }
                if (fixes == null) {
                    1.$$$reportNull$$$0(2);
                }
                LocalQuickFix[] quickFixes = this.registerFixes(identifier, fixes);
                if (highlightType == null) {
                    highlightType = ProblemHighlightType.LIKE_UNKNOWN_SYMBOL;
                }
                holder.registerProblem(identifier, message, highlightType, null, quickFixes);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[3];
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[0] = "identifier";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[0] = "message";
                        break;
                    }
                    case 2: {
                        objectArray = objectArray2;
                        objectArray2[0] = "fixes";
                        break;
                    }
                }
                objectArray[1] = "com/intellij/lang/javascript/inspections/JSAccessibilityCheckInspection$1";
                objectArray[2] = "reportAccessibilityError";
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        });
        if (jSReferenceInspectionVisitor == null) {
            JSAccessibilityCheckInspection.$$$reportNull$$$0(1);
        }
        return jSReferenceInspectionVisitor;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[2];
        objectArray2[0] = "com/intellij/lang/javascript/inspections/JSAccessibilityCheckInspection";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getDisplayName";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "createVisitor";
                break;
            }
        }
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
    }

    public static class SetJSDocElementVisibilityFix
    extends LocalQuickFixAndIntentionActionOnPsiElement {
        private final JSAttributeList.AccessType myNewVisibility;

        public SetJSDocElementVisibilityFix(@NotNull PsiElement element, JSAttributeList.AccessType newVisibility) {
            if (element == null) {
                SetJSDocElementVisibilityFix.$$$reportNull$$$0(0);
            }
            super(element);
            this.myNewVisibility = newVisibility;
        }

        public void invoke(@NotNull Project project, @NotNull PsiFile file, @Nullable(value="is null when called from inspection") Editor editor, @NotNull PsiElement startElement, @NotNull PsiElement endElement) {
            JSDocTag[] tags;
            PsiComment comment;
            if (project == null) {
                SetJSDocElementVisibilityFix.$$$reportNull$$$0(1);
            }
            if (file == null) {
                SetJSDocElementVisibilityFix.$$$reportNull$$$0(2);
            }
            if (startElement == null) {
                SetJSDocElementVisibilityFix.$$$reportNull$$$0(3);
            }
            if (endElement == null) {
                SetJSDocElementVisibilityFix.$$$reportNull$$$0(4);
            }
            if (!((comment = JSDocumentationUtils.findDocComment(startElement)) instanceof JSDocComment)) {
                return;
            }
            for (JSDocTag tag : tags = ((JSDocComment)comment).getTags()) {
                String tagName = tag.getName();
                if (!"private".equals(tagName) && !"protected".equals(tagName) && !"public".equals(tagName)) continue;
                Document document = PsiDocumentManager.getInstance((Project)project).getDocument(comment.getContainingFile());
                if (document != null) {
                    String visibilityTag = JSVisibilityUtil.getJSDocVisibilityKeyword(this.myNewVisibility);
                    if (visibilityTag != null) {
                        document.replaceString(tag.getTextRange().getStartOffset(), tag.getTextRange().getEndOffset(), (CharSequence)("@" + visibilityTag));
                    } else {
                        document.deleteString(tag.getTextRange().getStartOffset(), tag.getTextRange().getEndOffset());
                    }
                    PsiDocumentManager.getInstance((Project)project).commitDocument(document);
                }
                return;
            }
        }

        @NotNull
        public String getText() {
            PsiElement element = this.getStartElement();
            String name = element instanceof JSNamedElement ? ((JSNamedElement)element).getName() : "element";
            String visibility = JSVisibilityUtil.getJSDocVisibilityKeyword(this.myNewVisibility);
            if (visibility == null) {
                visibility = "default";
            }
            String string = JSBundle.message((String)"javascript.fix.set.element.visibility", (Object[])new Object[]{name, visibility});
            if (string == null) {
                SetJSDocElementVisibilityFix.$$$reportNull$$$0(5);
            }
            return string;
        }

        @NotNull
        public String getFamilyName() {
            String string = this.getText();
            if (string == null) {
                SetJSDocElementVisibilityFix.$$$reportNull$$$0(6);
            }
            return string;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 5: 
                case 6: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 5: 
                case 6: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "element";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "file";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "startElement";
                    break;
                }
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "endElement";
                    break;
                }
                case 5: 
                case 6: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/lang/javascript/inspections/JSAccessibilityCheckInspection$SetJSDocElementVisibilityFix";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/lang/javascript/inspections/JSAccessibilityCheckInspection$SetJSDocElementVisibilityFix";
                    break;
                }
                case 5: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getText";
                    break;
                }
                case 6: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getFamilyName";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 1: 
                case 2: 
                case 3: 
                case 4: {
                    objectArray = objectArray;
                    objectArray[2] = "invoke";
                    break;
                }
                case 5: 
                case 6: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 5: 
                case 6: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }
}

