/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.inspections;

import com.intellij.codeInspection.InspectionManager;
import com.intellij.codeInspection.InspectionProfileEntry;
import com.intellij.codeInspection.LocalInspectionTool;
import com.intellij.codeInspection.LocalInspectionToolSession;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.codeInspection.ui.SingleCheckboxOptionsPanel;
import com.intellij.lang.javascript.JSBundle;
import com.intellij.lang.javascript.psi.JSNamedElement;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiNamedElement;
import com.intellij.psi.util.PsiTreeUtil;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import org.jetbrains.annotations.NotNull;

public abstract class JSInspection
extends LocalInspectionTool {
    protected boolean myOnTheFly;

    @NotNull
    protected abstract PsiElementVisitor createVisitor(ProblemsHolder var1, LocalInspectionToolSession var2);

    @NotNull
    public String getShortName() {
        String string = JSInspection.calcShortNameFromClass(((Object)((Object)this)).getClass());
        if (string == null) {
            JSInspection.$$$reportNull$$$0(0);
        }
        return string;
    }

    public static String calcShortNameFromClass(Class aClass) {
        String name = aClass.getName();
        while (name.indexOf(36) != -1) {
            aClass = aClass.getSuperclass();
            name = aClass.getName();
        }
        name = name.substring(name.lastIndexOf(46) + 1);
        name = InspectionProfileEntry.getShortName((String)name);
        return name;
    }

    @NotNull
    public PsiElementVisitor buildVisitor(@NotNull ProblemsHolder holder, boolean isOnTheFly, @NotNull LocalInspectionToolSession session) {
        if (holder == null) {
            JSInspection.$$$reportNull$$$0(1);
        }
        if (session == null) {
            JSInspection.$$$reportNull$$$0(2);
        }
        this.myOnTheFly = isOnTheFly;
        PsiElementVisitor psiElementVisitor = this.createVisitor(holder, session);
        if (psiElementVisitor == null) {
            JSInspection.$$$reportNull$$$0(3);
        }
        return psiElementVisitor;
    }

    public boolean isEnabledByDefault() {
        return true;
    }

    @NotNull
    public String[] getGroupPath() {
        String[] stringArray = new String[]{"JavaScript", this.getGroupDisplayName()};
        if (stringArray == null) {
            JSInspection.$$$reportNull$$$0(4);
        }
        return stringArray;
    }

    public PsiNamedElement getProblemElement(@NotNull PsiElement psiElement) {
        JSNamedElement namedParent;
        if (psiElement == null) {
            JSInspection.$$$reportNull$$$0(5);
        }
        if ((namedParent = (JSNamedElement)PsiTreeUtil.getNonStrictParentOfType((PsiElement)psiElement, (Class[])new Class[]{JSNamedElement.class})) != null) {
            return namedParent;
        }
        return super.getProblemElement(psiElement);
    }

    @NotNull
    public String getGroupDisplayName() {
        String string = JSBundle.message((String)"js.inspection.group.name", (Object[])new Object[0]);
        if (string == null) {
            JSInspection.$$$reportNull$$$0(6);
        }
        return string;
    }

    protected JComponent createSingleCheckboxOptionsPanelWithHint(String label, String hint, String fieldName) {
        SingleCheckboxOptionsPanel checkBoxPanel = new SingleCheckboxOptionsPanel(label, (InspectionProfileEntry)this, fieldName);
        JCheckBox checkBox = (JCheckBox)checkBoxPanel.getComponents()[0];
        checkBox.setToolTipText(hint);
        return checkBoxPanel;
    }

    @NotNull
    public final ProblemDescriptor[] checkFile(@NotNull PsiFile file, @NotNull InspectionManager manager, boolean isOnTheFly) {
        if (file == null) {
            JSInspection.$$$reportNull$$$0(7);
        }
        if (manager == null) {
            JSInspection.$$$reportNull$$$0(8);
        }
        assert (false) : "should not be called, use visitFile in createVisitor instead";
        if (ProblemDescriptor.EMPTY_ARRAY == null) {
            JSInspection.$$$reportNull$$$0(9);
        }
        return ProblemDescriptor.EMPTY_ARRAY;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 1: 
            case 2: 
            case 5: 
            case 7: 
            case 8: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 1: 
            case 2: 
            case 5: 
            case 7: 
            case 8: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/javascript/inspections/JSInspection";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "holder";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "session";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psiElement";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "manager";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getShortName";
                break;
            }
            case 1: 
            case 2: 
            case 5: 
            case 7: 
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/javascript/inspections/JSInspection";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "buildVisitor";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getGroupPath";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getGroupDisplayName";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "checkFile";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "buildVisitor";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "getProblemElement";
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "checkFile";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 1: 
            case 2: 
            case 5: 
            case 7: 
            case 8: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

