/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.inspections;

import com.intellij.codeInspection.InspectionProfileEntry;
import com.intellij.codeInspection.LocalInspectionToolSession;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.codeInspection.reference.RefUtil;
import com.intellij.codeInspection.ui.MultipleCheckboxOptionsPanel;
import com.intellij.extapi.psi.StubBasedPsiElementBase;
import com.intellij.lang.injection.InjectedLanguageManager;
import com.intellij.lang.javascript.DialectDetector;
import com.intellij.lang.javascript.DialectOptionHolder;
import com.intellij.lang.javascript.JSBundle;
import com.intellij.lang.javascript.JavaScriptSupportLoader;
import com.intellij.lang.javascript.documentation.JSDocumentationUtils;
import com.intellij.lang.javascript.highlighting.JSFixFactory;
import com.intellij.lang.javascript.index.JSSymbolUtil;
import com.intellij.lang.javascript.inspections.JSInspection;
import com.intellij.lang.javascript.inspections.JSSharedUsageInformation;
import com.intellij.lang.javascript.psi.JSBlockStatement;
import com.intellij.lang.javascript.psi.JSCatchBlock;
import com.intellij.lang.javascript.psi.JSDefinitionExpression;
import com.intellij.lang.javascript.psi.JSElement;
import com.intellij.lang.javascript.psi.JSElementVisitor;
import com.intellij.lang.javascript.psi.JSEmbeddedContent;
import com.intellij.lang.javascript.psi.JSExpression;
import com.intellij.lang.javascript.psi.JSFunction;
import com.intellij.lang.javascript.psi.JSFunctionExpression;
import com.intellij.lang.javascript.psi.JSNamedElement;
import com.intellij.lang.javascript.psi.JSParameter;
import com.intellij.lang.javascript.psi.JSParameterItem;
import com.intellij.lang.javascript.psi.JSParameterList;
import com.intellij.lang.javascript.psi.JSProperty;
import com.intellij.lang.javascript.psi.JSStatement;
import com.intellij.lang.javascript.psi.JSVariable;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptFunctionType;
import com.intellij.lang.javascript.psi.ecmal4.JSAttributeList;
import com.intellij.lang.javascript.psi.ecmal4.JSClass;
import com.intellij.lang.javascript.psi.ecmal4.JSNamespaceDeclaration;
import com.intellij.lang.javascript.psi.impl.JSChangeUtil;
import com.intellij.lang.javascript.psi.impl.JSPsiImplUtils;
import com.intellij.lang.javascript.psi.jsdoc.JSDocComment;
import com.intellij.lang.javascript.psi.resolve.JSInheritanceUtil;
import com.intellij.lang.javascript.psi.resolve.JSNamedElementKind;
import com.intellij.lang.javascript.psi.resolve.JSResolveUtil;
import com.intellij.lang.javascript.validation.fixes.FixAndIntentionAction;
import com.intellij.lang.typescript.psi.TypeScriptPsiUtil;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiComment;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiLanguageInjectionHost;
import com.intellij.psi.PsiNamedElement;
import com.intellij.psi.search.LocalSearchScope;
import com.intellij.psi.search.SearchScope;
import com.intellij.psi.search.searches.ReferencesSearch;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.ui.components.JBPanel;
import com.intellij.util.Processor;
import com.intellij.util.SmartList;
import com.intellij.util.containers.Convertor;
import com.intellij.util.ui.JBUI;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.util.Arrays;
import java.util.List;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.border.EmptyBorder;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JSUnusedLocalSymbolsInspection
extends JSInspection {
    public boolean myIgnoreUnusedFunctionParameters;
    public boolean myIgnoreParametersBeforeUsed = true;
    public boolean myIgnoreUnusedCatchParameters = true;
    public static final String SHORT_NAME = JSUnusedLocalSymbolsInspection.calcShortNameFromClass(JSUnusedLocalSymbolsInspection.class);

    @NotNull
    public String getDisplayName() {
        String string = JSBundle.message((String)"js.unused.local.symbol.inspection.name", (Object[])new Object[0]);
        if (string == null) {
            JSUnusedLocalSymbolsInspection.$$$reportNull$$$0(0);
        }
        return string;
    }

    protected boolean shouldVisitVariable(@NotNull JSVariable node) {
        if (node == null) {
            JSUnusedLocalSymbolsInspection.$$$reportNull$$$0(1);
        }
        return true;
    }

    protected boolean shouldVisitParameter(@NotNull JSVariable node) {
        if (node == null) {
            JSUnusedLocalSymbolsInspection.$$$reportNull$$$0(2);
        }
        return true;
    }

    @NotNull
    protected JSElementVisitor createVisitor(final ProblemsHolder holder, LocalInspectionToolSession session) {
        JSElementVisitor jSElementVisitor = new JSElementVisitor(){

            public void visitJSVariable(JSVariable node) {
                if (JSUnusedLocalSymbolsInspection.this.shouldVisitVariable(node) && !(node instanceof JSParameter)) {
                    JSUnusedLocalSymbolsInspection.this.processNamedDeclaration((JSNamedElement)node, holder);
                }
            }

            public void visitJSCatchBlock(JSCatchBlock node) {
                if (JSUnusedLocalSymbolsInspection.this.myIgnoreUnusedCatchParameters || !node.hasParameter()) {
                    return;
                }
                JSParameter parameter = node.getParameter();
                if (parameter != null && JSUnusedLocalSymbolsInspection.this.shouldVisitParameter((JSVariable)parameter) && JSUnusedLocalSymbolsInspection.this.isLocallyDefined((JSNamedElement)parameter) && !JSUnusedLocalSymbolsInspection.isReferenced((JSNamedElement)parameter, (PsiElement)node)) {
                    JSUnusedLocalSymbolsInspection.reportUnused((PsiElement)node, (JSNamedElement)parameter, holder);
                }
            }

            public void visitJSParameterList(JSParameterList parameterList) {
                boolean breakAfterUsed;
                JSParameter[] variables = parameterList.getParameterVariables();
                JSParameter first = Arrays.stream(variables).filter(p -> !TypeScriptPsiUtil.isThisParameter((JSParameterItem)p)).findFirst().orElse(null);
                if (first == null || !JSUnusedLocalSymbolsInspection.this.shouldVisitParameter((JSVariable)first)) {
                    return;
                }
                JSFunction function = first.getDeclaringFunction();
                if (function == null || function instanceof TypeScriptFunctionType) {
                    return;
                }
                Processor scopeSkipChecker = scopeNode -> scopeNode == null || scopeNode instanceof JSFunction && (JSUnusedLocalSymbolsInspection.this.myIgnoreUnusedFunctionParameters || JSChangeUtil.getFunctionBody(function) == null);
                boolean isTypescript = DialectDetector.isTypeScript((PsiElement)function);
                boolean bl = breakAfterUsed = JSUnusedLocalSymbolsInspection.this.myIgnoreParametersBeforeUsed && (!isTypescript || function.getAccessType() != JSAttributeList.AccessType.PRIVATE);
                if (isTypescript && function.isConstructor()) {
                    Convertor scopeProvider = variable -> {
                        JSElement varScope = JSUnusedLocalSymbolsInspection.getScopeNode((JSNamedElement)variable);
                        return scopeSkipChecker.process((Object)varScope) ? null : varScope;
                    };
                    this.checkFunctionParameters(variables, (Convertor<JSParameter, PsiElement>)scopeProvider, breakAfterUsed, false);
                    return;
                }
                if (scopeSkipChecker.process((Object)function)) {
                    return;
                }
                if (!JSUnusedLocalSymbolsInspection.this.isLocallyDefined((JSNamedElement)first)) {
                    return;
                }
                String className = function.getQualifiedName();
                if (className != null && JSSymbolUtil.isInterface(className, (PsiElement)first)) {
                    return;
                }
                this.checkFunctionParameters(variables, (Convertor<JSParameter, PsiElement>)((Convertor)variable -> function), breakAfterUsed, true);
            }

            private void checkFunctionParameters(@NotNull JSParameter[] variables, @NotNull Convertor<JSParameter, PsiElement> scopeProvider, boolean breakAfterUsed, boolean localityDefined) {
                if (variables == null) {
                    1.$$$reportNull$$$0(0);
                }
                if (scopeProvider == null) {
                    1.$$$reportNull$$$0(1);
                }
                for (int i = variables.length - 1; i >= 0; --i) {
                    boolean isLocal;
                    JSParameter variable = variables[i];
                    PsiElement scopeNode = (PsiElement)scopeProvider.convert((Object)variable);
                    if (scopeNode == null) continue;
                    boolean bl = isLocal = localityDefined || JSUnusedLocalSymbolsInspection.this.isLocallyDefined((JSNamedElement)variable);
                    if (!isLocal) continue;
                    if (!JSUnusedLocalSymbolsInspection.isReferenced((JSNamedElement)variable, scopeNode)) {
                        JSUnusedLocalSymbolsInspection.reportUnused(scopeNode, (JSNamedElement)variable, holder);
                        continue;
                    }
                    if (breakAfterUsed) break;
                }
            }

            public void visitJSFunctionExpression(JSFunctionExpression node) {
                JSUnusedLocalSymbolsInspection.this.processNamedDeclaration((JSNamedElement)node, holder);
            }

            public void visitJSNamespaceDeclaration(JSNamespaceDeclaration node) {
                JSUnusedLocalSymbolsInspection.this.processNamedDeclaration((JSNamedElement)node, holder);
            }

            public void visitJSFunctionDeclaration(JSFunction node) {
                JSUnusedLocalSymbolsInspection.this.processNamedDeclaration((JSNamedElement)node, holder);
            }

            public void visitJSClass(JSClass aClass) {
                JSUnusedLocalSymbolsInspection.this.processNamedDeclaration((JSNamedElement)aClass, holder);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[3];
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[0] = "variables";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[0] = "scopeProvider";
                        break;
                    }
                }
                objectArray[1] = "com/intellij/lang/javascript/inspections/JSUnusedLocalSymbolsInspection$1";
                objectArray[2] = "checkFunctionParameters";
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        };
        if (jSElementVisitor == null) {
            JSUnusedLocalSymbolsInspection.$$$reportNull$$$0(3);
        }
        return jSElementVisitor;
    }

    private static boolean isJSAbstractMethod(JSFunction function) {
        DialectOptionHolder dialect = DialectDetector.dialectOfElement((PsiElement)function);
        boolean js = dialect != null && dialect.isJavaScript();
        JSElement body = JSChangeUtil.getFunctionBody(function);
        if (js && (body == null || body instanceof JSBlockStatement && PsiTreeUtil.findChildOfAnyType((PsiElement)body, (Class[])new Class[]{JSStatement.class, JSExpression.class}) == null)) {
            return true;
        }
        PsiComment docComment = JSDocumentationUtils.findDocCommentWider((PsiElement)function);
        return docComment instanceof JSDocComment && ((JSDocComment)docComment).hasAbstractTag();
    }

    private static boolean isSupportedFunction(JSFunction element) {
        return !(element instanceof JSFunctionExpression) && !(element.getContext() instanceof JSProperty);
    }

    private void processNamedDeclaration(@NotNull JSNamedElement node, @NotNull ProblemsHolder holder) {
        if (node == null) {
            JSUnusedLocalSymbolsInspection.$$$reportNull$$$0(4);
        }
        if (holder == null) {
            JSUnusedLocalSymbolsInspection.$$$reportNull$$$0(5);
        }
        JSSharedUsageInformation.get(holder.getFile()).registerDeclaration((PsiNamedElement)node);
        JSElement scopeNode = JSUnusedLocalSymbolsInspection.getScopeNode(node);
        if (scopeNode == null) {
            return;
        }
        if (this.isLocallyDefined(node) && !JSUnusedLocalSymbolsInspection.isReferenced(node, (PsiElement)scopeNode)) {
            JSUnusedLocalSymbolsInspection.reportUnused((PsiElement)scopeNode, node, holder);
        }
    }

    private static boolean isReferenced(@NotNull JSNamedElement node, @NotNull PsiElement scopeNode) {
        PsiLanguageInjectionHost host;
        if (node == null) {
            JSUnusedLocalSymbolsInspection.$$$reportNull$$$0(6);
        }
        if (scopeNode == null) {
            JSUnusedLocalSymbolsInspection.$$$reportNull$$$0(7);
        }
        if (RefUtil.isImplicitUsage((PsiElement)node)) {
            return true;
        }
        InjectedLanguageManager ilm = InjectedLanguageManager.getInstance((Project)node.getProject());
        if (scopeNode instanceof JSEmbeddedContent) {
            scopeNode = scopeNode.getContainingFile();
        } else if (ilm.isInjectedFragment(scopeNode.getContainingFile()) && (host = ilm.getInjectionHost((PsiElement)scopeNode.getContainingFile())) != null) {
            scopeNode = host.getContainingFile();
        }
        if (scopeNode == null) {
            return false;
        }
        return !ReferencesSearch.search((PsiElement)node, (SearchScope)new LocalSearchScope(scopeNode), (boolean)true).forEach(reference -> {
            if (node == null) {
                JSUnusedLocalSymbolsInspection.$$$reportNull$$$0(14);
            }
            return reference instanceof PsiElement && (JSResolveUtil.isSelfReference((PsiElement)reference) || node instanceof JSFunction && PsiTreeUtil.isAncestor((PsiElement)node, (PsiElement)((PsiElement)reference), (boolean)false));
        });
    }

    private static void reportUnused(@NotNull PsiElement scope, @NotNull JSNamedElement namedElement, @NotNull ProblemsHolder holder) {
        PsiElement highlightedElement;
        if (scope == null) {
            JSUnusedLocalSymbolsInspection.$$$reportNull$$$0(8);
        }
        if (namedElement == null) {
            JSUnusedLocalSymbolsInspection.$$$reportNull$$$0(9);
        }
        if (holder == null) {
            JSUnusedLocalSymbolsInspection.$$$reportNull$$$0(10);
        }
        JSNamedElementKind namedElementKind = JSNamedElementKind.kind((PsiElement)namedElement, true);
        boolean asInfo = false;
        if (namedElement instanceof JSParameter && scope instanceof JSFunction) {
            boolean ecma;
            boolean bl = ecma = scope.getContainingFile().getLanguage() == JavaScriptSupportLoader.ECMA_SCRIPT_L4;
            if (ecma && scope instanceof JSFunctionExpression) {
                return;
            }
            JSFunction fun = (JSFunction)scope;
            JSAttributeList attributeList = fun.getAttributeList();
            boolean bl2 = asInfo = holder.isOnTheFly() && (attributeList != null && attributeList.hasModifier(JSAttributeList.ModifierType.OVERRIDE) || JSInheritanceUtil.participatesInHierarchy(fun) || JSUnusedLocalSymbolsInspection.isJSAbstractMethod(fun));
        }
        if ((highlightedElement = namedElement.getNameIdentifier()) == null) {
            return;
        }
        String name = namedElement.getName();
        if (name != null && name.startsWith("ignore")) {
            return;
        }
        SmartList fixes = new SmartList();
        if (!(asInfo || scope instanceof JSFunction && ((JSFunction)scope).isSetProperty())) {
            FixAndIntentionAction fix = JSFixFactory.getInstance().removeElementLocalQuickFix(namedElementKind, name);
            fix.registerElementRefForFix(highlightedElement, null);
            fixes.add(fix);
        }
        if (holder.isOnTheFly() && scope instanceof JSFunction && namedElement instanceof JSParameter) {
            JSFixFactory.getInstance().addFixesForFields((JSFunction)scope, highlightedElement, name, (List<LocalQuickFix>)fixes);
        }
        LocalQuickFix[] quickFixes = fixes.size() == 0 ? LocalQuickFix.EMPTY_ARRAY : fixes.toArray(LocalQuickFix.EMPTY_ARRAY);
        ProblemHighlightType highlightType = asInfo ? ProblemHighlightType.INFORMATION : ProblemHighlightType.LIKE_UNUSED_SYMBOL;
        holder.registerProblem(highlightedElement, JSUnusedLocalSymbolsInspection.unusedMessage(namedElementKind), highlightType, quickFixes);
        JSSharedUsageInformation.get(holder.getFile()).registerDeclaration((PsiNamedElement)namedElement);
    }

    static String unusedMessage(JSNamedElementKind namedElementKind) {
        return JSBundle.message((String)"js.unused.symbol", (Object[])new Object[]{JSUnusedLocalSymbolsInspection.getNamedElementKindDecapitalizedText(namedElementKind)});
    }

    @Nullable
    private static String getNamedElementKindDecapitalizedText(@NotNull JSNamedElementKind namedElementKind) {
        if (namedElementKind == null) {
            JSUnusedLocalSymbolsInspection.$$$reportNull$$$0(11);
        }
        return StringUtil.decapitalize((String)JSBundle.message((String)namedElementKind.humanReadableKey(), (Object[])new Object[0]));
    }

    public static boolean isNotGloballyDefined(@NotNull JSNamedElement node) {
        if (node == null) {
            JSUnusedLocalSymbolsInspection.$$$reportNull$$$0(12);
        }
        return JSUnusedLocalSymbolsInspection.isNonDefinitionExpression(node) || JSUnusedLocalSymbolsInspection.locallyDefinedInScope(node);
    }

    protected boolean isLocallyDefined(JSNamedElement node) {
        return JSUnusedLocalSymbolsInspection.locallyDefinedInScope(node) && !JSUnusedLocalSymbolsInspection.isNonDefinitionExpression(node);
    }

    private static boolean isNonDefinitionExpression(@NotNull JSNamedElement node) {
        if (node == null) {
            JSUnusedLocalSymbolsInspection.$$$reportNull$$$0(13);
        }
        return node instanceof JSExpression && !(node instanceof JSDefinitionExpression);
    }

    private static boolean locallyDefinedInScope(JSNamedElement node) {
        if (node instanceof JSFunction && !JSUnusedLocalSymbolsInspection.isSupportedFunction((JSFunction)node)) {
            return false;
        }
        return JSPsiImplUtils.getNameScope(node) != null;
    }

    private static JSElement getScopeNode(JSNamedElement node) {
        if (node instanceof StubBasedPsiElementBase && ((StubBasedPsiElementBase)node).getStub() != null) {
            return null;
        }
        return JSPsiImplUtils.getScopeNode((JSElement)node);
    }

    public JComponent createOptionsPanel() {
        MultipleCheckboxOptionsPanel optionsPanel = new MultipleCheckboxOptionsPanel((InspectionProfileEntry)this);
        JBPanel wrapper = new JBPanel((LayoutManager)new BorderLayout());
        JLabel label = new JLabel(JSBundle.message((String)"javascript.ignore.unused.function.parameters", (Object[])new Object[0]));
        EmptyBorder border = new EmptyBorder((Insets)JBUI.insets((int)0, (int)5, (int)5, (int)5));
        label.setBorder(border);
        wrapper.add((Component)label, (Object)"West");
        JComboBox<MyIgnoreUnusedParametersOption> comboBox = new JComboBox<MyIgnoreUnusedParametersOption>(MyIgnoreUnusedParametersOption.values());
        label.setLabelFor(comboBox);
        comboBox.setEditable(false);
        comboBox.setBorder(border);
        comboBox.setSelectedItem((Object)(this.myIgnoreUnusedFunctionParameters ? MyIgnoreUnusedParametersOption.all : (this.myIgnoreParametersBeforeUsed ? MyIgnoreUnusedParametersOption.beforeUsed : MyIgnoreUnusedParametersOption.none)));
        comboBox.addActionListener(e -> {
            Object selected = comboBox.getSelectedItem();
            if (MyIgnoreUnusedParametersOption.all.equals(selected)) {
                this.myIgnoreUnusedFunctionParameters = true;
                this.myIgnoreParametersBeforeUsed = false;
            } else {
                this.myIgnoreUnusedFunctionParameters = false;
                this.myIgnoreParametersBeforeUsed = MyIgnoreUnusedParametersOption.beforeUsed.equals(selected);
            }
        });
        wrapper.add(comboBox, (Object)"East");
        optionsPanel.addComponent((JComponent)wrapper);
        optionsPanel.addCheckbox(JSBundle.message((String)"javascript.ignore.unused.catch.parameters", (Object[])new Object[0]), "myIgnoreUnusedCatchParameters");
        return optionsPanel;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 1: 
            case 2: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 1: 
            case 2: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/javascript/inspections/JSUnusedLocalSymbolsInspection";
                break;
            }
            case 1: 
            case 2: 
            case 4: 
            case 6: 
            case 12: 
            case 13: 
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "node";
                break;
            }
            case 5: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "holder";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "scopeNode";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "scope";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "namedElement";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "namedElementKind";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getDisplayName";
                break;
            }
            case 1: 
            case 2: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/javascript/inspections/JSUnusedLocalSymbolsInspection";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "createVisitor";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "shouldVisitVariable";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "shouldVisitParameter";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "processNamedDeclaration";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "isReferenced";
                break;
            }
            case 8: 
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "reportUnused";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "getNamedElementKindDecapitalizedText";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "isNotGloballyDefined";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "isNonDefinitionExpression";
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "lambda$isReferenced$0";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 1: 
            case 2: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static enum MyIgnoreUnusedParametersOption {
        all("All"),
        beforeUsed("Before used"),
        none("None");

        private final String myText;

        private MyIgnoreUnusedParametersOption(String text) {
            if (text == null) {
                MyIgnoreUnusedParametersOption.$$$reportNull$$$0(0);
            }
            this.myText = text;
        }

        public String toString() {
            return this.myText;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "text", "com/intellij/lang/javascript/inspections/JSUnusedLocalSymbolsInspection$MyIgnoreUnusedParametersOption", "<init>"));
        }
    }
}

