/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.json;

import com.google.common.base.Predicates;
import com.intellij.lang.documentation.DocumentationProvider;
import com.intellij.lang.javascript.json.JsonSchemaInJavaScriptProvider;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiManager;
import com.jetbrains.jsonSchema.ide.JsonSchemaService;
import com.jetbrains.jsonSchema.impl.JsonSchemaDocumentationProvider;
import com.jetbrains.jsonSchema.impl.JsonSchemaObject;
import java.util.Arrays;
import java.util.List;
import java.util.function.Predicate;
import org.jetbrains.annotations.Nullable;

public class JsonSchemaInJavaScriptDocumentationProvider
implements DocumentationProvider {
    @Nullable
    public String getQuickNavigateInfo(PsiElement element, PsiElement originalElement) {
        return JsonSchemaInJavaScriptDocumentationProvider.findSchemaAndGenerateDoc(element, true);
    }

    @Nullable
    public List<String> getUrlFor(PsiElement element, PsiElement originalElement) {
        return null;
    }

    @Nullable
    public String generateDoc(PsiElement element, @Nullable PsiElement originalElement) {
        return JsonSchemaInJavaScriptDocumentationProvider.findSchemaAndGenerateDoc(element, false);
    }

    @Nullable
    private static String findSchemaAndGenerateDoc(PsiElement element, boolean preferShort) {
        JsonSchemaInJavaScriptProvider[] extensions = (JsonSchemaInJavaScriptProvider[])JsonSchemaInJavaScriptProvider.EP_NAME.getExtensions();
        JsonSchemaService jsonSchemaService = JsonSchemaService.Impl.get((Project)element.getProject());
        return Arrays.stream(extensions).filter(provider2 -> provider2.getSchemaFile() != null && provider2.isAvailable(element)).map(provider2 -> {
            JsonSchemaObject schemaObject = jsonSchemaService.getSchemaObjectForSchemaFile(provider2.getSchemaFile());
            if (schemaObject != null) {
                return JsonSchemaDocumentationProvider.generateDoc((PsiElement)element, (JsonSchemaObject)schemaObject, (boolean)preferShort);
            }
            return null;
        }).filter((Predicate<String>)Predicates.notNull()).findFirst().orElse(null);
    }

    @Nullable
    public PsiElement getDocumentationElementForLookupItem(PsiManager psiManager, Object object, PsiElement element) {
        return null;
    }

    @Nullable
    public PsiElement getDocumentationElementForLink(PsiManager psiManager, String link, PsiElement context) {
        return null;
    }
}

