/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.library;

import com.intellij.lang.javascript.library.JSCorePredefinedLibrariesProvider;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ProjectFileIndex;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.search.ProjectScope;
import com.intellij.util.ArrayUtil;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.xml.util.HtmlUtil;
import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JSLibraryUtil {
    public static final Logger LOG = Logger.getInstance(JSLibraryUtil.class);
    public static final String[] MIN_SUFFIXES = new String[]{".min.", "-min.", "-yui-compressed"};
    public static final HashMap<String, String> MIN_TO_DEV_VERSION_MAP = new HashMap();
    public static final String NODE_MODULES = "node_modules";
    public static final String BOWER_COMPONENTS = "bower_components";
    public static final String JSPM_PACKAGES = "jspm_packages";
    public static final String[] LIBRARY_DIR_NAMES = new String[]{"node_modules", "bower_components", "jspm_packages"};
    public static final Set<String> LIBRARY_ROOT_DIR_NAME_SET = Collections.unmodifiableSet(ContainerUtil.newHashSet((Object[])LIBRARY_DIR_NAMES));
    private static final String JS_EXT = ".js";
    private static final String[] HTTP_PREFIXES;

    private JSLibraryUtil() {
    }

    public static boolean containsLibURL(String location) {
        return HtmlUtil.hasHtmlPrefix((String)location) && location.endsWith(JS_EXT);
    }

    public static String getDevVersionLocation(@NotNull String location) {
        if (location == null) {
            JSLibraryUtil.$$$reportNull$$$0(0);
        }
        if (!location.endsWith(JS_EXT)) {
            return location;
        }
        String oldFileName = JSLibraryUtil.extractFileName(location);
        String fileName = oldFileName;
        if (MIN_TO_DEV_VERSION_MAP.containsKey(fileName)) {
            return location.replace(oldFileName, MIN_TO_DEV_VERSION_MAP.get(fileName));
        }
        for (String minSuffix : MIN_SUFFIXES) {
            if (!fileName.contains(minSuffix)) continue;
            fileName = oldFileName.replace(minSuffix, ".");
            return location.replace(oldFileName, fileName);
        }
        return location;
    }

    public static String makeUniqueFileName(String filePath, boolean adjustFileName) {
        String path = filePath;
        for (String prefix : HTTP_PREFIXES) {
            if (!filePath.contains(prefix)) continue;
            path = filePath.replace(prefix, "http_");
            break;
        }
        if (adjustFileName) {
            String fileName = JSLibraryUtil.extractFileName(filePath);
            if (MIN_TO_DEV_VERSION_MAP.containsKey(fileName)) {
                path = path.replace(fileName, MIN_TO_DEV_VERSION_MAP.get(fileName));
            } else {
                for (String minSuffix : MIN_SUFFIXES) {
                    if (!filePath.contains(minSuffix)) continue;
                    path = path.replace(minSuffix, ".");
                    break;
                }
            }
        }
        return path.replace('/', '_').replace('\\', '_');
    }

    public static String extractFileName(String filePath) {
        int fileSepIndex = filePath.lastIndexOf(47);
        if (fileSepIndex < 0) {
            fileSepIndex = filePath.lastIndexOf(File.separatorChar);
        }
        return fileSepIndex >= 0 ? filePath.substring(fileSepIndex + 1, filePath.length()) : filePath;
    }

    @Nullable
    public static String getCanonicalUrl(String path) {
        File file = new File(path);
        try {
            return VfsUtilCore.pathToUrl((String)file.getCanonicalPath());
        }
        catch (IOException e) {
            return null;
        }
    }

    public static String getLibName(String location) {
        int dotIndex;
        String libName = JSLibraryUtil.extractFileName(location);
        if (!MIN_TO_DEV_VERSION_MAP.containsKey(libName)) {
            for (String minSuffix : MIN_SUFFIXES) {
                if (!libName.contains(minSuffix)) continue;
                libName = libName.replace(minSuffix, ".");
                break;
            }
        }
        if ((dotIndex = libName.lastIndexOf(46)) >= 0) {
            libName = libName.substring(0, dotIndex);
        }
        return libName;
    }

    public static boolean isProbableLibraryFile(@NotNull VirtualFile file, @Nullable Project project) {
        if (file == null) {
            JSLibraryUtil.$$$reportNull$$$0(1);
        }
        return JSLibraryUtil.isProbableLibraryFile(file, project == null ? null : project.getBaseDir());
    }

    public static boolean isProbableLibraryFile(@NotNull VirtualFile file) {
        if (file == null) {
            JSLibraryUtil.$$$reportNull$$$0(2);
        }
        return JSLibraryUtil.isPredefinedLibraryFile(file) || JSLibraryUtil.hasDirectoryInPath(file, LIBRARY_DIR_NAMES, null);
    }

    public static boolean isProbableLibraryFile(@NotNull VirtualFile file, @Nullable VirtualFile fileToStop) {
        if (file == null) {
            JSLibraryUtil.$$$reportNull$$$0(3);
        }
        return JSLibraryUtil.isPredefinedLibraryFile(file) || JSLibraryUtil.hasDirectoryInPath(file, LIBRARY_DIR_NAMES, fileToStop);
    }

    private static boolean isPredefinedLibraryFile(@NotNull VirtualFile file) {
        if (file == null) {
            JSLibraryUtil.$$$reportNull$$$0(4);
        }
        return JSCorePredefinedLibrariesProvider.getAllJSPredefinedLibraryFiles().contains(file);
    }

    public static VirtualFile getTopLibraryFolder(@NotNull VirtualFile file, @NotNull String libraryFolder, @Nullable VirtualFile stopFolder) {
        if (file == null) {
            JSLibraryUtil.$$$reportNull$$$0(5);
        }
        if (libraryFolder == null) {
            JSLibraryUtil.$$$reportNull$$$0(6);
        }
        VirtualFile currentTarget = file;
        VirtualFile current = file;
        VirtualFile candidate;
        while ((candidate = JSLibraryUtil.getLibraryFolder(currentTarget, libraryFolder)) != null && (stopFolder == null || VfsUtilCore.isAncestor((VirtualFile)stopFolder, (VirtualFile)candidate, (boolean)true))) {
            current = candidate;
            if (current.getParent() == null || current.getParent().getParent() == null) {
                return current;
            }
            currentTarget = current.getParent().getParent();
        }
        return current;
    }

    @Nullable
    public static VirtualFile findAncestorLibraryDir(@NotNull VirtualFile fileOrDir, @NotNull String libraryName) {
        if (fileOrDir == null) {
            JSLibraryUtil.$$$reportNull$$$0(7);
        }
        if (libraryName == null) {
            JSLibraryUtil.$$$reportNull$$$0(8);
        }
        for (VirtualFile f = fileOrDir.getParent(); f != null; f = f.getParent()) {
            if (!StringUtil.equals((CharSequence)libraryName, (CharSequence)f.getNameSequence())) continue;
            return f;
        }
        return null;
    }

    public static VirtualFile getLibraryFolder(@NotNull VirtualFile file) {
        if (file == null) {
            JSLibraryUtil.$$$reportNull$$$0(9);
        }
        return JSLibraryUtil.getLibraryFolder(file, LIBRARY_ROOT_DIR_NAME_SET);
    }

    public static VirtualFile getLibraryFolder(@NotNull VirtualFile file, @NotNull String parentLibraryFolder) {
        if (file == null) {
            JSLibraryUtil.$$$reportNull$$$0(10);
        }
        if (parentLibraryFolder == null) {
            JSLibraryUtil.$$$reportNull$$$0(11);
        }
        return JSLibraryUtil.getLibraryFolder(file, Collections.singleton(parentLibraryFolder));
    }

    @Nullable
    public static VirtualFile getLibraryFolder(@NotNull VirtualFile file, @NotNull Set<String> parentLibraryFolders) {
        if (file == null) {
            JSLibraryUtil.$$$reportNull$$$0(12);
        }
        if (parentLibraryFolders == null) {
            JSLibraryUtil.$$$reportNull$$$0(13);
        }
        VirtualFile current = file;
        while (current != null) {
            CharSequence parentName;
            VirtualFile parent = current.getParent();
            CharSequence charSequence = parentName = parent == null ? null : parent.getNameSequence();
            if (parentName != null && parentLibraryFolders.contains(parentName.toString())) {
                return current;
            }
            current = parent;
        }
        return null;
    }

    public static boolean hasDirectoryInPath(@NotNull VirtualFile file, @NotNull String[] dirNames, @Nullable VirtualFile fileToStop) {
        if (file == null) {
            JSLibraryUtil.$$$reportNull$$$0(14);
        }
        if (dirNames == null) {
            JSLibraryUtil.$$$reportNull$$$0(15);
        }
        for (VirtualFile parent = file.getParent(); !(parent == null || fileToStop != null && parent.equals(fileToStop)); parent = parent.getParent()) {
            CharSequence name = parent.getNameSequence();
            for (String dirName : dirNames) {
                if (!StringUtil.equals((CharSequence)dirName, (CharSequence)name)) continue;
                return true;
            }
        }
        return false;
    }

    public static boolean hasDirectoryInPath(@NotNull VirtualFile file, @NotNull String directoryName, @Nullable VirtualFile fileToStop) {
        if (file == null) {
            JSLibraryUtil.$$$reportNull$$$0(16);
        }
        if (directoryName == null) {
            JSLibraryUtil.$$$reportNull$$$0(17);
        }
        for (VirtualFile parent = file.getParent(); !(parent == null || fileToStop != null && parent.equals(fileToStop)); parent = parent.getParent()) {
            if (!StringUtil.equals((CharSequence)directoryName, (CharSequence)parent.getNameSequence())) continue;
            return true;
        }
        return false;
    }

    public static boolean isProbableLibraryPath(@NotNull String file) {
        if (file == null) {
            JSLibraryUtil.$$$reportNull$$$0(18);
        }
        String name = FileUtil.toSystemDependentName((String)file);
        for (String s : FileUtil.splitPath((String)name)) {
            if (!ArrayUtil.contains((String)s, (String[])LIBRARY_DIR_NAMES)) continue;
            return true;
        }
        return false;
    }

    @Nullable
    public static VirtualFile findFileByIoFile(@NotNull LocalFileSystem localFileSystem, @NotNull File ioFile) {
        if (localFileSystem == null) {
            JSLibraryUtil.$$$reportNull$$$0(19);
        }
        if (ioFile == null) {
            JSLibraryUtil.$$$reportNull$$$0(20);
        }
        if (!ioFile.isFile()) {
            LOG.warn("Cannot find " + ioFile.getAbsolutePath() + ", the installation is possibly broken.");
            return null;
        }
        VirtualFile file = localFileSystem.findFileByIoFile(ioFile);
        if (file != null) {
            return file;
        }
        LOG.warn("Cannot find virtual file for " + ioFile.getAbsolutePath());
        return null;
    }

    @Nullable
    public static VirtualFile findUpClosestNodeModulesResolveRoot(@NotNull VirtualFile file) {
        if (file == null) {
            JSLibraryUtil.$$$reportNull$$$0(21);
        }
        for (VirtualFile parent = file.getParent(); parent != null; parent = parent.getParent()) {
            VirtualFile nodeModulesDir = parent.findChild(NODE_MODULES);
            if (nodeModulesDir == null || !nodeModulesDir.isDirectory()) continue;
            return nodeModulesDir;
        }
        return null;
    }

    @Nullable
    public static VirtualFile findFileByIO(@NotNull File ioFile, boolean includeInvalid) {
        if (ioFile == null) {
            JSLibraryUtil.$$$reportNull$$$0(22);
        }
        URL libFileUrl = null;
        try {
            libFileUrl = ioFile.toURI().toURL();
        }
        catch (MalformedURLException malformedURLException) {
            // empty catch block
        }
        if (libFileUrl == null) {
            LOG.error("Cannot find " + ioFile.getName() + ", the installation is possibly broken.");
            return null;
        }
        VirtualFile file = VfsUtil.findFileByURL((URL)libFileUrl);
        if (file != null && (includeInvalid || file.isValid())) {
            return file;
        }
        LOG.warn("Cannot find virtual file " + ioFile.getName() + " by url " + libFileUrl.toExternalForm());
        return null;
    }

    @Contract(value="_, null, _-> null")
    @Nullable
    public static VirtualFile cacheFile(@NotNull String libFileName, @Nullable VirtualFile file, @NotNull Map<String, Ref<VirtualFile>> cache) {
        if (libFileName == null) {
            JSLibraryUtil.$$$reportNull$$$0(23);
        }
        if (cache == null) {
            JSLibraryUtil.$$$reportNull$$$0(24);
        }
        cache.put(libFileName, (Ref<VirtualFile>)Ref.create((Object)file));
        return file;
    }

    @Contract(value="_, null -> null")
    public static VirtualFile getContentRootForFile(@NotNull Project project, @Nullable VirtualFile file) {
        if (project == null) {
            JSLibraryUtil.$$$reportNull$$$0(25);
        }
        return JSLibraryUtil.getContentRootForFile(ProjectFileIndex.getInstance((Project)project), file);
    }

    @Contract(value="_, null -> null")
    public static VirtualFile getContentRootForFile(@NotNull ProjectFileIndex fileIndex, @Nullable VirtualFile file) {
        if (fileIndex == null) {
            JSLibraryUtil.$$$reportNull$$$0(26);
        }
        if (file == null) {
            return null;
        }
        VirtualFile contentRoot = fileIndex.getContentRootForFile(file, false);
        if (contentRoot == null && (file = file.getParent()) != null) {
            contentRoot = fileIndex.getContentRootForFile(file, false);
        }
        return contentRoot;
    }

    @NotNull
    public static GlobalSearchScope getContentScopeWithoutLibraries(@NotNull Project project) {
        if (project == null) {
            JSLibraryUtil.$$$reportNull$$$0(27);
        }
        GlobalSearchScope scope = ProjectScope.getContentScope((Project)project);
        final ProjectFileIndex fileIndex = ProjectFileIndex.getInstance((Project)project);
        GlobalSearchScope globalSearchScope = scope.intersectWith(new GlobalSearchScope(){

            public boolean contains(@NotNull VirtualFile file) {
                if (file == null) {
                    1.$$$reportNull$$$0(0);
                }
                return file.isValid() && !file.isDirectory() && !JSLibraryUtil.isProbableLibraryFile(file) && !fileIndex.isInLibrary(file);
            }

            public int compare(@NotNull VirtualFile file1, @NotNull VirtualFile file2) {
                if (file1 == null) {
                    1.$$$reportNull$$$0(1);
                }
                if (file2 == null) {
                    1.$$$reportNull$$$0(2);
                }
                return 0;
            }

            public boolean isSearchInModuleContent(@NotNull Module aModule) {
                if (aModule == null) {
                    1.$$$reportNull$$$0(3);
                }
                return true;
            }

            public boolean isSearchInLibraries() {
                return false;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2;
                Object[] objectArray3 = new Object[3];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "file";
                        break;
                    }
                    case 1: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "file1";
                        break;
                    }
                    case 2: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "file2";
                        break;
                    }
                    case 3: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "aModule";
                        break;
                    }
                }
                objectArray2[1] = "com/intellij/lang/javascript/library/JSLibraryUtil$1";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[2] = "contains";
                        break;
                    }
                    case 1: 
                    case 2: {
                        objectArray = objectArray2;
                        objectArray2[2] = "compare";
                        break;
                    }
                    case 3: {
                        objectArray = objectArray2;
                        objectArray2[2] = "isSearchInModuleContent";
                        break;
                    }
                }
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        });
        if (globalSearchScope == null) {
            JSLibraryUtil.$$$reportNull$$$0(28);
        }
        return globalSearchScope;
    }

    static {
        MIN_TO_DEV_VERSION_MAP.put("dojo.xd.js", "dojo.xd.js.uncompressed.js");
        MIN_TO_DEV_VERSION_MAP.put("dojo.js", "dojo.js.uncompressed.js");
        MIN_TO_DEV_VERSION_MAP.put("ext-core.js", "ext-core-debug.js");
        MIN_TO_DEV_VERSION_MAP.put("swfobject.js", "swfobject_src.js");
        MIN_TO_DEV_VERSION_MAP.put("webfont.js", "webfont_debug.js");
        HTTP_PREFIXES = new String[]{"http://", "https://"};
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 28: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 28: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "location";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 9: 
            case 10: 
            case 12: 
            case 14: 
            case 16: 
            case 18: 
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "libraryFolder";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fileOrDir";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "libraryName";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parentLibraryFolder";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parentLibraryFolders";
                break;
            }
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dirNames";
                break;
            }
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "directoryName";
                break;
            }
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "localFileSystem";
                break;
            }
            case 20: 
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "ioFile";
                break;
            }
            case 23: {
                objectArray2 = objectArray3;
                objectArray3[0] = "libFileName";
                break;
            }
            case 24: {
                objectArray2 = objectArray3;
                objectArray3[0] = "cache";
                break;
            }
            case 25: 
            case 27: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 26: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fileIndex";
                break;
            }
            case 28: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/javascript/library/JSLibraryUtil";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/javascript/library/JSLibraryUtil";
                break;
            }
            case 28: {
                objectArray = objectArray2;
                objectArray2[1] = "getContentScopeWithoutLibraries";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getDevVersionLocation";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "isProbableLibraryFile";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "isPredefinedLibraryFile";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "getTopLibraryFolder";
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "findAncestorLibraryDir";
                break;
            }
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "getLibraryFolder";
                break;
            }
            case 14: 
            case 15: 
            case 16: 
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "hasDirectoryInPath";
                break;
            }
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "isProbableLibraryPath";
                break;
            }
            case 19: 
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "findFileByIoFile";
                break;
            }
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "findUpClosestNodeModulesResolveRoot";
                break;
            }
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "findFileByIO";
                break;
            }
            case 23: 
            case 24: {
                objectArray = objectArray;
                objectArray[2] = "cacheFile";
                break;
            }
            case 25: 
            case 26: {
                objectArray = objectArray;
                objectArray[2] = "getContentRootForFile";
                break;
            }
            case 27: {
                objectArray = objectArray;
                objectArray[2] = "getContentScopeWithoutLibraries";
                break;
            }
            case 28: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 28: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

