/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.linter.eslint;

import com.intellij.codeInsight.intention.IntentionAction;
import com.intellij.history.LocalHistory;
import com.intellij.ide.actions.OpenFileAction;
import com.intellij.lang.javascript.JSBundle;
import com.intellij.lang.javascript.linter.JSLinterAnnotationResult;
import com.intellij.lang.javascript.linter.JSLinterError;
import com.intellij.lang.javascript.linter.JSLinterState;
import com.intellij.lang.javascript.linter.jscs.JscsConfiguration;
import com.intellij.notification.Notification;
import com.intellij.notification.NotificationListener;
import com.intellij.notification.NotificationType;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.util.PsiEditorUtil;
import com.intellij.util.Function;
import com.intellij.util.containers.MultiMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.swing.event.HyperlinkEvent;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class JSLinterReformatterTask
extends Task.Backgroundable {
    @NotNull
    private final String myLinterName;
    @NotNull
    private final Collection<VirtualFile> myRoots;
    @NotNull
    private final Runnable myCompleteCallback;
    private MultiMap<VirtualFile, Pair<String, IntentionAction[]>> myProblems;

    public JSLinterReformatterTask(@Nullable Project project, @Nls(capitalization=Nls.Capitalization.Title) @NotNull String linterName, @NotNull Collection<VirtualFile> roots, @NotNull Runnable completeCallback) {
        if (linterName == null) {
            JSLinterReformatterTask.$$$reportNull$$$0(0);
        }
        if (roots == null) {
            JSLinterReformatterTask.$$$reportNull$$$0(1);
        }
        if (completeCallback == null) {
            JSLinterReformatterTask.$$$reportNull$$$0(2);
        }
        super(project, "Reformatting with " + linterName + "...");
        this.myProblems = new MultiMap();
        this.myLinterName = linterName;
        this.myRoots = roots;
        this.myCompleteCallback = completeCallback;
        LocalHistory.getInstance().putSystemLabel(this.myProject, JSBundle.message((String)"javascript.linter.action.fix.problems.name.start", (Object[])new Object[]{this.myLinterName}));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run(@NotNull ProgressIndicator indicator) {
        if (indicator == null) {
            JSLinterReformatterTask.$$$reportNull$$$0(3);
        }
        try {
            for (VirtualFile file : this.myRoots) {
                if (file.isDirectory()) continue;
                String parentPath = file.getParent() == null ? "" : " (" + file.getParent().getPath() + ")";
                indicator.setText("Processing " + file.getName() + parentPath);
                this.formatFile(file);
            }
        }
        finally {
            this.myCompleteCallback.run();
        }
    }

    public void onSuccess() {
        if (!this.myProblems.isEmpty()) {
            new MyNotification(this.myProject, this.myLinterName, this.myProblems).showNotification();
        }
    }

    protected <T extends JSLinterState> void processLinterRunnerOutput(VirtualFile file, JSLinterAnnotationResult<T> result2, boolean onlyFileLevel) {
        if (result2 != null) {
            List<JSLinterError> errors;
            if (result2.getFileLevelError() != null) {
                this.error(file, result2.getFileLevelError().getMessage(), new IntentionAction[0]);
            }
            if (!onlyFileLevel && !(errors = result2.getErrors()).isEmpty()) {
                for (JSLinterError error : errors) {
                    this.error(file, error.getDescription(), new IntentionAction[0]);
                }
            }
        }
    }

    private void formatFile(VirtualFile file) {
        ApplicationManager.getApplication().runReadAction(() -> {
            PsiFile psiFile = PsiManager.getInstance((Project)this.myProject).findFile(file);
            if (psiFile == null) {
                this.error(file, "Can not find PSI file for " + file.getPath(), new IntentionAction[0]);
                return;
            }
            Document document = PsiDocumentManager.getInstance((Project)this.myProject).getDocument(psiFile);
            if (document == null) {
                this.error(file, "Can not find Document for " + psiFile.getName(), new IntentionAction[0]);
                return;
            }
            this.runLinter(psiFile, document);
        });
    }

    protected void error(@NotNull VirtualFile file, String error, IntentionAction ... fixes) {
        if (file == null) {
            JSLinterReformatterTask.$$$reportNull$$$0(4);
        }
        this.myProblems.putValue((Object)file, (Object)Pair.create((Object)error, (Object)fixes));
    }

    protected abstract void runLinter(@NotNull PsiFile var1, @NotNull Document var2);

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "linterName";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "roots";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "completeCallback";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "indicator";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
        }
        objectArray2[1] = "com/intellij/lang/javascript/linter/eslint/JSLinterReformatterTask";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "run";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "error";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    private static class MyNotification {
        private final List<IntentionAction> intentions;
        private final List<VirtualFile> files;
        @NotNull
        private final Project myProject;
        @NotNull
        private final String myLinterName;
        private String myMessage;

        public MyNotification(@NotNull Project project, @NotNull String linterName, @NotNull MultiMap<VirtualFile, Pair<String, IntentionAction[]>> problems) {
            if (project == null) {
                MyNotification.$$$reportNull$$$0(0);
            }
            if (linterName == null) {
                MyNotification.$$$reportNull$$$0(1);
            }
            if (problems == null) {
                MyNotification.$$$reportNull$$$0(2);
            }
            this.intentions = new ArrayList<IntentionAction>();
            this.files = new ArrayList<VirtualFile>();
            this.myProject = project;
            this.myLinterName = linterName;
            if (problems.isEmpty()) {
                return;
            }
            this.myMessage = this.fillData(problems);
        }

        private String fillData(MultiMap<VirtualFile, Pair<String, IntentionAction[]>> problems) {
            Function function = entry -> {
                String path = ((VirtualFile)entry.getKey()).getPath();
                StringBuilder sb = new StringBuilder("<a href= '#file" + path + "'>" + ((VirtualFile)entry.getKey()).getName() + "</a>: ");
                boolean withComma = false;
                for (Pair pair : (Collection)entry.getValue()) {
                    if (withComma) {
                        sb.append("<br/>");
                    }
                    withComma = true;
                    if (((IntentionAction[])pair.getSecond()).length > 0) {
                        sb.append((String)pair.getFirst()).append(' ').append(StringUtil.join((Object[])((Object[])pair.getSecond()), action -> {
                            this.intentions.add((IntentionAction)action);
                            this.files.add((VirtualFile)entry.getKey());
                            return "<a href='#action" + (this.intentions.size() - 1) + "'>" + action.getText() + "</a>";
                        }, (String)", "));
                        continue;
                    }
                    sb.append((String)pair.getFirst());
                }
                return sb.toString();
            };
            return StringUtil.join((Collection)problems.entrySet(), (Function)function, (String)"<br/>");
        }

        public void showNotification() {
            if (this.myMessage == null || this.myMessage.isEmpty()) {
                return;
            }
            JscsConfiguration.NOTIFICATION_GROUP.createNotification("", "Problem with " + this.myLinterName + " reformatting:<br/>" + this.myMessage, NotificationType.ERROR, (NotificationListener)new MyNotificationListener()).notify(this.myProject);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "project";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "linterName";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[0] = "problems";
                    break;
                }
            }
            objectArray[1] = "com/intellij/lang/javascript/linter/eslint/JSLinterReformatterTask$MyNotification";
            objectArray[2] = "<init>";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }

        private class MyNotificationListener
        implements NotificationListener {
            private MyNotificationListener() {
            }

            public void hyperlinkUpdate(@NotNull Notification notification2, @NotNull HyperlinkEvent event) {
                String description;
                if (notification2 == null) {
                    MyNotificationListener.$$$reportNull$$$0(0);
                }
                if (event == null) {
                    MyNotificationListener.$$$reportNull$$$0(1);
                }
                if ((description = event.getDescription()) != null && description.startsWith("#file")) {
                    String path = description.substring(5);
                    OpenFileAction.openFile((String)path, (Project)MyNotification.this.myProject);
                } else if (description != null && description.startsWith("#action")) {
                    String number = description.substring(6);
                    try {
                        int idx = Integer.parseInt(number);
                        if (idx >= 0 && idx < MyNotification.this.intentions.size()) {
                            VirtualFile file = (VirtualFile)MyNotification.this.files.get(idx);
                            PsiFile psiFile = null;
                            Editor editor = null;
                            if (file != null && (psiFile = PsiManager.getInstance((Project)MyNotification.this.myProject).findFile(file)) != null) {
                                editor = PsiEditorUtil.Service.getInstance().findEditorByPsiElement((PsiElement)psiFile);
                            }
                            ((IntentionAction)MyNotification.this.intentions.get(idx)).invoke(MyNotification.this.myProject, editor, psiFile);
                        }
                    }
                    catch (NumberFormatException numberFormatException) {
                        // empty catch block
                    }
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[3];
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[0] = "notification";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[0] = "event";
                        break;
                    }
                }
                objectArray[1] = "com/intellij/lang/javascript/linter/eslint/JSLinterReformatterTask$MyNotification$MyNotificationListener";
                objectArray[2] = "hyperlinkUpdate";
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        }
    }
}

