/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.linter.jscs;

import com.intellij.codeInsight.daemon.HighlightDisplayKey;
import com.intellij.codeInsight.daemon.impl.actions.SuppressByCommentFix;
import com.intellij.codeInspection.SuppressQuickFix;
import com.intellij.lang.javascript.JSBundle;
import com.intellij.lang.javascript.formatter.JSCodeStyleSettings;
import com.intellij.lang.javascript.inspections.JSInspectionSuppressor;
import com.intellij.lang.javascript.linter.JSLinterInspection;
import com.intellij.lang.javascript.linter.JSLinterUtil;
import com.intellij.lang.javascript.linter.jscs.JscsExternalAnnotator;
import com.intellij.lang.javascript.psi.JSElement;
import com.intellij.openapi.command.CommandProcessor;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiComment;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.search.PsiElementProcessor;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.IncorrectOperationException;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JscsInspection
extends JSLinterInspection {
    @Override
    @NotNull
    protected JscsExternalAnnotator getExternalAnnotatorForBatchInspection() {
        JscsExternalAnnotator jscsExternalAnnotator = JscsExternalAnnotator.getInstanceForBatchInspection();
        if (jscsExternalAnnotator == null) {
            JscsInspection.$$$reportNull$$$0(0);
        }
        return jscsExternalAnnotator;
    }

    public static HighlightDisplayKey getHighlightDisplayKey() {
        return JscsInspection.getHighlightDisplayKeyByClass(JscsInspection.class);
    }

    @Nls
    @NotNull
    public String getDisplayName() {
        String string = JSBundle.message((String)"settings.javascript.linters.jscs.configurable.name", (Object[])new Object[0]);
        if (string == null) {
            JscsInspection.$$$reportNull$$$0(1);
        }
        return string;
    }

    @NotNull
    public SuppressQuickFix[] getBatchSuppressActions(@Nullable PsiElement element) {
        SuppressQuickFix[] suppressQuickFixArray = new SuppressQuickFix[]{new JscsSuppressForFileByCommentFix(HighlightDisplayKey.find((String)this.getShortName()), JSInspectionSuppressor.getHolderClass(element)), new JscsSuppressForLineByCommentFix(HighlightDisplayKey.find((String)this.getShortName()), JSInspectionSuppressor.getHolderClass(element))};
        if (suppressQuickFixArray == null) {
            JscsInspection.$$$reportNull$$$0(2);
        }
        return suppressQuickFixArray;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[2];
        objectArray2[0] = "com/intellij/lang/javascript/linter/jscs/JscsInspection";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getExternalAnnotatorForBatchInspection";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getDisplayName";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getBatchSuppressActions";
                break;
            }
        }
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
    }

    private static class JscsSuppressForFileByCommentFix
    extends SuppressByCommentFix {
        public JscsSuppressForFileByCommentFix(@NotNull HighlightDisplayKey key, @NotNull Class<? extends PsiElement> suppressionHolderClass) {
            if (key == null) {
                JscsSuppressForFileByCommentFix.$$$reportNull$$$0(0);
            }
            if (suppressionHolderClass == null) {
                JscsSuppressForFileByCommentFix.$$$reportNull$$$0(1);
            }
            super(key, suppressionHolderClass);
        }

        @NotNull
        public String getText() {
            if ("Suppress all JSCS rules for file" == null) {
                JscsSuppressForFileByCommentFix.$$$reportNull$$$0(2);
            }
            return "Suppress all JSCS rules for file";
        }

        protected void createSuppression(@NotNull Project project, @NotNull PsiElement element, @NotNull PsiElement container) throws IncorrectOperationException {
            Document document;
            if (project == null) {
                JscsSuppressForFileByCommentFix.$$$reportNull$$$0(3);
            }
            if (element == null) {
                JscsSuppressForFileByCommentFix.$$$reportNull$$$0(4);
            }
            if (container == null) {
                JscsSuppressForFileByCommentFix.$$$reportNull$$$0(5);
            }
            if ((document = JSLinterUtil.getDocumentForElement(element)) == null) {
                return;
            }
            CommandProcessor.getInstance().executeCommand(project, () -> {
                if (container == null) {
                    JscsSuppressForFileByCommentFix.$$$reportNull$$$0(6);
                }
                document.insertString(0, (CharSequence)String.format("//%sjscs:disable\n", JSCodeStyleSettings.getLineCommentPrefix(container)));
            }, null, null);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 2: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 2: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "key";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "suppressionHolderClass";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/lang/javascript/linter/jscs/JscsInspection$JscsSuppressForFileByCommentFix";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "element";
                    break;
                }
                case 5: 
                case 6: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "container";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/lang/javascript/linter/jscs/JscsInspection$JscsSuppressForFileByCommentFix";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getText";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 2: {
                    break;
                }
                case 3: 
                case 4: 
                case 5: {
                    objectArray = objectArray;
                    objectArray[2] = "createSuppression";
                    break;
                }
                case 6: {
                    objectArray = objectArray;
                    objectArray[2] = "lambda$createSuppression$0";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 2: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    public static class JscsSuppressForLineByCommentFix
    extends SuppressByCommentFix {
        public JscsSuppressForLineByCommentFix(@NotNull HighlightDisplayKey key, @NotNull Class<? extends PsiElement> suppressionHolderClass) {
            if (key == null) {
                JscsSuppressForLineByCommentFix.$$$reportNull$$$0(0);
            }
            if (suppressionHolderClass == null) {
                JscsSuppressForLineByCommentFix.$$$reportNull$$$0(1);
            }
            super(key, suppressionHolderClass);
        }

        @NotNull
        public String getText() {
            if ("Suppress all JSCS rules for current line" == null) {
                JscsSuppressForLineByCommentFix.$$$reportNull$$$0(2);
            }
            return "Suppress all JSCS rules for current line";
        }

        protected void createSuppression(@NotNull Project project, @NotNull PsiElement element, @NotNull PsiElement container) throws IncorrectOperationException {
            Document document;
            if (project == null) {
                JscsSuppressForLineByCommentFix.$$$reportNull$$$0(3);
            }
            if (element == null) {
                JscsSuppressForLineByCommentFix.$$$reportNull$$$0(4);
            }
            if (container == null) {
                JscsSuppressForLineByCommentFix.$$$reportNull$$$0(5);
            }
            if ((document = JSLinterUtil.getDocumentForElement(element)) == null) {
                return;
            }
            int lineNo = document.getLineNumber(element.getTextOffset());
            JscsSuppressForLineByCommentFix.suppressRuleForLine(project, document, element.getContainingFile(), lineNo, element.getTextOffset(), "");
        }

        public static void suppressRuleForLine(Project project, Document document, PsiFile file, int line, int elementOffset, String rule) {
            CommandProcessor.getInstance().executeCommand(project, () -> {
                String commentPrefix;
                int lineEndOffset = document.getLineEndOffset(line);
                PsiElement contextElement = file.findElementAt(elementOffset);
                String string = commentPrefix = contextElement instanceof JSElement ? JSCodeStyleSettings.getLineCommentPrefix((PsiElement)file) : " ";
                if (!JscsSuppressForLineByCommentFix.lineHasComments(document, file, line, elementOffset)) {
                    document.insertString(lineEndOffset, (CharSequence)String.format("//%sjscs:ignore %s", commentPrefix, rule));
                } else {
                    int lineStartOffset = document.getLineStartOffset(line);
                    document.insertString(lineEndOffset, (CharSequence)String.format("\n//%sjscs:enable %s", commentPrefix, rule));
                    document.insertString(lineStartOffset, (CharSequence)String.format("//%sjscs:disable %s\n", commentPrefix, rule));
                }
            }, null, null);
        }

        private static boolean lineHasComments(Document document, PsiFile file, int line, final int elementOffset) {
            final boolean[] result2 = new boolean[1];
            final int endOffset = document.getLineEndOffset(line);
            PsiTreeUtil.processElements((PsiElement)file, (PsiElementProcessor)new PsiElementProcessor(){

                public boolean execute(@NotNull PsiElement element) {
                    if (element == null) {
                        1.$$$reportNull$$$0(0);
                    }
                    TextRange range = element.getTextRange();
                    if (element instanceof PsiComment && range.getStartOffset() > elementOffset && range.getStartOffset() < endOffset) {
                        result2[0] = true;
                        return false;
                    }
                    return true;
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/lang/javascript/linter/jscs/JscsInspection$JscsSuppressForLineByCommentFix$1", "execute"));
                }
            });
            return result2[0];
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 2: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 2: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "key";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "suppressionHolderClass";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/lang/javascript/linter/jscs/JscsInspection$JscsSuppressForLineByCommentFix";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "element";
                    break;
                }
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "container";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/lang/javascript/linter/jscs/JscsInspection$JscsSuppressForLineByCommentFix";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getText";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 2: {
                    break;
                }
                case 3: 
                case 4: 
                case 5: {
                    objectArray = objectArray;
                    objectArray[2] = "createSuppression";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 2: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }
}

