/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.modules;

import com.intellij.codeInsight.hint.QuestionAction;
import com.intellij.codeInsight.navigation.NavigationUtil;
import com.intellij.ide.util.PsiElementListCellRenderer;
import com.intellij.lang.ecmascript6.psi.JSExportAssignment;
import com.intellij.lang.ecmascript6.psi.impl.ES6CreateImportUtil;
import com.intellij.lang.ecmascript6.psi.impl.ES6ImportPsiUtil;
import com.intellij.lang.ecmascript6.resolve.ES6PsiUtil;
import com.intellij.lang.javascript.JSBundle;
import com.intellij.lang.javascript.JSTokenTypes;
import com.intellij.lang.javascript.ecmascript6.ES6QualifiedNamedElementRenderer;
import com.intellij.lang.javascript.flex.JSQualifiedNamedElementRenderer;
import com.intellij.lang.javascript.frameworks.react.ReactXmlExtension;
import com.intellij.lang.javascript.inspections.FileHeaderKeeper;
import com.intellij.lang.javascript.library.JSLibraryUtil;
import com.intellij.lang.javascript.modules.JSImportPlaceInfo;
import com.intellij.lang.javascript.modules.JSModuleNameInfo;
import com.intellij.lang.javascript.psi.JSElement;
import com.intellij.lang.javascript.psi.JSExpressionCodeFragment;
import com.intellij.lang.javascript.psi.JSFile;
import com.intellij.lang.javascript.psi.JSReferenceExpression;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptModule;
import com.intellij.lang.javascript.psi.ecmal4.JSQualifiedNamedElement;
import com.intellij.lang.javascript.psi.stubs.ES6DefaultAssignmentModuleIndex;
import com.intellij.lang.javascript.psi.stubs.JSSymbolIndex2;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.application.TransactionGuard;
import com.intellij.openapi.application.WriteAction;
import com.intellij.openapi.command.CommandProcessor;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.ResolveResult;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.search.PsiElementProcessor;
import com.intellij.psi.stubs.StubIndex;
import com.intellij.psi.util.PsiUtilCore;
import com.intellij.util.Consumer;
import com.intellij.util.Processor;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ES6ImportAction
implements QuestionAction {
    public static final Key<Boolean> NO_HINT_KEY = Key.create((String)"ES6.auto.import.no.hint");
    public static final ImportElementFilter DEFAULT_FILTER = new DefaultElementFilter();
    @Nullable
    protected final Editor myEditor;
    @Nullable
    protected final String myName;
    @Nullable
    protected final PsiElement myContext;
    protected final ImportElementFilter myFilter;

    public ES6ImportAction(@Nullable Editor editor, @Nullable PsiElement context, @Nullable String name, @NotNull ImportElementFilter filter) {
        if (filter == null) {
            ES6ImportAction.$$$reportNull$$$0(0);
        }
        this.myContext = context;
        this.myEditor = editor;
        this.myName = name;
        this.myFilter = filter;
    }

    public boolean execute() {
        this.executeForAllVariants();
        return true;
    }

    public void executeForAllVariants() {
        this.executeForAllVariants(null);
    }

    public void executeForAllVariants(@Nullable Consumer<JSElement> postProcess) {
        ApplicationManager.getApplication().assertIsDispatchThread();
        if (this.myContext == null || this.myName == null || !this.myContext.isValid()) {
            return;
        }
        if (!this.myFilter.isValidContext(this.myContext)) {
            return;
        }
        List<JSElement> candidates = this.getCandidates();
        if (candidates.isEmpty()) {
            return;
        }
        if (candidates.size() == 1 || this.myEditor == null) {
            this.addImport(candidates, postProcess);
        } else {
            HashMap preRenderedQNames = ContainerUtil.newHashMap();
            Project project = this.myContext.getProject();
            Collection<JSElement> elementsFromLibraries = ES6ImportAction.getElementsFromLibraries(project, candidates);
            PsiFile file = this.myContext.getContainingFile();
            if (elementsFromLibraries.isEmpty()) {
                List<JSElement> finalElements = ES6ImportAction.getFinalElements(project, file, candidates, elementsFromLibraries, preRenderedQNames);
                if (finalElements.size() == 1) {
                    this.addImport(candidates, postProcess);
                } else {
                    this.setNoHintFlag(true);
                    this.showPopup(finalElements, preRenderedQNames, postProcess);
                }
                return;
            }
            Runnable calcModuleNamesAndShowPopupIfNecessary = () -> {
                List newCandidates = (List)ReadAction.compute(() -> ES6ImportAction.getFinalElements(project, file, candidates, elementsFromLibraries, preRenderedQNames));
                TransactionGuard.submitTransaction((Disposable)project, () -> {
                    this.setNoHintFlag(false);
                    if (newCandidates.isEmpty() || !this.myContext.isValid() || this.myEditor.isDisposed()) {
                        return;
                    }
                    if (newCandidates.size() == 1) {
                        JSElement item = (JSElement)ContainerUtil.getFirstItem((List)newCandidates);
                        assert (item != null);
                        if (!item.isValid()) {
                            return;
                        }
                        Runnable runnable = () -> this.executeFor(item, postProcess);
                        CommandProcessor.getInstance().executeCommand(item.getProject(), runnable, this.getClass().getName(), (Object)this);
                        return;
                    }
                    this.showPopup(newCandidates, preRenderedQNames, postProcess);
                });
            };
            this.setNoHintFlag(true);
            if (ApplicationManager.getApplication().isUnitTestMode()) {
                calcModuleNamesAndShowPopupIfNecessary.run();
            } else {
                ApplicationManager.getApplication().executeOnPooledThread(calcModuleNamesAndShowPopupIfNecessary);
            }
        }
    }

    private void setNoHintFlag(boolean value) {
        if (this.myContext == null || !this.myContext.isValid()) {
            return;
        }
        PsiElement toSet = this.myContext;
        if (this.myContext.getNode().getElementType() == JSTokenTypes.IDENTIFIER) {
            this.myContext.putUserData(NO_HINT_KEY, (Object)value);
            PsiElement parent = this.myContext.getParent();
            toSet = parent == null ? toSet : parent;
        }
        toSet.putUserData(NO_HINT_KEY, (Object)value);
    }

    private void addImport(List<JSElement> candidates, @Nullable Consumer<JSElement> postProcess) {
        JSElement candidate = candidates.iterator().next();
        this.executeFor(candidate, postProcess);
    }

    public void executeWithoutPrepare(@NotNull JSElement candidate) {
        if (candidate == null) {
            ES6ImportAction.$$$reportNull$$$0(1);
        }
        assert (this.myContext != null && this.myName != null);
        this.runAction(this.myEditor, this.myName, candidate, this.myContext);
    }

    public void executeFor(@NotNull JSElement candidate, @Nullable Consumer<JSElement> postProcess) {
        if (candidate == null) {
            ES6ImportAction.$$$reportNull$$$0(2);
        }
        assert (this.myContext != null && this.myName != null);
        FileHeaderKeeper keeper = new FileHeaderKeeper(ES6CreateImportUtil.getExternalModuleScope(this.myContext));
        this.executeWithoutPrepare(candidate);
        if (postProcess != null || keeper.canMove()) {
            CommandProcessor.getInstance().runUndoTransparentAction(() -> {
                if (candidate == null) {
                    ES6ImportAction.$$$reportNull$$$0(44);
                }
                WriteAction.run(() -> {
                    if (candidate == null) {
                        ES6ImportAction.$$$reportNull$$$0(45);
                    }
                    if (postProcess != null) {
                        postProcess.consume((Object)candidate);
                    }
                    if (keeper.canMove()) {
                        if (this.myEditor != null && !this.myEditor.isDisposed()) {
                            Document document = this.myEditor.getDocument();
                            PsiDocumentManager.getInstance((Project)candidate.getProject()).commitDocument(document);
                        }
                        keeper.moveHeader();
                    }
                });
            });
        }
    }

    @NotNull
    public List<JSElement> getCandidates() {
        if (!this.isContextValid(this.myContext) || this.myName == null) {
            List list = ContainerUtil.emptyList();
            if (list == null) {
                ES6ImportAction.$$$reportNull$$$0(3);
            }
            return list;
        }
        GlobalSearchScope scope = ES6CreateImportUtil.createSymbolToImportSearchScope(this.myContext.getProject(), this.myContext);
        JSImportPlaceInfo info = new JSImportPlaceInfo(this.myContext);
        ArrayList candidates = ContainerUtil.newArrayList();
        Processor processor = toProcess -> {
            if (ES6CreateImportUtil.isAvailableForImport((PsiElement)toProcess, info)) {
                candidates.add(toProcess);
            }
            return true;
        };
        StubIndex.getInstance().processElements(JSSymbolIndex2.KEY, (Object)this.myName, this.myContext.getProject(), scope, JSElement.class, processor);
        Processor assignmentProcessor = toProcess -> {
            JSElement expression = toProcess.getStubSafeElement();
            if (expression instanceof JSQualifiedNamedElement) {
                if (expression.getName() == null) {
                    candidates.add(expression);
                }
            } else {
                candidates.add(toProcess);
            }
            return true;
        };
        StubIndex.getInstance().processElements(ES6DefaultAssignmentModuleIndex.KEY, (Object)this.myName, this.myContext.getProject(), scope, JSExportAssignment.class, assignmentProcessor);
        List<JSElement> result2 = this.additionalProcessCandidates(info, candidates);
        List<JSElement> list = this.myFilter.filterByContext(this.myContext, result2);
        if (list == null) {
            ES6ImportAction.$$$reportNull$$$0(4);
        }
        return list;
    }

    @Contract(value="null -> false")
    protected boolean isContextValid(@Nullable PsiElement context) {
        ApplicationManager.getApplication().assertReadAccessAllowed();
        if (context == null || !context.isValid()) {
            return false;
        }
        Project project = context.getProject();
        return !DumbService.isDumb((Project)project) && !project.isDisposed();
    }

    @NotNull
    protected List<JSElement> additionalProcessCandidates(@NotNull JSImportPlaceInfo info, @NotNull List<JSElement> candidates) {
        if (info == null) {
            ES6ImportAction.$$$reportNull$$$0(5);
        }
        if (candidates == null) {
            ES6ImportAction.$$$reportNull$$$0(6);
        }
        List<JSElement> list = candidates;
        if (list == null) {
            ES6ImportAction.$$$reportNull$$$0(7);
        }
        return list;
    }

    protected void runAction(@Nullable Editor editor, @NotNull String name, @NotNull JSElement elementToImport, @NotNull PsiElement place) {
        if (name == null) {
            ES6ImportAction.$$$reportNull$$$0(8);
        }
        if (elementToImport == null) {
            ES6ImportAction.$$$reportNull$$$0(9);
        }
        if (place == null) {
            ES6ImportAction.$$$reportNull$$$0(10);
        }
        assert (this.myContext != null);
        PsiFile containingFile = this.myContext.getContainingFile();
        if (containingFile instanceof JSExpressionCodeFragment) {
            ((JSExpressionCodeFragment)containingFile).importElement(elementToImport);
        } else {
            WriteAction.run(() -> {
                if (name == null) {
                    ES6ImportAction.$$$reportNull$$$0(42);
                }
                if (elementToImport == null) {
                    ES6ImportAction.$$$reportNull$$$0(43);
                }
                ES6ImportPsiUtil.insertJSImport(this.myContext, name, (PsiElement)elementToImport, editor);
            });
        }
    }

    @NotNull
    private static List<JSElement> getFinalElements(@NotNull Project project, @NotNull PsiFile file, @NotNull List<JSElement> candidates, @NotNull Collection<JSElement> elementsFromLibraries, @NotNull Map<PsiElement, String> renderedTexts) {
        if (project == null) {
            ES6ImportAction.$$$reportNull$$$0(11);
        }
        if (file == null) {
            ES6ImportAction.$$$reportNull$$$0(12);
        }
        if (candidates == null) {
            ES6ImportAction.$$$reportNull$$$0(13);
        }
        if (elementsFromLibraries == null) {
            ES6ImportAction.$$$reportNull$$$0(14);
        }
        if (renderedTexts == null) {
            ES6ImportAction.$$$reportNull$$$0(15);
        }
        if (!file.isValid() || project.isDisposed() || !project.isOpen()) {
            List list = ContainerUtil.emptyList();
            if (list == null) {
                ES6ImportAction.$$$reportNull$$$0(16);
            }
            return list;
        }
        candidates = ES6ImportAction.removeMergedElements(candidates, elementsFromLibraries);
        if (elementsFromLibraries.isEmpty()) {
            List<JSElement> list = candidates;
            if (list == null) {
                ES6ImportAction.$$$reportNull$$$0(17);
            }
            return list;
        }
        HashMap modulesInfos = ContainerUtil.newHashMap();
        ES6ImportAction.fillExternalModuleNames(project, modulesInfos, elementsFromLibraries, file);
        modulesInfos.forEach((el, info) -> {
            if (renderedTexts == null) {
                ES6ImportAction.$$$reportNull$$$0(41);
            }
            renderedTexts.put((PsiElement)el, info.getPath());
        });
        List<JSElement> list = ES6ImportAction.removeSimilarLibraryModules(candidates, modulesInfos);
        if (list == null) {
            ES6ImportAction.$$$reportNull$$$0(18);
        }
        return list;
    }

    private void showPopup(@NotNull List<JSElement> candidates, @NotNull Map<PsiElement, String> preRenderedQNames, @Nullable Consumer<JSElement> postProcess) {
        if (candidates == null) {
            ES6ImportAction.$$$reportNull$$$0(19);
        }
        if (preRenderedQNames == null) {
            ES6ImportAction.$$$reportNull$$$0(20);
        }
        ApplicationManager.getApplication().assertIsDispatchThread();
        if (ApplicationManager.getApplication().isUnitTestMode()) {
            return;
        }
        assert (this.myEditor != null);
        if (this.myEditor.isDisposed()) {
            return;
        }
        NavigationUtil.getPsiElementPopup((PsiElement[])((PsiElement[])candidates.toArray(JSElement.EMPTY_ARRAY)), this.createRenderer(preRenderedQNames), (String)JSBundle.message((String)"choose.class.to.import.title", (Object[])new Object[0]), this.createModuleProcessor(postProcess)).showInBestPositionFor(this.myEditor);
    }

    @NotNull
    private PsiElementProcessor<JSElement> createModuleProcessor(final @Nullable Consumer<JSElement> postProcess) {
        PsiElementProcessor<JSElement> psiElementProcessor = new PsiElementProcessor<JSElement>(){

            public boolean execute(@NotNull JSElement element) {
                if (element == null) {
                    1.$$$reportNull$$$0(0);
                }
                CommandProcessor.getInstance().executeCommand(element.getProject(), () -> {
                    if (element == null) {
                        1.$$$reportNull$$$0(1);
                    }
                    if (ES6ImportAction.this.myContext == null || !ES6ImportAction.this.myContext.isValid() || !element.isValid()) {
                        return;
                    }
                    assert (ES6ImportAction.this.myName != null);
                    ES6ImportAction.this.executeFor(element, (Consumer<JSElement>)postProcess);
                }, this.getClass().getName(), (Object)this);
                return false;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[3];
                objectArray2[0] = "element";
                objectArray2[1] = "com/intellij/lang/javascript/modules/ES6ImportAction$1";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[2] = "execute";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[2] = "lambda$execute$0";
                        break;
                    }
                }
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        };
        if (psiElementProcessor == null) {
            ES6ImportAction.$$$reportNull$$$0(21);
        }
        return psiElementProcessor;
    }

    @NotNull
    protected PsiElementListCellRenderer<JSElement> createRenderer(final @NotNull Map<PsiElement, String> preRenderedQNames) {
        if (preRenderedQNames == null) {
            ES6ImportAction.$$$reportNull$$$0(22);
        }
        ES6QualifiedNamedElementRenderer<JSElement> eS6QualifiedNamedElementRenderer = new ES6QualifiedNamedElementRenderer<JSElement>(){

            @Override
            protected String getContainerText(JSElement element, String name) {
                String preRenderedQName = (String)preRenderedQNames.get(element);
                if (!StringUtil.isEmpty((String)preRenderedQName)) {
                    return "(" + preRenderedQName + ")";
                }
                return super.getContainerText(element, name);
            }
        };
        if (eS6QualifiedNamedElementRenderer == null) {
            ES6ImportAction.$$$reportNull$$$0(23);
        }
        return eS6QualifiedNamedElementRenderer;
    }

    private static void fillExternalModuleNames(@NotNull Project project, @NotNull Map<PsiElement, JSModuleNameInfo> renderedText, @NotNull Collection<JSElement> elementsFromLibraries, @NotNull PsiFile file) {
        if (project == null) {
            ES6ImportAction.$$$reportNull$$$0(24);
        }
        if (renderedText == null) {
            ES6ImportAction.$$$reportNull$$$0(25);
        }
        if (elementsFromLibraries == null) {
            ES6ImportAction.$$$reportNull$$$0(26);
        }
        if (file == null) {
            ES6ImportAction.$$$reportNull$$$0(27);
        }
        ApplicationManager.getApplication().assertReadAccessAllowed();
        for (JSElement element : elementsFromLibraries) {
            JSModuleNameInfo nameToModule = ES6CreateImportUtil.getExternalFileModuleName(element, (PsiElement)file);
            if (nameToModule == null) continue;
            renderedText.put((PsiElement)element, nameToModule);
        }
    }

    private static boolean checkReferenceExpressionAcceptable(@NotNull JSReferenceExpression referenceExpression) {
        if (referenceExpression == null) {
            ES6ImportAction.$$$reportNull$$$0(28);
        }
        if (referenceExpression.getQualifier() != null) {
            return false;
        }
        ResolveResult[] results = referenceExpression.multiResolve(false);
        boolean hasValidResult = false;
        for (ResolveResult result2 : results) {
            if (!result2.isValidResult()) continue;
            hasValidResult = true;
            break;
        }
        return !hasValidResult;
    }

    @NotNull
    private static Collection<JSElement> getElementsFromLibraries(@NotNull Project project, @NotNull Collection<JSElement> candidates) {
        if (project == null) {
            ES6ImportAction.$$$reportNull$$$0(29);
        }
        if (candidates == null) {
            ES6ImportAction.$$$reportNull$$$0(30);
        }
        Collection collection = candidates.stream().filter(element -> {
            PsiFile file;
            if (project == null) {
                ES6ImportAction.$$$reportNull$$$0(40);
            }
            if (!((file = element.getContainingFile()) instanceof JSFile) || !((JSFile)file).isCommonJSModule()) {
                return false;
            }
            VirtualFile fileToSearch = file.getVirtualFile();
            VirtualFile virtualFile = PsiUtilCore.getVirtualFile((PsiElement)file);
            if (virtualFile == null) {
                return false;
            }
            Pair<VirtualFile, VirtualFile> parentLibraryDirectory = ES6CreateImportUtil.findParentLibraryDirectory(project, fileToSearch, JSLibraryUtil.LIBRARY_DIR_NAMES);
            return parentLibraryDirectory != null;
        }).collect(Collectors.toList());
        if (collection == null) {
            ES6ImportAction.$$$reportNull$$$0(31);
        }
        return collection;
    }

    @NotNull
    private static List<JSElement> removeMergedElements(@NotNull List<JSElement> candidates, @NotNull Collection<JSElement> elementsFromLibraries) {
        if (candidates == null) {
            ES6ImportAction.$$$reportNull$$$0(32);
        }
        if (elementsFromLibraries == null) {
            ES6ImportAction.$$$reportNull$$$0(33);
        }
        HashSet qNames = ContainerUtil.newHashSet();
        HashSet toRemove = ContainerUtil.newHashSet();
        for (JSElement candidate : candidates) {
            PsiElement module;
            String qName;
            if (elementsFromLibraries.contains(candidate) || StringUtil.isEmpty((String)(qName = JSQualifiedNamedElementRenderer.getQualifiedName(candidate))) || (module = ES6PsiUtil.findExternalModule((PsiElement)candidate)) != null || qNames.add(qName)) continue;
            toRemove.add(candidate);
        }
        if (toRemove.isEmpty()) {
            List<JSElement> list = candidates;
            if (list == null) {
                ES6ImportAction.$$$reportNull$$$0(34);
            }
            return list;
        }
        List<JSElement> list = candidates.stream().filter(el -> !toRemove.contains(el)).collect(Collectors.toList());
        if (list == null) {
            ES6ImportAction.$$$reportNull$$$0(35);
        }
        return list;
    }

    @NotNull
    private static List<JSElement> removeSimilarLibraryModules(@NotNull List<JSElement> candidates, @NotNull Map<PsiElement, JSModuleNameInfo> calculatedModules) {
        if (candidates == null) {
            ES6ImportAction.$$$reportNull$$$0(36);
        }
        if (calculatedModules == null) {
            ES6ImportAction.$$$reportNull$$$0(37);
        }
        if (calculatedModules.isEmpty() || calculatedModules.size() == 1) {
            List<JSElement> list = candidates;
            if (list == null) {
                ES6ImportAction.$$$reportNull$$$0(38);
            }
            return list;
        }
        HashSet toRemove = ContainerUtil.newHashSet();
        Set<Map.Entry<PsiElement, JSModuleNameInfo>> entries = calculatedModules.entrySet();
        ArrayList toIterate = ContainerUtil.newArrayList(calculatedModules.entrySet());
        HashSet uniqueModuleNamesForSymbols = ContainerUtil.newHashSet();
        HashSet uniqueModuleNamesForModules = ContainerUtil.newHashSet();
        entries.forEach(entry -> {
            JSModuleNameInfo moduleInfo = (JSModuleNameInfo)entry.getValue();
            VirtualFile moduleFileOrDirectory = moduleInfo.getModuleFileOrDirectory();
            PsiElement elementToImport = (PsiElement)entry.getKey();
            String pathText = moduleFileOrDirectory.getPath();
            if (!StringUtil.isEmpty((String)pathText)) {
                if (elementToImport instanceof TypeScriptModule) {
                    if (!uniqueModuleNamesForModules.add(pathText)) {
                        toRemove.add(elementToImport);
                    }
                } else if (!uniqueModuleNamesForSymbols.add(pathText)) {
                    toRemove.add(elementToImport);
                }
            }
            if (!moduleFileOrDirectory.isDirectory()) {
                return;
            }
            toIterate.forEach(second -> {
                JSModuleNameInfo secondModuleInfo = (JSModuleNameInfo)second.getValue();
                VirtualFile secondModuleInfoPathFile = secondModuleInfo.getModuleFileOrDirectory();
                if (secondModuleInfoPathFile.isDirectory() && VfsUtilCore.isAncestor((VirtualFile)secondModuleInfoPathFile, (VirtualFile)moduleFileOrDirectory, (boolean)true) && secondModuleInfoPathFile.findChild("package.json") != null) {
                    toRemove.add(elementToImport);
                }
            });
        });
        List<JSElement> list = candidates.stream().filter(el -> !toRemove.contains(el)).collect(Collectors.toList());
        if (list == null) {
            ES6ImportAction.$$$reportNull$$$0(39);
        }
        return list;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 3: 
            case 4: 
            case 7: 
            case 16: 
            case 17: 
            case 18: 
            case 21: 
            case 23: 
            case 31: 
            case 34: 
            case 35: 
            case 38: 
            case 39: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 3: 
            case 4: 
            case 7: 
            case 16: 
            case 17: 
            case 18: 
            case 21: 
            case 23: 
            case 31: 
            case 34: 
            case 35: 
            case 38: 
            case 39: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "filter";
                break;
            }
            case 1: 
            case 2: 
            case 44: 
            case 45: {
                objectArray2 = objectArray3;
                objectArray3[0] = "candidate";
                break;
            }
            case 3: 
            case 4: 
            case 7: 
            case 16: 
            case 17: 
            case 18: 
            case 21: 
            case 23: 
            case 31: 
            case 34: 
            case 35: 
            case 38: 
            case 39: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/javascript/modules/ES6ImportAction";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "info";
                break;
            }
            case 6: 
            case 13: 
            case 19: 
            case 30: 
            case 32: 
            case 36: {
                objectArray2 = objectArray3;
                objectArray3[0] = "candidates";
                break;
            }
            case 8: 
            case 42: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 9: 
            case 43: {
                objectArray2 = objectArray3;
                objectArray3[0] = "elementToImport";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "place";
                break;
            }
            case 11: 
            case 24: 
            case 29: 
            case 40: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 12: 
            case 27: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 14: 
            case 26: 
            case 33: {
                objectArray2 = objectArray3;
                objectArray3[0] = "elementsFromLibraries";
                break;
            }
            case 15: 
            case 41: {
                objectArray2 = objectArray3;
                objectArray3[0] = "renderedTexts";
                break;
            }
            case 20: 
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "preRenderedQNames";
                break;
            }
            case 25: {
                objectArray2 = objectArray3;
                objectArray3[0] = "renderedText";
                break;
            }
            case 28: {
                objectArray2 = objectArray3;
                objectArray3[0] = "referenceExpression";
                break;
            }
            case 37: {
                objectArray2 = objectArray3;
                objectArray3[0] = "calculatedModules";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/javascript/modules/ES6ImportAction";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getCandidates";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "additionalProcessCandidates";
                break;
            }
            case 16: 
            case 17: 
            case 18: {
                objectArray = objectArray2;
                objectArray2[1] = "getFinalElements";
                break;
            }
            case 21: {
                objectArray = objectArray2;
                objectArray2[1] = "createModuleProcessor";
                break;
            }
            case 23: {
                objectArray = objectArray2;
                objectArray2[1] = "createRenderer";
                break;
            }
            case 31: {
                objectArray = objectArray2;
                objectArray2[1] = "getElementsFromLibraries";
                break;
            }
            case 34: 
            case 35: {
                objectArray = objectArray2;
                objectArray2[1] = "removeMergedElements";
                break;
            }
            case 38: 
            case 39: {
                objectArray = objectArray2;
                objectArray2[1] = "removeSimilarLibraryModules";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "executeWithoutPrepare";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "executeFor";
                break;
            }
            case 3: 
            case 4: 
            case 7: 
            case 16: 
            case 17: 
            case 18: 
            case 21: 
            case 23: 
            case 31: 
            case 34: 
            case 35: 
            case 38: 
            case 39: {
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "additionalProcessCandidates";
                break;
            }
            case 8: 
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "runAction";
                break;
            }
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "getFinalElements";
                break;
            }
            case 19: 
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "showPopup";
                break;
            }
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "createRenderer";
                break;
            }
            case 24: 
            case 25: 
            case 26: 
            case 27: {
                objectArray = objectArray;
                objectArray[2] = "fillExternalModuleNames";
                break;
            }
            case 28: {
                objectArray = objectArray;
                objectArray[2] = "checkReferenceExpressionAcceptable";
                break;
            }
            case 29: 
            case 30: {
                objectArray = objectArray;
                objectArray[2] = "getElementsFromLibraries";
                break;
            }
            case 32: 
            case 33: {
                objectArray = objectArray;
                objectArray[2] = "removeMergedElements";
                break;
            }
            case 36: 
            case 37: {
                objectArray = objectArray;
                objectArray[2] = "removeSimilarLibraryModules";
                break;
            }
            case 40: {
                objectArray = objectArray;
                objectArray[2] = "lambda$getElementsFromLibraries$10";
                break;
            }
            case 41: {
                objectArray = objectArray;
                objectArray[2] = "lambda$getFinalElements$9";
                break;
            }
            case 42: 
            case 43: {
                objectArray = objectArray;
                objectArray[2] = "lambda$runAction$8";
                break;
            }
            case 44: {
                objectArray = objectArray;
                objectArray[2] = "lambda$executeFor$5";
                break;
            }
            case 45: {
                objectArray = objectArray;
                objectArray[2] = "lambda$null$4";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 3: 
            case 4: 
            case 7: 
            case 16: 
            case 17: 
            case 18: 
            case 21: 
            case 23: 
            case 31: 
            case 34: 
            case 35: 
            case 38: 
            case 39: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    public static interface ImportElementFilter {
        @NotNull
        public List<JSElement> filterByContext(@NotNull PsiElement var1, @NotNull List<JSElement> var2);

        public boolean isValidContext(@NotNull PsiElement var1);
    }

    public static class DefaultElementFilter
    implements ImportElementFilter {
        @Override
        @NotNull
        public List<JSElement> filterByContext(@NotNull PsiElement context, @NotNull List<JSElement> result2) {
            if (context == null) {
                DefaultElementFilter.$$$reportNull$$$0(0);
            }
            if (result2 == null) {
                DefaultElementFilter.$$$reportNull$$$0(1);
            }
            if (result2.isEmpty()) {
                List<JSElement> list = result2;
                if (list == null) {
                    DefaultElementFilter.$$$reportNull$$$0(2);
                }
                return list;
            }
            if (context.getNode().getElementType() == JSTokenTypes.XML_TAG_NAME) {
                List<JSElement> list = result2.stream().filter(el -> {
                    if (!ReactXmlExtension.isPossibleReactComponent((PsiElement)el)) {
                        return false;
                    }
                    JSElement scope = ES6PsiUtil.getExportScope((PsiElement)el);
                    if (scope == null) {
                        return false;
                    }
                    return ES6PsiUtil.isExternalModule((PsiElement)scope);
                }).collect(Collectors.toList());
                if (list == null) {
                    DefaultElementFilter.$$$reportNull$$$0(3);
                }
                return list;
            }
            List<JSElement> list = result2;
            if (list == null) {
                DefaultElementFilter.$$$reportNull$$$0(4);
            }
            return list;
        }

        @Override
        public boolean isValidContext(@NotNull PsiElement context) {
            if (context == null) {
                DefaultElementFilter.$$$reportNull$$$0(5);
            }
            return !(context instanceof JSReferenceExpression) || ES6ImportAction.checkReferenceExpressionAcceptable((JSReferenceExpression)context);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 2: 
                case 3: 
                case 4: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 2: 
                case 3: 
                case 4: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "context";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "result";
                    break;
                }
                case 2: 
                case 3: 
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/lang/javascript/modules/ES6ImportAction$DefaultElementFilter";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/lang/javascript/modules/ES6ImportAction$DefaultElementFilter";
                    break;
                }
                case 2: 
                case 3: 
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[1] = "filterByContext";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "filterByContext";
                    break;
                }
                case 2: 
                case 3: 
                case 4: {
                    break;
                }
                case 5: {
                    objectArray = objectArray;
                    objectArray[2] = "isValidContext";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 2: 
                case 3: 
                case 4: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }
}

