/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.modules.diagramm;

import com.intellij.diagram.AbstractDiagramElementManager;
import com.intellij.diagram.AbstractDiagramNodeContentManager;
import com.intellij.diagram.AbstractUmlVisibilityManager;
import com.intellij.diagram.BaseDiagramProvider;
import com.intellij.diagram.DiagramBuilder;
import com.intellij.diagram.DiagramCategory;
import com.intellij.diagram.DiagramColorManager;
import com.intellij.diagram.DiagramDataModel;
import com.intellij.diagram.DiagramEdge;
import com.intellij.diagram.DiagramElementManager;
import com.intellij.diagram.DiagramNode;
import com.intellij.diagram.DiagramNodeContentManager;
import com.intellij.diagram.DiagramPresentationModel;
import com.intellij.diagram.DiagramProvider;
import com.intellij.diagram.DiagramVfsResolver;
import com.intellij.diagram.DiagramVisibilityManager;
import com.intellij.diagram.VisibilityLevel;
import com.intellij.diagram.components.DiagramNodeContainer;
import com.intellij.diagram.extras.DiagramExtras;
import com.intellij.diagram.presentation.DiagramState;
import com.intellij.icons.AllIcons;
import com.intellij.ide.BrowserUtil;
import com.intellij.ide.util.PropertiesComponent;
import com.intellij.lang.Language;
import com.intellij.lang.html.HTMLLanguage;
import com.intellij.lang.javascript.DialectDetector;
import com.intellij.lang.javascript.JSBundle;
import com.intellij.lang.javascript.ecmascript6.TypeScriptUtil;
import com.intellij.lang.javascript.library.JSLibraryUtil;
import com.intellij.lang.javascript.modules.diagramm.JSDiagramColorManager;
import com.intellij.lang.javascript.modules.diagramm.JSModuleDependencyData;
import com.intellij.lang.javascript.modules.diagramm.JSModulesDiagramUtils;
import com.intellij.lang.javascript.modules.diagramm.JSStructuralDiagramItem;
import com.intellij.lang.javascript.modules.diagramm.JSStructuralDiagramModel;
import com.intellij.lang.javascript.modules.diagramm.JSStructuralUiEdge;
import com.intellij.lang.javascript.modules.diagramm.JSStructuralUiNode;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.fileTypes.LanguageFileType;
import com.intellij.openapi.graph.base.Graph;
import com.intellij.openapi.graph.layout.Layouter;
import com.intellij.openapi.graph.layout.organic.SmartOrganicLayouter;
import com.intellij.openapi.graph.settings.GraphSettings;
import com.intellij.openapi.graph.settings.GraphSettingsProvider;
import com.intellij.openapi.graph.view.EditMode;
import com.intellij.openapi.graph.view.Graph2D;
import com.intellij.openapi.graph.view.Graph2DView;
import com.intellij.openapi.graph.view.NodeRealizer;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ProjectFileIndex;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.ui.popup.Balloon;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.Trinity;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.pom.Navigatable;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiFileSystemItem;
import com.intellij.psi.PsiManager;
import com.intellij.psi.SmartPointerManager;
import com.intellij.psi.SmartPsiElementPointer;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.search.GlobalSearchScopesCore;
import com.intellij.psi.search.SearchScope;
import com.intellij.ui.ColoredTextContainer;
import com.intellij.ui.GotItMessage;
import com.intellij.ui.Gray;
import com.intellij.ui.JBColor;
import com.intellij.ui.SimpleColoredText;
import com.intellij.ui.SimpleTextAttributes;
import com.intellij.ui.awt.RelativePoint;
import com.intellij.uml.core.renderers.DefaultUmlRenderer;
import com.intellij.uml.presentation.DiagramPresentationModelImpl;
import com.intellij.util.ArrayUtil;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.UIUtil;
import com.intellij.util.ui.update.UiNotifyConnector;
import java.awt.Color;
import java.awt.Point;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.stream.Collectors;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.border.Border;
import org.intellij.lang.annotations.Pattern;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JSModulesDiagramProvider
extends BaseDiagramProvider<JSStructuralDiagramItem> {
    private static final String FIRST_SHOW_KEY = "js.modules.notification.shown";
    public static final String JAVASCRIPT_MODULES_DIAGRAMM = "JavaScript-modules-diagram";
    public static final VisibilityLevel OVERVIEW = new VisibilityLevel("Overview");
    public static final VisibilityLevel DETAILS = new VisibilityLevel("Details");
    public static final Comparator<VisibilityLevel> COMPARATOR = (o1, o2) -> {
        if (o1.equals(o2)) {
            return 0;
        }
        return OVERVIEW.equals(o1) ? -1 : 1;
    };
    public static final DiagramCategory ALL = new DiagramCategory("All", null);
    private volatile boolean myGotItMessageActive;
    private final DiagramVfsResolver<JSStructuralDiagramItem> myResolver = new DiagramVfsResolver<JSStructuralDiagramItem>(){

        public String getQualifiedName(JSStructuralDiagramItem element) {
            if (!element.getUsedExported().isEmpty()) {
                return StringUtil.join((Collection)element.getUsedExported().stream().map(i -> JSModulesDiagramProvider.serializeOneItem(i)).collect(Collectors.toList()), (String)";") + ";";
            }
            return JSModulesDiagramProvider.serializeOneItem(element);
        }

        @Nullable
        public JSStructuralDiagramItem resolveElementByFQN(String fqn, Project project) {
            if (fqn.contains(";")) {
                String[] strings = fqn.split(";");
                JSStructuralDiagramItem item = JSModulesDiagramProvider.this.createProjectItem(project, SmartPointerManager.getInstance((Project)project));
                if (item == null) {
                    return null;
                }
                for (String string : strings) {
                    JSStructuralDiagramItem child = JSModulesDiagramProvider.deserializeOneItem(string, project);
                    if (child == null) {
                        return null;
                    }
                    item.addImportedOrExported(child, true);
                }
                return item;
            }
            return JSModulesDiagramProvider.deserializeOneItem(fqn, project);
        }
    };
    private final DiagramElementManager<JSStructuralDiagramItem> myElementManager = new AbstractDiagramElementManager<JSStructuralDiagramItem>(){

        public Object[] getNodeItems(JSStructuralDiagramItem parent) {
            return ArrayUtil.toObjectArray(parent.getUsedExported());
        }

        @Nullable
        public JSStructuralDiagramItem findInDataContext(DataContext context) {
            Project project = (Project)CommonDataKeys.PROJECT.getData(context);
            if (project == null) {
                return null;
            }
            VirtualFile[] data = (VirtualFile[])CommonDataKeys.VIRTUAL_FILE_ARRAY.getData(context);
            SmartPointerManager spm = SmartPointerManager.getInstance((Project)project);
            PsiManager psiManager = PsiManager.getInstance((Project)project);
            if (data != null) {
                List<VirtualFile> files = this.checkFilesTypesAndFilterExcluded(project, data);
                if (files.isEmpty()) {
                    return null;
                }
                if (files.size() == 1) {
                    PsiDirectory psiFile;
                    VirtualFile file = files.get(0);
                    Object object = psiFile = file.isDirectory() ? psiManager.findDirectory(file) : psiManager.findFile(file);
                    if (psiFile == null) {
                        return null;
                    }
                    return new JSStructuralDiagramItem((SmartPsiElementPointer<PsiElement>)spm.createSmartPsiElementPointer((PsiElement)psiFile), file.getName(), true);
                }
                JSStructuralDiagramItem item = JSModulesDiagramProvider.this.createProjectItem(project, spm);
                if (item == null) {
                    return null;
                }
                for (VirtualFile file : files) {
                    PsiDirectory psiFile;
                    Object object = psiFile = file.isDirectory() ? psiManager.findDirectory(file) : psiManager.findFile(file);
                    if (psiFile == null) continue;
                    item.addImportedOrExported(new JSStructuralDiagramItem((SmartPsiElementPointer<PsiElement>)spm.createSmartPsiElementPointer((PsiElement)psiFile), file.getName(), true), true);
                }
                return item;
            }
            PsiElement element = (PsiElement)CommonDataKeys.PSI_FILE.getData(context);
            return element == null ? null : new JSStructuralDiagramItem((SmartPsiElementPointer<PsiElement>)spm.createSmartPsiElementPointer((PsiElement)element.getContainingFile()), JSModulesDiagramUtils.getFileNamePart(element.getContainingFile()), true);
        }

        private List<VirtualFile> checkFilesTypesAndFilterExcluded(Project project, @NotNull VirtualFile[] files) {
            if (files == null) {
                2.$$$reportNull$$$0(0);
            }
            ProjectFileIndex fi = ProjectRootManager.getInstance((Project)project).getFileIndex();
            return Arrays.stream(files).filter(file -> {
                if (fi.isExcluded(file)) {
                    return false;
                }
                if (file.isDirectory()) {
                    return true;
                }
                FileType type = file.getFileType();
                if (type instanceof LanguageFileType) {
                    Language language = ((LanguageFileType)type).getLanguage();
                    return language.isKindOf((Language)HTMLLanguage.INSTANCE) || DialectDetector.JAVASCRIPT_FILE_TYPES.contains(type) || TypeScriptUtil.TYPESCRIPT_FILE_TYPES.contains(type);
                }
                return false;
            }).collect(Collectors.toList());
        }

        public boolean isAcceptableAsNode(Object element) {
            return element instanceof JSStructuralDiagramItem;
        }

        @Nullable
        public String getElementTitle(JSStructuralDiagramItem element) {
            return JSModulesDiagramProvider.getElementTitleStatic(element);
        }

        @Nullable
        public SimpleColoredText getItemName(Object element, DiagramState presentation) {
            if (element instanceof JSStructuralDiagramItem) {
                SimpleTextAttributes attributes = UIUtil.isUnderDarcula() ? new SimpleTextAttributes(0, (Color)JBColor.black) : SimpleTextAttributes.REGULAR_ATTRIBUTES;
                return new SimpleColoredText(JSModulesDiagramProvider.getElementTitleStatic((JSStructuralDiagramItem)element), attributes);
            }
            return null;
        }

        public SimpleColoredText getItemType(Object element) {
            if (element instanceof JSStructuralDiagramItem && ((JSStructuralDiagramItem)element).getParent() != null) {
                boolean isExported = ((JSStructuralDiagramItem)element).getParent().isExported((JSStructuralDiagramItem)element);
                SimpleColoredText text = new SimpleColoredText(){
                    private Icon myIcon;

                    public void setIcon(@Nullable Icon icon) {
                        this.myIcon = icon;
                    }

                    public void appendToComponent(@NotNull ColoredTextContainer component) {
                        if (component == null) {
                            1.$$$reportNull$$$0(0);
                        }
                        super.appendToComponent(component);
                        if (this.myIcon != null) {
                            component.setIcon(this.myIcon);
                        }
                    }

                    private static /* synthetic */ void $$$reportNull$$$0(int n) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "component", "com/intellij/lang/javascript/modules/diagramm/JSModulesDiagramProvider$2$1", "appendToComponent"));
                    }
                };
                if (isExported) {
                    text.setIcon(AllIcons.ToolbarDecorator.Export);
                } else {
                    text.setIcon(AllIcons.ToolbarDecorator.Import);
                }
                return text;
            }
            return super.getItemType(element);
        }

        public Icon getItemIcon(Object element, DiagramState presentation) {
            if (element instanceof JSStructuralDiagramItem) {
                JSStructuralDiagramItem item = (JSStructuralDiagramItem)element;
                if (item.getIcon() != null) {
                    return item.getIcon();
                }
                return JSStructuralUiNode.calculateIcon(item);
            }
            return super.getItemIcon(element, presentation);
        }

        public String getNodeTooltip(JSStructuralDiagramItem element) {
            return JSModulesDiagramUtils.getJSStructuralItemTooltip(element);
        }

        public String getEditorTitle(JSStructuralDiagramItem element, DiagramState presentation, Collection<JSStructuralDiagramItem> additionalElements) {
            return this.getElementTitle(element);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "files", "com/intellij/lang/javascript/modules/diagramm/JSModulesDiagramProvider$2", "checkFilesTypesAndFilterExcluded"));
        }
    };
    private AbstractUmlVisibilityManager myVisibilityManager = new AbstractUmlVisibilityManager(){

        public VisibilityLevel[] getVisibilityLevels() {
            return new VisibilityLevel[]{OVERVIEW, DETAILS};
        }

        @Nullable
        public VisibilityLevel getVisibilityLevel(Object element) {
            if (element instanceof JSStructuralDiagramItem && !((JSStructuralDiagramItem)element).isFile()) {
                return DETAILS;
            }
            return OVERVIEW;
        }

        public Comparator<VisibilityLevel> getComparator() {
            return COMPARATOR;
        }

        public boolean isRelayoutNeeded() {
            return true;
        }
    };

    @Nullable
    private JSStructuralDiagramItem createProjectItem(Project project, SmartPointerManager spm) {
        VirtualFile baseDir = project.getBaseDir();
        PsiDirectory projectPsiFile = PsiManager.getInstance((Project)project).findDirectory(baseDir);
        if (projectPsiFile == null) {
            return null;
        }
        SmartPsiElementPointer pointer = spm.createSmartPsiElementPointer((PsiElement)projectPsiFile);
        JSStructuralDiagramItem item = new JSStructuralDiagramItem((SmartPsiElementPointer<PsiElement>)pointer, "Selected", false);
        return item;
    }

    @Nullable
    private static JSStructuralDiagramItem deserializeOneItem(String fqn, Project project) {
        int offset;
        PsiDirectory psiFile;
        if (StringUtil.isEmptyOrSpaces((String)fqn)) {
            return null;
        }
        PsiManager psiManager = PsiManager.getInstance((Project)project);
        if (!fqn.contains("#")) {
            VirtualFile file = LocalFileSystem.getInstance().findFileByPath(fqn);
            if (file != null) {
                PsiDirectory psiFile2;
                Object object = psiFile2 = file.isDirectory() ? psiManager.findDirectory(file) : psiManager.findFile(file);
                if (psiFile2 == null) {
                    return null;
                }
                String name = psiFile2 instanceof PsiFile ? JSModulesDiagramUtils.getFileNamePart((PsiFile)psiFile2) : file.getName();
                return new JSStructuralDiagramItem((SmartPsiElementPointer<PsiElement>)SmartPointerManager.getInstance((Project)project).createSmartPsiElementPointer((PsiElement)psiFile2), name, true);
            }
            return new JSStructuralDiagramItem(null, fqn, true);
        }
        String[] strings = fqn.split("#");
        if (strings.length != 1 && strings.length != 3) {
            return null;
        }
        VirtualFile file = LocalFileSystem.getInstance().findFileByPath(strings[0]);
        if (file == null) {
            return null;
        }
        Object object = psiFile = file.isDirectory() ? psiManager.findDirectory(file) : psiManager.findFile(file);
        if (psiFile == null) {
            return null;
        }
        if (strings.length == 1) {
            String name = psiFile instanceof PsiFile ? JSModulesDiagramUtils.getFileNamePart((PsiFile)psiFile) : file.getName();
            return new JSStructuralDiagramItem((SmartPsiElementPointer<PsiElement>)SmartPointerManager.getInstance((Project)project).createSmartPsiElementPointer((PsiElement)psiFile), name, true);
        }
        String name = strings[1];
        try {
            offset = Integer.parseInt(strings[2]);
        }
        catch (NumberFormatException e) {
            return null;
        }
        PsiElement element = psiFile.findElementAt(offset);
        if (element == null || !element.isValid()) {
            return null;
        }
        return new JSStructuralDiagramItem((SmartPsiElementPointer<PsiElement>)SmartPointerManager.getInstance((Project)project).createSmartPsiElementPointer(element), name, false);
    }

    @NotNull
    private static String serializeOneItem(JSStructuralDiagramItem element) {
        if (element.getElementPointer() == null) {
            String string = element.getName();
            if (string == null) {
                JSModulesDiagramProvider.$$$reportNull$$$0(0);
            }
            return string;
        }
        PsiElement psiElement = element.getElementPointer().getElement();
        if (psiElement == null) {
            if ("" == null) {
                JSModulesDiagramProvider.$$$reportNull$$$0(1);
            }
            return "";
        }
        String path = psiElement instanceof PsiFileSystemItem ? ((PsiFileSystemItem)psiElement).getVirtualFile().getPath() : psiElement.getContainingFile().getVirtualFile().getPath();
        StringBuilder sb = new StringBuilder(path);
        if (!(psiElement instanceof PsiFileSystemItem) && !element.isFile()) {
            if (psiElement.getTextRange() == null) {
                String string = path;
                if (string == null) {
                    JSModulesDiagramProvider.$$$reportNull$$$0(2);
                }
                return string;
            }
            sb.append("#").append(element.getName()).append("#").append(String.format("%d", psiElement.getTextRange().getStartOffset()));
        }
        String string = sb.toString();
        if (string == null) {
            JSModulesDiagramProvider.$$$reportNull$$$0(3);
        }
        return string;
    }

    @Pattern(value="[a-zA-Z0-9_-]*")
    public String getID() {
        return JAVASCRIPT_MODULES_DIAGRAMM;
    }

    public DiagramVisibilityManager createVisibilityManager() {
        return this.myVisibilityManager;
    }

    public DiagramNodeContentManager getNodeContentManager() {
        return new AbstractDiagramNodeContentManager(){
            {
                this.setEnabled(ALL, true);
            }

            public boolean isInCategory(Object element, DiagramCategory category, DiagramState presentation) {
                return true;
            }

            public DiagramCategory[] getContentCategories() {
                return new DiagramCategory[]{ALL};
            }

            public boolean isEditCategoriesSettings() {
                return false;
            }
        };
    }

    @Nullable
    public DiagramPresentationModel createPresentationModel(Project project, Graph2D graph) {
        return new DiagramPresentationModelImpl(graph, project, (DiagramProvider)this){

            public boolean allowChangeVisibleCategories() {
                return false;
            }

            public void customizeSettings(Graph2DView view, EditMode editMode) {
                super.customizeSettings(view, editMode);
                this.getPresentation().setCategoryEnabled(ALL, true);
                JComponent component = this.getBuilder().getView().getJComponent();
                if (!PropertiesComponent.getInstance().isTrueValue(JSModulesDiagramProvider.FIRST_SHOW_KEY)) {
                    this.showGotItMessage(component, JSBundle.message((String)"javascript.module.dependencies.got.it.text", (Object[])new Object[0]));
                } else if (this.getBuilder().getDataModel().getNodes().size() == 0) {
                    this.showGotItMessage(component, JSBundle.message((String)"javascript.module.dependencies.empty.got.it.text", (Object[])new Object[0]));
                }
            }

            private void showGotItMessage(JComponent component, String message) {
                UiNotifyConnector.doWhenFirstShown((JComponent)component, () -> {
                    if (JSModulesDiagramProvider.this.myGotItMessageActive) {
                        return;
                    }
                    JSModulesDiagramProvider.this.myGotItMessageActive = true;
                    GotItMessage.createMessage((String)JSBundle.message((String)"javascript.module.dependencies.got.it.title", (Object[])new Object[0]), (String)message).setCallback(() -> {
                        JSModulesDiagramProvider.this.myGotItMessageActive = false;
                        PropertiesComponent.getInstance().setValue(JSModulesDiagramProvider.FIRST_SHOW_KEY, true);
                    }).setDisposable((Disposable)this.getBuilder()).show(RelativePoint.getSouthEastOf((JComponent)component), Balloon.Position.below);
                });
            }

            public DefaultUmlRenderer getRenderer() {
                if (this.myRenderer == null) {
                    this.myRenderer = new DefaultUmlRenderer(this.getBuilder(), this.createModificationTracker()){

                        public void tuneNode(NodeRealizer realizer, JPanel wrapper) {
                            Border border = JBUI.Borders.customLine((Color)Gray._190);
                            DiagramNode object = this.getBuilder().getNodeObject(realizer.getNode());
                            if (object instanceof JSStructuralUiNode) {
                                JSStructuralDiagramItem element = ((JSStructuralUiNode)object).getIdentifyingElement();
                                if (element.isInScope()) {
                                    PsiFile file;
                                    PsiFile psiFile = file = element.getElementPointer() != null ? element.getElementPointer().getContainingFile() : null;
                                    if (file != null && !JSLibraryUtil.isProbableLibraryFile(file.getVirtualFile())) {
                                        border = JBUI.Borders.customLine((Color)JBColor.black);
                                    }
                                } else if (element.getElementPointer() == null && !JSModulesDiagramUtils.startsWithHttpProtocol(element.getName())) {
                                    border = JBUI.Borders.customLine((Color)JBColor.red);
                                }
                            }
                            wrapper.setBorder(border);
                            if (wrapper.getParent() instanceof JComponent) {
                                ((JComponent)wrapper.getParent()).setBorder((Border)JBUI.Borders.empty());
                            }
                            super.tuneNode(realizer, wrapper);
                        }
                    };
                }
                return this.myRenderer;
            }

            public String getNodeTooltip(DiagramNode node) {
                return node.getTooltip();
            }

            public String getEdgeTooltip(DiagramEdge edge) {
                if (edge instanceof JSStructuralUiEdge) {
                    return ((JSStructuralUiEdge)edge).getTooltip();
                }
                return super.getEdgeTooltip(edge);
            }
        };
    }

    public DiagramColorManager getColorManager() {
        return JSDiagramColorManager.INSTANCE;
    }

    public DiagramElementManager<JSStructuralDiagramItem> getElementManager() {
        return this.myElementManager;
    }

    public DiagramVfsResolver<JSStructuralDiagramItem> getVfsResolver() {
        return this.myResolver;
    }

    public String getPresentableName() {
        return "JavaScript Module Dependency Diagram";
    }

    @NotNull
    public DiagramExtras<JSStructuralDiagramItem> getExtras() {
        DiagramExtras<JSStructuralDiagramItem> diagramExtras = new DiagramExtras<JSStructuralDiagramItem>(){

            public List<AnAction> getExtraActions() {
                return Collections.singletonList(new MyEditSourceAction());
            }

            @Nullable
            public Object getData(String dataId, List<DiagramNode<JSStructuralDiagramItem>> list, DiagramBuilder builder) {
                if (CommonDataKeys.PSI_ELEMENT.is(dataId) && list.size() == 1) {
                    SmartPsiElementPointer<PsiElement> target = ((JSStructuralDiagramItem)list.get(0).getIdentifyingElement()).getElementPointer();
                    if (target != null) {
                        return target.getElement();
                    }
                } else if (CommonDataKeys.NAVIGATABLE_ARRAY.is(dataId) && list.size() == 1) {
                    final JSStructuralDiagramItem element = (JSStructuralDiagramItem)list.get(0).getIdentifyingElement();
                    if (element.getElementPointer() == null && JSModulesDiagramUtils.startsWithHttpProtocol(element.getName())) {
                        return new Navigatable[]{new Navigatable(){

                            public void navigate(boolean requestFocus) {
                                BrowserUtil.open((String)element.getName());
                            }

                            public boolean canNavigate() {
                                return true;
                            }

                            public boolean canNavigateToSource() {
                                return true;
                            }
                        }};
                    }
                } else if (JSModulesDiagramUtils.DIAGRAM_BUILDER.is(dataId)) {
                    return builder;
                }
                return super.getData(dataId, list, builder);
            }

            @NotNull
            public JComponent createNodeComponent(DiagramNode<JSStructuralDiagramItem> node, DiagramBuilder builder, Point basePoint, JPanel wrapper) {
                DiagramNodeContainer container = new DiagramNodeContainer(node, builder, basePoint);
                if (!((JSStructuralDiagramItem)node.getIdentifyingElement()).getUsedExported().isEmpty()) {
                    container.getHeader().setBorder(JBUI.Borders.customLine((Color)Gray._190, (int)0, (int)0, (int)1, (int)0));
                }
                container.setBackground((Color)JBColor.WHITE);
                DiagramNodeContainer diagramNodeContainer = container;
                if (diagramNodeContainer == null) {
                    6.$$$reportNull$$$0(0);
                }
                return diagramNodeContainer;
            }

            @Nullable
            public Layouter getCustomLayouter(Graph2D graph, Project project) {
                GraphSettingsProvider settingsProvider = GraphSettingsProvider.getInstance((Project)project);
                GraphSettings settings = settingsProvider.getSettings((Graph)graph);
                SmartOrganicLayouter layouter = settings.getOrganicLayouter();
                layouter.setNodeEdgeOverlapAvoided(true);
                layouter.setDeterministic(true);
                return layouter;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/modules/diagramm/JSModulesDiagramProvider$6", "createNodeComponent"));
            }
        };
        if (diagramExtras == null) {
            JSModulesDiagramProvider.$$$reportNull$$$0(4);
        }
        return diagramExtras;
    }

    public DiagramDataModel<JSStructuralDiagramItem> createDataModel(@NotNull Project project, @Nullable JSStructuralDiagramItem element, @Nullable VirtualFile file, DiagramPresentationModel presentationModel) {
        GlobalSearchScope scope;
        if (project == null) {
            JSModulesDiagramProvider.$$$reportNull$$$0(5);
        }
        if (element != null && !element.getUsedExported().isEmpty()) {
            GlobalSearchScope current = GlobalSearchScope.EMPTY_SCOPE;
            for (JSStructuralDiagramItem item : element.getUsedExported()) {
                PsiElement child;
                if (item.getElementPointer() == null || !((child = item.getElementPointer().getElement()) instanceof PsiFileSystemItem)) continue;
                if (child instanceof PsiDirectory) {
                    current = current.union((SearchScope)GlobalSearchScopesCore.directoryScope((PsiDirectory)((PsiDirectory)child), (boolean)true));
                    continue;
                }
                if (!(child instanceof PsiFile)) continue;
                current = current.union((SearchScope)GlobalSearchScope.fileScope((PsiFile)((PsiFile)child)));
            }
            scope = current;
        } else if (element != null && element.getElementPointer() != null) {
            PsiElement psiElement = element.getElementPointer().getElement();
            if (psiElement instanceof PsiFileSystemItem) {
                scope = psiElement instanceof PsiDirectory ? GlobalSearchScopesCore.directoryScope((Project)project, (VirtualFile)((PsiDirectory)psiElement).getVirtualFile(), (boolean)true) : (psiElement instanceof PsiFile ? GlobalSearchScope.fileScope((PsiFile)((PsiFile)psiElement)) : GlobalSearchScope.projectScope((Project)project));
            } else {
                PsiFile psiFile = element.getElementPointer().getContainingFile();
                if (psiFile == null) {
                    return null;
                }
                scope = GlobalSearchScope.fileScope((Project)project, (VirtualFile)psiFile.getVirtualFile());
            }
        } else {
            scope = GlobalSearchScope.projectScope((Project)project);
        }
        JSModuleDependencyData data = new JSModuleDependencyData(project, scope);
        data.calculate();
        Pair<List<JSStructuralUiNode>, List<JSStructuralUiEdge>> nodesAndEdges = data.getNodesAndEdges(this);
        return new JSStructuralDiagramModel(project, this, (List)nodesAndEdges.getFirst(), (List)nodesAndEdges.getSecond());
    }

    public static String getElementTitleStatic(JSStructuralDiagramItem element) {
        if (element != null) {
            return JSModulesDiagramProvider.getElementNamePart(element);
        }
        return "";
    }

    private static String getElementNamePart(JSStructuralDiagramItem element) {
        if (element.getElementPointer() != null) {
            if (element.getElementPointer().getElement() instanceof PsiFile) {
                if (JSModulesDiagramUtils.startsWithHttpProtocol(element.getName())) {
                    return JSModulesDiagramProvider.onlyName(element);
                }
                return JSModulesDiagramUtils.getFileNamePart((PsiFile)element.getElementPointer().getElement());
            }
            if (element.getElementPointer().getElement() instanceof PsiDirectory) {
                return element.getName();
            }
            if (element.getElementPointer() == null) {
                return JSModulesDiagramProvider.onlyName(element);
            }
        } else if (element.getElementPointer() == null) {
            return JSModulesDiagramProvider.onlyName(element);
        }
        return element.getName();
    }

    private static String onlyName(JSStructuralDiagramItem element) {
        String[] split = element.getName().replace("\\", "/").split("/");
        return split.length == 0 ? element.getName() : split[split.length - 1];
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 5: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 5: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/javascript/modules/diagramm/JSModulesDiagramProvider";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "serializeOneItem";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getExtras";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/javascript/modules/diagramm/JSModulesDiagramProvider";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "createDataModel";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 5: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private class MyEditSourceAction
    extends AnAction {
        private final AnAction myAction;

        public MyEditSourceAction() {
            super("Jump To...", "Jump To...", AllIcons.Actions.EditSource);
            this.myAction = ActionManager.getInstance().getAction("EditSource");
        }

        public void update(AnActionEvent e) {
            Project project = (Project)CommonDataKeys.PROJECT.getData(e.getDataContext());
            if (project == null) {
                e.getPresentation().setEnabled(false);
                return;
            }
            List<DiagramNode> nodes = JSModulesDiagramUtils.getSelectedNodes(e);
            e.getPresentation().setEnabled(nodes != null && nodes.size() == 1 && nodes.get(0) instanceof JSStructuralUiNode);
        }

        public void actionPerformed(AnActionEvent e) {
            Project project = (Project)CommonDataKeys.PROJECT.getData(e.getDataContext());
            List<DiagramNode> nodes = JSModulesDiagramUtils.getSelectedNodes(e);
            if (project == null || nodes == null || nodes.size() != 1 || !(nodes.get(0) instanceof JSStructuralUiNode)) {
                return;
            }
            JSStructuralDiagramItem main = (JSStructuralDiagramItem)nodes.get(0).getIdentifyingElement();
            List<JSStructuralDiagramItem> exported = main.getUsedExported();
            if (exported.isEmpty()) {
                return;
            }
            JSModulesDiagramUtils.showMembersSelectionPopup(StringUtil.notNullize((String)JSModulesDiagramProvider.getElementTitleStatic(main)), main.getElementPointer(), JSStructuralUiNode.calculateIcon(main), exported.stream().map(el -> Trinity.create((Object)StringUtil.notNullize((String)JSModulesDiagramProvider.getElementTitleStatic(el)), el.getElementPointer(), (Object)JSStructuralUiNode.calculateIcon(el))).collect(Collectors.toList()), e.getDataContext());
        }
    }
}

