/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.psi.ecma6.impl;

import com.intellij.lang.ASTNode;
import com.intellij.lang.javascript.JSStringUtil;
import com.intellij.lang.javascript.ecmascript6.EnumConstantValueImpl;
import com.intellij.lang.javascript.ecmascript6.InvalidEnumConstantValue;
import com.intellij.lang.javascript.psi.JSStubElementType;
import com.intellij.lang.javascript.psi.JSVariable;
import com.intellij.lang.javascript.psi.ecma6.EnumConstantValue;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptEnum;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptEnumField;
import com.intellij.lang.javascript.psi.ecma6.impl.TypeScriptFieldImpl;
import com.intellij.lang.javascript.psi.ecmal4.JSClass;
import com.intellij.lang.javascript.psi.stubs.JSVariableStub;
import com.intellij.lang.javascript.psi.stubs.TypeScriptEnumFieldStub;
import com.intellij.lang.javascript.psi.util.JSUtils;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.util.CachedValueProvider;
import com.intellij.psi.util.CachedValuesManager;
import com.intellij.psi.util.ParameterizedCachedValue;
import com.intellij.psi.util.ParameterizedCachedValueProvider;
import com.intellij.util.containers.ContainerUtil;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class TypeScriptEnumFieldImpl
extends TypeScriptFieldImpl
implements TypeScriptEnumField {
    private static final ParameterizedCachedValueProvider<Map<TypeScriptEnumField, EnumConstantValue>, TypeScriptEnum> VALUES_PROVIDER = new ParameterizedCachedValueProvider<Map<TypeScriptEnumField, EnumConstantValue>, TypeScriptEnum>(){

        @NotNull
        public CachedValueProvider.Result<Map<TypeScriptEnumField, EnumConstantValue>> compute(TypeScriptEnum param) {
            CachedValueProvider.Result result2 = CachedValueProvider.Result.create((Object)TypeScriptEnumFieldImpl.calculateConstraintValuesImpl(param), (Object[])new Object[]{param});
            if (result2 == null) {
                1.$$$reportNull$$$0(0);
            }
            return result2;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/psi/ecma6/impl/TypeScriptEnumFieldImpl$1", "compute"));
        }
    };
    private static final Key<ParameterizedCachedValue<Map<TypeScriptEnumField, EnumConstantValue>, TypeScriptEnum>> CACHED_VALUE_KEY = Key.create((String)"enum.fields.values");

    public TypeScriptEnumFieldImpl(ASTNode node) {
        super(node);
    }

    public TypeScriptEnumFieldImpl(JSVariableStub<JSVariable> stub, JSStubElementType<JSVariableStub<JSVariable>, JSVariable> signature) {
        super(stub, signature);
    }

    @Nullable
    public String getConstantValueDescription() {
        return this.getConstantValue().getDescription();
    }

    @NotNull
    public EnumConstantValue getConstantValue() {
        TypeScriptEnumFieldStub stub = (TypeScriptEnumFieldStub)this.getGreenStub();
        if (stub != null) {
            EnumConstantValue enumConstantValue = stub.getConstantValue();
            if (enumConstantValue == null) {
                TypeScriptEnumFieldImpl.$$$reportNull$$$0(0);
            }
            return enumConstantValue;
        }
        EnumConstantValue enumConstantValue = this.computeConstantValue();
        if (enumConstantValue == null) {
            TypeScriptEnumFieldImpl.$$$reportNull$$$0(1);
        }
        return enumConstantValue;
    }

    @NotNull
    private EnumConstantValue computeConstantValue() {
        TypeScriptEnum owner = this.getOwner();
        if (owner == null) {
            EnumConstantValue enumConstantValue = InvalidEnumConstantValue.INSTANCE;
            if (enumConstantValue == null) {
                TypeScriptEnumFieldImpl.$$$reportNull$$$0(2);
            }
            return enumConstantValue;
        }
        Map<TypeScriptEnumField, EnumConstantValue> valueMap = TypeScriptEnumFieldImpl.calculateConstraintValues(owner);
        EnumConstantValue value = valueMap.get(this);
        EnumConstantValue enumConstantValue = value == null ? InvalidEnumConstantValue.INSTANCE : value;
        if (enumConstantValue == null) {
            TypeScriptEnumFieldImpl.$$$reportNull$$$0(3);
        }
        return enumConstantValue;
    }

    @NotNull
    private static Map<TypeScriptEnumField, EnumConstantValue> calculateConstraintValues(@NotNull TypeScriptEnum enumClass) {
        if (enumClass == null) {
            TypeScriptEnumFieldImpl.$$$reportNull$$$0(4);
        }
        Map map = (Map)CachedValuesManager.getManager((Project)enumClass.getProject()).getParameterizedCachedValue((UserDataHolder)enumClass, CACHED_VALUE_KEY, VALUES_PROVIDER, false, (Object)enumClass);
        if (map == null) {
            TypeScriptEnumFieldImpl.$$$reportNull$$$0(5);
        }
        return map;
    }

    @NotNull
    private static Map<TypeScriptEnumField, EnumConstantValue> calculateConstraintValuesImpl(@NotNull TypeScriptEnum enumClass) {
        if (enumClass == null) {
            TypeScriptEnumFieldImpl.$$$reportNull$$$0(6);
        }
        List fields = Arrays.stream(enumClass.getFields()).filter(el -> el instanceof TypeScriptEnumField).map(el -> (TypeScriptEnumField)el).collect(Collectors.toList());
        HashMap result2 = ContainerUtil.newHashMap();
        HashMap processedValues = ContainerUtil.newHashMap();
        EnumConstantValue prevValue = null;
        for (TypeScriptEnumField field : fields) {
            String fieldName = field.getName();
            if (StringUtil.isEmpty((String)fieldName)) {
                result2.put(field, InvalidEnumConstantValue.INSTANCE);
                continue;
            }
            String text = field.getLiteralOrReferenceInitializerText();
            EnumConstantValue value = TypeScriptEnumFieldImpl.getValueForField(enumClass, field, text, processedValues, prevValue);
            result2.put(field, value);
            processedValues.put(fieldName, value);
            prevValue = value;
        }
        HashMap hashMap = result2;
        if (hashMap == null) {
            TypeScriptEnumFieldImpl.$$$reportNull$$$0(7);
        }
        return hashMap;
    }

    @NotNull
    private static EnumConstantValue getValueForField(@NotNull TypeScriptEnum enumClass, @NotNull TypeScriptEnumField field, @Nullable String valueText, @NotNull Map<String, EnumConstantValue> allPrevValues, @Nullable EnumConstantValue prevValue) {
        if (enumClass == null) {
            TypeScriptEnumFieldImpl.$$$reportNull$$$0(8);
        }
        if (field == null) {
            TypeScriptEnumFieldImpl.$$$reportNull$$$0(9);
        }
        if (allPrevValues == null) {
            TypeScriptEnumFieldImpl.$$$reportNull$$$0(10);
        }
        if (valueText != null) {
            String enumName;
            if (StringUtil.isQuotedString((String)valueText) || JSStringUtil.isNumericValueStart(valueText, true)) {
                EnumConstantValueImpl enumConstantValueImpl = new EnumConstantValueImpl(valueText);
                if (enumConstantValueImpl == null) {
                    TypeScriptEnumFieldImpl.$$$reportNull$$$0(11);
                }
                return enumConstantValueImpl;
            }
            EnumConstantValue otherValue = allPrevValues.get(valueText);
            if (otherValue == null && (enumName = enumClass.getName()) != null) {
                String withoutEnumName = StringUtil.trimStart((String)valueText, (String)(enumName + "."));
                otherValue = allPrevValues.get(withoutEnumName);
            }
            EnumConstantValue enumConstantValue = otherValue != null && otherValue.isValid() ? otherValue : InvalidEnumConstantValue.INSTANCE;
            if (enumConstantValue == null) {
                TypeScriptEnumFieldImpl.$$$reportNull$$$0(12);
            }
            return enumConstantValue;
        }
        if (!field.hasInitializer()) {
            if (prevValue == null) {
                EnumConstantValueImpl enumConstantValueImpl = new EnumConstantValueImpl("0");
                if (enumConstantValueImpl == null) {
                    TypeScriptEnumFieldImpl.$$$reportNull$$$0(13);
                }
                return enumConstantValueImpl;
            }
            EnumConstantValue enumConstantValue = prevValue.increaseNumericDelta(1);
            if (enumConstantValue == null) {
                TypeScriptEnumFieldImpl.$$$reportNull$$$0(14);
            }
            return enumConstantValue;
        }
        EnumConstantValue enumConstantValue = InvalidEnumConstantValue.INSTANCE;
        if (enumConstantValue == null) {
            TypeScriptEnumFieldImpl.$$$reportNull$$$0(15);
        }
        return enumConstantValue;
    }

    @Nullable
    public TypeScriptEnum getOwner() {
        JSClass aClass = JSUtils.getMemberContainingClass((PsiElement)this);
        return aClass instanceof TypeScriptEnum ? (TypeScriptEnum)aClass : null;
    }

    @Override
    public boolean isOptional() {
        return false;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 4: 
            case 6: 
            case 8: 
            case 9: 
            case 10: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 4: 
            case 6: 
            case 8: 
            case 9: 
            case 10: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/javascript/psi/ecma6/impl/TypeScriptEnumFieldImpl";
                break;
            }
            case 4: 
            case 6: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "enumClass";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "field";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "allPrevValues";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getConstantValue";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "computeConstantValue";
                break;
            }
            case 4: 
            case 6: 
            case 8: 
            case 9: 
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/javascript/psi/ecma6/impl/TypeScriptEnumFieldImpl";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "calculateConstraintValues";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "calculateConstraintValuesImpl";
                break;
            }
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: {
                objectArray = objectArray2;
                objectArray2[1] = "getValueForField";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "calculateConstraintValues";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "calculateConstraintValuesImpl";
                break;
            }
            case 8: 
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "getValueForField";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 4: 
            case 6: 
            case 8: 
            case 9: 
            case 10: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

