/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.psi.impl;

import com.intellij.lang.ASTNode;
import com.intellij.lang.ecmascript6.psi.ES6ComputedName;
import com.intellij.lang.javascript.JSExtendedLanguagesTokenSetProvider;
import com.intellij.lang.javascript.JSStubElementTypes;
import com.intellij.lang.javascript.JSTokenTypes;
import com.intellij.lang.javascript.JavascriptLanguage;
import com.intellij.lang.javascript.documentation.JSDocumentationProcessor;
import com.intellij.lang.javascript.documentation.JSDocumentationUtils;
import com.intellij.lang.javascript.index.JSSymbolUtil;
import com.intellij.lang.javascript.psi.JSAssignmentExpression;
import com.intellij.lang.javascript.psi.JSDestructuringParameter;
import com.intellij.lang.javascript.psi.JSElement;
import com.intellij.lang.javascript.psi.JSElementBase;
import com.intellij.lang.javascript.psi.JSExpression;
import com.intellij.lang.javascript.psi.JSExpressionStatement;
import com.intellij.lang.javascript.psi.JSFunction;
import com.intellij.lang.javascript.psi.JSInitializerOwner;
import com.intellij.lang.javascript.psi.JSParameter;
import com.intellij.lang.javascript.psi.JSParameterList;
import com.intellij.lang.javascript.psi.JSParameterListElement;
import com.intellij.lang.javascript.psi.JSParameterTypeDecorator;
import com.intellij.lang.javascript.psi.JSQualifiedName;
import com.intellij.lang.javascript.psi.JSQualifiedNameImpl;
import com.intellij.lang.javascript.psi.JSRecordType;
import com.intellij.lang.javascript.psi.JSReferenceExpression;
import com.intellij.lang.javascript.psi.JSSourceElement;
import com.intellij.lang.javascript.psi.JSStatement;
import com.intellij.lang.javascript.psi.JSType;
import com.intellij.lang.javascript.psi.JSTypeUtils;
import com.intellij.lang.javascript.psi.JSVariable;
import com.intellij.lang.javascript.psi.ecma6.JSComputedPropertyNameOwner;
import com.intellij.lang.javascript.psi.ecmal4.JSAttributeList;
import com.intellij.lang.javascript.psi.ecmal4.JSAttributeListOwner;
import com.intellij.lang.javascript.psi.ecmal4.JSClass;
import com.intellij.lang.javascript.psi.impl.JSChangeUtil;
import com.intellij.lang.javascript.psi.impl.JSFunctionCachedData;
import com.intellij.lang.javascript.psi.impl.JSFunctionNodesVisitor;
import com.intellij.lang.javascript.psi.impl.JSParameterImpl;
import com.intellij.lang.javascript.psi.impl.JSPsiImplUtils;
import com.intellij.lang.javascript.psi.impl.JSQualifiedNamedElementBaseImpl;
import com.intellij.lang.javascript.psi.impl.JSVariableBaseImpl;
import com.intellij.lang.javascript.psi.jsdoc.JSDocComment;
import com.intellij.lang.javascript.psi.resolve.ImplicitJSVariableImpl;
import com.intellij.lang.javascript.psi.resolve.JSEvaluateContext;
import com.intellij.lang.javascript.psi.resolve.JSImportHandlingUtil;
import com.intellij.lang.javascript.psi.resolve.JSResolveUtil;
import com.intellij.lang.javascript.psi.resolve.ResolveProcessor;
import com.intellij.lang.javascript.psi.resolve.context.JSApplyContextUtil;
import com.intellij.lang.javascript.psi.stubs.JSFunctionStubBase;
import com.intellij.lang.javascript.psi.types.JSAnyType;
import com.intellij.lang.javascript.psi.types.JSCompositeTypeImpl;
import com.intellij.lang.javascript.psi.types.JSContext;
import com.intellij.lang.javascript.psi.types.JSFunctionTypeImpl;
import com.intellij.lang.javascript.psi.types.JSParameterTypeDecoratorImpl;
import com.intellij.lang.javascript.psi.types.JSReferenceType;
import com.intellij.lang.javascript.psi.types.JSTypeParser;
import com.intellij.lang.javascript.psi.types.JSTypeSource;
import com.intellij.lang.javascript.psi.types.JSTypeSourceFactory;
import com.intellij.lang.javascript.psi.types.primitives.JSObjectType;
import com.intellij.lang.javascript.psi.types.primitives.JSPrimitiveFunctionType;
import com.intellij.lang.javascript.psi.util.JSDestructuringUtil;
import com.intellij.lang.javascript.psi.util.JSUtils;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiComment;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiNamedElement;
import com.intellij.psi.ResolveState;
import com.intellij.psi.scope.PsiScopeProcessor;
import com.intellij.psi.stubs.IStubElementType;
import com.intellij.psi.util.CachedValueProvider;
import com.intellij.psi.util.CachedValuesManager;
import com.intellij.psi.util.ParameterizedCachedValue;
import com.intellij.psi.util.ParameterizedCachedValueProvider;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.Function;
import com.intellij.util.IncorrectOperationException;
import gnu.trove.THashSet;
import gnu.trove.TObjectIntHashMap;
import gnu.trove.TObjectIntProcedure;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class JSFunctionBaseImpl<T extends JSFunctionStubBase<?>>
extends JSQualifiedNamedElementBaseImpl<T>
implements JSFunction {
    static final int OPTIONAL_STATUS = 1;
    private static final int REST_PARAMETER = 2;
    private static final int REFERENCED = 1;
    private String name;
    private static final Key<ParameterizedCachedValue<JSVariable, JSFunctionBaseImpl<?>>> ARGUMENTS_VAR_KEY = Key.create((String)"js.arguments.var");
    private static final ParameterizedCachedValueProvider<JSVariable, JSFunctionBaseImpl<?>> ARGUMENTS_VAR_PROVIDER = fun -> {
        String type = fun.getArgumentsClassName();
        JSParameterList parameterList = fun.getParameterList();
        ImplicitJSVariableImpl argumentsVar = new ImplicitJSVariableImpl("arguments", type, (PsiElement)(parameterList != null ? parameterList : fun));
        return CachedValueProvider.Result.create((Object)((Object)argumentsVar), (Object[])new Object[]{fun});
    };
    private static final Key<ParameterizedCachedValue<JSFunctionCachedData, JSFunctionBaseImpl<?>>> DATA_KEY = Key.create((String)"js.function.base.cached.data");
    private static final ParameterizedCachedValueProvider<JSFunctionCachedData, JSFunctionBaseImpl<?>> DATA_PROVIDER = psi -> {
        JSFunctionCachedData value = psi.initCachedData();
        return CachedValueProvider.Result.create((Object)value, (Object[])new Object[]{JSTypeUtils.getTypeInvalidationDependency()});
    };
    private static final Key<ParameterizedCachedValue<JSType, JSFunctionBaseImpl<?>>> TYPE_KEY = Key.create((String)"js.function.base.type");
    private static final ParameterizedCachedValueProvider<JSType, JSFunctionBaseImpl<?>> TYPE_PROVIDER = new ParameterizedCachedValueProvider<JSType, JSFunctionBaseImpl<?>>(){

        @Nullable
        public CachedValueProvider.Result<JSType> compute(JSFunctionBaseImpl<?> psi) {
            return this.captureCompute(psi);
        }

        private <StubT extends JSFunctionStubBase<?>> CachedValueProvider.Result<JSType> captureCompute(JSFunctionBaseImpl<StubT> psi) {
            JSFunctionStubBase stub = (JSFunctionStubBase)psi.getGreenStub();
            JSType returnType = stub != null ? psi.doGetStubReturnType(stub) : ((JSFunctionBaseImpl)psi).getCachedData().returnType;
            return CachedValueProvider.Result.create((Object)returnType, (Object[])new Object[]{JSTypeUtils.getTypeInvalidationDependency()});
        }
    };

    public JSFunctionBaseImpl(ASTNode node) {
        super(node);
    }

    public JSFunctionBaseImpl(T stub, IStubElementType type) {
        super(stub, type);
    }

    @Override
    public void clearCaches() {
        super.clearCaches();
        this.name = null;
        JSParameterList parameterList = this.getParameterList();
        if (parameterList != null) {
            for (JSParameter p : parameterList.getParameterVariables()) {
                ((JSParameterImpl)p).clearCaches();
            }
        }
    }

    public JSParameterList getParameterList() {
        return (JSParameterList)this.getStubOrPsiChild((IStubElementType)JSStubElementTypes.PARAMETER_LIST);
    }

    @NotNull
    public JSSourceElement[] getBody() {
        ASTNode[] children = this.getNode().getChildren(JSExtendedLanguagesTokenSetProvider.SOURCE_ELEMENTS);
        if (children.length == 0) {
            if (JSSourceElement.EMPTY_ARRAY == null) {
                JSFunctionBaseImpl.$$$reportNull$$$0(0);
            }
            return JSSourceElement.EMPTY_ARRAY;
        }
        JSSourceElement[] result2 = new JSSourceElement[children.length];
        for (int i = 0; i < children.length; ++i) {
            result2[i] = (JSSourceElement)children[i].getPsi();
        }
        if (result2 == null) {
            JSFunctionBaseImpl.$$$reportNull$$$0(1);
        }
        return result2;
    }

    public String getReturnTypeString() {
        JSFunctionStubBase stub = (JSFunctionStubBase)this.getGreenStub();
        if (stub != null) {
            return stub.getReturnTypeString();
        }
        return this.getCachedData().returnTypeString;
    }

    public PsiElement getReturnTypeElement() {
        ASTNode node = JSPsiImplUtils.getTypeExpressionFromDeclaration(this);
        return node != null ? node.getPsi() : null;
    }

    public PsiElement setName(@NotNull String name) throws IncorrectOperationException {
        if (name == null) {
            JSFunctionBaseImpl.$$$reportNull$$$0(2);
        }
        if (JSVariableBaseImpl.setComputedPropertyName(name, (PsiElement)this)) {
            return this;
        }
        ASTNode nameIdentifier = this.findNameIdentifier();
        if (nameIdentifier != null) {
            ASTNode newNameElement = JSChangeUtil.createPropertyNameWithContext(name, nameIdentifier);
            nameIdentifier.getTreeParent().replaceChild(nameIdentifier, newNameElement);
        }
        this.name = null;
        return this;
    }

    public boolean isGetProperty() {
        JSFunctionStubBase stub = (JSFunctionStubBase)this.getGreenStub();
        if (stub != null) {
            return stub.isGetProperty();
        }
        ASTNode node = this.getNode().findChildByType(JSTokenTypes.GET_KEYWORD);
        return node != null && node != this.findNameIdentifier();
    }

    public boolean isSetProperty() {
        JSFunctionStubBase stub = (JSFunctionStubBase)this.getGreenStub();
        if (stub != null) {
            return stub.isSetProperty();
        }
        ASTNode node = this.getNode().findChildByType(JSTokenTypes.SET_KEYWORD);
        return node != null && node != this.findNameIdentifier();
    }

    public String getName() {
        if (this.name == null) {
            this.name = this.doGetName();
        }
        return this.name;
    }

    protected String doGetName() {
        String nameFromComputed;
        JSFunctionStubBase stub = (JSFunctionStubBase)this.getGreenStub();
        if (stub != null) {
            return stub.getName();
        }
        if (this instanceof JSComputedPropertyNameOwner && (nameFromComputed = JSPsiImplUtils.getValidNameFromComputedName(((JSComputedPropertyNameOwner)this).getComputedPropertyName())) != null) {
            return nameFromComputed;
        }
        ASTNode name = this.findNameIdentifier();
        boolean computed = false;
        if (name == null) {
            name = JSPsiImplUtils.getComputedNameOfFunction(this.getNode(), false);
            computed = true;
        }
        if (name != null) {
            if (computed) {
                PsiElement psi = name.getPsi();
                if (psi instanceof ES6ComputedName) {
                    return ((ES6ComputedName)psi).getExpressionAsPropertyName();
                }
                return JSPsiImplUtils.getNameFromIdentifier(name);
            }
            return JSPsiImplUtils.getNameFromIdentifier(name);
        }
        return null;
    }

    public ASTNode findNameIdentifier() {
        return JSPsiImplUtils.findNameIdentifierOfFunction(this.getNode());
    }

    public int getTextOffset() {
        ASTNode name = this.findNameIdentifier();
        return name != null ? name.getStartOffset() : super.getTextOffset();
    }

    public boolean processDeclarations(@NotNull PsiScopeProcessor processor, @NotNull ResolveState state, PsiElement lastParent, @NotNull PsiElement place) {
        ResolveProcessor.ProcessingOptions funInternalDefsProcessingOptions;
        if (processor == null) {
            JSFunctionBaseImpl.$$$reportNull$$$0(3);
        }
        if (state == null) {
            JSFunctionBaseImpl.$$$reportNull$$$0(4);
        }
        if (place == null) {
            JSFunctionBaseImpl.$$$reportNull$$$0(5);
        }
        if ((funInternalDefsProcessingOptions = JSFunctionBaseImpl.getProcessingOptions(processor)).toProcessFunctionBodyDeclarations(lastParent, this)) {
            return this.processInnerAndBodyDeclarations(processor, state, lastParent, place, funInternalDefsProcessingOptions);
        }
        return this.processOuterDeclarations(processor, state, place);
    }

    protected boolean processOuterDeclarations(@NotNull PsiScopeProcessor processor, @NotNull ResolveState state, @NotNull PsiElement place) {
        if (processor == null) {
            JSFunctionBaseImpl.$$$reportNull$$$0(6);
        }
        if (state == null) {
            JSFunctionBaseImpl.$$$reportNull$$$0(7);
        }
        if (place == null) {
            JSFunctionBaseImpl.$$$reportNull$$$0(8);
        }
        processor.handleEvent(ResolveProcessor.SCOPE_CHANGE, (Object)this);
        return processor.execute((PsiElement)this, state);
    }

    protected boolean processInnerAndBodyDeclarations(@NotNull PsiScopeProcessor processor, @NotNull ResolveState state, PsiElement lastParent, @NotNull PsiElement place, ResolveProcessor.ProcessingOptions funInternalDefsProcessingOptions) {
        boolean result2;
        boolean b;
        if (processor == null) {
            JSFunctionBaseImpl.$$$reportNull$$$0(9);
        }
        if (state == null) {
            JSFunctionBaseImpl.$$$reportNull$$$0(10);
        }
        if (place == null) {
            JSFunctionBaseImpl.$$$reportNull$$$0(11);
        }
        if (place instanceof JSReferenceExpression && (!(b = JSImportHandlingUtil.tryResolveImports(processor, (PsiNamedElement)this, place)) || JSResolveUtil.isExprInStrictTypeContext((JSReferenceExpression)place))) {
            return b;
        }
        if (funInternalDefsProcessingOptions.toProcessFunctionArguments()) {
            JSParameterList parameterList = this.getParameterList();
            if (!this.processArguments(parameterList, processor, state, lastParent, place)) {
                return false;
            }
            if (!this.processImplicitArguments(processor, state)) {
                return false;
            }
        }
        if (result2 = JSResolveUtil.processDeclarationsInScope(this, processor, state, lastParent, place)) {
            processor.handleEvent(PsiScopeProcessor.Event.SET_DECLARATION_HOLDER, (Object)this);
        }
        return result2;
    }

    protected boolean processImplicitArguments(@NotNull PsiScopeProcessor processor, @NotNull ResolveState state) {
        if (processor == null) {
            JSFunctionBaseImpl.$$$reportNull$$$0(12);
        }
        if (state == null) {
            JSFunctionBaseImpl.$$$reportNull$$$0(13);
        }
        JSVariable argumentsVar = this.getImplicitArgumentsVar();
        return processor.execute((PsiElement)argumentsVar, state);
    }

    @NotNull
    private JSVariable getImplicitArgumentsVar() {
        JSVariable jSVariable = (JSVariable)CachedValuesManager.getManager((Project)this.getProject()).getParameterizedCachedValue((UserDataHolder)this, ARGUMENTS_VAR_KEY, ARGUMENTS_VAR_PROVIDER, false, (Object)this);
        if (jSVariable == null) {
            JSFunctionBaseImpl.$$$reportNull$$$0(14);
        }
        return jSVariable;
    }

    protected boolean processArguments(@Nullable JSParameterList parameterList, @NotNull PsiScopeProcessor processor, @NotNull ResolveState state, PsiElement lastParent, @NotNull PsiElement place) {
        if (processor == null) {
            JSFunctionBaseImpl.$$$reportNull$$$0(15);
        }
        if (state == null) {
            JSFunctionBaseImpl.$$$reportNull$$$0(16);
        }
        if (place == null) {
            JSFunctionBaseImpl.$$$reportNull$$$0(17);
        }
        if (parameterList != null) {
            for (JSParameter param : parameterList.getParameterVariables()) {
                if (param.processDeclarations(processor, state, lastParent, place)) continue;
                return false;
            }
        }
        return true;
    }

    private static ResolveProcessor.ProcessingOptions getProcessingOptions(@NotNull PsiScopeProcessor processor) {
        if (processor == null) {
            JSFunctionBaseImpl.$$$reportNull$$$0(18);
        }
        ResolveProcessor.ProcessingOptions funInternalDefsProcessingOptions = processor instanceof ResolveProcessor ? ((ResolveProcessor)processor).getProcessingOptions() : ResolveProcessor.DEFAULT_RESOLVE;
        return funInternalDefsProcessingOptions;
    }

    protected String getArgumentsClassName() {
        return "IArguments";
    }

    @Override
    public PsiElement addBefore(@NotNull PsiElement element, PsiElement anchor) throws IncorrectOperationException {
        if (element == null) {
            JSFunctionBaseImpl.$$$reportNull$$$0(19);
        }
        if (anchor == this.getFirstChild() && element instanceof JSAttributeList && anchor.getNode().getElementType() == JSTokenTypes.FUNCTION_KEYWORD) {
            return JSChangeUtil.doDoAddBefore((PsiElement)this, element, anchor);
        }
        return super.addBefore(element, anchor);
    }

    @NotNull
    public JSFunction.FunctionKind getKind() {
        if (this.isGetProperty()) {
            JSFunction.FunctionKind functionKind = JSFunction.FunctionKind.GETTER;
            if (functionKind == null) {
                JSFunctionBaseImpl.$$$reportNull$$$0(20);
            }
            return functionKind;
        }
        if (this.isSetProperty()) {
            JSFunction.FunctionKind functionKind = JSFunction.FunctionKind.SETTER;
            if (functionKind == null) {
                JSFunctionBaseImpl.$$$reportNull$$$0(21);
            }
            return functionKind;
        }
        if (this.isConstructor()) {
            JSFunction.FunctionKind functionKind = JSFunction.FunctionKind.CONSTRUCTOR;
            if (functionKind == null) {
                JSFunctionBaseImpl.$$$reportNull$$$0(22);
            }
            return functionKind;
        }
        JSFunction.FunctionKind functionKind = JSFunction.FunctionKind.SIMPLE;
        if (functionKind == null) {
            JSFunctionBaseImpl.$$$reportNull$$$0(23);
        }
        return functionKind;
    }

    @Override
    public boolean isDeprecated() {
        JSFunctionStubBase stub = (JSFunctionStubBase)this.getGreenStub();
        if (stub != null) {
            return stub.isDeprecated();
        }
        if (JSPsiImplUtils.isDeprecatedFromAttribute((JSAttributeListOwner)this)) {
            return true;
        }
        return JSDocumentationUtils.calculateDeprecated((PsiElement)this);
    }

    public boolean isReferencesArguments() {
        JSFunctionStubBase stub = (JSFunctionStubBase)this.getGreenStub();
        if (stub != null) {
            return stub.isReferencesArguments();
        }
        return this.getCachedData().referencesArguments;
    }

    public boolean constructorCanBeInvokedWithoutNew() {
        JSFunctionStubBase stub = (JSFunctionStubBase)this.getGreenStub();
        if (stub != null) {
            return stub.constructorCanBeInvokedWithoutNew();
        }
        return this.getCachedData().constructorCanBeInvokedWithoutNew;
    }

    public boolean isReferencesThis() {
        JSFunctionStubBase stub = (JSFunctionStubBase)this.getGreenStub();
        if (stub != null) {
            return stub.isReferencesThis();
        }
        return this.getCachedData().referencesThis;
    }

    @NotNull
    public JSParameterListElement[] getParameters() {
        JSParameterList parameterList = this.getParameterList();
        Object[] objectArray = parameterList != null ? parameterList.getParameters() : JSParameter.EMPTY_ARRAY;
        if (objectArray == null) {
            JSFunctionBaseImpl.$$$reportNull$$$0(24);
        }
        return objectArray;
    }

    @NotNull
    public JSParameter[] getParameterVariables() {
        JSParameterList parameterList = this.getParameterList();
        JSParameter[] jSParameterArray = parameterList != null ? parameterList.getParameterVariables() : JSParameter.EMPTY_ARRAY;
        if (jSParameterArray == null) {
            JSFunctionBaseImpl.$$$reportNull$$$0(25);
        }
        return jSParameterArray;
    }

    private JSFunctionCachedData initCachedData() {
        JSType type;
        final JSFunctionCachedData cachedData = new JSFunctionCachedData();
        ArrayList<JSFunction> nestedFuns = new ArrayList<JSFunction>(2);
        ArrayList<JSType> evaluatedReturnTypes = new ArrayList<JSType>();
        final TObjectIntHashMap declaredParameters = new TObjectIntHashMap(2);
        JSFunctionNodesVisitor cachedDataEvaluator = this.createCachingVisitor(cachedData, nestedFuns, evaluatedReturnTypes);
        cachedDataEvaluator.visitElement(this.getNode());
        cachedDataEvaluator.summarizeNamesUsages((TObjectIntHashMap<String>)declaredParameters);
        JSExpression expression = JSPsiImplUtils.tryGetArrowFunctionReturnExpression(this);
        if (expression != null && (type = cachedDataEvaluator.visitReturnNode(expression.getNode(), expression)) != null) {
            evaluatedReturnTypes.add(type);
        }
        for (JSFunction f : nestedFuns) {
            JSFunctionBaseImpl fun = (JSFunctionBaseImpl)f;
            fun.getCachedData().referencedVariableNames.forEachEntry((TObjectIntProcedure)new TObjectIntProcedure<String>(){

                public boolean execute(String a, int b) {
                    if (cachedData.declaredParameters.contains(a) && !cachedData.declaredVariableNames.contains((Object)a) && b == 1) {
                        declaredParameters.put((Object)a, 1);
                    } else if (!cachedData.declaredVariableNames.contains((Object)a)) {
                        cachedData.referencedVariableNames.put((Object)a, 1);
                    }
                    return true;
                }
            });
        }
        this.fillInfoFromDocComment(cachedData);
        JSType typeFromDeclaration = this.getReturnTypeFromDeclaration();
        if (typeFromDeclaration != null) {
            cachedData.returnType = typeFromDeclaration;
        }
        for (JSParameter p : this.getParameterVariables()) {
            JSParameterTypeDecorator parameterType;
            boolean explicitlyDeclared;
            boolean optional;
            JSType type2;
            String parameterName = p.getName();
            if (parameterName == null) continue;
            JSParameterTypeDecorator typeDecorator = cachedData.parameterTypes.get(parameterName);
            JSType jSType = type2 = typeDecorator != null ? typeDecorator.getType() : null;
            boolean bl = typeDecorator != null ? typeDecorator.isOptional() : (optional = (declaredParameters.get((Object)parameterName) & 1) != 0);
            boolean rest = typeDecorator != null ? typeDecorator.isRest() : (declaredParameters.get((Object)parameterName) & 2) != 0;
            boolean bl2 = explicitlyDeclared = typeDecorator != null && typeDecorator.isExplicitlyDeclared();
            if (type2 == null && (parameterType = JSDocumentationUtils.getParameterTypeFromPrecedingComment(p)) != null) {
                type2 = parameterType.getType();
                optional = parameterType.isOptional();
                rest = parameterType.isRest();
                explicitlyDeclared = true;
            }
            if (type2 != null) {
                type2.setSourceIfEmpty(JSTypeSourceFactory.createTypeSource((PsiElement)p, true));
            }
            if (type2 == null && !optional && !rest) continue;
            cachedData.parameterTypes.put(parameterName, new JSParameterTypeDecoratorImpl(type2, optional, rest, explicitlyDeclared));
        }
        if (!cachedData.declaredVariableNames.contains((Object)"arguments") && cachedData.referencedVariableNames.contains((Object)"arguments")) {
            cachedData.referencesArguments = true;
            cachedData.referencedVariableNames.remove((Object)"arguments");
        }
        if (cachedData.returnType == null) {
            cachedData.returnType = JSDocumentationUtils.getTypeFromReturnTypeComment(this);
        }
        if (cachedData.returnType == null) {
            cachedData.returnType = cachedDataEvaluator.getReturnTypeFromEvaluated();
        }
        cachedData.returnTypeString = cachedData.returnType == null ? null : cachedData.returnType.getTypeText(JSType.TypeTextFormat.SERIALIZED);
        return cachedData;
    }

    @NotNull
    protected JSFunctionNodesVisitor createCachingVisitor(JSFunctionCachedData cachedData, List<JSFunction> nestedFuns, List<JSType> evaluatedReturnTypes) {
        JSFunctionNodesVisitor jSFunctionNodesVisitor = new JSFunctionNodesVisitor(this, cachedData, nestedFuns, evaluatedReturnTypes){

            @Override
            @NotNull
            protected JSType getTypeFromReturnedExpression(@NotNull ASTNode context, @Nullable JSExpression expression) {
                JSType type;
                if (context == null) {
                    2.$$$reportNull$$$0(0);
                }
                if (expression instanceof JSReferenceExpression && ((JSReferenceExpression)expression).getQualifier() == null) {
                    JSType predefinedType = JSSymbolUtil.getPredefinedType((JSReferenceExpression)expression);
                    if (predefinedType != null) {
                        JSType jSType = predefinedType;
                        if (jSType == null) {
                            2.$$$reportNull$$$0(1);
                        }
                        return jSType;
                    }
                    String referenceName = ((JSReferenceExpression)expression).getReferenceName();
                    if (referenceName != null) {
                        JSTypeSource typeSource = JSTypeSourceFactory.createTypeSource((PsiElement)expression, true, false);
                        JSReferenceType jSReferenceType = new JSReferenceType(referenceName, typeSource);
                        if (jSReferenceType == null) {
                            2.$$$reportNull$$$0(2);
                        }
                        return jSReferenceType;
                    }
                }
                Object object = (type = super.getTypeFromReturnedExpression(context, expression)) != null ? type : JSAnyType.get(context.getPsi(), false);
                if (object == null) {
                    2.$$$reportNull$$$0(3);
                }
                return object;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                RuntimeException runtimeException;
                Object[] objectArray;
                Object[] objectArray2;
                int n2;
                String string;
                switch (n) {
                    default: {
                        string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                        break;
                    }
                    case 1: 
                    case 2: 
                    case 3: {
                        string = "@NotNull method %s.%s must not return null";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        n2 = 3;
                        break;
                    }
                    case 1: 
                    case 2: 
                    case 3: {
                        n2 = 2;
                        break;
                    }
                }
                Object[] objectArray3 = new Object[n2];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "context";
                        break;
                    }
                    case 1: 
                    case 2: 
                    case 3: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "com/intellij/lang/javascript/psi/impl/JSFunctionBaseImpl$2";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[1] = "com/intellij/lang/javascript/psi/impl/JSFunctionBaseImpl$2";
                        break;
                    }
                    case 1: 
                    case 2: 
                    case 3: {
                        objectArray = objectArray2;
                        objectArray2[1] = "getTypeFromReturnedExpression";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray;
                        objectArray[2] = "getTypeFromReturnedExpression";
                        break;
                    }
                    case 1: 
                    case 2: 
                    case 3: {
                        break;
                    }
                }
                String string2 = String.format(string, objectArray);
                switch (n) {
                    default: {
                        runtimeException = new IllegalArgumentException(string2);
                        break;
                    }
                    case 1: 
                    case 2: 
                    case 3: {
                        runtimeException = new IllegalStateException(string2);
                        break;
                    }
                }
                throw runtimeException;
            }
        };
        if (jSFunctionNodesVisitor == null) {
            JSFunctionBaseImpl.$$$reportNull$$$0(26);
        }
        return jSFunctionNodesVisitor;
    }

    private JSFunctionCachedData getCachedData() {
        return (JSFunctionCachedData)CachedValuesManager.getManager((Project)this.getProject()).getParameterizedCachedValue((UserDataHolder)this, DATA_KEY, DATA_PROVIDER, false, (Object)this);
    }

    public void addReferencedExternalNames(Set<String> names) {
        this.getCachedData().referencedVariableNames.forEach(object -> {
            names.add((String)object);
            return true;
        });
    }

    protected boolean seemsToBePropertyAccessor() {
        if (this.isGetProperty() || this.isSetProperty()) {
            return true;
        }
        String name = this.getName();
        return name != null && (name.startsWith("get") || name.startsWith("set"));
    }

    protected void fillInfoFromDocComment(@NotNull JSFunctionCachedData cachedFunctionData) {
        JSType typeFromTrailingComment;
        if (cachedFunctionData == null) {
            JSFunctionBaseImpl.$$$reportNull$$$0(27);
        }
        JSTypeSource functionTypeSource = JSTypeSourceFactory.createTypeSource((PsiElement)this, true);
        PsiElement docComment = this.findFunctionOrPropertyDocComment();
        if (docComment != null) {
            MyJSDocumentationProcessor processor = new MyJSDocumentationProcessor(cachedFunctionData, functionTypeSource);
            JSDocumentationUtils.processDocumentationTextFromComment(docComment.getNode(), processor);
        }
        if ((typeFromTrailingComment = JSDocumentationUtils.getTypeFromTrailingComment(this)) != null && cachedFunctionData.returnType == null) {
            cachedFunctionData.returnType = typeFromTrailingComment;
        }
    }

    protected JSType getReturnTypeFromDeclaration() {
        return JSPsiImplUtils.getTypeFromDeclaration(this);
    }

    private PsiElement findFunctionOrPropertyDocComment() {
        PsiComment docComment = JSDocumentationUtils.findFunctionComment(this);
        if (docComment == null && this.seemsToBePropertyAccessor()) {
            JSExpression rOperand;
            JSExpression expression;
            JSStatement statement = (JSStatement)PsiTreeUtil.getParentOfType((PsiElement)this, JSStatement.class);
            JSStatement prevStatement = (JSStatement)PsiTreeUtil.getPrevSiblingOfType((PsiElement)statement, JSStatement.class);
            JSFunctionBaseImpl prevFunction = null;
            if (prevStatement instanceof JSExpressionStatement && (expression = ((JSExpressionStatement)prevStatement).getExpression()) instanceof JSAssignmentExpression && (rOperand = ((JSAssignmentExpression)expression).getROperand()) instanceof JSFunctionBaseImpl) {
                prevFunction = (JSFunctionBaseImpl)rOperand;
            }
            if (prevFunction != null && prevFunction.seemsToBePropertyAccessor()) {
                docComment = JSDocumentationUtils.findFunctionComment(prevFunction);
            }
        }
        return docComment;
    }

    public boolean isConstructor() {
        JSFunctionStubBase stub = (JSFunctionStubBase)this.getGreenStub();
        if (stub != null) {
            return stub.isConstructor();
        }
        return this.getCachedData().constructor;
    }

    public boolean isOverride() {
        JSFunctionStubBase stub = (JSFunctionStubBase)this.getGreenStub();
        if (stub != null) {
            return stub.isOverride();
        }
        return this.getCachedData().overrides;
    }

    private static void processFunctionLevelDocTag(JSDocumentationProcessor.MetaDocType type, String matchName, JSFunctionCachedData cachedFunctionData, JSTypeSource typeSource) {
        if (type == JSDocumentationProcessor.MetaDocType.RETURN) {
            cachedFunctionData.returnType = JSTypeUtils.createTypeFromJSDoc(matchName, typeSource);
        } else if (type == JSDocumentationProcessor.MetaDocType.TYPE) {
            JSType jsType = JSTypeUtils.createTypeFromJSDoc(matchName, typeSource);
            if (jsType instanceof JSFunctionTypeImpl) {
                cachedFunctionData.returnType = ((JSFunctionTypeImpl)jsType).getReturnType();
            } else if (!(jsType instanceof JSPrimitiveFunctionType)) {
                cachedFunctionData.returnType = jsType;
            }
        } else if (type == JSDocumentationProcessor.MetaDocType.CONSTRUCTOR || type == JSDocumentationProcessor.MetaDocType.CONSTRUCTS || type == JSDocumentationProcessor.MetaDocType.CLASS || type == JSDocumentationProcessor.MetaDocType.INTERFACE) {
            cachedFunctionData.constructor = true;
        }
    }

    public boolean isOptional(JSParameter parameter) {
        JSParameterTypeDecorator decorator = this.getCachedData().parameterTypes.get(parameter.getName());
        return decorator != null && decorator.isOptional();
    }

    public boolean isRest(JSParameter parameter) {
        JSParameterTypeDecorator decorator = this.getCachedData().parameterTypes.get(parameter.getName());
        return decorator != null && decorator.isRest();
    }

    public boolean isTypeExplicitlyDeclared(JSParameter parameter) {
        JSParameterTypeDecorator decorator = this.getCachedData().parameterTypes.get(parameter.getName());
        return decorator != null && decorator.isExplicitlyDeclared();
    }

    @Nullable
    public JSType getTypeFromComments(@NotNull JSParameter jsParameter) {
        String parameterName;
        JSParameterTypeDecorator decorator;
        if (jsParameter == null) {
            JSFunctionBaseImpl.$$$reportNull$$$0(28);
        }
        JSParameterTypeDecorator jSParameterTypeDecorator = decorator = (parameterName = jsParameter.getName()) != null ? this.getCachedData().parameterTypes.get(parameterName) : null;
        if (decorator == null && JSDestructuringUtil.isDestructuring(jsParameter.getParent())) {
            JSType appliedContext;
            JSType dummyType;
            String dummyName;
            JSParameterTypeDecorator dummyTypeDecorator;
            HashMap<Integer, String> tagNames;
            JSDocumentationUtils.JSTagToParameterMap tagToParameterMap;
            int tagIndex;
            JSEvaluateContext evaluateContext = new JSEvaluateContext(this.getContainingFile());
            JSInitializerOwner parent = JSDestructuringUtil.findDestructuringParent((JSElement)jsParameter, evaluateContext, (Condition<JSInitializerOwner>)((Condition)JSDestructuringParameter.class::isInstance));
            PsiElement comment = this.findFunctionOrPropertyDocComment();
            if (comment instanceof JSDocComment && parent instanceof JSDestructuringParameter && (tagIndex = (tagToParameterMap = JSDocumentationUtils.getTagToParameterMap((JSDocComment)comment, this, tagNames = new HashMap<Integer, String>())).getTagForParameter((JSParameterListElement)((JSDestructuringParameter)parent))) >= 0 && (dummyTypeDecorator = this.getCachedData().parameterTypes.get(dummyName = (String)tagNames.get(tagIndex))) != null && (dummyType = dummyTypeDecorator.getType()) != null && (appliedContext = JSApplyContextUtil.getTypeWithAppliedContext(dummyType, evaluateContext)) != null) {
                return appliedContext;
            }
        }
        return decorator != null ? decorator.getType() : null;
    }

    protected static boolean isInJS(ASTNode node) {
        ASTNode parent = node.getTreeParent();
        return parent == null || parent.getElementType().getLanguage() instanceof JavascriptLanguage;
    }

    public PsiElement getNameIdentifier() {
        ASTNode node = this.findNameIdentifier();
        return node != null ? node.getPsi() : null;
    }

    @Nullable
    public JSType getReturnType() {
        return (JSType)CachedValuesManager.getManager((Project)this.getProject()).getParameterizedCachedValue((UserDataHolder)this, TYPE_KEY, TYPE_PROVIDER, false, (Object)this);
    }

    protected JSType doGetStubReturnType(T stub) {
        JSTypeSource source = JSTypeSourceFactory.createTypeSource((PsiElement)this, stub.isReturnTypeStrict(), stub.isReturnTypeExplicitlyDeclared());
        JSType returnType = JSTypeUtils.parseSerializedType(stub.getReturnTypeString(), source);
        return returnType;
    }

    public String getQualifiedName() {
        return JSPsiImplUtils.buildQualifiedNameFromNamespaceAndName(this);
    }

    public boolean isNamespaceExplicitlyDeclared() {
        return true;
    }

    @NotNull
    public JSAttributeList.AccessType getAccessType() {
        JSFunctionStubBase stub = (JSFunctionStubBase)this.getGreenStub();
        if (stub != null) {
            JSAttributeList.AccessType accessType = stub.getAccessType();
            if (accessType == null) {
                JSFunctionBaseImpl.$$$reportNull$$$0(29);
            }
            return accessType;
        }
        JSAttributeList.AccessType accessType = JSPsiImplUtils.getAccessType(this);
        if (accessType == null) {
            JSFunctionBaseImpl.$$$reportNull$$$0(30);
        }
        return accessType;
    }

    @NotNull
    public Map<String, JSReferenceExpression> getExtensionSymbols() {
        Map<String, JSReferenceExpression> map = this.getCachedData().extensionSymbols;
        if (map == null) {
            JSFunctionBaseImpl.$$$reportNull$$$0(31);
        }
        return map;
    }

    public boolean isAnonymousFunctionCall() {
        return false;
    }

    @NotNull
    public JSContext getJSContext() {
        JSFunctionStubBase stub = (JSFunctionStubBase)this.getGreenStub();
        if (stub != null) {
            JSContext jSContext = stub.getJSContext();
            if (jSContext == null) {
                JSFunctionBaseImpl.$$$reportNull$$$0(32);
            }
            return jSContext;
        }
        JSContext jSContext = JSSymbolUtil.getContext(this, this.useTypesFromJSDoc());
        if (jSContext == null) {
            JSFunctionBaseImpl.$$$reportNull$$$0(33);
        }
        return jSContext;
    }

    @Nullable
    public JSAttributeList getAttributeList() {
        return JSUtils.getAttributeList(this);
    }

    public boolean isGenerator() {
        if (this.getNode().findChildByType(JSTokenTypes.MULT) != null) {
            return true;
        }
        JSAttributeList list = this.getAttributeList();
        return list != null && list.hasModifier(JSAttributeList.ModifierType.GENERATOR);
    }

    @Override
    @NotNull
    public JSElementBase.ClassOrInterface isClassOrInterface() {
        JSFunctionStubBase stub = (JSFunctionStubBase)this.getGreenStub();
        if (stub != null) {
            JSElementBase.ClassOrInterface classOrInterface = stub.isClassOrInterface();
            if (classOrInterface == null) {
                JSFunctionBaseImpl.$$$reportNull$$$0(34);
            }
            return classOrInterface;
        }
        if (this.getParent() instanceof JSClass) {
            JSElementBase.ClassOrInterface classOrInterface = JSElementBase.ClassOrInterface.NONE;
            if (classOrInterface == null) {
                JSFunctionBaseImpl.$$$reportNull$$$0(35);
            }
            return classOrInterface;
        }
        JSElementBase.ClassOrInterface classOrInterface = super.isClassOrInterface();
        JSElementBase.ClassOrInterface classOrInterface2 = classOrInterface != JSElementBase.ClassOrInterface.NONE ? classOrInterface : (this.isConstructor() ? JSElementBase.ClassOrInterface.CLASS : JSElementBase.ClassOrInterface.NONE);
        if (classOrInterface2 == null) {
            JSFunctionBaseImpl.$$$reportNull$$$0(36);
        }
        return classOrInterface2;
    }

    protected boolean useTypesFromJSDoc() {
        return true;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 27: 
            case 28: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 27: 
            case 28: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/javascript/psi/impl/JSFunctionBaseImpl";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 3: 
            case 6: 
            case 9: 
            case 12: 
            case 15: 
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "processor";
                break;
            }
            case 4: 
            case 7: 
            case 10: 
            case 13: 
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "state";
                break;
            }
            case 5: 
            case 8: 
            case 11: 
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "place";
                break;
            }
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 27: {
                objectArray2 = objectArray3;
                objectArray3[0] = "cachedFunctionData";
                break;
            }
            case 28: {
                objectArray2 = objectArray3;
                objectArray3[0] = "jsParameter";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getBody";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 27: 
            case 28: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/javascript/psi/impl/JSFunctionBaseImpl";
                break;
            }
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "getImplicitArgumentsVar";
                break;
            }
            case 20: 
            case 21: 
            case 22: 
            case 23: {
                objectArray = objectArray2;
                objectArray2[1] = "getKind";
                break;
            }
            case 24: {
                objectArray = objectArray2;
                objectArray2[1] = "getParameters";
                break;
            }
            case 25: {
                objectArray = objectArray2;
                objectArray2[1] = "getParameterVariables";
                break;
            }
            case 26: {
                objectArray = objectArray2;
                objectArray2[1] = "createCachingVisitor";
                break;
            }
            case 29: 
            case 30: {
                objectArray = objectArray2;
                objectArray2[1] = "getAccessType";
                break;
            }
            case 31: {
                objectArray = objectArray2;
                objectArray2[1] = "getExtensionSymbols";
                break;
            }
            case 32: 
            case 33: {
                objectArray = objectArray2;
                objectArray2[1] = "getJSContext";
                break;
            }
            case 34: 
            case 35: 
            case 36: {
                objectArray = objectArray2;
                objectArray2[1] = "isClassOrInterface";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "setName";
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "processDeclarations";
                break;
            }
            case 6: 
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "processOuterDeclarations";
                break;
            }
            case 9: 
            case 10: 
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "processInnerAndBodyDeclarations";
                break;
            }
            case 12: 
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "processImplicitArguments";
                break;
            }
            case 15: 
            case 16: 
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "processArguments";
                break;
            }
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "getProcessingOptions";
                break;
            }
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "addBefore";
                break;
            }
            case 27: {
                objectArray = objectArray;
                objectArray[2] = "fillInfoFromDocComment";
                break;
            }
            case 28: {
                objectArray = objectArray;
                objectArray[2] = "getTypeFromComments";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 27: 
            case 28: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class MyJSDocumentationProcessor
    implements JSDocumentationProcessor {
        @NotNull
        private final Set<JSQualifiedName> myOptionalParameters;
        @NotNull
        private final Map<String, JSParameterTypeDecorator> myParameterTypes;
        @NotNull
        private final Map<JSQualifiedName, String> myParameterProperties;
        @NotNull
        private final JSTypeSource myFunctionTypeSource;
        @NotNull
        private final JSFunctionCachedData myCachedFunctionData;
        @Nullable
        private String lastParameterName;
        @Nullable
        private Set<String> genericParameters;
        private boolean parametersAreOptional;
        private boolean docCommentHasOverrides;

        public MyJSDocumentationProcessor(@NotNull JSFunctionCachedData cachedFunctionData, @NotNull JSTypeSource functionTypeSource) {
            if (cachedFunctionData == null) {
                MyJSDocumentationProcessor.$$$reportNull$$$0(0);
            }
            if (functionTypeSource == null) {
                MyJSDocumentationProcessor.$$$reportNull$$$0(1);
            }
            this.myOptionalParameters = new THashSet();
            this.myCachedFunctionData = cachedFunctionData;
            this.myFunctionTypeSource = functionTypeSource;
            this.myParameterTypes = new LinkedHashMap<String, JSParameterTypeDecorator>();
            this.myParameterProperties = new LinkedHashMap<JSQualifiedName, String>();
        }

        @Override
        public boolean needsPlainCommentData() {
            return false;
        }

        @Override
        public boolean onCommentLine(@NotNull String line) {
            if (line == null) {
                MyJSDocumentationProcessor.$$$reportNull$$$0(2);
            }
            return true;
        }

        @Override
        public boolean onPatternMatch(@NotNull JSDocumentationProcessor.MetaDocType type, @Nullable String matchName, @Nullable String matchValue, @Nullable String remainingLineContent, @NotNull String line, @NotNull String patternMatched) {
            if (type == null) {
                MyJSDocumentationProcessor.$$$reportNull$$$0(3);
            }
            if (line == null) {
                MyJSDocumentationProcessor.$$$reportNull$$$0(4);
            }
            if (patternMatched == null) {
                MyJSDocumentationProcessor.$$$reportNull$$$0(5);
            }
            boolean consumed = false;
            if (type == JSDocumentationProcessor.MetaDocType.TYPE && matchName != null) {
                JSType jsType = new JSTypeParser(matchName, JSTypeSource.EMPTY).parse();
                if (!(jsType instanceof JSFunctionTypeImpl) && !(jsType instanceof JSPrimitiveFunctionType) && this.myCachedFunctionData.declaredParameters.size() == 1) {
                    this.registerParameter(this.myCachedFunctionData.declaredParameters.iterator().next(), matchName);
                    consumed = true;
                }
            } else if (type == JSDocumentationProcessor.MetaDocType.PARAMETER && matchName != null && this.myCachedFunctionData.declaredParameters.contains(matchName)) {
                this.registerParameter(matchName, matchValue);
                this.lastParameterName = matchName;
            } else if (type == JSDocumentationProcessor.MetaDocType.OVERRIDE || type == JSDocumentationProcessor.MetaDocType.INHERIT_DOC) {
                this.docCommentHasOverrides = true;
            } else if (type == JSDocumentationProcessor.MetaDocType.FIELD) {
                if (matchName != null) {
                    this.registerParameter(matchName, matchValue);
                }
            } else if (type == JSDocumentationProcessor.MetaDocType.TEMPLATE && matchName != null) {
                List generics = StringUtil.split((String)matchName, (String)",");
                if (this.genericParameters == null) {
                    this.genericParameters = new THashSet();
                }
                for (String generic : generics) {
                    this.genericParameters.add(generic.trim());
                }
            }
            if (type == JSDocumentationProcessor.MetaDocType.OPTIONAL_PARAMETERS || type == JSDocumentationProcessor.MetaDocType.PARAMETER) {
                String optionalParameterName = matchName != null && matchValue == null ? matchName : this.lastParameterName;
                JSParameterTypeDecorator parameterType = JSTypeUtils.createParameterType(matchValue, JSTypeSource.EMPTY);
                boolean parameterIsOptional = type == JSDocumentationProcessor.MetaDocType.OPTIONAL_PARAMETERS && (matchName == null || matchName.indexOf(46) == -1) || type == JSDocumentationProcessor.MetaDocType.PARAMETER && parameterType != null && parameterType.isOptional();
                this.parametersAreOptional |= type == JSDocumentationProcessor.MetaDocType.OPTIONAL_PARAMETERS && matchName == null;
                if ((parameterIsOptional || this.parametersAreOptional) && optionalParameterName != null) {
                    this.myOptionalParameters.add(JSQualifiedNameImpl.fromQualifiedName(optionalParameterName));
                }
                if (type == JSDocumentationProcessor.MetaDocType.OPTIONAL_PARAMETERS && matchName != null && matchName.indexOf(46) >= 0) {
                    this.makeFieldOptional(matchName);
                }
            } else if (!consumed) {
                JSFunctionBaseImpl.processFunctionLevelDocTag(type, matchName, this.myCachedFunctionData, this.myFunctionTypeSource);
            }
            return true;
        }

        private void registerParameter(@NotNull String matchName, @Nullable String matchValue) {
            if (matchName == null) {
                MyJSDocumentationProcessor.$$$reportNull$$$0(6);
            }
            JSQualifiedNameImpl qName = JSQualifiedNameImpl.fromQualifiedName(matchName);
            JSParameterTypeDecorator parameterType = JSTypeUtils.createParameterType(matchValue, JSTypeSource.EMPTY, false, true);
            if (parameterType != null && parameterType.isOptional()) {
                this.myOptionalParameters.add(qName);
            }
            if (qName.getParent() == null) {
                String name = qName.getName();
                JSParameterTypeDecorator oldType = this.myParameterTypes.get(name);
                JSParameterTypeDecorator newType = JSTypeUtils.createParameterType(matchValue, JSTypeSource.EMPTY, false, true);
                if (oldType == null || oldType.getType() == null && newType != null && newType.getType() != null) {
                    this.myParameterTypes.put(name, newType);
                } else if (newType != null) {
                    JSType composite = oldType.getType() == null ? newType.getType() : (newType.getType() == null ? oldType.getType() : new JSCompositeTypeImpl(JSTypeSource.EMPTY, oldType.getType(), newType.getType()));
                    JSParameterTypeDecoratorImpl newDecorator = new JSParameterTypeDecoratorImpl(composite, oldType.isOptional() || newType.isOptional(), oldType.isRest() || newType.isRest(), true);
                    this.myParameterTypes.put(matchName, newDecorator);
                }
            } else {
                this.myParameterProperties.put(qName, matchValue);
            }
        }

        private void makeFieldOptional(@NotNull String matchName) {
            if (matchName == null) {
                MyJSDocumentationProcessor.$$$reportNull$$$0(7);
            }
            this.myOptionalParameters.add(JSQualifiedNameImpl.fromQualifiedName(matchName));
        }

        @Override
        public void postProcess() {
            this.myCachedFunctionData.overrides = this.docCommentHasOverrides;
            THashSet declaredParameters = new THashSet();
            LinkedHashMap<String, JSType> evaluatedTypes = new LinkedHashMap<String, JSType>();
            THashSet restParameters = new THashSet();
            for (Map.Entry<String, JSParameterTypeDecorator> entry : this.myParameterTypes.entrySet()) {
                JSParameterTypeDecorator parameterType = entry.getValue();
                if (parameterType == null) continue;
                evaluatedTypes.put(entry.getKey(), parameterType.getType());
                if (parameterType.isOptional()) {
                    this.myOptionalParameters.add(JSQualifiedNameImpl.create((String)entry.getKey(), null));
                }
                if (!parameterType.isRest()) continue;
                restParameters.add(entry.getKey());
            }
            if (!this.myParameterProperties.isEmpty()) {
                JSRecordType dummyType = JSTypeUtils.buildRecordTypeFromProperties(this.myParameterProperties, this.myOptionalParameters, JSTypeSource.EMPTY);
                assert (dummyType != null);
                for (JSRecordType.TypeMember typeMember : dummyType.getTypeMembers()) {
                    assert (typeMember instanceof JSRecordType.PropertySignature);
                    String name = ((JSRecordType.PropertySignature)typeMember).getMemberName();
                    JSType rawType = (JSType)evaluatedTypes.get(name);
                    JSType propertyType = ((JSRecordType.PropertySignature)typeMember).getType();
                    Ref objectReplaced = Ref.create((Object)false);
                    if (rawType != null && propertyType != null) {
                        JSType typeWithObjectReplaced = JSTypeUtils.applyCompositeMapping(rawType, (Function<JSType, JSType>)((Function)type -> {
                            if (type instanceof JSObjectType && !((Boolean)objectReplaced.get()).booleanValue()) {
                                objectReplaced.set((Object)true);
                                return propertyType;
                            }
                            return type;
                        }));
                        if (((Boolean)objectReplaced.get()).booleanValue()) {
                            evaluatedTypes.put(name, typeWithObjectReplaced);
                        }
                    } else if (rawType == null && propertyType != null) {
                        evaluatedTypes.put(name, propertyType);
                        objectReplaced.set((Object)true);
                    }
                    if (((Boolean)objectReplaced.get()).booleanValue() || rawType == null || propertyType == null) continue;
                    JSCompositeTypeImpl compositeType = new JSCompositeTypeImpl(JSTypeSource.EMPTY, rawType, propertyType);
                    evaluatedTypes.put(name, compositeType);
                }
            }
            declaredParameters.addAll(evaluatedTypes.keySet());
            for (JSQualifiedName optionalParameter : this.myOptionalParameters) {
                if (optionalParameter.getParent() != null) continue;
                declaredParameters.add((Object)optionalParameter.getName());
            }
            this.addGenericParameters(evaluatedTypes);
            for (String parameter : declaredParameters) {
                JSParameterTypeDecoratorImpl decorator = new JSParameterTypeDecoratorImpl((JSType)evaluatedTypes.get(parameter), this.myOptionalParameters.contains(JSQualifiedNameImpl.fromQualifiedName(parameter)), restParameters.contains(parameter), true);
                this.myCachedFunctionData.parameterTypes.put(parameter, decorator);
            }
        }

        private void addGenericParameters(@NotNull Map<String, JSType> types) {
            if (types == null) {
                MyJSDocumentationProcessor.$$$reportNull$$$0(8);
            }
            if (this.genericParameters == null) {
                return;
            }
            for (Map.Entry<String, JSType> entry : types.entrySet()) {
                JSType type = entry.getValue();
                if (type == null) continue;
                type.setSourceIfEmpty(this.myFunctionTypeSource);
                if (this.genericParameters.isEmpty()) continue;
                entry.setValue(JSTypeUtils.addGenericParameters(type, this.genericParameters));
            }
            if (this.myCachedFunctionData.returnType != null) {
                this.myCachedFunctionData.returnType.setSourceIfEmpty(this.myFunctionTypeSource);
                if (!this.genericParameters.isEmpty()) {
                    this.myCachedFunctionData.returnType = JSTypeUtils.addGenericParameters(this.myCachedFunctionData.returnType, this.genericParameters);
                }
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "cachedFunctionData";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "functionTypeSource";
                    break;
                }
                case 2: 
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "line";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "type";
                    break;
                }
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "patternMatched";
                    break;
                }
                case 6: 
                case 7: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "matchName";
                    break;
                }
                case 8: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "types";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/lang/javascript/psi/impl/JSFunctionBaseImpl$MyJSDocumentationProcessor";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[2] = "onCommentLine";
                    break;
                }
                case 3: 
                case 4: 
                case 5: {
                    objectArray = objectArray2;
                    objectArray2[2] = "onPatternMatch";
                    break;
                }
                case 6: {
                    objectArray = objectArray2;
                    objectArray2[2] = "registerParameter";
                    break;
                }
                case 7: {
                    objectArray = objectArray2;
                    objectArray2[2] = "makeFieldOptional";
                    break;
                }
                case 8: {
                    objectArray = objectArray2;
                    objectArray2[2] = "addGenericParameters";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

