/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.psi.impl;

import com.intellij.lang.ASTNode;
import com.intellij.lang.javascript.JSTokenTypes;
import com.intellij.lang.javascript.index.JSSymbolUtil;
import com.intellij.lang.javascript.psi.JSAssignmentExpression;
import com.intellij.lang.javascript.psi.JSElementBase;
import com.intellij.lang.javascript.psi.JSElementVisitor;
import com.intellij.lang.javascript.psi.JSExpression;
import com.intellij.lang.javascript.psi.JSFunctionExpression;
import com.intellij.lang.javascript.psi.JSNamespace;
import com.intellij.lang.javascript.psi.JSProperty;
import com.intellij.lang.javascript.psi.JSQualifiedName;
import com.intellij.lang.javascript.psi.ecmal4.JSQualifiedNamedElement;
import com.intellij.lang.javascript.psi.impl.JSChangeUtil;
import com.intellij.lang.javascript.psi.impl.JSFunctionBaseImpl;
import com.intellij.lang.javascript.psi.impl.JSPropertyImpl;
import com.intellij.lang.javascript.psi.impl.JSPsiImplUtils;
import com.intellij.lang.javascript.psi.resolve.ResolveProcessor;
import com.intellij.lang.javascript.psi.stubs.JSFunctionStubBase;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.ResolveState;
import com.intellij.psi.scope.PsiScopeProcessor;
import com.intellij.psi.stubs.IStubElementType;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.PlatformIcons;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JSFunctionExpressionImpl<StubT extends JSFunctionStubBase<?>>
extends JSFunctionBaseImpl<JSFunctionStubBase<?>>
implements JSFunctionExpression {
    public JSFunctionExpressionImpl(ASTNode node) {
        super(node);
    }

    public JSFunctionExpressionImpl(StubT stub, IStubElementType type) {
        super(stub, type);
    }

    @Override
    public void accept(@NotNull PsiElementVisitor visitor) {
        if (visitor == null) {
            JSFunctionExpressionImpl.$$$reportNull$$$0(0);
        }
        if (visitor instanceof JSElementVisitor) {
            ((JSElementVisitor)visitor).visitJSFunctionExpression((JSFunctionExpression)this);
        } else {
            visitor.visitElement((PsiElement)this);
        }
    }

    public JSExpression replace(JSExpression newExpr) {
        return JSChangeUtil.replaceExpression((JSExpression)this, newExpr);
    }

    @Nullable
    public PsiElement getOwnNameIdentifier() {
        PsiElement parent = this.getParent();
        if (parent instanceof JSProperty && parent.getNode().findChildByType(JSTokenTypes.COLON) == null) {
            return null;
        }
        ASTNode identifierNode = JSPsiImplUtils.findNameIdentifierOfFunction(this.getNode(), true);
        return identifierNode != null ? identifierNode.getPsi() : null;
    }

    @Override
    public ASTNode findNameIdentifier() {
        PsiElement ownNameIdentifier = this.getOwnNameIdentifier();
        if (ownNameIdentifier != null) {
            return ownNameIdentifier.getNode();
        }
        JSQualifiedNamedElement assignedTo = this.getElementAssignedTo();
        if (assignedTo != null) {
            return assignedTo.findNameIdentifier();
        }
        return null;
    }

    public void delete() throws IncorrectOperationException {
        PsiElement parent = this.getParent();
        if (parent instanceof JSAssignmentExpression) {
            ((JSAssignmentExpression)parent).getLOperand().delete();
            return;
        }
        super.delete();
    }

    public Icon getIcon(int flags) {
        JSQualifiedNamedElement assignedTo = this.getElementAssignedTo();
        if (assignedTo != null) {
            return assignedTo.getIcon(flags);
        }
        return JSFunctionExpressionImpl.blendFlags(PlatformIcons.METHOD_ICON, true, false);
    }

    @Override
    public boolean isGetProperty() {
        JSFunctionStubBase stub = (JSFunctionStubBase)this.getGreenStub();
        if (stub != null) {
            return stub.isGetProperty();
        }
        return super.isGetProperty() || JSPropertyImpl.findAccessNodeAsIdentifier(JSTokenTypes.GET_KEYWORD, this.getNode()) != null;
    }

    @Override
    public boolean isSetProperty() {
        JSFunctionStubBase stub = (JSFunctionStubBase)this.getGreenStub();
        if (stub != null) {
            return stub.isSetProperty();
        }
        return super.isSetProperty() || JSPropertyImpl.findAccessNodeAsIdentifier(JSTokenTypes.SET_KEYWORD, this.getNode()) != null;
    }

    @Nullable
    public JSQualifiedName getNamespace() {
        JSFunctionStubBase stub = (JSFunctionStubBase)this.getGreenStub();
        if (stub != null) {
            return stub.getNamespace();
        }
        JSQualifiedNamedElement baseElement = this.getElementAssignedTo();
        if (baseElement != null) {
            return baseElement.getNamespace();
        }
        return null;
    }

    @Override
    public boolean isNamespaceExplicitlyDeclared() {
        JSFunctionStubBase stub = (JSFunctionStubBase)this.getGreenStub();
        if (stub != null) {
            return stub.isNamespaceExplicitlyDeclared();
        }
        JSQualifiedNamedElement baseElement = this.getElementAssignedTo();
        return baseElement != null && baseElement.isNamespaceExplicitlyDeclared();
    }

    @Override
    @NotNull
    public JSNamespace getJSNamespace() {
        JSFunctionStubBase stub = (JSFunctionStubBase)this.getGreenStub();
        if (stub != null) {
            JSNamespace jSNamespace = stub.getJSNamespace();
            if (jSNamespace == null) {
                JSFunctionExpressionImpl.$$$reportNull$$$0(1);
            }
            return jSNamespace;
        }
        JSQualifiedNamedElement baseElement = this.getElementAssignedTo();
        if (baseElement != null) {
            JSNamespace jSNamespace = baseElement.getJSNamespace();
            if (jSNamespace == null) {
                JSFunctionExpressionImpl.$$$reportNull$$$0(2);
            }
            return jSNamespace;
        }
        JSNamespace jSNamespace = super.getJSNamespace();
        if (jSNamespace == null) {
            JSFunctionExpressionImpl.$$$reportNull$$$0(3);
        }
        return jSNamespace;
    }

    @Override
    protected boolean processInnerAndBodyDeclarations(@NotNull PsiScopeProcessor processor, @NotNull ResolveState state, PsiElement lastParent, @NotNull PsiElement place, ResolveProcessor.ProcessingOptions funInternalDefsProcessingOptions) {
        if (processor == null) {
            JSFunctionExpressionImpl.$$$reportNull$$$0(4);
        }
        if (state == null) {
            JSFunctionExpressionImpl.$$$reportNull$$$0(5);
        }
        if (place == null) {
            JSFunctionExpressionImpl.$$$reportNull$$$0(6);
        }
        if (!super.processInnerAndBodyDeclarations(processor, state, lastParent, place, funInternalDefsProcessingOptions)) {
            return false;
        }
        return lastParent == null || lastParent.getParent() != this || this.getOwnNameIdentifier() == null || processor.execute((PsiElement)this, state);
    }

    @Override
    protected boolean processOuterDeclarations(@NotNull PsiScopeProcessor processor, @NotNull ResolveState state, @NotNull PsiElement place) {
        if (processor == null) {
            JSFunctionExpressionImpl.$$$reportNull$$$0(7);
        }
        if (state == null) {
            JSFunctionExpressionImpl.$$$reportNull$$$0(8);
        }
        if (place == null) {
            JSFunctionExpressionImpl.$$$reportNull$$$0(9);
        }
        return true;
    }

    @Override
    public boolean isAnonymousFunctionCall() {
        JSFunctionStubBase stub = (JSFunctionStubBase)this.getGreenStub();
        if (stub != null) {
            return stub.isAnonymousFunCall();
        }
        return JSSymbolUtil.getAnonymousFunCall(this) != null;
    }

    @Nullable
    public JSQualifiedNamedElement getElementAssignedTo() {
        return JSPsiImplUtils.getInitializedElement((JSExpression)this);
    }

    @Override
    @NotNull
    public JSElementBase.ClassOrInterface isClassOrInterface() {
        JSFunctionStubBase stub = (JSFunctionStubBase)this.getGreenStub();
        if (stub != null) {
            JSElementBase.ClassOrInterface classOrInterface = stub.isClassOrInterface();
            if (classOrInterface == null) {
                JSFunctionExpressionImpl.$$$reportNull$$$0(10);
            }
            return classOrInterface;
        }
        JSQualifiedNamedElement initializedElement = JSPsiImplUtils.getInitializedElement((JSExpression)this);
        if (initializedElement != null) {
            JSElementBase.ClassOrInterface classOrInterface = JSElementBase.ClassOrInterface.NONE;
            if (classOrInterface == null) {
                JSFunctionExpressionImpl.$$$reportNull$$$0(11);
            }
            return classOrInterface;
        }
        JSElementBase.ClassOrInterface classOrInterface = super.isClassOrInterface();
        if (classOrInterface == null) {
            JSFunctionExpressionImpl.$$$reportNull$$$0(12);
        }
        return classOrInterface;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 10: 
            case 11: 
            case 12: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 10: 
            case 11: 
            case 12: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "visitor";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 10: 
            case 11: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/javascript/psi/impl/JSFunctionExpressionImpl";
                break;
            }
            case 4: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "processor";
                break;
            }
            case 5: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "state";
                break;
            }
            case 6: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "place";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/javascript/psi/impl/JSFunctionExpressionImpl";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getJSNamespace";
                break;
            }
            case 10: 
            case 11: 
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "isClassOrInterface";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "accept";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 10: 
            case 11: 
            case 12: {
                break;
            }
            case 4: 
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "processInnerAndBodyDeclarations";
                break;
            }
            case 7: 
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "processOuterDeclarations";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 10: 
            case 11: 
            case 12: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

