/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.psi.impl;

import com.intellij.icons.AllIcons;
import com.intellij.lang.ASTNode;
import com.intellij.lang.javascript.DialectDetector;
import com.intellij.lang.javascript.DialectOptionHolder;
import com.intellij.lang.javascript.dialects.JSDialectSpecificHandlersFactory;
import com.intellij.lang.javascript.documentation.JSDocumentationUtils;
import com.intellij.lang.javascript.psi.JSCallExpression;
import com.intellij.lang.javascript.psi.JSElement;
import com.intellij.lang.javascript.psi.JSElementVisitor;
import com.intellij.lang.javascript.psi.JSExpectedTypeKind;
import com.intellij.lang.javascript.psi.JSExpression;
import com.intellij.lang.javascript.psi.JSFile;
import com.intellij.lang.javascript.psi.JSFunction;
import com.intellij.lang.javascript.psi.JSFunctionDeclaration;
import com.intellij.lang.javascript.psi.JSFunctionExpression;
import com.intellij.lang.javascript.psi.JSFunctionItem;
import com.intellij.lang.javascript.psi.JSNamedElement;
import com.intellij.lang.javascript.psi.JSNamespace;
import com.intellij.lang.javascript.psi.JSParameterList;
import com.intellij.lang.javascript.psi.JSPsiElementBase;
import com.intellij.lang.javascript.psi.JSQualifiedName;
import com.intellij.lang.javascript.psi.JSReferenceExpression;
import com.intellij.lang.javascript.psi.JSReturnStatement;
import com.intellij.lang.javascript.psi.JSSuppressionHolder;
import com.intellij.lang.javascript.psi.JSType;
import com.intellij.lang.javascript.psi.JSTypeUtils;
import com.intellij.lang.javascript.psi.JSVariable;
import com.intellij.lang.javascript.psi.ecmal4.JSAttributeList;
import com.intellij.lang.javascript.psi.ecmal4.JSAttributeListOwner;
import com.intellij.lang.javascript.psi.ecmal4.JSClass;
import com.intellij.lang.javascript.psi.ecmal4.JSPackageStatement;
import com.intellij.lang.javascript.psi.impl.JSFunctionBaseImpl;
import com.intellij.lang.javascript.psi.impl.JSPsiImplUtils;
import com.intellij.lang.javascript.psi.resolve.ActionScriptResolveUtil;
import com.intellij.lang.javascript.psi.resolve.JSInheritanceUtil;
import com.intellij.lang.javascript.psi.resolve.JSResolveUtil;
import com.intellij.lang.javascript.psi.stubs.JSFunctionStub;
import com.intellij.lang.javascript.psi.stubs.JSFunctionStubBase;
import com.intellij.lang.javascript.psi.types.JSAnyType;
import com.intellij.lang.javascript.psi.types.JSCompositeTypeImpl;
import com.intellij.lang.javascript.psi.types.JSContext;
import com.intellij.lang.javascript.psi.types.JSFunctionTypeImpl;
import com.intellij.lang.javascript.psi.types.JSGenericTypeImpl;
import com.intellij.lang.javascript.psi.types.JSNamedType;
import com.intellij.lang.javascript.psi.types.JSNamedTypeFactory;
import com.intellij.lang.javascript.psi.types.JSTypeSource;
import com.intellij.lang.javascript.psi.types.JSTypeSourceFactory;
import com.intellij.lang.javascript.psi.types.guard.TypeScriptTypeRelations;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.RecursionManager;
import com.intellij.openapi.util.Ref;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.search.SearchScope;
import com.intellij.psi.stubs.IStubElementType;
import com.intellij.util.PlatformIcons;
import com.intellij.util.Processor;
import icons.JavaScriptPsiIcons;
import java.util.List;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JSFunctionImpl<StubT extends JSFunctionStub<?>>
extends JSFunctionBaseImpl<StubT>
implements JSSuppressionHolder,
JSFunctionDeclaration {
    public static final Icon CONSTRUCTOR_ICON = JavaScriptPsiIcons.Members.Constructor;

    public JSFunctionImpl(ASTNode node) {
        super(node);
    }

    public JSFunctionImpl(StubT stub, IStubElementType type) {
        super(stub, type);
    }

    @Nullable
    public static JSType getReturnTypeInContext(@NotNull JSFunctionItem function, @Nullable PsiElement place) {
        String name;
        JSType returnType;
        PsiElement sourceElement;
        if (function == null) {
            JSFunctionImpl.$$$reportNull$$$0(0);
        }
        PsiElement psiElement = sourceElement = (returnType = JSFunctionImpl.evaluateReturnTypeFromHierarchy(function)) == null ? null : returnType.getSource().getSourceElement();
        if (sourceElement != null && sourceElement.getParent() instanceof JSReturnStatement) {
            JSType type;
            JSType expectedType;
            boolean prohibitWidening = false;
            if (function instanceof JSFunctionExpression && (expectedType = (JSType)RecursionManager.doPreventingRecursion((Object)"js.function.base.type", (boolean)false, () -> {
                if (function == null) {
                    JSFunctionImpl.$$$reportNull$$$0(9);
                }
                return JSDialectSpecificHandlersFactory.findExpectedType((JSExpression)((JSFunctionExpression)function), JSExpectedTypeKind.CONTEXTUAL);
            })) instanceof JSFunctionTypeImpl && JSTypeUtils.containsLiteralTypes(((JSFunctionTypeImpl)expectedType).getReturnType())) {
                prohibitWidening = true;
            }
            if (!prohibitWidening && (type = TypeScriptTypeRelations.expandTypeRecursive(returnType)) instanceof JSCompositeTypeImpl && JSTypeUtils.containsLiteralTypes(type)) {
                prohibitWidening = true;
            }
            if (!prohibitWidening) {
                returnType = JSTypeUtils.getApparentType(returnType);
            }
        } else {
            JSType type = TypeScriptTypeRelations.expandTypeRecursive(returnType);
            if (type instanceof JSCompositeTypeImpl && sourceElement == function) {
                boolean prohibitWidening = false;
                List<JSType> types = ((JSCompositeTypeImpl)type).getTypes();
                if (DialectDetector.isTypeScript((PsiElement)function) && types.stream().allMatch(t -> JSTypeUtils.containsLiteralTypes(t))) {
                    prohibitWidening = true;
                }
                if (!prohibitWidening) {
                    returnType = JSTypeUtils.getApparentType(JSCompositeTypeImpl.optimizeTypeForSubstitute((JSCompositeTypeImpl)type));
                }
            }
        }
        if (returnType instanceof JSAnyType && ("pop".equals(name = function.getName()) || "shift".equals(name))) {
            JSResolveUtil.GenericSignature signature;
            String qualifiedExpressionType;
            JSExpression instance;
            JSType classType;
            PsiElement element = JSResolveUtil.findParent((PsiElement)function);
            JSType jSType = classType = !(element instanceof JSClass) ? null : JSNamedType.createType(((JSClass)element).getQualifiedName(), JSTypeSource.EMPTY, JSContext.INSTANCE);
            if (classType != null && JSTypeUtils.isActionScriptVectorType(classType) && place instanceof JSReferenceExpression && (instance = ((JSReferenceExpression)place).getQualifier()) != null && (qualifiedExpressionType = JSResolveUtil.getQualifiedExpressionType(instance, place.getContainingFile())) != null && (signature = JSResolveUtil.extractGenericSignature(qualifiedExpressionType)) != null) {
                return JSTypeUtils.createType(signature.genericType, JSTypeSourceFactory.createTypeSource(place));
            }
        } else if (JSGenericTypeImpl.isGenericActionScriptVectorType(returnType) && place instanceof JSExpression) {
            JSExpression expression;
            JSExpression processedExpression = expression = (JSExpression)place;
            if (place instanceof JSReferenceExpression) {
                processedExpression = ((JSReferenceExpression)place).getQualifier();
            }
            if (processedExpression != null && processedExpression != expression) {
                String expressionType;
                JSExpression expressionToCheckType = processedExpression;
                PsiElement parent = processedExpression.getParent();
                if (parent instanceof JSCallExpression) {
                    expressionToCheckType = (JSExpression)parent;
                }
                if ((expressionType = JSResolveUtil.getQualifiedExpressionType(expressionToCheckType, expression.getContainingFile())) != null && (expressionType.equals("Vector") || expressionType.startsWith("Vector.<"))) {
                    return JSTypeUtils.createType(expressionType, JSTypeSourceFactory.createTypeSource(place));
                }
            }
        }
        return returnType;
    }

    @Nullable
    public static JSType evaluateReturnTypeFromHierarchy(@NotNull JSFunctionItem function) {
        JSType type;
        if (function == null) {
            JSFunctionImpl.$$$reportNull$$$0(1);
        }
        if ((type = function.getReturnType()) != null && type.getSource().isStrict()) {
            return type;
        }
        if (function.isOverride()) {
            Ref overridden = Ref.create(null);
            JSInheritanceUtil.processNearestOverriddenMethods(function, (Processor<JSFunction>)((Processor)function1 -> {
                overridden.set(function1);
                return function1 == null || function1.getReturnType() == null;
            }));
            if (!overridden.isNull()) {
                return ((JSFunction)overridden.get()).getReturnType();
            }
        }
        return type;
    }

    @Override
    public boolean isConstructor() {
        JSFunctionStubBase stub = (JSFunctionStubBase)this.getGreenStub();
        if (stub != null) {
            return stub.isConstructor();
        }
        PsiElement parent = JSResolveUtil.findParent((PsiElement)this);
        if (parent instanceof JSClass) {
            DialectOptionHolder dialect = DialectDetector.dialectOfElement((PsiElement)this);
            if (dialect != null && dialect.isECMA6) {
                return Comparing.equal((String)"constructor", (String)this.getName(), (boolean)true);
            }
            return Comparing.equal((String)((JSClass)parent).getName(), (String)ActionScriptResolveUtil.replaceInternalName(this.getName()), (boolean)true);
        }
        return super.isConstructor();
    }

    @Override
    public boolean isOverride() {
        JSFunctionStubBase stub = (JSFunctionStubBase)this.getGreenStub();
        if (stub != null) {
            return stub.isOverride();
        }
        return super.isOverride();
    }

    @Override
    public void accept(@NotNull PsiElementVisitor visitor) {
        if (visitor == null) {
            JSFunctionImpl.$$$reportNull$$$0(2);
        }
        if (visitor instanceof JSElementVisitor) {
            ((JSElementVisitor)visitor).visitJSFunctionDeclaration((JSFunction)this);
        } else {
            visitor.visitElement((PsiElement)this);
        }
    }

    @Nullable
    public Icon getIcon(int flags) {
        return JSFunctionImpl.getFunctionIcon((JSFunctionItem)this, flags);
    }

    public static Icon getFunctionIcon(JSFunctionItem function, int flags) {
        PsiElement parent = JSResolveUtil.findParent((PsiElement)function);
        if (parent instanceof JSClass || parent instanceof JSPackageStatement) {
            JSAttributeList attributeList;
            JSAttributeList jSAttributeList = attributeList = function instanceof JSAttributeListOwner ? ((JSAttributeListOwner)function).getAttributeList() : null;
            if (attributeList != null && function instanceof JSFunction) {
                Icon initialIcon;
                JSFunction.FunctionKind kind = ((JSFunction)function).getKind();
                boolean isStatic = attributeList.hasModifier(JSAttributeList.ModifierType.STATIC);
                switch (kind) {
                    case GETTER: {
                        initialIcon = isStatic ? AllIcons.Nodes.PropertyReadStatic : AllIcons.Nodes.PropertyRead;
                        break;
                    }
                    case SETTER: {
                        initialIcon = isStatic ? AllIcons.Nodes.PropertyWriteStatic : AllIcons.Nodes.PropertyWrite;
                        break;
                    }
                    case CONSTRUCTOR: {
                        initialIcon = CONSTRUCTOR_ICON;
                        break;
                    }
                    case SIMPLE: {
                        initialIcon = PlatformIcons.METHOD_ICON;
                        break;
                    }
                    default: {
                        assert (false) : "unexpected kind: " + kind;
                        initialIcon = PlatformIcons.METHOD_ICON;
                    }
                }
                Icon baseIcon = JSFunctionImpl.blendModifierFlags(initialIcon, attributeList, kind == JSFunction.FunctionKind.SIMPLE);
                return JSFunctionImpl.iconWithVisibilityIfNeeded((int)flags, (Icon)baseIcon, (Icon)attributeList.getAccessType().getIcon());
            }
        }
        return JSFunctionImpl.getIcon((JSPsiElementBase)function, JSFunctionImpl.getFunctionBaseIcon(function), flags);
    }

    @NotNull
    public static Icon getFunctionBaseIcon(@NotNull JSFunctionItem function) {
        if (function == null) {
            JSFunctionImpl.$$$reportNull$$$0(3);
        }
        boolean isFunction = function.getNamespace() == null && function.isNamespaceExplicitlyDeclared();
        Icon icon = isFunction ? PlatformIcons.FUNCTION_ICON : PlatformIcons.METHOD_ICON;
        if (icon == null) {
            JSFunctionImpl.$$$reportNull$$$0(4);
        }
        return icon;
    }

    @Nullable
    public JSQualifiedName getNamespace() {
        JSFunctionStub stub = (JSFunctionStub)this.getGreenStub();
        if (stub != null) {
            return stub.getNamespace();
        }
        JSNamespace fromJSDoc = JSDocumentationUtils.getNamespaceFromJSDoc((JSNamedElement)this);
        if (fromJSDoc != null) {
            return fromJSDoc.getQualifiedName();
        }
        PsiElement parent = JSResolveUtil.findParent((PsiElement)this);
        if (parent instanceof JSFile || parent instanceof JSPackageStatement || parent instanceof JSClass && !DialectDetector.isActionScript(parent)) {
            return JSPsiImplUtils.getNamespace((JSNamedElement)this);
        }
        return null;
    }

    @Override
    @NotNull
    public JSNamespace getJSNamespace() {
        JSFunctionStub stub = (JSFunctionStub)this.getStub();
        if (stub != null) {
            JSNamespace jSNamespace = stub.getJSNamespace();
            if (jSNamespace == null) {
                JSFunctionImpl.$$$reportNull$$$0(5);
            }
            return jSNamespace;
        }
        JSQualifiedName ns = this.getNamespace();
        JSElement scope = JSPsiImplUtils.getScopeNode(this);
        JSNamespace jSNamespace = JSNamedTypeFactory.createNamespace(ns, this.getJSContext(), (PsiElement)scope, this.isNamespaceExplicitlyDeclared(), true, ns == null && scope instanceof JSFunction);
        if (jSNamespace == null) {
            JSFunctionImpl.$$$reportNull$$$0(6);
        }
        return jSNamespace;
    }

    @NotNull
    public SearchScope getUseScope() {
        if (this.isConstructor()) {
            SearchScope searchScope = super.getUseScope();
            if (searchScope == null) {
                JSFunctionImpl.$$$reportNull$$$0(7);
            }
            return searchScope;
        }
        SearchScope searchScope = JSResolveUtil.findUseScope(this);
        if (searchScope == null) {
            JSFunctionImpl.$$$reportNull$$$0(8);
        }
        return searchScope;
    }

    public PsiElement getNavigationElement() {
        PsiElement parentOriginalElement;
        PsiElement parent = this.getParent();
        if (parent instanceof JSClass && (parentOriginalElement = parent.getNavigationElement()) != parent) {
            JSFunction functionByNameAndKind = ((JSClass)parentOriginalElement).findFunctionByNameAndKind(this.getName(), this.getKind());
            return functionByNameAndKind != null ? functionByNameAndKind : (this.isActionScriptDecompiledConstructor() ? parentOriginalElement : this);
        }
        return JSPsiImplUtils.findTopLevelNavigatableElement(this);
    }

    private boolean isActionScriptDecompiledConstructor() {
        if (!this.isConstructor() || !DialectDetector.isActionScript((PsiElement)this)) {
            return false;
        }
        JSAttributeList attributeList = this.getAttributeList();
        if (attributeList == null || !attributeList.hasExplicitModifier(JSAttributeList.ModifierType.NATIVE)) {
            return false;
        }
        JSParameterList parameterList = this.getParameterList();
        if (parameterList == null || parameterList.getParameters().length != 0) {
            return false;
        }
        return "*".equals(this.getReturnTypeString());
    }

    public boolean isEquivalentTo(PsiElement another) {
        if (another instanceof JSVariable) {
            String name = ((JSVariable)another).getName();
            if (Comparing.equal((String)this.getName(), (String)name) && ActionScriptResolveUtil.fieldIsImplicitAccessorMethod(this, (JSVariable)another)) {
                return true;
            }
        }
        return super.isEquivalentTo(another);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "function";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "visitor";
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/javascript/psi/impl/JSFunctionImpl";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/javascript/psi/impl/JSFunctionImpl";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getFunctionBaseIcon";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getJSNamespace";
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getUseScope";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getReturnTypeInContext";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "evaluateReturnTypeFromHierarchy";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "accept";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "getFunctionBaseIcon";
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "lambda$getReturnTypeInContext$0";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

