/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.psi.resolve;

import com.intellij.codeInsight.completion.CompletionUtilCoreImpl;
import com.intellij.lang.javascript.DialectDetector;
import com.intellij.lang.javascript.DialectOptionHolder;
import com.intellij.lang.javascript.JavaScriptSupportLoader;
import com.intellij.lang.javascript.frameworks.commonjs.CommonJSUtil;
import com.intellij.lang.javascript.index.FrameworkIndexingHandler;
import com.intellij.lang.javascript.index.JSImplicitElementsIndex;
import com.intellij.lang.javascript.index.JSSymbolUtil;
import com.intellij.lang.javascript.index.JSTypeEvaluateManager;
import com.intellij.lang.javascript.library.JSCorePredefinedLibrariesProvider;
import com.intellij.lang.javascript.psi.JSCallExpression;
import com.intellij.lang.javascript.psi.JSDefinitionExpression;
import com.intellij.lang.javascript.psi.JSElementBase;
import com.intellij.lang.javascript.psi.JSExpression;
import com.intellij.lang.javascript.psi.JSFile;
import com.intellij.lang.javascript.psi.JSFunction;
import com.intellij.lang.javascript.psi.JSFunctionExpression;
import com.intellij.lang.javascript.psi.JSIndexedPropertyAccessExpression;
import com.intellij.lang.javascript.psi.JSNamespace;
import com.intellij.lang.javascript.psi.JSObjectLiteralExpression;
import com.intellij.lang.javascript.psi.JSParameter;
import com.intellij.lang.javascript.psi.JSProperty;
import com.intellij.lang.javascript.psi.JSPsiElementBase;
import com.intellij.lang.javascript.psi.JSQualifiedName;
import com.intellij.lang.javascript.psi.JSQualifiedNameImpl;
import com.intellij.lang.javascript.psi.JSReferenceExpression;
import com.intellij.lang.javascript.psi.JSThisExpression;
import com.intellij.lang.javascript.psi.JSType;
import com.intellij.lang.javascript.psi.JSTypeUtils;
import com.intellij.lang.javascript.psi.JSVariable;
import com.intellij.lang.javascript.psi.JSWithStatement;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptClass;
import com.intellij.lang.javascript.psi.ecmal4.JSAttributeList;
import com.intellij.lang.javascript.psi.ecmal4.JSClass;
import com.intellij.lang.javascript.psi.ecmal4.JSSuperExpression;
import com.intellij.lang.javascript.psi.impl.JSOffsetBasedImplicitElement;
import com.intellij.lang.javascript.psi.impl.JSPsiImplUtils;
import com.intellij.lang.javascript.psi.jsdoc.JSDocComment;
import com.intellij.lang.javascript.psi.resolve.ActionScriptResolveUtil;
import com.intellij.lang.javascript.psi.resolve.JSContextLevel;
import com.intellij.lang.javascript.psi.resolve.JSEvaluationResultContext;
import com.intellij.lang.javascript.psi.resolve.JSHierarchyProcessor;
import com.intellij.lang.javascript.psi.resolve.JSResolveUtil;
import com.intellij.lang.javascript.psi.resolve.JSTaggedResolveResult;
import com.intellij.lang.javascript.psi.resolve.JSTypeEvaluator;
import com.intellij.lang.javascript.psi.resolve.JSTypeInfo;
import com.intellij.lang.javascript.psi.resolve.JSTypeProcessor;
import com.intellij.lang.javascript.psi.resolve.WalkUpResolveProcessor;
import com.intellij.lang.javascript.psi.stubs.JSImplicitElement;
import com.intellij.lang.javascript.psi.types.JSAnyType;
import com.intellij.lang.javascript.psi.types.JSContext;
import com.intellij.lang.javascript.psi.types.JSGenericParameterImpl;
import com.intellij.lang.javascript.psi.types.JSGenericTypeImpl;
import com.intellij.lang.javascript.psi.types.JSNamedType;
import com.intellij.lang.javascript.psi.types.JSNamedTypeFactory;
import com.intellij.lang.javascript.psi.types.JSTypeContext;
import com.intellij.lang.javascript.psi.types.JSTypeSource;
import com.intellij.lang.javascript.psi.types.JSTypeSourceFactory;
import com.intellij.lang.javascript.psi.types.TypeScriptIndexedAccessJSTypeImpl;
import com.intellij.lang.javascript.psi.types.primitives.JSObjectType;
import com.intellij.lang.javascript.psi.types.primitives.TypeScriptNeverJSTypeImpl;
import com.intellij.lang.javascript.refactoring.JSVisibilityUtil;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.NotNullLazyValue;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.PersistentFSConstants;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.QualifiedName;
import com.intellij.testFramework.LightVirtualFile;
import com.intellij.util.SmartList;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.indexing.FileBasedIndex;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumSet;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class BaseJSSymbolProcessor {
    public static final Set<String> GLOBAL_OBJECT_NAMES = ContainerUtil.immutableSet((Object[])new String[]{"window", "global", "GLOBAL"});
    public static final Set<String> GLOBAL_TYPE_NAMES = ContainerUtil.immutableSet((Object[])new String[]{"Window"});
    public static final String HTML_ELEMENT_TYPE_NAME = "HTMLElement";
    protected final boolean ecmal4;
    protected final boolean typescript;
    @NotNull
    protected final JSTypeInfo myTypeInfo;
    @NotNull
    protected final PsiElement myContext;
    @NotNull
    protected final PsiFile myTargetFile;
    @Nullable
    protected final VirtualFile myTargetVirtualFile;
    @NotNull
    private final NotNullLazyValue<String[]> myContextScopesCache;
    protected boolean myCheckFileLevelAccess;
    @Nullable
    protected VirtualFile myCurrentFile;
    public static final String[] TS_EXCLUDED = new String[]{"HTMLElementTagNameMap", "DocumentEventMap", "HTMLElementEventMap", "WindowEventMap", "SVGMatrix", "WebKitCSSMatrix"};
    protected boolean myAddOnlyCompleteMatches;
    protected boolean myAddOnlyCompleteMatchesSet;

    public static boolean isNamedGlobalType(@NotNull String typeString, @NotNull JSContext context) {
        if (typeString == null) {
            BaseJSSymbolProcessor.$$$reportNull$$$0(0);
        }
        if (context == null) {
            BaseJSSymbolProcessor.$$$reportNull$$$0(1);
        }
        return GLOBAL_TYPE_NAMES.contains(typeString) && context != JSContext.STATIC || GLOBAL_OBJECT_NAMES.contains(typeString);
    }

    @Nullable
    public static JSType namespaceAsType(@NotNull JSNamespace namespace, @Nullable PsiElement source) {
        JSQualifiedName qualifiedName;
        if (namespace == null) {
            BaseJSSymbolProcessor.$$$reportNull$$$0(2);
        }
        if ((qualifiedName = namespace.getQualifiedName()) != null) {
            JSTypeSource typeSource = source == JSTypeEvaluator.EXPLICIT_TYPE_MARKER_ELEMENT ? JSTypeSource.EXPLICITLY_DECLARED : JSTypeSourceFactory.createTypeSource(source, namespace.isExplicitlyDeclared());
            return JSNamedType.createType(qualifiedName.getQualifiedName(), typeSource, JSTypeContext.fromJSContext(namespace.getJSContext()), false, false);
        }
        return null;
    }

    protected BaseJSSymbolProcessor(@NotNull PsiFile targetFile, @NotNull PsiElement context) {
        if (targetFile == null) {
            BaseJSSymbolProcessor.$$$reportNull$$$0(3);
        }
        if (context == null) {
            BaseJSSymbolProcessor.$$$reportNull$$$0(4);
        }
        this.myTargetFile = targetFile;
        this.myTargetVirtualFile = targetFile.getVirtualFile();
        this.myContext = context;
        this.myTypeInfo = this.createTypeInfo();
        this.myContextScopesCache = NotNullLazyValue.createValue(() -> JSVisibilityUtil.calculateContextNames(this.getContext()));
        DialectOptionHolder holder = DialectDetector.dialectOfElement(context);
        this.ecmal4 = holder != null && holder.isECMA4;
        this.typescript = holder != null && holder.isTypeScript;
        JSExpression contextRefQualifier = context instanceof JSReferenceExpression ? ((JSReferenceExpression)this.myContext).getQualifier() : null;
        this.myTypeInfo.setContextGlobalStatusHint(this.initGlobalStatusHint(context, (PsiElement)contextRefQualifier));
        for (FrameworkIndexingHandler handler : (FrameworkIndexingHandler[])FrameworkIndexingHandler.EP_NAME.getExtensions()) {
            handler.addContextType(this.myTypeInfo, context);
        }
    }

    protected JSTypeInfo createTypeInfo() {
        return new JSTypeInfo();
    }

    @NotNull
    protected JSTypeInfo.GlobalStatusHint initGlobalStatusHint(@Nullable PsiElement context, @Nullable PsiElement contextRefQualifier) {
        boolean withinWithStatement;
        if (contextRefQualifier instanceof JSCallExpression || contextRefQualifier instanceof JSIndexedPropertyAccessExpression || contextRefQualifier instanceof JSReferenceExpression || contextRefQualifier instanceof JSThisExpression || contextRefQualifier instanceof JSSuperExpression) {
            JSTypeInfo.GlobalStatusHint globalStatusHint = JSTypeInfo.GlobalStatusHint.NONGLOBAL;
            if (globalStatusHint == null) {
                BaseJSSymbolProcessor.$$$reportNull$$$0(5);
            }
            return globalStatusHint;
        }
        boolean bl = withinWithStatement = PsiTreeUtil.getParentOfType((PsiElement)this.myContext, JSWithStatement.class) != null;
        if (this.myContext instanceof JSReferenceExpression && contextRefQualifier == null && !withinWithStatement && JSResolveUtil.getRealRefExprQualifier((JSReferenceExpression)this.myContext) == null) {
            JSTypeInfo.GlobalStatusHint globalStatusHint = JSTypeInfo.GlobalStatusHint.GLOBAL;
            if (globalStatusHint == null) {
                BaseJSSymbolProcessor.$$$reportNull$$$0(6);
            }
            return globalStatusHint;
        }
        JSTypeInfo.GlobalStatusHint globalStatusHint = JSTypeInfo.GlobalStatusHint.UNKNOWN;
        if (globalStatusHint == null) {
            BaseJSSymbolProcessor.$$$reportNull$$$0(7);
        }
        return globalStatusHint;
    }

    public void addTypeHierarchy(@NotNull JSNamespace namespace, @Nullable PsiElement localScope) {
        if (namespace == null) {
            BaseJSSymbolProcessor.$$$reportNull$$$0(8);
        }
        this.myTypeInfo.addNamespace(namespace, true, localScope);
        this.addSupers(namespace);
    }

    public void addSupers(@NotNull JSNamespace namespace) {
        JSQualifiedName name;
        if (namespace == null) {
            BaseJSSymbolProcessor.$$$reportNull$$$0(9);
        }
        if ((name = namespace.getQualifiedName()) == null) {
            return;
        }
        JSContext staticOrInstance = namespace.getJSContext();
        final boolean isExplicitlyDeclared = namespace.isExplicitlyDeclared();
        SmartList parentClasses = new SmartList();
        JSHierarchyProcessor processor = new JSHierarchyProcessor((List)parentClasses, staticOrInstance){
            final /* synthetic */ List val$parentClasses;
            final /* synthetic */ JSContext val$staticOrInstance;
            {
                this.val$parentClasses = list;
                this.val$staticOrInstance = jSContext;
            }

            @Override
            public boolean processNamespace(String serializedType, VirtualFile file) {
                JSType type = JSTypeUtils.createType(serializedType, JSTypeSource.EMPTY);
                if (type instanceof JSObjectType || type == null) {
                    return true;
                }
                JSNamespace namespace = JSTypeUtils.getNamespaceMatchingType(type, isExplicitlyDeclared);
                if (namespace != null) {
                    this.val$parentClasses.add(namespace);
                }
                return true;
            }

            @Override
            public boolean processClass(JSClass clazz) {
                String name = clazz.getQualifiedName();
                if ("Object".equals(name)) {
                    return true;
                }
                if (name != null) {
                    JSNamespace namespace = JSNamedTypeFactory.createNamespace(JSQualifiedNameImpl.fromQualifiedName(name), this.val$staticOrInstance, null, true);
                    this.val$parentClasses.add(namespace);
                }
                return true;
            }

            @Override
            public boolean processObjectLiteral(JSObjectLiteralExpression objectLiteral) {
                return BaseJSSymbolProcessor.this.processObjectLiteral(objectLiteral);
            }
        };
        String typeString = name.getQualifiedName();
        if (staticOrInstance == JSContext.STATIC) {
            typeString = JSNamedType.appendStaticSuffix(typeString);
        }
        JSTypeEvaluateManager.iterateTypeHierarchy(typeString, processor, this.myContext);
        for (JSNamespace parentClass : parentClasses) {
            this.myTypeInfo.addNamespace(parentClass, false);
        }
        this.addGenericArguments(namespace, (List<JSNamespace>)parentClasses);
    }

    protected boolean processObjectLiteral(@NotNull JSObjectLiteralExpression objectLiteral) {
        if (objectLiteral == null) {
            BaseJSSymbolProcessor.$$$reportNull$$$0(10);
        }
        return true;
    }

    protected void addGenericArguments(@NotNull JSNamespace namespace, @NotNull List<JSNamespace> parentClasses) {
        if (namespace == null) {
            BaseJSSymbolProcessor.$$$reportNull$$$0(11);
        }
        if (parentClasses == null) {
            BaseJSSymbolProcessor.$$$reportNull$$$0(12);
        }
    }

    public abstract String getRequiredName();

    public boolean addOnlyCompleteMatches() {
        return this.myAddOnlyCompleteMatches;
    }

    public void setAddOnlyCompleteMatches(boolean addOnlyCompleteMatches) {
        this.setAddOnlyCompleteMatches(addOnlyCompleteMatches, false);
    }

    protected void forceSetAddOnlyCompleteMatches() {
        this.setAddOnlyCompleteMatches(true, true);
    }

    public void setAddOnlyCompleteMatches(boolean addOnlyCompleteMatches, boolean forced) {
        if (!forced && this.myAddOnlyCompleteMatchesSet) {
            return;
        }
        this.myAddOnlyCompleteMatchesSet = true;
        this.myAddOnlyCompleteMatches = addOnlyCompleteMatches;
    }

    protected final boolean isGlobalNS(@Nullable JSQualifiedName namespace, boolean includeGlobalObjects) {
        return BaseJSSymbolProcessor.isGlobalNS(namespace, this.typescript, includeGlobalObjects);
    }

    public static boolean isGlobalNS(@Nullable JSQualifiedName namespace, boolean isTypeScript, boolean includeGlobalObjects) {
        if (namespace == null) {
            return true;
        }
        if (isTypeScript) {
            return false;
        }
        String name = namespace.getName();
        return includeGlobalObjects && (GLOBAL_OBJECT_NAMES.contains(name) || GLOBAL_TYPE_NAMES.contains(name)) && namespace.getParent() == null;
    }

    @Contract(value="null -> true")
    public static boolean isGlobalNS(@Nullable JSQualifiedName namespace) {
        if (namespace == null) {
            return true;
        }
        String name = namespace.getName();
        if (name.isEmpty()) {
            return true;
        }
        return namespace.getParent() == null && (GLOBAL_OBJECT_NAMES.contains(name) || GLOBAL_TYPE_NAMES.contains(name));
    }

    public boolean acceptsFile(PsiFile file) {
        this.myCurrentFile = file.getViewProvider().getVirtualFile();
        boolean currentFileEcma = file.getLanguage() == JavaScriptSupportLoader.ECMA_SCRIPT_L4;
        return this.ecmal4 == currentFileEcma;
    }

    protected boolean isFromRelevantFileOrDirectory() {
        return Comparing.equal((Object)this.myTargetVirtualFile, (Object)this.myCurrentFile);
    }

    public boolean toCheckFileLevelAccess() {
        return this.myCheckFileLevelAccess;
    }

    protected final void initCheckFileLevelAccess() {
        if (!this.myTypeInfo.isNonGlobalStatusHint() && this.myTargetFile instanceof JSFile) {
            PsiElement resolve;
            JSExpression qualifier;
            this.myCheckFileLevelAccess = true;
            if (this.myContext instanceof JSReferenceExpression && (qualifier = ((JSReferenceExpression)this.myContext).getQualifier()) instanceof JSReferenceExpression && ((resolve = ((JSReferenceExpression)qualifier).resolve()) == null || resolve instanceof JSParameter || !resolve.getContainingFile().getOriginalFile().isEquivalentTo((PsiElement)this.myTargetFile))) {
                this.myCheckFileLevelAccess = false;
            }
        }
    }

    @Nullable
    public String isAcceptable(@NotNull JSPsiElementBase element) {
        if (element == null) {
            BaseJSSymbolProcessor.$$$reportNull$$$0(13);
        }
        if (!this.toCheckFileLevelAccess()) {
            return null;
        }
        JSNamespace jsNamespace = element.getJSNamespace();
        JSQualifiedName namespace = jsNamespace.getQualifiedName();
        boolean isCommonJSExported = CommonJSUtil.isExportNamespace(jsNamespace);
        if (namespace != null && !isCommonJSExported) {
            return null;
        }
        PsiFile file = element.getContainingFile();
        if (element.getContext() instanceof JSDocComment && file.equals(this.myContext.getContainingFile())) {
            return null;
        }
        if (!(file instanceof JSFile) || ((JSFile)file).getModuleStatus() == JSFile.ModuleStatus.NONE || ((JSFile)file).getModuleStatus() == JSFile.ModuleStatus.MAYBE_COMMONJS || !element.isNamespaceExplicitlyDeclared() && !element.isExportedWithDefault()) {
            return null;
        }
        if (this.myContext instanceof JSReferenceExpression && (DialectDetector.isES6((PsiElement)element) && (element.isExported() || element.isExportedWithDefault()) || isCommonJSExported)) {
            if (((JSReferenceExpression)this.myContext).getQualifier() == null) {
                return "javascript.element.need.to.be.imported";
            }
            return null;
        }
        return "javascript.element.need.to.be.exported";
    }

    protected void tryAddFunctionType(@NotNull JSType type, @Nullable PsiElement source) {
        if (type == null) {
            BaseJSSymbolProcessor.$$$reportNull$$$0(14);
        }
        if (JSTypeUtils.hasFunctionType(type) || source instanceof TypeScriptClass && type instanceof JSNamedType && ((JSNamedType)type).isStaticOrInstance() == JSContext.STATIC) {
            this.myTypeInfo.addNamespace("Function", false, JSContext.INSTANCE, type.getSource().isStrict());
        }
    }

    protected boolean isStrictTypingPossible(@Nullable PsiElement source, @NotNull JSType type) {
        if (type == null) {
            BaseJSSymbolProcessor.$$$reportNull$$$0(15);
        }
        return !(source != JSTypeEvaluator.EXPLICIT_TYPE_MARKER_ELEMENT || type instanceof JSObjectType || type instanceof JSAnyType || type instanceof TypeScriptIndexedAccessJSTypeImpl && !this.typescript || type instanceof TypeScriptNeverJSTypeImpl || type instanceof JSGenericParameterImpl || type instanceof JSGenericTypeImpl && !this.isStrictGenericType((JSGenericTypeImpl)type));
    }

    private boolean isStrictGenericType(@NotNull JSGenericTypeImpl type) {
        if (type == null) {
            BaseJSSymbolProcessor.$$$reportNull$$$0(16);
        }
        if (this.typescript) {
            return true;
        }
        if (type.getType() instanceof JSObjectType) {
            return false;
        }
        for (JSType jsType : type.getArguments()) {
            if (!(jsType instanceof JSGenericParameterImpl)) continue;
            return false;
        }
        return true;
    }

    static boolean isValidType(String parameterType) {
        return parameterType != null && !parameterType.isEmpty();
    }

    protected void addPackageScope(@Nullable JSClass jsClass, @Nullable PsiElement expression) {
        String packageQualifier = JSResolveUtil.findPackageStatementQualifier(expression);
        if (packageQualifier != null) {
            this.myTypeInfo.buildIndexListFromQNameAndCorrectQName(packageQualifier);
        } else if (jsClass != null) {
            int index;
            String qName = jsClass.getQualifiedName();
            if (qName != null && !qName.equals(jsClass.getName()) && (index = qName.lastIndexOf(46)) > 0) {
                this.myTypeInfo.buildIndexListFromQNameAndCorrectQName(qName.substring(0, index));
            }
        } else {
            String s = ActionScriptResolveUtil.findPackageForMxml(expression);
            if (BaseJSSymbolProcessor.isValidType(s)) {
                this.myTypeInfo.buildIndexListFromQNameAndCorrectQName(s);
            }
        }
    }

    protected void addNamespace(@NotNull JSNamespace namespace, boolean isTopClassInHierarchy) {
        if (namespace == null) {
            BaseJSSymbolProcessor.$$$reportNull$$$0(17);
        }
        this.myTypeInfo.addNamespace(namespace, isTopClassInHierarchy);
    }

    public static String addIndexListFromQName(@NotNull String type, List<String> list) {
        if (type == null) {
            BaseJSSymbolProcessor.$$$reportNull$$$0(18);
        }
        QualifiedName qName = StringUtil.isQuotedString((String)type) ? QualifiedName.fromComponents((String[])new String[]{type}) : QualifiedName.fromDottedString((String)type);
        list.addAll(qName.getComponents());
        return type;
    }

    protected String[] getContextScopeNames() {
        return (String[])this.myContextScopesCache.getValue();
    }

    @NotNull
    public PsiElement getContext() {
        PsiElement psiElement = this.myContext;
        if (psiElement == null) {
            BaseJSSymbolProcessor.$$$reportNull$$$0(19);
        }
        return psiElement;
    }

    @NotNull
    public JSTypeInfo getTypeInfo() {
        JSTypeInfo jSTypeInfo = this.myTypeInfo;
        if (jSTypeInfo == null) {
            BaseJSSymbolProcessor.$$$reportNull$$$0(20);
        }
        return jSTypeInfo;
    }

    @NotNull
    protected MatchType isAcceptableQualifiedItem(@NotNull JSPsiElementBase element, @NotNull Ref<Integer> typeHierarchyLevel) {
        boolean isGlobalIncludeGlobalObjects;
        if (element == null) {
            BaseJSSymbolProcessor.$$$reportNull$$$0(21);
        }
        if (typeHierarchyLevel == null) {
            BaseJSSymbolProcessor.$$$reportNull$$$0(22);
        }
        JSQualifiedName namespace = this.getElementNamespace(element);
        boolean isElementLocal = element.getJSNamespace().isLocal();
        boolean isNamespaceExplicitlyDeclared = element.isNamespaceExplicitlyDeclared();
        boolean isGlobal = this.isGlobalNS(namespace, false);
        boolean bl = isGlobalIncludeGlobalObjects = isGlobal || this.isGlobalNS(namespace, true);
        if (isGlobal && BaseJSSymbolProcessor.isPrivate(element) && !this.isFromRelevantFileOrDirectory()) {
            MatchType matchType = MatchType.NOMATCH;
            if (matchType == null) {
                BaseJSSymbolProcessor.$$$reportNull$$$0(23);
            }
            return matchType;
        }
        if (isGlobalIncludeGlobalObjects && BaseJSSymbolProcessor.isPrivate(element) && !this.isFromRelevantFileOrDirectory()) {
            MatchType matchType = MatchType.NOMATCH;
            if (matchType == null) {
                BaseJSSymbolProcessor.$$$reportNull$$$0(24);
            }
            return matchType;
        }
        if (this.myTypeInfo.isNonGlobalStatusHint() && isNamespaceExplicitlyDeclared && (isGlobal || isGlobalIncludeGlobalObjects && !(this instanceof WalkUpResolveProcessor) || (element instanceof JSVariable || element instanceof JSFunction && !(element instanceof JSFunctionExpression)) && this.isGlobalNS(namespace, true))) {
            MatchType matchType = MatchType.NOMATCH;
            if (matchType == null) {
                BaseJSSymbolProcessor.$$$reportNull$$$0(25);
            }
            return matchType;
        }
        if (this.myTypeInfo.isGlobalStatusHint() && isNamespaceExplicitlyDeclared && (isElementLocal || !BaseJSSymbolProcessor.isGlobalNS(namespace, this.typescript, true))) {
            MatchType matchType = MatchType.NOMATCH;
            if (matchType == null) {
                BaseJSSymbolProcessor.$$$reportNull$$$0(26);
            }
            return matchType;
        }
        MatchType result2 = this.iterateContextLevels(element, typeHierarchyLevel, namespace);
        if (result2 != null) {
            MatchType matchType = result2;
            if (matchType == null) {
                BaseJSSymbolProcessor.$$$reportNull$$$0(27);
            }
            return matchType;
        }
        if (this.myTypeInfo.isGlobalStatusHint() && (JSPsiImplUtils.isClassMember((PsiElement)element) || element instanceof JSProperty)) {
            MatchType matchType = MatchType.NOMATCH;
            if (matchType == null) {
                BaseJSSymbolProcessor.$$$reportNull$$$0(28);
            }
            return matchType;
        }
        if (isNamespaceExplicitlyDeclared && isGlobalIncludeGlobalObjects && this.myTypeInfo.isGlobalStatusHint()) {
            MatchType matchType = MatchType.COMPLETE;
            if (matchType == null) {
                BaseJSSymbolProcessor.$$$reportNull$$$0(29);
            }
            return matchType;
        }
        if (namespace != null && !this.typescript && BaseJSSymbolProcessor.isTSExcludedMap(namespace)) {
            MatchType matchType = MatchType.NOMATCH;
            if (matchType == null) {
                BaseJSSymbolProcessor.$$$reportNull$$$0(30);
            }
            return matchType;
        }
        MatchType matchType = MatchType.PARTIAL;
        if (matchType == null) {
            BaseJSSymbolProcessor.$$$reportNull$$$0(31);
        }
        return matchType;
    }

    private static boolean isTSExcludedMap(JSQualifiedName namespace) {
        String qualifiedName = namespace.getQualifiedName();
        for (String map : TS_EXCLUDED) {
            if (!qualifiedName.equals(map)) continue;
            return true;
        }
        return false;
    }

    @Nullable
    private MatchType iterateContextLevels(@NotNull JSPsiElementBase element, @NotNull Ref<Integer> typeHierarchyLevel, JSQualifiedName namespace) {
        if (element == null) {
            BaseJSSymbolProcessor.$$$reportNull$$$0(32);
        }
        if (typeHierarchyLevel == null) {
            BaseJSSymbolProcessor.$$$reportNull$$$0(33);
        }
        JSContext elementStaticOrInstance = element.getJSContext();
        boolean jsContextMismatched = false;
        for (JSContextLevel contextLevel : this.myTypeInfo.myContextLevels) {
            JSQualifiedName currentNs;
            if (!contextLevel.isElementInScope((PsiElement)element, this.myTargetFile)) continue;
            JSQualifiedName currentContextNamespace = contextLevel.myNamespace.getQualifiedName();
            if (currentContextNamespace == null && contextLevel.myNamespace.isExplicitlyDeclared() && element instanceof JSProperty && namespace == null && !element.getJSNamespace().isExplicitlyDeclared()) continue;
            for (currentNs = namespace; currentContextNamespace != null && currentNs != null && currentContextNamespace.getName().equals(currentNs.getName()); currentNs = currentNs.getParent(), currentContextNamespace = currentContextNamespace.getParent()) {
            }
            if (currentContextNamespace != null || currentNs != null) continue;
            if (!contextLevel.myNamespace.getJSContext().isCompatibleWith(elementStaticOrInstance)) {
                jsContextMismatched = true;
                continue;
            }
            if (jsContextMismatched && contextLevel.myNamespace.getJSContext() == JSContext.UNKNOWN) continue;
            int relativeLevel = contextLevel.myRelativeLevel;
            typeHierarchyLevel.set((Object)relativeLevel);
            return relativeLevel == 0 && elementStaticOrInstance != JSContext.UNKNOWN && contextLevel.myNamespace.getJSContext() != JSContext.UNKNOWN ? MatchType.COMPLETE_WITH_CONTEXT : MatchType.COMPLETE;
        }
        return jsContextMismatched ? MatchType.NOMATCH : null;
    }

    private JSQualifiedName getElementNamespace(@NotNull JSPsiElementBase element) {
        if (element == null) {
            BaseJSSymbolProcessor.$$$reportNull$$$0(34);
        }
        PsiElement parent = element.getContext();
        return this.ecmal4 && parent instanceof JSClass ? JSQualifiedNameImpl.buildProvidedNamespace((JSElementBase)((JSClass)parent)) : element.getJSNamespace().getQualifiedName();
    }

    private static boolean isPrivate(@NotNull JSPsiElementBase element) {
        if (element == null) {
            BaseJSSymbolProcessor.$$$reportNull$$$0(35);
        }
        return element.getAccessType() == JSAttributeList.AccessType.PRIVATE;
    }

    @Contract(value="null -> null")
    public static JSExpression getOriginalQualifier(@Nullable JSExpression rawqualifier) {
        if (rawqualifier == null) {
            return null;
        }
        JSExpression element = (JSExpression)CompletionUtilCoreImpl.getOriginalElement((PsiElement)rawqualifier);
        return element != null ? element : rawqualifier;
    }

    protected static boolean isCompleteOrWithContextMatchType(@Nullable MatchType matchType) {
        return matchType == MatchType.COMPLETE_WITH_CONTEXT || matchType == MatchType.COMPLETE;
    }

    protected void addResolveResultTags(@NotNull EnumSet<JSTaggedResolveResult.ResolveResultTag> tags, @Nullable PsiElement element) {
        if (tags == null) {
            BaseJSSymbolProcessor.$$$reportNull$$$0(36);
        }
        if (element instanceof JSElementBase && this.isJavaScriptCoreLibraryElement(element)) {
            if (((JSElementBase)element).getNamespace() == null) {
                tags.add(JSTaggedResolveResult.ResolveResultTag.HAS_JSDOC);
            }
            return;
        }
        if (element instanceof JSElementBase && ((JSElementBase)element).hasJSDoc()) {
            tags.add(JSTaggedResolveResult.ResolveResultTag.HAS_JSDOC);
        }
        if (element instanceof JSImplicitElement && ((JSImplicitElement)element).hasMinorImportance() || element != null && BaseJSSymbolProcessor.isTooBigForHighlighting(element.getContainingFile().getViewProvider().getVirtualFile()) || BaseJSSymbolProcessor.isFromMinifiedFile(element)) {
            tags.add(JSTaggedResolveResult.ResolveResultTag.MINOR_IMPORTANCE);
        }
        if (element instanceof JSDefinitionExpression && !((JSDefinitionExpression)element).isDeclaration()) {
            tags.add(JSTaggedResolveResult.ResolveResultTag.IS_ASSIGNMENT);
        }
    }

    public static boolean isTooBigForHighlighting(@NotNull VirtualFile file) {
        if (file == null) {
            BaseJSSymbolProcessor.$$$reportNull$$$0(37);
        }
        return !(file instanceof LightVirtualFile) && file.getLength() > (long)PersistentFSConstants.getMaxIntellisenseFileSize();
    }

    private static boolean isFromMinifiedFile(@Nullable PsiElement element) {
        if (element == null) {
            return false;
        }
        PsiFile file = element.getContainingFile();
        return file instanceof JSFile && ((JSFile)file).isMinified();
    }

    protected void addReferenceNamespace(@NotNull JSReferenceExpression qualifier, boolean isTopClassInHierarchy) {
        JSNamespace ns;
        if (qualifier == null) {
            BaseJSSymbolProcessor.$$$reportNull$$$0(38);
        }
        if ((ns = JSSymbolUtil.createNamespaceFromReferenceExpression(qualifier, JSContext.STATIC, true)) != null) {
            this.myTypeInfo.addNamespace(ns, isTopClassInHierarchy);
        }
    }

    protected boolean isJavaScriptCoreLibraryElement(@Nullable PsiElement sourceElement) {
        return !this.typescript && sourceElement != JSTypeEvaluator.EXPLICIT_TYPE_MARKER_ELEMENT && JSCorePredefinedLibrariesProvider.isLibraryElement(sourceElement);
    }

    public static boolean processImplicitElementProxies(@Nullable String name, @NotNull GlobalSearchScope scope, @NotNull Project project, @NotNull JSSymbolProcessor processor) {
        if (scope == null) {
            BaseJSSymbolProcessor.$$$reportNull$$$0(39);
        }
        if (project == null) {
            BaseJSSymbolProcessor.$$$reportNull$$$0(40);
        }
        if (processor == null) {
            BaseJSSymbolProcessor.$$$reportNull$$$0(41);
        }
        Set<String> implicitKeys = name != null ? Collections.singleton(name) : FileBasedIndex.getInstance().getAllKeys(JSImplicitElementsIndex.INDEX_ID, project);
        ArrayList implicitElementProxies = new ArrayList();
        for (String key : implicitKeys) {
            FileBasedIndex.getInstance().processValues(JSImplicitElementsIndex.INDEX_ID, (Object)key, null, (virtualFile, value) -> {
                implicitElementProxies.add(Pair.create((Object)virtualFile, (Object)value));
                return true;
            }, scope);
        }
        for (Pair pair : implicitElementProxies) {
            VirtualFile virtualFile2 = (VirtualFile)pair.first;
            Collection value2 = (Collection)pair.second;
            PsiFile psiFile = PsiManager.getInstance((Project)project).findFile(virtualFile2);
            if (psiFile == null || !processor.acceptsFile(psiFile)) continue;
            for (JSImplicitElementsIndex.JSElementProxy proxy : value2) {
                JSOffsetBasedImplicitElement element = proxy.toOffsetBasedImplicitElement(psiFile);
                if (element.getUserString() != null || processor.process((JSPsiElementBase)element)) continue;
                return false;
            }
        }
        return true;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 5: 
            case 6: 
            case 7: 
            case 19: 
            case 20: 
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 27: 
            case 28: 
            case 29: 
            case 30: 
            case 31: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 5: 
            case 6: 
            case 7: 
            case 19: 
            case 20: 
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 27: 
            case 28: 
            case 29: 
            case 30: 
            case 31: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "typeString";
                break;
            }
            case 1: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 2: 
            case 8: 
            case 9: 
            case 11: 
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "namespace";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "targetFile";
                break;
            }
            case 5: 
            case 6: 
            case 7: 
            case 19: 
            case 20: 
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 27: 
            case 28: 
            case 29: 
            case 30: 
            case 31: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/javascript/psi/resolve/BaseJSSymbolProcessor";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "objectLiteral";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parentClasses";
                break;
            }
            case 13: 
            case 21: 
            case 32: 
            case 34: 
            case 35: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 14: 
            case 15: 
            case 16: 
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "type";
                break;
            }
            case 22: 
            case 33: {
                objectArray2 = objectArray3;
                objectArray3[0] = "typeHierarchyLevel";
                break;
            }
            case 36: {
                objectArray2 = objectArray3;
                objectArray3[0] = "tags";
                break;
            }
            case 37: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 38: {
                objectArray2 = objectArray3;
                objectArray3[0] = "qualifier";
                break;
            }
            case 39: {
                objectArray2 = objectArray3;
                objectArray3[0] = "scope";
                break;
            }
            case 40: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 41: {
                objectArray2 = objectArray3;
                objectArray3[0] = "processor";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/javascript/psi/resolve/BaseJSSymbolProcessor";
                break;
            }
            case 5: 
            case 6: 
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "initGlobalStatusHint";
                break;
            }
            case 19: {
                objectArray = objectArray2;
                objectArray2[1] = "getContext";
                break;
            }
            case 20: {
                objectArray = objectArray2;
                objectArray2[1] = "getTypeInfo";
                break;
            }
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 27: 
            case 28: 
            case 29: 
            case 30: 
            case 31: {
                objectArray = objectArray2;
                objectArray2[1] = "isAcceptableQualifiedItem";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "isNamedGlobalType";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "namespaceAsType";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 5: 
            case 6: 
            case 7: 
            case 19: 
            case 20: 
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 27: 
            case 28: 
            case 29: 
            case 30: 
            case 31: {
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "addTypeHierarchy";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "addSupers";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "processObjectLiteral";
                break;
            }
            case 11: 
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "addGenericArguments";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "isAcceptable";
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "tryAddFunctionType";
                break;
            }
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "isStrictTypingPossible";
                break;
            }
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "isStrictGenericType";
                break;
            }
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "addNamespace";
                break;
            }
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "addIndexListFromQName";
                break;
            }
            case 21: 
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "isAcceptableQualifiedItem";
                break;
            }
            case 32: 
            case 33: {
                objectArray = objectArray;
                objectArray[2] = "iterateContextLevels";
                break;
            }
            case 34: {
                objectArray = objectArray;
                objectArray[2] = "getElementNamespace";
                break;
            }
            case 35: {
                objectArray = objectArray;
                objectArray[2] = "isPrivate";
                break;
            }
            case 36: {
                objectArray = objectArray;
                objectArray[2] = "addResolveResultTags";
                break;
            }
            case 37: {
                objectArray = objectArray;
                objectArray[2] = "isTooBigForHighlighting";
                break;
            }
            case 38: {
                objectArray = objectArray;
                objectArray[2] = "addReferenceNamespace";
                break;
            }
            case 39: 
            case 40: 
            case 41: {
                objectArray = objectArray;
                objectArray[2] = "processImplicitElementProxies";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 5: 
            case 6: 
            case 7: 
            case 19: 
            case 20: 
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 27: 
            case 28: 
            case 29: 
            case 30: 
            case 31: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    public static interface JSSymbolProcessor {
        public boolean acceptsFile(@NotNull PsiFile var1);

        public boolean process(@NotNull JSPsiElementBase var1);
    }

    public abstract class JSTypeProcessorBase
    implements JSTypeProcessor {
        @Override
        public void processResolvedElement(@NotNull PsiElement element, @NotNull JSEvaluationResultContext evaluateContext) {
            if (element == null) {
                JSTypeProcessorBase.$$$reportNull$$$0(0);
            }
            if (evaluateContext == null) {
                JSTypeProcessorBase.$$$reportNull$$$0(1);
            }
            if (!(!(element instanceof PsiFile) || element instanceof JSFile && ((JSFile)element).referencesImportInDefaultExport())) {
                BaseJSSymbolProcessor.this.setAddOnlyCompleteMatches(true);
            }
        }

        protected boolean isTopLevelJSCoreLibraryElement(@Nullable PsiElement qualifier, @Nullable PsiElement sourceElement) {
            return qualifier instanceof JSReferenceExpression && ((JSReferenceExpression)qualifier).getQualifier() == null && BaseJSSymbolProcessor.this.isJavaScriptCoreLibraryElement(sourceElement);
        }

        @Override
        public void setUnknownElement(@NotNull PsiElement element) {
            if (element == null) {
                JSTypeProcessorBase.$$$reportNull$$$0(2);
            }
        }

        protected void addFullQualifierAsNamespace(@Nullable PsiElement qualifier, @NotNull JSType type, boolean isStrictlyTyped) {
            if (type == null) {
                JSTypeProcessorBase.$$$reportNull$$$0(3);
            }
            if (qualifier instanceof JSExpression) {
                JSNamespace namespace;
                PsiElement element = type.getSource().getSourceElement();
                if (this.isStrictTypeScriptInJSContext(type) && (!isStrictlyTyped || this.isTopLevelJSCoreLibraryElement(qualifier, element)) && (namespace = JSSymbolUtil.evaluateReferencedNamespace((JSExpression)qualifier, true)) != null) {
                    BaseJSSymbolProcessor.this.myTypeInfo.addNamespace(namespace, true);
                }
            }
        }

        protected boolean isStrictTypeScriptInJSContext(@NotNull JSType type) {
            if (type == null) {
                JSTypeProcessorBase.$$$reportNull$$$0(4);
            }
            return !BaseJSSymbolProcessor.this.typescript && type.isTypeScript() && type.isSourceStrict();
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "element";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "evaluateContext";
                    break;
                }
                case 3: 
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "type";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/lang/javascript/psi/resolve/BaseJSSymbolProcessor$JSTypeProcessorBase";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "processResolvedElement";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[2] = "setUnknownElement";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[2] = "addFullQualifierAsNamespace";
                    break;
                }
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[2] = "isStrictTypeScriptInJSContext";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    public static enum MatchType {
        COMPLETE_WITH_CONTEXT,
        COMPLETE,
        PARTIAL,
        NOMATCH;

    }
}

