/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.psi.resolve;

import com.intellij.javascript.JSModuleBaseReference;
import com.intellij.lang.javascript.frameworks.modules.JSParentReference;
import com.intellij.lang.javascript.psi.JSLiteralExpression;
import com.intellij.lang.javascript.psi.resolve.JSResolveResult;
import com.intellij.openapi.extensions.ExtensionPointName;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiPolyVariantReference;
import com.intellij.psi.PsiReference;
import com.intellij.psi.PsiReferenceProvider;
import com.intellij.psi.ResolveResult;
import com.intellij.psi.impl.source.resolve.reference.impl.providers.FileReference;
import com.intellij.util.ArrayUtil;
import com.intellij.util.containers.ContainerUtil;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public interface JSModuleReferenceContributor {
    public static final ExtensionPointName<JSModuleReferenceContributor> EP_NAME = ExtensionPointName.create((String)"JavaScript.moduleReferenceContributor");

    default public int getDefaultWeight() {
        return JSModuleBaseReference.ModuleTypes.DEFAULT.weight();
    }

    @NotNull
    public PsiReference[] getCommonJSModuleReferences(@NotNull String var1, @NotNull PsiElement var2, int var3, @Nullable PsiReferenceProvider var4);

    @NotNull
    public PsiReference[] getAllReferences(@NotNull String var1, @NotNull PsiElement var2, int var3, @Nullable PsiReferenceProvider var4);

    public boolean isApplicable(@NotNull PsiElement var1);

    @NotNull
    default public Collection<PsiElement> resolveReferences(@NotNull PsiElement context, @NotNull String path, boolean isCommonJS) {
        PsiReference[] references;
        if (context == null) {
            JSModuleReferenceContributor.$$$reportNull$$$0(0);
        }
        if (path == null) {
            JSModuleReferenceContributor.$$$reportNull$$$0(1);
        }
        PsiReference[] psiReferenceArray = references = isCommonJS ? this.getCommonJSModuleReferences(path, context, 0, null) : this.getAllReferences(path, context, 0, null);
        if (references.length == 0) {
            List list = ContainerUtil.emptyList();
            if (list == null) {
                JSModuleReferenceContributor.$$$reportNull$$$0(2);
            }
            return list;
        }
        List result2 = ContainerUtil.newSmartList();
        int maxWeight = Integer.MIN_VALUE;
        for (PsiReference reference : references) {
            int weight;
            Collection<PsiElement> current = JSModuleReferenceContributor.resolveModuleReference(reference);
            if (current.isEmpty()) continue;
            int n = weight = reference instanceof JSModuleBaseReference ? ((JSModuleBaseReference)reference).getWeight() : this.getDefaultWeight();
            if (weight < maxWeight) continue;
            if (weight > maxWeight) {
                result2.clear();
                maxWeight = weight;
            }
            result2.addAll(current);
        }
        List list = result2;
        if (list == null) {
            JSModuleReferenceContributor.$$$reportNull$$$0(3);
        }
        return list;
    }

    @Nullable
    default public String getModulePath(@NotNull PsiElement context, @NotNull VirtualFile moduleFileOrDirectory, @NotNull VirtualFile resolvedModuleFile) {
        if (context == null) {
            JSModuleReferenceContributor.$$$reportNull$$$0(4);
        }
        if (moduleFileOrDirectory == null) {
            JSModuleReferenceContributor.$$$reportNull$$$0(5);
        }
        if (resolvedModuleFile == null) {
            JSModuleReferenceContributor.$$$reportNull$$$0(6);
        }
        return null;
    }

    public static PsiReference[] getReferences(@NotNull String unquoted, @NotNull PsiElement context, int offset, @Nullable PsiReferenceProvider provider2, boolean commonjsReferencesOnly) {
        if (unquoted == null) {
            JSModuleReferenceContributor.$$$reportNull$$$0(7);
        }
        if (context == null) {
            JSModuleReferenceContributor.$$$reportNull$$$0(8);
        }
        Object[] result2 = PsiReference.EMPTY_ARRAY;
        for (JSModuleReferenceContributor contributor : (JSModuleReferenceContributor[])EP_NAME.getExtensions()) {
            if (!contributor.isApplicable(context)) continue;
            Object[] references = commonjsReferencesOnly ? contributor.getCommonJSModuleReferences(unquoted, context, offset, provider2) : contributor.getAllReferences(unquoted, context, offset, provider2);
            result2 = (PsiReference[])ArrayUtil.mergeArrays((Object[])result2, (Object[])references);
        }
        return result2;
    }

    public static PsiReference[] getReferencesForObjectLiteral(@Nullable JSLiteralExpression literalExpression, @Nullable PsiReferenceProvider provider2, boolean commonjsReferencesOnly) {
        if (literalExpression == null || !literalExpression.isQuotedLiteral()) {
            return PsiReference.EMPTY_ARRAY;
        }
        String text = literalExpression.getText();
        String unquoted = StringUtil.unquoteString((String)text);
        return JSModuleReferenceContributor.getReferences(unquoted, (PsiElement)literalExpression, 1, provider2, commonjsReferencesOnly);
    }

    @NotNull
    public static Collection<PsiElement> resolveModuleReference(@Nullable PsiReference reference) {
        ProgressManager.checkCanceled();
        if (reference instanceof JSParentReference || reference == null || reference instanceof FileReference && !((FileReference)reference).isLast()) {
            List list = ContainerUtil.emptyList();
            if (list == null) {
                JSModuleReferenceContributor.$$$reportNull$$$0(9);
            }
            return list;
        }
        if (reference instanceof PsiPolyVariantReference) {
            ResolveResult[] results = ((PsiPolyVariantReference)reference).multiResolve(false);
            List<PsiElement> list = JSResolveResult.toElements(results);
            if (list == null) {
                JSModuleReferenceContributor.$$$reportNull$$$0(10);
            }
            return list;
        }
        List list = ContainerUtil.createMaybeSingletonList((Object)reference.resolve());
        if (list == null) {
            JSModuleReferenceContributor.$$$reportNull$$$0(11);
        }
        return list;
    }

    public static Pair<Integer, String> getActualPath(@NotNull String modulePath) {
        int resourcePathStartInd;
        if (modulePath == null) {
            JSModuleReferenceContributor.$$$reportNull$$$0(12);
        }
        resourcePathStartInd = (resourcePathStartInd = modulePath.lastIndexOf(33)) >= 0 ? resourcePathStartInd + 1 : 0;
        int resourcePathEndInd = modulePath.indexOf(63, resourcePathStartInd);
        resourcePathEndInd = resourcePathEndInd >= 0 ? resourcePathEndInd : modulePath.length();
        String requiredModulePath = modulePath.substring(resourcePathStartInd, resourcePathEndInd);
        return Pair.create((Object)resourcePathStartInd, (Object)requiredModulePath);
    }

    public static JSModuleReferenceContributor[] getSortedExtensions() {
        JSModuleReferenceContributor[] extensions = (JSModuleReferenceContributor[])EP_NAME.getExtensions();
        Arrays.sort(extensions, Comparator.comparing(el -> -el.getDefaultWeight()));
        return extensions;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 3: 
            case 9: 
            case 10: 
            case 11: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 3: 
            case 9: 
            case 10: 
            case 11: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "path";
                break;
            }
            case 2: 
            case 3: 
            case 9: 
            case 10: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/javascript/psi/resolve/JSModuleReferenceContributor";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "moduleFileOrDirectory";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "resolvedModuleFile";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "unquoted";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "modulePath";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/javascript/psi/resolve/JSModuleReferenceContributor";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "resolveReferences";
                break;
            }
            case 9: 
            case 10: 
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "resolveModuleReference";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "resolveReferences";
                break;
            }
            case 2: 
            case 3: 
            case 9: 
            case 10: 
            case 11: {
                break;
            }
            case 4: 
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "getModulePath";
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "getReferences";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "getActualPath";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 3: 
            case 9: 
            case 10: 
            case 11: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

