/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.psi.types;

import com.intellij.lang.javascript.JSLanguageDialect;
import com.intellij.lang.javascript.JavaScriptSupportLoader;
import com.intellij.lang.javascript.JavascriptLanguage;
import com.intellij.lang.javascript.dialects.JSDialectSpecificHandlersFactory;
import com.intellij.lang.javascript.psi.JSRecordType;
import com.intellij.lang.javascript.psi.JSType;
import com.intellij.lang.javascript.psi.JSTypeUtils;
import com.intellij.lang.javascript.psi.ecmal4.JSClass;
import com.intellij.lang.javascript.psi.resolve.JSImportHandlingUtil;
import com.intellij.lang.javascript.psi.resolve.JSTypeHelper;
import com.intellij.lang.javascript.psi.types.JSExoticStringLiteralType;
import com.intellij.lang.javascript.psi.types.JSFreshObjectLiteralType;
import com.intellij.lang.javascript.psi.types.JSGenericParameterImpl;
import com.intellij.lang.javascript.psi.types.JSRecursiveTypeVisitor;
import com.intellij.lang.javascript.psi.types.JSTypeCastUtil;
import com.intellij.lang.javascript.psi.types.JSTypeComparingCache;
import com.intellij.lang.javascript.psi.types.JSTypeSource;
import com.intellij.lang.javascript.psi.types.JSTypeSourceFactory;
import com.intellij.lang.javascript.psi.types.JSTypeofTypeImpl;
import com.intellij.lang.javascript.psi.types.TypeScriptTypeParser;
import com.intellij.lang.javascript.psi.types.primitives.JSObjectType;
import com.intellij.lang.javascript.settings.JSSymbolPresentationProvider;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.RecursionManager;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.openapi.util.UserDataHolderBase;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.util.CachedValueProvider;
import com.intellij.psi.util.CachedValuesManager;
import com.intellij.psi.util.ParameterizedCachedValue;
import com.intellij.psi.util.ParameterizedCachedValueProvider;
import com.intellij.util.Function;
import com.intellij.util.ProcessingContext;
import com.intellij.util.containers.ContainerUtil;
import java.util.Collection;
import java.util.function.Supplier;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class JSTypeBaseImpl
extends UserDataHolderBase
implements JSType {
    private static final Key<ParameterizedCachedValue<JSType, Supplier<JSType>>> RECORD_TYPE_CACHE = Key.create((String)"js.record.type.cache.base");
    private static boolean ASSERT_ON_RECORD_TYPE_USAGE = false;
    private static final ParameterizedCachedValueProvider<JSType, Supplier<JSType>> LOCAL_TYPE_CACHE_VALUE_PROVIDER = new ParameterizedCachedValueProvider<JSType, Supplier<JSType>>(){

        @NotNull
        public CachedValueProvider.Result<JSType> compute(@NotNull Supplier<JSType> param) {
            if (param == null) {
                1.$$$reportNull$$$0(0);
            }
            CachedValueProvider.Result result2 = CachedValueProvider.Result.create((Object)param.get(), (Object[])new Object[]{JSTypeUtils.getTypeInvalidationDependency()});
            if (result2 == null) {
                1.$$$reportNull$$$0(1);
            }
            return result2;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 1: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 1: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "param";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/lang/javascript/psi/types/JSTypeBaseImpl$1";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/lang/javascript/psi/types/JSTypeBaseImpl$1";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "compute";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "compute";
                    break;
                }
                case 1: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 1: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    };
    @NotNull
    private JSTypeSource mySource;

    public static void assertOnRecordTypeUsage(@NotNull Disposable parentDisposable) {
        if (parentDisposable == null) {
            JSTypeBaseImpl.$$$reportNull$$$0(0);
        }
        ASSERT_ON_RECORD_TYPE_USAGE = true;
        Disposer.register((Disposable)parentDisposable, (Disposable)new Disposable(){

            public void dispose() {
                ASSERT_ON_RECORD_TYPE_USAGE = false;
            }
        });
    }

    @NotNull
    protected final JSType getLocalCachedType(@NotNull Supplier<JSType> factory, @NotNull Key<ParameterizedCachedValue<JSType, Supplier<JSType>>> cacheKey) {
        JSTypeSource source;
        PsiElement element;
        if (factory == null) {
            JSTypeBaseImpl.$$$reportNull$$$0(1);
        }
        if (cacheKey == null) {
            JSTypeBaseImpl.$$$reportNull$$$0(2);
        }
        if ((element = (source = this.getSource()).getSourceElement()) == null || !element.isValid()) {
            JSType jSType = factory.get();
            if (jSType == null) {
                JSTypeBaseImpl.$$$reportNull$$$0(3);
            }
            return jSType;
        }
        JSType jSType = (JSType)CachedValuesManager.getManager((Project)element.getProject()).getParameterizedCachedValue((UserDataHolder)this, cacheKey, LOCAL_TYPE_CACHE_VALUE_PROVIDER, false, factory);
        if (jSType == null) {
            JSTypeBaseImpl.$$$reportNull$$$0(4);
        }
        return jSType;
    }

    protected JSTypeBaseImpl(@NotNull JSTypeSource source) {
        if (source == null) {
            JSTypeBaseImpl.$$$reportNull$$$0(5);
        }
        this.mySource = source;
    }

    @NotNull
    public String getTypeText() {
        String string = this.getTypeText(JSType.TypeTextFormat.SIMPLE);
        if (string == null) {
            JSTypeBaseImpl.$$$reportNull$$$0(6);
        }
        return string;
    }

    @NotNull
    public String getResolvedTypeText() {
        String string = this.getTypeText(JSType.TypeTextFormat.RESOLVED);
        if (string == null) {
            JSTypeBaseImpl.$$$reportNull$$$0(7);
        }
        return string;
    }

    @NotNull
    public JSTypeSource getSource() {
        JSTypeSource jSTypeSource = this.mySource;
        if (jSTypeSource == null) {
            JSTypeBaseImpl.$$$reportNull$$$0(8);
        }
        return jSTypeSource;
    }

    public final boolean isDirectlyAssignableType(@Nullable JSType elementType, @Nullable ProcessingContext processingContext) {
        JSTypeComparingCache cache;
        if (elementType instanceof JSExoticStringLiteralType) {
            elementType = ((JSExoticStringLiteralType)((Object)elementType)).asSimpleLiteralType();
        }
        if (elementType == this || elementType == null || this.isEquivalentTo(elementType, processingContext, false) || this instanceof JSExoticStringLiteralType && ((JSExoticStringLiteralType)((Object)this)).asSimpleLiteralType().isEquivalentTo(elementType, processingContext, false) || JSTypeCastUtil.isAlwaysAssignableType(elementType, this.isJavaScript() && elementType.getSource().isJavaScript())) {
            return true;
        }
        ProgressManager.checkCanceled();
        JSTypeComparingCache jSTypeComparingCache = cache = processingContext == null ? null : (JSTypeComparingCache)processingContext.get(JSTypeComparingCache.TYPE_COMPARATOR);
        if (cache != null) {
            JSTypeCastUtil.AssignableResult assignableResult = cache.areAssignableTypes(this, elementType, processingContext);
            if (assignableResult.isStrict()) {
                if (ApplicationManager.getApplication().isUnitTestMode()) {
                    this.checkCachedValue(elementType, processingContext, assignableResult);
                }
                return assignableResult.isAssignable();
            }
            if (assignableResult != JSTypeCastUtil.AssignableResult.NO_CACHE) {
                boolean result2 = this.calculateAssignabilityWithoutCache(elementType, processingContext);
                cache.putAssignableTypes(this, elementType, processingContext, JSTypeCastUtil.toStrictAssignable(result2));
                return result2;
            }
        }
        return this.calculateAssignabilityWithoutCache(elementType, processingContext);
    }

    private boolean calculateAssignabilityWithoutCache(@NotNull JSType elementType, @Nullable ProcessingContext processingContext) {
        JSFreshObjectLiteralType freshType;
        if (elementType == null) {
            JSTypeBaseImpl.$$$reportNull$$$0(9);
        }
        JSFreshObjectLiteralType jSFreshObjectLiteralType = freshType = elementType instanceof JSFreshObjectLiteralType ? (JSFreshObjectLiteralType)elementType : null;
        if (freshType != null) {
            elementType = ((JSFreshObjectLiteralType)elementType).removeFreshness();
        }
        return this.isDirectlyAssignableTypeImpl(elementType, processingContext) && (!this.isTypeScript() || freshType == null || JSTypeCastUtil.compareByExcessProperties(this, freshType));
    }

    private void checkCachedValue(@NotNull JSType elementType, @NotNull ProcessingContext processingContext, JSTypeCastUtil.AssignableResult fromCache) {
        Boolean subtyping;
        if (elementType == null) {
            JSTypeBaseImpl.$$$reportNull$$$0(10);
        }
        if (processingContext == null) {
            JSTypeBaseImpl.$$$reportNull$$$0(11);
        }
        ProcessingContext newContext = new ProcessingContext();
        Boolean aBoolean = (Boolean)processingContext.get(JSGenericParameterImpl.CALL_ENV_KEY);
        if (aBoolean != null) {
            newContext.put(JSGenericParameterImpl.CALL_ENV_KEY, (Object)aBoolean);
        }
        if ((subtyping = (Boolean)processingContext.get(JSTypeComparingCache.SUBTYPING_CONTEXT)) != null) {
            newContext.put(JSTypeComparingCache.SUBTYPING_CONTEXT, (Object)subtyping);
        }
        boolean isAssignable = this.isDirectlyAssignableTypeImpl(elementType, newContext);
        if (fromCache.isAssignable() != isAssignable) assert (false) : String.format("checkCachedValue failed. This: %s;\nElement: %s;\nFrom cache: %s;\nIsAssignable:%s", new Object[]{this.getTypeText(), elementType.getTypeText(), fromCache, isAssignable});
    }

    protected boolean isDirectlyAssignableTypeImpl(@NotNull JSType elementType, @Nullable ProcessingContext processingContext) {
        if (elementType == null) {
            JSTypeBaseImpl.$$$reportNull$$$0(12);
        }
        return this.isDirectlyAssignableTypeCommon(elementType, processingContext).isAssignable();
    }

    @NotNull
    protected JSTypeCastUtil.AssignableResult isDirectlyAssignableTypeCommon(@NotNull JSType elementType, @Nullable ProcessingContext processingContext) {
        if (elementType == null) {
            JSTypeBaseImpl.$$$reportNull$$$0(13);
        }
        JSTypeCastUtil.AssignableResult assignableResult = JSTypeCastUtil.isDirectlyAssignableTypeCommon(this, elementType, processingContext);
        if (assignableResult == null) {
            JSTypeBaseImpl.$$$reportNull$$$0(14);
        }
        return assignableResult;
    }

    public void accept(JSRecursiveTypeVisitor visitor) {
        visitor.visitJSTypeBaseImpl((JSType)this);
    }

    public void acceptChildren(JSRecursiveTypeVisitor visitor) {
    }

    public void setSourceIfEmpty(final @NotNull JSTypeSource source) {
        if (source == null) {
            JSTypeBaseImpl.$$$reportNull$$$0(15);
        }
        JSRecursiveTypeVisitor visitor = new JSRecursiveTypeVisitor(){

            public void visitJSTypeBaseImpl(@NotNull JSType type) {
                if (type == null) {
                    3.$$$reportNull$$$0(0);
                }
                if (((JSTypeBaseImpl)type).mySource == JSTypeSource.EMPTY) {
                    ((JSTypeBaseImpl)type).mySource = source;
                }
                super.visitJSTypeBaseImpl(type);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "type", "com/intellij/lang/javascript/psi/types/JSTypeBaseImpl$3", "visitJSTypeBaseImpl"));
            }
        };
        this.accept(visitor);
    }

    @Nullable
    public PsiFile getScope() {
        return this.mySource.getScope();
    }

    public boolean isEcma() {
        return this.mySource.isEcma();
    }

    @NotNull
    protected JSTypeHelper getTypeHelper() {
        JSLanguageDialect language = null;
        switch (this.getSource().getLanguage()) {
            case TS: {
                language = JavaScriptSupportLoader.TYPESCRIPT;
                break;
            }
            case AS: {
                language = JavaScriptSupportLoader.ECMA_SCRIPT_L4;
                break;
            }
            case JS: {
                language = JavascriptLanguage.INSTANCE;
            }
        }
        JSTypeHelper jSTypeHelper = JSDialectSpecificHandlersFactory.forLanguage(language).getTypeHelper();
        if (jSTypeHelper == null) {
            JSTypeBaseImpl.$$$reportNull$$$0(16);
        }
        return jSTypeHelper;
    }

    @Nullable
    public JSClass resolveClass() {
        return null;
    }

    @NotNull
    public final JSType transformTypeHierarchy(@NotNull Function<JSType, JSType> transformation) {
        JSType transformedType;
        if (transformation == null) {
            JSTypeBaseImpl.$$$reportNull$$$0(17);
        }
        if (this != (transformedType = (JSType)transformation.fun((Object)this))) {
            JSType jSType = transformedType;
            if (jSType == null) {
                JSTypeBaseImpl.$$$reportNull$$$0(18);
            }
            return jSType;
        }
        JSType jSType = this.copyTypeHierarchy(transformation);
        if (jSType == null) {
            JSTypeBaseImpl.$$$reportNull$$$0(19);
        }
        return jSType;
    }

    @NotNull
    protected abstract JSType copyTypeHierarchy(@NotNull Function<JSType, JSType> var1);

    @NotNull
    public JSType substitute() {
        JSTypeBaseImpl jSTypeBaseImpl = this;
        if (jSTypeBaseImpl == null) {
            JSTypeBaseImpl.$$$reportNull$$$0(20);
        }
        return jSTypeBaseImpl;
    }

    public final boolean isEquivalentTo(@Nullable JSType type, @Nullable ProcessingContext processingContext) {
        return this.isEquivalentTo(type, processingContext, true);
    }

    public final boolean isEquivalentTo(@Nullable JSType type, @Nullable ProcessingContext processingContext, boolean allowResolve) {
        ProgressManager.checkCanceled();
        if (this == type) {
            return true;
        }
        if (type == null) {
            return false;
        }
        if (this.isEquivalentToImpl(type, processingContext, allowResolve)) {
            return true;
        }
        return this.isEquivalentCommon(type, processingContext, allowResolve);
    }

    protected boolean isEquivalentCommon(@Nullable JSType rOperand, @Nullable ProcessingContext processingContext, boolean allowResolve) {
        if (rOperand instanceof JSGenericParameterImpl) {
            return rOperand.isEquivalentTo((JSType)this, processingContext, allowResolve);
        }
        if (rOperand instanceof JSTypeofTypeImpl) {
            return rOperand.isEquivalentTo((JSType)this, processingContext, allowResolve);
        }
        return false;
    }

    @NotNull
    public final JSType copyWithStrict(boolean strict) {
        JSTypeSource source = this.getSource();
        if (source.isStrict() == strict) {
            JSTypeBaseImpl jSTypeBaseImpl = this;
            if (jSTypeBaseImpl == null) {
                JSTypeBaseImpl.$$$reportNull$$$0(21);
            }
            return jSTypeBaseImpl;
        }
        JSType jSType = this.copyWithNewSource(JSTypeSourceFactory.copyTypeSource(source, strict));
        if (jSType == null) {
            JSTypeBaseImpl.$$$reportNull$$$0(22);
        }
        return jSType;
    }

    @NotNull
    protected abstract JSType copyWithNewSource(@NotNull JSTypeSource var1);

    protected abstract boolean isEquivalentToImpl(@NotNull JSType var1, ProcessingContext var2, boolean var3);

    @NotNull
    public JSRecordType asRecordType() {
        if (ASSERT_ON_RECORD_TYPE_USAGE) {
            throw new AssertionError((Object)"Record type must be not used");
        }
        ProgressManager.checkCanceled();
        JSType value = this.getLocalCachedType(this::asRecordTypeNoCache, RECORD_TYPE_CACHE);
        JSRecordType jSRecordType = value instanceof JSRecordType ? (JSRecordType)value : JSTypeCastUtil.NO_RECORD_TYPE;
        if (jSRecordType == null) {
            JSTypeBaseImpl.$$$reportNull$$$0(23);
        }
        return jSRecordType;
    }

    @NotNull
    protected JSRecordType asRecordTypeNoCache() {
        String id;
        JSRecordType result2;
        JSType substitute = this.substitute();
        if (substitute != this && (result2 = (JSRecordType)RecursionManager.doPreventingRecursion((Object)(id = this.getTypeId()), (boolean)false, () -> substitute.asRecordType())) != null) {
            JSRecordType jSRecordType = result2;
            if (jSRecordType == null) {
                JSTypeBaseImpl.$$$reportNull$$$0(24);
            }
            return jSRecordType;
        }
        PsiElement element = this.getSource().getSourceElement();
        if (element != null) {
            if (this.isEcma()) {
                JSRecordType jSRecordType = JSTypeCastUtil.NO_RECORD_TYPE;
                if (jSRecordType == null) {
                    JSTypeBaseImpl.$$$reportNull$$$0(25);
                }
                return jSRecordType;
            }
            Collection<? extends PsiElement> resolvedElements = this.resolveElementsForRecordType(element);
            if (this.isJavaScript() && (resolvedElements.isEmpty() || this instanceof JSObjectType)) {
                JSRecordType jSRecordType = JSTypeCastUtil.NO_RECORD_TYPE;
                if (jSRecordType == null) {
                    JSTypeBaseImpl.$$$reportNull$$$0(26);
                }
                return jSRecordType;
            }
            JSRecordType jSRecordType = TypeScriptTypeParser.buildResolvedType(resolvedElements, this);
            if (jSRecordType == null) {
                JSTypeBaseImpl.$$$reportNull$$$0(27);
            }
            return jSRecordType;
        }
        JSRecordType jSRecordType = TypeScriptTypeParser.buildResolvedType(ContainerUtil.emptyList(), this);
        if (jSRecordType == null) {
            JSTypeBaseImpl.$$$reportNull$$$0(28);
        }
        return jSRecordType;
    }

    protected Collection<? extends PsiElement> resolveElementsForRecordType(@NotNull PsiElement element) {
        if (element == null) {
            JSTypeBaseImpl.$$$reportNull$$$0(29);
        }
        return JSImportHandlingUtil.resolveElementsByType(this, element);
    }

    @Deprecated
    public static JSType replaceSourceRecursive(@Nullable JSType type, final @NotNull JSTypeSource newSource) {
        if (newSource == null) {
            JSTypeBaseImpl.$$$reportNull$$$0(30);
        }
        if (type == null) {
            return null;
        }
        Function<JSType, JSType> function = new Function<JSType, JSType>(){

            public JSType fun(JSType currentType) {
                if (currentType instanceof JSTypeBaseImpl) {
                    if (currentType.getSource() == newSource) {
                        return currentType;
                    }
                    JSType elementResult = ((JSTypeBaseImpl)currentType).copyWithNewSource(newSource);
                    if (elementResult == currentType) {
                        return elementResult;
                    }
                    return elementResult.transformTypeHierarchy((Function)this);
                }
                assert (false);
                return currentType;
            }
        };
        return type.transformTypeHierarchy((Function)function);
    }

    @NotNull
    protected String getTypeSeparator(@NotNull JSType.TypeTextFormat format, String defaultValue) {
        if (format == null) {
            JSTypeBaseImpl.$$$reportNull$$$0(31);
        }
        String string = format == JSType.TypeTextFormat.SERIALIZED ? defaultValue : JSSymbolPresentationProvider.getDefaultTypeSeparator(this.getSource().getSourceElement());
        if (string == null) {
            JSTypeBaseImpl.$$$reportNull$$$0(32);
        }
        return string;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 3: 
            case 4: 
            case 6: 
            case 7: 
            case 8: 
            case 14: 
            case 16: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 27: 
            case 28: 
            case 32: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 3: 
            case 4: 
            case 6: 
            case 7: 
            case 8: 
            case 14: 
            case 16: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 27: 
            case 28: 
            case 32: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parentDisposable";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "factory";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "cacheKey";
                break;
            }
            case 3: 
            case 4: 
            case 6: 
            case 7: 
            case 8: 
            case 14: 
            case 16: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 27: 
            case 28: 
            case 32: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/javascript/psi/types/JSTypeBaseImpl";
                break;
            }
            case 5: 
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "source";
                break;
            }
            case 9: 
            case 10: 
            case 12: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "elementType";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "processingContext";
                break;
            }
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "transformation";
                break;
            }
            case 29: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 30: {
                objectArray2 = objectArray3;
                objectArray3[0] = "newSource";
                break;
            }
            case 31: {
                objectArray2 = objectArray3;
                objectArray3[0] = "format";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/javascript/psi/types/JSTypeBaseImpl";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getLocalCachedType";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getTypeText";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getResolvedTypeText";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getSource";
                break;
            }
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "isDirectlyAssignableTypeCommon";
                break;
            }
            case 16: {
                objectArray = objectArray2;
                objectArray2[1] = "getTypeHelper";
                break;
            }
            case 18: 
            case 19: {
                objectArray = objectArray2;
                objectArray2[1] = "transformTypeHierarchy";
                break;
            }
            case 20: {
                objectArray = objectArray2;
                objectArray2[1] = "substitute";
                break;
            }
            case 21: 
            case 22: {
                objectArray = objectArray2;
                objectArray2[1] = "copyWithStrict";
                break;
            }
            case 23: {
                objectArray = objectArray2;
                objectArray2[1] = "asRecordType";
                break;
            }
            case 24: 
            case 25: 
            case 26: 
            case 27: 
            case 28: {
                objectArray = objectArray2;
                objectArray2[1] = "asRecordTypeNoCache";
                break;
            }
            case 32: {
                objectArray = objectArray2;
                objectArray2[1] = "getTypeSeparator";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "assertOnRecordTypeUsage";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "getLocalCachedType";
                break;
            }
            case 3: 
            case 4: 
            case 6: 
            case 7: 
            case 8: 
            case 14: 
            case 16: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 27: 
            case 28: 
            case 32: {
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "calculateAssignabilityWithoutCache";
                break;
            }
            case 10: 
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "checkCachedValue";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "isDirectlyAssignableTypeImpl";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "isDirectlyAssignableTypeCommon";
                break;
            }
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "setSourceIfEmpty";
                break;
            }
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "transformTypeHierarchy";
                break;
            }
            case 29: {
                objectArray = objectArray;
                objectArray[2] = "resolveElementsForRecordType";
                break;
            }
            case 30: {
                objectArray = objectArray;
                objectArray[2] = "replaceSourceRecursive";
                break;
            }
            case 31: {
                objectArray = objectArray;
                objectArray[2] = "getTypeSeparator";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 3: 
            case 4: 
            case 6: 
            case 7: 
            case 8: 
            case 14: 
            case 16: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 27: 
            case 28: 
            case 32: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

