/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.psi.types;

import com.intellij.lang.javascript.psi.JSEmbeddedContent;
import com.intellij.lang.javascript.psi.JSType;
import com.intellij.lang.javascript.psi.JSTypeUtils;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptModule;
import com.intellij.lang.javascript.psi.stubs.TypeScriptLocalClassIndex;
import com.intellij.lang.javascript.psi.types.JSLiteralType;
import com.intellij.lang.javascript.psi.types.JSNamedType;
import com.intellij.lang.javascript.psi.types.JSRecursiveTypeUtil;
import com.intellij.lang.javascript.psi.types.JSTypeCastUtil;
import com.intellij.lang.javascript.psi.types.JSTypeContext;
import com.intellij.lang.javascript.psi.types.primitives.JSPrimitiveType;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.NotNullLazyValue;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.stubs.StubIndex;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.ProcessingContext;
import com.intellij.util.containers.ContainerUtil;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.atomic.AtomicLong;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JSTypeComparingCache {
    public static final Key<JSTypeComparingCache> TYPE_COMPARATOR = Key.create((String)"js.type.comparator.cache");
    public static final Key<JSTypeId> TYPE_ID = Key.create((String)"type.id");
    public static final Key<Boolean> SUBTYPING_CONTEXT = Key.create((String)"js.type.subtyping");
    private static final Logger LOG = Logger.getInstance(JSTypeComparingCache.class);
    private final Project myProject;
    private final boolean myLogDebug;
    @NotNull
    private final NotNullLazyValue<Collection<String>> myLocalClassNames = new NotNullLazyValue<Collection<String>>(){

        @NotNull
        protected Collection<String> compute() {
            Collection result2 = StubIndex.getInstance().getAllKeys(TypeScriptLocalClassIndex.KEY, JSTypeComparingCache.this.myProject);
            Collection collection = result2 instanceof Set ? result2 : ContainerUtil.newTroveSet((Collection)result2);
            if (collection == null) {
                1.$$$reportNull$$$0(0);
            }
            return collection;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/psi/types/JSTypeComparingCache$1", "compute"));
        }
    };
    private final ConcurrentMap<JSTypeId, Map<JSTypeId, JSTypeCastUtil.AssignableResult>> myDefaultResult = new ConcurrentHashMap<JSTypeId, Map<JSTypeId, JSTypeCastUtil.AssignableResult>>();
    private final AtomicLong myCacheMissCount = new AtomicLong();
    private final AtomicLong myCacheUseCount = new AtomicLong();

    public JSTypeComparingCache(Project project) {
        this.myProject = project;
        this.myLogDebug = LOG.isDebugEnabled();
    }

    @NotNull
    public JSTypeCastUtil.AssignableResult areAssignableTypes(@NotNull JSType lType, @NotNull JSType rType, @NotNull ProcessingContext processingContext) {
        if (lType == null) {
            JSTypeComparingCache.$$$reportNull$$$0(0);
        }
        if (rType == null) {
            JSTypeComparingCache.$$$reportNull$$$0(1);
        }
        if (processingContext == null) {
            JSTypeComparingCache.$$$reportNull$$$0(2);
        }
        JSTypeId lTypeId = this.getTypeId(lType);
        JSTypeId rTypeId = this.getTypeId(rType);
        if (lTypeId == null || rTypeId == null) {
            JSTypeCastUtil.AssignableResult assignableResult = JSTypeCastUtil.AssignableResult.NO_CACHE;
            if (assignableResult == null) {
                JSTypeComparingCache.$$$reportNull$$$0(3);
            }
            return assignableResult;
        }
        if (JSRecursiveTypeUtil.isRecursiveComparison(lType, rType, processingContext)) {
            JSTypeCastUtil.AssignableResult assignableResult = JSTypeCastUtil.AssignableResult.NO_CACHE;
            if (assignableResult == null) {
                JSTypeComparingCache.$$$reportNull$$$0(4);
            }
            return assignableResult;
        }
        JSTypeCastUtil.AssignableResult assignableResult = this.areAssignableIds(lTypeId, rTypeId, processingContext);
        if (assignableResult == null) {
            JSTypeComparingCache.$$$reportNull$$$0(5);
        }
        return assignableResult;
    }

    public void putAssignableTypes(@NotNull JSType lType, @NotNull JSType rType, @NotNull ProcessingContext processingContext, @NotNull JSTypeCastUtil.AssignableResult result2) {
        if (lType == null) {
            JSTypeComparingCache.$$$reportNull$$$0(6);
        }
        if (rType == null) {
            JSTypeComparingCache.$$$reportNull$$$0(7);
        }
        if (processingContext == null) {
            JSTypeComparingCache.$$$reportNull$$$0(8);
        }
        if (result2 == null) {
            JSTypeComparingCache.$$$reportNull$$$0(9);
        }
        JSTypeId lTypeId = this.getTypeId(lType);
        JSTypeId rTypeId = this.getTypeId(rType);
        if (lTypeId == null || rTypeId == null) {
            return;
        }
        this.putAssignableIds(lTypeId, rTypeId, processingContext, result2);
    }

    @NotNull
    private JSTypeCastUtil.AssignableResult areAssignableIds(@NotNull JSTypeId lType, @NotNull JSTypeId rType, @NotNull ProcessingContext context) {
        if (lType == null) {
            JSTypeComparingCache.$$$reportNull$$$0(10);
        }
        if (rType == null) {
            JSTypeComparingCache.$$$reportNull$$$0(11);
        }
        if (context == null) {
            JSTypeComparingCache.$$$reportNull$$$0(12);
        }
        ApplicationManager.getApplication().assertReadAccessAllowed();
        if (lType.equals(rType)) {
            this.logUsedCache(lType, rType, JSTypeCastUtil.AssignableResult.ASSIGNABLE);
            JSTypeCastUtil.AssignableResult assignableResult = JSTypeCastUtil.AssignableResult.ASSIGNABLE;
            if (assignableResult == null) {
                JSTypeComparingCache.$$$reportNull$$$0(13);
            }
            return assignableResult;
        }
        ConcurrentMap<JSTypeId, Map<JSTypeId, JSTypeCastUtil.AssignableResult>> map = this.getCachedMap(context);
        Map compared = map.getOrDefault(lType, Collections.emptyMap());
        JSTypeCastUtil.AssignableResult result2 = compared.getOrDefault(rType, JSTypeCastUtil.AssignableResult.NOT_SURE);
        this.logUsedCache(lType, rType, result2);
        JSTypeCastUtil.AssignableResult assignableResult = result2;
        if (assignableResult == null) {
            JSTypeComparingCache.$$$reportNull$$$0(14);
        }
        return assignableResult;
    }

    @NotNull
    private ConcurrentMap<JSTypeId, Map<JSTypeId, JSTypeCastUtil.AssignableResult>> getCachedMap(@NotNull ProcessingContext context) {
        if (context == null) {
            JSTypeComparingCache.$$$reportNull$$$0(15);
        }
        ConcurrentMap<JSTypeId, Map<JSTypeId, JSTypeCastUtil.AssignableResult>> concurrentMap = this.myDefaultResult;
        if (concurrentMap == null) {
            JSTypeComparingCache.$$$reportNull$$$0(16);
        }
        return concurrentMap;
    }

    private void putAssignableIds(@NotNull JSTypeId lType, @NotNull JSTypeId rType, @NotNull ProcessingContext context, @NotNull JSTypeCastUtil.AssignableResult result2) {
        if (lType == null) {
            JSTypeComparingCache.$$$reportNull$$$0(17);
        }
        if (rType == null) {
            JSTypeComparingCache.$$$reportNull$$$0(18);
        }
        if (context == null) {
            JSTypeComparingCache.$$$reportNull$$$0(19);
        }
        if (result2 == null) {
            JSTypeComparingCache.$$$reportNull$$$0(20);
        }
        ApplicationManager.getApplication().assertReadAccessAllowed();
        ConcurrentMap<JSTypeId, Map<JSTypeId, JSTypeCastUtil.AssignableResult>> toUse = this.getCachedMap(context);
        Map map = toUse.computeIfAbsent(lType, el -> new ConcurrentHashMap());
        map.putIfAbsent(rType, result2);
        this.logWasCached(lType, rType, result2);
    }

    @Nullable
    private JSTypeId getTypeId(@NotNull JSType type) {
        if (type == null) {
            JSTypeComparingCache.$$$reportNull$$$0(21);
        }
        if (!((type = JSTypeUtils.getValuableType(type)) instanceof JSNamedType) || ((JSNamedType)type).getTypeContext() == JSTypeContext.STATIC || !type.getSource().isTypeScript()) {
            return null;
        }
        JSTypeId candidate = (JSTypeId)type.getUserData(TYPE_ID);
        if (candidate != null) {
            return candidate;
        }
        PsiElement scope = JSTypeComparingCache.getScopeForType(type);
        if (type instanceof JSPrimitiveType) {
            String text = type.getTypeText(JSType.TypeTextFormat.CODE);
            if (type instanceof JSLiteralType && type.isTypeScript() && ((JSLiteralType)type).canBeWidened()) {
                text = type.getTypeText(JSType.TypeTextFormat.PRESENTABLE);
            }
            PrimitiveTypeId id = type instanceof JSLiteralType ? new LiteralTypeId(text, !((JSLiteralType)type).canBeWidened()) : new PrimitiveTypeId(text);
            type.putUserData(TYPE_ID, (Object)id);
            return id;
        }
        String text = type.getTypeText(JSType.TypeTextFormat.CODE);
        if (scope == null || this.canBeLocalClass(text)) {
            return null;
        }
        NamedTypeId id = new NamedTypeId(text, scope);
        type.putUserData(TYPE_ID, (Object)id);
        return id;
    }

    private boolean canBeLocalClass(@Nullable String name) {
        Collection value = (Collection)this.myLocalClassNames.getValue();
        return name != null && value.contains(name);
    }

    @Nullable
    private static PsiElement getScopeForType(@NotNull JSType type) {
        PsiElement element;
        if (type == null) {
            JSTypeComparingCache.$$$reportNull$$$0(22);
        }
        return (element = type.getSource().getSourceElement()) == null ? null : PsiTreeUtil.getContextOfType((PsiElement)element, (Class[])new Class[]{TypeScriptModule.class, PsiFile.class, JSEmbeddedContent.class});
    }

    private void logWasCached(@NotNull JSTypeId lType, @NotNull JSTypeId rType, @NotNull JSTypeCastUtil.AssignableResult result2) {
        if (lType == null) {
            JSTypeComparingCache.$$$reportNull$$$0(23);
        }
        if (rType == null) {
            JSTypeComparingCache.$$$reportNull$$$0(24);
        }
        if (result2 == null) {
            JSTypeComparingCache.$$$reportNull$$$0(25);
        }
        if (this.myLogDebug) {
            LOG.debug(String.format("Cached result %d. ltype: %s, rtype: %s, assignable: %s", new Object[]{this.myCacheMissCount.incrementAndGet(), lType, rType, result2}));
        }
    }

    private void logRejectCache(JSType type, String reason) {
        if (this.myLogDebug) {
            LOG.debug("Reject use name " + type.getTypeText() + " reason: " + reason);
        }
    }

    private void logUsedCache(@NotNull JSTypeId lType, @NotNull JSTypeId rType, @NotNull JSTypeCastUtil.AssignableResult result2) {
        if (lType == null) {
            JSTypeComparingCache.$$$reportNull$$$0(26);
        }
        if (rType == null) {
            JSTypeComparingCache.$$$reportNull$$$0(27);
        }
        if (result2 == null) {
            JSTypeComparingCache.$$$reportNull$$$0(28);
        }
        if (this.myLogDebug && result2.isStrict()) {
            LOG.debug(String.format("Used cached value (%s). ltype: %s, rtype: %s, assignable: %s", new Object[]{this.myCacheUseCount.incrementAndGet(), lType, rType, result2}));
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 13: 
            case 14: 
            case 16: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 13: 
            case 14: 
            case 16: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "lType";
                break;
            }
            case 1: 
            case 7: 
            case 11: 
            case 18: 
            case 24: 
            case 27: {
                objectArray2 = objectArray3;
                objectArray3[0] = "rType";
                break;
            }
            case 2: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "processingContext";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 13: 
            case 14: 
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/javascript/psi/types/JSTypeComparingCache";
                break;
            }
            case 9: 
            case 20: 
            case 25: 
            case 28: {
                objectArray2 = objectArray3;
                objectArray3[0] = "result";
                break;
            }
            case 12: 
            case 15: 
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 21: 
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "type";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/javascript/psi/types/JSTypeComparingCache";
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "areAssignableTypes";
                break;
            }
            case 13: 
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "areAssignableIds";
                break;
            }
            case 16: {
                objectArray = objectArray2;
                objectArray2[1] = "getCachedMap";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "areAssignableTypes";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 13: 
            case 14: 
            case 16: {
                break;
            }
            case 6: 
            case 7: 
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "putAssignableTypes";
                break;
            }
            case 10: 
            case 11: 
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "areAssignableIds";
                break;
            }
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "getCachedMap";
                break;
            }
            case 17: 
            case 18: 
            case 19: 
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "putAssignableIds";
                break;
            }
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "getTypeId";
                break;
            }
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "getScopeForType";
                break;
            }
            case 23: 
            case 24: 
            case 25: {
                objectArray = objectArray;
                objectArray[2] = "logWasCached";
                break;
            }
            case 26: 
            case 27: 
            case 28: {
                objectArray = objectArray;
                objectArray[2] = "logUsedCache";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 13: 
            case 14: 
            case 16: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class NamedTypeId
    implements JSTypeId {
        @NotNull
        private final String myName;
        @NotNull
        private final PsiElement myScope;

        public NamedTypeId(@NotNull String name, @NotNull PsiElement scope) {
            if (name == null) {
                NamedTypeId.$$$reportNull$$$0(0);
            }
            if (scope == null) {
                NamedTypeId.$$$reportNull$$$0(1);
            }
            this.myName = name;
            this.myScope = scope;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            NamedTypeId id = (NamedTypeId)o;
            if (!this.myName.equals(id.myName)) {
                return false;
            }
            return this.myScope.equals(id.myScope);
        }

        public int hashCode() {
            int result2 = this.myName.hashCode();
            result2 = 31 * result2 + this.myScope.hashCode();
            return result2;
        }

        public String toString() {
            return this.myName + ", file " + this.myScope.getContainingFile().getName();
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "name";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "scope";
                    break;
                }
            }
            objectArray[1] = "com/intellij/lang/javascript/psi/types/JSTypeComparingCache$NamedTypeId";
            objectArray[2] = "<init>";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private static class LiteralTypeId
    extends PrimitiveTypeId {
        private final boolean myStrict;

        public LiteralTypeId(@NotNull String text, boolean isStrict) {
            if (text == null) {
                LiteralTypeId.$$$reportNull$$$0(0);
            }
            super(text);
            this.myStrict = isStrict;
        }

        @Override
        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            if (!super.equals(o)) {
                return false;
            }
            LiteralTypeId id = (LiteralTypeId)o;
            return this.myStrict == id.myStrict;
        }

        @Override
        public int hashCode() {
            int result2 = super.hashCode();
            result2 = 31 * result2 + (this.myStrict ? 1 : 0);
            return result2;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "text", "com/intellij/lang/javascript/psi/types/JSTypeComparingCache$LiteralTypeId", "<init>"));
        }
    }

    private static class PrimitiveTypeId
    implements JSTypeId {
        @NotNull
        private final String myText;

        public PrimitiveTypeId(@NotNull String text) {
            if (text == null) {
                PrimitiveTypeId.$$$reportNull$$$0(0);
            }
            this.myText = text;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            PrimitiveTypeId type = (PrimitiveTypeId)o;
            return this.myText.equals(type.myText);
        }

        public int hashCode() {
            return this.myText.hashCode();
        }

        public String toString() {
            return this.myText;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "text", "com/intellij/lang/javascript/psi/types/JSTypeComparingCache$PrimitiveTypeId", "<init>"));
        }
    }

    public static interface JSTypeId {
    }
}

