/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.psi.types;

import com.intellij.lang.javascript.JSNumberParser;
import com.intellij.lang.javascript.JSStringUtil;
import com.intellij.lang.javascript.psi.JSParameterTypeDecorator;
import com.intellij.lang.javascript.psi.JSRecordType;
import com.intellij.lang.javascript.psi.JSType;
import com.intellij.lang.javascript.psi.types.JSAnyType;
import com.intellij.lang.javascript.psi.types.JSApplyCallType;
import com.intellij.lang.javascript.psi.types.JSArrayTypeImpl;
import com.intellij.lang.javascript.psi.types.JSBooleanLiteralTypeImpl;
import com.intellij.lang.javascript.psi.types.JSCompositeTypeImpl;
import com.intellij.lang.javascript.psi.types.JSContext;
import com.intellij.lang.javascript.psi.types.JSDecoratedTypeImpl;
import com.intellij.lang.javascript.psi.types.JSDestructuringTypeImpl;
import com.intellij.lang.javascript.psi.types.JSFunctionTypeImpl;
import com.intellij.lang.javascript.psi.types.JSGenericParameterImpl;
import com.intellij.lang.javascript.psi.types.JSGenericTypeImpl;
import com.intellij.lang.javascript.psi.types.JSIntersectionTypeImpl;
import com.intellij.lang.javascript.psi.types.JSIterableComponentTypeImpl;
import com.intellij.lang.javascript.psi.types.JSMixinTypeImpl;
import com.intellij.lang.javascript.psi.types.JSNamedType;
import com.intellij.lang.javascript.psi.types.JSNumberLiteralTypeImpl;
import com.intellij.lang.javascript.psi.types.JSParameterTypeDecoratorImpl;
import com.intellij.lang.javascript.psi.types.JSRecordMemberSourceFactory;
import com.intellij.lang.javascript.psi.types.JSRecordTypeImpl;
import com.intellij.lang.javascript.psi.types.JSReferenceType;
import com.intellij.lang.javascript.psi.types.JSRequireCallExpressionType;
import com.intellij.lang.javascript.psi.types.JSStringLiteralTypeImpl;
import com.intellij.lang.javascript.psi.types.JSTaggedLiteralKeyTypeImpl;
import com.intellij.lang.javascript.psi.types.JSTupleTypeImpl;
import com.intellij.lang.javascript.psi.types.JSTypeContext;
import com.intellij.lang.javascript.psi.types.JSTypeImpl;
import com.intellij.lang.javascript.psi.types.JSTypeKeyTypeImpl;
import com.intellij.lang.javascript.psi.types.JSTypeSource;
import com.intellij.lang.javascript.psi.types.JSTypeVisitor;
import com.intellij.lang.javascript.psi.types.JSTypeofTypeImpl;
import com.intellij.lang.javascript.psi.types.JSUniqueSymbolTypeImpl;
import com.intellij.lang.javascript.psi.types.JSUnknownType;
import com.intellij.lang.javascript.psi.types.TypeScriptConditionalTypeJSTypeImpl;
import com.intellij.lang.javascript.psi.types.TypeScriptGenericThisTypeImpl;
import com.intellij.lang.javascript.psi.types.TypeScriptIndexedAccessJSTypeImpl;
import com.intellij.lang.javascript.psi.types.TypeScriptMappedJSTypeImpl;
import com.intellij.lang.javascript.psi.types.TypeScriptTypeOfJSTypeImpl;
import com.intellij.lang.javascript.psi.types.TypeScriptTypeOperatorJSTypeImpl;
import com.intellij.lang.javascript.psi.types.TypeScriptTypePredicateTypeImpl;
import com.intellij.openapi.util.Segment;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.util.SmartList;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.EnumSet;
import java.util.List;
import java.util.function.BiFunction;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JSTypeParser {
    public static final char GENERIC_PARAMETER_DELIMITER = '%';
    public static final String TYPEOF_IDENTIFIER = "#typeof";
    public static final String UNIQSYM_IDENTIFIER = "#uniqsym";
    public static final String TS_TYPEOF_IDENTIFIER = "#tstypeof";
    public static final String DESTRUCTURING_IDENTIFIER = "#destr";
    public static final String THIS_TYPE_IDENTIFIER = "#this";
    public static final String COMPONENT_OF_ITERABLE_IDENTIFIER = "#compof";
    public static final String APPLY_CALL_PREFIX = "#call(";
    public static final String REQUIRE_CALL_EXPRESSION_PREFIX = "#req";
    public static final String TYPE_PREDICATE_PREFIX = "#guard";
    public static final String TYPE_KEY_OF_PREFIX = "#keyof";
    public static final String TYPE_LITERAL_KEY_PREFIX = "#literalkey";
    public static final String TAGGED_LITERAL_KEY_PREFIX = "#taggedliteralkey";
    public static final String TYPE_MAPPED_PREFIX = "#mapped";
    public static final String TYPE_CONDITIONAL_PREFIX = "#conditional";
    public static final String TYPE_INDEXED_PREFIX = "#indt";
    public static final String INDEX_SIGNATURE_PREFIX = "#idx(";
    public static final String REFERENCE_TYPE_PREFIX = "#ref";
    public static final char SINGLE_TYPE_SPECIAL_CHAR = '^';
    public static final String SOME_INVALID_TYPE_PART = "^^";
    public static final String MIXIN_DELIMITER = "+";
    public static final String MODULE_PREFIX = "module:";
    public static final String EVENT_PREFIX = "event:";
    public static final String TUPLE_PREFIX = "#tuple";
    private static final String TRUE = "true";
    private static final String FALSE = "false";
    private static final String REST_PARAM_PREFIX = "...";
    @NotNull
    private final String myTypeString;
    private final JSTypeVisitor myVisitor;
    private final boolean myIsFromJSDoc;
    private int myCurrentOffset;
    @NotNull
    private final JSTypeSource mySource;
    private boolean myParsingFunction;

    public JSTypeParser(@NotNull String typeString, @NotNull JSTypeSource source) {
        if (typeString == null) {
            JSTypeParser.$$$reportNull$$$0(0);
        }
        if (source == null) {
            JSTypeParser.$$$reportNull$$$0(1);
        }
        this(typeString, source, false);
    }

    public JSTypeParser(@NotNull String typeString, @NotNull JSTypeSource source, boolean isFromJSDoc) {
        if (typeString == null) {
            JSTypeParser.$$$reportNull$$$0(2);
        }
        if (source == null) {
            JSTypeParser.$$$reportNull$$$0(3);
        }
        this(typeString, source, null, isFromJSDoc);
    }

    public JSTypeParser(@NotNull String typeString, JSTypeVisitor visitor) {
        if (typeString == null) {
            JSTypeParser.$$$reportNull$$$0(4);
        }
        this(typeString, JSTypeSource.EMPTY, visitor, true);
    }

    private JSTypeParser(@NotNull String typeString, @NotNull JSTypeSource typeSource, @Nullable JSTypeVisitor visitor, boolean isFromJSDoc) {
        if (typeString == null) {
            JSTypeParser.$$$reportNull$$$0(5);
        }
        if (typeSource == null) {
            JSTypeParser.$$$reportNull$$$0(6);
        }
        this.myTypeString = typeString;
        this.myIsFromJSDoc = isFromJSDoc;
        this.mySource = typeSource;
        this.myVisitor = visitor;
        this.myCurrentOffset = 0;
    }

    @Nullable
    public JSType parse() {
        return this.parse(false);
    }

    @Nullable
    public JSType parse(boolean allowCommentAfterType) {
        return this.handleParseResult(this.parseComposite(true), allowCommentAfterType);
    }

    @Nullable
    public JSParameterTypeDecorator parseParameterType() {
        return this.parseParameterType(false);
    }

    @Nullable
    public JSParameterTypeDecorator parseParameterType(boolean allowCommentAfterType) {
        return this.handleParseResult(this.parseInnerParameterType(true), allowCommentAfterType);
    }

    @Nullable
    public JSType parseNamepath() {
        return this.handleParseResult(this.parseSingleType(true), false);
    }

    private <T> T handleParseResult(T result2, boolean allowCommentAfterType) {
        if (!allowCommentAfterType && this.myCurrentOffset != this.myTypeString.length()) {
            return null;
        }
        return result2;
    }

    public int getTypeStringLength() {
        return this.myCurrentOffset;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Nullable
    private JSParameterTypeDecorator parseInnerParameterType(boolean allowComma) {
        JSType type;
        this.advanceSpaces();
        boolean rest = false;
        if (this.startsWith(REST_PARAM_PREFIX)) {
            char afterDotsChar;
            rest = true;
            this.advanceBy(REST_PARAM_PREFIX.length());
            this.advanceSpaces();
            if (!this.hasSymbol() || (afterDotsChar = this.getSymbol()) == ',' || afterDotsChar == ')' || afterDotsChar == '}') {
                type = JSAnyType.get((PsiElement)this.mySource.getScope(), this.mySource.isStrict());
            } else {
                boolean parseBrackets;
                boolean bl = parseBrackets = this.myParsingFunction && this.checkCurrentSymbol('[');
                if (parseBrackets) {
                    this.advance();
                }
                type = this.parseComposite(false);
                if (parseBrackets) {
                    if (!this.checkCurrentSymbol(']')) return null;
                    this.advance();
                }
            }
        } else {
            type = this.parseComposite(allowComma);
        }
        this.advanceSpaces();
        boolean optional = false;
        if (this.hasSymbol()) {
            char symbol = this.getSymbol();
            if (symbol == '?' || symbol == '=') {
                optional = true;
                this.advance();
                this.advanceSpaces();
                while (this.hasSymbol() && (this.getSymbol() == '\"' || StringUtil.isJavaIdentifierPart((char)this.getSymbol()))) {
                    this.advance();
                }
            } else if (symbol == ',') {
                int beforeCommaOffset = this.myCurrentOffset;
                this.advance();
                this.advanceSpaces();
                if (this.startsWith("optional")) {
                    this.advanceBy("optional".length());
                    optional = true;
                } else {
                    this.myCurrentOffset = beforeCommaOffset;
                }
            }
        }
        this.advanceSpaces();
        if (type == null && !optional) {
            if (!rest) return null;
        }
        JSParameterTypeDecoratorImpl jSParameterTypeDecoratorImpl = new JSParameterTypeDecoratorImpl(type, optional, rest, this.mySource.isStrict());
        return jSParameterTypeDecoratorImpl;
    }

    private JSType parseComposite(boolean allowComma) {
        return this.parseComposite(allowComma, "|/", true);
    }

    @Nullable
    private JSType parseComposite(boolean allowComma, @NotNull String delimiters, boolean isUnion) {
        if (delimiters == null) {
            JSTypeParser.$$$reportNull$$$0(7);
        }
        this.advanceSpaces();
        if (!this.hasSymbol()) {
            return null;
        }
        JSType type = this.parseTypeFromComposite(isUnion);
        this.advanceSpaces();
        ArrayList<JSType> addedUnionOptions = null;
        while (this.hasSymbol() && (delimiters.indexOf(this.getSymbol()) != -1 || allowComma && ',' == this.getSymbol())) {
            JSType unionOption;
            int commaOffset = ',' != this.getSymbol() ? -1 : this.myCurrentOffset;
            this.advance();
            if (addedUnionOptions == null) {
                addedUnionOptions = new ArrayList<JSType>();
            }
            if ((unionOption = this.parseTypeFromComposite(isUnion)) == null) continue;
            this.advanceSpaces();
            if (commaOffset >= 0 && unionOption instanceof JSTypeImpl && "optional".equals(unionOption.getTypeText(JSType.TypeTextFormat.SIMPLE))) {
                this.myCurrentOffset = commaOffset;
                break;
            }
            addedUnionOptions.add(unionOption);
        }
        if (addedUnionOptions != null && !addedUnionOptions.isEmpty()) {
            if (type != null) {
                addedUnionOptions.add(0, type);
            }
            type = isUnion ? new JSCompositeTypeImpl(this.mySource, (List<JSType>)addedUnionOptions) : new JSIntersectionTypeImpl(this.mySource, (Collection<JSType>)addedUnionOptions);
        }
        return type;
    }

    private JSType parseTypeFromComposite(boolean isUnion) {
        if (isUnion) {
            return this.parseComposite(false, "&", false);
        }
        return this.parseType();
    }

    private boolean isBooleanLiteralAhead() {
        if (this.startsWith(TRUE)) {
            int offset = this.myCurrentOffset + TRUE.length();
            return this.myTypeString.length() == offset || !Character.isJavaIdentifierPart(this.myTypeString.charAt(offset));
        }
        if (this.startsWith(FALSE)) {
            int offset = this.myCurrentOffset + FALSE.length();
            return this.myTypeString.length() == offset || !Character.isJavaIdentifierPart(this.myTypeString.charAt(offset));
        }
        return false;
    }

    /*
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Nullable
    private JSType parseType() {
        void var1_31;
        boolean decorationsAdded;
        this.advanceSpaces();
        if (!this.hasSymbol()) {
            return null;
        }
        char c = this.getSymbol();
        if (c == '{') {
            JSRecordType jSRecordType = this.parseRecordType();
            if (jSRecordType == null) {
                return null;
            }
        } else if (c == '(') {
            this.advance();
            JSType jSType = this.parseComposite(true);
            this.advanceSpaces();
            if (!this.hasSymbol() || this.getSymbol() != ')') return null;
            this.advance();
        } else if (c == '[') {
            this.advance();
            JSType jSType = this.parseComposite(true);
            this.advanceSpaces();
            if (!this.hasSymbol() || this.getSymbol() != ']') {
                return null;
            }
            this.advance();
            JSArrayTypeImpl jSArrayTypeImpl = new JSArrayTypeImpl(jSType, this.mySource);
        } else if (c == 'f' && this.startsWith("function")) {
            int funcStartOffset = this.myCurrentOffset;
            this.advanceBy("function".length());
            this.advanceSpaces();
            if (this.hasSymbol() && (this.getSymbol() == ':' || this.getSymbol() == '(')) {
                JSFunctionTypeImpl jSFunctionTypeImpl = this.parseFunctionAfterKeyword();
            } else {
                this.myCurrentOffset = funcStartOffset;
                JSType jSType = this.parseSingleType(false);
            }
        } else if (JSTypeParser.isQuote(c)) {
            JSStringLiteralTypeImpl jSStringLiteralTypeImpl = this.parseStringLiteralType();
        } else if (!this.myIsFromJSDoc && JSStringUtil.isNumericValueStart(this.myTypeString, false, this.myCurrentOffset)) {
            JSNumberLiteralTypeImpl jSNumberLiteralTypeImpl = this.parseNumericLiteralType();
        } else if (!this.myIsFromJSDoc && this.isBooleanLiteralAhead()) {
            JSBooleanLiteralTypeImpl jSBooleanLiteralTypeImpl = this.parseBooleanLiteralType();
        } else if (!this.myIsFromJSDoc && this.startsWith(TYPEOF_IDENTIFIER)) {
            JSTypeofTypeImpl jSTypeofTypeImpl = this.parseTypeofType();
        } else if (!this.myIsFromJSDoc && this.startsWith(UNIQSYM_IDENTIFIER)) {
            JSUniqueSymbolTypeImpl jSUniqueSymbolTypeImpl = this.parseUniqueSymbolType();
        } else if (!this.myIsFromJSDoc && this.startsWith(TS_TYPEOF_IDENTIFIER)) {
            TypeScriptTypeOfJSTypeImpl typeScriptTypeOfJSTypeImpl = this.parseTypeScriptTypeOf();
        } else if (!this.myIsFromJSDoc && this.startsWith(DESTRUCTURING_IDENTIFIER)) {
            JSType jSType = this.parseDestructuring();
        } else if (!this.myIsFromJSDoc && this.startsWith(TUPLE_PREFIX)) {
            JSType jSType = this.parseTupleType();
        } else if (!this.myIsFromJSDoc && this.startsWith(COMPONENT_OF_ITERABLE_IDENTIFIER)) {
            JSIterableComponentTypeImpl jSIterableComponentTypeImpl = this.parseIterableComponentType();
        } else if (!this.myIsFromJSDoc && this.startsWith(REQUIRE_CALL_EXPRESSION_PREFIX)) {
            JSType jSType = this.parseRequireCallExpressionType();
        } else if (!this.myIsFromJSDoc && this.startsWith(APPLY_CALL_PREFIX)) {
            JSApplyCallType jSApplyCallType = this.parseApplyCallType();
        } else if (!this.myIsFromJSDoc && this.startsWith(THIS_TYPE_IDENTIFIER)) {
            JSType jSType = this.parseThisExpressionType();
        } else if (!this.myIsFromJSDoc && this.startsWith(TYPE_PREDICATE_PREFIX)) {
            JSType jSType = this.parseTypePredicate();
        } else if (!this.myIsFromJSDoc && this.startsWith(TYPE_KEY_OF_PREFIX)) {
            JSType jSType = this.parseKeyOf();
        } else if (!this.myIsFromJSDoc && this.startsWith(TYPE_LITERAL_KEY_PREFIX)) {
            JSType jSType = this.parseSpecialLiteralType(TYPE_LITERAL_KEY_PREFIX, (literal, t) -> new JSTypeKeyTypeImpl((String)literal, (JSType)t, this.mySource));
        } else if (!this.myIsFromJSDoc && this.startsWith(TAGGED_LITERAL_KEY_PREFIX)) {
            JSType jSType = this.parseSpecialLiteralType(TAGGED_LITERAL_KEY_PREFIX, (literal, t) -> new JSTaggedLiteralKeyTypeImpl((String)literal, (JSType)t, this.mySource));
        } else if (!this.myIsFromJSDoc && this.startsWith(TYPE_INDEXED_PREFIX)) {
            JSType jSType = this.parseIndexedType();
        } else if (!this.myIsFromJSDoc && this.startsWith(TYPE_MAPPED_PREFIX)) {
            JSType jSType = this.parseMappedType();
        } else if (!this.myIsFromJSDoc && this.startsWith(TYPE_CONDITIONAL_PREFIX)) {
            JSType jSType = this.parseConditionalType();
        } else if (!this.myIsFromJSDoc && this.startsWith(REFERENCE_TYPE_PREFIX)) {
            JSReferenceType jSReferenceType = this.parseReferenceType();
        } else if (c == '%') {
            int genericParamStartOffset = ++this.myCurrentOffset;
            while (this.hasSymbol() && (c = this.getSymbol()) != '\u0000' && (StringUtil.isJavaIdentifierPart((char)c) || c == '.' || c == '#')) {
                this.advance();
            }
            JSGenericParameterImpl jSGenericParameterImpl = new JSGenericParameterImpl(this.myTypeString.substring(genericParamStartOffset, this.myCurrentOffset), this.mySource);
            if (!this.startsWith(String.valueOf('%'))) {
                return null;
            }
            this.advance();
        } else {
            JSType jSType = this.parseSingleType(false);
        }
        do {
            this.advanceSpaces();
            decorationsAdded = true;
            if (this.startsWith("[]")) {
                JSArrayTypeImpl jSArrayTypeImpl = new JSArrayTypeImpl((JSType)var1_31, this.mySource);
                this.advanceBy("[]".length());
                continue;
            }
            if (this.checkCurrentSymbol('!')) {
                JSType jSType = this.addTypeDecoration((JSType)var1_31, JSDecoratedTypeImpl.TypeDecoration.NOTNULL);
                this.advance();
                continue;
            }
            if (this.checkCurrentSymbol('<')) {
                this.advance();
                while (this.hasSymbol() && this.getSymbol() != '>') {
                    int typeStart = this.myCurrentOffset;
                    JSType jSType = this.addGenericArgument((JSType)var1_31, this.parseComposite(false));
                    this.advanceSpaces();
                    if (this.checkCurrentSymbol(',')) {
                        this.advance();
                        this.advanceSpaces();
                    }
                    if (typeStart != this.myCurrentOffset) continue;
                    return null;
                }
                if (!this.hasSymbol() || this.getSymbol() != '>') {
                    return null;
                }
                this.advance();
                continue;
            }
            if (this.checkCurrentSymbol('.')) {
                this.advance();
                continue;
            }
            if (this.startsWith(MIXIN_DELIMITER)) {
                this.advance();
                JSType mixed = this.parseType();
                if (var1_31 == null || mixed == null) continue;
                JSMixinTypeImpl jSMixinTypeImpl = new JSMixinTypeImpl((JSType)var1_31, mixed, this.mySource);
                continue;
            }
            decorationsAdded = false;
        } while (decorationsAdded);
        return var1_31;
    }

    private JSType parseTupleType() {
        assert (this.startsWith(TUPLE_PREFIX));
        this.advanceBy(TUPLE_PREFIX.length());
        boolean strict = this.parseProhibitWideningFlag();
        this.advance();
        if (!this.hasSymbol()) {
            return null;
        }
        ArrayList types = ContainerUtil.newArrayList();
        if (this.getSymbol() != ']') {
            do {
                if (this.getSymbol() == ',') {
                    this.advance();
                }
                int startOffset = this.myCurrentOffset;
                JSType type = this.parseComposite(false);
                if (type != null) {
                    types.add(type);
                }
                if (startOffset != this.myCurrentOffset) continue;
                this.advance();
            } while (this.hasSymbol() && this.getSymbol() == ',');
            if (!this.hasSymbol()) {
                return null;
            }
        }
        this.advance();
        return new JSTupleTypeImpl(this.mySource, types, strict);
    }

    @Nullable
    private JSType parseDestructuring() {
        TextRange range = this.parseSegmentBasedType(DESTRUCTURING_IDENTIFIER);
        if (range == null) {
            return null;
        }
        return new JSDestructuringTypeImpl((Segment)range, this.mySource);
    }

    private JSType parseThisExpressionType() {
        assert (this.startsWith(THIS_TYPE_IDENTIFIER));
        this.advanceBy(THIS_TYPE_IDENTIFIER.length());
        this.advance();
        JSType classQualifiedType = null;
        if (this.hasSymbol()) {
            classQualifiedType = this.parseComposite(false);
        }
        if (this.hasSymbol() && this.getSymbol() == ')') {
            this.advance();
        }
        return new TypeScriptGenericThisTypeImpl(this.mySource, classQualifiedType);
    }

    private JSTypeofTypeImpl parseTypeofType() {
        TextRange range = this.parseSegmentBasedType(TYPEOF_IDENTIFIER);
        if (range == null) {
            return null;
        }
        boolean prohibitWidening = this.parseProhibitWideningFlag();
        PsiFile file = this.mySource.getScope();
        return file != null ? new JSTypeofTypeImpl((Segment)range, file, this.mySource, prohibitWidening) : null;
    }

    private JSUniqueSymbolTypeImpl parseUniqueSymbolType() {
        TextRange range = this.parseSegmentBasedType(UNIQSYM_IDENTIFIER);
        if (range == null) {
            return null;
        }
        boolean prohibitWidening = this.parseProhibitWideningFlag();
        PsiFile file = this.mySource.getScope();
        return file != null ? new JSUniqueSymbolTypeImpl(this.mySource, JSTypeContext.INSTANCE, !prohibitWidening) : null;
    }

    private TextRange parseSegmentBasedType(String identifier) {
        assert (this.startsWith(identifier));
        this.advanceBy(identifier.length());
        int startOffset = this.parseSegmentBasedTypePart();
        int endOffset = this.parseSegmentBasedTypePart();
        if (!this.hasSymbol()) {
            return null;
        }
        this.advance();
        return new TextRange(startOffset, endOffset);
    }

    private int parseSegmentBasedTypePart() {
        char c;
        int startOffset = 0;
        this.advance();
        while (this.hasSymbol() && Character.isDigit(c = this.getSymbol())) {
            startOffset = startOffset * 10 + c - 48;
            this.advance();
        }
        return startOffset;
    }

    private JSIterableComponentTypeImpl parseIterableComponentType() {
        assert (this.startsWith(COMPONENT_OF_ITERABLE_IDENTIFIER));
        this.advanceBy(COMPONENT_OF_ITERABLE_IDENTIFIER.length());
        this.advance();
        JSType type = this.parseComposite(false);
        if (this.hasSymbol() && this.getSymbol() == ')') {
            this.advance();
        }
        if (type == null) {
            type = this.createAnyType();
        }
        return new JSIterableComponentTypeImpl(type, this.mySource);
    }

    private TypeScriptTypeOfJSTypeImpl parseTypeScriptTypeOf() {
        assert (this.startsWith(TS_TYPEOF_IDENTIFIER));
        this.advanceBy(TS_TYPEOF_IDENTIFIER.length());
        this.advance();
        int start = this.myCurrentOffset;
        while (this.hasSymbol() && this.getSymbol() != ')') {
            this.advance();
        }
        int end = this.myCurrentOffset;
        if (!this.hasSymbol() || this.getSymbol() != ')') {
            return null;
        }
        this.advance();
        String identifier = this.myTypeString.substring(start, end);
        return new TypeScriptTypeOfJSTypeImpl(identifier, this.mySource);
    }

    private JSType parseRequireCallExpressionType() {
        assert (this.startsWith(REQUIRE_CALL_EXPRESSION_PREFIX));
        this.advanceBy(REQUIRE_CALL_EXPRESSION_PREFIX.length());
        int start = this.myCurrentOffset;
        while (this.hasSymbol()) {
            char c = this.getSymbol();
            this.advance();
            if (c != '^') continue;
            break;
        }
        if (this.myCurrentOffset - 1 < start) {
            return null;
        }
        return new JSRequireCallExpressionType(this.myTypeString.substring(start, this.myCurrentOffset - 1), this.mySource);
    }

    private JSApplyCallType parseApplyCallType() {
        assert (this.startsWith(APPLY_CALL_PREFIX));
        this.advanceBy(APPLY_CALL_PREFIX.length());
        JSType type = this.parseComposite(false);
        if (this.hasSymbol() && this.getSymbol() == ')') {
            this.advance();
        }
        return new JSApplyCallType((JSType)(type != null ? type : this.createAnyType()), this.mySource);
    }

    @NotNull
    private String readIdentifier() {
        assert (this.hasSymbol());
        int start = this.myCurrentOffset;
        while (this.hasSymbol() && Character.isJavaIdentifierPart(this.getSymbol())) {
            this.advance();
        }
        String string = this.myTypeString.substring(start, this.myCurrentOffset);
        if (string == null) {
            JSTypeParser.$$$reportNull$$$0(8);
        }
        return string;
    }

    private int readPositiveNumber() {
        int start = this.myCurrentOffset;
        while (this.hasSymbol() && Character.isDigit(this.getSymbol())) {
            this.advance();
        }
        try {
            if (this.myCurrentOffset > start) {
                return Integer.parseInt(this.myTypeString.substring(start, this.myCurrentOffset));
            }
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        return -1;
    }

    @NotNull
    private JSType parseTypePredicate() {
        assert (this.startsWith(TYPE_PREDICATE_PREFIX));
        this.advanceBy(TYPE_PREDICATE_PREFIX.length());
        this.advanceSpaces();
        String parameterName = null;
        if (this.getSymbol() != '?') {
            parameterName = this.readIdentifier();
        } else {
            this.advance();
        }
        this.advanceSpaces();
        boolean isNegative = false;
        if (this.hasSymbol() && this.getSymbol() == '-') {
            isNegative = true;
            this.advance();
        }
        int parameterIndex = this.readPositiveNumber();
        JSType type = this.parseType();
        TypeScriptTypePredicateTypeImpl typeScriptTypePredicateTypeImpl = new TypeScriptTypePredicateTypeImpl(type, this.mySource, parameterName, isNegative ? -1 : parameterIndex);
        if (typeScriptTypePredicateTypeImpl == null) {
            JSTypeParser.$$$reportNull$$$0(9);
        }
        return typeScriptTypePredicateTypeImpl;
    }

    private JSType parseSpecialLiteralType(String prefix, BiFunction<String, JSType, JSType> createType) {
        assert (this.startsWith(prefix));
        this.advanceBy(prefix.length());
        if (this.hasSymbol()) {
            this.advance();
        }
        JSType type = null;
        if (this.hasSymbol() && this.getSymbol() != ')') {
            type = this.parseComposite(false);
        }
        if (this.hasSymbol() && this.getSymbol() == ')') {
            this.advance();
        }
        if (type == null) {
            type = this.createAnyType();
        }
        String literal = null;
        if (this.hasSymbol() && this.getSymbol() == '(') {
            this.advance();
            literal = this.parseStringLiteral();
            if (this.hasSymbol() && this.getSymbol() == ')') {
                this.advance();
            }
        }
        if (literal == null) {
            literal = "";
        }
        return createType.apply(literal, type);
    }

    @NotNull
    private JSType parseKeyOf() {
        assert (this.startsWith(TYPE_KEY_OF_PREFIX));
        this.advanceBy(TYPE_KEY_OF_PREFIX.length());
        if (this.hasSymbol()) {
            this.advance();
        }
        JSType type = null;
        if (this.hasSymbol() && this.getSymbol() != ')') {
            type = this.parseComposite(false);
        }
        if (this.hasSymbol() && this.getSymbol() == ')') {
            this.advance();
        }
        if (type == null) {
            type = this.createAnyType();
        }
        TypeScriptTypeOperatorJSTypeImpl typeScriptTypeOperatorJSTypeImpl = new TypeScriptTypeOperatorJSTypeImpl(type, this.mySource);
        if (typeScriptTypeOperatorJSTypeImpl == null) {
            JSTypeParser.$$$reportNull$$$0(10);
        }
        return typeScriptTypeOperatorJSTypeImpl;
    }

    private JSType parseIndexedType() {
        assert (this.startsWith(TYPE_INDEXED_PREFIX));
        this.advanceBy(TYPE_INDEXED_PREFIX.length());
        if (!this.hasSymbol() || this.getSymbol() != '(') {
            return this.createAnyType();
        }
        this.advance();
        JSType ownerType = this.parseType();
        if (ownerType == null || !this.hasSymbol() || this.getSymbol() != ',') {
            return this.createAnyType();
        }
        this.advance();
        JSType parameterType = this.parseComposite(false);
        if (parameterType == null || !this.hasSymbol() || this.getSymbol() != ')') {
            return this.createAnyType();
        }
        this.advance();
        return new TypeScriptIndexedAccessJSTypeImpl(ownerType, parameterType, this.mySource);
    }

    private JSType parseConditionalType() {
        assert (this.startsWith(TYPE_CONDITIONAL_PREFIX));
        this.advanceBy(TYPE_CONDITIONAL_PREFIX.length());
        if (!this.hasSymbol() || this.getSymbol() != '(') {
            return this.createAnyType();
        }
        this.advance();
        JSType checkedType = this.parseType();
        if (checkedType == null || !this.hasSymbol() || this.getSymbol() != ',') {
            return this.createAnyType();
        }
        this.advance();
        JSType testType = this.parseType();
        if (testType == null || !this.hasSymbol() || this.getSymbol() != ',') {
            return this.createAnyType();
        }
        this.advance();
        JSType typeIfTrue = this.parseType();
        if (typeIfTrue == null || !this.hasSymbol() || this.getSymbol() != ',') {
            return this.createAnyType();
        }
        this.advance();
        JSType typeIfFalse = this.parseType();
        if (typeIfFalse == null || !this.hasSymbol() || this.getSymbol() != ')') {
            return this.createAnyType();
        }
        this.advance();
        return new TypeScriptConditionalTypeJSTypeImpl(this.mySource, checkedType, testType, typeIfTrue, typeIfFalse);
    }

    private JSType parseMappedType() {
        assert (this.startsWith(TYPE_MAPPED_PREFIX));
        this.advanceBy(TYPE_MAPPED_PREFIX.length());
        if (this.hasSymbol()) {
            this.advance();
        }
        if (!this.hasSymbol()) {
            return this.createAnyType();
        }
        char candidate = this.getSymbol();
        boolean isReadonly = false;
        if (candidate == 'r') {
            isReadonly = true;
            this.advance();
            if (this.hasSymbol()) {
                candidate = this.getSymbol();
            } else {
                return this.createAnyType();
            }
        }
        if (candidate == '[') {
            this.advance();
        }
        String parameterName = this.readIdentifier();
        if (!this.hasSymbol()) {
            return this.createAnyType();
        }
        char separator = this.getSymbol();
        if (separator != '+') {
            return this.createAnyType();
        }
        this.advance();
        if (!this.hasSymbol()) {
            return this.createAnyType();
        }
        JSType type = this.parseType();
        if (type == null || !this.hasSymbol() || this.getSymbol() != ']') {
            return this.createAnyType();
        }
        this.advance();
        if (!this.hasSymbol()) {
            return this.createAnyType();
        }
        boolean isOptional = false;
        candidate = this.getSymbol();
        if (candidate == '?') {
            isOptional = true;
            this.advance();
            if (!this.hasSymbol()) {
                return this.createAnyType();
            }
            candidate = this.getSymbol();
        }
        if (candidate != ':') {
            return this.createAnyType();
        }
        this.advance();
        if (!this.hasSymbol()) {
            return this.createAnyType();
        }
        JSType resultType = this.parseType();
        if (resultType == null || !this.hasSymbol() || this.getSymbol() != '}') {
            return this.createAnyType();
        }
        this.advance();
        return new TypeScriptMappedJSTypeImpl(this.mySource, isReadonly, isOptional, parameterName, type, resultType);
    }

    @NotNull
    private JSReferenceType parseReferenceType() {
        assert (this.startsWith(REFERENCE_TYPE_PREFIX));
        this.advanceBy(REFERENCE_TYPE_PREFIX.length());
        int identifierStart = this.myCurrentOffset;
        while (this.hasSymbol() && StringUtil.isJavaIdentifierPart((char)this.getSymbol())) {
            this.advance();
        }
        JSReferenceType jSReferenceType = new JSReferenceType(this.myTypeString.substring(identifierStart, this.myCurrentOffset), this.mySource);
        if (jSReferenceType == null) {
            JSTypeParser.$$$reportNull$$$0(11);
        }
        return jSReferenceType;
    }

    @NotNull
    private JSAnyType createAnyType() {
        JSAnyType jSAnyType = JSAnyType.get(this.mySource.getSourceElement(), true);
        if (jSAnyType == null) {
            JSTypeParser.$$$reportNull$$$0(12);
        }
        return jSAnyType;
    }

    private JSRecordType parseRecordType() {
        ArrayList<JSRecordType.TypeMember> typeMembers = new ArrayList<JSRecordType.TypeMember>();
        this.advance();
        this.advanceSpaces();
        while (this.hasSymbol() && this.getSymbol() != '}') {
            int labelStart = this.myCurrentOffset;
            if (this.checkCurrentSymbol('(')) {
                JSFunctionTypeImpl callSignature = this.parseFunctionAfterKeyword();
                if (callSignature != null) {
                    typeMembers.add((JSRecordType.TypeMember)new JSRecordTypeImpl.CallSignatureImpl(false, callSignature));
                }
            } else if (this.startsWith(INDEX_SIGNATURE_PREFIX)) {
                JSRecordType.IndexSignature signature = this.parseIndexSignature();
                if (signature != null) {
                    typeMembers.add((JSRecordType.TypeMember)signature);
                }
            } else {
                boolean optional = false;
                char startSymbol = this.getSymbol();
                boolean isSymbol = startSymbol == '[' && this.startsWith("[Symbol.");
                boolean isQuoted = JSTypeParser.isQuote(startSymbol);
                if (!isSymbol && !isQuoted && startSymbol == '[') {
                    optional = true;
                    this.advance();
                    this.advanceSpaces();
                }
                labelStart = this.myCurrentOffset;
                if (isSymbol || isQuoted) {
                    this.advance();
                }
                while (this.hasSymbol() && (StringUtil.isJavaIdentifierPart((char)this.getSymbol()) || '.' == this.getSymbol() || isQuoted && this.getSymbol() != startSymbol)) {
                    this.advance();
                }
                if (isSymbol && this.checkCurrentSymbol(']')) {
                    this.advance();
                }
                if (isQuoted && this.checkCurrentSymbol(startSymbol)) {
                    this.advance();
                }
                String recordLabel = this.myTypeString.substring(labelStart, this.myCurrentOffset);
                if (isQuoted) {
                    recordLabel = JSStringUtil.unquoteAndUnescapeString(recordLabel);
                }
                this.advanceSpaces();
                if (optional && this.checkCurrentSymbol(']')) {
                    this.advance();
                    this.advanceSpaces();
                }
                if (!optional && !isQuoted && "new".equals(recordLabel) && this.checkCurrentSymbol('(')) {
                    JSFunctionTypeImpl callSignature = this.parseFunctionAfterKeyword();
                    if (callSignature != null) {
                        typeMembers.add((JSRecordType.TypeMember)new JSRecordTypeImpl.CallSignatureImpl(true, callSignature));
                    }
                } else {
                    JSParameterTypeDecorator recordPropertyType = null;
                    if (this.checkCurrentSymbol('?')) {
                        optional = true;
                        this.advance();
                        this.advanceSpaces();
                    }
                    if (this.checkCurrentSymbol(':')) {
                        this.advance();
                        this.advanceSpaces();
                        recordPropertyType = this.parseInnerParameterType(false);
                        this.advanceSpaces();
                    }
                    JSType type = recordPropertyType != null ? recordPropertyType.getType() : null;
                    typeMembers.add((JSRecordType.TypeMember)new JSRecordTypeImpl.PropertySignatureImpl(recordLabel, type, optional |= recordPropertyType != null && recordPropertyType.isOptional()));
                    if (this.myVisitor != null) {
                        this.myVisitor.visitRecordProperty(labelStart, recordLabel, type != null ? type.getTypeText() : null);
                    }
                }
            }
            if (this.hasSymbol() && this.getSymbol() == ',') {
                this.advance();
                this.advanceSpaces();
            }
            if (labelStart != this.myCurrentOffset) continue;
            break;
        }
        if (!this.hasSymbol() || this.getSymbol() != '}') {
            return null;
        }
        this.advance();
        return new JSRecordTypeImpl(this.mySource, typeMembers);
    }

    @NotNull
    private JSBooleanLiteralTypeImpl parseBooleanLiteralType() {
        if (this.startsWith(TRUE)) {
            this.advanceBy(TRUE.length());
            JSBooleanLiteralTypeImpl jSBooleanLiteralTypeImpl = new JSBooleanLiteralTypeImpl(true, !this.parseProhibitWideningFlag(), this.mySource);
            if (jSBooleanLiteralTypeImpl == null) {
                JSTypeParser.$$$reportNull$$$0(13);
            }
            return jSBooleanLiteralTypeImpl;
        }
        this.advanceBy(FALSE.length());
        JSBooleanLiteralTypeImpl jSBooleanLiteralTypeImpl = new JSBooleanLiteralTypeImpl(false, !this.parseProhibitWideningFlag(), this.mySource);
        if (jSBooleanLiteralTypeImpl == null) {
            JSTypeParser.$$$reportNull$$$0(14);
        }
        return jSBooleanLiteralTypeImpl;
    }

    @Nullable
    private JSNumberLiteralTypeImpl parseNumericLiteralType() {
        JSStringUtil.NumberParseResult result2 = JSNumberParser.tryParseNumericValue(this.myTypeString, this.myCurrentOffset);
        if (result2 == null) {
            return null;
        }
        this.myCurrentOffset = result2.getNewOffset();
        return new JSNumberLiteralTypeImpl(result2.getValue(), !this.parseProhibitWideningFlag(), this.mySource, result2.getStringValue());
    }

    @Nullable
    private JSStringLiteralTypeImpl parseStringLiteralType() {
        String literalValue = this.parseStringLiteral();
        return literalValue == null ? null : new JSStringLiteralTypeImpl(literalValue, !this.parseProhibitWideningFlag(), this.mySource);
    }

    @Nullable
    private String parseStringLiteral() {
        char quote = this.getSymbol();
        this.advance();
        int literalStart = this.myCurrentOffset;
        boolean screened = false;
        while (this.hasSymbol()) {
            char c = this.getSymbol();
            if (c == '\\') {
                screened = !screened;
            } else if (!screened && c == quote) {
                this.advance();
                return this.myTypeString.substring(literalStart, this.myCurrentOffset - 1);
            }
            this.advance();
        }
        return null;
    }

    private boolean parseProhibitWideningFlag() {
        boolean canBeWidened = true;
        if (this.hasSymbol() && this.getSymbol() == '!') {
            this.advance();
            canBeWidened = false;
        }
        return !canBeWidened;
    }

    private JSRecordType.IndexSignature parseIndexSignature() {
        assert (this.startsWith(INDEX_SIGNATURE_PREFIX));
        this.advanceBy(INDEX_SIGNATURE_PREFIX.length());
        if (!this.checkCurrentSymbol('[')) {
            return null;
        }
        this.advance();
        JSType typeParameter = this.parseComposite(false);
        this.advanceSpaces();
        if (!this.checkCurrentSymbol(']')) {
            return null;
        }
        this.advance();
        if (!this.checkCurrentSymbol(':')) {
            return null;
        }
        this.advance();
        this.advanceSpaces();
        JSType typeReturn = this.parseComposite(false);
        this.advanceSpaces();
        if (!this.checkCurrentSymbol(')')) {
            return null;
        }
        this.advance();
        return new JSRecordTypeImpl.IndexSignatureImpl(typeParameter, typeReturn, JSRecordMemberSourceFactory.createEmptySource());
    }

    @Nullable
    private JSType addTypeDecoration(@Nullable JSType type, JSDecoratedTypeImpl.TypeDecoration decoration) {
        JSDecoratedTypeImpl decoratedType;
        if (type == null) {
            return null;
        }
        if (type instanceof JSDecoratedTypeImpl) {
            EnumSet<JSDecoratedTypeImpl.TypeDecoration> decorations = EnumSet.copyOf(((JSDecoratedTypeImpl)type).getDecorations());
            decorations.add(decoration);
            decoratedType = new JSDecoratedTypeImpl(this.mySource, ((JSDecoratedTypeImpl)type).getType(), decorations);
        } else {
            decoratedType = new JSDecoratedTypeImpl(this.mySource, type, EnumSet.of(decoration));
        }
        return decoratedType;
    }

    @Nullable
    private JSType addGenericArgument(JSType type, JSType genericArgument) {
        if (type == null || genericArgument == null) {
            return null;
        }
        if (type instanceof JSGenericTypeImpl) {
            List<JSType> arguments = ((JSGenericTypeImpl)type).getArguments();
            ArrayList newArgs = ContainerUtil.newArrayList(arguments);
            newArgs.add(genericArgument);
            return new JSGenericTypeImpl(type.getSource(), ((JSGenericTypeImpl)type).getType(), newArgs);
        }
        return new JSGenericTypeImpl(this.mySource, type, genericArgument);
    }

    @Nullable
    private JSFunctionTypeImpl parseFunctionAfterKeyword() {
        SmartList decorators = new SmartList();
        JSType newType = null;
        JSType thisType = null;
        this.myParsingFunction = true;
        if (this.checkCurrentSymbol('(')) {
            this.advance();
            this.advanceSpaces();
            while (this.hasSymbol() && this.getSymbol() != ')') {
                JSType paramType;
                int paramStart = this.myCurrentOffset;
                while (this.hasSymbol() && StringUtil.isJavaIdentifierPart((char)this.getSymbol())) {
                    this.advance();
                }
                int identifierEnd = this.myCurrentOffset;
                this.advanceSpaces();
                String recordLabel = null;
                if (this.checkCurrentSymbol(':')) {
                    this.advance();
                    recordLabel = this.myTypeString.substring(paramStart, identifierEnd);
                } else {
                    this.myCurrentOffset = paramStart;
                }
                JSParameterTypeDecorator paramTypeDecorator = this.parseInnerParameterType(false);
                JSType jSType = paramType = paramTypeDecorator != null ? paramTypeDecorator.getType() : null;
                if ("this".equals(recordLabel)) {
                    thisType = paramType;
                } else if ("new".equals(recordLabel)) {
                    newType = paramType;
                } else {
                    boolean optional = paramTypeDecorator != null && paramTypeDecorator.isOptional();
                    boolean rest = paramTypeDecorator != null && paramTypeDecorator.isRest();
                    JSParameterTypeDecoratorImpl decorator = new JSParameterTypeDecoratorImpl(paramType, optional, rest, true);
                    decorators.add(decorator);
                }
                this.advanceSpaces();
                if (this.checkCurrentSymbol(',')) {
                    this.advance();
                    this.advanceSpaces();
                }
                if (this.myCurrentOffset != paramStart) continue;
                return null;
            }
            if (!this.hasSymbol() || this.getSymbol() != ')') {
                return null;
            }
            this.advance();
        }
        this.advanceSpaces();
        JSType returnType = null;
        if (this.checkCurrentSymbol(':')) {
            this.advance();
            returnType = this.parseType();
        }
        return new JSFunctionTypeImpl(this.mySource, (List<JSParameterTypeDecorator>)decorators, returnType, thisType, newType);
    }

    @Nullable
    private JSType parseSingleType(boolean isModule) {
        JSType type;
        char c;
        this.advanceSpaces();
        char c2 = c = this.hasSymbol() ? this.getSymbol() : (char)'\u0000';
        if (c == '?') {
            this.advance();
            this.advanceSpaces();
            int afterQuestOffset = this.myCurrentOffset;
            type = this.parseType();
            type = type == null && afterQuestOffset == this.myCurrentOffset ? JSUnknownType.INSTANCE : this.addTypeDecoration(type, JSDecoratedTypeImpl.TypeDecoration.NULLABLE);
        } else if (c == '!') {
            this.advance();
            type = this.parseType();
            type = this.addTypeDecoration(type, JSDecoratedTypeImpl.TypeDecoration.NOTNULL);
        } else if (c == '*') {
            this.advance();
            type = JSAnyType.get((PsiElement)this.mySource.getScope(), this.mySource.isStrict());
        } else {
            int identifierStartOffset = this.myCurrentOffset;
            JSContext jsContext = JSContext.INSTANCE;
            if (c == 't' && this.startsWith("typeof ")) {
                this.advanceBy("typeof".length());
                this.advanceSpaces();
                if (this.hasSymbol() && StringUtil.isJavaIdentifierPart((char)this.getSymbol())) {
                    jsContext = JSContext.STATIC;
                    identifierStartOffset = this.myCurrentOffset;
                } else {
                    this.myCurrentOffset = identifierStartOffset;
                }
            }
            int identifierEndOffset = identifierStartOffset;
            while (this.hasSymbol() && (c = this.getSymbol()) != '\u0000' && (StringUtil.isJavaIdentifierPart((char)c) || c == '.' || c == '#' || c == '~' || isModule && c == '/' || c == '^')) {
                if (c == 'm' && this.startsWith(MODULE_PREFIX)) {
                    this.advanceBy(MODULE_PREFIX.length());
                    isModule = true;
                    continue;
                }
                if (c == 'e' && this.startsWith(EVENT_PREFIX)) {
                    this.advanceBy(EVENT_PREFIX.length());
                    continue;
                }
                if (c == 'e' && this.startsWith("external:")) {
                    this.advanceBy("external:".length());
                    continue;
                }
                this.advance();
                if (c != '.' && c != '#' && c != '~') {
                    identifierEndOffset = this.myCurrentOffset;
                }
                if (c != '^' || !this.checkCurrentSymbol('q')) continue;
                this.advance();
                while (true) {
                    if (!this.canLookahead()) {
                        return null;
                    }
                    if (this.getSymbol() == '^' && this.lookaheadSymbol() == 'q') break;
                    this.advance();
                }
                this.advanceBy(2);
            }
            if (identifierEndOffset > identifierStartOffset) {
                String name = this.myTypeString.substring(identifierStartOffset, identifierEndOffset);
                if (c == '.') {
                    jsContext = JSContext.STATIC;
                }
                JSType jSType = type = this.mySource.getLanguage() == JSTypeSource.SourceLanguage.TS && "any".equals(name) ? JSAnyType.get((PsiElement)this.mySource.getScope(), this.mySource.isStrict()) : JSNamedType.createType(name, this.mySource, JSTypeContext.fromJSContext(jsContext), false, this.myIsFromJSDoc);
                if (this.myVisitor != null) {
                    this.myVisitor.visitSingleType(identifierStartOffset, name);
                }
            } else {
                return null;
            }
        }
        return type;
    }

    private static boolean isQuote(char c) {
        return c == '\"' || c == '\'';
    }

    private char getSymbol() {
        return this.myTypeString.charAt(this.myCurrentOffset);
    }

    private boolean checkCurrentSymbol(char ch) {
        return this.hasSymbol() && this.getSymbol() == ch;
    }

    private void advance() {
        ++this.myCurrentOffset;
    }

    private void advanceBy(int count) {
        this.myCurrentOffset += count;
    }

    private boolean hasSymbol() {
        return this.myCurrentOffset < this.myTypeString.length();
    }

    private char lookaheadSymbol() {
        return this.myTypeString.charAt(this.myCurrentOffset + 1);
    }

    private boolean canLookahead() {
        return this.myCurrentOffset + 1 < this.myTypeString.length();
    }

    private boolean startsWith(String prefix) {
        return this.myTypeString.startsWith(prefix, this.myCurrentOffset);
    }

    private void advanceSpaces() {
        while (this.myCurrentOffset < this.myTypeString.length() && StringUtil.isWhiteSpace((char)this.getSymbol())) {
            this.advance();
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "typeString";
                break;
            }
            case 1: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "source";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "typeSource";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "delimiters";
                break;
            }
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/javascript/psi/types/JSTypeParser";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/javascript/psi/types/JSTypeParser";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "readIdentifier";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "parseTypePredicate";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "parseKeyOf";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "parseReferenceType";
                break;
            }
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "createAnyType";
                break;
            }
            case 13: 
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "parseBooleanLiteralType";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "parseComposite";
                break;
            }
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class Chars {
        private static final char LPAREN = '(';
        private static final char RPAREN = ')';
        private static final char LBRACE = '{';
        private static final char RBRACE = '}';
        private static final char LBRACKET = '[';
        private static final char RBRACKET = ']';
        private static final char COMMA = ',';
        private static final char QUESTION = '?';
        private static final char EQ = '=';
        private static final char LT = '<';
        private static final char GT = '>';
        private static final char DOT = '.';
        private static final char EXCLAMATION = '!';
        private static final char MINUS = '-';
        private static final char PLUS = '+';
        private static final char COLON = ':';

        private Chars() {
        }
    }
}

