/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.psi.types;

import com.intellij.lang.javascript.psi.JSNamespace;
import com.intellij.lang.javascript.psi.JSQualifiedName;
import com.intellij.lang.javascript.psi.JSQualifiedNameImpl;
import com.intellij.lang.javascript.psi.JSType;
import com.intellij.lang.javascript.psi.JSTypeUtils;
import com.intellij.lang.javascript.psi.types.JSContext;
import com.intellij.lang.javascript.psi.types.JSNamedType;
import com.intellij.lang.javascript.psi.types.JSRecursiveTypeVisitor;
import com.intellij.lang.javascript.psi.types.JSTypeBaseImpl;
import com.intellij.lang.javascript.psi.types.JSTypeSource;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.Function;
import com.intellij.util.ProcessingContext;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class TypeScriptTypePredicateTypeImpl
extends JSTypeBaseImpl
implements JSType.CompositeStructure,
JSNamespace {
    public static final char NO_NAME_HOLDER = '?';
    @Nullable
    private final JSType myType;
    @Nullable
    private final String myParameterName;
    private final int myParameterIndex;

    @Nullable
    public JSType getGuardType() {
        return this.myType;
    }

    @Nullable
    public String getParameterName() {
        return this.myParameterName;
    }

    public boolean isThisParameter() {
        return "this".equals(this.myParameterName);
    }

    public int getParameterIndex() {
        return this.myParameterIndex;
    }

    public TypeScriptTypePredicateTypeImpl(@Nullable JSType guardType, @NotNull JSTypeSource source, @Nullable String parameterName, int parameterIndex) {
        if (source == null) {
            TypeScriptTypePredicateTypeImpl.$$$reportNull$$$0(0);
        }
        super(source);
        this.myType = guardType;
        this.myParameterName = parameterName;
        this.myParameterIndex = parameterIndex;
    }

    @NotNull
    public String getTypeText(JSType.TypeTextFormat format) {
        if (format == JSType.TypeTextFormat.PRESENTABLE) {
            if ("boolean" == null) {
                TypeScriptTypePredicateTypeImpl.$$$reportNull$$$0(1);
            }
            return "boolean";
        }
        if (format == JSType.TypeTextFormat.SERIALIZED) {
            StringBuilder result2 = new StringBuilder();
            result2.append("#guard");
            result2.append(StringUtil.isEmpty((String)this.myParameterName) ? Character.valueOf('?') : this.myParameterName);
            result2.append(" ");
            result2.append(this.myParameterIndex);
            result2.append(" ");
            boolean shouldWrap = JSTypeUtils.isNeedWrapTypeForSerialization(this.myType);
            if (shouldWrap) {
                result2.append("(");
            }
            result2.append(this.myType != null ? this.myType.getTypeText(format) : "any");
            if (shouldWrap) {
                result2.append(")");
            }
            String string = result2.toString();
            if (string == null) {
                TypeScriptTypePredicateTypeImpl.$$$reportNull$$$0(2);
            }
            return string;
        }
        String string = (this.myParameterName == null ? "param" : this.myParameterName) + " is " + (this.myType == null ? "" : this.myType.getTypeText(format));
        if (string == null) {
            TypeScriptTypePredicateTypeImpl.$$$reportNull$$$0(3);
        }
        return string;
    }

    @NotNull
    public String getTypeId() {
        String string = "#typepredicate#" + (this.myType == null ? "$null$" : this.myType.getTypeId()) + "/" + this.myParameterName + ":" + this.myParameterIndex;
        if (string == null) {
            TypeScriptTypePredicateTypeImpl.$$$reportNull$$$0(4);
        }
        return string;
    }

    @Override
    protected boolean isDirectlyAssignableTypeImpl(@NotNull JSType elementType, @Nullable ProcessingContext processingContext) {
        if (elementType == null) {
            TypeScriptTypePredicateTypeImpl.$$$reportNull$$$0(5);
        }
        if (elementType instanceof TypeScriptTypePredicateTypeImpl && this.isDirectlyAssignableTypeForPredicate((TypeScriptTypePredicateTypeImpl)elementType, processingContext)) {
            return true;
        }
        return super.isDirectlyAssignableTypeImpl(elementType, processingContext);
    }

    private boolean isDirectlyAssignableTypeForPredicate(@NotNull TypeScriptTypePredicateTypeImpl typePredicateType, @Nullable ProcessingContext processingContext) {
        if (typePredicateType == null) {
            TypeScriptTypePredicateTypeImpl.$$$reportNull$$$0(6);
        }
        JSType rGuardType = typePredicateType.getGuardType();
        JSType lGuardType = this.getGuardType();
        if (typePredicateType.getParameterIndex() != this.getParameterIndex()) {
            return false;
        }
        if (rGuardType == null || lGuardType == null) {
            return rGuardType == lGuardType;
        }
        return lGuardType.isDirectlyAssignableType(rGuardType, processingContext);
    }

    @Override
    public boolean isEquivalentToImpl(@NotNull JSType type, @Nullable ProcessingContext processingContext, boolean allowResolve) {
        if (type == null) {
            TypeScriptTypePredicateTypeImpl.$$$reportNull$$$0(7);
        }
        if (!(type instanceof TypeScriptTypePredicateTypeImpl)) {
            return false;
        }
        TypeScriptTypePredicateTypeImpl typePredicateType = (TypeScriptTypePredicateTypeImpl)type;
        JSType lGuardType = this.getGuardType();
        JSType rGuardType = typePredicateType.getGuardType();
        if (typePredicateType.getParameterIndex() == this.getParameterIndex()) {
            if (lGuardType == null || rGuardType == null) {
                return lGuardType == typePredicateType;
            }
            return lGuardType.isEquivalentTo(rGuardType, processingContext, allowResolve);
        }
        return false;
    }

    @Override
    public void acceptChildren(JSRecursiveTypeVisitor visitor) {
        if (this.myType != null) {
            this.myType.accept(visitor);
        }
    }

    @Override
    @NotNull
    protected JSType copyTypeHierarchy(@NotNull Function<JSType, JSType> childTransform) {
        JSType newGuardType;
        JSType oldGuard;
        if (childTransform == null) {
            TypeScriptTypePredicateTypeImpl.$$$reportNull$$$0(8);
        }
        if ((oldGuard = this.getGuardType()) == (newGuardType = JSTypeUtils.transformTypeHierarchySafe(oldGuard, childTransform))) {
            TypeScriptTypePredicateTypeImpl typeScriptTypePredicateTypeImpl = this;
            if (typeScriptTypePredicateTypeImpl == null) {
                TypeScriptTypePredicateTypeImpl.$$$reportNull$$$0(9);
            }
            return typeScriptTypePredicateTypeImpl;
        }
        TypeScriptTypePredicateTypeImpl typeScriptTypePredicateTypeImpl = new TypeScriptTypePredicateTypeImpl(newGuardType, this.getSource(), this.getParameterName(), this.getParameterIndex());
        if (typeScriptTypePredicateTypeImpl == null) {
            TypeScriptTypePredicateTypeImpl.$$$reportNull$$$0(10);
        }
        return typeScriptTypePredicateTypeImpl;
    }

    @NotNull
    public JSType asBoolean() {
        JSType jSType = JSNamedType.createType("boolean", this.getSource(), JSContext.INSTANCE);
        if (jSType == null) {
            TypeScriptTypePredicateTypeImpl.$$$reportNull$$$0(11);
        }
        return jSType;
    }

    @Override
    @NotNull
    protected JSType copyWithNewSource(@NotNull JSTypeSource source) {
        if (source == null) {
            TypeScriptTypePredicateTypeImpl.$$$reportNull$$$0(12);
        }
        TypeScriptTypePredicateTypeImpl typeScriptTypePredicateTypeImpl = new TypeScriptTypePredicateTypeImpl(this.getGuardType(), source, this.getParameterName(), this.getParameterIndex());
        if (typeScriptTypePredicateTypeImpl == null) {
            TypeScriptTypePredicateTypeImpl.$$$reportNull$$$0(13);
        }
        return typeScriptTypePredicateTypeImpl;
    }

    @Override
    @NotNull
    public JSType substitute() {
        JSType jSType = this.asBoolean();
        if (jSType == null) {
            TypeScriptTypePredicateTypeImpl.$$$reportNull$$$0(14);
        }
        return jSType;
    }

    @Nullable
    public JSQualifiedName getQualifiedName() {
        return JSQualifiedNameImpl.create("Boolean", null);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 9: 
            case 10: 
            case 11: 
            case 13: 
            case 14: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 9: 
            case 10: 
            case 11: 
            case 13: 
            case 14: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "source";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 9: 
            case 10: 
            case 11: 
            case 13: 
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/javascript/psi/types/TypeScriptTypePredicateTypeImpl";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "elementType";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "typePredicateType";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "type";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "childTransform";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/javascript/psi/types/TypeScriptTypePredicateTypeImpl";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getTypeText";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getTypeId";
                break;
            }
            case 9: 
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "copyTypeHierarchy";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "asBoolean";
                break;
            }
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "copyWithNewSource";
                break;
            }
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "substitute";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 9: 
            case 10: 
            case 11: 
            case 13: 
            case 14: {
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "isDirectlyAssignableTypeImpl";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "isDirectlyAssignableTypeForPredicate";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "isEquivalentToImpl";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "copyTypeHierarchy";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "copyWithNewSource";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 9: 
            case 10: 
            case 11: 
            case 13: 
            case 14: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

