/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.psi.types.guard;

import com.intellij.lang.javascript.DialectDetector;
import com.intellij.lang.javascript.DialectOptionHolder;
import com.intellij.lang.javascript.JSTokenTypes;
import com.intellij.lang.javascript.ecmascript6.TypeScriptUtil;
import com.intellij.lang.javascript.index.JSSymbolUtil;
import com.intellij.lang.javascript.psi.JSBinaryExpression;
import com.intellij.lang.javascript.psi.JSCallExpression;
import com.intellij.lang.javascript.psi.JSCaseClause;
import com.intellij.lang.javascript.psi.JSCommonTypeNames;
import com.intellij.lang.javascript.psi.JSDefinitionExpression;
import com.intellij.lang.javascript.psi.JSElement;
import com.intellij.lang.javascript.psi.JSExecutionScope;
import com.intellij.lang.javascript.psi.JSExpression;
import com.intellij.lang.javascript.psi.JSFieldVariable;
import com.intellij.lang.javascript.psi.JSLiteralExpression;
import com.intellij.lang.javascript.psi.JSParenthesizedExpression;
import com.intellij.lang.javascript.psi.JSPrefixExpression;
import com.intellij.lang.javascript.psi.JSRecordType;
import com.intellij.lang.javascript.psi.JSReferenceExpression;
import com.intellij.lang.javascript.psi.JSSwitchStatement;
import com.intellij.lang.javascript.psi.JSThisExpression;
import com.intellij.lang.javascript.psi.JSType;
import com.intellij.lang.javascript.psi.JSTypeUtils;
import com.intellij.lang.javascript.psi.JSVariable;
import com.intellij.lang.javascript.psi.ecma6.JSTypeDeclaration;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptTypeParameterList;
import com.intellij.lang.javascript.psi.ecmal4.JSClass;
import com.intellij.lang.javascript.psi.ecmal4.JSQualifiedNamedElement;
import com.intellij.lang.javascript.psi.ecmal4.JSSuperExpression;
import com.intellij.lang.javascript.psi.resolve.JSEvaluateContext;
import com.intellij.lang.javascript.psi.resolve.JSTypeEvaluator;
import com.intellij.lang.javascript.psi.types.JSAnyType;
import com.intellij.lang.javascript.psi.types.JSCompositeTypeBaseImpl;
import com.intellij.lang.javascript.psi.types.JSCompositeTypeImpl;
import com.intellij.lang.javascript.psi.types.JSContext;
import com.intellij.lang.javascript.psi.types.JSExoticStringLiteralType;
import com.intellij.lang.javascript.psi.types.JSIntersectionTypeImpl;
import com.intellij.lang.javascript.psi.types.JSLiteralType;
import com.intellij.lang.javascript.psi.types.JSNamedType;
import com.intellij.lang.javascript.psi.types.JSNumberLiteralTypeImpl;
import com.intellij.lang.javascript.psi.types.JSPrimitiveLiteralType;
import com.intellij.lang.javascript.psi.types.JSResolvableType;
import com.intellij.lang.javascript.psi.types.JSResolvedTypeInfo;
import com.intellij.lang.javascript.psi.types.JSStringLiteralTypeImpl;
import com.intellij.lang.javascript.psi.types.JSTypeComparingCacheService;
import com.intellij.lang.javascript.psi.types.JSTypeContext;
import com.intellij.lang.javascript.psi.types.JSTypeSource;
import com.intellij.lang.javascript.psi.types.JSTypeSourceFactory;
import com.intellij.lang.javascript.psi.types.JSUnionType;
import com.intellij.lang.javascript.psi.types.TypeScriptTypePredicateTypeImpl;
import com.intellij.lang.javascript.psi.types.guard.JSControlFlowTypeGuard;
import com.intellij.lang.javascript.psi.types.guard.JSTypeFacts;
import com.intellij.lang.javascript.psi.types.guard.TypeScriptTypeGuard;
import com.intellij.lang.javascript.psi.types.guard.TypeScriptTypeRelations;
import com.intellij.lang.javascript.psi.types.primitives.JSNullType;
import com.intellij.lang.javascript.psi.types.primitives.JSNumberType;
import com.intellij.lang.javascript.psi.types.primitives.JSObjectType;
import com.intellij.lang.javascript.psi.types.primitives.JSPrimitiveFunctionType;
import com.intellij.lang.javascript.psi.types.primitives.JSPrimitiveType;
import com.intellij.lang.javascript.psi.types.primitives.JSStringType;
import com.intellij.lang.javascript.psi.types.primitives.JSUndefinedType;
import com.intellij.lang.javascript.psi.types.primitives.TypeScriptNeverJSTypeImpl;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.ArrayUtil;
import com.intellij.util.Function;
import com.intellij.util.ProcessingContext;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.Predicate;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.stream.Collectors;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class JSTypeGuardChecker {
    @NotNull
    protected final String myTopReferenceName;
    @NotNull
    protected final JSExpression myReference;
    @NotNull
    protected final JSTypeSource mySource;
    @NotNull
    protected final JSType myDeclaredType;
    @Nullable
    protected final JSType myRealType;
    @NotNull
    protected final ProcessingContext myProcessingContext;
    @NotNull
    protected final ProcessingContext mySubtypingProcessingContext;
    protected final boolean myIsTypeScript;
    @Nullable
    protected final PsiElement myResolveElement;

    public static boolean isNarrowableReference(@Nullable JSExpression expression) {
        if (expression instanceof JSThisExpression || expression instanceof JSSuperExpression) {
            return true;
        }
        if (expression instanceof JSReferenceExpression) {
            JSExpression qualifier = ((JSReferenceExpression)expression).getQualifier();
            return qualifier == null || JSTypeGuardChecker.isNarrowableReference(qualifier);
        }
        return false;
    }

    public static boolean isAvailable(@NotNull PsiElement place, @Nullable JSType type, @NotNull PsiElement candidate) {
        DialectOptionHolder holder;
        if (place == null) {
            JSTypeGuardChecker.$$$reportNull$$$0(0);
        }
        if (candidate == null) {
            JSTypeGuardChecker.$$$reportNull$$$0(1);
        }
        if ((holder = DialectDetector.dialectOfElement(place)) == null || holder.isECMA4) {
            return false;
        }
        if (!(place instanceof JSExpression) || !JSTypeGuardChecker.isNarrowableReference((JSExpression)place)) {
            return false;
        }
        boolean isTypeScript = holder.isTypeScript;
        if ((type instanceof JSPrimitiveType || type instanceof JSUndefinedType || type instanceof JSNullType) && !isTypeScript) {
            return false;
        }
        if (isTypeScript && candidate instanceof JSDefinitionExpression) {
            return false;
        }
        if (!(candidate instanceof JSQualifiedNamedElement)) {
            return false;
        }
        PsiElement placeParent = place.getContext();
        if (placeParent instanceof JSDefinitionExpression && ((JSDefinitionExpression)placeParent).getExpression() == place) {
            return false;
        }
        JSElement scopeParent = (JSElement)PsiTreeUtil.getContextOfType((PsiElement)place, (Class[])new Class[]{JSClass.class, JSExecutionScope.class, JSTypeDeclaration.class, TypeScriptTypeParameterList.class});
        return scopeParent instanceof JSExecutionScope;
    }

    @NotNull
    public static JSTypeGuardChecker createGuard(@NotNull JSReferenceExpression reference, @Nullable JSType startType, @Nullable PsiElement resolveElement) {
        if (reference == null) {
            JSTypeGuardChecker.$$$reportNull$$$0(2);
        }
        if (DialectDetector.isTypeScript((PsiElement)reference)) {
            TypeScriptTypeGuard typeScriptTypeGuard = TypeScriptTypeGuard.createTypeScriptTypeGuard(reference, startType, resolveElement);
            if (typeScriptTypeGuard == null) {
                JSTypeGuardChecker.$$$reportNull$$$0(3);
            }
            return typeScriptTypeGuard;
        }
        JSControlFlowTypeGuard jSControlFlowTypeGuard = new JSControlFlowTypeGuard(reference, startType, resolveElement);
        if (jSControlFlowTypeGuard == null) {
            JSTypeGuardChecker.$$$reportNull$$$0(4);
        }
        return jSControlFlowTypeGuard;
    }

    public JSTypeGuardChecker(@NotNull JSReferenceExpression reference, @Nullable JSType startType, @Nullable PsiElement resolveElement) {
        if (reference == null) {
            JSTypeGuardChecker.$$$reportNull$$$0(5);
        }
        this.myTopReferenceName = JSTypeGuardChecker.getFirstQualifierName(reference);
        this.myProcessingContext = JSTypeComparingCacheService.getProcessingContextWithCache((PsiElement)reference);
        this.mySubtypingProcessingContext = JSTypeComparingCacheService.getSubtypingProcessingContext((PsiElement)reference);
        this.myReference = reference;
        this.myRealType = startType;
        this.myIsTypeScript = DialectDetector.isTypeScript((PsiElement)reference);
        this.mySource = startType == null ? JSTypeSourceFactory.createTypeSource((PsiElement)this.myReference, this.myIsTypeScript, false) : startType.getSource();
        this.myDeclaredType = startType != null ? JSTypeGuardChecker.getExactType(startType) : JSNamedType.createType("Object", this.mySource, JSContext.INSTANCE);
        this.myResolveElement = resolveElement;
    }

    @NotNull
    private static String getFirstQualifierName(@NotNull JSReferenceExpression expression) {
        if (expression == null) {
            JSTypeGuardChecker.$$$reportNull$$$0(6);
        }
        JSExpression qualifier = expression.getQualifier();
        while (qualifier instanceof JSReferenceExpression) {
            expression = (JSReferenceExpression)qualifier;
            qualifier = expression.getQualifier();
        }
        String string = StringUtil.notNullize((String)expression.getReferenceName());
        if (string == null) {
            JSTypeGuardChecker.$$$reportNull$$$0(7);
        }
        return string;
    }

    @Nullable
    public final JSType getNarrowedType() {
        JSType result2 = this.getNarrowedTypeImpl();
        return result2 == this.myDeclaredType || !this.myIsTypeScript && result2 instanceof TypeScriptNeverJSTypeImpl ? this.myRealType : result2;
    }

    @NotNull
    protected abstract JSType getNarrowedTypeImpl();

    @Nullable
    public static JSPrefixExpression getTypeOfPrefixExpression(@Nullable JSExpression candidate) {
        if (candidate instanceof JSPrefixExpression && ((JSPrefixExpression)candidate).getOperationSign() == JSTokenTypes.TYPEOF_KEYWORD) {
            return (JSPrefixExpression)candidate;
        }
        return null;
    }

    @NotNull
    private JSType narrowTypeByEquality(@NotNull JSType type, @NotNull IElementType sign, @NotNull JSExpression expression, boolean assumeTrue) {
        JSType valueType;
        if (type == null) {
            JSTypeGuardChecker.$$$reportNull$$$0(8);
        }
        if (sign == null) {
            JSTypeGuardChecker.$$$reportNull$$$0(9);
        }
        if (expression == null) {
            JSTypeGuardChecker.$$$reportNull$$$0(10);
        }
        if (type instanceof JSAnyType) {
            JSType jSType = type;
            if (jSType == null) {
                JSTypeGuardChecker.$$$reportNull$$$0(11);
            }
            return jSType;
        }
        if (JSTypeGuardChecker.isNegativeSign(sign)) {
            boolean bl = assumeTrue = !assumeTrue;
        }
        if ((valueType = JSTypeGuardChecker.getExactType(JSTypeGuardChecker.getExpressionTypeForTypeGuard(expression))) == null) {
            JSType jSType = type;
            if (jSType == null) {
                JSTypeGuardChecker.$$$reportNull$$$0(12);
            }
            return jSType;
        }
        if (JSCompositeTypeBaseImpl.isNullOrUndefinedType(valueType)) {
            boolean doubleEquals;
            boolean bl = doubleEquals = sign == JSTokenTypes.EQEQ || sign == JSTokenTypes.NE;
            JSTypeFacts.SimpleFact facts = doubleEquals ? (assumeTrue ? JSTypeFacts.SimpleFact.EQUndefinedOrNull : JSTypeFacts.SimpleFact.NEUndefinedOrNull) : (valueType instanceof JSNullType ? (assumeTrue ? JSTypeFacts.SimpleFact.EQNull : JSTypeFacts.SimpleFact.NENull) : (assumeTrue ? JSTypeFacts.SimpleFact.EQUndefined : JSTypeFacts.SimpleFact.NEUndefined));
            JSType jSType = JSTypeFacts.TYPE_FACTS.getTypeWithFact(type, facts, (PsiElement)this.myReference, this.strictNullChecks());
            if (jSType == null) {
                JSTypeGuardChecker.$$$reportNull$$$0(13);
            }
            return jSType;
        }
        if (!(type instanceof JSUnionType) && !JSTypeGuardChecker.isUnitType(type)) {
            JSType jSType = type;
            if (jSType == null) {
                JSTypeGuardChecker.$$$reportNull$$$0(14);
            }
            return jSType;
        }
        if (assumeTrue) {
            JSType narrowType = TypeScriptTypeRelations.filterType(type, (Predicate<JSType>)((Predicate)el -> TypeScriptTypeRelations.areTypesComparable(el, valueType, this.myProcessingContext)), (PsiElement)this.myReference);
            JSType jSType = narrowType instanceof TypeScriptNeverJSTypeImpl ? type : this.replacePrimitivesWithLiterals(narrowType, valueType);
            if (jSType == null) {
                JSTypeGuardChecker.$$$reportNull$$$0(15);
            }
            return jSType;
        }
        if (JSTypeGuardChecker.isUnitType(valueType)) {
            JSType regularType = TypeScriptTypeRelations.getRegularTypeOfLiteralType(valueType);
            JSType resultType = TypeScriptTypeRelations.filterType(type, (Predicate<JSType>)((Predicate)el -> {
                JSType literalType = TypeScriptTypeRelations.getRegularTypeOfLiteralType(el);
                return literalType != null && !literalType.isEquivalentTo(regularType, null, true);
            }), (PsiElement)this.myReference);
            JSType jSType = JSTypeGuardChecker.processNeverType(type, resultType);
            if (jSType == null) {
                JSTypeGuardChecker.$$$reportNull$$$0(16);
            }
            return jSType;
        }
        JSType jSType = type;
        if (jSType == null) {
            JSTypeGuardChecker.$$$reportNull$$$0(17);
        }
        return jSType;
    }

    @Contract(value="!null,!null->!null")
    private static JSType processNeverType(@Nullable JSType type, @Nullable JSType resultOrNeverType) {
        return resultOrNeverType instanceof TypeScriptNeverJSTypeImpl ? type : resultOrNeverType;
    }

    protected JSType getBaseTypeOfLiteralType(@NotNull JSType type) {
        JSResolvedTypeInfo resolvedType;
        if (type == null) {
            JSTypeGuardChecker.$$$reportNull$$$0(18);
        }
        if (type instanceof JSResolvableType && type.isTypeScript() && (resolvedType = ((JSResolvableType)type).resolveType()) != null && resolvedType.isEnumLiteral()) {
            return TypeScriptUtil.getBaseTypeOfEnumLiteralType((JSResolvableType)type);
        }
        if (type instanceof JSLiteralType) {
            return ((JSLiteralType)type).asPrimitiveType();
        }
        if (type instanceof JSCompositeTypeImpl) {
            List<JSType> types = ((JSCompositeTypeImpl)type).getTypes();
            List<JSType> resultTypes = types.stream().map(el -> this.getBaseTypeOfLiteralType((JSType)el)).collect(Collectors.toList());
            return TypeScriptTypeRelations.getUnionType(resultTypes, type.getSource());
        }
        return type;
    }

    private static boolean isDiscriminantProperty(@Nullable JSType type, @NotNull String propertyName) {
        JSRecordType.MemberSource source;
        JSRecordType recordType;
        JSRecordType.PropertySignature signature;
        if (propertyName == null) {
            JSTypeGuardChecker.$$$reportNull$$$0(19);
        }
        if (type instanceof JSCompositeTypeImpl && (signature = (recordType = type.asRecordType()).findPropertySignature(propertyName)) != null && ((source = signature.getMemberSource()).isEmpty() || source.getMemberSourceKind() == JSRecordType.MemberSourceKind.Union)) {
            return JSTypeGuardChecker.isLiteralType(signature.getType());
        }
        return false;
    }

    private static boolean isNegativeSign(@NotNull IElementType sign) {
        if (sign == null) {
            JSTypeGuardChecker.$$$reportNull$$$0(20);
        }
        return sign == JSTokenTypes.NE || sign == JSTokenTypes.NEQEQ;
    }

    @NotNull
    private JSType narrowTypeByAnd(@NotNull JSType rawType, @NotNull JSBinaryExpression expr, boolean assumeTrue) {
        if (rawType == null) {
            JSTypeGuardChecker.$$$reportNull$$$0(21);
        }
        if (expr == null) {
            JSTypeGuardChecker.$$$reportNull$$$0(22);
        }
        if (assumeTrue) {
            JSType jSType = this.narrowType(this.narrowType(rawType, expr.getLOperand(), true), expr.getROperand(), true);
            if (jSType == null) {
                JSTypeGuardChecker.$$$reportNull$$$0(23);
            }
            return jSType;
        }
        JSType type1 = this.narrowType(rawType, expr.getLOperand(), false);
        JSType type2 = this.narrowType(this.narrowType(rawType, expr.getLOperand(), true), expr.getROperand(), false);
        if (type1 == rawType) {
            JSType jSType = type2;
            if (jSType == null) {
                JSTypeGuardChecker.$$$reportNull$$$0(24);
            }
            return jSType;
        }
        if (type2 == rawType) {
            JSType jSType = type1;
            if (jSType == null) {
                JSTypeGuardChecker.$$$reportNull$$$0(25);
            }
            return jSType;
        }
        JSType jSType = this.getUnionType(type1, type2);
        if (jSType == null) {
            JSTypeGuardChecker.$$$reportNull$$$0(26);
        }
        return jSType;
    }

    @NotNull
    private JSType narrowTypeByOr(@NotNull JSType rawType, @NotNull JSBinaryExpression expr, boolean assumeTrue) {
        if (rawType == null) {
            JSTypeGuardChecker.$$$reportNull$$$0(27);
        }
        if (expr == null) {
            JSTypeGuardChecker.$$$reportNull$$$0(28);
        }
        if (assumeTrue) {
            JSType jSType = this.getUnionType(this.narrowType(rawType, expr.getLOperand(), true), this.narrowType(this.narrowType(rawType, expr.getLOperand(), false), expr.getROperand(), true));
            if (jSType == null) {
                JSTypeGuardChecker.$$$reportNull$$$0(29);
            }
            return jSType;
        }
        JSType jSType = this.narrowType(this.narrowType(rawType, expr.getLOperand(), false), expr.getROperand(), false);
        if (jSType == null) {
            JSTypeGuardChecker.$$$reportNull$$$0(30);
        }
        return jSType;
    }

    @Contract(value="null,_ -> false")
    private boolean isMatchingReferenceDiscriminant(@NotNull JSType type, @Nullable PsiElement expression) {
        if (type == null) {
            JSTypeGuardChecker.$$$reportNull$$$0(31);
        }
        if (expression instanceof JSReferenceExpression) {
            JSReferenceExpression referenceExpression = (JSReferenceExpression)expression;
            String name = referenceExpression.getReferenceName();
            if (name == null) {
                return false;
            }
            JSExpression qualifier = referenceExpression.getQualifier();
            if (qualifier == null) {
                return false;
            }
            if ((type = JSTypeGuardChecker.getExactType(type)) instanceof JSCompositeTypeImpl) {
                return JSTypeGuardChecker.isMatchingReference((PsiElement)this.myReference, (PsiElement)qualifier) && JSTypeGuardChecker.isDiscriminantProperty(type, name);
            }
        }
        return false;
    }

    private static boolean isLiteralType(@Nullable JSType rawType) {
        if (rawType == null) {
            return false;
        }
        if (rawType instanceof JSCompositeTypeImpl) {
            return ((JSCompositeTypeImpl)rawType).getTypes().stream().allMatch(JSTypeGuardChecker::isUnitType);
        }
        return JSTypeGuardChecker.isUnitType(rawType);
    }

    private static boolean isUnitType(@Nullable JSType rawType) {
        return rawType instanceof JSLiteralType || rawType instanceof JSUndefinedType || rawType instanceof JSNullType || JSTypeUtils.isEnumLiteral(rawType) && rawType.getSource().isStrict();
    }

    @NotNull
    private JSType narrowTypeByInstanceof(@NotNull JSType type, @NotNull JSBinaryExpression expr, boolean assumeTrue) {
        JSExpression left;
        if (type == null) {
            JSTypeGuardChecker.$$$reportNull$$$0(32);
        }
        if (expr == null) {
            JSTypeGuardChecker.$$$reportNull$$$0(33);
        }
        if ((left = JSTypeGuardChecker.getReferenceCandidate(expr.getLOperand())) == null) {
            JSType jSType = type;
            if (jSType == null) {
                JSTypeGuardChecker.$$$reportNull$$$0(34);
            }
            return jSType;
        }
        if (!JSTypeGuardChecker.isMatchingReference((PsiElement)this.myReference, (PsiElement)left)) {
            if (JSTypeGuardChecker.containsMatchingReference((PsiElement)this.myReference, (PsiElement)left)) {
                JSType jSType = this.myDeclaredType;
                if (jSType == null) {
                    JSTypeGuardChecker.$$$reportNull$$$0(35);
                }
                return jSType;
            }
            JSType jSType = type;
            if (jSType == null) {
                JSTypeGuardChecker.$$$reportNull$$$0(36);
            }
            return jSType;
        }
        JSExpression rOperand = expr.getROperand();
        if (rOperand == null) {
            JSType jSType = type;
            if (jSType == null) {
                JSTypeGuardChecker.$$$reportNull$$$0(37);
            }
            return jSType;
        }
        type = JSTypeGuardChecker.getExactType(type);
        JSType targetType = this.getTargetTypeForInstanceof((PsiElement)rOperand);
        if (targetType == null) {
            JSType jSType = type;
            if (jSType == null) {
                JSTypeGuardChecker.$$$reportNull$$$0(38);
            }
            return jSType;
        }
        if (JSTypeGuardChecker.isSourceTypeAnyAndTargetTypeFunctionOrObject(type, targetType)) {
            JSType jSType = type;
            if (jSType == null) {
                JSTypeGuardChecker.$$$reportNull$$$0(39);
            }
            return jSType;
        }
        if (type instanceof JSAnyType) {
            JSType jSType = targetType;
            if (jSType == null) {
                JSTypeGuardChecker.$$$reportNull$$$0(40);
            }
            return jSType;
        }
        JSType narrowedType = this.getNarrowedType(type, targetType, assumeTrue, (el, el2) -> TypeScriptTypeRelations.isTypeInstanceOf(el, el2, this.mySubtypingProcessingContext));
        JSType jSType = JSTypeGuardChecker.processNeverType(type, narrowedType);
        if (jSType == null) {
            JSTypeGuardChecker.$$$reportNull$$$0(41);
        }
        return jSType;
    }

    private JSType getTargetTypeForInstanceof(PsiElement rOperand) {
        if (!(rOperand instanceof JSReferenceExpression)) {
            return null;
        }
        JSReferenceExpression operand = (JSReferenceExpression)rOperand;
        JSType result2 = JSSymbolUtil.createTypeFromReferenceExpression(operand, JSTypeContext.INSTANCE);
        return result2 == null ? null : result2.copyWithStrict(this.mySource.isStrict());
    }

    @NotNull
    private JSType getNarrowedType(@NotNull JSType type, @NotNull JSType candidate, boolean assumeTrue, @NotNull TypeRelation relation) {
        JSType assignableType;
        if (type == null) {
            JSTypeGuardChecker.$$$reportNull$$$0(42);
        }
        if (candidate == null) {
            JSTypeGuardChecker.$$$reportNull$$$0(43);
        }
        if (relation == null) {
            JSTypeGuardChecker.$$$reportNull$$$0(44);
        }
        if (!assumeTrue) {
            JSType jSType = TypeScriptTypeRelations.filterType(type, (Predicate<JSType>)((Predicate)t -> {
                if (relation == null) {
                    JSTypeGuardChecker.$$$reportNull$$$0(122);
                }
                if (candidate == null) {
                    JSTypeGuardChecker.$$$reportNull$$$0(123);
                }
                return !relation.isRelated((JSType)t, candidate);
            }), (PsiElement)this.myReference);
            if (jSType == null) {
                JSTypeGuardChecker.$$$reportNull$$$0(45);
            }
            return jSType;
        }
        if ((type = JSTypeGuardChecker.getExactType(type)) instanceof JSUnionType && !((assignableType = TypeScriptTypeRelations.filterType(type, (Predicate<JSType>)((Predicate)t -> {
            if (relation == null) {
                JSTypeGuardChecker.$$$reportNull$$$0(120);
            }
            if (candidate == null) {
                JSTypeGuardChecker.$$$reportNull$$$0(121);
            }
            return relation.isRelated((JSType)t, candidate);
        }), (PsiElement)this.myReference)) instanceof TypeScriptNeverJSTypeImpl)) {
            JSType jSType = assignableType;
            if (jSType == null) {
                JSTypeGuardChecker.$$$reportNull$$$0(46);
            }
            return jSType;
        }
        if (TypeScriptTypeRelations.isTypeSubtypeOf(candidate, type, this.mySubtypingProcessingContext)) {
            JSType jSType = candidate;
            if (jSType == null) {
                JSTypeGuardChecker.$$$reportNull$$$0(47);
            }
            return jSType;
        }
        if (TypeScriptTypeRelations.isTypeAssignableTo(type, candidate, this.myProcessingContext)) {
            JSType jSType = type;
            if (jSType == null) {
                JSTypeGuardChecker.$$$reportNull$$$0(48);
            }
            return jSType;
        }
        if (TypeScriptTypeRelations.isTypeAssignableTo(candidate, type, this.myProcessingContext)) {
            JSType jSType = candidate;
            if (jSType == null) {
                JSTypeGuardChecker.$$$reportNull$$$0(49);
            }
            return jSType;
        }
        JSType jSType = JSIntersectionTypeImpl.getIntersectionType(ContainerUtil.newArrayList((Object[])new JSType[]{type, candidate}), candidate.getSource());
        if (jSType == null) {
            JSTypeGuardChecker.$$$reportNull$$$0(50);
        }
        return jSType;
    }

    @NotNull
    protected JSType getTypeAtSwitchClause(@NotNull JSType type, @NotNull JSSwitchStatement statement, int start, int end) {
        JSExpression expression;
        if (type == null) {
            JSTypeGuardChecker.$$$reportNull$$$0(51);
        }
        if (statement == null) {
            JSTypeGuardChecker.$$$reportNull$$$0(52);
        }
        if (JSTypeGuardChecker.isMatchingReference((PsiElement)this.myReference, (PsiElement)(expression = statement.getSwitchExpression()))) {
            JSType jSType = this.narrowTypeBySwitchOnDiscriminant(type, statement, start, end);
            if (jSType == null) {
                JSTypeGuardChecker.$$$reportNull$$$0(53);
            }
            return jSType;
        }
        if (expression instanceof JSReferenceExpression && this.isMatchingReferenceDiscriminant(this.myDeclaredType, (PsiElement)expression)) {
            JSType jSType = this.narrowTypeByDiscriminant(type, (JSReferenceExpression)expression, (Function<JSType, JSType>)((Function)t -> {
                if (statement == null) {
                    JSTypeGuardChecker.$$$reportNull$$$0(119);
                }
                return this.narrowTypeBySwitchOnDiscriminant((JSType)t, statement, start, end);
            }));
            if (jSType == null) {
                JSTypeGuardChecker.$$$reportNull$$$0(54);
            }
            return jSType;
        }
        JSType jSType = type;
        if (jSType == null) {
            JSTypeGuardChecker.$$$reportNull$$$0(55);
        }
        return jSType;
    }

    @NotNull
    private JSType narrowTypeBySwitchOnDiscriminant(@NotNull JSType originalType, @NotNull JSSwitchStatement statement, int clauseStart, int clauseEnd) {
        if (originalType == null) {
            JSTypeGuardChecker.$$$reportNull$$$0(56);
        }
        if (statement == null) {
            JSTypeGuardChecker.$$$reportNull$$$0(57);
        }
        assert (clauseStart <= clauseEnd);
        JSCaseClause[] clauses = statement.getCaseClauses();
        if (clauses.length == 0 || clauses.length < clauseEnd) {
            JSType jSType = originalType;
            if (jSType == null) {
                JSTypeGuardChecker.$$$reportNull$$$0(58);
            }
            return jSType;
        }
        JSType type = TypeScriptTypeRelations.getAsUnionTypeIfEnumWithLiterals(originalType);
        boolean hasDefaultClause = JSTypeGuardChecker.hasDefaultSwitchBranch(clauses, clauseStart, clauseEnd);
        List switchTypes = Arrays.stream(clauses).map(el -> el.isDefault() ? new TypeScriptNeverJSTypeImpl(this.mySource) : JSTypeGuardChecker.getExpressionTypeForTypeGuard(el.getCaseExpression())).map(el -> JSTypeGuardChecker.getExactType(el)).filter(el -> JSTypeGuardChecker.isUnitType(el) || el instanceof TypeScriptNeverJSTypeImpl).collect(Collectors.toList());
        if (switchTypes.size() != clauses.length) {
            JSType jSType = originalType;
            if (jSType == null) {
                JSTypeGuardChecker.$$$reportNull$$$0(59);
            }
            return jSType;
        }
        List<JSType> clauseTypes = switchTypes.subList(clauseStart, clauseEnd + 1);
        JSType discriminantType = TypeScriptTypeRelations.getUnionType(clauseTypes, this.mySource);
        JSType caseType = this.getEffectiveCaseType(type, discriminantType);
        if (!hasDefaultClause) {
            JSType jSType = caseType;
            if (jSType == null) {
                JSTypeGuardChecker.$$$reportNull$$$0(60);
            }
            return jSType;
        }
        JSType defaultType = TypeScriptTypeRelations.filterType(type, (Predicate<JSType>)((Predicate)t -> !JSTypeGuardChecker.isUnitType(t) || !this.containsType(switchTypes, (JSType)t)), (PsiElement)this.myReference);
        JSType jSType = caseType instanceof TypeScriptNeverJSTypeImpl ? defaultType : this.getUnionType(caseType, defaultType);
        if (jSType == null) {
            JSTypeGuardChecker.$$$reportNull$$$0(61);
        }
        return jSType;
    }

    @NotNull
    private JSType getEffectiveCaseType(@NotNull JSType type, @NotNull JSType discriminantType) {
        JSType typeToProcess;
        if (type == null) {
            JSTypeGuardChecker.$$$reportNull$$$0(62);
        }
        if (discriminantType == null) {
            JSTypeGuardChecker.$$$reportNull$$$0(63);
        }
        if (discriminantType instanceof TypeScriptNeverJSTypeImpl) {
            JSType jSType = discriminantType;
            if (jSType == null) {
                JSTypeGuardChecker.$$$reportNull$$$0(64);
            }
            return jSType;
        }
        if (discriminantType instanceof JSUnionType) {
            List<JSType> newTypes = ((JSUnionType)discriminantType).getTypes().stream().map(el -> TypeScriptTypeRelations.getRegularTypeOfLiteralType(el)).collect(Collectors.toList());
            typeToProcess = TypeScriptTypeRelations.getUnionType(newTypes, discriminantType.getSource());
        } else {
            typeToProcess = discriminantType;
        }
        JSType rawType = TypeScriptTypeRelations.filterType(type, (Predicate<JSType>)((Predicate)t -> TypeScriptTypeRelations.areTypesComparable(typeToProcess, t, this.myProcessingContext)), (PsiElement)this.myReference);
        JSType jSType = this.replacePrimitivesWithLiterals(rawType, discriminantType);
        if (jSType == null) {
            JSTypeGuardChecker.$$$reportNull$$$0(65);
        }
        return jSType;
    }

    private static boolean hasDefaultSwitchBranch(@NotNull JSCaseClause[] clauses, int clauseStart, int clauseEnd) {
        if (clauses == null) {
            JSTypeGuardChecker.$$$reportNull$$$0(66);
        }
        for (int i = clauseStart; i < clauseEnd + 1; ++i) {
            if (!clauses[i].isDefault()) continue;
            return true;
        }
        return false;
    }

    private boolean containsType(@NotNull List<JSType> types, @Nullable JSType type) {
        if (types == null) {
            JSTypeGuardChecker.$$$reportNull$$$0(67);
        }
        for (JSType clauseType : types) {
            if (!clauseType.isEquivalentTo(type, this.myProcessingContext)) continue;
            return true;
        }
        return false;
    }

    @Contract(value="!null,_->!null")
    private JSType replacePrimitivesWithLiterals(@Nullable JSType typeWithPrimitives, @Nullable JSType typeWithLiterals) {
        if (typeWithPrimitives == null || typeWithLiterals == null) {
            return typeWithPrimitives;
        }
        if (!JSTypeUtils.hasTypes(typeWithLiterals, JSNumberLiteralTypeImpl.class, JSStringLiteralTypeImpl.class)) {
            return typeWithPrimitives;
        }
        typeWithLiterals = JSTypeGuardChecker.getExactType(typeWithLiterals);
        typeWithPrimitives = JSTypeGuardChecker.getExactType(typeWithPrimitives);
        JSType numberLiterals = TypeScriptTypeRelations.filterType(typeWithLiterals, (Predicate<JSType>)((Predicate)t -> t instanceof JSNumberType), (PsiElement)this.myReference);
        JSType stringLiterals = TypeScriptTypeRelations.filterType(typeWithLiterals, (Predicate<JSType>)((Predicate)t -> t instanceof JSStringType), (PsiElement)this.myReference);
        if (numberLiterals instanceof TypeScriptNeverJSTypeImpl && stringLiterals instanceof TypeScriptNeverJSTypeImpl) {
            return typeWithPrimitives;
        }
        return typeWithPrimitives.transformTypeHierarchy(toProcess -> {
            if ((toProcess instanceof JSStringType || toProcess instanceof JSNumberType) && !(toProcess instanceof JSLiteralType)) {
                return toProcess instanceof JSNumberType ? numberLiterals : stringLiterals;
            }
            return toProcess;
        });
    }

    private JSType narrowTypeByTypePredicate(@NotNull JSType rawType, JSExpression expr, boolean assumeTrue) {
        if (rawType == null) {
            JSTypeGuardChecker.$$$reportNull$$$0(68);
        }
        if (!this.myIsTypeScript) {
            return rawType;
        }
        JSType expressionTypeRaw = JSTypeGuardChecker.getExpressionTypeForTypeGuard(expr);
        JSType expressionJSType = JSTypeGuardChecker.getExactType(expressionTypeRaw);
        if (!(expressionJSType instanceof TypeScriptTypePredicateTypeImpl)) {
            return rawType;
        }
        TypeScriptTypePredicateTypeImpl typePredicate = (TypeScriptTypePredicateTypeImpl)expressionJSType;
        JSType guardType = typePredicate.getGuardType();
        if (guardType == null) {
            return rawType;
        }
        guardType = JSTypeGuardChecker.getExactType(guardType);
        JSType type = JSTypeGuardChecker.getExactType(rawType);
        if (JSTypeGuardChecker.isSourceTypeAnyAndTargetTypeFunctionOrObject(type, guardType)) {
            return type;
        }
        JSExpression argument = JSTypeGuardChecker.getExpressionUnderGuard(typePredicate, expr);
        if (!(argument instanceof JSReferenceExpression)) {
            return rawType;
        }
        if (!JSTypeGuardChecker.isMatchingReference((PsiElement)this.myReference, (PsiElement)argument)) {
            return rawType;
        }
        if (type instanceof JSAnyType) {
            return rawType;
        }
        JSType narrowedType = this.getNarrowedType(type, guardType, assumeTrue, (el1, el2) -> TypeScriptTypeRelations.isTypeSubtypeOf(el1, el2, this.mySubtypingProcessingContext));
        return JSTypeGuardChecker.processNeverType(type, narrowedType);
    }

    private static boolean isSourceTypeAnyAndTargetTypeFunctionOrObject(@Nullable JSType type, @Nullable JSType guardType) {
        return type instanceof JSAnyType && (guardType instanceof JSPrimitiveFunctionType || guardType instanceof JSObjectType);
    }

    private static JSExpression getExpressionUnderGuard(@NotNull TypeScriptTypePredicateTypeImpl typePredicate, JSExpression expr) {
        if (typePredicate == null) {
            JSTypeGuardChecker.$$$reportNull$$$0(69);
        }
        if (typePredicate.isThisParameter()) {
            JSExpression qualifier;
            JSExpression jSExpression = qualifier = expr instanceof JSCallExpression ? ((JSCallExpression)expr).getMethodExpression() : expr;
            if (qualifier instanceof JSReferenceExpression) {
                return ((JSReferenceExpression)qualifier).getQualifier();
            }
            return null;
        }
        if (!(expr instanceof JSCallExpression)) {
            return null;
        }
        JSCallExpression callExpression = (JSCallExpression)expr;
        int index = typePredicate.getParameterIndex();
        if (index < 0) {
            return null;
        }
        JSExpression[] arguments = callExpression.getArguments();
        if (arguments.length <= index) {
            return null;
        }
        return arguments[index];
    }

    @NotNull
    protected JSType narrowType(@NotNull JSType type, @Nullable JSExpression expression, boolean assumeTrue) {
        if (type == null) {
            JSTypeGuardChecker.$$$reportNull$$$0(70);
        }
        if ((expression instanceof JSSuperExpression || expression instanceof JSThisExpression || expression instanceof JSReferenceExpression) && this.myIsTypeScript) {
            JSType jSType = this.narrowTypeByTruthiness(type, expression, assumeTrue);
            if (jSType == null) {
                JSTypeGuardChecker.$$$reportNull$$$0(71);
            }
            return jSType;
        }
        if (expression instanceof JSCallExpression) {
            JSType jSType = this.narrowTypeByTypePredicate(type, expression, assumeTrue);
            if (jSType == null) {
                JSTypeGuardChecker.$$$reportNull$$$0(72);
            }
            return jSType;
        }
        if (expression instanceof JSParenthesizedExpression) {
            JSType jSType = this.narrowType(type, ((JSParenthesizedExpression)expression).getInnerExpression(), assumeTrue);
            if (jSType == null) {
                JSTypeGuardChecker.$$$reportNull$$$0(73);
            }
            return jSType;
        }
        if (expression instanceof JSBinaryExpression) {
            JSType jSType = this.narrowTypeByBinaryExpression(type, (JSBinaryExpression)expression, assumeTrue);
            if (jSType == null) {
                JSTypeGuardChecker.$$$reportNull$$$0(74);
            }
            return jSType;
        }
        if (expression instanceof JSPrefixExpression && ((JSPrefixExpression)expression).getOperationSign() == JSTokenTypes.EXCL) {
            JSType jSType = this.narrowType(type, ((JSPrefixExpression)expression).getExpression(), !assumeTrue);
            if (jSType == null) {
                JSTypeGuardChecker.$$$reportNull$$$0(75);
            }
            return jSType;
        }
        JSType jSType = type;
        if (jSType == null) {
            JSTypeGuardChecker.$$$reportNull$$$0(76);
        }
        return jSType;
    }

    @NotNull
    private JSType narrowTypeByTruthiness(@NotNull JSType type, @Nullable JSExpression expression, boolean assumeTrue) {
        if (type == null) {
            JSTypeGuardChecker.$$$reportNull$$$0(77);
        }
        if (JSTypeGuardChecker.isMatchingReference((PsiElement)this.myReference, (PsiElement)expression)) {
            JSType jSType = JSTypeGuardChecker.processNeverType(type, JSTypeFacts.TYPE_FACTS.getTypeWithFact(type, assumeTrue ? JSTypeFacts.SimpleFact.Truthy : JSTypeFacts.SimpleFact.Falsy, (PsiElement)this.myReference, this.strictNullChecks()));
            if (jSType == null) {
                JSTypeGuardChecker.$$$reportNull$$$0(78);
            }
            return jSType;
        }
        if (this.isMatchingReferenceDiscriminant(this.myDeclaredType, (PsiElement)expression) && expression instanceof JSReferenceExpression) {
            JSType jSType = this.narrowTypeByDiscriminant(type, (JSReferenceExpression)expression, (Function<JSType, JSType>)((Function)el -> JSTypeFacts.TYPE_FACTS.getTypeWithFact((JSType)el, assumeTrue ? JSTypeFacts.SimpleFact.Truthy : JSTypeFacts.SimpleFact.Falsy, (PsiElement)this.myReference, this.strictNullChecks())));
            if (jSType == null) {
                JSTypeGuardChecker.$$$reportNull$$$0(79);
            }
            return jSType;
        }
        if (JSTypeGuardChecker.containsMatchingReferenceDiscriminant((PsiElement)this.myReference, (PsiElement)expression)) {
            JSType jSType = this.myDeclaredType;
            if (jSType == null) {
                JSTypeGuardChecker.$$$reportNull$$$0(80);
            }
            return jSType;
        }
        JSType jSType = type;
        if (jSType == null) {
            JSTypeGuardChecker.$$$reportNull$$$0(81);
        }
        return jSType;
    }

    private static boolean containsMatchingReferenceDiscriminant(@Nullable PsiElement source, @Nullable PsiElement target) {
        if (source == null || target == null) {
            return false;
        }
        if (!(target instanceof JSReferenceExpression)) {
            return false;
        }
        JSReferenceExpression targetRefExpression = (JSReferenceExpression)target;
        String name = targetRefExpression.getReferenceName();
        if (StringUtil.isEmpty((String)name)) {
            return false;
        }
        JSExpression targetQualifier = targetRefExpression.getQualifier();
        if (!JSTypeGuardChecker.containsMatchingReference(source, (PsiElement)targetQualifier)) {
            return false;
        }
        JSType type = JSTypeGuardChecker.getExpressionTypeForTypeGuard(targetQualifier);
        return JSTypeGuardChecker.isDiscriminantProperty(type, name);
    }

    @Contract(value="_,null -> false")
    protected static boolean containsMatchingReference(@Nullable PsiElement source, @Nullable PsiElement target) {
        while (JSTypeGuardChecker.isPropertyAccessExpression(source)) {
            if (!JSTypeGuardChecker.isMatchingReference(source = ((JSReferenceExpression)source).getQualifier(), target)) continue;
            return true;
        }
        return false;
    }

    @NotNull
    private JSType narrowTypeByDiscriminant(@NotNull JSType type, @NotNull JSReferenceExpression expression, @NotNull Function<JSType, JSType> convertType) {
        JSType narrowedPropType;
        String name;
        if (type == null) {
            JSTypeGuardChecker.$$$reportNull$$$0(82);
        }
        if (expression == null) {
            JSTypeGuardChecker.$$$reportNull$$$0(83);
        }
        if (convertType == null) {
            JSTypeGuardChecker.$$$reportNull$$$0(84);
        }
        if ((name = expression.getReferenceName()) == null) {
            JSType jSType = type;
            if (jSType == null) {
                JSTypeGuardChecker.$$$reportNull$$$0(85);
            }
            return jSType;
        }
        JSType propType = JSTypeGuardChecker.getTypeOfPropertyOfType(type, name);
        JSType jSType = narrowedPropType = propType == null ? null : (JSType)convertType.fun((Object)propType);
        if (narrowedPropType == null) {
            JSType jSType2 = type;
            if (jSType2 == null) {
                JSTypeGuardChecker.$$$reportNull$$$0(86);
            }
            return jSType2;
        }
        JSType result2 = propType == narrowedPropType ? type : TypeScriptTypeRelations.filterType(type, (Predicate<JSType>)((Predicate)el -> TypeScriptTypeRelations.isTypeComparableTo(JSTypeGuardChecker.getTypeOfPropertyOfType(el, name), narrowedPropType, this.myProcessingContext)), (PsiElement)this.myReference);
        JSType jSType3 = JSTypeGuardChecker.processNeverType(type, result2);
        if (jSType3 == null) {
            JSTypeGuardChecker.$$$reportNull$$$0(87);
        }
        return jSType3;
    }

    @Nullable
    private static JSType getTypeOfPropertyOfType(@Nullable JSType type, @NotNull String propertyName) {
        if (propertyName == null) {
            JSTypeGuardChecker.$$$reportNull$$$0(88);
        }
        if (type == null) {
            return null;
        }
        JSRecordType recordType = type.asRecordType();
        JSRecordType.PropertySignature signature = recordType.findPropertySignature(propertyName);
        return signature == null ? null : signature.getType();
    }

    protected static boolean isMatchingReference(@Nullable PsiElement source, @Nullable PsiElement target) {
        if (target == null || source == null) {
            return false;
        }
        if (source instanceof JSReferenceExpression && target instanceof JSReferenceExpression) {
            String sourceName;
            String targetName = ((JSReferenceExpression)target).getReferenceName();
            if (!StringUtil.equals((CharSequence)targetName, (CharSequence)(sourceName = ((JSReferenceExpression)source).getReferenceName()))) {
                return false;
            }
            JSExpression targetQualifier = ((JSReferenceExpression)target).getQualifier();
            JSExpression sourceQualifier = ((JSReferenceExpression)source).getQualifier();
            if (targetQualifier == null) {
                return sourceQualifier == null;
            }
            return JSTypeGuardChecker.isMatchingReference((PsiElement)targetQualifier, (PsiElement)sourceQualifier);
        }
        if (source instanceof JSVariable && target instanceof JSReferenceExpression) {
            return JSTypeGuardChecker.isMatchingReferenceForVariable((JSFieldVariable)source, (JSReferenceExpression)target);
        }
        if (source instanceof JSReferenceExpression && target instanceof JSVariable) {
            return JSTypeGuardChecker.isMatchingReferenceForVariable((JSFieldVariable)target, (JSReferenceExpression)source);
        }
        if (source instanceof JSThisExpression && target instanceof JSThisExpression) {
            return true;
        }
        return source instanceof JSSuperExpression && target instanceof JSSuperExpression;
    }

    private static boolean isMatchingReferenceForVariable(@NotNull JSFieldVariable variable, @NotNull JSReferenceExpression expression) {
        JSExpression qualifier;
        if (variable == null) {
            JSTypeGuardChecker.$$$reportNull$$$0(89);
        }
        if (expression == null) {
            JSTypeGuardChecker.$$$reportNull$$$0(90);
        }
        if ((qualifier = expression.getQualifier()) != null) {
            return false;
        }
        String name = expression.getReferenceName();
        String varName = variable.getName();
        return StringUtil.equals((CharSequence)name, (CharSequence)varName);
    }

    private static boolean isPropertyAccessExpression(@Nullable PsiElement element) {
        return element instanceof JSReferenceExpression && ((JSReferenceExpression)element).getQualifier() != null;
    }

    @NotNull
    protected JSType narrowTypeByBinaryExpression(@NotNull JSType type, @NotNull JSBinaryExpression expression, boolean assumeTrue) {
        IElementType sign;
        if (type == null) {
            JSTypeGuardChecker.$$$reportNull$$$0(91);
        }
        if (expression == null) {
            JSTypeGuardChecker.$$$reportNull$$$0(92);
        }
        if ((sign = expression.getOperationSign()) == null) {
            JSType jSType = type;
            if (jSType == null) {
                JSTypeGuardChecker.$$$reportNull$$$0(93);
            }
            return jSType;
        }
        if (sign == JSTokenTypes.ANDAND) {
            JSType jSType = this.narrowTypeByAnd(type, expression, assumeTrue);
            if (jSType == null) {
                JSTypeGuardChecker.$$$reportNull$$$0(94);
            }
            return jSType;
        }
        if (sign == JSTokenTypes.OROR) {
            JSType jSType = this.narrowTypeByOr(type, expression, assumeTrue);
            if (jSType == null) {
                JSTypeGuardChecker.$$$reportNull$$$0(95);
            }
            return jSType;
        }
        if (sign == JSTokenTypes.EQ) {
            JSType jSType = this.narrowTypeByTruthiness(type, expression.getLOperand(), assumeTrue);
            if (jSType == null) {
                JSTypeGuardChecker.$$$reportNull$$$0(96);
            }
            return jSType;
        }
        if (sign == JSTokenTypes.INSTANCEOF_KEYWORD) {
            JSType jSType = this.narrowTypeByInstanceof(type, expression, assumeTrue);
            if (jSType == null) {
                JSTypeGuardChecker.$$$reportNull$$$0(97);
            }
            return jSType;
        }
        if (sign == JSTokenTypes.COMMA) {
            JSType jSType = this.narrowType(type, expression.getROperand(), assumeTrue);
            if (jSType == null) {
                JSTypeGuardChecker.$$$reportNull$$$0(98);
            }
            return jSType;
        }
        if (sign == JSTokenTypes.EQEQ || sign == JSTokenTypes.NE || sign == JSTokenTypes.NEQEQ || sign == JSTokenTypes.EQEQEQ) {
            JSExpression left = JSTypeGuardChecker.getReferenceCandidate(expression.getLOperand());
            JSExpression right = JSTypeGuardChecker.getReferenceCandidate(expression.getROperand());
            if (left == null || right == null) {
                JSType jSType = type;
                if (jSType == null) {
                    JSTypeGuardChecker.$$$reportNull$$$0(99);
                }
                return jSType;
            }
            JSPrefixExpression leftTypeOf = JSTypeGuardChecker.getTypeOfPrefixExpression(left);
            if (leftTypeOf != null && JSTypeGuardChecker.isStringLiteralExpression(right)) {
                JSType jSType = this.narrowTypeByTypeof(type, leftTypeOf, sign, (JSLiteralExpression)right, assumeTrue);
                if (jSType == null) {
                    JSTypeGuardChecker.$$$reportNull$$$0(100);
                }
                return jSType;
            }
            JSPrefixExpression rightTypeOf = JSTypeGuardChecker.getTypeOfPrefixExpression(right);
            if (rightTypeOf != null && JSTypeGuardChecker.isStringLiteralExpression(left)) {
                JSType jSType = this.narrowTypeByTypeof(type, rightTypeOf, sign, (JSLiteralExpression)left, assumeTrue);
                if (jSType == null) {
                    JSTypeGuardChecker.$$$reportNull$$$0(101);
                }
                return jSType;
            }
            if (JSTypeGuardChecker.isMatchingReference((PsiElement)this.myReference, (PsiElement)left)) {
                JSType jSType = this.narrowTypeByEquality(type, sign, right, assumeTrue);
                if (jSType == null) {
                    JSTypeGuardChecker.$$$reportNull$$$0(102);
                }
                return jSType;
            }
            if (JSTypeGuardChecker.isMatchingReference((PsiElement)this.myReference, (PsiElement)right)) {
                JSType jSType = this.narrowTypeByEquality(type, sign, left, assumeTrue);
                if (jSType == null) {
                    JSTypeGuardChecker.$$$reportNull$$$0(103);
                }
                return jSType;
            }
            if (left instanceof JSReferenceExpression && this.isMatchingReferenceDiscriminant(this.myDeclaredType, (PsiElement)left)) {
                JSType jSType = this.narrowTypeByDiscriminant(type, (JSReferenceExpression)left, (Function<JSType, JSType>)((Function)el -> this.narrowTypeByEquality((JSType)el, sign, right, assumeTrue)));
                if (jSType == null) {
                    JSTypeGuardChecker.$$$reportNull$$$0(104);
                }
                return jSType;
            }
            if (right instanceof JSReferenceExpression && this.isMatchingReferenceDiscriminant(this.myDeclaredType, (PsiElement)right)) {
                JSType jSType = this.narrowTypeByDiscriminant(type, (JSReferenceExpression)right, (Function<JSType, JSType>)((Function)el -> this.narrowTypeByEquality((JSType)el, sign, left, assumeTrue)));
                if (jSType == null) {
                    JSTypeGuardChecker.$$$reportNull$$$0(105);
                }
                return jSType;
            }
            if (JSTypeGuardChecker.containsMatchingReferenceDiscriminant((PsiElement)this.myReference, (PsiElement)left) || JSTypeGuardChecker.containsMatchingReferenceDiscriminant((PsiElement)this.myReference, (PsiElement)right)) {
                JSType jSType = this.myDeclaredType;
                if (jSType == null) {
                    JSTypeGuardChecker.$$$reportNull$$$0(106);
                }
                return jSType;
            }
        }
        JSType jSType = type;
        if (jSType == null) {
            JSTypeGuardChecker.$$$reportNull$$$0(107);
        }
        return jSType;
    }

    @NotNull
    private JSType narrowTypeByTypeof(@NotNull JSType type, @NotNull JSPrefixExpression typeOfExpr, @NotNull IElementType sign, @NotNull JSLiteralExpression literal, boolean assumeTrue) {
        JSType primitiveType;
        JSExpression target;
        if (type == null) {
            JSTypeGuardChecker.$$$reportNull$$$0(108);
        }
        if (typeOfExpr == null) {
            JSTypeGuardChecker.$$$reportNull$$$0(109);
        }
        if (sign == null) {
            JSTypeGuardChecker.$$$reportNull$$$0(110);
        }
        if (literal == null) {
            JSTypeGuardChecker.$$$reportNull$$$0(111);
        }
        if (!JSTypeGuardChecker.isMatchingReference((PsiElement)this.myReference, (PsiElement)(target = JSTypeGuardChecker.getReferenceCandidate(typeOfExpr.getExpression())))) {
            JSType jSType = type;
            if (jSType == null) {
                JSTypeGuardChecker.$$$reportNull$$$0(112);
            }
            return jSType;
        }
        if (JSTypeGuardChecker.isNegativeSign(sign)) {
            assumeTrue = !assumeTrue;
        }
        type = JSTypeGuardChecker.getExactType(type);
        String value = literal.getStringValue();
        if (StringUtil.isEmpty((String)value)) {
            JSType jSType = type;
            if (jSType == null) {
                JSTypeGuardChecker.$$$reportNull$$$0(113);
            }
            return jSType;
        }
        if (assumeTrue && !(type instanceof JSUnionType) && JSTypeGuardChecker.isPrimitiveType(value) && TypeScriptTypeRelations.isTypeSubtypeOf(primitiveType = this.buildNamedType(value), type, this.mySubtypingProcessingContext)) {
            JSType jSType = primitiveType;
            if (jSType == null) {
                JSTypeGuardChecker.$$$reportNull$$$0(114);
            }
            return jSType;
        }
        JSTypeFacts.SimpleFact fact = JSTypeFacts.getFactsForPrimitiveType(value, assumeTrue);
        JSType jSType = JSTypeFacts.TYPE_FACTS.getTypeWithFact(type, fact, (PsiElement)this.myReference, this.strictNullChecks());
        if (jSType == null) {
            JSTypeGuardChecker.$$$reportNull$$$0(115);
        }
        return jSType;
    }

    public static boolean isStringLiteralExpression(@Nullable JSExpression right) {
        return right instanceof JSLiteralExpression && ((JSLiteralExpression)right).isQuotedLiteral();
    }

    @Nullable
    public static JSExpression getReferenceCandidate(@Nullable JSExpression expression) {
        if (expression instanceof JSParenthesizedExpression) {
            return JSTypeGuardChecker.getReferenceCandidate(((JSParenthesizedExpression)expression).getInnerExpression());
        }
        if (expression instanceof JSBinaryExpression) {
            IElementType sign = ((JSBinaryExpression)expression).getOperationSign();
            if (sign == JSTokenTypes.EQ) {
                return JSTypeGuardChecker.getReferenceCandidate(((JSBinaryExpression)expression).getLOperand());
            }
            if (sign == JSTokenTypes.COMMA) {
                return JSTypeGuardChecker.getReferenceCandidate(((JSBinaryExpression)expression).getROperand());
            }
        }
        return expression;
    }

    @Contract(value="!null,!null->!null")
    protected JSType getUnionType(@Nullable JSType type1, @Nullable JSType type2) {
        if (type1 == null || type1 instanceof TypeScriptNeverJSTypeImpl) {
            return type2;
        }
        if (type2 == null || type2 instanceof TypeScriptNeverJSTypeImpl) {
            return type1;
        }
        return JSCompositeTypeImpl.getCommonType(type1, type2, this.mySource, true);
    }

    private static boolean isPrimitiveType(@NotNull String name) {
        if (name == null) {
            JSTypeGuardChecker.$$$reportNull$$$0(116);
        }
        return ArrayUtil.contains((String)name, (String[])JSCommonTypeNames.TYPEOF_VALUES);
    }

    @NotNull
    private JSType buildNamedType(@NotNull String name) {
        if (name == null) {
            JSTypeGuardChecker.$$$reportNull$$$0(117);
        }
        JSType jSType = JSNamedType.createType(name, this.mySource, JSContext.INSTANCE);
        if (jSType == null) {
            JSTypeGuardChecker.$$$reportNull$$$0(118);
        }
        return jSType;
    }

    @Contract(value="!null -> !null")
    public static JSType getExactType(@Nullable JSType type) {
        return JSTypeGuardChecker.getExactType(type, null);
    }

    @Contract(value="!null,_ -> !null")
    protected static JSType getExactType(@Nullable JSType type, @Nullable Collection<String> visited) {
        if (null == type) {
            return null;
        }
        JSPrimitiveLiteralType<String> valuableType = JSCompositeTypeImpl.optimizeTypeIfComposite(TypeScriptTypeRelations.expandTypeRecursive(type));
        if (valuableType instanceof JSExoticStringLiteralType) {
            valuableType = ((JSExoticStringLiteralType)((Object)valuableType)).asSimpleLiteralType();
        }
        if (valuableType instanceof JSUnionType) {
            if (visited == null) {
                visited = ContainerUtil.newHashSet();
            }
            if (!visited.add(type.getTypeId())) {
                return valuableType;
            }
            List<JSType> oldTypes = ((JSUnionType)((Object)valuableType)).getTypes();
            HashSet finalVisited = visited;
            boolean isTypeScript = valuableType.getSource().isTypeScript();
            List<JSType> types = oldTypes.stream().map(el -> {
                if (!isTypeScript) {
                    return el;
                }
                JSType exactSubType = JSTypeGuardChecker.getExactType(el, finalVisited);
                if (exactSubType instanceof JSUnionType) {
                    return exactSubType;
                }
                return el;
            }).collect(Collectors.toList());
            if (ContainerUtil.equalsIdentity(oldTypes, types)) {
                return valuableType;
            }
            return TypeScriptTypeRelations.getUnionType(types, valuableType.getSource());
        }
        return valuableType;
    }

    protected boolean strictNullChecks() {
        return false;
    }

    @Nullable
    protected static JSType getExpressionTypeForTypeGuard(@Nullable JSExpression expression) {
        if (expression == null) {
            return null;
        }
        return JSTypeEvaluator.getExpressionTypeWithGuard(expression, JSEvaluateContext.JSEvaluationPlace.TYPE_GUARD);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 3: 
            case 4: 
            case 7: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 29: 
            case 30: 
            case 34: 
            case 35: 
            case 36: 
            case 37: 
            case 38: 
            case 39: 
            case 40: 
            case 41: 
            case 45: 
            case 46: 
            case 47: 
            case 48: 
            case 49: 
            case 50: 
            case 53: 
            case 54: 
            case 55: 
            case 58: 
            case 59: 
            case 60: 
            case 61: 
            case 64: 
            case 65: 
            case 71: 
            case 72: 
            case 73: 
            case 74: 
            case 75: 
            case 76: 
            case 78: 
            case 79: 
            case 80: 
            case 81: 
            case 85: 
            case 86: 
            case 87: 
            case 93: 
            case 94: 
            case 95: 
            case 96: 
            case 97: 
            case 98: 
            case 99: 
            case 100: 
            case 101: 
            case 102: 
            case 103: 
            case 104: 
            case 105: 
            case 106: 
            case 107: 
            case 112: 
            case 113: 
            case 114: 
            case 115: 
            case 118: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 3: 
            case 4: 
            case 7: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 29: 
            case 30: 
            case 34: 
            case 35: 
            case 36: 
            case 37: 
            case 38: 
            case 39: 
            case 40: 
            case 41: 
            case 45: 
            case 46: 
            case 47: 
            case 48: 
            case 49: 
            case 50: 
            case 53: 
            case 54: 
            case 55: 
            case 58: 
            case 59: 
            case 60: 
            case 61: 
            case 64: 
            case 65: 
            case 71: 
            case 72: 
            case 73: 
            case 74: 
            case 75: 
            case 76: 
            case 78: 
            case 79: 
            case 80: 
            case 81: 
            case 85: 
            case 86: 
            case 87: 
            case 93: 
            case 94: 
            case 95: 
            case 96: 
            case 97: 
            case 98: 
            case 99: 
            case 100: 
            case 101: 
            case 102: 
            case 103: 
            case 104: 
            case 105: 
            case 106: 
            case 107: 
            case 112: 
            case 113: 
            case 114: 
            case 115: 
            case 118: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "place";
                break;
            }
            case 1: 
            case 43: 
            case 121: 
            case 123: {
                objectArray2 = objectArray3;
                objectArray3[0] = "candidate";
                break;
            }
            case 2: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "reference";
                break;
            }
            case 3: 
            case 4: 
            case 7: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 29: 
            case 30: 
            case 34: 
            case 35: 
            case 36: 
            case 37: 
            case 38: 
            case 39: 
            case 40: 
            case 41: 
            case 45: 
            case 46: 
            case 47: 
            case 48: 
            case 49: 
            case 50: 
            case 53: 
            case 54: 
            case 55: 
            case 58: 
            case 59: 
            case 60: 
            case 61: 
            case 64: 
            case 65: 
            case 71: 
            case 72: 
            case 73: 
            case 74: 
            case 75: 
            case 76: 
            case 78: 
            case 79: 
            case 80: 
            case 81: 
            case 85: 
            case 86: 
            case 87: 
            case 93: 
            case 94: 
            case 95: 
            case 96: 
            case 97: 
            case 98: 
            case 99: 
            case 100: 
            case 101: 
            case 102: 
            case 103: 
            case 104: 
            case 105: 
            case 106: 
            case 107: 
            case 112: 
            case 113: 
            case 114: 
            case 115: 
            case 118: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/javascript/psi/types/guard/JSTypeGuardChecker";
                break;
            }
            case 6: 
            case 10: 
            case 83: 
            case 90: 
            case 92: {
                objectArray2 = objectArray3;
                objectArray3[0] = "expression";
                break;
            }
            case 8: 
            case 18: 
            case 31: 
            case 32: 
            case 42: 
            case 51: 
            case 62: 
            case 70: 
            case 77: 
            case 82: 
            case 91: 
            case 108: {
                objectArray2 = objectArray3;
                objectArray3[0] = "type";
                break;
            }
            case 9: 
            case 20: 
            case 110: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sign";
                break;
            }
            case 19: 
            case 88: {
                objectArray2 = objectArray3;
                objectArray3[0] = "propertyName";
                break;
            }
            case 21: 
            case 27: 
            case 68: {
                objectArray2 = objectArray3;
                objectArray3[0] = "rawType";
                break;
            }
            case 22: 
            case 28: 
            case 33: {
                objectArray2 = objectArray3;
                objectArray3[0] = "expr";
                break;
            }
            case 44: 
            case 120: 
            case 122: {
                objectArray2 = objectArray3;
                objectArray3[0] = "relation";
                break;
            }
            case 52: 
            case 57: 
            case 119: {
                objectArray2 = objectArray3;
                objectArray3[0] = "statement";
                break;
            }
            case 56: {
                objectArray2 = objectArray3;
                objectArray3[0] = "originalType";
                break;
            }
            case 63: {
                objectArray2 = objectArray3;
                objectArray3[0] = "discriminantType";
                break;
            }
            case 66: {
                objectArray2 = objectArray3;
                objectArray3[0] = "clauses";
                break;
            }
            case 67: {
                objectArray2 = objectArray3;
                objectArray3[0] = "types";
                break;
            }
            case 69: {
                objectArray2 = objectArray3;
                objectArray3[0] = "typePredicate";
                break;
            }
            case 84: {
                objectArray2 = objectArray3;
                objectArray3[0] = "convertType";
                break;
            }
            case 89: {
                objectArray2 = objectArray3;
                objectArray3[0] = "variable";
                break;
            }
            case 109: {
                objectArray2 = objectArray3;
                objectArray3[0] = "typeOfExpr";
                break;
            }
            case 111: {
                objectArray2 = objectArray3;
                objectArray3[0] = "literal";
                break;
            }
            case 116: 
            case 117: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/javascript/psi/types/guard/JSTypeGuardChecker";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "createGuard";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getFirstQualifierName";
                break;
            }
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: {
                objectArray = objectArray2;
                objectArray2[1] = "narrowTypeByEquality";
                break;
            }
            case 23: 
            case 24: 
            case 25: 
            case 26: {
                objectArray = objectArray2;
                objectArray2[1] = "narrowTypeByAnd";
                break;
            }
            case 29: 
            case 30: {
                objectArray = objectArray2;
                objectArray2[1] = "narrowTypeByOr";
                break;
            }
            case 34: 
            case 35: 
            case 36: 
            case 37: 
            case 38: 
            case 39: 
            case 40: 
            case 41: {
                objectArray = objectArray2;
                objectArray2[1] = "narrowTypeByInstanceof";
                break;
            }
            case 45: 
            case 46: 
            case 47: 
            case 48: 
            case 49: 
            case 50: {
                objectArray = objectArray2;
                objectArray2[1] = "getNarrowedType";
                break;
            }
            case 53: 
            case 54: 
            case 55: {
                objectArray = objectArray2;
                objectArray2[1] = "getTypeAtSwitchClause";
                break;
            }
            case 58: 
            case 59: 
            case 60: 
            case 61: {
                objectArray = objectArray2;
                objectArray2[1] = "narrowTypeBySwitchOnDiscriminant";
                break;
            }
            case 64: 
            case 65: {
                objectArray = objectArray2;
                objectArray2[1] = "getEffectiveCaseType";
                break;
            }
            case 71: 
            case 72: 
            case 73: 
            case 74: 
            case 75: 
            case 76: {
                objectArray = objectArray2;
                objectArray2[1] = "narrowType";
                break;
            }
            case 78: 
            case 79: 
            case 80: 
            case 81: {
                objectArray = objectArray2;
                objectArray2[1] = "narrowTypeByTruthiness";
                break;
            }
            case 85: 
            case 86: 
            case 87: {
                objectArray = objectArray2;
                objectArray2[1] = "narrowTypeByDiscriminant";
                break;
            }
            case 93: 
            case 94: 
            case 95: 
            case 96: 
            case 97: 
            case 98: 
            case 99: 
            case 100: 
            case 101: 
            case 102: 
            case 103: 
            case 104: 
            case 105: 
            case 106: 
            case 107: {
                objectArray = objectArray2;
                objectArray2[1] = "narrowTypeByBinaryExpression";
                break;
            }
            case 112: 
            case 113: 
            case 114: 
            case 115: {
                objectArray = objectArray2;
                objectArray2[1] = "narrowTypeByTypeof";
                break;
            }
            case 118: {
                objectArray = objectArray2;
                objectArray2[1] = "buildNamedType";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "isAvailable";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "createGuard";
                break;
            }
            case 3: 
            case 4: 
            case 7: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 29: 
            case 30: 
            case 34: 
            case 35: 
            case 36: 
            case 37: 
            case 38: 
            case 39: 
            case 40: 
            case 41: 
            case 45: 
            case 46: 
            case 47: 
            case 48: 
            case 49: 
            case 50: 
            case 53: 
            case 54: 
            case 55: 
            case 58: 
            case 59: 
            case 60: 
            case 61: 
            case 64: 
            case 65: 
            case 71: 
            case 72: 
            case 73: 
            case 74: 
            case 75: 
            case 76: 
            case 78: 
            case 79: 
            case 80: 
            case 81: 
            case 85: 
            case 86: 
            case 87: 
            case 93: 
            case 94: 
            case 95: 
            case 96: 
            case 97: 
            case 98: 
            case 99: 
            case 100: 
            case 101: 
            case 102: 
            case 103: 
            case 104: 
            case 105: 
            case 106: 
            case 107: 
            case 112: 
            case 113: 
            case 114: 
            case 115: 
            case 118: {
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "getFirstQualifierName";
                break;
            }
            case 8: 
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "narrowTypeByEquality";
                break;
            }
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "getBaseTypeOfLiteralType";
                break;
            }
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "isDiscriminantProperty";
                break;
            }
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "isNegativeSign";
                break;
            }
            case 21: 
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "narrowTypeByAnd";
                break;
            }
            case 27: 
            case 28: {
                objectArray = objectArray;
                objectArray[2] = "narrowTypeByOr";
                break;
            }
            case 31: {
                objectArray = objectArray;
                objectArray[2] = "isMatchingReferenceDiscriminant";
                break;
            }
            case 32: 
            case 33: {
                objectArray = objectArray;
                objectArray[2] = "narrowTypeByInstanceof";
                break;
            }
            case 42: 
            case 43: 
            case 44: {
                objectArray = objectArray;
                objectArray[2] = "getNarrowedType";
                break;
            }
            case 51: 
            case 52: {
                objectArray = objectArray;
                objectArray[2] = "getTypeAtSwitchClause";
                break;
            }
            case 56: 
            case 57: {
                objectArray = objectArray;
                objectArray[2] = "narrowTypeBySwitchOnDiscriminant";
                break;
            }
            case 62: 
            case 63: {
                objectArray = objectArray;
                objectArray[2] = "getEffectiveCaseType";
                break;
            }
            case 66: {
                objectArray = objectArray;
                objectArray[2] = "hasDefaultSwitchBranch";
                break;
            }
            case 67: {
                objectArray = objectArray;
                objectArray[2] = "containsType";
                break;
            }
            case 68: {
                objectArray = objectArray;
                objectArray[2] = "narrowTypeByTypePredicate";
                break;
            }
            case 69: {
                objectArray = objectArray;
                objectArray[2] = "getExpressionUnderGuard";
                break;
            }
            case 70: {
                objectArray = objectArray;
                objectArray[2] = "narrowType";
                break;
            }
            case 77: {
                objectArray = objectArray;
                objectArray[2] = "narrowTypeByTruthiness";
                break;
            }
            case 82: 
            case 83: 
            case 84: {
                objectArray = objectArray;
                objectArray[2] = "narrowTypeByDiscriminant";
                break;
            }
            case 88: {
                objectArray = objectArray;
                objectArray[2] = "getTypeOfPropertyOfType";
                break;
            }
            case 89: 
            case 90: {
                objectArray = objectArray;
                objectArray[2] = "isMatchingReferenceForVariable";
                break;
            }
            case 91: 
            case 92: {
                objectArray = objectArray;
                objectArray[2] = "narrowTypeByBinaryExpression";
                break;
            }
            case 108: 
            case 109: 
            case 110: 
            case 111: {
                objectArray = objectArray;
                objectArray[2] = "narrowTypeByTypeof";
                break;
            }
            case 116: {
                objectArray = objectArray;
                objectArray[2] = "isPrimitiveType";
                break;
            }
            case 117: {
                objectArray = objectArray;
                objectArray[2] = "buildNamedType";
                break;
            }
            case 119: {
                objectArray = objectArray;
                objectArray[2] = "lambda$getTypeAtSwitchClause$6";
                break;
            }
            case 120: 
            case 121: {
                objectArray = objectArray;
                objectArray[2] = "lambda$getNarrowedType$5";
                break;
            }
            case 122: 
            case 123: {
                objectArray = objectArray;
                objectArray[2] = "lambda$getNarrowedType$4";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 3: 
            case 4: 
            case 7: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 29: 
            case 30: 
            case 34: 
            case 35: 
            case 36: 
            case 37: 
            case 38: 
            case 39: 
            case 40: 
            case 41: 
            case 45: 
            case 46: 
            case 47: 
            case 48: 
            case 49: 
            case 50: 
            case 53: 
            case 54: 
            case 55: 
            case 58: 
            case 59: 
            case 60: 
            case 61: 
            case 64: 
            case 65: 
            case 71: 
            case 72: 
            case 73: 
            case 74: 
            case 75: 
            case 76: 
            case 78: 
            case 79: 
            case 80: 
            case 81: 
            case 85: 
            case 86: 
            case 87: 
            case 93: 
            case 94: 
            case 95: 
            case 96: 
            case 97: 
            case 98: 
            case 99: 
            case 100: 
            case 101: 
            case 102: 
            case 103: 
            case 104: 
            case 105: 
            case 106: 
            case 107: 
            case 112: 
            case 113: 
            case 114: 
            case 115: 
            case 118: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    static interface TypeRelation {
        public boolean isRelated(@Nullable JSType var1, @Nullable JSType var2);
    }
}

