/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.psi.types.guard;

import com.intellij.lang.javascript.index.JSSymbolUtil;
import com.intellij.lang.javascript.psi.JSExpression;
import com.intellij.lang.javascript.psi.JSInitializerOwner;
import com.intellij.lang.javascript.psi.JSOptionalOwner;
import com.intellij.lang.javascript.psi.JSReferenceExpression;
import com.intellij.lang.javascript.psi.JSType;
import com.intellij.lang.javascript.psi.JSVariable;
import com.intellij.lang.javascript.psi.stubs.TypeScriptProxyImplicitElement;
import com.intellij.lang.javascript.psi.types.JSCompositeTypeImpl;
import com.intellij.lang.javascript.psi.types.JSContext;
import com.intellij.lang.javascript.psi.types.JSNamedType;
import com.intellij.lang.javascript.psi.types.JSTypeSource;
import com.intellij.lang.javascript.psi.types.JSTypeSourceFactory;
import com.intellij.lang.javascript.psi.types.guard.JSControlFlowTypeGuard;
import com.intellij.lang.typescript.tsconfig.TypeScriptConfig;
import com.intellij.lang.typescript.tsconfig.TypeScriptConfigUtil;
import com.intellij.psi.PsiElement;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class TypeScriptTypeGuard
extends JSControlFlowTypeGuard {
    protected TypeScriptTypeGuard(@NotNull JSReferenceExpression reference, @Nullable JSType startType, @Nullable PsiElement resolveResult, boolean useAutoArrayType, boolean useAutoVariableType, boolean strictNullCheck) {
        if (reference == null) {
            TypeScriptTypeGuard.$$$reportNull$$$0(0);
        }
        super(reference, startType, resolveResult, useAutoArrayType, useAutoVariableType, strictNullCheck);
    }

    private static boolean isOptionalProperty(@Nullable PsiElement resolveResult) {
        if (resolveResult instanceof JSInitializerOwner && ((JSInitializerOwner)resolveResult).hasInitializer()) {
            return false;
        }
        return resolveResult instanceof JSOptionalOwner && ((JSOptionalOwner)resolveResult).isOptional() || resolveResult instanceof TypeScriptProxyImplicitElement && TypeScriptTypeGuard.isOptionalProperty(((TypeScriptProxyImplicitElement)resolveResult).getExplicitElement());
    }

    @Nullable
    private static JSType addUndefinedTypeForOptionalProperties(@Nullable JSType startType, @Nullable PsiElement resolveResult, @Nullable TypeScriptConfig config2) {
        if (config2 == null) {
            return startType;
        }
        if (TypeScriptTypeGuard.isOptionalProperty(resolveResult) && startType != null) {
            JSTypeSource source = JSTypeSourceFactory.createTypeSource(resolveResult, true);
            return new JSCompositeTypeImpl(source, startType, JSNamedType.createType("undefined", source, JSContext.UNKNOWN));
        }
        return startType;
    }

    @NotNull
    protected static TypeScriptTypeGuard createTypeScriptTypeGuard(@NotNull JSReferenceExpression reference, @Nullable JSType startType, @Nullable PsiElement resolveResult) {
        if (reference == null) {
            TypeScriptTypeGuard.$$$reportNull$$$0(1);
        }
        TypeScriptConfig config2 = TypeScriptConfigUtil.getConfigForPsiFile(reference.getContainingFile());
        boolean useAutoVariableType = false;
        boolean useAutoArrayType = false;
        if (resolveResult instanceof JSVariable && TypeScriptTypeGuard.useAutoTypes(reference, resolveResult, config2)) {
            JSVariable variable = (JSVariable)resolveResult;
            JSExpression initializer = variable.getInitializer();
            useAutoVariableType = !variable.isConst() && (initializer == null || JSSymbolUtil.isUndefinedExpression(initializer) || JSSymbolUtil.isNullLiteral(initializer));
            useAutoArrayType = !useAutoVariableType && TypeScriptTypeGuard.isEmptyArrayExpression(initializer);
        }
        boolean strictNullCheck = config2 != null && config2.strictNullChecks();
        TypeScriptTypeGuard typeScriptTypeGuard = new TypeScriptTypeGuard(reference, TypeScriptTypeGuard.addUndefinedTypeForOptionalProperties(startType, resolveResult, config2), resolveResult, useAutoArrayType, useAutoVariableType, strictNullCheck);
        if (typeScriptTypeGuard == null) {
            TypeScriptTypeGuard.$$$reportNull$$$0(2);
        }
        return typeScriptTypeGuard;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "reference";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/javascript/psi/types/guard/TypeScriptTypeGuard";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/javascript/psi/types/guard/TypeScriptTypeGuard";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "createTypeScriptTypeGuard";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "createTypeScriptTypeGuard";
                break;
            }
            case 2: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

