/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.refactoring.extractSuper;

import com.intellij.lang.javascript.DialectDetector;
import com.intellij.lang.javascript.dialects.JSDialectSpecificHandlersFactory;
import com.intellij.lang.javascript.psi.JSArgumentList;
import com.intellij.lang.javascript.psi.JSAssignmentExpression;
import com.intellij.lang.javascript.psi.JSBinaryExpression;
import com.intellij.lang.javascript.psi.JSCallExpression;
import com.intellij.lang.javascript.psi.JSDefinitionExpression;
import com.intellij.lang.javascript.psi.JSElement;
import com.intellij.lang.javascript.psi.JSExpression;
import com.intellij.lang.javascript.psi.JSExpressionStatement;
import com.intellij.lang.javascript.psi.JSForInStatement;
import com.intellij.lang.javascript.psi.JSFunction;
import com.intellij.lang.javascript.psi.JSIndexedPropertyAccessExpression;
import com.intellij.lang.javascript.psi.JSLiteralExpression;
import com.intellij.lang.javascript.psi.JSNamedElement;
import com.intellij.lang.javascript.psi.JSNewExpression;
import com.intellij.lang.javascript.psi.JSParameter;
import com.intellij.lang.javascript.psi.JSParameterList;
import com.intellij.lang.javascript.psi.JSReferenceExpression;
import com.intellij.lang.javascript.psi.JSReturnStatement;
import com.intellij.lang.javascript.psi.JSVarStatement;
import com.intellij.lang.javascript.psi.JSVariable;
import com.intellij.lang.javascript.psi.ecmal4.JSAttributeListOwner;
import com.intellij.lang.javascript.psi.ecmal4.JSClass;
import com.intellij.lang.javascript.psi.ecmal4.JSGenericSignature;
import com.intellij.lang.javascript.psi.ecmal4.JSQualifiedNamedElement;
import com.intellij.lang.javascript.psi.ecmal4.JSReferenceListMember;
import com.intellij.lang.javascript.psi.ecmal4.JSSuperExpression;
import com.intellij.lang.javascript.psi.impl.JSPsiImplUtils;
import com.intellij.lang.javascript.psi.resolve.JSImportHandlingUtil;
import com.intellij.lang.javascript.psi.resolve.JSImportedElementResolveResult;
import com.intellij.lang.javascript.psi.resolve.JSInheritanceUtil;
import com.intellij.lang.javascript.psi.resolve.JSResolveUtil;
import com.intellij.lang.javascript.refactoring.extractSuper.JSExtractSuperMode;
import com.intellij.lang.javascript.refactoring.util.JSMemberInfo;
import com.intellij.lang.javascript.refactoring.util.JSRefactoringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.search.SearchScope;
import com.intellij.psi.search.searches.ReferencesSearch;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.ArrayUtil;
import com.intellij.util.Processor;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JSConvertReferencesToSuperUtil {
    private JSClass mySourceClass;
    private final JSMemberInfo[] myMembersToMove;
    private final JSExtractSuperMode myMode;
    @Nullable
    private JSClass myTargetClass;
    @Nullable
    private Collection<JSElement> myMembersAfterMove;

    public JSConvertReferencesToSuperUtil(@NotNull JSMemberInfo[] membersToMove, @Nullable Collection<JSElement> membersAfterMove, @NotNull JSExtractSuperMode mode, @NotNull JSClass sourceClass, @Nullable JSClass targetClass) {
        if (membersToMove == null) {
            JSConvertReferencesToSuperUtil.$$$reportNull$$$0(0);
        }
        if (mode == null) {
            JSConvertReferencesToSuperUtil.$$$reportNull$$$0(1);
        }
        if (sourceClass == null) {
            JSConvertReferencesToSuperUtil.$$$reportNull$$$0(2);
        }
        this.mySourceClass = sourceClass;
        this.myMembersToMove = membersToMove;
        this.myMode = mode;
        this.myTargetClass = targetClass;
        this.myMembersAfterMove = membersAfterMove;
    }

    public boolean canTurnReferenceToSuper(@NotNull JSReferenceExpression refExpr, @NotNull Map<PsiElement, Status> results) {
        JSReferenceExpression typeDeclaration;
        PsiElement parent;
        if (refExpr == null) {
            JSConvertReferencesToSuperUtil.$$$reportNull$$$0(3);
        }
        if (results == null) {
            JSConvertReferencesToSuperUtil.$$$reportNull$$$0(4);
        }
        if ((parent = refExpr.getParent()) instanceof JSNewExpression) {
            return false;
        }
        if (parent instanceof JSBinaryExpression) {
            return false;
        }
        if (parent instanceof JSReferenceListMember) {
            return false;
        }
        if (parent instanceof JSCallExpression) {
            return this.checkUsage(null, parent, false, results);
        }
        if (parent instanceof JSReferenceExpression) {
            return false;
        }
        if (parent instanceof JSGenericSignature) {
            JSVariable variable = (JSVariable)PsiTreeUtil.getParentOfType((PsiElement)refExpr, JSVariable.class);
            if (variable != null) {
                if (PsiTreeUtil.isAncestor((PsiElement)variable.getTypeElement(), (PsiElement)parent, (boolean)false)) {
                    return this.canPullUpVariableOrFunctionType((JSNamedElement)variable, results, true, true);
                }
                return this.canPullUpVariableOrFunctionType((JSNamedElement)variable, results, true, true);
            }
            JSFunction function = (JSFunction)PsiTreeUtil.getParentOfType((PsiElement)refExpr, JSFunction.class);
            if (function != null && PsiTreeUtil.isAncestor((PsiElement)function.getReturnTypeElement(), (PsiElement)parent, (boolean)false)) {
                return this.canPullUpVariableOrFunctionType((JSNamedElement)function, results, true, true);
            }
            return false;
        }
        Object object = typeDeclaration = DialectDetector.isActionScript((PsiElement)refExpr) ? refExpr : (JSElement)refExpr.getParent();
        return this.canUpdateTypeDeclaration((JSElement)typeDeclaration, typeDeclaration.getParent(), results);
    }

    private boolean canUpdateTypeDeclaration(@NotNull JSElement typeDeclaration, @Nullable PsiElement owner, @NotNull Map<PsiElement, Status> results) {
        if (typeDeclaration == null) {
            JSConvertReferencesToSuperUtil.$$$reportNull$$$0(5);
        }
        if (results == null) {
            JSConvertReferencesToSuperUtil.$$$reportNull$$$0(6);
        }
        if (owner instanceof JSVariable) {
            return this.canPullUpVariableOrFunctionType((JSNamedElement)owner, results, false, true);
        }
        if (owner instanceof JSFunction && ((JSFunction)owner).getReturnTypeElement() == typeDeclaration) {
            return this.canPullUpVariableOrFunctionType((JSNamedElement)owner, results, false, true);
        }
        return false;
    }

    private boolean canPullUpVariableOrFunctionType(JSNamedElement element, Map<PsiElement, Status> results, boolean genericSignature, boolean checkParamsHierarchy) {
        Status status = results.get(element);
        if (status == null) {
            results.put((PsiElement)element, Status.InProgress);
            Collection<JSReferenceExpression> usages = Collections.synchronizedCollection(new ArrayList());
            ReferencesSearch.search((PsiElement)element, (SearchScope)element.getUseScope()).forEach(psiReference -> {
                if (!(psiReference.getElement() instanceof JSReferenceExpression)) {
                    return true;
                }
                usages.add((JSReferenceExpression)psiReference.getElement());
                return true;
            });
            boolean result2 = true;
            for (JSReferenceExpression usage : usages) {
                if (this.checkUsage(element, (PsiElement)usage, genericSignature, results)) continue;
                result2 = false;
                break;
            }
            status = result2 ? Status.Yes : Status.No;
            results.put((PsiElement)element, status);
        }
        if (status != Status.No && checkParamsHierarchy && (element instanceof JSParameter || element instanceof JSFunction)) {
            if (element instanceof JSParameter) {
                int index = ArrayUtil.indexOf((Object[])((JSParameterList)element.getParent()).getParameters(), (Object)element);
                return JSInheritanceUtil.processHierarchy((JSFunction)element.getParent().getParent(), (Processor<JSFunction>)((Processor)jsFunction -> {
                    if (((JSClass)jsFunction.getParent()).isInterface()) {
                        return true;
                    }
                    JSParameter[] parameters = jsFunction.getParameterVariables();
                    return parameters.length > index && this.canPullUpVariableOrFunctionType((JSNamedElement)parameters[index], results, genericSignature, false);
                }));
            }
            return JSInheritanceUtil.processHierarchy((JSFunction)element, (Processor<JSFunction>)((Processor)jsFunction -> this.canPullUpVariableOrFunctionType((JSNamedElement)jsFunction, results, genericSignature, false)));
        }
        return status != Status.No;
    }

    private boolean checkUsage(JSNamedElement element, PsiElement usage, boolean genericSignature, Map<PsiElement, Status> results) {
        JSVarStatement declarationStatement;
        PsiElement parent = usage.getParent();
        if (element instanceof JSFunction && parent instanceof JSCallExpression) {
            parent = parent.getParent();
            usage = usage.getParent();
        }
        if (parent instanceof JSVariable) {
            JSVariable variable = (JSVariable)parent;
            JSExpression initializer = variable.getInitializer();
            if (JSResolveUtil.isSelfReference((PsiElement)variable, usage)) {
                if (initializer == null) {
                    return true;
                }
                return this.isAssignableToPulledType(initializer, genericSignature);
            }
            if (initializer == usage) {
                return this.isPulledTypeAssignableTo(variable, genericSignature, results);
            }
        }
        if (parent == element) {
            return true;
        }
        if (parent instanceof JSReferenceExpression) {
            if (genericSignature && usage == ((JSReferenceExpression)parent).getQualifier()) {
                return true;
            }
            PsiElement psiElement = ((JSReferenceExpression)parent).resolve();
            if (psiElement == null) {
                return false;
            }
            if (psiElement instanceof JSFunction || psiElement instanceof JSVariable) {
                return this.doesMemberBelongToPulledType((JSQualifiedNamedElement)psiElement);
            }
        }
        if (parent instanceof JSDefinitionExpression && parent.getParent() instanceof JSAssignmentExpression) {
            JSExpression expression = ((JSAssignmentExpression)parent.getParent()).getROperand();
            return this.isAssignableToPulledType(expression, genericSignature);
        }
        if (parent instanceof JSAssignmentExpression && ((JSAssignmentExpression)parent).getROperand() == usage) {
            JSAssignmentExpression assignment = (JSAssignmentExpression)parent;
            JSDefinitionExpression definition = (JSDefinitionExpression)assignment.getLOperand();
            String type = JSResolveUtil.getQualifiedExpressionType(definition.getExpression(), definition.getContainingFile());
            if (type == null || "*".equals(type)) {
                return true;
            }
            PsiElement clazz = JSDialectSpecificHandlersFactory.forElement((PsiElement)definition).getClassResolver().findClassByQName(type, (PsiElement)definition);
            if (clazz instanceof JSClass) {
                if (clazz.isEquivalentTo((PsiElement)this.getSubjectClass((JSElement)definition))) {
                    if (definition.getExpression() instanceof JSReferenceExpression) {
                        PsiElement psiElement = ((JSReferenceExpression)definition.getExpression()).resolve();
                        return psiElement instanceof JSVariable && this.canPullUpVariableOrFunctionType((JSNamedElement)((JSVariable)psiElement), results, genericSignature, true);
                    }
                    return false;
                }
                return this.isSuperClassOfPulledTypes((JSClass)clazz);
            }
            return false;
        }
        if (parent instanceof JSArgumentList) {
            JSArgumentList argumentList = (JSArgumentList)parent;
            int index = 0;
            while (usage != argumentList.getArguments()[index]) {
                ++index;
            }
            JSCallExpression callExpression = (JSCallExpression)argumentList.getParent();
            JSExpression methodExpression = callExpression.getMethodExpression();
            if (methodExpression instanceof JSReferenceExpression) {
                PsiElement psiElement = ((JSReferenceExpression)methodExpression).resolve();
                if (psiElement instanceof JSFunction) {
                    return this.checkMethodParameter((JSFunction)psiElement, index, genericSignature, results);
                }
                return psiElement instanceof JSClass && !(argumentList.getParent() instanceof JSNewExpression);
            }
            if (methodExpression instanceof JSSuperExpression) {
                JSFunction constructor;
                JSClass clazz = JSResolveUtil.getClassOfContext((PsiElement)methodExpression);
                if (clazz == null) {
                    // empty if block
                }
                return (constructor = clazz.getSuperClasses()[0].getConstructor()) != null && this.checkMethodParameter(constructor, index, genericSignature, results);
            }
        }
        if (parent instanceof JSReturnStatement) {
            JSFunction function = (JSFunction)PsiTreeUtil.getParentOfType((PsiElement)parent, JSFunction.class);
            if (function != null) {
                return this.canPullUpVariableOrFunctionType((JSNamedElement)function, results, genericSignature, true);
            }
            return false;
        }
        if (parent instanceof JSExpressionStatement) {
            return true;
        }
        if (element instanceof JSFunction && parent instanceof JSFunction && JSPsiImplUtils.isFunctionNameReference((JSFunction)parent, usage)) {
            return this.canPullUpVariableOrFunctionType((JSNamedElement)((JSFunction)parent), results, genericSignature, true);
        }
        if (parent instanceof JSIndexedPropertyAccessExpression) {
            if (genericSignature) {
                return this.checkUsage(null, parent, false, results);
            }
            return true;
        }
        if (parent instanceof JSForInStatement && (declarationStatement = ((JSForInStatement)parent).getDeclarationStatement()) != null) {
            return this.canPullUpVariableOrFunctionType((JSNamedElement)declarationStatement.getVariables()[0], results, false, false);
        }
        return false;
    }

    private boolean checkMethodParameter(JSFunction function, int index, boolean genericSignature, Map<PsiElement, Status> results) {
        JSParameter[] params = function.getParameterVariables();
        if (index < params.length) {
            return this.isPulledTypeAssignableTo((JSVariable)params[index], genericSignature, results);
        }
        return params.length > 0 && params[params.length - 1].isRest();
    }

    public JSClass getSubjectClass(@NotNull JSElement element) {
        if (element == null) {
            JSConvertReferencesToSuperUtil.$$$reportNull$$$0(7);
        }
        if (this.myMembersAfterMove != null && this.myMembersAfterMove.contains(element)) {
            return this.myMode == JSExtractSuperMode.RenameImplementation ? this.mySourceClass : this.myTargetClass;
        }
        return this.myTargetClass != null && !JSRefactoringUtil.isChildOfAny((PsiElement)element, this.myMembersAfterMove) ? this.myTargetClass : this.mySourceClass;
    }

    private boolean isPulledTypeAssignableTo(JSVariable variable, boolean genericSignature, Map<PsiElement, Status> results) {
        PsiElement typeElement = variable.getTypeElement();
        if (typeElement == null || "*".equals(typeElement.getText())) {
            return true;
        }
        if (typeElement instanceof JSReferenceExpression) {
            if (genericSignature) {
                JSGenericSignature signatureElement = (JSGenericSignature)PsiTreeUtil.getChildOfType((PsiElement)typeElement, JSGenericSignature.class);
                if (signatureElement != null) {
                    JSClass genericType = JSConvertReferencesToSuperUtil.findSubjectType((JSExpression)signatureElement.getTypeReference(), false);
                    return genericType != null && genericType.isEquivalentTo((PsiElement)this.getSubjectClass((JSElement)variable)) && this.canPullUpVariableOrFunctionType((JSNamedElement)variable, results, genericSignature, true);
                }
                return false;
            }
            JSImportedElementResolveResult result2 = JSImportHandlingUtil.resolveTypeNameUsingImports((JSReferenceExpression)typeElement);
            if (result2 != null && result2.resolvedElement instanceof JSClass) {
                return result2.resolvedElement.isEquivalentTo((PsiElement)this.getSubjectClass((JSElement)variable)) ? this.canPullUpVariableOrFunctionType((JSNamedElement)variable, results, genericSignature, true) : this.isSuperClassOfPulledTypes((JSClass)result2.resolvedElement);
            }
        }
        return false;
    }

    private boolean isAssignableToPulledType(JSExpression expression, boolean genericSignature) {
        if (expression instanceof JSLiteralExpression && "null".equals(expression.getText())) {
            return true;
        }
        JSClass assignedType = JSConvertReferencesToSuperUtil.findSubjectType(expression, genericSignature);
        if (assignedType != null) {
            JSClass clazz = this.getSubjectClass((JSElement)expression);
            return assignedType.isEquivalentTo((PsiElement)clazz) || !genericSignature && JSInheritanceUtil.isParentClass(assignedType, clazz);
        }
        return false;
    }

    private boolean doesMemberBelongToPulledType(JSQualifiedNamedElement member) {
        Collection<JSClass> declaringClasses = JSInheritanceUtil.findDeclaringClasses(member);
        for (JSClass declaringClass : declaringClasses) {
            if (!(declaringClass.isEquivalentTo((PsiElement)this.getSubjectClass((JSElement)member)) && member instanceof JSAttributeListOwner ? JSConvertReferencesToSuperUtil.willBeInSuperclass((JSAttributeListOwner)member, this.myMembersToMove, this.myMembersAfterMove) : this.isSuperClassOfPulledTypes(declaringClass))) continue;
            return true;
        }
        return false;
    }

    private boolean isSuperClassOfPulledTypes(JSClass type) {
        if (JSDialectSpecificHandlersFactory.forElement((PsiElement)type).getClassResolver().findClassByQName("Object", (PsiElement)type).isEquivalentTo((PsiElement)type)) {
            return true;
        }
        if (this.myMembersAfterMove != null) {
            for (JSElement member : this.myMembersAfterMove) {
                if (!JSConvertReferencesToSuperUtil.isEquivalentOrSuper(type, member)) continue;
                return true;
            }
            return false;
        }
        for (JSMemberInfo memberInfo : this.myMembersToMove) {
            if (!JSConvertReferencesToSuperUtil.isEquivalentOrSuper(type, (JSElement)memberInfo.getMember())) continue;
            return true;
        }
        return false;
    }

    private static boolean isEquivalentOrSuper(JSClass type, JSElement member) {
        return member instanceof JSClass && JSInheritanceUtil.isParentClass((JSClass)member, type, false);
    }

    public static boolean willBeInSuperclass(@NotNull JSAttributeListOwner member, @NotNull JSMemberInfo[] membersToMove, @Nullable Collection<JSElement> membersAfterMove) {
        if (member == null) {
            JSConvertReferencesToSuperUtil.$$$reportNull$$$0(8);
        }
        if (membersToMove == null) {
            JSConvertReferencesToSuperUtil.$$$reportNull$$$0(9);
        }
        if (membersAfterMove != null) {
            return membersAfterMove.contains(member);
        }
        for (JSMemberInfo jsMemberInfo : membersToMove) {
            if (jsMemberInfo.getMember() != member) continue;
            return true;
        }
        return false;
    }

    @Nullable
    private static JSClass findSubjectType(JSExpression expr, boolean genericSignature) {
        String typeString;
        if (genericSignature) {
            String genericTypeString = JSResolveUtil.getQualifiedExpressionType(expr, expr.getContainingFile());
            JSResolveUtil.GenericSignature signature = JSResolveUtil.extractGenericSignature(genericTypeString);
            if (signature == null) {
                return null;
            }
            typeString = signature.genericType;
        } else {
            typeString = JSResolveUtil.getQualifiedExpressionType(expr, expr.getContainingFile());
        }
        PsiElement type = JSResolveUtil.findType(typeString, (PsiElement)expr, true);
        return type instanceof JSClass ? (JSClass)type : null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "membersToMove";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "mode";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sourceClass";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "refExpr";
                break;
            }
            case 4: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "results";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "typeDeclaration";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "member";
                break;
            }
        }
        objectArray2[1] = "com/intellij/lang/javascript/refactoring/extractSuper/JSConvertReferencesToSuperUtil";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "canTurnReferenceToSuper";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[2] = "canUpdateTypeDeclaration";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[2] = "getSubjectClass";
                break;
            }
            case 8: 
            case 9: {
                objectArray = objectArray2;
                objectArray2[2] = "willBeInSuperclass";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    public static enum Status {
        Yes,
        No,
        InProgress;

    }
}

