/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.refactoring.introduce;

import com.intellij.lang.ASTNode;
import com.intellij.lang.Language;
import com.intellij.lang.LanguageNamesValidation;
import com.intellij.lang.javascript.JSBundle;
import com.intellij.lang.javascript.JSElementTypes;
import com.intellij.lang.javascript.documentation.JSDocumentationUtils;
import com.intellij.lang.javascript.flex.ImportUtils;
import com.intellij.lang.javascript.psi.JSArgumentList;
import com.intellij.lang.javascript.psi.JSAssignmentExpression;
import com.intellij.lang.javascript.psi.JSCallExpression;
import com.intellij.lang.javascript.psi.JSDefinitionExpression;
import com.intellij.lang.javascript.psi.JSElement;
import com.intellij.lang.javascript.psi.JSElementVisitor;
import com.intellij.lang.javascript.psi.JSEmbeddedContent;
import com.intellij.lang.javascript.psi.JSExpression;
import com.intellij.lang.javascript.psi.JSExpressionStatement;
import com.intellij.lang.javascript.psi.JSField;
import com.intellij.lang.javascript.psi.JSFile;
import com.intellij.lang.javascript.psi.JSFunction;
import com.intellij.lang.javascript.psi.JSFunctionItem;
import com.intellij.lang.javascript.psi.JSIndexedPropertyAccessExpression;
import com.intellij.lang.javascript.psi.JSInitializerOwner;
import com.intellij.lang.javascript.psi.JSLiteralExpression;
import com.intellij.lang.javascript.psi.JSNamedElement;
import com.intellij.lang.javascript.psi.JSNewExpression;
import com.intellij.lang.javascript.psi.JSObjectLiteralExpression;
import com.intellij.lang.javascript.psi.JSParameterItem;
import com.intellij.lang.javascript.psi.JSProperty;
import com.intellij.lang.javascript.psi.JSReferenceExpression;
import com.intellij.lang.javascript.psi.JSType;
import com.intellij.lang.javascript.psi.JSTypeUtils;
import com.intellij.lang.javascript.psi.JSVariable;
import com.intellij.lang.javascript.psi.ecmal4.JSClass;
import com.intellij.lang.javascript.psi.ecmal4.JSGenericSignature;
import com.intellij.lang.javascript.psi.resolve.ImplicitJSVariableImpl;
import com.intellij.lang.javascript.psi.resolve.JSResolveResult;
import com.intellij.lang.javascript.psi.resolve.JSResolveUtil;
import com.intellij.lang.javascript.psi.resolve.ResolveResultSink;
import com.intellij.lang.javascript.psi.resolve.SinkResolveProcessor;
import com.intellij.lang.javascript.psi.types.JSAnyType;
import com.intellij.lang.javascript.psi.types.JSGenericTypeImpl;
import com.intellij.lang.javascript.psi.types.JSNamedType;
import com.intellij.lang.javascript.psi.types.primitives.JSBooleanType;
import com.intellij.lang.javascript.psi.types.primitives.JSIntType;
import com.intellij.lang.javascript.psi.types.primitives.JSPrimitiveFunctionType;
import com.intellij.lang.javascript.psi.types.primitives.JSStringType;
import com.intellij.lang.javascript.psi.types.primitives.JSUintType;
import com.intellij.lang.javascript.refactoring.introduce.IntroducedEntityInfoProvider;
import com.intellij.lang.javascript.validation.fixes.BaseCreateFix;
import com.intellij.lang.refactoring.NamesValidator;
import com.intellij.openapi.application.WriteAction;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiFile;
import com.intellij.psi.ResolveState;
import com.intellij.psi.codeStyle.NameUtil;
import com.intellij.psi.util.QualifiedName;
import com.intellij.refactoring.ui.ConflictsDialog;
import com.intellij.refactoring.util.RefactoringUIUtil;
import com.intellij.util.ArrayUtil;
import com.intellij.util.ObjectUtils;
import com.intellij.util.Processor;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.MultiMap;
import gnu.trove.THashSet;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class BasicIntroducedEntityInfoProvider
implements IntroducedEntityInfoProvider {
    public final JSExpression[] myOccurrences;
    public final JSExpression myMainOccurrence;
    private PsiElement myScope;

    public BasicIntroducedEntityInfoProvider(@NotNull JSExpression mainOccurrence, JSExpression[] occurrences, PsiElement scope) {
        if (mainOccurrence == null) {
            BasicIntroducedEntityInfoProvider.$$$reportNull$$$0(0);
        }
        this.myOccurrences = occurrences;
        this.myMainOccurrence = mainOccurrence;
        this.myScope = scope;
    }

    @Override
    public int getOccurrenceCount() {
        return this.myOccurrences.length;
    }

    @Override
    @Nullable
    public String evaluateType() {
        JSType type = JSResolveUtil.getExpressionJSType(this.myMainOccurrence);
        String finalType = type == null || type instanceof JSAnyType && this.myMainOccurrence instanceof JSReferenceExpression ? BaseCreateFix.guessTypeForExpression(this.myMainOccurrence, this.myMainOccurrence.getContainingFile(), false) : type.getTypeText(JSType.TypeTextFormat.CODE);
        String typeString = (String)WriteAction.compute(() -> (String)ImportUtils.importAndShortenReference((String)finalType, (PsiElement)this.myMainOccurrence, (boolean)false, (boolean)false).first);
        return typeString;
    }

    @Override
    public PsiFile getContainingFile() {
        return this.myMainOccurrence.getContainingFile();
    }

    @Override
    public String[] suggestCandidateNames() {
        return ArrayUtil.toStringArray(BasicIntroducedEntityInfoProvider.generateVariableNamesFromExpression(this.myMainOccurrence, this.myScope, Collections.emptyList()));
    }

    @Override
    public boolean checkConflicts(@NotNull String name, boolean replaceAllOccurences) {
        if (name == null) {
            BasicIntroducedEntityInfoProvider.$$$reportNull$$$0(1);
        }
        PsiElement scope = this.myScope;
        assert (scope != null);
        JSNamedElement existing = BasicIntroducedEntityInfoProvider.findExistingInScopeAndUp(name, scope);
        if (existing != null) {
            return BasicIntroducedEntityInfoProvider.showMemberAlreadyExists((PsiElement)existing);
        }
        return true;
    }

    private static JSNamedElement findExistingInScopeAndUp(final @NotNull String name, final PsiElement scope) {
        if (name == null) {
            BasicIntroducedEntityInfoProvider.$$$reportNull$$$0(2);
        }
        final Ref existing = new Ref();
        final Ref existingRef = new Ref();
        scope.accept((PsiElementVisitor)new JSElementVisitor(){

            public void visitJSFile(JSFile file) {
                if (existing.isNull()) {
                    file.acceptChildren((PsiElementVisitor)this);
                }
            }

            public void visitJSEmbeddedContent(JSEmbeddedContent embeddedContent) {
                if (existing.isNull()) {
                    embeddedContent.acceptChildren((PsiElementVisitor)this);
                }
            }

            public void visitJSElement(JSElement node) {
                if (existing.isNull()) {
                    node.acceptChildren((PsiElementVisitor)this);
                }
            }

            public void visitJSClass(JSClass aClass) {
                if (name.equals(aClass.getName())) {
                    existing.set((Object)aClass);
                }
            }

            public void visitJSVariable(JSVariable node) {
                if (name.equals(node.getName())) {
                    existing.set((Object)node);
                }
                super.visitJSVariable(node);
            }

            public void visitJSReferenceExpression(JSReferenceExpression node) {
                if (JSResolveUtil.isExprInStrictTypeContext(node)) {
                    return;
                }
                if (name.equals(node.getReferencedName()) && node.getQualifier() == null) {
                    existingRef.set((Object)node);
                }
                super.visitJSReferenceExpression(node);
            }

            public void visitJSFunctionDeclaration(JSFunction node) {
                if (name.equals(node.getName())) {
                    existing.set((Object)node);
                }
                if (node == scope) {
                    super.visitJSFunctionDeclaration(node);
                }
            }
        });
        if (existing.isNull()) {
            SinkResolveProcessor<ResolveResultSink> processor = new SinkResolveProcessor<ResolveResultSink>(name, new ResolveResultSink(null, name));
            JSResolveUtil.treeWalkUp(processor, scope, null, scope);
            PsiElement resolved = (PsiElement)ContainerUtil.getFirstItem(JSResolveResult.toElements(processor.getResultsAsResolveResults()));
            if (resolved instanceof JSNamedElement && !(resolved instanceof JSClass)) {
                existing.set((Object)((JSNamedElement)resolved));
            }
            if (existing.isNull() && !existingRef.isNull()) {
                existing.set((Object)new ImplicitJSVariableImpl(name, (JSType)null, scope));
            }
        }
        return (JSNamedElement)existing.get();
    }

    public static boolean showMemberAlreadyExists(@NotNull PsiElement existing) {
        if (existing == null) {
            BasicIntroducedEntityInfoProvider.$$$reportNull$$$0(3);
        }
        String description = StringUtil.capitalize((String)RefactoringUIUtil.getDescription((PsiElement)existing, (boolean)false));
        String msg = JSBundle.message((String)"javascript.introduce.element.already.exists", (Object[])new Object[]{description});
        MultiMap conflicts = new MultiMap();
        conflicts.putValue((Object)existing, (Object)msg);
        return new ConflictsDialog(existing.getProject(), conflicts).showAndGet();
    }

    @Nullable
    public static String generateVariableNameFromExpression(@NotNull JSExpression mainOccurrence, PsiElement scope) {
        if (mainOccurrence == null) {
            BasicIntroducedEntityInfoProvider.$$$reportNull$$$0(4);
        }
        return (String)ContainerUtil.getFirstItem(BasicIntroducedEntityInfoProvider.generateVariableNamesFromExpression(mainOccurrence, scope, Collections.emptyList()));
    }

    @NotNull
    public static List<String> generateVariableNamesFromExpression(@NotNull JSExpression mainOccurrence, PsiElement scope, @NotNull Collection<String> existing) {
        if (mainOccurrence == null) {
            BasicIntroducedEntityInfoProvider.$$$reportNull$$$0(5);
        }
        if (existing == null) {
            BasicIntroducedEntityInfoProvider.$$$reportNull$$$0(6);
        }
        List<String> list = BasicIntroducedEntityInfoProvider.generateVariableNamesFromExpression(mainOccurrence, scope, "", existing, NamedEntityKind.Default);
        if (list == null) {
            BasicIntroducedEntityInfoProvider.$$$reportNull$$$0(7);
        }
        return list;
    }

    @NotNull
    public static List<String> generateVariableNamesFromExpression(@NotNull JSExpression mainOccurrence, PsiElement scope, String namePrefix, @NotNull Collection<String> existing, @NotNull NamedEntityKind entityKind) {
        if (mainOccurrence == null) {
            BasicIntroducedEntityInfoProvider.$$$reportNull$$$0(8);
        }
        if (existing == null) {
            BasicIntroducedEntityInfoProvider.$$$reportNull$$$0(9);
        }
        if (entityKind == null) {
            BasicIntroducedEntityInfoProvider.$$$reportNull$$$0(10);
        }
        LinkedHashSet results = ContainerUtil.newLinkedHashSet();
        Processor processor = s -> {
            if (mainOccurrence == null) {
                BasicIntroducedEntityInfoProvider.$$$reportNull$$$0(47);
            }
            if (existing == null) {
                BasicIntroducedEntityInfoProvider.$$$reportNull$$$0(48);
            }
            if (StringUtil.isEmpty((String)s)) {
                return true;
            }
            for (String candidate : BasicIntroducedEntityInfoProvider.generateNamesFromQualifiedName(s, mainOccurrence instanceof JSIndexedPropertyAccessExpression)) {
                if (namePrefix.length() > 0) {
                    candidate = Character.isLetterOrDigit(namePrefix.charAt(namePrefix.length() - 1)) ? StringUtil.capitalize((String)candidate) : candidate;
                    candidate = namePrefix + candidate;
                }
                results.add(BasicIntroducedEntityInfoProvider.generateUniqueVariableName(candidate, scope, existing, false));
            }
            return true;
        };
        BasicIntroducedEntityInfoProvider.processCandidates(mainOccurrence, (Processor<String>)processor, entityKind);
        ArrayList arrayList = ContainerUtil.newArrayList((Iterable)results);
        if (arrayList == null) {
            BasicIntroducedEntityInfoProvider.$$$reportNull$$$0(11);
        }
        return arrayList;
    }

    @NotNull
    public static List<String> generateVariableNamesFromType(@NotNull JSType type, @NotNull PsiElement scope, @NotNull Collection<String> existing) {
        String fromType;
        if (type == null) {
            BasicIntroducedEntityInfoProvider.$$$reportNull$$$0(12);
        }
        if (scope == null) {
            BasicIntroducedEntityInfoProvider.$$$reportNull$$$0(13);
        }
        if (existing == null) {
            BasicIntroducedEntityInfoProvider.$$$reportNull$$$0(14);
        }
        if ((fromType = BasicIntroducedEntityInfoProvider.generateNameFromJSTypeOrNull(type, scope)) == null) {
            List list = ContainerUtil.emptyList();
            if (list == null) {
                BasicIntroducedEntityInfoProvider.$$$reportNull$$$0(15);
            }
            return list;
        }
        List list = ContainerUtil.map(BasicIntroducedEntityInfoProvider.generateNamesFromQualifiedName(fromType, false), nameCandidate -> {
            if (scope == null) {
                BasicIntroducedEntityInfoProvider.$$$reportNull$$$0(45);
            }
            if (existing == null) {
                BasicIntroducedEntityInfoProvider.$$$reportNull$$$0(46);
            }
            return BasicIntroducedEntityInfoProvider.generateUniqueVariableName(nameCandidate, scope, existing, false);
        });
        if (list == null) {
            BasicIntroducedEntityInfoProvider.$$$reportNull$$$0(16);
        }
        return list;
    }

    @NotNull
    public static List<String> generateNamesForType(@Nullable JSType jsType, @NotNull PsiElement scope) {
        if (scope == null) {
            BasicIntroducedEntityInfoProvider.$$$reportNull$$$0(17);
        }
        if (jsType == null) {
            List list = ContainerUtil.emptyList();
            if (list == null) {
                BasicIntroducedEntityInfoProvider.$$$reportNull$$$0(18);
            }
            return list;
        }
        String forComplexType = BasicIntroducedEntityInfoProvider.getNameForComplexType(jsType, scope);
        if (forComplexType == null) {
            List list = ContainerUtil.emptyList();
            if (list == null) {
                BasicIntroducedEntityInfoProvider.$$$reportNull$$$0(19);
            }
            return list;
        }
        HashSet existing = ContainerUtil.newHashSet();
        List list = ContainerUtil.map(BasicIntroducedEntityInfoProvider.generateNamesFromQualifiedName(forComplexType, false), s -> {
            if (scope == null) {
                BasicIntroducedEntityInfoProvider.$$$reportNull$$$0(44);
            }
            return BasicIntroducedEntityInfoProvider.generateUniqueVariableName(StringUtil.capitalize((String)s), scope, existing, false);
        });
        if (list == null) {
            BasicIntroducedEntityInfoProvider.$$$reportNull$$$0(20);
        }
        return list;
    }

    public static String generateUniqueVariableName(String originalString, @Nullable PsiElement scope, @NotNull Collection<String> existing, boolean skipSearchInScope) {
        if (existing == null) {
            BasicIntroducedEntityInfoProvider.$$$reportNull$$$0(21);
        }
        String currentVariant = originalString;
        if ((skipSearchInScope || scope != null) && StringUtil.isJavaIdentifier((String)originalString)) {
            int cnt = 1;
            String originalStringWithoutTrailingNumbers = null;
            while (existing.contains(currentVariant) || !skipSearchInScope && !currentVariant.equals(scope.getText()) && (BasicIntroducedEntityInfoProvider.findExistingInScopeAndUp(currentVariant, scope) != null || !BasicIntroducedEntityInfoProvider.isValidIdentifier(currentVariant, scope))) {
                ++cnt;
                if (originalStringWithoutTrailingNumbers == null) {
                    int i;
                    originalStringWithoutTrailingNumbers = originalString;
                    int startedPos = i = originalStringWithoutTrailingNumbers.length() - 1;
                    while (i >= 0 && Character.isDigit(originalStringWithoutTrailingNumbers.charAt(i))) {
                        --i;
                    }
                    if (i >= 0 && startedPos != i) {
                        currentVariant = originalStringWithoutTrailingNumbers = originalStringWithoutTrailingNumbers.substring(0, i + 1);
                        --cnt;
                        continue;
                    }
                }
                currentVariant = originalStringWithoutTrailingNumbers + cnt;
            }
        }
        return currentVariant;
    }

    private static void processCandidates(@NotNull JSExpression mainOccurrence, @NotNull Processor<String> processor, @NotNull NamedEntityKind entityKind) {
        String typeString;
        String name;
        PsiElement parent;
        if (mainOccurrence == null) {
            BasicIntroducedEntityInfoProvider.$$$reportNull$$$0(22);
        }
        if (processor == null) {
            BasicIntroducedEntityInfoProvider.$$$reportNull$$$0(23);
        }
        if (entityKind == null) {
            BasicIntroducedEntityInfoProvider.$$$reportNull$$$0(24);
        }
        if (mainOccurrence instanceof JSIndexedPropertyAccessExpression) {
            mainOccurrence = ((JSIndexedPropertyAccessExpression)mainOccurrence).getQualifier();
        }
        if (mainOccurrence == null) {
            return;
        }
        THashSet reported = new THashSet();
        String someDefaultName = null;
        boolean typeHasHigherPriorityThanName = entityKind == NamedEntityKind.Parameter;
        JSType expressionType = JSResolveUtil.getExpressionJSType(mainOccurrence);
        if (mainOccurrence instanceof JSCallExpression) {
            JSExpression methodExpression = ((JSCallExpression)mainOccurrence).getMethodExpression();
            boolean bl = typeHasHigherPriorityThanName = expressionType != null && !JSTypeUtils.isIndexableType(expressionType);
            if (methodExpression instanceof JSReferenceExpression) {
                String referencedName = ((JSReferenceExpression)methodExpression).getReferencedName();
                if (mainOccurrence instanceof JSNewExpression) {
                    JSReferenceExpression typeReference;
                    ASTNode node = methodExpression.getNode().findChildByType(JSElementTypes.GENERIC_SIGNATURE);
                    if (node != null && (typeReference = ((JSGenericSignature)node.getPsi()).getTypeReference()) != null) {
                        String typeText = typeReference.getText();
                        JSResolveUtil.GenericSignature signature = JSResolveUtil.extractGenericSignature(typeText);
                        referencedName = StringUtil.pluralize((String)(signature == null ? typeText : signature.elementType));
                    }
                    BasicIntroducedEntityInfoProvider.addName(referencedName, processor, (Set<String>)reported);
                } else {
                    String propertyName;
                    String string = propertyName = referencedName != null ? JSDocumentationUtils.getPropertyName(referencedName) : null;
                    if (propertyName != null) {
                        BasicIntroducedEntityInfoProvider.addName(propertyName, processor, (Set<String>)reported);
                    } else if ("$".equals(referencedName) || "get".equals(referencedName) || "set".equals(referencedName) || "require".equals(referencedName)) {
                        JSExpression[] arguments = ((JSCallExpression)mainOccurrence).getArguments();
                        if (arguments.length > 0 && arguments[0] instanceof JSLiteralExpression) {
                            int index;
                            String value = StringUtil.stripQuotesAroundValue((String)arguments[0].getText());
                            int start = 0;
                            if (value.length() > 0 && !Character.isJavaIdentifierStart(value.charAt(0))) {
                                ++start;
                            }
                            for (index = start; index < value.length() && Character.isJavaIdentifierPart(value.charAt(index)); ++index) {
                            }
                            if (index > start) {
                                String name2 = value.substring(start, index);
                                if ("$".equals(referencedName)) {
                                    name2 = "$" + name2;
                                }
                                BasicIntroducedEntityInfoProvider.addName(name2, processor, (Set<String>)reported);
                            }
                        }
                        someDefaultName = referencedName;
                    } else {
                        someDefaultName = referencedName;
                    }
                }
            }
        }
        if (mainOccurrence instanceof JSReferenceExpression) {
            JSReferenceExpression refExpr = (JSReferenceExpression)mainOccurrence;
            someDefaultName = refExpr.getReferencedName();
            if (refExpr.getParent() instanceof JSExpressionStatement) {
                BasicIntroducedEntityInfoProvider.addName(someDefaultName, processor, (Set<String>)reported);
                someDefaultName = null;
            }
        }
        if ((parent = mainOccurrence.getParent()) instanceof JSArgumentList && entityKind != NamedEntityKind.Parameter) {
            JSResolveUtil.processParametersForUsedArgument(mainOccurrence, (JSArgumentList)parent, (Processor<JSParameterItem>)((Processor)arg_0 -> BasicIntroducedEntityInfoProvider.lambda$processCandidates$4(processor, (Set)reported, arg_0)));
        } else if (parent instanceof JSAssignmentExpression) {
            JSExpression expression;
            JSExpression lOperand = ((JSAssignmentExpression)parent).getLOperand();
            if (lOperand instanceof JSDefinitionExpression && (expression = ((JSDefinitionExpression)lOperand).getExpression()) instanceof JSReferenceExpression) {
                String name3;
                JSParameterItem parameter;
                JSReferenceExpression referenceExpression = (JSReferenceExpression)expression;
                PsiElement resolve = referenceExpression.resolve();
                if (resolve instanceof JSFunction && (parameter = JSResolveUtil.getParameterFromSetAccessor((JSFunctionItem)((JSFunction)resolve))) != null && !"value".equals(name3 = parameter.getName())) {
                    BasicIntroducedEntityInfoProvider.addName(name3, processor, (Set<String>)reported);
                }
                String referencedName = referenceExpression.getReferencedName();
                BasicIntroducedEntityInfoProvider.addName(referencedName, processor, (Set<String>)reported);
            }
        } else if (parent instanceof JSProperty && BasicIntroducedEntityInfoProvider.isValidIdentifier(name = ((JSProperty)parent).getName(), (PsiElement)mainOccurrence)) {
            BasicIntroducedEntityInfoProvider.addName(name, processor, (Set<String>)reported);
        }
        if (parent instanceof JSInitializerOwner && parent instanceof JSNamedElement && BasicIntroducedEntityInfoProvider.getKind((JSNamedElement)parent) != entityKind) {
            BasicIntroducedEntityInfoProvider.addName(((JSNamedElement)parent).getName(), processor, (Set<String>)reported);
        }
        if (expressionType != null && JSTypeUtils.isIndexableType(expressionType)) {
            typeHasHigherPriorityThanName = true;
        }
        String string = typeString = expressionType != null ? BasicIntroducedEntityInfoProvider.generateNameFromJSTypeOrNull(expressionType, (PsiElement)mainOccurrence) : null;
        if (typeHasHigherPriorityThanName) {
            BasicIntroducedEntityInfoProvider.addName(typeString, processor, (Set<String>)reported);
            BasicIntroducedEntityInfoProvider.addName(someDefaultName, processor, (Set<String>)reported);
        } else {
            BasicIntroducedEntityInfoProvider.addName(someDefaultName, processor, (Set<String>)reported);
            BasicIntroducedEntityInfoProvider.addName(typeString, processor, (Set<String>)reported);
        }
    }

    @NotNull
    private static NamedEntityKind getKind(@Nullable JSNamedElement named) {
        if (named instanceof JSField) {
            NamedEntityKind namedEntityKind = NamedEntityKind.Field;
            if (namedEntityKind == null) {
                BasicIntroducedEntityInfoProvider.$$$reportNull$$$0(25);
            }
            return namedEntityKind;
        }
        NamedEntityKind namedEntityKind = NamedEntityKind.Default;
        if (namedEntityKind == null) {
            BasicIntroducedEntityInfoProvider.$$$reportNull$$$0(26);
        }
        return namedEntityKind;
    }

    private static void addName(@Nullable String name, @NotNull Processor<String> processor, @NotNull Set<String> reported) {
        if (processor == null) {
            BasicIntroducedEntityInfoProvider.$$$reportNull$$$0(27);
        }
        if (reported == null) {
            BasicIntroducedEntityInfoProvider.$$$reportNull$$$0(28);
        }
        if (name != null && reported.add(name)) {
            processor.process((Object)name);
        }
    }

    private static boolean isValidIdentifier(String candidate, PsiElement context) {
        if (candidate == null) {
            return false;
        }
        candidate = QualifiedName.fromDottedString((String)candidate).getLastComponent();
        Language language = context.getContainingFile().getLanguage();
        return ((NamesValidator)LanguageNamesValidation.INSTANCE.forLanguage(language)).isIdentifier(candidate, context.getProject());
    }

    @Override
    public PsiElement findNamedElementInScope(@NotNull String name, PsiElement place) {
        if (name == null) {
            BasicIntroducedEntityInfoProvider.$$$reportNull$$$0(29);
        }
        return (PsiElement)ContainerUtil.getFirstItem(BasicIntroducedEntityInfoProvider.findExistingInScope(name, place, this.processStatics(place)));
    }

    @NotNull
    public static List<PsiElement> findExistingInScope(@NotNull String name, @Nullable PsiElement scope, boolean processStatics) {
        if (name == null) {
            BasicIntroducedEntityInfoProvider.$$$reportNull$$$0(30);
        }
        if (scope == null) {
            List list = ContainerUtil.emptyList();
            if (list == null) {
                BasicIntroducedEntityInfoProvider.$$$reportNull$$$0(31);
            }
            return list;
        }
        SinkResolveProcessor<ResolveResultSink> processor = new SinkResolveProcessor<ResolveResultSink>(name, new ResolveResultSink(null, name));
        processor.getAccessibilityProcessingHandler().setProcessStatics(processStatics);
        if (scope instanceof JSClass) {
            processor.configureClassScope((JSClass)scope);
        }
        PsiElement realPlace = scope;
        if (scope instanceof JSObjectLiteralExpression) {
            scope = ((JSObjectLiteralExpression)scope).getFirstProperty();
        }
        scope.processDeclarations(processor, ResolveState.initial(), scope, realPlace);
        List list = (List)ObjectUtils.notNull(JSResolveResult.toElements(processor.getResultsAsResolveResults()), (Object)ContainerUtil.emptyList());
        if (list == null) {
            BasicIntroducedEntityInfoProvider.$$$reportNull$$$0(32);
        }
        return list;
    }

    protected boolean processStatics(PsiElement place) {
        return JSResolveUtil.calculateStaticFromContext(place);
    }

    @Nullable
    private static String generateNameFromJSTypeOrNull(@NotNull JSType type, @NotNull PsiElement context) {
        if (type == null) {
            BasicIntroducedEntityInfoProvider.$$$reportNull$$$0(33);
        }
        if (context == null) {
            BasicIntroducedEntityInfoProvider.$$$reportNull$$$0(34);
        }
        if (type instanceof JSAnyType) {
            return null;
        }
        if (type instanceof JSIntType || type instanceof JSUintType) {
            return "i";
        }
        if (type instanceof JSStringType) {
            return "s";
        }
        if (type instanceof JSBooleanType) {
            return "b";
        }
        if (type instanceof JSPrimitiveFunctionType) {
            return "f";
        }
        String s = type.getTypeText(JSType.TypeTextFormat.CODE);
        if ("Class".equals(s)) {
            return "cls";
        }
        if (JSTypeUtils.getIndexableComponentType(type) != null || type instanceof JSGenericTypeImpl && ((JSGenericTypeImpl)type).getType() instanceof JSNamedType) {
            return BasicIntroducedEntityInfoProvider.getNameForComplexType(type, context);
        }
        return StringUtil.isEmpty((String)s) || !BasicIntroducedEntityInfoProvider.isValidIdentifier(s, context) ? null : s;
    }

    @Nullable
    private static String getNameForComplexType(@NotNull JSType type, @NotNull PsiElement context) {
        String s;
        if (type == null) {
            BasicIntroducedEntityInfoProvider.$$$reportNull$$$0(35);
        }
        if (context == null) {
            BasicIntroducedEntityInfoProvider.$$$reportNull$$$0(36);
        }
        return StringUtil.isEmpty((String)(s = (String)ObjectUtils.coalesce((Object)BasicIntroducedEntityInfoProvider.getNameFromIterableType(type), (Object)BasicIntroducedEntityInfoProvider.getNameFromGenericType(type)))) || !BasicIntroducedEntityInfoProvider.isValidIdentifier(s, context) ? null : s;
    }

    @Nullable
    private static String getNameFromIterableType(@NotNull JSType type) {
        JSType arrayComponentOrNull;
        if (type == null) {
            BasicIntroducedEntityInfoProvider.$$$reportNull$$$0(37);
        }
        if ((arrayComponentOrNull = JSTypeUtils.getIndexableComponentType(type)) != null) {
            return StringUtil.pluralize((String)arrayComponentOrNull.getTypeText(JSType.TypeTextFormat.CODE));
        }
        return null;
    }

    @Nullable
    private static String getNameFromGenericType(@NotNull JSType type) {
        JSGenericTypeImpl genericType;
        if (type == null) {
            BasicIntroducedEntityInfoProvider.$$$reportNull$$$0(38);
        }
        JSGenericTypeImpl jSGenericTypeImpl = genericType = type instanceof JSGenericTypeImpl ? (JSGenericTypeImpl)type : null;
        if (genericType != null && genericType.getType() instanceof JSNamedType) {
            JSNamedType baseType = (JSNamedType)genericType.getType();
            List<JSType> arguments = genericType.getArguments();
            String baseText = baseType.getTypeText(JSType.TypeTextFormat.CODE);
            if (arguments.size() == 1 && arguments.get(0) instanceof JSNamedType) {
                return arguments.get(0).getTypeText(JSType.TypeTextFormat.CODE) + baseText;
            }
            return baseText;
        }
        return null;
    }

    @NotNull
    private static List<String> generateNamesFromQualifiedName(@NotNull String s, boolean removePlural) {
        String singular;
        if (s == null) {
            BasicIntroducedEntityInfoProvider.$$$reportNull$$$0(39);
        }
        ArrayList results = ContainerUtil.newArrayList();
        s = QualifiedName.fromDottedString((String)s).getLastComponent();
        assert (s != null);
        s = BasicIntroducedEntityInfoProvider.sanitizeJavaScriptIdentifier(s);
        if (removePlural && (singular = StringUtil.unpluralize((String)s)) != null) {
            s = singular;
        }
        for (String namePart : NameUtil.nameToWords((String)s)) {
            String name;
            if ("get".equals(namePart) || "set".equals(namePart) || "is".equals(namePart) || "create".equals(namePart) || !StringUtil.isJavaIdentifier((String)(name = namePart.toLowerCase() + s.substring(s.indexOf(namePart) + namePart.length())))) continue;
            results.add(name);
        }
        ArrayList arrayList = results;
        if (arrayList == null) {
            BasicIntroducedEntityInfoProvider.$$$reportNull$$$0(40);
        }
        return arrayList;
    }

    @NotNull
    private static String sanitizeJavaScriptIdentifier(@NotNull String name) {
        if (name == null) {
            BasicIntroducedEntityInfoProvider.$$$reportNull$$$0(41);
        }
        StringBuilder result2 = new StringBuilder();
        boolean capitalize = false;
        for (int i = 0; i < name.length(); ++i) {
            char ch = name.charAt(i);
            if (Character.isLetterOrDigit(ch) || ch == '$') {
                if (result2.length() == 0 && !Character.isJavaIdentifierStart(ch) && ch != '$') {
                    result2.append("_");
                }
                result2.append(capitalize ? Character.toUpperCase(ch) : ch);
                capitalize = false;
                continue;
            }
            capitalize = true;
        }
        String string = result2.toString();
        if (string == null) {
            BasicIntroducedEntityInfoProvider.$$$reportNull$$$0(42);
        }
        return string;
    }

    private static /* synthetic */ boolean lambda$processCandidates$4(@NotNull Processor processor, Set reported, JSParameterItem jsParameter) {
        if (processor == null) {
            BasicIntroducedEntityInfoProvider.$$$reportNull$$$0(43);
        }
        BasicIntroducedEntityInfoProvider.addName(jsParameter.getName(), (Processor<String>)processor, reported);
        return true;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 7: 
            case 11: 
            case 15: 
            case 16: 
            case 18: 
            case 19: 
            case 20: 
            case 25: 
            case 26: 
            case 31: 
            case 32: 
            case 40: 
            case 42: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 7: 
            case 11: 
            case 15: 
            case 16: 
            case 18: 
            case 19: 
            case 20: 
            case 25: 
            case 26: 
            case 31: 
            case 32: 
            case 40: 
            case 42: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "mainOccurrence";
                break;
            }
            case 1: 
            case 2: 
            case 29: 
            case 30: 
            case 41: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 3: 
            case 6: 
            case 9: 
            case 14: 
            case 21: 
            case 46: 
            case 48: {
                objectArray2 = objectArray3;
                objectArray3[0] = "existing";
                break;
            }
            case 7: 
            case 11: 
            case 15: 
            case 16: 
            case 18: 
            case 19: 
            case 20: 
            case 25: 
            case 26: 
            case 31: 
            case 32: 
            case 40: 
            case 42: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/javascript/refactoring/introduce/BasicIntroducedEntityInfoProvider";
                break;
            }
            case 10: 
            case 24: {
                objectArray2 = objectArray3;
                objectArray3[0] = "entityKind";
                break;
            }
            case 12: 
            case 33: 
            case 35: 
            case 37: 
            case 38: {
                objectArray2 = objectArray3;
                objectArray3[0] = "type";
                break;
            }
            case 13: 
            case 17: 
            case 44: 
            case 45: {
                objectArray2 = objectArray3;
                objectArray3[0] = "scope";
                break;
            }
            case 23: 
            case 27: 
            case 43: {
                objectArray2 = objectArray3;
                objectArray3[0] = "processor";
                break;
            }
            case 28: {
                objectArray2 = objectArray3;
                objectArray3[0] = "reported";
                break;
            }
            case 34: 
            case 36: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 39: {
                objectArray2 = objectArray3;
                objectArray3[0] = "s";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/javascript/refactoring/introduce/BasicIntroducedEntityInfoProvider";
                break;
            }
            case 7: 
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "generateVariableNamesFromExpression";
                break;
            }
            case 15: 
            case 16: {
                objectArray = objectArray2;
                objectArray2[1] = "generateVariableNamesFromType";
                break;
            }
            case 18: 
            case 19: 
            case 20: {
                objectArray = objectArray2;
                objectArray2[1] = "generateNamesForType";
                break;
            }
            case 25: 
            case 26: {
                objectArray = objectArray2;
                objectArray2[1] = "getKind";
                break;
            }
            case 31: 
            case 32: {
                objectArray = objectArray2;
                objectArray2[1] = "findExistingInScope";
                break;
            }
            case 40: {
                objectArray = objectArray2;
                objectArray2[1] = "generateNamesFromQualifiedName";
                break;
            }
            case 42: {
                objectArray = objectArray2;
                objectArray2[1] = "sanitizeJavaScriptIdentifier";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "checkConflicts";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "findExistingInScopeAndUp";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "showMemberAlreadyExists";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "generateVariableNameFromExpression";
                break;
            }
            case 5: 
            case 6: 
            case 8: 
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "generateVariableNamesFromExpression";
                break;
            }
            case 7: 
            case 11: 
            case 15: 
            case 16: 
            case 18: 
            case 19: 
            case 20: 
            case 25: 
            case 26: 
            case 31: 
            case 32: 
            case 40: 
            case 42: {
                break;
            }
            case 12: 
            case 13: 
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "generateVariableNamesFromType";
                break;
            }
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "generateNamesForType";
                break;
            }
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "generateUniqueVariableName";
                break;
            }
            case 22: 
            case 23: 
            case 24: {
                objectArray = objectArray;
                objectArray[2] = "processCandidates";
                break;
            }
            case 27: 
            case 28: {
                objectArray = objectArray;
                objectArray[2] = "addName";
                break;
            }
            case 29: {
                objectArray = objectArray;
                objectArray[2] = "findNamedElementInScope";
                break;
            }
            case 30: {
                objectArray = objectArray;
                objectArray[2] = "findExistingInScope";
                break;
            }
            case 33: 
            case 34: {
                objectArray = objectArray;
                objectArray[2] = "generateNameFromJSTypeOrNull";
                break;
            }
            case 35: 
            case 36: {
                objectArray = objectArray;
                objectArray[2] = "getNameForComplexType";
                break;
            }
            case 37: {
                objectArray = objectArray;
                objectArray[2] = "getNameFromIterableType";
                break;
            }
            case 38: {
                objectArray = objectArray;
                objectArray[2] = "getNameFromGenericType";
                break;
            }
            case 39: {
                objectArray = objectArray;
                objectArray[2] = "generateNamesFromQualifiedName";
                break;
            }
            case 41: {
                objectArray = objectArray;
                objectArray[2] = "sanitizeJavaScriptIdentifier";
                break;
            }
            case 43: {
                objectArray = objectArray;
                objectArray[2] = "lambda$processCandidates$4";
                break;
            }
            case 44: {
                objectArray = objectArray;
                objectArray[2] = "lambda$generateNamesForType$3";
                break;
            }
            case 45: 
            case 46: {
                objectArray = objectArray;
                objectArray[2] = "lambda$generateVariableNamesFromType$2";
                break;
            }
            case 47: 
            case 48: {
                objectArray = objectArray;
                objectArray[2] = "lambda$generateVariableNamesFromExpression$1";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 7: 
            case 11: 
            case 15: 
            case 16: 
            case 18: 
            case 19: 
            case 20: 
            case 25: 
            case 26: 
            case 31: 
            case 32: 
            case 40: 
            case 42: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    public static enum NamedEntityKind {
        Parameter,
        Field,
        Default;

    }
}

