/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.refactoring.introduceVariable;

import com.intellij.ide.util.PropertiesComponent;
import com.intellij.lang.javascript.DialectDetector;
import com.intellij.lang.javascript.DialectOptionHolder;
import com.intellij.lang.javascript.JSBundle;
import com.intellij.lang.javascript.JSLanguageDialect;
import com.intellij.lang.javascript.dialects.JSLanguageFeature;
import com.intellij.lang.javascript.psi.JSElement;
import com.intellij.lang.javascript.psi.JSExpression;
import com.intellij.lang.javascript.psi.JSExpressionStatement;
import com.intellij.lang.javascript.psi.JSFunction;
import com.intellij.lang.javascript.psi.JSFunctionExpression;
import com.intellij.lang.javascript.psi.JSRecursiveElementVisitor;
import com.intellij.lang.javascript.psi.JSSourceElement;
import com.intellij.lang.javascript.psi.JSThisExpression;
import com.intellij.lang.javascript.psi.JSVarStatement;
import com.intellij.lang.javascript.psi.ecmal4.JSClass;
import com.intellij.lang.javascript.psi.util.JSUtils;
import com.intellij.lang.javascript.refactoring.JSIntroduceTargetChooser;
import com.intellij.lang.javascript.refactoring.introduce.BasicIntroducedEntityInfoProvider;
import com.intellij.lang.javascript.refactoring.introduce.JSBaseInplaceIntroducer;
import com.intellij.lang.javascript.refactoring.introduce.JSBaseIntroduceHandler;
import com.intellij.lang.javascript.refactoring.introduceVariable.ASVariableInplaceIntroducer;
import com.intellij.lang.javascript.refactoring.introduceVariable.InplaceSettings;
import com.intellij.lang.javascript.refactoring.introduceVariable.JSIntroduceVariableDialog;
import com.intellij.lang.javascript.refactoring.introduceVariable.JSVariableInplaceIntroducer;
import com.intellij.lang.javascript.refactoring.introduceVariable.JSVariableInplaceIntroducerBase;
import com.intellij.lang.javascript.refactoring.introduceVariable.Settings;
import com.intellij.lang.typescript.refactoring.TypeScriptExtractNamedTypeHandler;
import com.intellij.lang.typescript.refactoring.TypeScriptExtractTypeAliasHandler;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiFile;
import com.intellij.refactoring.introduce.inplace.OccurrencesChooser;
import com.intellij.util.ArrayUtil;
import com.intellij.util.IncorrectOperationException;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JSIntroduceVariableHandler
extends JSBaseIntroduceHandler<JSSourceElement, Settings, JSIntroduceVariableDialog> {
    private final TypeScriptExtractNamedTypeHandler myExtractTypeAliasHandler;
    private static final String LAST_INTRODUCE = "js.last.introduce.type";

    public JSIntroduceVariableHandler(@NotNull JSIntroduceTargetChooser<JSExpression> introducedExpressionChooser) {
        if (introducedExpressionChooser == null) {
            JSIntroduceVariableHandler.$$$reportNull$$$0(0);
        }
        super(introducedExpressionChooser);
        this.myExtractTypeAliasHandler = new TypeScriptExtractTypeAliasHandler();
    }

    public JSIntroduceVariableHandler() {
        this.myExtractTypeAliasHandler = new TypeScriptExtractTypeAliasHandler();
    }

    public static boolean varTypeEnabled(@Nullable DialectOptionHolder holder, @NotNull Settings.IntroducedVarType type) {
        if (type == null) {
            JSIntroduceVariableHandler.$$$reportNull$$$0(1);
        }
        if (type == Settings.IntroducedVarType.LET) {
            return holder != null && holder.hasFeature(JSLanguageFeature.LET_DEFINITIONS);
        }
        if (type == Settings.IntroducedVarType.CONST) {
            return holder != null && holder.hasFeature(JSLanguageFeature.CONST_DEFINITIONS);
        }
        return true;
    }

    public static Settings.IntroducedVarType getLastIntroduceType(Project project, @Nullable DialectOptionHolder holder) {
        Settings.IntroducedVarType defaultValue = JSIntroduceVariableHandler.varTypeEnabled(holder, Settings.IntroducedVarType.LET) ? Settings.IntroducedVarType.LET : Settings.IntroducedVarType.VAR;
        String value = PropertiesComponent.getInstance((Project)project).getValue(LAST_INTRODUCE, defaultValue.name());
        Settings.IntroducedVarType storedValue = Settings.IntroducedVarType.valueOf(value);
        return JSIntroduceVariableHandler.varTypeEnabled(holder, storedValue) ? storedValue : defaultValue;
    }

    public static void setLastIntroduceType(Project project, Settings.IntroducedVarType value) {
        PropertiesComponent.getInstance((Project)project).setValue(LAST_INTRODUCE, value.name());
    }

    @Override
    protected String getProductivityFeatureId() {
        return "refactoring.introduceVariable";
    }

    @Override
    protected String getRefactoringName() {
        return JSBundle.message((String)"javascript.introduce.variable.title", (Object[])new Object[0]);
    }

    @Override
    protected String getCannotIntroduceVoidExpressionTypeMessagePropertyKey() {
        return "javascript.introduce.variable.error.expression.has.void.type";
    }

    @Override
    protected String getCannotIntroduceMessagePropertyKey() {
        return "javascript.introduce.variable.error.no.expression.selected";
    }

    @Override
    protected String getDeclText(JSBaseIntroduceHandler.BaseIntroduceContext<Settings> baseIntroduceContext, JSSourceElement anchor) {
        return this.calcDeclText(baseIntroduceContext, ((Settings)baseIntroduceContext.settings).getIntroducedVarType().toString().toLowerCase(), anchor);
    }

    @Override
    protected JSElement getElementForContextTypeCheck(JSBaseIntroduceHandler.BaseIntroduceContext<Settings> baseIntroduceContext, JSSourceElement anchor) {
        return DialectDetector.isActionScript((PsiElement)anchor) ? super.getElementForContextTypeCheck(baseIntroduceContext, anchor) : anchor;
    }

    @Override
    public void invoke(@NotNull Project project, Editor editor, PsiFile file, DataContext dataContext) {
        if (project == null) {
            JSIntroduceVariableHandler.$$$reportNull$$$0(2);
        }
        if (this.myExtractTypeAliasHandler.isAvailableOnEditorAndFile(editor, file)) {
            this.myExtractTypeAliasHandler.invoke(project, editor, file, dataContext);
            return;
        }
        super.invoke(project, editor, file, dataContext);
    }

    @Override
    protected JSBaseInplaceIntroducer<Settings> createInplaceIntroducer(JSBaseIntroduceHandler.BaseIntroduceContext<Settings> context, JSElement scope, Editor editor, Project project, JSExpression[] occurrences) {
        JSExpression first = (JSExpression)context.expressionDescriptor.first;
        if (first.getParent() instanceof JSExpressionStatement) {
            for (int i = 0; i < occurrences.length; ++i) {
                if (occurrences[i] != first) continue;
                occurrences = (JSExpression[])ArrayUtil.remove((Object[])occurrences, (int)i);
                break;
            }
        }
        return this.createJSorASInplaceIntroducer(context, scope, editor, project, occurrences);
    }

    @NotNull
    protected JSBaseInplaceIntroducer<Settings> createJSorASInplaceIntroducer(JSBaseIntroduceHandler.BaseIntroduceContext<Settings> context, JSElement scope, Editor editor, Project project, JSExpression[] occurrences) {
        JSVariableInplaceIntroducerBase jSVariableInplaceIntroducerBase = DialectDetector.isActionScript((PsiElement)scope) ? new ASVariableInplaceIntroducer(project, editor, occurrences, this, context) : new JSVariableInplaceIntroducer(project, editor, occurrences, this, context);
        if (jSVariableInplaceIntroducerBase == null) {
            JSIntroduceVariableHandler.$$$reportNull$$$0(3);
        }
        return jSVariableInplaceIntroducerBase;
    }

    @Override
    protected JSIntroduceVariableDialog createDialog(Project project, JSExpression expression, JSExpression[] occurrences, PsiElement scope) {
        return new JSIntroduceVariableDialog(project, occurrences, expression, scope);
    }

    @Override
    protected InplaceSettings<Settings> getInplaceSettings(Pair<JSExpression, TextRange> expr, JSExpression[] occurrences, final PsiElement scope, final OccurrencesChooser.ReplaceChoice choice) {
        BasicIntroducedEntityInfoProvider entityInfoProvider = new BasicIntroducedEntityInfoProvider((JSExpression)expr.first, occurrences, scope);
        final String[] candidateNames = entityInfoProvider.suggestCandidateNames();
        final String myIntroducedName = candidateNames.length > 0 ? candidateNames[0].trim() : "newVar";
        return new InplaceSettings<Settings>(){

            @Override
            public String[] getSuggestedNames() {
                return candidateNames;
            }

            @Override
            public Settings getSettings() {
                return new Settings(){

                    @Override
                    public boolean isReplaceAllOccurrences() {
                        return choice == OccurrencesChooser.ReplaceChoice.ALL;
                    }

                    @Override
                    public String getVariableName() {
                        return myIntroducedName;
                    }

                    @Override
                    public String getVariableType() {
                        return null;
                    }

                    @Override
                    public Settings.IntroducedVarType getIntroducedVarType() {
                        return JSIntroduceVariableHandler.this.getDefaultIntroduceType(scope);
                    }
                };
            }
        };
    }

    protected Settings.IntroducedVarType getDefaultIntroduceType(PsiElement scope) {
        DialectOptionHolder holder = DialectDetector.dialectOfElement(scope);
        Settings.IntroducedVarType type = JSIntroduceVariableHandler.getLastIntroduceType(scope.getProject(), holder);
        if (type == Settings.IntroducedVarType.LET && holder != null && !holder.hasFeature(JSLanguageFeature.LET_DEFINITIONS)) {
            return Settings.IntroducedVarType.VAR;
        }
        return type;
    }

    @Override
    protected Pair<JSVarStatement, Boolean> prepareDeclaration(String varDeclText, JSBaseIntroduceHandler.BaseIntroduceContext<Settings> introduceContext, Project project, @Nullable JSLanguageDialect languageDialect, JSSourceElement sourceElement, Editor editor, JSExpression introducedExpression) throws IncorrectOperationException {
        Pair<JSVarStatement, Boolean> preparedDeclarationStatus = super.prepareDeclaration(varDeclText, introduceContext, project, languageDialect, sourceElement, editor, introducedExpression);
        JSVarStatement declaration = (JSVarStatement)preparedDeclarationStatus.first;
        if (sourceElement == introducedExpression.getParent() && sourceElement instanceof JSExpressionStatement && !JSIntroduceVariableHandler.isIntroducingPartOfExpression(introduceContext.expressionDescriptor)) {
            declaration = (JSVarStatement)sourceElement.replace((PsiElement)declaration);
            editor.getCaretModel().moveToOffset(declaration.getTextRange().getEndOffset());
            return Pair.create((Object)declaration, (Object)Boolean.TRUE);
        }
        return preparedDeclarationStatus;
    }

    @Override
    protected boolean validateSelectedExpression(@NotNull PsiFile file, @NotNull Editor editor, @NotNull Pair<JSExpression, TextRange> expressionDescriptor) {
        JSSourceElement anchor;
        if (file == null) {
            JSIntroduceVariableHandler.$$$reportNull$$$0(4);
        }
        if (editor == null) {
            JSIntroduceVariableHandler.$$$reportNull$$$0(5);
        }
        if (expressionDescriptor == null) {
            JSIntroduceVariableHandler.$$$reportNull$$$0(6);
        }
        if (!super.validateSelectedExpression(file, editor, expressionDescriptor)) {
            return false;
        }
        JSExpression expression = (JSExpression)expressionDescriptor.first;
        if (DialectDetector.isActionScript((PsiElement)expression)) {
            return true;
        }
        final Ref isContextDependExpression = Ref.create((Object)false);
        expression.accept((PsiElementVisitor)new JSRecursiveElementVisitor(){

            public void visitJSThisExpression(JSThisExpression node) {
                isContextDependExpression.set((Object)true);
            }

            public void visitJSFunctionDeclaration(JSFunction node) {
            }

            public void visitJSFunctionExpression(JSFunctionExpression node) {
            }
        });
        if (((Boolean)isContextDependExpression.get()).booleanValue() && (anchor = JSUtils.findSourceAnchor((PsiElement)expression, false)) instanceof JSClass) {
            this.showErrorHint(editor, file, JSBundle.message((String)"javascript.introduce.incorrect.context", (Object[])new Object[0]));
            return false;
        }
        return true;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 3: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 3: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "introducedExpressionChooser";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "type";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/javascript/refactoring/introduceVariable/JSIntroduceVariableHandler";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "editor";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "expressionDescriptor";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/javascript/refactoring/introduceVariable/JSIntroduceVariableHandler";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "createJSorASInplaceIntroducer";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "varTypeEnabled";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "invoke";
                break;
            }
            case 3: {
                break;
            }
            case 4: 
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "validateSelectedExpression";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 3: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

