/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.refactoring.util;

import com.intellij.lang.javascript.DialectDetector;
import com.intellij.lang.javascript.psi.JSFile;
import com.intellij.lang.javascript.psi.JSReferenceExpression;
import com.intellij.lang.javascript.psi.JSType;
import com.intellij.lang.javascript.psi.JSTypeUtils;
import com.intellij.lang.javascript.psi.e4x.JSE4XNamespaceReference;
import com.intellij.lang.javascript.psi.ecmal4.JSAttributeListOwner;
import com.intellij.lang.javascript.psi.ecmal4.JSClass;
import com.intellij.lang.javascript.psi.ecmal4.JSNamespaceDeclaration;
import com.intellij.lang.javascript.psi.ecmal4.JSQualifiedNamedElement;
import com.intellij.lang.javascript.psi.ecmal4.XmlBackedJSClass;
import com.intellij.lang.javascript.psi.ecmal4.impl.JSPackageWrapper;
import com.intellij.lang.javascript.psi.impl.JSReferenceExpressionImpl;
import com.intellij.lang.javascript.psi.resolve.JSInheritanceUtil;
import com.intellij.lang.javascript.psi.resolve.JSResolveUtil;
import com.intellij.lang.javascript.psi.types.JSContext;
import com.intellij.lang.javascript.psi.types.JSNamedType;
import com.intellij.lang.javascript.psi.types.JSTypeSource;
import com.intellij.lang.javascript.psi.types.JSTypeSourceFactory;
import com.intellij.lang.javascript.psi.util.JSUtils;
import com.intellij.lang.javascript.refactoring.util.JSMemberUsageInfo;
import com.intellij.lang.javascript.refactoring.util.JSRefactoringUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiNamedElement;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.usageView.UsageInfo;
import java.util.Collection;
import java.util.HashSet;
import org.jetbrains.annotations.Nullable;

public class ActionScriptRefactoringUtil {
    private ActionScriptRefactoringUtil() {
    }

    public static Collection<PsiFile> qualifyIncomingReferences(UsageInfo[] usages) {
        HashSet<PsiFile> filesWithUsages = new HashSet<PsiFile>();
        for (UsageInfo usageInfo : usages) {
            JSMemberUsageInfo usage = (JSMemberUsageInfo)usageInfo;
            PsiFile file = usage.getElement().getContainingFile();
            XmlBackedJSClass xmlBackedClass = JSResolveUtil.getXmlBackedClass((JSFile)file);
            filesWithUsages.add(xmlBackedClass != null ? xmlBackedClass.getContainingFile() : file);
            JSRefactoringUtil.makeQualified((JSReferenceExpression)usage.getElement(), (JSQualifiedNamedElement)usage.qualifierClass, false);
        }
        return filesWithUsages;
    }

    public static PsiElement fixOutgoingReferences(PsiElement scope, Collection<String> imports, Collection<String> namespaces, Collection<JSAttributeListOwner> membersToMove, @Nullable JSClass targetClass, boolean justCollectImports, boolean visibilityWillChange) {
        JSReferenceExpression refExpr;
        PsiElement resolved;
        if (scope != null && !DialectDetector.isActionScript(scope)) {
            return scope;
        }
        if (scope instanceof JSReferenceExpression && (resolved = (refExpr = (JSReferenceExpression)scope).resolve()) instanceof JSQualifiedNamedElement) {
            String qName;
            JSNamespaceDeclaration namespaceDecl;
            boolean isReferenceToMovedMember = JSRefactoringUtil.isChildOfAny(resolved, membersToMove);
            if (!(PsiTreeUtil.isAncestor((PsiElement)resolved, (PsiElement)refExpr, (boolean)false) || isReferenceToMovedMember && visibilityWillChange || (namespaceDecl = JSRefactoringUtil.getNamespace(resolved)) == null)) {
                qName = namespaceDecl.getQualifiedName();
                JSE4XNamespaceReference namespaceRef = (JSE4XNamespaceReference)PsiTreeUtil.getChildOfType((PsiElement)refExpr, JSE4XNamespaceReference.class);
                if (!"AS3".equals(qName)) {
                    if (namespaceRef == null) {
                        namespaces.add(qName);
                    }
                    if (qName.indexOf(46) != -1) {
                        imports.add(qName);
                    }
                }
            }
            if (!isReferenceToMovedMember || resolved instanceof JSClass) {
                PsiElement r;
                JSClass containingClass = JSUtils.getMemberContainingClass(resolved);
                if (containingClass == null) {
                    JSType type = JSNamedType.createType(((JSQualifiedNamedElement)resolved).getQualifiedName(), JSTypeSourceFactory.createTypeSource(resolved), JSContext.INSTANCE);
                    if (JSTypeUtils.isActionScriptVectorType(type)) {
                        ActionScriptRefactoringUtil.processChildren((PsiElement)refExpr, imports, namespaces, membersToMove, targetClass, justCollectImports, visibilityWillChange);
                        return refExpr;
                    }
                    String qName2 = type.getTypeText();
                    if (qName2.indexOf(46) != -1) {
                        imports.add(qName2);
                    }
                    if (!justCollectImports && refExpr.getQualifier() == null && !(refExpr.getParent() instanceof JSE4XNamespaceReference)) {
                        refExpr = JSReferenceExpressionImpl.bindToElement(refExpr, qName2, (PsiNamedElement)resolved, true);
                    }
                    return refExpr;
                }
                if (JSResolveUtil.isConstructorFunction(resolved) && JSTypeUtils.isActionScriptVectorType(JSNamedType.createType(containingClass.getQualifiedName(), JSTypeSource.EMPTY, JSContext.INSTANCE))) {
                    ActionScriptRefactoringUtil.processChildren((PsiElement)refExpr, imports, namespaces, membersToMove, targetClass, justCollectImports, visibilityWillChange);
                } else if (refExpr.getQualifier() == null) {
                    if (targetClass == null || !JSInheritanceUtil.isParentClass(targetClass, containingClass, false)) {
                        qName = containingClass.getQualifiedName();
                        if (!justCollectImports) {
                            String packageName;
                            Object bindTo = JSResolveUtil.isConstructorFunction(resolved) ? ((packageName = StringUtil.getPackageName((String)qName)).isEmpty() ? null : new JSPackageWrapper(packageName, containingClass.getProject(), null)) : containingClass;
                            JSRefactoringUtil.makeQualified(refExpr, (JSQualifiedNamedElement)bindTo, false);
                        }
                        if (qName.indexOf(46) != -1) {
                            imports.add(qName);
                        }
                        return refExpr;
                    }
                } else if (refExpr.getQualifier() instanceof JSReferenceExpression && (r = ((JSReferenceExpression)refExpr.getQualifier()).resolve()) instanceof JSClass && targetClass != null && JSInheritanceUtil.isParentClass(targetClass, (JSClass)r, false)) {
                    if (!justCollectImports) {
                        JSRefactoringUtil.makeQualified(refExpr, null, false);
                    }
                    return refExpr;
                }
            }
        }
        ActionScriptRefactoringUtil.processChildren(scope, imports, namespaces, membersToMove, targetClass, justCollectImports, visibilityWillChange);
        return scope;
    }

    private static void processChildren(PsiElement scope, Collection<String> imports, Collection<String> namespaces, Collection<JSAttributeListOwner> membersToMove, JSClass targetClass, boolean justCollectImports, boolean visibilityWillChange) {
        for (PsiElement child = scope.getFirstChild(); child != null; child = child.getNextSibling()) {
            child = ActionScriptRefactoringUtil.fixOutgoingReferences(child, imports, namespaces, membersToMove, targetClass, justCollectImports, visibilityWillChange);
        }
    }

    public static boolean isValidClassName(String name, boolean acceptFqn) {
        if (StringUtil.isEmptyOrSpaces((String)name)) {
            return false;
        }
        if (acceptFqn) {
            return name.trim().matches("[\\p{Alpha}][\\p{Alnum}_]*(\\.[\\p{Alpha}][\\p{Alnum}_]*)*");
        }
        return name.trim().matches("[\\p{Alpha}][\\p{Alnum}_]*");
    }
}

