/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.validation;

import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.lang.javascript.DialectDetector;
import com.intellij.lang.javascript.JSAnalysisHandlersFactory;
import com.intellij.lang.javascript.JSBundle;
import com.intellij.lang.javascript.JSElementTypes;
import com.intellij.lang.javascript.JSKeywordSets;
import com.intellij.lang.javascript.documentation.JSDocumentationUtils;
import com.intellij.lang.javascript.highlighting.JSFixFactory;
import com.intellij.lang.javascript.psi.JSArgumentList;
import com.intellij.lang.javascript.psi.JSAssignmentExpression;
import com.intellij.lang.javascript.psi.JSBinaryExpression;
import com.intellij.lang.javascript.psi.JSCallExpression;
import com.intellij.lang.javascript.psi.JSConditionalExpression;
import com.intellij.lang.javascript.psi.JSElement;
import com.intellij.lang.javascript.psi.JSElementVisitor;
import com.intellij.lang.javascript.psi.JSExpression;
import com.intellij.lang.javascript.psi.JSFieldVariable;
import com.intellij.lang.javascript.psi.JSFunction;
import com.intellij.lang.javascript.psi.JSFunctionExpression;
import com.intellij.lang.javascript.psi.JSNamedElement;
import com.intellij.lang.javascript.psi.JSNewExpression;
import com.intellij.lang.javascript.psi.JSParameterList;
import com.intellij.lang.javascript.psi.JSParameterListElement;
import com.intellij.lang.javascript.psi.JSPostfixExpression;
import com.intellij.lang.javascript.psi.JSPrefixExpression;
import com.intellij.lang.javascript.psi.JSProperty;
import com.intellij.lang.javascript.psi.JSPsiNamedElementBase;
import com.intellij.lang.javascript.psi.JSReferenceExpression;
import com.intellij.lang.javascript.psi.JSReturnStatement;
import com.intellij.lang.javascript.psi.JSType;
import com.intellij.lang.javascript.psi.JSTypeUtils;
import com.intellij.lang.javascript.psi.JSVariable;
import com.intellij.lang.javascript.psi.ecmal4.JSClass;
import com.intellij.lang.javascript.psi.impl.JSPsiImplUtils;
import com.intellij.lang.javascript.psi.resolve.JSResolveUtil;
import com.intellij.lang.javascript.psi.resolve.JSTypeEvaluator;
import com.intellij.lang.javascript.psi.types.JSAnyType;
import com.intellij.lang.javascript.psi.types.JSTypeSourceFactory;
import com.intellij.lang.javascript.validation.JSAnnotatingVisitor;
import com.intellij.lang.javascript.validation.JSFunctionSignatureChecker;
import com.intellij.lang.javascript.validation.JSTypeChecker;
import com.intellij.lang.javascript.validation.ValidateTypesUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.ResolveResult;
import com.intellij.psi.tree.IElementType;
import org.jetbrains.annotations.NotNull;

public class JSTypeInspectionVisitor
extends JSElementVisitor {
    @NotNull
    protected final ProblemsHolder myHolder;

    public JSTypeInspectionVisitor(@NotNull ProblemsHolder holder) {
        if (holder == null) {
            JSTypeInspectionVisitor.$$$reportNull$$$0(0);
        }
        this.myHolder = holder;
    }

    protected boolean isAcceptable(@NotNull PsiElement element) {
        if (element == null) {
            JSTypeInspectionVisitor.$$$reportNull$$$0(1);
        }
        return !DialectDetector.isTypeScript(element) && !DialectDetector.isFlow(element);
    }

    public void visitElement(PsiElement element) {
        IElementType elementType;
        JSNamedElement namedElement;
        if (!this.isAcceptable(element)) {
            return;
        }
        if (JSKeywordSets.IDENTIFIER_NAMES.contains(element.getNode().getElementType()) && (namedElement = JSPsiImplUtils.findElementFromNameIdentifier(element)) instanceof JSFunction && JSElementTypes.FUNCTION_DECLARATIONS.contains(elementType = namedElement.getNode().getElementType())) {
            this.checkFunctionDeclaration((JSFunction)namedElement);
        }
    }

    public void visitJSCallExpression(JSCallExpression node) {
        if (this.isAcceptable((PsiElement)node)) {
            this.checkIsCallable(node);
        }
    }

    protected boolean checkIsCallable(@NotNull JSCallExpression node) {
        JSExpression methodExpression;
        if (node == null) {
            JSTypeInspectionVisitor.$$$reportNull$$$0(2);
        }
        if ((methodExpression = node.getMethodExpression()) instanceof JSReferenceExpression) {
            JSReferenceExpression referenceExpression = (JSReferenceExpression)methodExpression;
            ResolveResult[] resolveResults = referenceExpression.multiResolve(false);
            boolean hasValidResolveResult = false;
            boolean hasCallableElement = false;
            for (ResolveResult r : resolveResults) {
                if (!r.isValidResult()) continue;
                hasValidResolveResult = true;
                PsiElement element = r.getElement();
                JSType jsType = JSTypeUtils.getTypeOfElement(element);
                if (element instanceof JSFieldVariable) {
                    jsType = JSTypeEvaluator.getTypeFromTypeGuard((JSPsiNamedElementBase)((JSFieldVariable)element), referenceExpression, jsType, element);
                }
                if (!this.getFunctionSignatureChecker((PsiElement)node).processMethodExpressionResolveResult(node, referenceExpression, element, jsType)) {
                    return true;
                }
                if (jsType != null && jsType.getSource().isStrict() && !this.getFunctionSignatureChecker((PsiElement)node).isCallableType(node instanceof JSNewExpression, jsType) && (element == null || JSPsiImplUtils.calculatePossibleFunction(element, (PsiElement)methodExpression) == null)) continue;
                hasCallableElement = true;
                break;
            }
            if (hasValidResolveResult && !hasCallableElement) {
                PsiElement function;
                boolean isProperty;
                LocalQuickFix[] fixes = LocalQuickFix.EMPTY_ARRAY;
                JSArgumentList argumentList = node.getArgumentList();
                boolean bl = isProperty = resolveResults.length == 1 && (function = resolveResults[0].getElement()) instanceof JSFunction && ((JSFunction)function).isGetProperty();
                if (argumentList != null && isProperty) {
                    fixes = new LocalQuickFix[]{JSFixFactory.getInstance().removeASTNodeFix("javascript.term.does.not.evaluate.to.function2.fix", argumentList.getNode())};
                }
                this.getTypeChecker((PsiElement)node).registerProblem(referenceExpression.getReferenceNameElement(), JSBundle.message((String)(isProperty ? "javascript.term.does.not.evaluate.to.function2" : "javascript.term.does.not.evaluate.to.function"), (Object[])new Object[0]), ValidateTypesUtil.getHighlightTypeForTypeOrSignatureProblem((PsiElement)node), fixes);
                return false;
            }
        }
        return true;
    }

    protected JSTypeChecker getTypeChecker(@NotNull PsiElement context) {
        if (context == null) {
            JSTypeInspectionVisitor.$$$reportNull$$$0(3);
        }
        return JSAnalysisHandlersFactory.forElement(context).getTypeChecker(this.myHolder);
    }

    @NotNull
    protected JSFunctionSignatureChecker getFunctionSignatureChecker(@NotNull PsiElement context) {
        if (context == null) {
            JSTypeInspectionVisitor.$$$reportNull$$$0(4);
        }
        JSFunctionSignatureChecker jSFunctionSignatureChecker = JSAnalysisHandlersFactory.forElement(context).getFunctionSignatureChecker(this.myHolder);
        if (jSFunctionSignatureChecker == null) {
            JSTypeInspectionVisitor.$$$reportNull$$$0(5);
        }
        return jSFunctionSignatureChecker;
    }

    public void visitJSConditionalExpression(JSConditionalExpression node) {
        if (!this.isAcceptable((PsiElement)node)) {
            return;
        }
        ValidateTypesUtil.checkTypesInConditionalExpr(node, this.getTypeChecker((PsiElement)node));
    }

    public void visitJSPrefixExpression(JSPrefixExpression node) {
        if (!this.isAcceptable((PsiElement)node)) {
            return;
        }
        ValidateTypesUtil.checkNumericTypesInUnaryOperation(node.getOperationSign(), node.getExpression(), this.getTypeChecker((PsiElement)node));
    }

    public void visitJSPostfixExpression(JSPostfixExpression node) {
        if (!this.isAcceptable((PsiElement)node)) {
            return;
        }
        ValidateTypesUtil.checkNumericTypesInUnaryOperation(node.getOperationSign(), node.getExpression(), this.getTypeChecker((PsiElement)node));
    }

    public void visitJSProperty(JSProperty node) {
        if (!this.isAcceptable((PsiElement)node)) {
            return;
        }
        String type = JSDocumentationUtils.findType((PsiElement)node);
        JSExpression value = node.getValue();
        if (type != null && value != null) {
            JSType jsType = JSTypeUtils.createType(type, JSTypeSourceFactory.createTypeSource((PsiElement)node, true));
            this.getTypeChecker((PsiElement)node).checkExpressionIsAssignableToType(value, jsType, "javascript.initializer.type.mismatch", (PsiElement)node, true);
        }
    }

    public void visitJSReturnStatement(JSReturnStatement node) {
        if (!this.isAcceptable((PsiElement)node)) {
            return;
        }
        this.getTypeChecker((PsiElement)node).checkTypesInReturnStatement((JSElement)node);
    }

    public void visitJSVariable(JSVariable node) {
        if (!this.isAcceptable((PsiElement)node)) {
            return;
        }
        JSExpression initializer = node.getInitializer();
        if (initializer == null) {
            return;
        }
        this.getTypeChecker((PsiElement)node).checkExpressionIsAssignableToVariable(node, initializer, node.getContainingFile(), "javascript.initializer.type.mismatch", true);
    }

    public void visitJSBinaryExpression(JSBinaryExpression node) {
        if (!this.isAcceptable((PsiElement)node)) {
            return;
        }
        ValidateTypesUtil.checkTypesInBinaryExpression(node, this.getTypeChecker((PsiElement)node));
    }

    public void visitJSAssignmentExpression(JSAssignmentExpression node) {
        if (!this.isAcceptable((PsiElement)node)) {
            return;
        }
        ValidateTypesUtil.checkTypesInAssignment(node, this.getTypeChecker((PsiElement)node));
    }

    protected void checkGetterAndSetter(@NotNull JSFunction function) {
        if (function == null) {
            JSTypeInspectionVisitor.$$$reportNull$$$0(6);
        }
        if (function.isSetProperty()) {
            JSFunction getter;
            PsiElement element;
            JSParameterListElement[] params;
            JSParameterList parameterList = function.getParameterList();
            JSParameterListElement[] jSParameterListElementArray = params = parameterList != null ? parameterList.getParameters() : JSParameterListElement.EMPTY_ARRAY;
            if (params.length == 1 && (element = JSResolveUtil.findParent((PsiElement)function)) instanceof JSClass && !JSAnnotatingVisitor.isBindable((JSClass)element) && (getter = ((JSClass)element).findFunctionByNameAndKind(function.getName(), JSFunction.FunctionKind.GETTER)) != null) {
                JSType retType = getter.getReturnType();
                JSType setterType = params[0].getType();
                this.validateSetter(function, getter, params[0], setterType, retType);
            }
        }
    }

    protected void checkFunctionDeclaration(@NotNull JSFunction function) {
        if (function == null) {
            JSTypeInspectionVisitor.$$$reportNull$$$0(7);
        }
        this.checkGetterAndSetter(function);
    }

    public void visitJSFunctionExpression(JSFunctionExpression node) {
        if (!this.isAcceptable((PsiElement)node)) {
            return;
        }
        JSExpression returnExpression = JSPsiImplUtils.tryGetArrowFunctionReturnExpression((JSFunction)node);
        if (returnExpression != null) {
            this.getTypeChecker((PsiElement)node).checkTypesInReturnStatement((JSElement)returnExpression);
        }
        this.checkGetterAndSetter((JSFunction)node);
    }

    protected void validateSetter(@NotNull JSFunction setter, @NotNull JSFunction getter, JSParameterListElement param, JSType setterType, JSType retType) {
        if (setter == null) {
            JSTypeInspectionVisitor.$$$reportNull$$$0(8);
        }
        if (getter == null) {
            JSTypeInspectionVisitor.$$$reportNull$$$0(9);
        }
        if (!(setterType instanceof JSAnyType || retType instanceof JSAnyType || JSTypeUtils.areTypesCompatible(setterType, retType, null, (PsiElement)setter))) {
            PsiElement typeElement = param.getTypeElement();
            this.getTypeChecker((PsiElement)setter).registerProblem((PsiElement)(typeElement != null ? typeElement : param), JSBundle.message((String)"javascript.validation.message.set.method.type.is.different.from.getter", (Object[])new Object[]{retType != null ? retType.getTypeText(JSType.TypeTextFormat.PRESENTABLE) : "empty"}), ValidateTypesUtil.getHighlightTypeForTypeOrSignatureProblem((PsiElement)setter), new LocalQuickFix[0]);
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 5: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 5: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "holder";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "node";
                break;
            }
            case 3: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/javascript/validation/JSTypeInspectionVisitor";
                break;
            }
            case 6: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "function";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "setter";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "getter";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/javascript/validation/JSTypeInspectionVisitor";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getFunctionSignatureChecker";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "isAcceptable";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "checkIsCallable";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "getTypeChecker";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "getFunctionSignatureChecker";
                break;
            }
            case 5: {
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "checkGetterAndSetter";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "checkFunctionDeclaration";
                break;
            }
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "validateSetter";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 5: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

