/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.validation.fixes;

import com.intellij.codeInsight.FileModificationService;
import com.intellij.codeInsight.intention.IntentionAction;
import com.intellij.codeInsight.template.Expression;
import com.intellij.codeInsight.template.Macro;
import com.intellij.codeInsight.template.Template;
import com.intellij.codeInsight.template.TemplateManager;
import com.intellij.codeInsight.template.impl.MacroCallNode;
import com.intellij.codeInsight.template.macro.CompleteMacro;
import com.intellij.lang.javascript.JSBundle;
import com.intellij.lang.javascript.formatter.JSCodeStyleSettings;
import com.intellij.lang.javascript.psi.JSBlockStatement;
import com.intellij.lang.javascript.psi.JSFunction;
import com.intellij.lang.javascript.psi.JSParameterListElement;
import com.intellij.lang.javascript.psi.JSSourceElement;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.util.IncorrectOperationException;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class AddSuperInvocationFix
implements IntentionAction {
    private final JSFunction myConstructor;
    private final JSFunction mySuperConstructor;

    public AddSuperInvocationFix(JSFunction constructor, @Nullable JSFunction superConstructor) {
        this.myConstructor = constructor;
        this.mySuperConstructor = superConstructor;
    }

    @NotNull
    public String getText() {
        String string = JSBundle.message((String)"javascript.fix.create.invoke.super", (Object[])new Object[0]);
        if (string == null) {
            AddSuperInvocationFix.$$$reportNull$$$0(0);
        }
        return string;
    }

    @NotNull
    public String getFamilyName() {
        String string = this.getText();
        if (string == null) {
            AddSuperInvocationFix.$$$reportNull$$$0(1);
        }
        return string;
    }

    public boolean isAvailable(@NotNull Project project, Editor editor, PsiFile file) {
        if (project == null) {
            AddSuperInvocationFix.$$$reportNull$$$0(2);
        }
        return (this.mySuperConstructor == null || this.mySuperConstructor.isValid()) && this.myConstructor.isValid();
    }

    public void invoke(@NotNull Project project, Editor editor, PsiFile file) throws IncorrectOperationException {
        if (project == null) {
            AddSuperInvocationFix.$$$reportNull$$$0(3);
        }
        if (!FileModificationService.getInstance().prepareFileForWrite(file)) {
            return;
        }
        TemplateManager templateManager = TemplateManager.getInstance((Project)project);
        Template template = templateManager.createTemplate("", "");
        template.setToReformat(true);
        if (this.myConstructor == null) {
            return;
        }
        AddSuperInvocationFix.addToTemplate(template, (PsiElement)this.myConstructor, this.mySuperConstructor);
        JSSourceElement[] body = this.myConstructor.getBody();
        if (body.length > 0 && body[0] instanceof JSBlockStatement) {
            PsiElement firstChild = body[0].getFirstChild();
            editor.getCaretModel().moveToOffset(firstChild.getTextRange().getEndOffset());
            TemplateManager.getInstance((Project)project).startTemplate(editor, template);
        }
    }

    public static void addToTemplate(@NotNull Template template, @NotNull PsiElement context, @Nullable JSFunction superConstructor) {
        JSParameterListElement[] parameters;
        if (template == null) {
            AddSuperInvocationFix.$$$reportNull$$$0(4);
        }
        if (context == null) {
            AddSuperInvocationFix.$$$reportNull$$$0(5);
        }
        template.addTextSegment("super(");
        boolean first = true;
        for (JSParameterListElement p : parameters = superConstructor != null ? superConstructor.getParameters() : JSParameterListElement.EMPTY_ARRAY) {
            if (p.isRest()) break;
            if (!first) {
                template.addTextSegment(", ");
            }
            first = false;
            template.addVariable((Expression)new MacroCallNode((Macro)new CompleteMacro()), true);
        }
        template.addTextSegment(")");
        String s = JSCodeStyleSettings.getSemicolon((PsiElement)context.getContainingFile());
        template.addTextSegment(s);
        template.addEndVariable();
    }

    public boolean startInWriteAction() {
        return false;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/javascript/validation/fixes/AddSuperInvocationFix";
                break;
            }
            case 2: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "template";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getText";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getFamilyName";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/javascript/validation/fixes/AddSuperInvocationFix";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "isAvailable";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "invoke";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "addToTemplate";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

