/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.validation.fixes;

import com.intellij.codeInsight.FileModificationService;
import com.intellij.codeInsight.lookup.LookupElement;
import com.intellij.codeInsight.template.Expression;
import com.intellij.codeInsight.template.ExpressionContext;
import com.intellij.codeInsight.template.Result;
import com.intellij.codeInsight.template.Template;
import com.intellij.codeInsight.template.TemplateManager;
import com.intellij.codeInsight.template.TextResult;
import com.intellij.codeInsight.template.impl.MacroCallNode;
import com.intellij.codeInsight.template.macro.MacroFactory;
import com.intellij.injected.editor.EditorWindow;
import com.intellij.lang.ASTNode;
import com.intellij.lang.Language;
import com.intellij.lang.javascript.DialectDetector;
import com.intellij.lang.javascript.DialectOptionHolder;
import com.intellij.lang.javascript.JSTokenTypes;
import com.intellij.lang.javascript.JavaScriptSupportLoader;
import com.intellij.lang.javascript.flex.ImportUtils;
import com.intellij.lang.javascript.flex.XmlBackedJSClassImpl;
import com.intellij.lang.javascript.formatter.JSCodeStyleSettings;
import com.intellij.lang.javascript.library.JSLibraryUtil;
import com.intellij.lang.javascript.psi.JSArgumentList;
import com.intellij.lang.javascript.psi.JSAssignmentExpression;
import com.intellij.lang.javascript.psi.JSBinaryExpression;
import com.intellij.lang.javascript.psi.JSCallExpression;
import com.intellij.lang.javascript.psi.JSDefinitionExpression;
import com.intellij.lang.javascript.psi.JSExpression;
import com.intellij.lang.javascript.psi.JSExpressionStatement;
import com.intellij.lang.javascript.psi.JSField;
import com.intellij.lang.javascript.psi.JSFile;
import com.intellij.lang.javascript.psi.JSFunction;
import com.intellij.lang.javascript.psi.JSNewExpression;
import com.intellij.lang.javascript.psi.JSParameter;
import com.intellij.lang.javascript.psi.JSParameterItem;
import com.intellij.lang.javascript.psi.JSPostfixExpression;
import com.intellij.lang.javascript.psi.JSPrefixExpression;
import com.intellij.lang.javascript.psi.JSReferenceExpression;
import com.intellij.lang.javascript.psi.JSReturnStatement;
import com.intellij.lang.javascript.psi.JSSourceElement;
import com.intellij.lang.javascript.psi.JSThisExpression;
import com.intellij.lang.javascript.psi.JSType;
import com.intellij.lang.javascript.psi.JSTypeEvaluationResult;
import com.intellij.lang.javascript.psi.JSTypeUtils;
import com.intellij.lang.javascript.psi.JSVarStatement;
import com.intellij.lang.javascript.psi.JSVariable;
import com.intellij.lang.javascript.psi.ecma6.ES6Decorator;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptEnum;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptInterface;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptModule;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptObjectType;
import com.intellij.lang.javascript.psi.ecmal4.JSAttributeList;
import com.intellij.lang.javascript.psi.ecmal4.JSClass;
import com.intellij.lang.javascript.psi.ecmal4.JSImportStatement;
import com.intellij.lang.javascript.psi.ecmal4.JSPackageStatement;
import com.intellij.lang.javascript.psi.ecmal4.XmlBackedJSClass;
import com.intellij.lang.javascript.psi.ecmal4.XmlBackedJSClassFactory;
import com.intellij.lang.javascript.psi.impl.JSPsiImplUtils;
import com.intellij.lang.javascript.psi.resolve.JSClassResolver;
import com.intellij.lang.javascript.psi.resolve.JSImportHandlingUtil;
import com.intellij.lang.javascript.psi.resolve.JSResolveUtil;
import com.intellij.lang.javascript.psi.resolve.JSSimpleTypeProcessor;
import com.intellij.lang.javascript.psi.resolve.JSTypeEvaluator;
import com.intellij.lang.javascript.psi.types.JSArrayType;
import com.intellij.lang.javascript.psi.types.JSGenericTypeImpl;
import com.intellij.lang.javascript.psi.types.JSNamedType;
import com.intellij.lang.javascript.psi.types.JSResolvableType;
import com.intellij.lang.javascript.psi.types.JSResolvedTypeInfo;
import com.intellij.lang.javascript.psi.types.JSSimpleRecordTypeImpl;
import com.intellij.lang.javascript.psi.util.JSClassUtils;
import com.intellij.lang.javascript.psi.util.JSProjectUtil;
import com.intellij.lang.javascript.psi.util.JSStubBasedPsiTreeUtil;
import com.intellij.lang.javascript.psi.util.JSUtils;
import com.intellij.lang.javascript.ui.JSFormatUtil;
import com.intellij.lang.javascript.validation.fixes.FixAndIntentionAction;
import com.intellij.lang.typescript.formatter.TypeScriptCodeStyleSettings;
import com.intellij.lang.typescript.resolve.TypeScriptClassResolver;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.WriteAction;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.ScrollType;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.fileEditor.OpenFileDescriptor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiComment;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiWhiteSpace;
import com.intellij.psi.impl.source.xml.XmlTextImpl;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.xml.XmlAttribute;
import com.intellij.psi.xml.XmlAttributeValue;
import com.intellij.psi.xml.XmlFile;
import com.intellij.psi.xml.XmlTag;
import com.intellij.psi.xml.XmlText;
import com.intellij.psi.xml.XmlToken;
import com.intellij.psi.xml.XmlTokenType;
import com.intellij.util.Function;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.xml.XmlElementDescriptor;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class BaseCreateFix
extends FixAndIntentionAction {
    private static final String SCRIPT_TAG_NAME = "Script";
    private static final Function<PsiElement, Boolean> ourFilter = psiElement -> BaseCreateFix.toSkipElement(psiElement);
    private static final Function<PsiElement, Boolean> ourEnumFilter = psiElement -> psiElement instanceof PsiComment;
    private int uniqueCounter;

    @Override
    protected void applyFix(Project project, PsiElement psiElement, PsiFile file, Editor editor) {
        this.doApplyFix(project, psiElement, file, editor);
    }

    protected final void doApplyFix(Project project, PsiElement psiElement, PsiFile file, Editor editor) {
        this.doApplyFix(project, psiElement, file, editor, null, null);
    }

    protected final void doApplyFix(Project project, PsiElement psiElement, PsiFile file, Editor editor, @Nullable PsiElement predefinedAnchor, @Nullable PsiElement predefinedScope) {
        Pair<JSReferenceExpression, PsiElement> anchor = this.calculateAnchors(psiElement);
        JSReferenceExpression referenceExpression = (JSReferenceExpression)anchor.first;
        PsiElement nodeForAnchor = (PsiElement)anchor.second;
        PsiFile realFile = file;
        if (file.getContext() != null) {
            realFile = file.getContext().getContainingFile();
            Editor editor2 = editor = editor instanceof EditorWindow ? ((EditorWindow)editor).getDelegate() : editor;
        }
        assert (psiElement instanceof XmlAttribute || referenceExpression != null);
        JSExpression qualifier = referenceExpression == null ? null : referenceExpression.getQualifier();
        boolean canHaveClasses = JSClassUtils.canHaveClasses((PsiElement)file);
        if (qualifier != null && canHaveClasses || psiElement instanceof XmlAttribute) {
            XmlTag tag;
            XmlElementDescriptor descriptor2;
            PsiElement type = psiElement instanceof XmlAttribute ? ((descriptor2 = (tag = (XmlTag)psiElement.getParent()).getDescriptor()) == null ? null : descriptor2.getDeclaration()) : BaseCreateFix.getType(qualifier, file);
            if (type == null && DialectDetector.isActionScript((PsiElement)file)) {
                return;
            }
            if (type != null) {
                if (type instanceof XmlBackedJSClass) {
                    type = type.getParent().getContainingFile();
                }
                editor = null;
                if (type instanceof JSClass || type instanceof TypeScriptObjectType || type instanceof TypeScriptModule) {
                    realFile = file = type.getContainingFile();
                    predefinedAnchor = this.findInsertionAnchorForClass(type);
                } else if (type instanceof JSFile) {
                    realFile = file = (JSFile)type;
                    predefinedAnchor = null;
                    nodeForAnchor = file;
                    predefinedScope = file;
                } else if (type instanceof XmlFile) {
                    realFile = file = type.getContainingFile();
                    predefinedAnchor = type;
                }
            }
        }
        if (!FileModificationService.getInstance().prepareFileForWrite(realFile)) {
            return;
        }
        if (editor == null) {
            editor = BaseCreateFix.getEditor(project, realFile);
        }
        if (editor == null) {
            return;
        }
        boolean fieldLevel = psiElement instanceof XmlAttribute || canHaveClasses && this.produceDeclarationOnClassLevel(predefinedAnchor == null ? psiElement : predefinedAnchor);
        PsiElement initialAnchor = (PsiElement)ObjectUtils.coalesce((Object)predefinedAnchor, (Object)JSUtils.findStatementAnchor(nodeForAnchor, realFile), (Object)nodeForAnchor);
        PsiElement scope = BaseCreateFix.getInsertionScope(predefinedScope, initialAnchor, fieldLevel);
        initialAnchor = PsiTreeUtil.findFirstParent((PsiElement)initialAnchor, el -> el.getParent() == scope || el == scope);
        InsertPlaceInfo insertPlaceInfo = new InsertPlaceInfo(initialAnchor, realFile, fieldLevel, this.isIntroducingVariable());
        if (insertPlaceInfo.anchor != null) {
            boolean isStatic = canHaveClasses && BaseCreateFix.isStatic(psiElement, qualifier);
            referenceExpression = this.beforeStartTemplateAction(referenceExpression, editor, insertPlaceInfo.anchor, isStatic);
            TemplateManager templateManager = TemplateManager.getInstance((Project)project);
            Template template = templateManager.createTemplate("", "");
            template.setToReformat(true);
            if (insertPlaceInfo.addNewLineBefore) {
                template.addTextSegment("\n");
            }
            this.buildTemplate(template, referenceExpression, isStatic, file, scope);
            if (insertPlaceInfo.toInsertNewLineAfter) {
                template.addTextSegment("\n");
            }
            int offset = BaseCreateFix.calculateOffset(file, realFile, insertPlaceInfo);
            BaseCreateFix.navigate(project, editor, offset, realFile.getVirtualFile());
            templateManager.startTemplate(editor, template);
        }
    }

    @Nullable
    private static PsiElement getInsertionScope(@Nullable PsiElement predefinedScope, @NotNull PsiElement initialAnchor, boolean isFieldLevel) {
        if (initialAnchor == null) {
            BaseCreateFix.$$$reportNull$$$0(0);
        }
        if (predefinedScope != null) {
            return predefinedScope;
        }
        if (isFieldLevel) {
            return PsiTreeUtil.getParentOfType((PsiElement)initialAnchor, (Class[])new Class[]{JSClass.class, TypeScriptObjectType.class, JSFile.class, TypeScriptModule.class});
        }
        return initialAnchor.getParent();
    }

    protected JSReferenceExpression beforeStartTemplateAction(JSReferenceExpression referenceExpression, Editor editor, PsiElement anchor, boolean isStaticContext) {
        return referenceExpression;
    }

    private static boolean isStatic(PsiElement psiElement, JSExpression qualifier) {
        if (PsiTreeUtil.getParentOfType((PsiElement)psiElement, ES6Decorator.class) != null) {
            return true;
        }
        if (qualifier != null) {
            if (qualifier instanceof JSReferenceExpression) {
                PsiElement qualifierResolve = ((JSReferenceExpression)qualifier).resolve();
                PsiElement target = qualifierResolve != null ? JSStubBasedPsiTreeUtil.calculateMeaningfulElement(qualifierResolve) : null;
                return target instanceof JSClass && !(target instanceof TypeScriptEnum) || target instanceof XmlFile;
            }
            if (qualifier instanceof JSThisExpression && JSClassUtils.isES6ClassImplementation(psiElement)) {
                return JSResolveUtil.calculateStaticFromContext(psiElement);
            }
            return false;
        }
        return JSResolveUtil.calculateStaticFromContext(psiElement);
    }

    private static int calculateOffset(PsiFile file, PsiFile realFile, InsertPlaceInfo insertPlaceInfo) {
        int offset;
        TextRange anchorRange = insertPlaceInfo.anchor.getTextRange();
        int n = offset = insertPlaceInfo.insertAtEnd ? anchorRange.getEndOffset() : anchorRange.getStartOffset();
        if (file != realFile || file instanceof XmlFile) {
            PsiFile anchorContainingFile = insertPlaceInfo.anchor.getContainingFile();
            PsiElement anchorFileContext = anchorContainingFile.getContext();
            if (anchorFileContext != null) {
                if (anchorFileContext instanceof XmlText) {
                    if (insertPlaceInfo.cdataStartOffset != 0) {
                        offset += insertPlaceInfo.cdataStartOffset;
                    } else {
                        int cdataOffset = 0;
                        if (anchorFileContext instanceof XmlTextImpl && anchorFileContext.getText().contains("<![CDATA[")) {
                            XmlTextImpl containingText = (XmlTextImpl)anchorFileContext;
                            cdataOffset = containingText.getCDATAInterior().getStartOffset() - "<![CDATA[".length();
                        }
                        offset += ((XmlText)anchorFileContext).displayToPhysical(cdataOffset);
                    }
                }
                offset += anchorFileContext.getTextOffset();
            } else if (insertPlaceInfo.cdataStartOffset != 0) {
                offset = insertPlaceInfo.cdataStartOffset;
            }
        }
        return offset;
    }

    protected boolean produceDeclarationOnClassLevel(PsiElement element) {
        JSSourceElement type = (JSSourceElement)PsiTreeUtil.getParentOfType((PsiElement)element, (Class[])new Class[]{JSPackageStatement.class, JSClass.class});
        if (DialectDetector.isActionScript(element)) {
            return !(type instanceof JSPackageStatement);
        }
        return type instanceof JSClass || PsiTreeUtil.getParentOfType((PsiElement)element, TypeScriptObjectType.class) != null;
    }

    @NotNull
    protected Pair<JSReferenceExpression, PsiElement> calculateAnchors(PsiElement psiElement) {
        JSReferenceExpression expression = (JSReferenceExpression)PsiTreeUtil.getNonStrictParentOfType((PsiElement)psiElement, (Class[])new Class[]{JSReferenceExpression.class});
        Pair pair = new Pair((Object)expression, (Object)expression);
        if (pair == null) {
            BaseCreateFix.$$$reportNull$$$0(1);
        }
        return pair;
    }

    public static void navigate(@NotNull Project project, @NotNull Editor editor, int offset, VirtualFile vfile) {
        if (project == null) {
            BaseCreateFix.$$$reportNull$$$0(2);
        }
        if (editor == null) {
            BaseCreateFix.$$$reportNull$$$0(3);
        }
        if (ApplicationManager.getApplication().isHeadlessEnvironment()) {
            editor.getCaretModel().moveToOffset(offset);
        } else {
            new OpenFileDescriptor(project, vfile, offset).navigate(true);
            editor.getScrollingModel().scrollToCaret(ScrollType.RELATIVE);
        }
    }

    private PsiElement findInsertionAnchorForClass(PsiElement jsClass) {
        PsiElement element;
        PsiElement candidate;
        ASTNode next;
        ASTNode node;
        PsiElement elementContainer = jsClass;
        if (jsClass instanceof TypeScriptInterface && DialectDetector.isTypeScript(jsClass)) {
            elementContainer = ((TypeScriptInterface)jsClass).getBody();
        }
        if (this.isIntroducingVariable() && (node = elementContainer.getNode().findChildByType(JSTokenTypes.LBRACE)) != null && (next = node.getTreeNext()) != null && (candidate = JSFormatUtil.findInsertionPlaceStartingFrom(element = next.getPsi(), false, elementContainer instanceof TypeScriptEnum ? ourEnumFilter : ourFilter)) != null) {
            return candidate;
        }
        return elementContainer.getLastChild().getPrevSibling();
    }

    private static boolean doesNotContainNewline(PsiElement nextLeaf) {
        return !(nextLeaf instanceof PsiWhiteSpace) && !(nextLeaf instanceof XmlToken) || nextLeaf.getText().indexOf(10) == -1;
    }

    protected boolean isIntroducingVariable() {
        return false;
    }

    private static PsiElement findInsertionPlaceBackward(PsiElement anchor) {
        ASTNode node;
        PsiElement anchorPrevSibling;
        while (!((anchorPrevSibling = anchor.getPrevSibling()) == null || anchorPrevSibling instanceof JSVarStatement || anchorPrevSibling instanceof JSImportStatement || (node = anchorPrevSibling.getNode()) != null && node.getElementType() == JSTokenTypes.LBRACE)) {
            anchor = anchorPrevSibling;
        }
        return anchor;
    }

    private static boolean toSkipElement(PsiElement nextSibling) {
        return nextSibling instanceof PsiComment || nextSibling instanceof JSImportStatement || nextSibling instanceof JSVarStatement;
    }

    @Nullable
    public static Editor getEditor(@NotNull Project project, @NotNull PsiFile realFile) {
        if (project == null) {
            BaseCreateFix.$$$reportNull$$$0(4);
        }
        if (realFile == null) {
            BaseCreateFix.$$$reportNull$$$0(5);
        }
        return FileEditorManager.getInstance((Project)project).openTextEditor(new OpenFileDescriptor(project, realFile.getVirtualFile(), 0), true);
    }

    protected abstract void buildTemplate(Template var1, JSReferenceExpression var2, boolean var3, PsiFile var4, PsiElement var5);

    @Nullable
    public static PsiElement resolveElementForQualifier(@NotNull JSReferenceExpression qualifier) {
        PsiElement resolvedElement;
        if (qualifier == null) {
            BaseCreateFix.$$$reportNull$$$0(6);
        }
        if ((resolvedElement = qualifier.resolve()) != null) {
            return JSStubBasedPsiTreeUtil.calculateMeaningfulElement(resolvedElement);
        }
        return null;
    }

    protected static PsiElement getType(JSExpression passedParameterValue, PsiFile file) {
        PsiElement sourceElement;
        JSSimpleTypeProcessor processor = new JSSimpleTypeProcessor();
        JSTypeEvaluator.evaluateTypes(passedParameterValue, file, processor);
        JSTypeEvaluationResult result2 = processor.getResult();
        JSType type = result2 != null ? result2.getType() : null;
        PsiElement source = processor.getSource();
        if (type != null && !(source instanceof JSClass) && !(source instanceof XmlFile)) {
            source = JSClassResolver.findClassFromNamespace(type.getTypeText(), (PsiElement)file);
        }
        DialectOptionHolder dialect = DialectDetector.dialectOfElement((PsiElement)file);
        if (type == null && source == null && dialect != null && !dialect.isECMA4 && passedParameterValue instanceof JSReferenceExpression) {
            return BaseCreateFix.resolveElementForQualifier((JSReferenceExpression)passedParameterValue);
        }
        if (type instanceof JSSimpleRecordTypeImpl && ((sourceElement = type.getSource().getSourceElement()) instanceof JSClass || sourceElement instanceof TypeScriptObjectType)) {
            return sourceElement;
        }
        if (type != null && source == null && dialect != null && dialect.isTypeScript) {
            JSResolvedTypeInfo info;
            List<JSClass> names = TypeScriptClassResolver.getInstance().findClassesByQName(type.getResolvedTypeText(), JSResolveUtil.getResolveScope((PsiElement)file));
            for (JSClass name : names) {
                if (!name.getContainingFile().isEquivalentTo((PsiElement)file)) continue;
                return name;
            }
            if (names.size() == 0 && type instanceof JSResolvableType && (info = ((JSResolvableType)type).resolveType()) != null) {
                JSClass classDeclaration = info.getDeclarationOfType(JSClass.class);
                if (classDeclaration != null) {
                    return classDeclaration;
                }
                TypeScriptModule module = info.getDeclarationOfType(TypeScriptModule.class);
                if (module != null) {
                    return module;
                }
                return null;
            }
            return (PsiElement)ContainerUtil.getFirstItem(names);
        }
        return source;
    }

    protected void addAccessModifier(Template template, JSReferenceExpression referenceExpression, PsiFile file, boolean staticContext, JSClass contextClass) {
        JSExpression qualifier = referenceExpression.getQualifier();
        if (JSClassUtils.canHaveClasses((PsiElement)file)) {
            boolean isConstructor = referenceExpression.getParent() instanceof JSNewExpression;
            JSClass classOfContextRef = JSResolveUtil.getClassOfContext((PsiElement)referenceExpression);
            if (!isConstructor && contextClass != null && !DialectDetector.isJavaScript((PsiElement)contextClass) && (qualifier == null || qualifier instanceof JSThisExpression || classOfContextRef != null && staticContext && qualifier instanceof JSReferenceExpression && StringUtil.equals((CharSequence)((JSReferenceExpression)qualifier).getReferenceName(), (CharSequence)classOfContextRef.getName()))) {
                template.addTextSegment("private ");
            } else if (DialectDetector.isActionScript((PsiElement)file)) {
                if (contextClass != null && !contextClass.isInterface()) {
                    JSAttributeList attributeList = contextClass.getAttributeList();
                    if (attributeList != null && attributeList.getAccessType() == JSAttributeList.AccessType.PUBLIC || classOfContextRef != null && JSPsiImplUtils.differentPackageName(JSResolveUtil.getPackageName((PsiElement)contextClass), JSResolveUtil.getPackageName((PsiElement)classOfContextRef))) {
                        template.addTextSegment("public ");
                    } else {
                        template.addTextSegment("internal ");
                    }
                }
            } else if (DialectDetector.isTypeScript((PsiElement)file) && contextClass != null && !contextClass.isInterface() && TypeScriptCodeStyleSettings.getTypeScriptSettings((Project)file.getProject()).USE_PUBLIC_MODIFIER) {
                template.addTextSegment("public ");
            }
            if (staticContext && (DialectDetector.isActionScript((PsiElement)referenceExpression) || contextClass != null)) {
                template.addTextSegment("static ");
            }
        }
    }

    protected void addCompletionVar(Template template) {
        MacroCallNode paramTypeExpr = new MacroCallNode(MacroFactory.createMacro((String)"complete"));
        template.addVariable("__Type" + this.uniqueCounter++, (Expression)paramTypeExpr, (Expression)paramTypeExpr, true);
    }

    protected void addSemicolonSegment(Template template, PsiFile file) {
        String semicolon = JSCodeStyleSettings.getSemicolon((PsiElement)file);
        if (semicolon.length() > 0) {
            template.addTextSegment(semicolon);
        }
    }

    public static void addTypeVariable(Template template, String var, PsiElement context, String typeName) {
        String type = (String)WriteAction.compute(() -> (String)ImportUtils.importAndShortenReference((String)typeName, (PsiElement)context, (boolean)true, (boolean)true).first);
        MyExpression paramTypeExpr = new MyExpression(type);
        template.addVariable(var + "Type", (Expression)paramTypeExpr, (Expression)paramTypeExpr, true);
    }

    protected void guessTypeAndAddTemplateVariable(Template template, JSExpression referenceExpression, PsiFile file, boolean voidAllowed) {
        String type = BaseCreateFix.guessTypeForExpression(referenceExpression, file, voidAllowed);
        if (type == null) {
            this.addCompletionVar(template);
        } else {
            MyExpression expression = new MyExpression(type);
            template.addVariable("__type" + referenceExpression.getText(), (Expression)expression, (Expression)expression, true);
        }
    }

    public static String guessTypeForExpression(JSExpression referenceExpression, PsiFile file, boolean voidAllowed) {
        JSType jsType;
        PsiElement parent = referenceExpression.getParent();
        boolean isCall = false;
        if (parent instanceof JSCallExpression) {
            isCall = true;
            parent = parent.getParent();
        }
        String type = null;
        JSExpression elementForWhichExprTypeToEvaluate = null;
        if (parent instanceof JSDefinitionExpression) {
            PsiElement grandParent = parent.getParent();
            if (grandParent instanceof JSAssignmentExpression) {
                elementForWhichExprTypeToEvaluate = ((JSAssignmentExpression)grandParent).getROperand();
            }
        } else if (parent instanceof JSReturnStatement) {
            JSFunction fun = (JSFunction)PsiTreeUtil.getParentOfType((PsiElement)referenceExpression, JSFunction.class);
            if (fun != null) {
                JSType returnType = fun.getReturnType();
                type = BaseCreateFix.isNamedType(returnType) ? JSImportHandlingUtil.resolveTypeName(JSTypeUtils.getTypeMatchingNamespace(returnType.getTypeText()), (PsiElement)fun) : (returnType == null ? null : returnType.getTypeText(JSType.TypeTextFormat.CODE));
            }
        } else if (parent instanceof JSExpressionStatement && voidAllowed) {
            type = "void";
        } else if (parent instanceof JSVariable) {
            JSVariable variable = (JSVariable)parent;
            type = BaseCreateFix.getPossibleTypeText(parent, variable.getType());
        } else if (parent instanceof JSArgumentList) {
            JSParameterItem parameter = JSResolveUtil.findParameterForUsedArgument(isCall ? (JSExpression)referenceExpression.getParent() : referenceExpression, (JSArgumentList)parent);
            if (parameter instanceof JSParameter && !parameter.isRest()) {
                JSParameter jsParameter = (JSParameter)parameter;
                type = BaseCreateFix.getPossibleTypeText((PsiElement)jsParameter, jsParameter.getType());
            }
        } else if (parent instanceof JSAssignmentExpression) {
            JSExpression lOperand = ((JSAssignmentExpression)parent).getLOperand();
            if (lOperand != null) {
                jsType = JSResolveUtil.getExpressionJSType(lOperand);
                type = jsType == null ? null : BaseCreateFix.getTypeText(jsType);
            }
        } else if (parent instanceof JSPrefixExpression) {
            type = BaseCreateFix.getNumberTypeForPrefixSuffixIncrement(file, type, ((JSPrefixExpression)parent).getOperationSign());
        } else if (parent instanceof JSPostfixExpression) {
            type = BaseCreateFix.getNumberTypeForPrefixSuffixIncrement(file, type, ((JSPostfixExpression)parent).getOperationSign());
        } else if (parent instanceof JSBinaryExpression) {
            JSBinaryExpression binOp = (JSBinaryExpression)parent;
            elementForWhichExprTypeToEvaluate = binOp.getLOperand() == referenceExpression ? binOp.getROperand() : binOp.getLOperand();
        } else if (referenceExpression instanceof JSReferenceExpression) {
            elementForWhichExprTypeToEvaluate = referenceExpression;
        }
        String expressionType = null;
        if (elementForWhichExprTypeToEvaluate != null) {
            jsType = JSResolveUtil.getExpressionJSType(elementForWhichExprTypeToEvaluate);
            String string = expressionType = jsType == null ? null : BaseCreateFix.getTypeText(jsType);
        }
        if (expressionType != null && !expressionType.equals("*")) {
            type = expressionType;
        }
        if (type != null && file.getLanguage().is((Language)JavaScriptSupportLoader.ECMA_SCRIPT_L4)) {
            type = type.endsWith("[]") ? "Array" : (String)ImportUtils.importAndShortenReference((String)type, (PsiElement)referenceExpression, (boolean)true, (boolean)true).first;
        }
        return type;
    }

    @Nullable
    private static String getPossibleTypeText(@NotNull PsiElement context, JSType variableType) {
        if (context == null) {
            BaseCreateFix.$$$reportNull$$$0(7);
        }
        if (BaseCreateFix.isNamedType(variableType)) {
            if (DialectDetector.isTypeScript(context)) {
                return variableType.getTypeText(JSType.TypeTextFormat.CODE);
            }
            String typeText = variableType.getTypeText();
            return JSImportHandlingUtil.resolveTypeName(typeText, context);
        }
        return null;
    }

    private static boolean isNamedType(JSType variableType) {
        return variableType instanceof JSNamedType || variableType instanceof JSGenericTypeImpl || variableType instanceof JSArrayType;
    }

    private static String getNumberTypeForPrefixSuffixIncrement(@Nullable PsiFile file, @Nullable String type, @Nullable IElementType operationSign) {
        if (operationSign == JSTokenTypes.PLUSPLUS || operationSign == JSTokenTypes.MINUSMINUS) {
            DialectOptionHolder holder = DialectDetector.dialectOfElement((PsiElement)file);
            if (holder == null) {
                return "Number";
            }
            if (holder.isECMA4) {
                return "int";
            }
            if (holder.isTypeScript) {
                return "number";
            }
            return "Number";
        }
        return type;
    }

    @Nullable
    protected static PsiElement findClass(PsiElement anchorParent) {
        if (anchorParent instanceof JSClass) {
            return (JSClass)anchorParent;
        }
        if (anchorParent instanceof TypeScriptObjectType) {
            PsiElement parent = anchorParent.getParent();
            if (parent instanceof JSClass) {
                return (JSClass)parent;
            }
            return anchorParent;
        }
        if (anchorParent instanceof JSFile) {
            return JSResolveUtil.getXmlBackedClass((JSFile)anchorParent);
        }
        return null;
    }

    @Override
    protected boolean isAvailable(Project project, PsiElement element, Editor editor, PsiFile file) {
        DialectOptionHolder dialect = DialectDetector.dialectOfElement(element);
        if (dialect != null && (dialect.isECMA4 || dialect.isTypeScript)) {
            JSExpression qualifier;
            Pair<JSReferenceExpression, PsiElement> anchor = this.calculateAnchors(element);
            JSExpression jSExpression = qualifier = anchor.first == null ? null : ((JSReferenceExpression)anchor.first).getQualifier();
            if (qualifier != null) {
                PsiElement toCheck;
                PsiElement type = BaseCreateFix.getType(qualifier, file);
                Object object = toCheck = qualifier instanceof JSThisExpression && type == null ? qualifier : type;
                if (toCheck == null || dialect.isECMA4 && JSProjectUtil.isInLibrary(toCheck)) {
                    return false;
                }
                if (dialect.isTypeScript) {
                    PsiFile containingFile = toCheck.getContainingFile();
                    if (containingFile == null) {
                        return false;
                    }
                    VirtualFile virtualFile = containingFile.getVirtualFile();
                    return virtualFile != null && !JSLibraryUtil.isProbableLibraryFile(virtualFile);
                }
            }
        }
        return true;
    }

    public static String getTypeText(JSType type) {
        if (type instanceof JSResolvableType) {
            type = ((JSResolvableType)type).copyAsWidened();
        }
        type = JSTypeUtils.expandEnumLiteralIfNeeded(type);
        return type.getTypeText(JSType.TypeTextFormat.CODE);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "initialAnchor";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/javascript/validation/fixes/BaseCreateFix";
                break;
            }
            case 2: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "editor";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "realFile";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "qualifier";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/javascript/validation/fixes/BaseCreateFix";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "calculateAnchors";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getInsertionScope";
                break;
            }
            case 1: {
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "navigate";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "getEditor";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "resolveElementForQualifier";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "getPossibleTypeText";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    public static class MyExpression
    extends Expression {
        TextResult result;
        private final String myVar1;

        public MyExpression(String var1) {
            this.myVar1 = var1;
            this.result = new TextResult(this.myVar1);
        }

        public Result calculateResult(ExpressionContext context) {
            return this.result;
        }

        public Result calculateQuickResult(ExpressionContext context) {
            return this.result;
        }

        public LookupElement[] calculateLookupItems(ExpressionContext context) {
            return LookupElement.EMPTY_ARRAY;
        }
    }

    public static class InsertPlaceInfo {
        public PsiElement anchor;
        public boolean insertAtEnd;
        public boolean toInsertNewLineAfter;
        public boolean addNewLineBefore;
        public int cdataStartOffset;

        public InsertPlaceInfo(PsiElement initialAnchor, PsiFile file, boolean fieldLevel, boolean isFieldOrVariable) {
            this.anchor = initialAnchor;
            if (this.anchor != null && fieldLevel) {
                PsiElement anchorParent = this.anchor.getParent();
                XmlFile contextFile = null;
                if (anchorParent instanceof JSFile && anchorParent.getContext() != null) {
                    PsiElement context = anchorParent.getContext();
                    if (context instanceof XmlAttributeValue || context instanceof XmlText && !BaseCreateFix.SCRIPT_TAG_NAME.equals(((XmlTag)context.getParent()).getLocalName())) {
                        contextFile = (XmlFile)context.getContainingFile();
                    }
                } else if (file instanceof XmlFile) {
                    contextFile = (XmlFile)file;
                }
                if (contextFile != null) {
                    XmlTag rootTag = contextFile.getDocument().getRootTag();
                    XmlBackedJSClass jsClass = XmlBackedJSClassFactory.getInstance().getXmlBackedClass(rootTag);
                    JSFile jsFile = ((XmlBackedJSClassImpl)jsClass).findFirstScriptTag();
                    if (jsFile != null) {
                        this.anchor = isFieldOrVariable ? JSFormatUtil.findInsertionPlaceStartingFrom(jsFile.getFirstChild(), true, (Function<PsiElement, Boolean>)ourFilter) : jsFile.getLastChild();
                    } else {
                        this.anchor = (PsiElement)WriteAction.compute(() -> InsertPlaceInfo.lambda$new$0((JSClass)jsClass));
                        this.insertAtEnd = true;
                    }
                } else if (anchorParent instanceof JSClass || anchorParent instanceof TypeScriptObjectType || anchorParent instanceof JSFile && anchorParent.getContext() != null) {
                    if (isFieldOrVariable) {
                        this.anchor = BaseCreateFix.findInsertionPlaceBackward(this.anchor);
                    } else {
                        this.insertAtEnd = true;
                    }
                }
            }
            boolean bl = this.toInsertNewLineAfter = !this.insertAtEnd;
            if (!this.toInsertNewLineAfter) {
                PsiElement nextLeaf = PsiTreeUtil.nextLeaf((PsiElement)this.anchor);
                if (nextLeaf != null && nextLeaf.getNode() != null && nextLeaf.getNode().getElementType() == XmlTokenType.XML_CDATA_START) {
                    this.cdataStartOffset += nextLeaf.getTextRange().getEndOffset() + 1;
                }
                if (BaseCreateFix.doesNotContainNewline(nextLeaf)) {
                    this.toInsertNewLineAfter = true;
                }
            } else if (!BaseCreateFix.doesNotContainNewline(this.anchor)) {
                this.toInsertNewLineAfter = false;
            }
            if (!this.insertAtEnd && this.anchor instanceof PsiWhiteSpace && this.anchor.textToCharArray()[0] == '\n') {
                this.addNewLineBefore = true;
                this.toInsertNewLineAfter = false;
            }
            if (!this.insertAtEnd && this.anchor instanceof PsiWhiteSpace) {
                int at = this.anchor.getText().indexOf("<![CDATA[");
                if (at != -1) {
                    this.cdataStartOffset += at + "<!CDATA[".length() + 1;
                    this.addNewLineBefore = true;
                } else if (this.anchor.getPrevSibling() == null && this.anchor.getContainingFile().getContext() != null) {
                    this.addNewLineBefore = true;
                }
            }
            if (this.insertAtEnd && this.anchor instanceof XmlToken && ((XmlToken)this.anchor).getTokenType() == XmlTokenType.XML_CDATA_START) {
                this.addNewLineBefore = true;
            }
            if (fieldLevel) {
                if (this.anchor instanceof PsiWhiteSpace && BaseCreateFix.doesNotContainNewline(this.anchor)) {
                    PsiElement prevSibling = this.anchor.getPrevSibling();
                    if (prevSibling != null && !(prevSibling instanceof PsiWhiteSpace)) {
                        this.addNewLineBefore = true;
                    }
                } else if (this.insertAtEnd && (this.anchor instanceof JSVarStatement || this.anchor instanceof JSField)) {
                    this.addNewLineBefore = true;
                }
            }
        }

        private static /* synthetic */ PsiElement lambda$new$0(JSClass jsClass) throws RuntimeException {
            return PsiTreeUtil.firstChild((PsiElement)((XmlBackedJSClassImpl)jsClass).createScriptTag().getContext());
        }
    }
}

