/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.validation.fixes;

import com.intellij.lang.javascript.JSBundle;
import com.intellij.lang.javascript.psi.JSCallExpression;
import com.intellij.lang.javascript.psi.JSExpression;
import com.intellij.lang.javascript.psi.JSFunction;
import com.intellij.lang.javascript.psi.JSReferenceExpression;
import com.intellij.lang.javascript.psi.ecmal4.JSSuperExpression;
import com.intellij.lang.javascript.psi.impl.JSChangeUtil;
import com.intellij.lang.javascript.refactoring.changeSignature.JSParameterInfo;
import com.intellij.lang.javascript.ui.JSFormatUtil;
import com.intellij.lang.javascript.validation.fixes.ChangeSignatureFix;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.SmartPointerManager;
import com.intellij.psi.SmartPsiElementPointer;
import com.intellij.util.IncorrectOperationException;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class ChangeSignatureWithDelegationUpdateFix
extends ChangeSignatureFix {
    private final SmartPsiElementPointer<JSCallExpression> myNode;
    private final String myCallName;

    public ChangeSignatureWithDelegationUpdateFix(JSFunction function, List<JSParameterInfo> parameterInfos, JSCallExpression node) {
        super(function, parameterInfos);
        this.myNode = SmartPointerManager.createPointer((PsiElement)node);
        JSExpression methodExpression = node.getMethodExpression();
        this.myCallName = methodExpression instanceof JSReferenceExpression || methodExpression instanceof JSSuperExpression ? "'" + methodExpression.getText() + "'" : JSBundle.message((String)"change.method.signature.delegating.default.text", (Object[])new Object[0]);
    }

    @Override
    public void invoke(PsiElement context) throws IncorrectOperationException {
        super.invoke(context);
        ApplicationManager.getApplication().runWriteAction(() -> {
            JSCallExpression element = (JSCallExpression)this.myNode.getElement();
            assert (element != null);
            JSExpression[] arguments = element.getArguments();
            JSExpression expression = element.getMethodExpression();
            StringBuilder builder = new StringBuilder(expression.getText());
            builder.append('(');
            for (JSExpression arg : arguments) {
                builder.append(arg.getText());
                builder.append(',');
            }
            for (int i = arguments.length; i < this.myParamInfos.size(); ++i) {
                builder.append(((JSParameterInfo)this.myParamInfos.get(i)).getName());
                if (i >= this.myParamInfos.size() - 1) continue;
                builder.append(',');
            }
            builder.append(')');
            JSChangeUtil.replaceExpression((JSExpression)element, (JSExpression)JSChangeUtil.createExpressionWithContext(builder.toString(), (PsiElement)element).getPsi());
        });
    }

    @Override
    @NotNull
    public String getText() {
        JSFunction function = (JSFunction)this.myFunction.getElement();
        if (function == null) {
            String string = JSBundle.message((String)"change.method.signature.and.update.delegating.call.noname.fix.text", (Object[])new Object[]{this.myCallName});
            if (string == null) {
                ChangeSignatureWithDelegationUpdateFix.$$$reportNull$$$0(0);
            }
            return string;
        }
        String string = JSBundle.message((String)"change.method.signature.and.update.delegating.call.fix.text", (Object[])new Object[]{JSFormatUtil.formatMethod(function, 4353, 0, 0, null), this.myCallName});
        if (string == null) {
            ChangeSignatureWithDelegationUpdateFix.$$$reportNull$$$0(1);
        }
        return string;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/validation/fixes/ChangeSignatureWithDelegationUpdateFix", "getText"));
    }
}

