/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.validation.fixes;

import com.intellij.codeInsight.template.Template;
import com.intellij.lang.javascript.DialectDetector;
import com.intellij.lang.javascript.JSBundle;
import com.intellij.lang.javascript.psi.JSNewExpression;
import com.intellij.lang.javascript.psi.JSReferenceExpression;
import com.intellij.lang.javascript.psi.ecmal4.JSClass;
import com.intellij.lang.javascript.validation.fixes.BaseCreateFix;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.PropertyKey;

public abstract class CreateJSFunctionIntentionActionBase
extends BaseCreateFix {
    private final String myName;
    private final String myIntentionNameKey;

    public CreateJSFunctionIntentionActionBase(String name, @PropertyKey(resourceBundle="messages.JavaScriptBundle") String nameKey) {
        this.myName = name;
        this.myIntentionNameKey = nameKey;
    }

    @NotNull
    public String getName() {
        String string = JSBundle.message((String)this.myIntentionNameKey, (Object[])new Object[]{this.myName});
        if (string == null) {
            CreateJSFunctionIntentionActionBase.$$$reportNull$$$0(0);
        }
        return string;
    }

    @Override
    @NotNull
    public String getFamilyName() {
        String string = JSBundle.message((String)"javascript.create.function.intention.family", (Object[])new Object[0]);
        if (string == null) {
            CreateJSFunctionIntentionActionBase.$$$reportNull$$$0(1);
        }
        return string;
    }

    @Override
    protected void buildTemplate(Template template, JSReferenceExpression referenceExpression, boolean staticContext, PsiFile file, PsiElement anchorParent) {
        boolean ecma = DialectDetector.isActionScript((PsiElement)file);
        String referencedName = ecma ? referenceExpression.getReferencedName() : referenceExpression.getText();
        PsiElement clazz = CreateJSFunctionIntentionActionBase.findClass(anchorParent);
        if (clazz instanceof JSClass) {
            this.addAccessModifier(template, referenceExpression, file, staticContext, (JSClass)clazz);
        }
        this.writeFunctionAndName(template, referencedName, file, clazz, referenceExpression);
        template.addTextSegment("(");
        this.addParameters(template, referenceExpression, file);
        template.addTextSegment(")");
        boolean constructor = referenceExpression.getParent() instanceof JSNewExpression;
        if ((ecma || DialectDetector.isTypeScript((PsiElement)file) && clazz != null && (!(clazz instanceof JSClass) || ((JSClass)clazz).isInterface())) && !constructor) {
            template.addTextSegment(":");
            this.addReturnType(template, referenceExpression, file);
        }
        if (clazz == null || clazz instanceof JSClass && !((JSClass)clazz).isInterface()) {
            template.addTextSegment(" {");
            this.addBody(template, referenceExpression, file);
            template.addTextSegment("}");
        } else {
            this.addSemicolonSegment(template, file);
            template.addEndVariable();
        }
    }

    protected void writeFunctionAndName(Template template, String referencedName, PsiFile file, PsiElement clazz, JSReferenceExpression referenceExpression) {
        template.addTextSegment("function ");
        template.addTextSegment(referencedName);
    }

    protected abstract void addParameters(Template var1, JSReferenceExpression var2, PsiFile var3);

    protected abstract void addReturnType(Template var1, JSReferenceExpression var2, PsiFile var3);

    protected abstract void addBody(Template var1, JSReferenceExpression var2, PsiFile var3);

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[2];
        objectArray2[0] = "com/intellij/lang/javascript/validation/fixes/CreateJSFunctionIntentionActionBase";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getName";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getFamilyName";
                break;
            }
        }
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
    }
}

