/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.validation.fixes;

import com.intellij.lang.javascript.JSBundle;
import com.intellij.lang.javascript.psi.JSExpression;
import com.intellij.lang.javascript.psi.impl.JSChangeUtil;
import com.intellij.lang.javascript.validation.fixes.FixAndIntentionAction;
import com.intellij.openapi.application.WriteAction;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import org.jetbrains.annotations.NotNull;

public class JSInsertPrimitiveWrapperFix
extends FixAndIntentionAction {
    private final String myType;

    public JSInsertPrimitiveWrapperFix(String type) {
        this.myType = type;
    }

    @NotNull
    public String getName() {
        String string = JSBundle.message((String)"javascript.insert.primitive.wrapper.fix", (Object[])new Object[]{StringUtil.capitalize((String)this.myType) + "(...)"});
        if (string == null) {
            JSInsertPrimitiveWrapperFix.$$$reportNull$$$0(0);
        }
        return string;
    }

    @Override
    protected boolean isAvailable(Project project, PsiElement element, Editor editor, PsiFile file) {
        return element instanceof JSExpression;
    }

    @Override
    public boolean startInWriteAction() {
        return true;
    }

    @Override
    protected void applyFix(Project project, PsiElement psiElement, PsiFile file, Editor editor) {
        WriteAction.run(() -> psiElement.replace(JSChangeUtil.createExpressionFromText(project, StringUtil.capitalize((String)this.myType) + "(" + psiElement.getText() + ")").getPsi()));
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/validation/fixes/JSInsertPrimitiveWrapperFix", "getName"));
    }
}

