/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.validation.fixes;

import com.intellij.extapi.psi.StubBasedPsiElementBase;
import com.intellij.ide.fileTemplates.FileTemplate;
import com.intellij.ide.fileTemplates.FileTemplateManager;
import com.intellij.lang.ASTNode;
import com.intellij.lang.javascript.DialectDetector;
import com.intellij.lang.javascript.JSTokenTypes;
import com.intellij.lang.javascript.dialects.JSDialectSpecificHandlersFactory;
import com.intellij.lang.javascript.ecmascript6.TypeScriptUtil;
import com.intellij.lang.javascript.formatter.JSCodeStyleSettings;
import com.intellij.lang.javascript.generation.JSChooserElementNode;
import com.intellij.lang.javascript.psi.JSElement;
import com.intellij.lang.javascript.psi.JSExpectedTypeKind;
import com.intellij.lang.javascript.psi.JSExpression;
import com.intellij.lang.javascript.psi.JSFunction;
import com.intellij.lang.javascript.psi.JSFunctionItem;
import com.intellij.lang.javascript.psi.JSNamedElement;
import com.intellij.lang.javascript.psi.JSNamedElementBase;
import com.intellij.lang.javascript.psi.JSObjectLiteralExpression;
import com.intellij.lang.javascript.psi.JSOptionalOwner;
import com.intellij.lang.javascript.psi.JSParameterItem;
import com.intellij.lang.javascript.psi.JSParameterListElement;
import com.intellij.lang.javascript.psi.JSProperty;
import com.intellij.lang.javascript.psi.JSRecordType;
import com.intellij.lang.javascript.psi.JSType;
import com.intellij.lang.javascript.psi.JSTypeUtils;
import com.intellij.lang.javascript.psi.JSVariable;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptFunction;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptIndexSignature;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptPropertySignature;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptTypeParameterList;
import com.intellij.lang.javascript.psi.ecmal4.JSAttributeList;
import com.intellij.lang.javascript.psi.ecmal4.JSAttributeListOwner;
import com.intellij.lang.javascript.psi.ecmal4.JSClass;
import com.intellij.lang.javascript.psi.impl.JSChangeUtil;
import com.intellij.lang.javascript.psi.impl.JSPsiImplUtils;
import com.intellij.lang.javascript.psi.resolve.JSResolveUtil;
import com.intellij.lang.javascript.psi.types.JSAnyType;
import com.intellij.lang.javascript.psi.types.JSCompositeTypeImpl;
import com.intellij.lang.javascript.psi.types.JSIntersectionTypeImpl;
import com.intellij.lang.javascript.psi.types.JSTypeSourceFactory;
import com.intellij.lang.javascript.psi.types.TypeScriptTypeParser;
import com.intellij.lang.javascript.refactoring.extractMethod.signatureGenerator.JSFunctionSignatureInfo;
import com.intellij.lang.javascript.refactoring.extractMethod.signatureGenerator.TypeScriptFunctionSignatureGenerator;
import com.intellij.lang.javascript.validation.fixes.BaseCreateFix;
import com.intellij.lang.javascript.validation.fixes.BaseCreateMembersFix;
import com.intellij.lang.javascript.validation.fixes.JSAttributeListWrapper;
import com.intellij.lang.typescript.psi.TypeScriptChangeUtil;
import com.intellij.lang.typescript.psi.TypeScriptPsiUtil;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.impl.source.tree.TreeUtil;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.MultiMap;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import kotlin.NotImplementedError;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class TypeScriptImplementMemberUtil {
    private static final TypeScriptFunctionSignatureGenerator TS_SIGNATURE_GENERATOR = new TypeScriptFunctionSignatureGenerator();
    private static final String ourImplementedMethodBodyTemplate = "TypeScript Implemented Method Body.ts";

    public static void implementAllMissingMembersForMemberOwner(@NotNull PsiElement memberOwner, @Nullable JSType expectedType) {
        JSObjectLiteralExpression objectLiteral;
        JSClass jsClass;
        ASTNode anchorNode;
        if (memberOwner == null) {
            TypeScriptImplementMemberUtil.$$$reportNull$$$0(0);
        }
        if ((anchorNode = memberOwner.getNode().findChildByType(JSTokenTypes.LBRACE)) == null) {
            return;
        }
        JSClass jSClass = jsClass = memberOwner instanceof JSClass ? (JSClass)memberOwner : null;
        if (jsClass != null) {
            Map<JSElement, JSClass> members = TypeScriptUtil.getUnimplementedMembers(jsClass, false);
            TypeScriptImplementMemberUtil.invokeOnMemberList((PsiElement)jsClass, anchorNode, members, false);
            return;
        }
        JSObjectLiteralExpression jSObjectLiteralExpression = objectLiteral = memberOwner instanceof JSObjectLiteralExpression ? (JSObjectLiteralExpression)memberOwner : null;
        if (objectLiteral != null) {
            if (expectedType != null) {
                Map<JSElement, JSClass> members = TypeScriptImplementMemberUtil.getUnimplementedMembersForLiteral(objectLiteral, expectedType, false);
                TypeScriptImplementMemberUtil.invokeOnMemberList((PsiElement)objectLiteral, objectLiteral.getFirstChild().getNode(), members, false);
            }
            return;
        }
        throw new NotImplementedError("Please implement me for: " + memberOwner.getClass());
    }

    @NotNull
    public static Map<JSElement, JSClass> getUnimplementedMembersForLiteral(@NotNull JSObjectLiteralExpression objectLiteral, @NotNull JSType expectedType, boolean includeOptional) {
        if (objectLiteral == null) {
            TypeScriptImplementMemberUtil.$$$reportNull$$$0(1);
        }
        if (expectedType == null) {
            TypeScriptImplementMemberUtil.$$$reportNull$$$0(2);
        }
        JSRecordType recordType = expectedType.asRecordType();
        HashMap members = ContainerUtil.newHashMap();
        Set propNames = Arrays.stream(objectLiteral.getProperties()).map(p -> p.getName()).filter(n -> n != null).collect(Collectors.toSet());
        for (JSRecordType.TypeMember prop : recordType.getTypeMembers()) {
            if (!(prop instanceof JSRecordType.PropertySignature) || propNames.contains(((JSRecordType.PropertySignature)prop).getMemberName())) continue;
            for (PsiElement singleElement : prop.getMemberSource().getAllSourceElements()) {
                if (!includeOptional && singleElement instanceof JSOptionalOwner && ((JSOptionalOwner)singleElement).isOptional()) continue;
                if (singleElement instanceof TypeScriptFunction) {
                    for (JSFunctionItem jSFunctionItem : TypeScriptPsiUtil.getAllOverloadSignatures((TypeScriptFunction)singleElement)) {
                        members.put(jSFunctionItem, JSResolveUtil.getClassOfContext((PsiElement)jSFunctionItem));
                    }
                    continue;
                }
                members.put((JSElement)singleElement, JSResolveUtil.getClassOfContext(singleElement));
            }
        }
        HashMap hashMap = members;
        if (hashMap == null) {
            TypeScriptImplementMemberUtil.$$$reportNull$$$0(3);
        }
        return hashMap;
    }

    public static void addUnimplementedMemberCandidates(@Nullable PsiElement memberContainer, @NotNull Collection<JSChooserElementNode> candidates, @NotNull Predicate<JSElement> filter) {
        JSType expectedType;
        Map<Object, Object> members;
        if (candidates == null) {
            TypeScriptImplementMemberUtil.$$$reportNull$$$0(4);
        }
        if (filter == null) {
            TypeScriptImplementMemberUtil.$$$reportNull$$$0(5);
        }
        if ((members = memberContainer instanceof JSClass ? TypeScriptUtil.getUnimplementedMembers((JSClass)memberContainer, true) : (memberContainer instanceof JSObjectLiteralExpression ? ((expectedType = JSDialectSpecificHandlersFactory.findExpectedType((JSExpression)memberContainer, JSExpectedTypeKind.CONTEXTUAL)) == null ? null : TypeScriptImplementMemberUtil.getUnimplementedMembersForLiteral((JSObjectLiteralExpression)memberContainer, expectedType, true)) : null)) == null) {
            return;
        }
        for (Map.Entry<JSElement, JSClass> entry : members.entrySet()) {
            JSElement key = entry.getKey();
            if (!filter.test(key)) continue;
            candidates.add(JSChooserElementNode.create((PsiElement)key));
        }
    }

    public static void implementMembersForMemberOwner(@NotNull PsiElement memberOwner, @NotNull Set<? extends JSNamedElement> toImplement, @Nullable ASTNode anchorNode, boolean implementAsAbstract) {
        if (memberOwner == null) {
            TypeScriptImplementMemberUtil.$$$reportNull$$$0(6);
        }
        if (toImplement == null) {
            TypeScriptImplementMemberUtil.$$$reportNull$$$0(7);
        }
        if ((anchorNode = TypeScriptImplementMemberUtil.fixAnchorNode(memberOwner, anchorNode)) == null) {
            return;
        }
        if (memberOwner instanceof JSClass) {
            TypeScriptImplementMemberUtil.doImplementMembers(memberOwner, toImplement, anchorNode, TypeScriptUtil.getUnimplementedMembers((JSClass)memberOwner, false), implementAsAbstract);
        } else if (memberOwner instanceof JSObjectLiteralExpression) {
            JSType expectedType = JSDialectSpecificHandlersFactory.findExpectedType((JSExpression)memberOwner, JSExpectedTypeKind.CONTEXTUAL);
            if (expectedType != null) {
                TypeScriptImplementMemberUtil.doImplementMembers(memberOwner, toImplement, anchorNode, TypeScriptImplementMemberUtil.getUnimplementedMembersForLiteral((JSObjectLiteralExpression)memberOwner, expectedType, true), false);
            }
        } else {
            throw new NotImplementedError("Please implement me for " + memberOwner.getClass());
        }
    }

    @Nullable
    private static ASTNode fixAnchorNode(@NotNull PsiElement owner, @Nullable ASTNode anchorNode) {
        if (owner == null) {
            TypeScriptImplementMemberUtil.$$$reportNull$$$0(8);
        }
        if (anchorNode == null) {
            anchorNode = owner.getNode().findChildByType(JSTokenTypes.LBRACE);
        } else {
            while (anchorNode != null && TreeUtil.isWhitespaceOrComment((ASTNode)anchorNode)) {
                anchorNode = anchorNode.getTreePrev();
            }
        }
        if (anchorNode == null) {
            return null;
        }
        return anchorNode;
    }

    private static void doImplementMembers(@NotNull PsiElement jsClass, @NotNull Set<? extends JSNamedElement> toImplement, @NotNull ASTNode anchorNode, Map<JSElement, JSClass> members, boolean implementAsAbstract) {
        if (jsClass == null) {
            TypeScriptImplementMemberUtil.$$$reportNull$$$0(9);
        }
        if (toImplement == null) {
            TypeScriptImplementMemberUtil.$$$reportNull$$$0(10);
        }
        if (anchorNode == null) {
            TypeScriptImplementMemberUtil.$$$reportNull$$$0(11);
        }
        ArrayList keySet = ContainerUtil.newArrayList(members.keySet());
        for (JSElement jSElement : keySet) {
            if (jSElement instanceof JSNamedElement && toImplement.contains(jSElement)) continue;
            members.remove(jSElement);
        }
        for (JSElement jSElement : toImplement) {
            if (members.containsKey(jSElement)) continue;
            members.put(jSElement, JSResolveUtil.getClassOfContext((PsiElement)jSElement));
        }
        TypeScriptImplementMemberUtil.invokeOnMemberList(jsClass, anchorNode, members, implementAsAbstract);
    }

    private static void invokeOnMemberList(@NotNull PsiElement jsClass, @NotNull ASTNode anchorNode, @NotNull Map<JSElement, JSClass> members, boolean implementAsAbstract) {
        if (jsClass == null) {
            TypeScriptImplementMemberUtil.$$$reportNull$$$0(12);
        }
        if (anchorNode == null) {
            TypeScriptImplementMemberUtil.$$$reportNull$$$0(13);
        }
        if (members == null) {
            TypeScriptImplementMemberUtil.$$$reportNull$$$0(14);
        }
        ContainerUtil.KeyOrderedMultiMap properties = new ContainerUtil.KeyOrderedMultiMap();
        ContainerUtil.KeyOrderedMultiMap functions = new ContainerUtil.KeyOrderedMultiMap();
        ArrayList stringIndexers = ContainerUtil.newArrayList();
        ArrayList numericIndexers = ContainerUtil.newArrayList();
        TypeScriptImplementMemberUtil.collectPropertiesFunctionsAndIndexersForImplementation(members, (MultiMap<String, JSNamedElement>)properties, (MultiMap<String, JSFunction>)functions, stringIndexers, numericIndexers);
        PsiElement anchor = anchorNode.getPsi();
        if (jsClass instanceof JSClass) {
            anchor = TypeScriptImplementMemberUtil.addIndexerToClass(jsClass, anchor, numericIndexers, members, JSRecordType.IndexSignatureKind.NUMERIC);
            anchor = TypeScriptImplementMemberUtil.addIndexerToClass(jsClass, anchor, stringIndexers, members, JSRecordType.IndexSignatureKind.STRING);
        }
        for (Map.Entry entry : properties.entrySet()) {
            anchor = TypeScriptImplementMemberUtil.addPropertyToClass(jsClass, anchor, (String)entry.getKey(), (Collection)entry.getValue(), members, implementAsAbstract);
        }
        for (Map.Entry entry : functions.entrySet()) {
            anchor = TypeScriptImplementMemberUtil.addFunctionToClass(jsClass, (String)entry.getKey(), (Collection)entry.getValue(), members, anchor, implementAsAbstract);
        }
        TypeScriptImplementMemberUtil.fixRedundantTrailingComma(jsClass);
    }

    private static void fixRedundantTrailingComma(@NotNull PsiElement jsClass) {
        if (jsClass == null) {
            TypeScriptImplementMemberUtil.$$$reportNull$$$0(15);
        }
        if (jsClass instanceof JSObjectLiteralExpression) {
            PsiElement child = jsClass.getLastChild();
            if (child != null) {
                child = child.getPrevSibling();
            }
            while (child != null && TreeUtil.isWhitespaceOrComment((ASTNode)child.getNode())) {
                child = child.getPrevSibling();
            }
            if (child == null || !",".equals(child.getText())) {
                return;
            }
            jsClass.deleteChildRange(child, child);
        }
    }

    private static void collectPropertiesFunctionsAndIndexersForImplementation(@NotNull Map<JSElement, JSClass> membersToImplement, @NotNull MultiMap<String, JSNamedElement> properties, @NotNull MultiMap<String, JSFunction> functions, @NotNull List<TypeScriptIndexSignature> stringIndexers, @NotNull List<TypeScriptIndexSignature> numericIndexers) {
        if (membersToImplement == null) {
            TypeScriptImplementMemberUtil.$$$reportNull$$$0(16);
        }
        if (properties == null) {
            TypeScriptImplementMemberUtil.$$$reportNull$$$0(17);
        }
        if (functions == null) {
            TypeScriptImplementMemberUtil.$$$reportNull$$$0(18);
        }
        if (stringIndexers == null) {
            TypeScriptImplementMemberUtil.$$$reportNull$$$0(19);
        }
        if (numericIndexers == null) {
            TypeScriptImplementMemberUtil.$$$reportNull$$$0(20);
        }
        for (JSElement member : membersToImplement.keySet()) {
            if (TypeScriptUtil.isTypeScriptMethod((PsiElement)member)) {
                functions.putValue((Object)JSPsiImplUtils.getNameOrComputedPropertyName((JSNamedElementBase)member, false), (Object)((JSFunction)member));
                continue;
            }
            if (TypeScriptUtil.isTypeScriptProperty((PsiElement)member)) {
                properties.putValue((Object)JSPsiImplUtils.getNameOrComputedPropertyName((JSNamedElementBase)member, false), (Object)((JSNamedElement)member));
                continue;
            }
            if (!(member instanceof TypeScriptIndexSignature)) continue;
            JSRecordType.IndexSignatureKind indexSignatureKind = ((TypeScriptIndexSignature)member).getIndexSignatureKind();
            if (indexSignatureKind == JSRecordType.IndexSignatureKind.STRING) {
                stringIndexers.add((TypeScriptIndexSignature)member);
                continue;
            }
            if (indexSignatureKind != JSRecordType.IndexSignatureKind.NUMERIC) continue;
            numericIndexers.add((TypeScriptIndexSignature)member);
        }
    }

    private static PsiElement addIndexerToClass(@NotNull PsiElement jsClass, @Nullable PsiElement anchor, @NotNull List<TypeScriptIndexSignature> indexers, @NotNull Map<JSElement, JSClass> interfacesForImplement, @NotNull JSRecordType.IndexSignatureKind indexSignatureKind) {
        String text;
        PsiElement parameterNameElement;
        if (jsClass == null) {
            TypeScriptImplementMemberUtil.$$$reportNull$$$0(21);
        }
        if (indexers == null) {
            TypeScriptImplementMemberUtil.$$$reportNull$$$0(22);
        }
        if (interfacesForImplement == null) {
            TypeScriptImplementMemberUtil.$$$reportNull$$$0(23);
        }
        if (indexSignatureKind == null) {
            TypeScriptImplementMemberUtil.$$$reportNull$$$0(24);
        }
        if (indexers.size() == 0) {
            return anchor;
        }
        JSType returnType = TypeScriptImplementMemberUtil.getBestTypeAnnotationType(jsClass, indexers.stream().filter(i -> i.getType() != null).map(i -> {
            if (jsClass == null) {
                TypeScriptImplementMemberUtil.$$$reportNull$$$0(73);
            }
            if (interfacesForImplement == null) {
                TypeScriptImplementMemberUtil.$$$reportNull$$$0(74);
            }
            return TypeScriptImplementMemberUtil.fixTypeWithBaseTypes(jsClass, interfacesForImplement, (JSElement)i, TypeScriptTypeParser.buildTypeFromTypeScript(i.getType()));
        }).collect(Collectors.toList()));
        String paramName = "p";
        if (indexers.size() == 1 && (parameterNameElement = indexers.get(0).getParameterNameElement()) != null) {
            paramName = parameterNameElement.getText();
        }
        StringBuilder builder = new StringBuilder("[");
        builder.append(paramName);
        builder.append(": ");
        builder.append(indexSignatureKind == JSRecordType.IndexSignatureKind.NUMERIC ? "number" : "string");
        builder.append("]");
        if (returnType != null && !StringUtil.isEmpty((String)(text = BaseCreateFix.getTypeText(returnType)))) {
            builder.append(": ").append(text);
        }
        builder.append(JSCodeStyleSettings.getSemicolon((PsiElement)jsClass.getContainingFile()));
        return TypeScriptImplementMemberUtil.createAndAppendMember(jsClass, anchor, builder.toString());
    }

    private static PsiElement addPropertyToClass(@NotNull PsiElement jsClass, @Nullable PsiElement anchor, @Nullable String name, @NotNull Collection<JSNamedElement> properties, @NotNull Map<JSElement, JSClass> interfacesForImplement, boolean implementAsAbstract) {
        if (jsClass == null) {
            TypeScriptImplementMemberUtil.$$$reportNull$$$0(25);
        }
        if (properties == null) {
            TypeScriptImplementMemberUtil.$$$reportNull$$$0(26);
        }
        if (interfacesForImplement == null) {
            TypeScriptImplementMemberUtil.$$$reportNull$$$0(27);
        }
        if (name == null) {
            return anchor;
        }
        StringBuilder builder = new StringBuilder();
        ArrayList types = ContainerUtil.newArrayList();
        String attributes = "";
        for (JSNamedElement property : properties) {
            JSAttributeList attributeList;
            String attributeListText;
            JSType type = null;
            if (property instanceof TypeScriptPropertySignature) {
                type = ((TypeScriptPropertySignature)property).getType();
            } else if (property instanceof JSVariable) {
                type = ((JSVariable)property).getType();
            }
            if (type != null) {
                type = TypeScriptImplementMemberUtil.fixTypeWithBaseTypes(jsClass, interfacesForImplement, (JSElement)property, type);
                types.add(type);
            }
            if (!(property instanceof JSAttributeListOwner) || StringUtil.isEmpty((String)(attributeListText = TypeScriptImplementMemberUtil.getAttributeListString(jsClass, attributeList = ((JSAttributeListOwner)property).getAttributeList())))) continue;
            attributes = attributeListText;
        }
        if (!StringUtil.isEmpty((String)attributes)) {
            builder.append(attributes);
            builder.append(' ');
        }
        if (implementAsAbstract) {
            builder.append("abstract");
            builder.append(' ');
        }
        builder.append(name);
        JSType type = TypeScriptImplementMemberUtil.getBestTypeAnnotationType(jsClass, types);
        if (type != null) {
            String text;
            String string = text = jsClass instanceof JSClass ? BaseCreateFix.getTypeText(type) : JSTypeUtils.defaultValueOfType(type);
            if (!StringUtil.isEmpty((String)text)) {
                builder.append(": ").append(text);
            } else if (jsClass instanceof JSObjectLiteralExpression) {
                builder.append(": ").append("undefined");
            }
        } else if (jsClass instanceof JSObjectLiteralExpression) {
            builder.append(": ").append("undefined");
        }
        builder.append(jsClass instanceof JSClass ? JSCodeStyleSettings.getSemicolon((PsiElement)jsClass.getContainingFile()) : ",");
        return TypeScriptImplementMemberUtil.createAndAppendMember(jsClass, anchor, builder.toString());
    }

    @NotNull
    private static String getAttributeListString(@NotNull PsiElement jsClass, @Nullable JSAttributeList attributeList) {
        if (jsClass == null) {
            TypeScriptImplementMemberUtil.$$$reportNull$$$0(28);
        }
        JSAttributeListWrapper wrapper = new JSAttributeListWrapper(attributeList, jsClass.getProject());
        wrapper.overrideModifier(JSAttributeList.ModifierType.ABSTRACT, false);
        String string = wrapper.computeText(null, DialectDetector.dialectOfElement(jsClass));
        if (string == null) {
            TypeScriptImplementMemberUtil.$$$reportNull$$$0(29);
        }
        return string;
    }

    private static JSType fixTypeWithBaseTypes(@NotNull PsiElement jsClass, @NotNull Map<JSElement, JSClass> interfacesForImplement, JSElement property, JSType type) {
        if (jsClass == null) {
            TypeScriptImplementMemberUtil.$$$reportNull$$$0(30);
        }
        if (interfacesForImplement == null) {
            TypeScriptImplementMemberUtil.$$$reportNull$$$0(31);
        }
        type = JSTypeUtils.getValuableType(type);
        if (jsClass instanceof JSClass && JSTypeUtils.hasGenericParameter(type)) {
            JSClass context = interfacesForImplement.get(property);
            type = TypeScriptUtil.applyGenericsToType(type, (JSClass)jsClass, context);
        }
        return type;
    }

    @Nullable
    private static JSType getBestTypeAnnotationType(@NotNull PsiElement anchor, @NotNull List<JSType> types) {
        if (anchor == null) {
            TypeScriptImplementMemberUtil.$$$reportNull$$$0(32);
        }
        if (types == null) {
            TypeScriptImplementMemberUtil.$$$reportNull$$$0(33);
        }
        if ((types = TypeScriptImplementMemberUtil.optimizeTypeSet(types)).size() == 0) {
            return null;
        }
        if (types.size() == 1) {
            return types.get(0);
        }
        return JSIntersectionTypeImpl.getIntersectionType(types, JSTypeSourceFactory.createTypeSource(anchor, true));
    }

    @NotNull
    private static List<JSType> optimizeTypeSet(@NotNull List<JSType> types) {
        if (types == null) {
            TypeScriptImplementMemberUtil.$$$reportNull$$$0(34);
        }
        ArrayList newTypes = ContainerUtil.newArrayListWithCapacity((int)types.size());
        for (JSType currentType : types) {
            if (currentType instanceof JSAnyType) {
                List list = ContainerUtil.createMaybeSingletonList((Object)currentType);
                if (list == null) {
                    TypeScriptImplementMemberUtil.$$$reportNull$$$0(35);
                }
                return list;
            }
            boolean add = true;
            ArrayList toRemove = ContainerUtil.newArrayList();
            for (JSType resultedType : newTypes) {
                if (currentType.isDirectlyAssignableType(resultedType, null)) {
                    add = false;
                    break;
                }
                if (!resultedType.isDirectlyAssignableType(currentType, null)) continue;
                toRemove.add(resultedType);
            }
            newTypes.removeAll(toRemove);
            if (!add) continue;
            newTypes.add(currentType);
        }
        ArrayList arrayList = newTypes;
        if (arrayList == null) {
            TypeScriptImplementMemberUtil.$$$reportNull$$$0(36);
        }
        return arrayList;
    }

    @Nullable
    private static PsiElement addFunctionToClass(@NotNull PsiElement jsClass, @Nullable String name, @NotNull Collection<JSFunction> functions, @NotNull Map<JSElement, JSClass> allMembers, @Nullable PsiElement anchor, boolean implementAsAbstract) {
        if (jsClass == null) {
            TypeScriptImplementMemberUtil.$$$reportNull$$$0(37);
        }
        if (functions == null) {
            TypeScriptImplementMemberUtil.$$$reportNull$$$0(38);
        }
        if (allMembers == null) {
            TypeScriptImplementMemberUtil.$$$reportNull$$$0(39);
        }
        if (name == null) {
            return anchor;
        }
        assert (!functions.isEmpty());
        if (functions.size() == 1) {
            JSFunction function = (JSFunction)ContainerUtil.getFirstItem(functions);
            assert (function != null);
            return TypeScriptImplementMemberUtil.addDistinctFunctionToClass(function, name, jsClass, anchor, allMembers, implementAsAbstract);
        }
        return TypeScriptImplementMemberUtil.doAddFunctions(functions, name, jsClass, anchor, allMembers, implementAsAbstract);
    }

    private static PsiElement doAddFunctions(@NotNull Collection<JSFunction> functions, @NotNull String name, @NotNull PsiElement jsClass, @Nullable PsiElement anchor, @NotNull Map<JSElement, JSClass> allMembers, boolean implementAsAbstract) {
        if (functions == null) {
            TypeScriptImplementMemberUtil.$$$reportNull$$$0(40);
        }
        if (name == null) {
            TypeScriptImplementMemberUtil.$$$reportNull$$$0(41);
        }
        if (jsClass == null) {
            TypeScriptImplementMemberUtil.$$$reportNull$$$0(42);
        }
        if (allMembers == null) {
            TypeScriptImplementMemberUtil.$$$reportNull$$$0(43);
        }
        if (jsClass instanceof JSClass) {
            for (JSFunction function : functions) {
                StringBuilder result2 = TypeScriptImplementMemberUtil.buildSignatureText(function, jsClass, name, allMembers, implementAsAbstract);
                if (result2 == null) continue;
                TypeScriptImplementMemberUtil.fixSemicolon(jsClass, result2);
                PsiElement element = TypeScriptChangeUtil.createClassMemberFromText(jsClass.getProject(), result2.toString());
                anchor = jsClass.addAfter(element, anchor);
            }
        }
        if (TypeScriptPsiUtil.isAmbientDeclaration(jsClass) || implementAsAbstract) {
            return anchor;
        }
        Signature signatureInfo = TypeScriptImplementMemberUtil.getParametersAndReturnType(functions, jsClass, allMembers);
        JSFunctionSignatureInfo info = new JSFunctionSignatureInfo(name);
        info.setScope(JSFunctionSignatureInfo.Scope.CLASS);
        JSAttributeList.AccessType type = signatureInfo.accessType;
        if (type != null) {
            info.setAccessType(type);
        }
        info.setReturnType(signatureInfo.returnTypeString);
        int count = 1;
        for (ParameterInfo param : signatureInfo.params) {
            String parameterName = param.name;
            if (parameterName == null) {
                parameterName = "p" + count++;
            }
            if (param.isRest) {
                parameterName = "... " + parameterName;
            } else if (param.isOptional) {
                parameterName = parameterName + "?";
            }
            info.addParameterAndType(parameterName, param.type);
        }
        StringBuilder signature = TS_SIGNATURE_GENERATOR.getSignature(info, jsClass);
        TypeScriptImplementMemberUtil.appendFunctionBody(jsClass, signatureInfo.returnType, signature, false, name);
        if (jsClass instanceof JSObjectLiteralExpression) {
            signature.append(',');
        }
        return TypeScriptImplementMemberUtil.createAndAppendMember(jsClass, anchor, signature.toString());
    }

    private static PsiElement createAndAppendMember(PsiElement jsClass, PsiElement anchor, String signatureText) {
        PsiElement comma;
        boolean isObjectLiteral = jsClass instanceof JSObjectLiteralExpression;
        PsiElement element = isObjectLiteral ? JSChangeUtil.createObjectLiteralPropertyFromText(signatureText, jsClass) : TypeScriptChangeUtil.createClassMemberFromText(jsClass.getProject(), signatureText);
        PsiElement psiElement = comma = isObjectLiteral ? JSChangeUtil.createCommaPsiElement(jsClass) : null;
        if (isObjectLiteral && anchor instanceof JSProperty) {
            anchor = jsClass.addAfter(comma, anchor);
        }
        anchor = jsClass.addAfter(element, anchor);
        if (isObjectLiteral) {
            anchor = jsClass.addAfter(comma, anchor);
        }
        return anchor;
    }

    @NotNull
    private static Signature getParametersAndReturnType(@NotNull Collection<JSFunction> functions, @NotNull PsiElement jsResultClass, @NotNull Map<JSElement, JSClass> allMembers) {
        if (functions == null) {
            TypeScriptImplementMemberUtil.$$$reportNull$$$0(44);
        }
        if (jsResultClass == null) {
            TypeScriptImplementMemberUtil.$$$reportNull$$$0(45);
        }
        if (allMembers == null) {
            TypeScriptImplementMemberUtil.$$$reportNull$$$0(46);
        }
        Signature result2 = new Signature();
        List<ParameterInfo> infos = result2.params;
        boolean isFirst = true;
        boolean hasTypeParametersList = false;
        int minParameterCount = Integer.MAX_VALUE;
        ArrayList returnTypes = ContainerUtil.newArrayList();
        MultiMap paramTypes = MultiMap.createLinked();
        for (JSFunction function : functions) {
            JSParameterListElement[] parameters;
            String newReturnType;
            JSClass surroundClass = allMembers.get(function);
            JSType returnType = function.getReturnType();
            JSType fixedType = TypeScriptImplementMemberUtil.fixTypeWithBaseTypes(jsResultClass, allMembers, (JSElement)function, returnType);
            if (fixedType != null) {
                returnTypes.add(fixedType);
            }
            if (isFirst) {
                result2.returnTypeString = BaseCreateMembersFix.getProcessedType(returnType, jsResultClass, (PsiElement)surroundClass);
                result2.returnType = returnType;
                isFirst = false;
            } else if (result2.returnType != null && !StringUtil.equals((CharSequence)(newReturnType = BaseCreateMembersFix.getProcessedType(returnType, jsResultClass, (PsiElement)surroundClass)), (CharSequence)result2.returnTypeString)) {
                result2.returnTypeString = "any";
                result2.returnType = null;
            }
            JSAttributeList.AccessType accessType = function.getAccessType();
            if (result2.accessType != accessType) {
                if (result2.accessType == null) {
                    result2.accessType = accessType;
                } else if (result2.accessType == JSAttributeList.AccessType.PROTECTED) {
                    result2.accessType = JSAttributeList.AccessType.PUBLIC;
                }
            }
            if (!hasTypeParametersList && function instanceof TypeScriptFunction) {
                boolean bl = hasTypeParametersList = ((TypeScriptFunction)function).getTypeParameterList() != null;
            }
            if (minParameterCount > (parameters = function.getParameters()).length) {
                minParameterCount = parameters.length;
            }
            for (int i = 0; i < parameters.length; ++i) {
                String type;
                JSParameterListElement parameter = parameters[i];
                ParameterInfo info = infos.size() > i ? infos.get(i) : null;
                JSType parameterType = TypeScriptImplementMemberUtil.getParameterType((JSParameterItem)parameter);
                JSType fixedParamType = TypeScriptImplementMemberUtil.fixTypeWithBaseTypes(jsResultClass, allMembers, (JSElement)function, parameterType);
                if (fixedParamType != null && parameter.isRest()) {
                    fixedParamType = JSTypeUtils.getIterableComponentType(fixedParamType);
                }
                if (fixedParamType != null) {
                    paramTypes.putValue((Object)i, (Object)fixedParamType);
                }
                if (info == null) {
                    info = new ParameterInfo();
                    type = BaseCreateMembersFix.getProcessedType(parameterType, jsResultClass, (PsiElement)surroundClass);
                    info.name = parameter.getName();
                    info.type = type;
                    info.isOptional = parameter.isOptional();
                    info.isRest = parameter.isRest();
                    infos.add(info);
                    continue;
                }
                type = BaseCreateMembersFix.getProcessedType(parameterType, jsResultClass, (PsiElement)surroundClass);
                if (!StringUtil.equals((CharSequence)type, (CharSequence)info.type)) {
                    info.type = null;
                }
                if (info.isOptional != parameter.isOptional()) {
                    info.isOptional = true;
                }
                if (info.isRest == parameter.isRest()) continue;
                info.isRest = true;
            }
        }
        if (result2.returnType == null && returnTypes.size() > 1 && jsResultClass instanceof JSClass) {
            JSType union = TypeScriptImplementMemberUtil.createCompositeType(jsResultClass, returnTypes);
            boolean hasGenericParameter = JSTypeUtils.hasGenericParameter(union);
            result2.returnTypeString = hasGenericParameter ? "any" : union.getTypeText(JSType.TypeTextFormat.CODE);
            result2.returnType = hasGenericParameter ? null : union;
        }
        int restIndex = -1;
        for (int i = 0; i < infos.size(); ++i) {
            int parameterNumber = i + 1;
            ParameterInfo info = infos.get(i);
            if (paramTypes.containsKey((Object)i)) {
                Collection types = paramTypes.get((Object)i);
                if (hasTypeParametersList && types.stream().anyMatch(t -> JSTypeUtils.hasGenericParameter(t))) {
                    info.type = null;
                } else if (info.type == null) {
                    info.type = TypeScriptImplementMemberUtil.createCompositeTypeText(jsResultClass, (List)types);
                    if (info.isRest) {
                        info.type = TypeScriptImplementMemberUtil.wrapTypeDescAsRest(info.type);
                    }
                }
            }
            if (parameterNumber > minParameterCount) {
                info.isOptional = true;
            }
            if (!info.isRest || parameterNumber == infos.size()) continue;
            info.type = null;
            restIndex = i;
            break;
        }
        if (restIndex != -1) {
            ArrayList newList = ContainerUtil.newArrayListWithCapacity((int)restIndex);
            for (int i = 0; i < restIndex; ++i) {
                newList.add(infos.get(i));
            }
            ArrayList allTypesForRest = ContainerUtil.newArrayList();
            for (int i = restIndex; i < infos.size(); ++i) {
                if (!paramTypes.containsKey((Object)i)) continue;
                allTypesForRest.addAll(paramTypes.get((Object)i));
            }
            ParameterInfo rest = infos.get(restIndex);
            rest.type = TypeScriptImplementMemberUtil.wrapTypeDescAsRest(TypeScriptImplementMemberUtil.createCompositeTypeText(jsResultClass, allTypesForRest));
            newList.add(rest);
            result2.params = newList;
        }
        Signature signature = result2;
        if (signature == null) {
            TypeScriptImplementMemberUtil.$$$reportNull$$$0(47);
        }
        return signature;
    }

    @Nullable
    @Contract(value="null -> null")
    private static String wrapTypeDescAsRest(@Nullable String typeDesc) {
        if (typeDesc == null) {
            return null;
        }
        return "(" + typeDesc + ")[]";
    }

    @NotNull
    private static String createCompositeTypeText(@Nullable PsiElement jsResultClass, @NotNull List<JSType> types) {
        if (types == null) {
            TypeScriptImplementMemberUtil.$$$reportNull$$$0(48);
        }
        JSType union = TypeScriptImplementMemberUtil.createCompositeType(jsResultClass, types);
        String string = union.getTypeText(JSType.TypeTextFormat.CODE);
        if (string == null) {
            TypeScriptImplementMemberUtil.$$$reportNull$$$0(49);
        }
        return string;
    }

    @NotNull
    private static JSType createCompositeType(@Nullable PsiElement jsResultClass, @NotNull List<JSType> types) {
        if (types == null) {
            TypeScriptImplementMemberUtil.$$$reportNull$$$0(50);
        }
        JSCompositeTypeImpl union = new JSCompositeTypeImpl(JSTypeSourceFactory.createTypeSource(jsResultClass, true), types);
        JSCompositeTypeImpl jSCompositeTypeImpl = union = JSCompositeTypeImpl.optimizeTypeIfComposite(union);
        if (jSCompositeTypeImpl == null) {
            TypeScriptImplementMemberUtil.$$$reportNull$$$0(51);
        }
        return jSCompositeTypeImpl;
    }

    @Nullable
    private static PsiElement addDistinctFunctionToClass(@NotNull JSFunction function, @NotNull String name, @NotNull PsiElement jsClass, @Nullable PsiElement anchor, @NotNull Map<JSElement, JSClass> allMembers, boolean implementAsAbstract) {
        StringBuilder result2;
        if (function == null) {
            TypeScriptImplementMemberUtil.$$$reportNull$$$0(52);
        }
        if (name == null) {
            TypeScriptImplementMemberUtil.$$$reportNull$$$0(53);
        }
        if (jsClass == null) {
            TypeScriptImplementMemberUtil.$$$reportNull$$$0(54);
        }
        if (allMembers == null) {
            TypeScriptImplementMemberUtil.$$$reportNull$$$0(55);
        }
        if ((result2 = TypeScriptImplementMemberUtil.buildSignatureText(function, jsClass, name, allMembers, implementAsAbstract)) == null) {
            return anchor;
        }
        TypeScriptImplementMemberUtil.appendFunctionBody(jsClass, function.getReturnType(), result2, implementAsAbstract, name);
        if (jsClass instanceof JSObjectLiteralExpression) {
            result2.append(',');
        }
        return TypeScriptImplementMemberUtil.createAndAppendMember(jsClass, anchor, result2.toString());
    }

    @Nullable
    private static StringBuilder buildSignatureText(@NotNull JSFunction function, @NotNull PsiElement jsResultClass, @NotNull String name, @NotNull Map<JSElement, JSClass> allMembers, boolean implementAsAbstract) {
        String generics;
        TypeScriptFunction typeScriptFunction;
        TypeScriptTypeParameterList list;
        JSParameterListElement[] parameters;
        if (function == null) {
            TypeScriptImplementMemberUtil.$$$reportNull$$$0(56);
        }
        if (jsResultClass == null) {
            TypeScriptImplementMemberUtil.$$$reportNull$$$0(57);
        }
        if (name == null) {
            TypeScriptImplementMemberUtil.$$$reportNull$$$0(58);
        }
        if (allMembers == null) {
            TypeScriptImplementMemberUtil.$$$reportNull$$$0(59);
        }
        JSClass interfaceForImplement = allMembers.get(function);
        JSFunctionSignatureInfo info = new JSFunctionSignatureInfo(name);
        if (implementAsAbstract) {
            info.setAbstract(true);
        }
        info.setScope(JSFunctionSignatureInfo.Scope.CLASS);
        info.setAccessType(function.getAccessType());
        for (JSParameterListElement parameter : parameters = function.getParameters()) {
            String parameterName = parameter.getName();
            if (parameterName == null) continue;
            if (parameter.isRest()) {
                parameterName = "... " + parameterName;
            } else if (parameter.isOptional()) {
                parameterName = parameterName + "?";
            }
            info.addParameterAndType(parameterName, BaseCreateMembersFix.getProcessedType(TypeScriptImplementMemberUtil.getParameterType((JSParameterItem)parameter), jsResultClass, (PsiElement)interfaceForImplement));
        }
        if (function instanceof TypeScriptFunction && (list = (typeScriptFunction = (TypeScriptFunction)function).getTypeParameterList()) != null && !StringUtil.isEmpty((String)(generics = TypeScriptUtil.buildParameterTypeListStringWithApplyingGenerics(typeScriptFunction, jsResultClass)))) {
            info.setTypeParameterList(generics);
        }
        JSType returnType = function.getReturnType();
        info.setReturnType(BaseCreateMembersFix.getProcessedType(returnType, jsResultClass, (PsiElement)interfaceForImplement));
        return TS_SIGNATURE_GENERATOR.getSignature(info, jsResultClass);
    }

    @Nullable
    private static JSType getParameterType(@NotNull JSParameterItem parameter) {
        if (parameter == null) {
            TypeScriptImplementMemberUtil.$$$reportNull$$$0(60);
        }
        if (parameter.isRest() && parameter instanceof StubBasedPsiElementBase) {
            return TypeScriptPsiUtil.getTypeFromDeclaration((StubBasedPsiElementBase)parameter);
        }
        return parameter.getType();
    }

    private static void appendFunctionBody(@NotNull PsiElement jsClass, @Nullable JSType returnType, @NotNull StringBuilder builder, boolean implementAsAbstract, String name) {
        if (jsClass == null) {
            TypeScriptImplementMemberUtil.$$$reportNull$$$0(61);
        }
        if (builder == null) {
            TypeScriptImplementMemberUtil.$$$reportNull$$$0(62);
        }
        if (TypeScriptPsiUtil.isAmbientDeclaration(jsClass) || implementAsAbstract) {
            TypeScriptImplementMemberUtil.fixSemicolon(jsClass, builder);
            return;
        }
        builder.append("{");
        TypeScriptImplementMemberUtil.appendDefaultMethodBody(jsClass, returnType, builder, name);
        builder.append("\n}");
    }

    public static void appendDefaultMethodBody(@NotNull PsiElement contextNode, @Nullable JSType returnType, @NotNull StringBuilder builder, @NotNull String name) {
        String defaultValue;
        if (contextNode == null) {
            TypeScriptImplementMemberUtil.$$$reportNull$$$0(63);
        }
        if (builder == null) {
            TypeScriptImplementMemberUtil.$$$reportNull$$$0(64);
        }
        if (name == null) {
            TypeScriptImplementMemberUtil.$$$reportNull$$$0(65);
        }
        FileTemplateManager fileTemplateManager = FileTemplateManager.getInstance((Project)contextNode.getProject());
        FileTemplate template = fileTemplateManager.getCodeTemplate(ourImplementedMethodBodyTemplate);
        Properties properties = fileTemplateManager.getDefaultProperties();
        properties.setProperty("RETURN_TYPE", returnType == null ? "any" : BaseCreateFix.getTypeText(returnType));
        String string = defaultValue = returnType != null ? JSTypeUtils.defaultValueOfType(returnType) : null;
        if (defaultValue == null) {
            defaultValue = "undefined";
        }
        properties.setProperty("DEFAULT_RETURN_VALUE", defaultValue);
        properties.setProperty("METHOD_NAME", name);
        builder.append(TypeScriptImplementMemberUtil.getBodyTextFromTemplate(template, properties));
    }

    @NotNull
    public static String getBodyTextFromTemplate(@NotNull FileTemplate template, @NotNull Properties properties) {
        String bodyText;
        if (template == null) {
            TypeScriptImplementMemberUtil.$$$reportNull$$$0(66);
        }
        if (properties == null) {
            TypeScriptImplementMemberUtil.$$$reportNull$$$0(67);
        }
        try {
            bodyText = template.getText(properties);
        }
        catch (ProcessCanceledException e) {
            throw e;
        }
        catch (Exception e) {
            throw new IncorrectOperationException("Failed to parse file template", (Throwable)e);
        }
        String string = bodyText;
        if (string == null) {
            TypeScriptImplementMemberUtil.$$$reportNull$$$0(68);
        }
        return string;
    }

    private static void fixSemicolon(@NotNull PsiElement context, @NotNull StringBuilder builder) {
        if (context == null) {
            TypeScriptImplementMemberUtil.$$$reportNull$$$0(69);
        }
        if (builder == null) {
            TypeScriptImplementMemberUtil.$$$reportNull$$$0(70);
        }
        builder.append(JSCodeStyleSettings.getSemicolon((PsiElement)context.getContainingFile()));
    }

    public static void appendEmptyBodyWithReturn(@NotNull PsiElement context, @NotNull StringBuilder builder) {
        if (context == null) {
            TypeScriptImplementMemberUtil.$$$reportNull$$$0(71);
        }
        if (builder == null) {
            TypeScriptImplementMemberUtil.$$$reportNull$$$0(72);
        }
        TypeScriptImplementMemberUtil.fixSemicolon(context, builder.append("return undefined"));
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 3: 
            case 29: 
            case 35: 
            case 36: 
            case 47: 
            case 49: 
            case 51: 
            case 68: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 3: 
            case 29: 
            case 35: 
            case 36: 
            case 47: 
            case 49: 
            case 51: 
            case 68: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "memberOwner";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "objectLiteral";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "expectedType";
                break;
            }
            case 3: 
            case 29: 
            case 35: 
            case 36: 
            case 47: 
            case 49: 
            case 51: 
            case 68: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/javascript/validation/fixes/TypeScriptImplementMemberUtil";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "candidates";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "filter";
                break;
            }
            case 7: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "toImplement";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "owner";
                break;
            }
            case 9: 
            case 12: 
            case 15: 
            case 21: 
            case 25: 
            case 28: 
            case 30: 
            case 37: 
            case 42: 
            case 54: 
            case 61: 
            case 73: {
                objectArray2 = objectArray3;
                objectArray3[0] = "jsClass";
                break;
            }
            case 11: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "anchorNode";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "members";
                break;
            }
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "membersToImplement";
                break;
            }
            case 17: 
            case 26: 
            case 67: {
                objectArray2 = objectArray3;
                objectArray3[0] = "properties";
                break;
            }
            case 18: 
            case 38: 
            case 40: 
            case 44: {
                objectArray2 = objectArray3;
                objectArray3[0] = "functions";
                break;
            }
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "stringIndexers";
                break;
            }
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "numericIndexers";
                break;
            }
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "indexers";
                break;
            }
            case 23: 
            case 27: 
            case 31: 
            case 74: {
                objectArray2 = objectArray3;
                objectArray3[0] = "interfacesForImplement";
                break;
            }
            case 24: {
                objectArray2 = objectArray3;
                objectArray3[0] = "indexSignatureKind";
                break;
            }
            case 32: {
                objectArray2 = objectArray3;
                objectArray3[0] = "anchor";
                break;
            }
            case 33: 
            case 34: 
            case 48: 
            case 50: {
                objectArray2 = objectArray3;
                objectArray3[0] = "types";
                break;
            }
            case 39: 
            case 43: 
            case 46: 
            case 55: 
            case 59: {
                objectArray2 = objectArray3;
                objectArray3[0] = "allMembers";
                break;
            }
            case 41: 
            case 53: 
            case 58: 
            case 65: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 45: 
            case 57: {
                objectArray2 = objectArray3;
                objectArray3[0] = "jsResultClass";
                break;
            }
            case 52: 
            case 56: {
                objectArray2 = objectArray3;
                objectArray3[0] = "function";
                break;
            }
            case 60: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parameter";
                break;
            }
            case 62: 
            case 64: 
            case 70: 
            case 72: {
                objectArray2 = objectArray3;
                objectArray3[0] = "builder";
                break;
            }
            case 63: {
                objectArray2 = objectArray3;
                objectArray3[0] = "contextNode";
                break;
            }
            case 66: {
                objectArray2 = objectArray3;
                objectArray3[0] = "template";
                break;
            }
            case 69: 
            case 71: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/javascript/validation/fixes/TypeScriptImplementMemberUtil";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getUnimplementedMembersForLiteral";
                break;
            }
            case 29: {
                objectArray = objectArray2;
                objectArray2[1] = "getAttributeListString";
                break;
            }
            case 35: 
            case 36: {
                objectArray = objectArray2;
                objectArray2[1] = "optimizeTypeSet";
                break;
            }
            case 47: {
                objectArray = objectArray2;
                objectArray2[1] = "getParametersAndReturnType";
                break;
            }
            case 49: {
                objectArray = objectArray2;
                objectArray2[1] = "createCompositeTypeText";
                break;
            }
            case 51: {
                objectArray = objectArray2;
                objectArray2[1] = "createCompositeType";
                break;
            }
            case 68: {
                objectArray = objectArray2;
                objectArray2[1] = "getBodyTextFromTemplate";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "implementAllMissingMembersForMemberOwner";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "getUnimplementedMembersForLiteral";
                break;
            }
            case 3: 
            case 29: 
            case 35: 
            case 36: 
            case 47: 
            case 49: 
            case 51: 
            case 68: {
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "addUnimplementedMemberCandidates";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "implementMembersForMemberOwner";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "fixAnchorNode";
                break;
            }
            case 9: 
            case 10: 
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "doImplementMembers";
                break;
            }
            case 12: 
            case 13: 
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "invokeOnMemberList";
                break;
            }
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "fixRedundantTrailingComma";
                break;
            }
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "collectPropertiesFunctionsAndIndexersForImplementation";
                break;
            }
            case 21: 
            case 22: 
            case 23: 
            case 24: {
                objectArray = objectArray;
                objectArray[2] = "addIndexerToClass";
                break;
            }
            case 25: 
            case 26: 
            case 27: {
                objectArray = objectArray;
                objectArray[2] = "addPropertyToClass";
                break;
            }
            case 28: {
                objectArray = objectArray;
                objectArray[2] = "getAttributeListString";
                break;
            }
            case 30: 
            case 31: {
                objectArray = objectArray;
                objectArray[2] = "fixTypeWithBaseTypes";
                break;
            }
            case 32: 
            case 33: {
                objectArray = objectArray;
                objectArray[2] = "getBestTypeAnnotationType";
                break;
            }
            case 34: {
                objectArray = objectArray;
                objectArray[2] = "optimizeTypeSet";
                break;
            }
            case 37: 
            case 38: 
            case 39: {
                objectArray = objectArray;
                objectArray[2] = "addFunctionToClass";
                break;
            }
            case 40: 
            case 41: 
            case 42: 
            case 43: {
                objectArray = objectArray;
                objectArray[2] = "doAddFunctions";
                break;
            }
            case 44: 
            case 45: 
            case 46: {
                objectArray = objectArray;
                objectArray[2] = "getParametersAndReturnType";
                break;
            }
            case 48: {
                objectArray = objectArray;
                objectArray[2] = "createCompositeTypeText";
                break;
            }
            case 50: {
                objectArray = objectArray;
                objectArray[2] = "createCompositeType";
                break;
            }
            case 52: 
            case 53: 
            case 54: 
            case 55: {
                objectArray = objectArray;
                objectArray[2] = "addDistinctFunctionToClass";
                break;
            }
            case 56: 
            case 57: 
            case 58: 
            case 59: {
                objectArray = objectArray;
                objectArray[2] = "buildSignatureText";
                break;
            }
            case 60: {
                objectArray = objectArray;
                objectArray[2] = "getParameterType";
                break;
            }
            case 61: 
            case 62: {
                objectArray = objectArray;
                objectArray[2] = "appendFunctionBody";
                break;
            }
            case 63: 
            case 64: 
            case 65: {
                objectArray = objectArray;
                objectArray[2] = "appendDefaultMethodBody";
                break;
            }
            case 66: 
            case 67: {
                objectArray = objectArray;
                objectArray[2] = "getBodyTextFromTemplate";
                break;
            }
            case 69: 
            case 70: {
                objectArray = objectArray;
                objectArray[2] = "fixSemicolon";
                break;
            }
            case 71: 
            case 72: {
                objectArray = objectArray;
                objectArray[2] = "appendEmptyBodyWithReturn";
                break;
            }
            case 73: 
            case 74: {
                objectArray = objectArray;
                objectArray[2] = "lambda$addIndexerToClass$3";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 3: 
            case 29: 
            case 35: 
            case 36: 
            case 47: 
            case 49: 
            case 51: 
            case 68: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class ParameterInfo {
        String name;
        String type;
        boolean isOptional;
        boolean isRest;

        private ParameterInfo() {
        }
    }

    private static class Signature {
        List<ParameterInfo> params = ContainerUtil.newArrayList();
        String returnTypeString;
        JSType returnType;
        JSAttributeList.AccessType accessType = null;

        private Signature() {
        }
    }
}

