/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.typescript.psi;

import com.intellij.codeInsight.daemon.ReferenceImporter;
import com.intellij.lang.javascript.DialectDetector;
import com.intellij.lang.javascript.modules.ES6ImportAction;
import com.intellij.lang.javascript.psi.JSElement;
import com.intellij.lang.javascript.psi.JSFile;
import com.intellij.lang.javascript.psi.JSReferenceExpression;
import com.intellij.lang.javascript.psi.resolve.JSImportHandlingUtil;
import com.intellij.lang.javascript.settings.JSApplicationSettings;
import com.intellij.lang.typescript.intentions.TypeScriptImportAction;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.util.Consumer;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 9}, bv={1, 0, 2}, k=1, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J \u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0016J\u0018\u0010\u000b\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0016J\u0010\u0010\f\u001a\u00020\u00042\u0006\u0010\u0007\u001a\u00020\bH\u0002\u00a8\u0006\r"}, d2={"Lcom/intellij/lang/typescript/psi/TypeScriptReferenceImporter;", "Lcom/intellij/codeInsight/daemon/ReferenceImporter;", "()V", "autoImportReferenceAt", "", "editor", "Lcom/intellij/openapi/editor/Editor;", "file", "Lcom/intellij/psi/PsiFile;", "offset", "", "autoImportReferenceAtCursor", "checkFileAndOption", "intellij.javascript.impl"})
public final class TypeScriptReferenceImporter
implements ReferenceImporter {
    public boolean autoImportReferenceAtCursor(@NotNull Editor editor, @NotNull PsiFile file) {
        Intrinsics.checkParameterIsNotNull((Object)editor, (String)"editor");
        Intrinsics.checkParameterIsNotNull((Object)file, (String)"file");
        if (!this.checkFileAndOption(file)) {
            return false;
        }
        return this.autoImportReferenceAt(editor, file, editor.getCaretModel().getOffset());
    }

    public boolean autoImportReferenceAt(@NotNull Editor editor, @NotNull PsiFile file, int offset) {
        Intrinsics.checkParameterIsNotNull((Object)editor, (String)"editor");
        Intrinsics.checkParameterIsNotNull((Object)file, (String)"file");
        if (!this.checkFileAndOption(file)) {
            return false;
        }
        JSReferenceExpression jSReferenceExpression = JSImportHandlingUtil.findUnresolvedReferenceExpression(editor, file, offset);
        if (jSReferenceExpression == null) {
            return false;
        }
        JSReferenceExpression expression = jSReferenceExpression;
        if (!DialectDetector.isTypeScript((PsiElement)expression) || Intrinsics.areEqual((Object)true, (Object)((Boolean)expression.getUserData(ES6ImportAction.NO_HINT_KEY)))) {
            return false;
        }
        String string = expression.getReferenceName();
        if (string == null) {
            return false;
        }
        String referenceName = string;
        TypeScriptImportAction action = new TypeScriptImportAction(editor, (PsiElement)expression, referenceName, new ES6ImportAction.DefaultElementFilter());
        List<JSElement> candidates = action.getCandidates();
        if (candidates.size() == 1) {
            expression.putUserData(ES6ImportAction.NO_HINT_KEY, (Object)true);
            action.executeFor(candidates.get(0), (Consumer<JSElement>)((Consumer)new Consumer<JSElement>(expression){
                final /* synthetic */ JSReferenceExpression $expression;

                public final void consume(JSElement it) {
                    this.$expression.putUserData(ES6ImportAction.NO_HINT_KEY, (Object)false);
                }
                {
                    this.$expression = jSReferenceExpression;
                }
            }));
            return true;
        }
        return false;
    }

    private final boolean checkFileAndOption(PsiFile file) {
        if (!(file instanceof JSFile)) {
            return false;
        }
        Project project = ((JSFile)file).getProject();
        return JSApplicationSettings.getInstance().haTSUnambiguousImportsOnTheFlyEffective(project);
    }
}

