/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.typescript.resolve;

import com.intellij.javascript.JSFunctionWithSubstitutor;
import com.intellij.lang.ecmascript6.psi.JSClassExpression;
import com.intellij.lang.javascript.DialectDetector;
import com.intellij.lang.javascript.DialectOptionHolder;
import com.intellij.lang.javascript.ecmascript6.TypeScriptImportHandler;
import com.intellij.lang.javascript.ecmascript6.TypeScriptSignatureChooser;
import com.intellij.lang.javascript.library.JSCorePredefinedLibrariesProvider;
import com.intellij.lang.javascript.psi.JSCallExpression;
import com.intellij.lang.javascript.psi.JSElement;
import com.intellij.lang.javascript.psi.JSExpression;
import com.intellij.lang.javascript.psi.JSFunction;
import com.intellij.lang.javascript.psi.JSFunctionItem;
import com.intellij.lang.javascript.psi.JSNewExpression;
import com.intellij.lang.javascript.psi.JSObjectLiteralExpression;
import com.intellij.lang.javascript.psi.JSRecordType;
import com.intellij.lang.javascript.psi.JSReferenceExpression;
import com.intellij.lang.javascript.psi.JSType;
import com.intellij.lang.javascript.psi.JSTypeEvaluationResult;
import com.intellij.lang.javascript.psi.JSTypeUtils;
import com.intellij.lang.javascript.psi.ecma6.JSTypeDeclaration;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptClass;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptFunction;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptObjectType;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptType;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptTypeParameter;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptTypeParameterList;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptTypeParameterListOwner;
import com.intellij.lang.javascript.psi.ecmal4.JSClass;
import com.intellij.lang.javascript.psi.ecmal4.JSQualifiedNamedElement;
import com.intellij.lang.javascript.psi.ecmal4.JSReferenceList;
import com.intellij.lang.javascript.psi.ecmal4.JSReferenceListMember;
import com.intellij.lang.javascript.psi.ecmal4.JSSuperExpression;
import com.intellij.lang.javascript.psi.resolve.JSEvaluateContext;
import com.intellij.lang.javascript.psi.resolve.JSGenericTypesEvaluator;
import com.intellij.lang.javascript.psi.resolve.JSInheritanceUtil;
import com.intellij.lang.javascript.psi.resolve.JSResolveUtil;
import com.intellij.lang.javascript.psi.resolve.JSTypeEvaluator;
import com.intellij.lang.javascript.psi.resolve.JSTypeResolveResult;
import com.intellij.lang.javascript.psi.resolve.JavaScriptQualifiedItemProcessor;
import com.intellij.lang.javascript.psi.stubs.TypeScriptProxyImplicitElement;
import com.intellij.lang.javascript.psi.types.JSAnyType;
import com.intellij.lang.javascript.psi.types.JSCompositeTypeImpl;
import com.intellij.lang.javascript.psi.types.JSContext;
import com.intellij.lang.javascript.psi.types.JSFunctionTypeImpl;
import com.intellij.lang.javascript.psi.types.JSGenericParameterImpl;
import com.intellij.lang.javascript.psi.types.JSGenericTypeImpl;
import com.intellij.lang.javascript.psi.types.JSIntersectionTypeImpl;
import com.intellij.lang.javascript.psi.types.JSNamedType;
import com.intellij.lang.javascript.psi.types.JSRecursiveExpandTransformer;
import com.intellij.lang.javascript.psi.types.JSResolvableType;
import com.intellij.lang.javascript.psi.types.JSResolvedTypeInfo;
import com.intellij.lang.javascript.psi.types.JSTypeImpl;
import com.intellij.lang.javascript.psi.types.JSTypeSource;
import com.intellij.lang.javascript.psi.types.JSTypeSourceFactory;
import com.intellij.lang.javascript.psi.types.JSTypeSubstitutor;
import com.intellij.lang.javascript.psi.types.TypeScriptGenericThisTypeImpl;
import com.intellij.lang.javascript.psi.types.TypeScriptTypeParser;
import com.intellij.lang.javascript.psi.types.guard.TypeScriptTypeRelations;
import com.intellij.lang.typescript.psi.TypeScriptPsiUtil;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.Ref;
import com.intellij.psi.PsiElement;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.ArrayUtil;
import com.intellij.util.Function;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.MultiMap;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class TypeScriptGenericTypesEvaluator
extends JSGenericTypesEvaluator {
    private static final TypeScriptGenericTypesEvaluator INSTANCE = new TypeScriptGenericTypesEvaluator();

    protected TypeScriptGenericTypesEvaluator() {
    }

    public static TypeScriptGenericTypesEvaluator getInstance() {
        return INSTANCE;
    }

    @Override
    @NotNull
    public JSType evaluateGenericsFromQualifier(@NotNull JSType type, @NotNull JSExpression qualifier, @NotNull JSExpression methodExpression) {
        JSType rawQualifier;
        if (type == null) {
            TypeScriptGenericTypesEvaluator.$$$reportNull$$$0(0);
        }
        if (qualifier == null) {
            TypeScriptGenericTypesEvaluator.$$$reportNull$$$0(1);
        }
        if (methodExpression == null) {
            TypeScriptGenericTypesEvaluator.$$$reportNull$$$0(2);
        }
        if (!type.getSource().isTypeScript()) {
            type = super.evaluateGenericsFromQualifier(type, qualifier, methodExpression);
        }
        boolean hasGenerics = JSTypeUtils.hasGenericParameter(type);
        boolean hasThisGenericType = JSTypeUtils.hasThisGenericType(type);
        if (!hasGenerics && !hasThisGenericType) {
            if (!(type instanceof JSResolvableType)) {
                JSType jSType = type;
                if (jSType == null) {
                    TypeScriptGenericTypesEvaluator.$$$reportNull$$$0(3);
                }
                return jSType;
            }
            JSResolvableType jsType = (JSResolvableType)type;
            JSResolvedTypeInfo resolvedType = jsType.resolveType();
            if (resolvedType != null && !resolvedType.isLocal()) {
                JSType jSType = type;
                if (jSType == null) {
                    TypeScriptGenericTypesEvaluator.$$$reportNull$$$0(4);
                }
                return jSType;
            }
        }
        if ((rawQualifier = JSResolveUtil.getExpressionJSType(qualifier)) != null && hasThisGenericType) {
            type = TypeScriptGenericTypesEvaluator.evaluateThisType(type, rawQualifier);
        }
        PsiElement sourceElement = type.getSource().getSourceElement();
        JSType jSType = type = TypeScriptGenericTypesEvaluator.evaluateGenericsFromQualifierType(type, rawQualifier, sourceElement, methodExpression);
        if (jSType == null) {
            TypeScriptGenericTypesEvaluator.$$$reportNull$$$0(5);
        }
        return jSType;
    }

    private static boolean isApplicableRecordTypeForThis(@NotNull JSRecordType recordType) {
        if (recordType == null) {
            TypeScriptGenericTypesEvaluator.$$$reportNull$$$0(6);
        }
        PsiElement sourceElement = recordType.getSource().getSourceElement();
        return sourceElement instanceof JSClassExpression;
    }

    @NotNull
    private static JSType evaluateThisType(@NotNull JSType type, final @NotNull JSType qualifierType) {
        if (type == null) {
            TypeScriptGenericTypesEvaluator.$$$reportNull$$$0(7);
        }
        if (qualifierType == null) {
            TypeScriptGenericTypesEvaluator.$$$reportNull$$$0(8);
        }
        JSType jSType = type.transformTypeHierarchy((Function)new JSRecursiveExpandTransformer(){

            @Override
            @NotNull
            protected JSType processExpanded(@NotNull JSType type) {
                if (type == null) {
                    1.$$$reportNull$$$0(0);
                }
                if (type instanceof TypeScriptGenericThisTypeImpl && (!(qualifierType instanceof JSRecordType) || TypeScriptGenericTypesEvaluator.isApplicableRecordTypeForThis((JSRecordType)qualifierType))) {
                    JSType jSType = qualifierType;
                    if (jSType == null) {
                        1.$$$reportNull$$$0(1);
                    }
                    return jSType;
                }
                JSType jSType = type;
                if (jSType == null) {
                    1.$$$reportNull$$$0(2);
                }
                return jSType;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                RuntimeException runtimeException;
                Object[] objectArray;
                Object[] objectArray2;
                int n2;
                String string;
                switch (n) {
                    default: {
                        string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                        break;
                    }
                    case 1: 
                    case 2: {
                        string = "@NotNull method %s.%s must not return null";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        n2 = 3;
                        break;
                    }
                    case 1: 
                    case 2: {
                        n2 = 2;
                        break;
                    }
                }
                Object[] objectArray3 = new Object[n2];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "type";
                        break;
                    }
                    case 1: 
                    case 2: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "com/intellij/lang/typescript/resolve/TypeScriptGenericTypesEvaluator$1";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[1] = "com/intellij/lang/typescript/resolve/TypeScriptGenericTypesEvaluator$1";
                        break;
                    }
                    case 1: 
                    case 2: {
                        objectArray = objectArray2;
                        objectArray2[1] = "processExpanded";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray;
                        objectArray[2] = "processExpanded";
                        break;
                    }
                    case 1: 
                    case 2: {
                        break;
                    }
                }
                String string2 = String.format(string, objectArray);
                switch (n) {
                    default: {
                        runtimeException = new IllegalArgumentException(string2);
                        break;
                    }
                    case 1: 
                    case 2: {
                        runtimeException = new IllegalStateException(string2);
                        break;
                    }
                }
                throw runtimeException;
            }
        });
        if (jSType == null) {
            TypeScriptGenericTypesEvaluator.$$$reportNull$$$0(9);
        }
        return jSType;
    }

    @Contract(value="!null,_,_,_ -> !null")
    private static JSType evaluateGenericsFromQualifierType(@Nullable JSType type, @Nullable JSType qualifierType, @Nullable PsiElement sourceElement, @NotNull JSExpression methodExpression) {
        JSTypeSubstitutor substitutor;
        if (methodExpression == null) {
            TypeScriptGenericTypesEvaluator.$$$reportNull$$$0(10);
        }
        if (type != null && qualifierType != null && !(substitutor = TypeScriptGenericTypesEvaluator.getTypeSubstitutorFromQualifierType(TypeScriptTypeRelations.expandTypeRecursive(qualifierType), sourceElement, (PsiElement)methodExpression)).isEmpty()) {
            type = JSTypeUtils.applyGenericArguments(type, (Map<String, JSType>)substitutor);
        }
        return type;
    }

    public boolean hasGenericsCompatibilityErrors(@NotNull List<JSType> parameterTypes, @NotNull List<JSType> arguments, @NotNull TypeScriptFunction context) {
        if (parameterTypes == null) {
            TypeScriptGenericTypesEvaluator.$$$reportNull$$$0(11);
        }
        if (arguments == null) {
            TypeScriptGenericTypesEvaluator.$$$reportNull$$$0(12);
        }
        if (context == null) {
            TypeScriptGenericTypesEvaluator.$$$reportNull$$$0(13);
        }
        List<Supplier<JSType>> argumentProviders = arguments.stream().map(el -> () -> el).collect(Collectors.toList());
        MultiMap<String, JSType> genericArguments = this.inferGenericArgumentsFromCall(parameterTypes, argumentProviders, -1, (PsiElement)context);
        final Ref hasErrors = Ref.create((Object)false);
        JSGenericTypesEvaluator.GenericErrorReporter reporter = new JSGenericTypesEvaluator.GenericErrorReporter(){

            @Override
            public void error(@NotNull String parameter) {
                if (parameter == null) {
                    2.$$$reportNull$$$0(0);
                }
                hasErrors.set((Object)true);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parameter", "com/intellij/lang/typescript/resolve/TypeScriptGenericTypesEvaluator$2", "error"));
            }
        };
        JSTypeSubstitutor substitutor = TypeScriptGenericTypesEvaluator.intersectGenerics(genericArguments, (PsiElement)context, reporter);
        if (((Boolean)hasErrors.get()).booleanValue()) {
            return true;
        }
        List<JSType> functionGenerics = TypeScriptGenericTypesEvaluator.buildGenericParameters(TypeScriptPsiUtil.getTypeParametersForOwner((PsiElement)context));
        if (functionGenerics.isEmpty()) {
            return false;
        }
        for (JSType generic : functionGenerics) {
            JSTypeUtils.applyGenericArguments(generic, (Map<String, JSType>)substitutor, true, reporter);
            if (!((Boolean)hasErrors.get()).booleanValue()) continue;
            return true;
        }
        return false;
    }

    @NotNull
    private static JSTypeSubstitutor getTypeSubstitutorFromQualifierType(@NotNull JSType qualifierType, @Nullable PsiElement sourceElement, @Nullable PsiElement place) {
        JSClass parentClass;
        JSType constraintType;
        if (qualifierType == null) {
            TypeScriptGenericTypesEvaluator.$$$reportNull$$$0(14);
        }
        JSTypeSubstitutor substitutor = new JSTypeSubstitutor();
        if ((qualifierType = JSTypeUtils.unwrapDecorations(qualifierType)) instanceof JSIntersectionTypeImpl) {
            for (JSType typeToProcess : ((JSIntersectionTypeImpl)qualifierType).getTypes()) {
                JSTypeSubstitutor candidate = TypeScriptGenericTypesEvaluator.getTypeSubstitutorFromQualifierType(typeToProcess, sourceElement, place);
                substitutor.putAll((Map)candidate);
            }
            JSTypeSubstitutor jSTypeSubstitutor = substitutor;
            if (jSTypeSubstitutor == null) {
                TypeScriptGenericTypesEvaluator.$$$reportNull$$$0(15);
            }
            return jSTypeSubstitutor;
        }
        if (qualifierType instanceof JSGenericTypeImpl) {
            JSGenericTypeImpl genericType = (JSGenericTypeImpl)qualifierType;
            Map<String, JSType> outerArguments = genericType.getOuterArguments();
            if (!outerArguments.isEmpty()) {
                substitutor.putAll(outerArguments);
            }
            if (genericType.getType() instanceof TypeScriptGenericThisTypeImpl) {
                qualifierType = new JSGenericTypeImpl(genericType.getSource(), genericType.getType().substitute(), genericType.getArguments(), genericType.getOuterArguments());
            }
        } else if (qualifierType instanceof JSRecordType) {
            PsiElement qualifierSource = qualifierType.getSource().getSourceElement();
            JSType objectType = null;
            if (qualifierSource instanceof TypeScriptObjectType) {
                objectType = TypeScriptTypeParser.buildTypeFromTypeScript((JSTypeDeclaration)((TypeScriptObjectType)qualifierSource));
            } else if (qualifierSource instanceof JSClass) {
                objectType = TypeScriptTypeParser.buildTypeFromClass((JSClass)qualifierSource, false);
            } else if (qualifierSource instanceof JSObjectLiteralExpression) {
                objectType = JSResolveUtil.getExpressionJSType((JSExpression)qualifierSource);
            }
            if (objectType != null) {
                if (objectType.isEquivalentTo(qualifierType, null, false)) {
                    JSTypeSubstitutor jSTypeSubstitutor = substitutor;
                    if (jSTypeSubstitutor == null) {
                        TypeScriptGenericTypesEvaluator.$$$reportNull$$$0(16);
                    }
                    return jSTypeSubstitutor;
                }
                MultiMap<String, JSType> generics = TypeScriptGenericTypesEvaluator.findGenericsTypeValues(qualifierType, objectType);
                if (!generics.isEmpty()) {
                    JSTypeSubstitutor candidate = TypeScriptGenericTypesEvaluator.intersectGenerics(generics, sourceElement, null);
                    substitutor.putAll((Map)candidate);
                    JSTypeSubstitutor jSTypeSubstitutor = substitutor;
                    if (jSTypeSubstitutor == null) {
                        TypeScriptGenericTypesEvaluator.$$$reportNull$$$0(17);
                    }
                    return jSTypeSubstitutor;
                }
            }
        } else if (qualifierType instanceof TypeScriptGenericThisTypeImpl) {
            qualifierType = qualifierType.substitute();
        }
        List<JSType> arguments = JSTypeUtils.getGenericTypeArguments(qualifierType);
        if (arguments == null && qualifierType instanceof JSGenericParameterImpl && (constraintType = ((JSGenericParameterImpl)qualifierType).getConstraintType()) != null) {
            qualifierType = constraintType;
            arguments = JSTypeUtils.getGenericTypeArguments(qualifierType);
        }
        if (sourceElement != null && (arguments != null && JSTypeUtils.getQualifiedNameMatchingType(qualifierType, false) != null || qualifierType instanceof JSTypeImpl) && (parentClass = (JSClass)PsiTreeUtil.getStubOrPsiParentOfType((PsiElement)sourceElement, JSClass.class)) != null) {
            Collection<JSClass> qualifierClasses = TypeScriptGenericTypesEvaluator.getQualifierClasses(qualifierType, place);
            for (JSClass qualifierClass : qualifierClasses) {
                List<JSType> argumentsList = arguments == null || arguments.isEmpty() ? TypeScriptGenericTypesEvaluator.getArgumentsListForQualifierType(qualifierType, qualifierClass) : arguments;
                Ref ref = Ref.create((Object)substitutor);
                TypeScriptGenericTypesEvaluator.processClassWithGenericArguments(qualifierClass, argumentsList, parentClass, (Ref<JSTypeSubstitutor>)ref);
                if (ref.isNull()) continue;
                substitutor = (JSTypeSubstitutor)ref.get();
            }
        }
        JSTypeSubstitutor jSTypeSubstitutor = substitutor;
        if (jSTypeSubstitutor == null) {
            TypeScriptGenericTypesEvaluator.$$$reportNull$$$0(18);
        }
        return jSTypeSubstitutor;
    }

    @NotNull
    private static List<JSType> getArgumentsListForQualifierType(@NotNull JSType qualifierType, @NotNull JSClass qualifierClass) {
        TypeScriptTypeParameter[] parameters;
        if (qualifierType == null) {
            TypeScriptGenericTypesEvaluator.$$$reportNull$$$0(19);
        }
        if (qualifierClass == null) {
            TypeScriptGenericTypesEvaluator.$$$reportNull$$$0(20);
        }
        if (TypeScriptGenericTypesEvaluator.isInstanceJSTypeImpl(qualifierType) && (parameters = TypeScriptPsiUtil.getTypeParametersForOwner((PsiElement)qualifierClass)).length > 0) {
            List<JSType> list = Arrays.stream(parameters).map(JSGenericTypesEvaluator::getTypeParameterDefaultType).collect(Collectors.toList());
            if (list == null) {
                TypeScriptGenericTypesEvaluator.$$$reportNull$$$0(21);
            }
            return list;
        }
        List list = ContainerUtil.emptyList();
        if (list == null) {
            TypeScriptGenericTypesEvaluator.$$$reportNull$$$0(22);
        }
        return list;
    }

    private static boolean isInstanceJSTypeImpl(@NotNull JSType qualifierType) {
        if (qualifierType == null) {
            TypeScriptGenericTypesEvaluator.$$$reportNull$$$0(23);
        }
        return qualifierType instanceof JSTypeImpl && ((JSTypeImpl)qualifierType).getTypeContext().toJSContext() == JSContext.INSTANCE;
    }

    @NotNull
    public static JSType processClassWithGenericArguments(@Nullable JSClass aClass, @NotNull List<JSType> typeArgumentsList, @Nullable JSClass requiredParentClass, @NotNull JSType appliedGenerics) {
        if (typeArgumentsList == null) {
            TypeScriptGenericTypesEvaluator.$$$reportNull$$$0(24);
        }
        if (appliedGenerics == null) {
            TypeScriptGenericTypesEvaluator.$$$reportNull$$$0(25);
        }
        Ref substitutor = Ref.create();
        TypeScriptGenericTypesEvaluator.processClassWithGenericArguments(aClass, typeArgumentsList, requiredParentClass, (Ref<JSTypeSubstitutor>)substitutor);
        JSType jSType = JSTypeUtils.applyGenericArguments(appliedGenerics, (Map)substitutor.get());
        if (jSType == null) {
            TypeScriptGenericTypesEvaluator.$$$reportNull$$$0(26);
        }
        return jSType;
    }

    public static void processClassWithGenericArguments(@Nullable JSClass contextClass, @NotNull List<JSType> typeArgumentsList, @Nullable JSClass expectedGenericOwnerClass, @NotNull Ref<JSTypeSubstitutor> substitutor) {
        if (typeArgumentsList == null) {
            TypeScriptGenericTypesEvaluator.$$$reportNull$$$0(27);
        }
        if (substitutor == null) {
            TypeScriptGenericTypesEvaluator.$$$reportNull$$$0(28);
        }
        TypeScriptGenericTypesEvaluator.processClassWithGenericArguments(contextClass, typeArgumentsList, expectedGenericOwnerClass, substitutor, ContainerUtil.newHashSet());
    }

    public static boolean processClassWithGenericArguments(@Nullable JSClass contextClass, @NotNull List<JSType> typeArgumentsList, @Nullable JSClass expectedGenericOwnerClass, @NotNull Ref<JSTypeSubstitutor> substitutor, @NotNull Set<JSClass> visitedClasses) {
        if (typeArgumentsList == null) {
            TypeScriptGenericTypesEvaluator.$$$reportNull$$$0(29);
        }
        if (substitutor == null) {
            TypeScriptGenericTypesEvaluator.$$$reportNull$$$0(30);
        }
        if (visitedClasses == null) {
            TypeScriptGenericTypesEvaluator.$$$reportNull$$$0(31);
        }
        if (!(contextClass instanceof TypeScriptTypeParameterListOwner) || expectedGenericOwnerClass == null) {
            return true;
        }
        if (contextClass.isEquivalentTo((PsiElement)expectedGenericOwnerClass)) {
            JSTypeSubstitutor genericArguments = TypeScriptGenericTypesEvaluator.getSubstitutorForTypeArguments((TypeScriptTypeParameterListOwner)contextClass, typeArgumentsList);
            JSTypeSubstitutor oldSubstitutor = (JSTypeSubstitutor)substitutor.get();
            if (oldSubstitutor != null && genericArguments != null) {
                genericArguments.putAll((Map)oldSubstitutor);
            }
            substitutor.set((Object)genericArguments);
            return false;
        }
        ArrayList superReferences = ContainerUtil.newArrayList();
        JSReferenceList extendsList = contextClass.getExtendsList();
        JSReferenceList implementsList = contextClass.getImplementsList();
        if (extendsList != null) {
            superReferences.addAll(extendsList.getResolvedExpressions());
        }
        if (implementsList != null) {
            superReferences.addAll(implementsList.getResolvedExpressions());
        }
        if (!superReferences.isEmpty()) {
            JSTypeSubstitutor typeArguments = TypeScriptGenericTypesEvaluator.getSubstitutorForTypeArguments((TypeScriptTypeParameterListOwner)contextClass, typeArgumentsList);
            for (Pair reference : superReferences) {
                if (((Collection)reference.second).isEmpty()) continue;
                List<JSType> superclassTypeArguments = TypeScriptGenericTypesEvaluator.getTypeArgumentsForDeclarations(((JSReferenceListMember)reference.first).getTypeArguments(), (Map<String, JSType>)typeArguments);
                for (JSClass jsSuperClass : (Collection)reference.second) {
                    if (!JSInheritanceUtil.isParentClass(jsSuperClass, expectedGenericOwnerClass, false)) continue;
                    if (!visitedClasses.add(jsSuperClass)) {
                        return false;
                    }
                    if (TypeScriptGenericTypesEvaluator.processClassWithGenericArguments(jsSuperClass, superclassTypeArguments, expectedGenericOwnerClass, substitutor, visitedClasses)) continue;
                    return false;
                }
            }
        }
        return true;
    }

    @NotNull
    public static List<JSType> getTypeArgumentsForDeclarations(@NotNull JSTypeDeclaration[] declarations, @Nullable Map<String, JSType> typeArguments) {
        if (declarations == null) {
            TypeScriptGenericTypesEvaluator.$$$reportNull$$$0(32);
        }
        List mappedArguments = ContainerUtil.newSmartList();
        for (JSTypeDeclaration typeArgument : declarations) {
            JSType expandedType = TypeScriptTypeParser.buildTypeFromTypeScript(typeArgument);
            if (typeArguments != null) {
                expandedType = JSTypeUtils.applyGenericArguments(expandedType, typeArguments);
            }
            mappedArguments.add(expandedType);
        }
        List list = mappedArguments;
        if (list == null) {
            TypeScriptGenericTypesEvaluator.$$$reportNull$$$0(33);
        }
        return list;
    }

    @Nullable
    public static JSTypeSubstitutor getSubstitutorForTypeArguments(@Nullable TypeScriptTypeParameterListOwner typeParameterListOwner, @Nullable JSType genericType) {
        List<JSType> arguments = JSTypeUtils.getGenericTypeArguments(genericType);
        return arguments == null ? null : TypeScriptGenericTypesEvaluator.getSubstitutorForTypeArguments(typeParameterListOwner, arguments);
    }

    @Nullable
    public static JSTypeSubstitutor getSubstitutorForTypeArguments(@Nullable TypeScriptTypeParameterListOwner typeParameterListOwner, @NotNull List<JSType> typeArgumentsList) {
        if (typeArgumentsList == null) {
            TypeScriptGenericTypesEvaluator.$$$reportNull$$$0(34);
        }
        if (typeParameterListOwner == null) {
            return null;
        }
        return TypeScriptGenericTypesEvaluator.getSubstitutorForTypeArguments(typeParameterListOwner.getTypeParameterList(), typeArgumentsList);
    }

    @Nullable
    public static JSTypeSubstitutor getSubstitutorForTypeArguments(@Nullable TypeScriptTypeParameterList typeParameterList, @NotNull List<JSType> typeArgumentsList) {
        if (typeArgumentsList == null) {
            TypeScriptGenericTypesEvaluator.$$$reportNull$$$0(35);
        }
        if (typeArgumentsList.isEmpty() || typeParameterList == null) {
            return null;
        }
        TypeScriptTypeParameter[] parameters = typeParameterList.getTypeParameters();
        return TypeScriptGenericTypesEvaluator.getSubstitutorForTypeArguments(parameters, typeArgumentsList);
    }

    @NotNull
    public static JSTypeSubstitutor getSubstitutorForTypeArguments(@NotNull TypeScriptTypeParameter[] parameters, @NotNull List<JSType> typeArgumentsList) {
        if (parameters == null) {
            TypeScriptGenericTypesEvaluator.$$$reportNull$$$0(36);
        }
        if (typeArgumentsList == null) {
            TypeScriptGenericTypesEvaluator.$$$reportNull$$$0(37);
        }
        if (typeArgumentsList.size() == 0 || parameters.length == 0) {
            JSTypeSubstitutor jSTypeSubstitutor = new JSTypeSubstitutor();
            if (jSTypeSubstitutor == null) {
                TypeScriptGenericTypesEvaluator.$$$reportNull$$$0(38);
            }
            return jSTypeSubstitutor;
        }
        JSTypeSubstitutor genericArguments = new JSTypeSubstitutor();
        for (int i = 0; i < parameters.length; ++i) {
            String name;
            TypeScriptTypeParameter parameter = parameters[i];
            JSType type = null;
            if (typeArgumentsList.size() > i) {
                type = typeArgumentsList.get(i);
            }
            if (type == null) {
                type = TypeScriptGenericTypesEvaluator.getTypeParameterDefaultType(parameter);
            }
            if ((name = parameter.getName()) == null) continue;
            genericArguments.put((Object)name, (Object)type);
        }
        JSTypeSubstitutor jSTypeSubstitutor = genericArguments;
        if (jSTypeSubstitutor == null) {
            TypeScriptGenericTypesEvaluator.$$$reportNull$$$0(39);
        }
        return jSTypeSubstitutor;
    }

    @Override
    @Nullable
    public JSType evaluateGenerics(@Nullable JSType type, @Nullable JSExpression methodExpression, @Nullable PsiElement resolvedFunction, @Nullable JSGenericTypesEvaluator.GenericErrorReporter reporter, int paramToSkip) {
        if (!this.canHaveGenericParameters(type)) {
            return type;
        }
        if (methodExpression != null) {
            JSReferenceList list;
            TypeScriptClass tsClass;
            PsiElement callExpression = methodExpression.getParent();
            JSTypeSubstitutor map = TypeScriptGenericTypesEvaluator.addExplicitGenericArgumentsFromCall(resolvedFunction, callExpression, null);
            if (TypeScriptGenericTypesEvaluator.isConstructorSuperCall(resolvedFunction, (PsiElement)methodExpression) && (tsClass = (TypeScriptClass)PsiTreeUtil.getStubOrPsiParentOfType((PsiElement)methodExpression, TypeScriptClass.class)) != null && resolvedFunction instanceof TypeScriptFunction && (list = tsClass.getExtendsList()) != null) {
                if (tsClass.getIndirectSuperConstructors().contains(resolvedFunction)) {
                    JSExpression element = (JSExpression)ArrayUtil.getFirstElement((Object[])list.getExpressions());
                    List<JSType> typesForGenerics = element != null ? TypeScriptGenericTypesEvaluator.getTypeArgumentsForDeclarations(TypeScriptPsiUtil.getNestedTypeArguments(element.getParent()), null) : ContainerUtil.emptyList();
                    TypeScriptFunction tsFunction = (TypeScriptFunction)resolvedFunction;
                    JSTypeSubstitutor argumentsFromSuper = TypeScriptGenericTypesEvaluator.getSubstitutorForTypeArguments((TypeScriptTypeParameterListOwner)tsFunction, typesForGenerics);
                    if (map != null && argumentsFromSuper != null) {
                        map.putAll(argumentsFromSuper);
                    }
                } else {
                    JSClass parentClass = (JSClass)PsiTreeUtil.getStubOrPsiParentOfType((PsiElement)resolvedFunction, JSClass.class);
                    type = TypeScriptGenericTypesEvaluator.processClassWithGenericArguments((JSClass)tsClass, (List<JSType>)ContainerUtil.emptyList(), parentClass, type);
                }
            }
            type = JSTypeUtils.applyGenericArguments(type, (Map<String, JSType>)map, false, reporter);
        }
        return super.evaluateGenerics(type, methodExpression, resolvedFunction, reporter, paramToSkip);
    }

    @NotNull
    public JSTypeSubstitutor getTypeSubstitutorForMember(@Nullable PsiElement member, @Nullable PsiElement place, @Nullable JSType qualifierType, @Nullable JSTypeSubstitutor additionalSubstitutor) {
        JSTypeSubstitutor candidate;
        PsiElement parent;
        boolean isFunctionCallContext;
        if (member instanceof TypeScriptProxyImplicitElement) {
            member = ((TypeScriptProxyImplicitElement)member).getExplicitElement();
        }
        if (place == null || !(member instanceof JSQualifiedNamedElement)) {
            JSTypeSubstitutor jSTypeSubstitutor = JSTypeSubstitutor.EMPTY;
            if (jSTypeSubstitutor == null) {
                TypeScriptGenericTypesEvaluator.$$$reportNull$$$0(40);
            }
            return jSTypeSubstitutor;
        }
        JSTypeSubstitutor substitutor = new JSTypeSubstitutor();
        if (additionalSubstitutor != null) {
            substitutor.putAll((Map)additionalSubstitutor);
        }
        boolean bl = isFunctionCallContext = (parent = place.getParent()) instanceof JSCallExpression && member instanceof TypeScriptTypeParameterListOwner;
        if (isFunctionCallContext) {
            candidate = this.inferGenericTypesForCall(member, (JSCallExpression)parent, null);
            candidate.forEach((key, value) -> {
                if (!(value instanceof JSAnyType)) {
                    substitutor.put(key, value);
                }
            });
        }
        if (qualifierType != null) {
            candidate = TypeScriptGenericTypesEvaluator.getTypeSubstitutorFromQualifierType(qualifierType, member, place);
            substitutor.putAll((Map)candidate);
        }
        if (isFunctionCallContext) {
            substitutor.putAll((Map)TypeScriptGenericTypesEvaluator.addExplicitGenericArgumentsFromCall(member, parent, substitutor));
        }
        JSTypeSubstitutor jSTypeSubstitutor = substitutor;
        if (jSTypeSubstitutor == null) {
            TypeScriptGenericTypesEvaluator.$$$reportNull$$$0(41);
        }
        return jSTypeSubstitutor;
    }

    @NotNull
    public JSTypeSubstitutor getTypeSubstitutorForMember(@Nullable JSElement member, @NotNull PsiElement place) {
        List<JSFunctionWithSubstitutor> elements;
        JSFunctionWithSubstitutor functionWithSubstitutor;
        if (place == null) {
            TypeScriptGenericTypesEvaluator.$$$reportNull$$$0(42);
        }
        if (member == null || !DialectDetector.isTypeScript((PsiElement)member) || !(place instanceof JSReferenceExpression)) {
            JSTypeSubstitutor jSTypeSubstitutor = JSTypeSubstitutor.EMPTY;
            if (jSTypeSubstitutor == null) {
                TypeScriptGenericTypesEvaluator.$$$reportNull$$$0(43);
            }
            return jSTypeSubstitutor;
        }
        JSReferenceExpression referenceExpression = (JSReferenceExpression)place;
        JSExpression qualifier = referenceExpression.getQualifier();
        JSType qualifierType = null;
        if (qualifier != null) {
            qualifierType = JSResolveUtil.getExpressionJSType(qualifier);
        }
        if (referenceExpression.getParent() instanceof JSCallExpression && (functionWithSubstitutor = (JSFunctionWithSubstitutor)ContainerUtil.getFirstItem(elements = TypeScriptSignatureChooser.getFunctionElementsWithCheckParameterTypes((PsiElement)referenceExpression))) != null) {
            JSFunctionItem functionItem = functionWithSubstitutor.myFunctionItem;
            JSTypeSubstitutor additionalSubstitutor = functionWithSubstitutor.myTypeSubstitutor;
            JSTypeSubstitutor jSTypeSubstitutor = this.getTypeSubstitutorForMember((PsiElement)functionItem, place, qualifierType, additionalSubstitutor);
            if (jSTypeSubstitutor == null) {
                TypeScriptGenericTypesEvaluator.$$$reportNull$$$0(44);
            }
            return jSTypeSubstitutor;
        }
        JSTypeSubstitutor jSTypeSubstitutor = this.getTypeSubstitutorForMember((PsiElement)member, place, qualifierType, null);
        if (jSTypeSubstitutor == null) {
            TypeScriptGenericTypesEvaluator.$$$reportNull$$$0(45);
        }
        return jSTypeSubstitutor;
    }

    private static boolean isConstructorSuperCall(PsiElement resolveResult, PsiElement callExpression) {
        return callExpression instanceof JSSuperExpression && callExpression.getParent() instanceof JSCallExpression && resolveResult instanceof JSFunction && ((JSFunction)resolveResult).isConstructor();
    }

    @Nullable
    public static JSType getParameterExpressionType(@NotNull JSExpression expression) {
        if (expression == null) {
            TypeScriptGenericTypesEvaluator.$$$reportNull$$$0(46);
        }
        Ref exprTypeRef = Ref.create(null);
        JSTypeEvaluator.processWithEvaluationGuard(expression, JSEvaluateContext.JSEvaluationPlace.PARAMETER_TYPE, e -> exprTypeRef.set((Object)JSTypeEvaluator.getExpressionType(e)));
        JSTypeEvaluationResult result2 = (JSTypeEvaluationResult)exprTypeRef.get();
        if (result2 == null) {
            return null;
        }
        List<JSTypeEvaluationResult.JSTypeEvaluationResultElement> results = result2.getResults();
        if (results.size() <= 1) {
            return JSTypeUtils.getValuableType(result2.getType());
        }
        ArrayList types = ContainerUtil.newArrayList();
        JSTypeSource source = null;
        for (JSTypeEvaluationResult.JSTypeEvaluationResultElement element : results) {
            JSType type = JSTypeUtils.getValuableType(element.getType());
            if (type == null) continue;
            types.add(type);
            JSTypeSource typeSource = type.getSource();
            source = source == null ? typeSource : JSTypeSourceFactory.copyTypeSource(source, source.isStrict() && typeSource.isStrict());
        }
        if (types.size() <= 1) {
            return (JSType)ContainerUtil.getFirstItem((List)types);
        }
        return new JSCompositeTypeImpl(source == null ? JSTypeSource.EMPTY_TS : source, types);
    }

    public static void fillExplicitGenericArguments(@NotNull TypeScriptTypeParameter[] typeParameters, @NotNull JSTypeDeclaration[] typeArguments, @NotNull Map<String, JSType> genericArguments) {
        if (typeParameters == null) {
            TypeScriptGenericTypesEvaluator.$$$reportNull$$$0(47);
        }
        if (typeArguments == null) {
            TypeScriptGenericTypesEvaluator.$$$reportNull$$$0(48);
        }
        if (genericArguments == null) {
            TypeScriptGenericTypesEvaluator.$$$reportNull$$$0(49);
        }
        if (typeParameters.length == 0) {
            return;
        }
        for (int i = 0; i < typeParameters.length; ++i) {
            String name;
            JSType type;
            TypeScriptTypeParameter parameter = typeParameters[i];
            JSTypeDeclaration typeArgument = typeArguments.length > i ? typeArguments[i] : null;
            JSType jSType = type = typeArgument != null ? TypeScriptTypeParser.buildTypeFromTypeScript(typeArgument) : null;
            if (typeArguments.length > 0 && type == null) {
                type = TypeScriptGenericTypesEvaluator.getTypeParameterDefaultType(parameter);
            }
            if ((name = parameter.getName()) == null || genericArguments.containsKey(name) && type == null) continue;
            genericArguments.put(name, type);
        }
    }

    @Contract(value="_,_,!null -> !null")
    public static JSTypeSubstitutor addExplicitGenericArgumentsFromCall(PsiElement resolveResult, PsiElement callExpression, @Nullable JSTypeSubstitutor genericArguments) {
        TypeScriptTypeParameter[] typeParameters;
        JSClass clazz;
        if (!(resolveResult instanceof TypeScriptTypeParameterListOwner)) {
            return genericArguments == null ? null : new JSTypeSubstitutor((Map)genericArguments);
        }
        JSTypeSubstitutor substitutor = genericArguments == null ? new JSTypeSubstitutor() : new JSTypeSubstitutor((Map)genericArguments);
        TypeScriptTypeParameterList typeParameterList = ((TypeScriptTypeParameterListOwner)resolveResult).getTypeParameterList();
        if (typeParameterList != null) {
            TypeScriptTypeParameter[] typeParameters2 = typeParameterList.getTypeParameters();
            JSTypeDeclaration[] typeArguments = TypeScriptPsiUtil.getNestedTypeArguments(callExpression);
            TypeScriptGenericTypesEvaluator.fillExplicitGenericArguments(typeParameters2, typeArguments, (Map<String, JSType>)substitutor);
        }
        if ((clazz = (JSClass)PsiTreeUtil.getStubOrPsiParentOfType((PsiElement)resolveResult, JSClass.class)) instanceof TypeScriptTypeParameterListOwner && (typeParameters = TypeScriptPsiUtil.getTypeParametersForOwner((PsiElement)clazz)).length > 0) {
            JSTypeDeclaration[] typeArguments = TypeScriptPsiUtil.getNewExpressionTypeArguments(callExpression);
            TypeScriptGenericTypesEvaluator.fillExplicitGenericArguments(typeParameters, typeArguments, (Map<String, JSType>)substitutor);
        }
        return substitutor;
    }

    @NotNull
    public static List<JSType> getArgumentTypesForSignatureChecking(@NotNull JSCallExpression callExpression) {
        if (callExpression == null) {
            TypeScriptGenericTypesEvaluator.$$$reportNull$$$0(50);
        }
        List<JSType> list = TypeScriptGenericTypesEvaluator.getArgumentTypesForSignatureChecking(callExpression.getArguments());
        if (list == null) {
            TypeScriptGenericTypesEvaluator.$$$reportNull$$$0(51);
        }
        return list;
    }

    @NotNull
    public static List<JSType> getArgumentTypesForSignatureChecking(JSExpression[] arguments) {
        if (arguments.length == 0) {
            List list = ContainerUtil.emptyList();
            if (list == null) {
                TypeScriptGenericTypesEvaluator.$$$reportNull$$$0(52);
            }
            return list;
        }
        DialectOptionHolder holder = DialectDetector.dialectOfElement((PsiElement)ArrayUtil.getFirstElement((Object[])arguments));
        boolean isTypeScript = holder != null && holder.isTypeScript;
        List argumentTypes = ContainerUtil.newSmartList();
        for (JSExpression expression : arguments) {
            JSType type = TypeScriptGenericTypesEvaluator.getParameterExpressionType(expression);
            argumentTypes.add(isTypeScript ? TypeScriptGenericTypesEvaluator.getExplicitTypeOrAny((PsiElement)expression, type) : (type != null ? type : JSAnyType.get((PsiElement)expression, false)));
        }
        List list = argumentTypes;
        if (list == null) {
            TypeScriptGenericTypesEvaluator.$$$reportNull$$$0(53);
        }
        return list;
    }

    @NotNull
    public static JSType getExplicitTypeOrAny(@NotNull PsiElement expression, @Nullable JSType type) {
        if (expression == null) {
            TypeScriptGenericTypesEvaluator.$$$reportNull$$$0(54);
        }
        JSType jSType = type == null ? JSAnyType.get(expression, false) : JSTypeUtils.replaceImplicitTypesWithAny(type);
        if (jSType == null) {
            TypeScriptGenericTypesEvaluator.$$$reportNull$$$0(55);
        }
        return jSType;
    }

    @NotNull
    public static Collection<JSClass> getQualifierClasses(@Nullable JSType qualifierType, @Nullable PsiElement place) {
        if (qualifierType == null) {
            List list = ContainerUtil.emptyList();
            if (list == null) {
                TypeScriptGenericTypesEvaluator.$$$reportNull$$$0(56);
            }
            return list;
        }
        JSTypeSource source = qualifierType.getSource();
        String type = JSTypeUtils.getQualifiedNameMatchingType(qualifierType, false);
        PsiElement element = source.getSourceElement();
        if (type == null || element == null) {
            List list = ContainerUtil.emptyList();
            if (list == null) {
                TypeScriptGenericTypesEvaluator.$$$reportNull$$$0(57);
            }
            return list;
        }
        Collection<? extends PsiElement> elements = TypeScriptGenericTypesEvaluator.getElementsForQualifierClassName(type, element, place);
        List result2 = ContainerUtil.newSmartList();
        for (PsiElement psiElement : elements) {
            if (!(psiElement instanceof JSClass)) continue;
            result2.add((JSClass)psiElement);
        }
        List list = result2;
        if (list == null) {
            TypeScriptGenericTypesEvaluator.$$$reportNull$$$0(58);
        }
        return list;
    }

    @NotNull
    private static Collection<? extends PsiElement> getElementsForQualifierClassName(@NotNull String type, @NotNull PsiElement element, @Nullable PsiElement place) {
        boolean isJSPlace;
        if (type == null) {
            TypeScriptGenericTypesEvaluator.$$$reportNull$$$0(59);
        }
        if (element == null) {
            TypeScriptGenericTypesEvaluator.$$$reportNull$$$0(60);
        }
        boolean bl = isJSPlace = place != null && !DialectDetector.isTypeScript(place);
        if (isJSPlace && (!DialectDetector.isTypeScript(element) || JSCorePredefinedLibrariesProvider.isLibraryElement(element))) {
            Collection<PsiElement> collection = JavaScriptQualifiedItemProcessor.resolveGlobalTypeElementsByName(type, place);
            if (collection == null) {
                TypeScriptGenericTypesEvaluator.$$$reportNull$$$0(61);
            }
            return collection;
        }
        JSTypeResolveResult resolveResults = TypeScriptImportHandler.getInstance().resolveMainElementName(type, element);
        Collection<? extends PsiElement> collection = resolveResults.getElements();
        if (collection == null) {
            TypeScriptGenericTypesEvaluator.$$$reportNull$$$0(62);
        }
        return collection;
    }

    @NotNull
    public static List<JSType> buildGenericParameters(@NotNull TypeScriptTypeParameter[] parameters) {
        if (parameters == null) {
            TypeScriptGenericTypesEvaluator.$$$reportNull$$$0(63);
        }
        List<JSType> list = TypeScriptGenericTypesEvaluator.buildGenericParameters(parameters, false);
        if (list == null) {
            TypeScriptGenericTypesEvaluator.$$$reportNull$$$0(64);
        }
        return list;
    }

    @NotNull
    public static List<JSType> buildGenericParameters(@NotNull TypeScriptTypeParameter[] parameters, boolean callEnv) {
        if (parameters == null) {
            TypeScriptGenericTypesEvaluator.$$$reportNull$$$0(65);
        }
        ArrayList generics = ContainerUtil.newArrayList();
        for (TypeScriptTypeParameter parameter : parameters) {
            String name;
            TypeScriptType constraint = parameter.getTypeConstraint();
            JSType constraintType = null;
            if (constraint != null) {
                constraintType = TypeScriptTypeParser.buildTypeFromTypeScript((JSTypeDeclaration)constraint);
            }
            if ((name = parameter.getName()) == null) continue;
            generics.add(new JSGenericParameterImpl(name, JSTypeSourceFactory.createTypeSource((PsiElement)parameter, true), constraintType, callEnv));
        }
        ArrayList arrayList = generics;
        if (arrayList == null) {
            TypeScriptGenericTypesEvaluator.$$$reportNull$$$0(66);
        }
        return arrayList;
    }

    @NotNull
    public static JSType applyTypeScriptGenericArguments(@NotNull JSFunctionTypeImpl functionType, @NotNull JSCallExpression callExpression) {
        if (functionType == null) {
            TypeScriptGenericTypesEvaluator.$$$reportNull$$$0(67);
        }
        if (callExpression == null) {
            TypeScriptGenericTypesEvaluator.$$$reportNull$$$0(68);
        }
        JSType jSType = TypeScriptGenericTypesEvaluator.applyTypeScriptGenericArguments(functionType, callExpression.getMethodExpression(), callExpression instanceof JSNewExpression, TypeScriptPsiUtil.getNestedTypeArguments((PsiElement)callExpression));
        if (jSType == null) {
            TypeScriptGenericTypesEvaluator.$$$reportNull$$$0(69);
        }
        return jSType;
    }

    @NotNull
    public static JSType applyTypeScriptGenericArguments(@NotNull JSFunctionTypeImpl functionType, @Nullable JSExpression methodExpression, boolean isNewExpression, @NotNull JSTypeDeclaration[] typeArguments) {
        if (functionType == null) {
            TypeScriptGenericTypesEvaluator.$$$reportNull$$$0(70);
        }
        if (typeArguments == null) {
            TypeScriptGenericTypesEvaluator.$$$reportNull$$$0(71);
        }
        PsiElement sourceElement = functionType.getSource().getSourceElement();
        JSTypeSubstitutor defaultParamsSubstitutor = new JSTypeSubstitutor();
        JSFunctionTypeImpl resultType = isNewExpression && sourceElement instanceof TypeScriptClass ? TypeScriptGenericTypesEvaluator.wrapNewExpressionReturnTypeWithGenerics(functionType, defaultParamsSubstitutor, typeArguments) : functionType;
        JSType evaluatedType = TypeScriptGenericTypesEvaluator.getInstance().evaluateGenerics(resultType, methodExpression, sourceElement);
        JSType jSType = JSTypeUtils.applyGenericArguments(evaluatedType, (Map<String, JSType>)defaultParamsSubstitutor);
        if (jSType == null) {
            TypeScriptGenericTypesEvaluator.$$$reportNull$$$0(72);
        }
        return jSType;
    }

    @NotNull
    private static JSType wrapNewExpressionReturnTypeWithGenerics(@NotNull JSFunctionTypeImpl functionType, @NotNull JSTypeSubstitutor defaultParamsSubstitutor, @NotNull JSTypeDeclaration[] typeArguments) {
        if (functionType == null) {
            TypeScriptGenericTypesEvaluator.$$$reportNull$$$0(73);
        }
        if (defaultParamsSubstitutor == null) {
            TypeScriptGenericTypesEvaluator.$$$reportNull$$$0(74);
        }
        if (typeArguments == null) {
            TypeScriptGenericTypesEvaluator.$$$reportNull$$$0(75);
        }
        PsiElement sourceElement = functionType.getSource().getSourceElement();
        JSType returnType = functionType.getReturnType();
        TypeScriptTypeParameter[] typeParameters = TypeScriptPsiUtil.getTypeParametersForOwner(sourceElement);
        if (typeParameters.length > 0 && returnType instanceof JSNamedType) {
            List<JSType> defaultGenerics;
            if (typeArguments.length == 0) {
                Arrays.stream(typeParameters).forEach(el -> {
                    if (defaultParamsSubstitutor == null) {
                        TypeScriptGenericTypesEvaluator.$$$reportNull$$$0(84);
                    }
                    JSType cfr_ignored_0 = (JSType)defaultParamsSubstitutor.put((Object)el.getName(), (Object)TypeScriptGenericTypesEvaluator.getTypeParameterDefaultType(el));
                });
                defaultGenerics = TypeScriptGenericTypesEvaluator.buildGenericParameters(typeParameters);
            } else {
                defaultGenerics = TypeScriptGenericTypesEvaluator.getTypeArgumentsForDeclarations(typeArguments, (Map<String, JSType>)defaultParamsSubstitutor);
            }
            JSGenericTypeImpl newReturnType = new JSGenericTypeImpl(functionType.getSource(), returnType, defaultGenerics);
            JSFunctionTypeImpl jSFunctionTypeImpl = new JSFunctionTypeImpl(functionType.getSource(), functionType.getParameters(), newReturnType);
            if (jSFunctionTypeImpl == null) {
                TypeScriptGenericTypesEvaluator.$$$reportNull$$$0(76);
            }
            return jSFunctionTypeImpl;
        }
        JSFunctionTypeImpl jSFunctionTypeImpl = functionType;
        if (jSFunctionTypeImpl == null) {
            TypeScriptGenericTypesEvaluator.$$$reportNull$$$0(77);
        }
        return jSFunctionTypeImpl;
    }

    @NotNull
    public static JSTypeSubstitutor getTypeSubstitutorForExtendClass(@NotNull JSClass contextClass, @NotNull JSClass genericOwner) {
        if (contextClass == null) {
            TypeScriptGenericTypesEvaluator.$$$reportNull$$$0(78);
        }
        if (genericOwner == null) {
            TypeScriptGenericTypesEvaluator.$$$reportNull$$$0(79);
        }
        if (!(genericOwner instanceof TypeScriptTypeParameterListOwner)) {
            JSTypeSubstitutor jSTypeSubstitutor = JSTypeSubstitutor.EMPTY;
            if (jSTypeSubstitutor == null) {
                TypeScriptGenericTypesEvaluator.$$$reportNull$$$0(80);
            }
            return jSTypeSubstitutor;
        }
        TypeScriptTypeParameterList typeParameterList = ((TypeScriptTypeParameterListOwner)genericOwner).getTypeParameterList();
        if (typeParameterList == null) {
            JSTypeSubstitutor jSTypeSubstitutor = JSTypeSubstitutor.EMPTY;
            if (jSTypeSubstitutor == null) {
                TypeScriptGenericTypesEvaluator.$$$reportNull$$$0(81);
            }
            return jSTypeSubstitutor;
        }
        TypeScriptTypeParameter[] parameters = typeParameterList.getTypeParameters();
        if (parameters.length <= 0) {
            JSTypeSubstitutor jSTypeSubstitutor = JSTypeSubstitutor.EMPTY;
            if (jSTypeSubstitutor == null) {
                TypeScriptGenericTypesEvaluator.$$$reportNull$$$0(82);
            }
            return jSTypeSubstitutor;
        }
        Ref substitutor = Ref.create((Object)new JSTypeSubstitutor());
        TypeScriptGenericTypesEvaluator.processClassWithGenericArguments(contextClass, (List<JSType>)ContainerUtil.emptyList(), genericOwner, (Ref<JSTypeSubstitutor>)substitutor);
        JSTypeSubstitutor result2 = (JSTypeSubstitutor)substitutor.get();
        JSTypeSubstitutor jSTypeSubstitutor = result2 == null ? JSTypeSubstitutor.EMPTY : result2;
        if (jSTypeSubstitutor == null) {
            TypeScriptGenericTypesEvaluator.$$$reportNull$$$0(83);
        }
        return jSTypeSubstitutor;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 9: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 21: 
            case 22: 
            case 26: 
            case 33: 
            case 38: 
            case 39: 
            case 40: 
            case 41: 
            case 43: 
            case 44: 
            case 45: 
            case 51: 
            case 52: 
            case 53: 
            case 55: 
            case 56: 
            case 57: 
            case 58: 
            case 61: 
            case 62: 
            case 64: 
            case 66: 
            case 69: 
            case 72: 
            case 76: 
            case 77: 
            case 80: 
            case 81: 
            case 82: 
            case 83: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 9: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 21: 
            case 22: 
            case 26: 
            case 33: 
            case 38: 
            case 39: 
            case 40: 
            case 41: 
            case 43: 
            case 44: 
            case 45: 
            case 51: 
            case 52: 
            case 53: 
            case 55: 
            case 56: 
            case 57: 
            case 58: 
            case 61: 
            case 62: 
            case 64: 
            case 66: 
            case 69: 
            case 72: 
            case 76: 
            case 77: 
            case 80: 
            case 81: 
            case 82: 
            case 83: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "type";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "qualifier";
                break;
            }
            case 2: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "methodExpression";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 9: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 21: 
            case 22: 
            case 26: 
            case 33: 
            case 38: 
            case 39: 
            case 40: 
            case 41: 
            case 43: 
            case 44: 
            case 45: 
            case 51: 
            case 52: 
            case 53: 
            case 55: 
            case 56: 
            case 57: 
            case 58: 
            case 61: 
            case 62: 
            case 64: 
            case 66: 
            case 69: 
            case 72: 
            case 76: 
            case 77: 
            case 80: 
            case 81: 
            case 82: 
            case 83: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/typescript/resolve/TypeScriptGenericTypesEvaluator";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "recordType";
                break;
            }
            case 8: 
            case 14: 
            case 19: 
            case 23: {
                objectArray2 = objectArray3;
                objectArray3[0] = "qualifierType";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parameterTypes";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "arguments";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "qualifierClass";
                break;
            }
            case 24: 
            case 27: 
            case 29: 
            case 34: 
            case 35: 
            case 37: {
                objectArray2 = objectArray3;
                objectArray3[0] = "typeArgumentsList";
                break;
            }
            case 25: {
                objectArray2 = objectArray3;
                objectArray3[0] = "appliedGenerics";
                break;
            }
            case 28: 
            case 30: {
                objectArray2 = objectArray3;
                objectArray3[0] = "substitutor";
                break;
            }
            case 31: {
                objectArray2 = objectArray3;
                objectArray3[0] = "visitedClasses";
                break;
            }
            case 32: {
                objectArray2 = objectArray3;
                objectArray3[0] = "declarations";
                break;
            }
            case 36: 
            case 63: 
            case 65: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parameters";
                break;
            }
            case 42: {
                objectArray2 = objectArray3;
                objectArray3[0] = "place";
                break;
            }
            case 46: 
            case 54: {
                objectArray2 = objectArray3;
                objectArray3[0] = "expression";
                break;
            }
            case 47: {
                objectArray2 = objectArray3;
                objectArray3[0] = "typeParameters";
                break;
            }
            case 48: 
            case 71: 
            case 75: {
                objectArray2 = objectArray3;
                objectArray3[0] = "typeArguments";
                break;
            }
            case 49: {
                objectArray2 = objectArray3;
                objectArray3[0] = "genericArguments";
                break;
            }
            case 50: 
            case 68: {
                objectArray2 = objectArray3;
                objectArray3[0] = "callExpression";
                break;
            }
            case 60: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 67: 
            case 70: 
            case 73: {
                objectArray2 = objectArray3;
                objectArray3[0] = "functionType";
                break;
            }
            case 74: 
            case 84: {
                objectArray2 = objectArray3;
                objectArray3[0] = "defaultParamsSubstitutor";
                break;
            }
            case 78: {
                objectArray2 = objectArray3;
                objectArray3[0] = "contextClass";
                break;
            }
            case 79: {
                objectArray2 = objectArray3;
                objectArray3[0] = "genericOwner";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/typescript/resolve/TypeScriptGenericTypesEvaluator";
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "evaluateGenericsFromQualifier";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "evaluateThisType";
                break;
            }
            case 15: 
            case 16: 
            case 17: 
            case 18: {
                objectArray = objectArray2;
                objectArray2[1] = "getTypeSubstitutorFromQualifierType";
                break;
            }
            case 21: 
            case 22: {
                objectArray = objectArray2;
                objectArray2[1] = "getArgumentsListForQualifierType";
                break;
            }
            case 26: {
                objectArray = objectArray2;
                objectArray2[1] = "processClassWithGenericArguments";
                break;
            }
            case 33: {
                objectArray = objectArray2;
                objectArray2[1] = "getTypeArgumentsForDeclarations";
                break;
            }
            case 38: 
            case 39: {
                objectArray = objectArray2;
                objectArray2[1] = "getSubstitutorForTypeArguments";
                break;
            }
            case 40: 
            case 41: 
            case 43: 
            case 44: 
            case 45: {
                objectArray = objectArray2;
                objectArray2[1] = "getTypeSubstitutorForMember";
                break;
            }
            case 51: 
            case 52: 
            case 53: {
                objectArray = objectArray2;
                objectArray2[1] = "getArgumentTypesForSignatureChecking";
                break;
            }
            case 55: {
                objectArray = objectArray2;
                objectArray2[1] = "getExplicitTypeOrAny";
                break;
            }
            case 56: 
            case 57: 
            case 58: {
                objectArray = objectArray2;
                objectArray2[1] = "getQualifierClasses";
                break;
            }
            case 61: 
            case 62: {
                objectArray = objectArray2;
                objectArray2[1] = "getElementsForQualifierClassName";
                break;
            }
            case 64: 
            case 66: {
                objectArray = objectArray2;
                objectArray2[1] = "buildGenericParameters";
                break;
            }
            case 69: 
            case 72: {
                objectArray = objectArray2;
                objectArray2[1] = "applyTypeScriptGenericArguments";
                break;
            }
            case 76: 
            case 77: {
                objectArray = objectArray2;
                objectArray2[1] = "wrapNewExpressionReturnTypeWithGenerics";
                break;
            }
            case 80: 
            case 81: 
            case 82: 
            case 83: {
                objectArray = objectArray2;
                objectArray2[1] = "getTypeSubstitutorForExtendClass";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "evaluateGenericsFromQualifier";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 9: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 21: 
            case 22: 
            case 26: 
            case 33: 
            case 38: 
            case 39: 
            case 40: 
            case 41: 
            case 43: 
            case 44: 
            case 45: 
            case 51: 
            case 52: 
            case 53: 
            case 55: 
            case 56: 
            case 57: 
            case 58: 
            case 61: 
            case 62: 
            case 64: 
            case 66: 
            case 69: 
            case 72: 
            case 76: 
            case 77: 
            case 80: 
            case 81: 
            case 82: 
            case 83: {
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "isApplicableRecordTypeForThis";
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "evaluateThisType";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "evaluateGenericsFromQualifierType";
                break;
            }
            case 11: 
            case 12: 
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "hasGenericsCompatibilityErrors";
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "getTypeSubstitutorFromQualifierType";
                break;
            }
            case 19: 
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "getArgumentsListForQualifierType";
                break;
            }
            case 23: {
                objectArray = objectArray;
                objectArray[2] = "isInstanceJSTypeImpl";
                break;
            }
            case 24: 
            case 25: 
            case 27: 
            case 28: 
            case 29: 
            case 30: 
            case 31: {
                objectArray = objectArray;
                objectArray[2] = "processClassWithGenericArguments";
                break;
            }
            case 32: {
                objectArray = objectArray;
                objectArray[2] = "getTypeArgumentsForDeclarations";
                break;
            }
            case 34: 
            case 35: 
            case 36: 
            case 37: {
                objectArray = objectArray;
                objectArray[2] = "getSubstitutorForTypeArguments";
                break;
            }
            case 42: {
                objectArray = objectArray;
                objectArray[2] = "getTypeSubstitutorForMember";
                break;
            }
            case 46: {
                objectArray = objectArray;
                objectArray[2] = "getParameterExpressionType";
                break;
            }
            case 47: 
            case 48: 
            case 49: {
                objectArray = objectArray;
                objectArray[2] = "fillExplicitGenericArguments";
                break;
            }
            case 50: {
                objectArray = objectArray;
                objectArray[2] = "getArgumentTypesForSignatureChecking";
                break;
            }
            case 54: {
                objectArray = objectArray;
                objectArray[2] = "getExplicitTypeOrAny";
                break;
            }
            case 59: 
            case 60: {
                objectArray = objectArray;
                objectArray[2] = "getElementsForQualifierClassName";
                break;
            }
            case 63: 
            case 65: {
                objectArray = objectArray;
                objectArray[2] = "buildGenericParameters";
                break;
            }
            case 67: 
            case 68: 
            case 70: 
            case 71: {
                objectArray = objectArray;
                objectArray[2] = "applyTypeScriptGenericArguments";
                break;
            }
            case 73: 
            case 74: 
            case 75: {
                objectArray = objectArray;
                objectArray[2] = "wrapNewExpressionReturnTypeWithGenerics";
                break;
            }
            case 78: 
            case 79: {
                objectArray = objectArray;
                objectArray[2] = "getTypeSubstitutorForExtendClass";
                break;
            }
            case 84: {
                objectArray = objectArray;
                objectArray[2] = "lambda$wrapNewExpressionReturnTypeWithGenerics$4";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 9: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 21: 
            case 22: 
            case 26: 
            case 33: 
            case 38: 
            case 39: 
            case 40: 
            case 41: 
            case 43: 
            case 44: 
            case 45: 
            case 51: 
            case 52: 
            case 53: 
            case 55: 
            case 56: 
            case 57: 
            case 58: 
            case 61: 
            case 62: 
            case 64: 
            case 66: 
            case 69: 
            case 72: 
            case 76: 
            case 77: 
            case 80: 
            case 81: 
            case 82: 
            case 83: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

