/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.javaee.model;

import com.intellij.codeInsight.CodeInsightBundle;
import com.intellij.ide.IdeBundle;
import com.intellij.javaee.model.xml.JavaeeDomModelElement;
import com.intellij.javaee.model.xml.ejb.MethodParams;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.Ref;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiType;
import com.intellij.util.CommonProcessors;
import com.intellij.util.Function;
import com.intellij.util.Processor;
import com.intellij.util.Processors;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.xml.ConvertContext;
import com.intellij.util.xml.GenericDomValue;
import com.intellij.util.xml.ResolvingConverter;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Deprecated
public abstract class AbstractMethodResolveConverter<T extends JavaeeDomModelElement>
extends ResolvingConverter<PsiMethod> {
    public static final String ALL_METHODS = "*";
    private final Class<T> myDomMethodClass;

    protected AbstractMethodResolveConverter(Class<T> domMethodClass) {
        this.myDomMethodClass = domMethodClass;
    }

    @NotNull
    protected abstract Collection<PsiClass> getPsiClasses(T var1, ConvertContext var2);

    @Nullable
    protected abstract MethodParams getMethodParams(@NotNull T var1);

    public void bindReference(GenericDomValue<PsiMethod> genericValue, ConvertContext context, PsiElement element) {
        assert (element instanceof PsiMethod) : "PsiMethod expected";
        PsiMethod psiMethod = (PsiMethod)element;
        T parent = this.getParent(context);
        MethodParams methodParams = this.getMethodParams(parent);
        genericValue.setStringValue(psiMethod.getName());
        if (methodParams != null) {
            methodParams.undefine();
            for (PsiParameter parameter : psiMethod.getParameterList().getParameters()) {
                methodParams.addMethodParam().setValue((Object)parameter.getType());
            }
        }
    }

    public String getErrorMessage(String s, ConvertContext context) {
        T t = this.getParent(context);
        return CodeInsightBundle.message((String)"error.cannot.resolve.0.1", (Object[])new Object[]{IdeBundle.message((String)"element.method", (Object[])new Object[0]), AbstractMethodResolveConverter.getReferenceCanonicalText(s, this.getMethodParams(t))});
    }

    @NotNull
    protected final T getParent(ConvertContext context) {
        JavaeeDomModelElement javaeeDomModelElement = (JavaeeDomModelElement)context.getInvocationElement().getParentOfType(this.myDomMethodClass, true);
        if (javaeeDomModelElement == null) {
            AbstractMethodResolveConverter.$$$reportNull$$$0(0);
        }
        return (T)javaeeDomModelElement;
    }

    public boolean isReferenceTo(@NotNull PsiElement element, String stringValue, PsiMethod resolveResult, ConvertContext context) {
        if (element == null) {
            AbstractMethodResolveConverter.$$$reportNull$$$0(1);
        }
        if (super.isReferenceTo(element, stringValue, (Object)resolveResult, context)) {
            return true;
        }
        Ref result = new Ref((Object)Boolean.FALSE);
        this.processMethods(context, (Processor<PsiMethod>)((Processor)method -> {
            if (element == null) {
                AbstractMethodResolveConverter.$$$reportNull$$$0(5);
            }
            if (method.equals(element)) {
                result.set((Object)Boolean.TRUE);
                return false;
            }
            return true;
        }), (Function<PsiClass, PsiMethod[]>)((Function)s -> s.findMethodsByName(stringValue, true)));
        return (Boolean)result.get();
    }

    protected void processMethods(ConvertContext context, Processor<PsiMethod> processor, Function<PsiClass, PsiMethod[]> methodGetter) {
        for (PsiClass psiClass : this.getPsiClasses(this.getParent(context), context)) {
            if (psiClass == null) continue;
            for (PsiMethod psiMethod : (PsiMethod[])methodGetter.fun((Object)psiClass)) {
                if (processor.process((Object)psiMethod)) continue;
                return;
            }
        }
    }

    @NotNull
    public Collection<? extends PsiMethod> getVariants(ConvertContext context) {
        LinkedHashSet methodList = new LinkedHashSet();
        this.processMethods(context, (Processor<PsiMethod>)Processors.cancelableCollectProcessor(methodList), (Function<PsiClass, PsiMethod[]>)((Function)s -> {
            List list = ContainerUtil.findAll(this.getVariants((PsiClass)s), object -> AbstractMethodResolveConverter.methodSuits(object));
            return list.toArray(PsiMethod.EMPTY_ARRAY);
        }));
        LinkedHashSet linkedHashSet = methodList;
        if (linkedHashSet == null) {
            AbstractMethodResolveConverter.$$$reportNull$$$0(2);
        }
        return linkedHashSet;
    }

    protected Collection<PsiMethod> getVariants(PsiClass s) {
        return Arrays.asList(s.getAllMethods());
    }

    public static boolean methodSuits(PsiMethod psiMethod) {
        if (psiMethod.isConstructor()) {
            return false;
        }
        return psiMethod.getContainingClass().isInterface() || psiMethod.hasModifierProperty("public") && !psiMethod.hasModifierProperty("static");
    }

    @NotNull
    public Set<String> getAdditionalVariants(@NotNull ConvertContext context) {
        if (context == null) {
            AbstractMethodResolveConverter.$$$reportNull$$$0(3);
        }
        Set<String> set = Collections.singleton(ALL_METHODS);
        if (set == null) {
            AbstractMethodResolveConverter.$$$reportNull$$$0(4);
        }
        return set;
    }

    public PsiMethod fromString(String methodName, ConvertContext context) {
        CommonProcessors.FindFirstProcessor processor = new CommonProcessors.FindFirstProcessor();
        this.processMethods(context, (Processor<PsiMethod>)processor, (Function<PsiClass, PsiMethod[]>)((Function)s -> {
            PsiMethod method = AbstractMethodResolveConverter.findMethod(s, methodName, this.getMethodParams(this.getParent(context)));
            if (method != null && AbstractMethodResolveConverter.methodSuits(method)) {
                return new PsiMethod[]{method};
            }
            return PsiMethod.EMPTY_ARRAY;
        }));
        if (processor.isFound()) {
            return (PsiMethod)processor.getFoundValue();
        }
        this.processMethods(context, (Processor<PsiMethod>)processor, (Function<PsiClass, PsiMethod[]>)((Function)s -> s.findMethodsByName(methodName, true)));
        return (PsiMethod)processor.getFoundValue();
    }

    public String toString(PsiMethod method, ConvertContext context) {
        return method.getName();
    }

    public static String getReferenceCanonicalText(String name, @Nullable MethodParams methodParams) {
        StringBuilder sb = new StringBuilder(name);
        if (methodParams == null) {
            sb.append("()");
        } else if (methodParams.getXmlTag() != null) {
            sb.append("(");
            List<GenericDomValue<PsiType>> list = methodParams.getMethodParams();
            boolean first = true;
            for (GenericDomValue<PsiType> value : list) {
                if (first) {
                    first = false;
                } else {
                    sb.append(", ");
                }
                sb.append(value.getStringValue());
            }
            sb.append(")");
        }
        return sb.toString();
    }

    @Nullable
    public static PsiMethod findMethod(PsiClass psiClass, String methodName, @Nullable MethodParams methodParameters) {
        if (psiClass == null || methodName == null) {
            return null;
        }
        return (PsiMethod)ContainerUtil.find((Object[])psiClass.findMethodsByName(methodName, true), object -> AbstractMethodResolveConverter.methodParamsMatchSignature(methodParameters, object));
    }

    public static boolean methodParamsMatchSignature(@Nullable MethodParams params, PsiMethod psiMethod) {
        if (params != null && params.getXmlTag() == null) {
            return true;
        }
        PsiParameter[] parameters = psiMethod.getParameterList().getParameters();
        if (params == null) {
            return parameters.length == 0;
        }
        List<GenericDomValue<PsiType>> methodParams = params.getMethodParams();
        if (methodParams.size() != parameters.length) {
            return false;
        }
        for (int i = 0; i < parameters.length; ++i) {
            if (Comparing.equal((Object)parameters[i].getType(), (Object)methodParams.get(i).getValue())) continue;
            return false;
        }
        return true;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 1: 
            case 3: 
            case 5: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 1: 
            case 3: 
            case 5: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/javaee/model/AbstractMethodResolveConverter";
                break;
            }
            case 1: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getParent";
                break;
            }
            case 1: 
            case 3: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/javaee/model/AbstractMethodResolveConverter";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getVariants";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getAdditionalVariants";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "isReferenceTo";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "getAdditionalVariants";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "lambda$isReferenceTo$0";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 1: 
            case 3: 
            case 5: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

