/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jps.maven.model.impl;

import com.intellij.openapi.util.io.FileUtil;
import com.intellij.util.xmlb.annotations.Tag;
import com.intellij.util.xmlb.annotations.Transient;
import com.intellij.util.xmlb.annotations.XCollection;
import gnu.trove.THashMap;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.jps.maven.model.impl.ResourceRootConfiguration;

public class MavenWebArtifactConfiguration {
    @Tag(value="module-name")
    public String moduleName;
    @XCollection(propertyElementName="web-resources", elementName="resource")
    public List<ResourceRootConfiguration> webResources = new ArrayList<ResourceRootConfiguration>();
    @Tag(value="packaging-includes")
    public List<String> packagingIncludes = new ArrayList<String>();
    @Tag(value="packaging-excludes")
    public List<String> packagingExcludes = new ArrayList<String>();
    @Tag(value="war-root")
    public String warSourceDirectory = "src/main/webapp";
    @XCollection(propertyElementName="war-source-includes", elementName="include")
    public List<String> warSourceIncludes = new ArrayList<String>();
    @XCollection(propertyElementName="war-source-excludes", elementName="exclude")
    public List<String> warSourceExcludes = new ArrayList<String>();
    @Transient
    private volatile Map<File, ResourceRootConfiguration> myResourceRootsMap;

    @Nullable
    public ResourceRootConfiguration getRootConfiguration(@NotNull File root) {
        if (root == null) {
            MavenWebArtifactConfiguration.$$$reportNull$$$0(0);
        }
        if (this.myResourceRootsMap == null) {
            THashMap map = new THashMap(FileUtil.FILE_HASHING_STRATEGY);
            for (ResourceRootConfiguration resource : this.webResources) {
                map.put(new File(resource.directory), resource);
            }
            this.myResourceRootsMap = map;
        }
        return this.myResourceRootsMap.get(root);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "root", "org/jetbrains/jps/maven/model/impl/MavenWebArtifactConfiguration", "getRootConfiguration"));
    }
}

