/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.actions;

import com.intellij.database.actions.DataSourceCopySettingsAction;
import com.intellij.database.actions.DataSourceSettingsHelperKt;
import com.intellij.database.dataSource.LocalDataSource;
import com.intellij.database.psi.DbDataSource;
import com.intellij.database.view.DatabaseStructure;
import com.intellij.database.view.DatabaseView;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.ide.CopyPasteManager;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.openapi.util.Condition;
import com.intellij.util.Function;
import com.intellij.util.containers.JBIterable;
import java.awt.datatransfer.StringSelection;
import java.awt.datatransfer.Transferable;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 9}, bv={1, 0, 2}, k=1, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0016J\u0016\u0010\u0007\u001a\u00020\u00042\f\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\tH\u0002J\u0010\u0010\u000b\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0016\u00a8\u0006\f"}, d2={"Lcom/intellij/database/actions/DataSourceCopySettingsAction;", "Lcom/intellij/openapi/project/DumbAwareAction;", "()V", "actionPerformed", "", "e", "Lcom/intellij/openapi/actionSystem/AnActionEvent;", "doCopySettings", "dss", "", "Lcom/intellij/database/dataSource/LocalDataSource;", "update", "intellij.database.impl"})
public final class DataSourceCopySettingsAction
extends DumbAwareAction {
    public void update(@NotNull AnActionEvent e) {
        Intrinsics.checkParameterIsNotNull((Object)e, (String)"e");
        JBIterable dataSources2 = DatabaseView.getSelectedElements(e.getDataContext(), (Condition<DatabaseStructure.Group>)((Condition)update.dataSources.1.INSTANCE)).filter(DbDataSource.class);
        int count2 = dataSources2.filter((Condition)update.count.1.INSTANCE).take(2).size();
        boolean enabled = count2 > 0;
        boolean visible = enabled || dataSources2.isNotEmpty();
        e.getPresentation().setEnabled(enabled);
        e.getPresentation().setVisible(visible);
        if (count2 > 1) {
            e.getPresentation().setText("Copy Data Sources to Clipboard");
        }
    }

    public void actionPerformed(@NotNull AnActionEvent e) {
        Intrinsics.checkParameterIsNotNull((Object)e, (String)"e");
        List dataSources2 = DatabaseView.getSelectedElements(e.getDataContext(), (Condition<DatabaseStructure.Group>)((Condition)actionPerformed.dataSources.1.INSTANCE)).filterMap((Function)actionPerformed.dataSources.2.INSTANCE).filter(LocalDataSource.class).toList();
        Collection collection = dataSources2;
        if (!collection.isEmpty()) {
            List list = dataSources2;
            Intrinsics.checkExpressionValueIsNotNull((Object)list, (String)"dataSources");
            this.doCopySettings(list);
        }
    }

    private final void doCopySettings(List<? extends LocalDataSource> dss) {
        StringBuilder b = new StringBuilder(1024);
        b.append("#DataSourceSettings#").append('\n');
        for (LocalDataSource charSequence : dss) {
            DataSourceSettingsHelperKt.exportSettings(charSequence, b);
        }
        CharSequence charSequence = b;
        if (charSequence.length() == 0) {
            return;
        }
        CopyPasteManager.getInstance().setContents((Transferable)new StringSelection(b.toString()));
    }
}

