/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.actions;

import com.intellij.database.dataSource.DatabaseDriver;
import com.intellij.database.dataSource.LocalDataSource;
import com.intellij.database.dataSource.url.JdbcUrlParser;
import com.intellij.database.dataSource.url.JdbcUrlParserUtil;
import com.intellij.database.dataSource.url.StatelessJdbcUrlParser;
import com.intellij.database.model.DatabaseSystem;
import com.intellij.database.psi.DbDataSource;
import com.intellij.database.psi.DbPsiFacade;
import com.intellij.database.psi.DbPsiManager;
import com.intellij.database.vfs.DbStorageFileType;
import com.intellij.database.view.DatabaseView;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.containers.ContainerUtil;
import java.util.Collections;
import java.util.List;

public class OpenDbStorageAction
extends DumbAwareAction {
    public void update(AnActionEvent e) {
        Project project = OpenDbStorageAction.getEventProject((AnActionEvent)e);
        VirtualFile file = (VirtualFile)CommonDataKeys.VIRTUAL_FILE.getData(e.getDataContext());
        boolean enabled = project != null && file != null && file.getFileType() instanceof DbStorageFileType;
        e.getPresentation().setEnabled(enabled);
    }

    public void actionPerformed(AnActionEvent e) {
        List<Object> toSelect;
        Project project = OpenDbStorageAction.getEventProject((AnActionEvent)e);
        VirtualFile file = (VirtualFile)CommonDataKeys.VIRTUAL_FILE.getData(e.getDataContext());
        if (project == null || file == null || !(file.getFileType() instanceof DbStorageFileType)) {
            return;
        }
        DbPsiFacade facade = DbPsiFacade.getInstance((Project)project);
        DbDataSource existing = OpenDbStorageAction.findDataSourceByFile(facade, file);
        if (existing != null) {
            toSelect = Collections.singletonList(existing);
        } else {
            toSelect = ContainerUtil.newArrayList();
            for (DbPsiManager manager : facade.getDbManagers()) {
                toSelect.addAll(manager.createDataSourceByFiles(Collections.singletonList(file)));
            }
        }
        DatabaseView.select(project, true, toSelect);
    }

    private static DbDataSource findDataSourceByFile(DbPsiFacade facade, VirtualFile file) {
        for (DbDataSource element : facade.getDataSources()) {
            JdbcUrlParser parser;
            DatabaseDriver driver;
            LocalDataSource dataSource;
            DatabaseSystem delegate = element.getDelegate();
            if (!(delegate instanceof LocalDataSource) || StringUtil.isEmptyOrSpaces((String)(dataSource = (LocalDataSource)delegate).getUrl()) || (driver = dataSource.getDatabaseDriver()) == null || (parser = JdbcUrlParserUtil.stateful(JdbcUrlParserUtil.select(driver.getJDBCUrlParsers(), dataSource.getUrl(), StatelessJdbcUrlParser.LocationType.FILE))) == null) continue;
            parser.setUrlText(dataSource.getUrl());
            String dbFile = parser.getParameter("file");
            if (dbFile == null || !dbFile.endsWith(file.getPath())) continue;
            return element;
        }
        return null;
    }
}

