/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.autoconfig;

import com.intellij.database.autoconfig.DataSourceDetector;
import com.intellij.database.dataSource.AbstractDataSource;
import com.intellij.database.dataSource.DataSourceStorage;
import com.intellij.database.dataSource.DatabaseDriver;
import com.intellij.database.dataSource.DatabaseDriverImpl;
import com.intellij.database.dataSource.LocalDataSource;
import com.intellij.database.util.DbImplUtil;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.util.PsiUtilCore;
import com.intellij.util.ArrayUtil;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.MultiMap;
import com.intellij.util.ui.classpath.SimpleClasspathElementFactory;
import java.io.File;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DataSourceRegistry {
    private final Project myProject;
    private final Map<LocalDataSource, DataSourceDetector.Callback> myDataSources = ContainerUtil.newLinkedHashMap();

    public DataSourceRegistry(Project project) {
        this.myProject = project;
    }

    public DataSourceDetector.Builder getBuilder() {
        return new MyBuilder();
    }

    public boolean isEmpty() {
        return this.myDataSources.isEmpty();
    }

    public Collection<LocalDataSource> getDataSources() {
        return Collections.unmodifiableCollection(this.myDataSources.keySet());
    }

    @Nullable
    public DataSourceDetector.Callback getCallback(LocalDataSource dataSource) {
        return this.myDataSources.get(dataSource);
    }

    public Collection<? extends LocalDataSource> getNewDataSources() {
        if (this.myDataSources.isEmpty()) {
            return Collections.emptyList();
        }
        MultiMap uniqueNames = MultiMap.createLinked();
        for (LocalDataSource localDataSource : this.myDataSources.keySet()) {
            uniqueNames.putValue((Object)localDataSource.getName(), (Object)localDataSource);
        }
        for (AbstractDataSource abstractDataSource : DataSourceStorage.getProjectStorage(this.myProject).getDataSources()) {
            uniqueNames.remove((Object)abstractDataSource.getName());
        }
        return uniqueNames.values();
    }

    private static boolean isEmpty(@NotNull LocalDataSource tmp) {
        if (tmp == null) {
            DataSourceRegistry.$$$reportNull$$$0(0);
        }
        return StringUtil.isEmptyOrSpaces((String)tmp.getDriverClass()) && StringUtil.isEmptyOrSpaces((String)tmp.getUsername()) && StringUtil.isEmptyOrSpaces((String)tmp.getPassword()) && StringUtil.isEmptyOrSpaces((String)tmp.getUrl());
    }

    public void retainNewOnly() {
        this.myDataSources.keySet().retainAll(this.getNewDataSources());
    }

    public String toString() {
        return "DataSourceRegistry:" + this.myDataSources.size();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "tmp", "com/intellij/database/autoconfig/DataSourceRegistry", "isEmpty"));
    }

    private class MyBuilder
    implements DataSourceDetector.Builder {
        final Set<String> paths = ContainerUtil.newLinkedHashSet();
        LocalDataSource tmp = new LocalDataSource(true);
        DataSourceDetector.Callback callback;

        private MyBuilder() {
        }

        public DataSourceDetector.Builder commit(@NotNull String category, @Nullable Object origin) {
            if (category == null) {
                MyBuilder.$$$reportNull$$$0(0);
            }
            ProgressManager.checkCanceled();
            if (DataSourceRegistry.isEmpty(this.tmp)) {
                return this.reset();
            }
            DatabaseDriver driver = DbImplUtil.guessDatabaseDriver(this.tmp);
            if (driver != null) {
                this.tmp.setDatabaseDriver(driver);
                if (driver instanceof DatabaseDriverImpl) {
                    ((DatabaseDriverImpl)driver).setDefaultProperties(this.tmp);
                }
            }
            VirtualFile file = origin instanceof PsiElement ? PsiUtilCore.getVirtualFile((PsiElement)((PsiElement)origin)) : null;
            String path = file != null ? file.getPath() : null;
            String remarks = path == null ? category : path;
            this.tmp.setComment(remarks);
            this.tmp.setClasspathElements(SimpleClasspathElementFactory.createElements((String[])ArrayUtil.toStringArray(this.paths)));
            DataSourceRegistry.this.myDataSources.put(this.tmp, this.callback);
            return this.reset();
        }

        public DataSourceDetector.Builder reset() {
            this.tmp = new LocalDataSource(true);
            this.paths.clear();
            this.callback = null;
            return this;
        }

        public DataSourceDetector.Builder onCreate(@NotNull DataSourceDetector.Callback callback) {
            if (callback == null) {
                MyBuilder.$$$reportNull$$$0(1);
            }
            this.callback = callback;
            return this;
        }

        public DataSourceDetector.Builder withName(String s) {
            if (StringUtil.isEmptyOrSpaces((String)s)) {
                return this;
            }
            this.tmp.setName(s);
            return this;
        }

        public DataSourceDetector.Builder withDriverClass(String s) {
            if (StringUtil.isEmptyOrSpaces((String)s)) {
                return this;
            }
            this.tmp.setDriverClass(s);
            return this;
        }

        public DataSourceDetector.Builder withUrl(String s) {
            if (StringUtil.isEmptyOrSpaces((String)s)) {
                return this;
            }
            this.tmp.setUrlSmart(s);
            return this;
        }

        public DataSourceDetector.Builder withUser(String s) {
            if (StringUtil.isEmptyOrSpaces((String)s)) {
                return this;
            }
            this.tmp.setUsername(s);
            return this;
        }

        public DataSourceDetector.Builder withPassword(String s) {
            if (StringUtil.isEmptyOrSpaces((String)s)) {
                return this;
            }
            this.tmp.setPassword(s);
            return this;
        }

        public DataSourceDetector.Builder withDriverPath(String path) {
            if (StringUtil.isEmptyOrSpaces((String)path)) {
                return this;
            }
            for (String s : StringUtil.split((String)path, (String)File.pathSeparator, (boolean)true, (boolean)true)) {
                this.paths.add(VfsUtilCore.pathToUrl((String)s));
            }
            return this;
        }

        public DataSourceDetector.Builder with(@NotNull DataSourceDetector.Property property, String value) {
            if (property == null) {
                MyBuilder.$$$reportNull$$$0(2);
            }
            property.set((DataSourceDetector.Builder)this, value);
            return this;
        }

        public String toString() {
            return "Builder{" + this.tmp.getName() + "; " + this.tmp.getUsername() + "@" + this.tmp.getPassword() + "; " + this.tmp.getUrl() + '}';
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "category";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "callback";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "property";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/database/autoconfig/DataSourceRegistry$MyBuilder";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "commit";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "onCreate";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[2] = "with";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

