/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.autoconfig;

import com.intellij.database.DatabaseNotifications;
import com.intellij.database.actions.ImportDataSourceAction;
import com.intellij.database.autoconfig.DataSourceDetector;
import com.intellij.database.autoconfig.DataSourceRegistry;
import com.intellij.database.psi.DbPsiFacade;
import com.intellij.notification.Notification;
import com.intellij.notification.NotificationAction;
import com.intellij.notification.NotificationType;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.components.ProjectComponent;
import com.intellij.openapi.extensions.ExtensionPointName;
import com.intellij.openapi.extensions.Extensions;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.progress.util.ProgressIndicatorUtils;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.startup.StartupManager;
import com.intellij.util.Alarm;
import com.intellij.util.ui.update.MergingUpdateQueue;
import com.intellij.util.ui.update.Update;
import org.jetbrains.annotations.NotNull;

public class DatabaseConfigFileWatcher
implements ProjectComponent {
    private final Project myProject;
    private final MergingUpdateQueue myQueue;

    public DatabaseConfigFileWatcher(Project project) {
        this.myProject = project;
        this.myQueue = new MergingUpdateQueue(this.getComponentName(), 3000, true, null, (Disposable)project, null, Alarm.ThreadToUse.POOLED_THREAD);
        this.myQueue.setRestartTimerOnAdd(true);
        this.myProject.getMessageBus().connect().subscribe(DumbService.DUMB_MODE, (Object)new DumbService.DumbModeListener(){

            public void enteredDumbMode() {
                DatabaseConfigFileWatcher.this.myQueue.suspend();
            }

            public void exitDumbMode() {
                DatabaseConfigFileWatcher.this.myQueue.resume();
            }
        });
    }

    @NotNull
    public String getComponentName() {
        if ("DatabaseConfigFileWatcher" == null) {
            DatabaseConfigFileWatcher.$$$reportNull$$$0(0);
        }
        return "DatabaseConfigFileWatcher";
    }

    public void projectOpened() {
        if (ApplicationManager.getApplication().isHeadlessEnvironment()) {
            return;
        }
        StartupManager.getInstance((Project)this.myProject).runWhenProjectIsInitialized(new Runnable(){

            @Override
            public void run() {
                DatabaseConfigFileWatcher.this.myQueue.queue(new Update(DatabaseConfigFileWatcher.this.myProject){

                    public void run() {
                        boolean done;
                        DataSourceRegistry registry = new DataSourceRegistry(DatabaseConfigFileWatcher.this.myProject);
                        boolean bl = done = !DumbService.isDumb((Project)DatabaseConfigFileWatcher.this.myProject) && ProgressIndicatorUtils.runInReadActionWithWriteActionPriority(() -> DatabaseConfigFileWatcher.this.scanForNewConfigurations(registry));
                        if (!DatabaseConfigFileWatcher.this.myProject.isOpen()) {
                            return;
                        }
                        if (!done) {
                            DatabaseConfigFileWatcher.this.myQueue.queue((Update)this);
                            return;
                        }
                        if (registry.getNewDataSources().isEmpty()) {
                            return;
                        }
                        ApplicationManager.getApplication().invokeAndWait(() -> DatabaseConfigFileWatcher.notifyNewDataSourcesDetected(DatabaseConfigFileWatcher.this.myProject), ModalityState.NON_MODAL);
                    }

                    public boolean canEat(Update update2) {
                        return this.equals(update2);
                    }
                });
            }
        });
    }

    protected void scanForNewConfigurations(@NotNull DataSourceRegistry registry) {
        Module[] modules;
        if (registry == null) {
            DatabaseConfigFileWatcher.$$$reportNull$$$0(1);
        }
        Module[] moduleArray = modules = this.myProject.isDisposed() ? Module.EMPTY_ARRAY : ModuleManager.getInstance((Project)this.myProject).getModules();
        if (modules.length == 0) {
            return;
        }
        for (DataSourceDetector detector : (DataSourceDetector[])Extensions.getExtensions((ExtensionPointName)DataSourceDetector.EP_NAME)) {
            for (Module module : modules) {
                detector.collectDataSources(module, registry.getBuilder(), false);
            }
        }
    }

    private static void notifyNewDataSourcesDetected(final @NotNull Project project) {
        if (project == null) {
            DatabaseConfigFileWatcher.$$$reportNull$$$0(2);
        }
        if (!project.isOpen()) {
            return;
        }
        DatabaseNotifications.DATABASE_DETECTION_GROUP.createNotification("Data Sources Detected", "Connection properties are detected.", NotificationType.INFORMATION, null).addAction((AnAction)new NotificationAction("Configure"){

            public void actionPerformed(@NotNull AnActionEvent e, @NotNull Notification notification) {
                if (e == null) {
                    3.$$$reportNull$$$0(0);
                }
                if (notification == null) {
                    3.$$$reportNull$$$0(1);
                }
                notification.expire();
                ImportDataSourceAction.doImportAction(DbPsiFacade.getInstance((Project)project), true);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[3];
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[0] = "e";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[0] = "notification";
                        break;
                    }
                }
                objectArray[1] = "com/intellij/database/autoconfig/DatabaseConfigFileWatcher$3";
                objectArray[2] = "actionPerformed";
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        }).notify(project);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 1: 
            case 2: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 1: 
            case 2: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/database/autoconfig/DatabaseConfigFileWatcher";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "registry";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getComponentName";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/database/autoconfig/DatabaseConfigFileWatcher";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "scanForNewConfigurations";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "notifyNewDataSourcesDetected";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 1: 
            case 2: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

