/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.console;

import com.intellij.database.DataBus;
import com.intellij.database.DatabaseMessages;
import com.intellij.database.actions.DatabaseViewActions;
import com.intellij.database.datagrid.DataRequest;
import com.intellij.database.editor.DatabaseEditorHelper;
import com.intellij.database.run.AbstractQueryLanguageConsole;
import com.intellij.database.run.audit.JdbcSessionLogger;
import com.intellij.database.run.audit.SessionLogger;
import com.intellij.database.run.session.BaseJdbcSession;
import com.intellij.database.run.session.BaseSessionView;
import com.intellij.database.util.DbUIUtil;
import com.intellij.execution.console.LanguageConsoleView;
import com.intellij.execution.ui.ConsoleView;
import com.intellij.execution.ui.layout.PlaceInGrid;
import com.intellij.icons.AllIcons;
import com.intellij.ide.util.PropertiesComponent;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.actionSystem.EmptyAction;
import com.intellij.openapi.application.TransactionGuard;
import com.intellij.openapi.fileEditor.FileEditor;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.fileEditor.ex.FileEditorManagerEx;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Getter;
import com.intellij.openapi.util.Setter;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.wm.ex.ToolWindowEx;
import com.intellij.ui.AutoScrollFromSourceHandler;
import com.intellij.ui.components.JBLoadingPanel;
import com.intellij.ui.content.Content;
import com.intellij.ui.content.ContentManager;
import com.intellij.ui.content.ContentManagerAdapter;
import com.intellij.ui.content.ContentManagerEvent;
import com.intellij.ui.content.ContentManagerListener;
import icons.DatabaseIcons;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.LayoutManager;
import javax.swing.Icon;
import javax.swing.JComponent;
import org.jetbrains.annotations.NotNull;

public class BaseJdbcSessionView<S extends BaseJdbcSession<?>>
extends BaseSessionView<S> {
    public static final String SESSION_TOOLWINDOW_ID = DatabaseMessages.message((String)"jdbc.console.tab.title", (Object[])new Object[0]);
    private final AnAction myTerminateAction;
    private final AnAction myCloseAction;

    public BaseJdbcSessionView(@NotNull LanguageConsoleView languageConsole, @NotNull S session, @NotNull DataBus.Consuming messageBus) {
        if (languageConsole == null) {
            BaseJdbcSessionView.$$$reportNull$$$0(0);
        }
        if (session == null) {
            BaseJdbcSessionView.$$$reportNull$$$0(1);
        }
        if (messageBus == null) {
            BaseJdbcSessionView.$$$reportNull$$$0(2);
        }
        super(languageConsole.getProject(), messageBus, languageConsole, session);
        languageConsole.setPrompt("sql> ");
        this.myTerminateAction = new TerminateAction();
        this.myCloseAction = new CloseAction();
        JComponent shortcutTarget = this.getConsoleView().getConsoleEditor().getComponent();
        EmptyAction.setupAction((AnAction)this.myCloseAction, (String)"Console.Jdbc.Close", (JComponent)shortcutTarget);
        EmptyAction.setupAction((AnAction)this.myTerminateAction, (String)"Console.Jdbc.Terminate", (JComponent)shortcutTarget);
    }

    @Override
    @NotNull
    public String getToolWindowId() {
        String string = SESSION_TOOLWINDOW_ID;
        if (string == null) {
            BaseJdbcSessionView.$$$reportNull$$$0(3);
        }
        return string;
    }

    @NotNull
    public AnAction getTerminateAction() {
        AnAction anAction = this.myTerminateAction;
        if (anAction == null) {
            BaseJdbcSessionView.$$$reportNull$$$0(4);
        }
        return anAction;
    }

    public boolean isToolWindowContentPresent() {
        return this.getContent().getManager() != null;
    }

    @Override
    @NotNull
    public Icon getToolWindowIcon() {
        Icon icon = DatabaseIcons.ToolWindowConsole;
        if (icon == null) {
            BaseJdbcSessionView.$$$reportNull$$$0(5);
        }
        return icon;
    }

    @Override
    protected void setupToolWindow(@NotNull ToolWindowEx toolWindow) {
        if (toolWindow == null) {
            BaseJdbcSessionView.$$$reportNull$$$0(6);
        }
        Project project = this.getProject();
        DefaultActionGroup group2 = new DefaultActionGroup();
        MyAutoScrollFromHandler scrollFromHandler = new MyAutoScrollFromHandler(project, toolWindow);
        MyAutoScrollToHandler scrollToHandler = new MyAutoScrollToHandler(project, toolWindow);
        group2.addAction((AnAction)DatabaseViewActions.toggle("Autoscroll from Editor", (Getter<Boolean>)((Getter)scrollFromHandler::isAutoScrollEnabled), (Setter<Boolean>)((Setter)scrollFromHandler::setAutoScrollEnabled)));
        group2.addAction((AnAction)DatabaseViewActions.toggle("Autoscroll to Editor", (Getter<Boolean>)((Getter)scrollToHandler::isAutoScrollMode), (Setter<Boolean>)((Setter)scrollToHandler::setAutoScrollMode)));
        toolWindow.setAdditionalGearActions((ActionGroup)group2);
        ScrollFromEditorAction scrollFromEditorAction = new ScrollFromEditorAction(scrollFromHandler);
        scrollFromEditorAction.getTemplatePresentation().setHoveredIcon(AllIcons.General.LocateHover);
        toolWindow.setTitleActions(new AnAction[]{scrollFromEditorAction});
    }

    protected void closeToolWindowContent() {
        ContentManager manager = this.getContent().getManager();
        if (manager != null) {
            manager.removeContent(this.getContent(), false);
        }
    }

    @Override
    @NotNull
    protected SessionLogger createAuditor() {
        JdbcSessionLogger jdbcSessionLogger = new JdbcSessionLogger(this);
        if (jdbcSessionLogger == null) {
            BaseJdbcSessionView.$$$reportNull$$$0(7);
        }
        return jdbcSessionLogger;
    }

    @Override
    protected void buildConsoleUi(boolean focused) {
        this.getUi().getDefaults().initTabDefaults(0, SESSION_TOOLWINDOW_ID, null);
        this.getUi().getOptions().setMoveToGridActionEnabled(false).setMinimizeActionEnabled(false);
        JBLoadingPanel loadingPanel = new JBLoadingPanel((LayoutManager)new BorderLayout(), (Disposable)this);
        loadingPanel.setLoadingText("");
        loadingPanel.add((Component)this.getConsoleView().getComponent(), (Object)"Center");
        final String title = DatabaseMessages.message((String)"jdbc.console.tab.title.console", (Object[])new Object[0]);
        JComponent toFocus = this.getConsoleView().getHistoryViewer().getContentComponent();
        Content output = this.getUi().createContent("Input", (JComponent)loadingPanel, title, AllIcons.Debugger.Console, toFocus);
        DefaultActionGroup outputActions = new DefaultActionGroup();
        DbUIUtil.addLeftToolbarConsoleActions(outputActions, (ConsoleView)this.getConsoleView());
        output.setActions((ActionGroup)outputActions, "RunnerToolbar", this.getConsoleView().getComponent());
        DefaultActionGroup consoleActions = new DefaultActionGroup();
        this.populateActionGroup(consoleActions);
        for (AnAction action : consoleActions.getChildActionsOrStubs()) {
            action.registerCustomShortcutSet(action.getShortcutSet(), this.getUi().getComponent());
        }
        this.getUi().getOptions().setLeftToolbar((ActionGroup)consoleActions, "toolbar");
        this.getConsoleView().setConsoleEditorEnabled(false);
        if (focused) {
            FileEditorManager.getInstance((Project)this.getProject()).openFile(this.getConsoleView().getVirtualFile(), true);
        }
        output.setCloseable(false);
        this.getUi().addContent(output, 0, PlaceInGrid.center, false);
        this.getUi().getContentManager().addContentManagerListener((ContentManagerListener)new ContentManagerAdapter(){

            public void contentAdded(ContentManagerEvent event) {
                BaseJdbcSession session = (BaseJdbcSession)BaseJdbcSessionView.this.getSession();
                if (!session.isValid()) {
                    return;
                }
                if (title.equals(event.getContent().getDisplayName())) {
                    FileEditorManager.getInstance((Project)BaseJdbcSessionView.this.getProject()).openFile(session.getVirtualFile(), true, true);
                }
            }
        });
    }

    protected void populateActionGroup(@NotNull DefaultActionGroup group2) {
        if (group2 == null) {
            BaseJdbcSessionView.$$$reportNull$$$0(8);
        }
        group2.add(this.myTerminateAction);
        group2.add(this.myCloseAction);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 7: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 7: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "languageConsole";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "session";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "messageBus";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/database/console/BaseJdbcSessionView";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "toolWindow";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "group";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/database/console/BaseJdbcSessionView";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getToolWindowId";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getTerminateAction";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getToolWindowIcon";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "createAuditor";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 7: {
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "setupToolWindow";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "populateActionGroup";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 7: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private class TerminateAction
    extends DumbAwareAction {
        TerminateAction() {
            super(null, null, AllIcons.Actions.Suspend);
        }

        public void actionPerformed(@NotNull AnActionEvent e) {
            if (e == null) {
                TerminateAction.$$$reportNull$$$0(0);
            }
            BaseJdbcSession session = (BaseJdbcSession)BaseJdbcSessionView.this.getSession();
            session.getMessageBus().getDataProducer().processRequest(new DataRequest.Cancel(session));
        }

        public void update(@NotNull AnActionEvent e) {
            if (e == null) {
                TerminateAction.$$$reportNull$$$0(1);
            }
            BaseJdbcSession session = (BaseJdbcSession)BaseJdbcSessionView.this.getSession();
            e.getPresentation().setEnabled(session.isValid() && !session.isIdle());
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            objectArray2[0] = "e";
            objectArray2[1] = "com/intellij/database/console/BaseJdbcSessionView$TerminateAction";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "actionPerformed";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "update";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private class CloseAction
    extends DumbAwareAction {
        CloseAction() {
            super("Close", "Close", AllIcons.Actions.Cancel);
        }

        public void actionPerformed(@NotNull AnActionEvent e) {
            if (e == null) {
                CloseAction.$$$reportNull$$$0(0);
            }
            BaseJdbcSessionView.this.closeToolWindowContent();
        }

        public void update(@NotNull AnActionEvent e) {
            if (e == null) {
                CloseAction.$$$reportNull$$$0(1);
            }
            e.getPresentation().setEnabled(true);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            objectArray2[0] = "e";
            objectArray2[1] = "com/intellij/database/console/BaseJdbcSessionView$CloseAction";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "actionPerformed";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "update";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private static class ScrollFromEditorAction
    extends DumbAwareAction {
        private final MyAutoScrollFromHandler myScrollFromHandler;

        ScrollFromEditorAction(MyAutoScrollFromHandler scrollFromHandler) {
            super("Scroll from Editor", "Select console open in the active editor", AllIcons.General.Locate);
            this.myScrollFromHandler = scrollFromHandler;
        }

        public void actionPerformed(AnActionEvent e) {
            Project project = e.getProject();
            if (project == null) {
                return;
            }
            FileEditorManager manager = FileEditorManager.getInstance((Project)project);
            FileEditor[] editors = manager.getSelectedEditors();
            if (editors.length == 0) {
                return;
            }
            this.myScrollFromHandler.selectElementFromEditor(editors[0]);
        }
    }

    private static class MyAutoScrollToHandler {
        private static final String PROPERTY = "database.console.AUTO_SCROLL_TO_SOURCE";
        private final Project myProject;
        private boolean myEnabled;

        MyAutoScrollToHandler(final @NotNull Project project, @NotNull ToolWindowEx toolWindow) {
            if (project == null) {
                MyAutoScrollToHandler.$$$reportNull$$$0(0);
            }
            if (toolWindow == null) {
                MyAutoScrollToHandler.$$$reportNull$$$0(1);
            }
            this.myProject = project;
            this.myEnabled = PropertiesComponent.getInstance((Project)this.myProject).getBoolean(PROPERTY, true);
            toolWindow.getContentManager().addContentManagerListener((ContentManagerListener)new ContentManagerAdapter(){

                public void selectionChanged(ContentManagerEvent event) {
                    if (event.getOperation() == ContentManagerEvent.ContentOperation.add) {
                        TransactionGuard.submitTransaction((Disposable)project, () -> this.selectContentEditor(event.getContent()));
                    }
                }
            });
        }

        protected boolean isAutoScrollMode() {
            return this.myEnabled;
        }

        protected void setAutoScrollMode(boolean enabled) {
            this.myEnabled = enabled;
            PropertiesComponent.getInstance((Project)this.myProject).setValue(PROPERTY, enabled, true);
        }

        private void selectContentEditor(@NotNull Content content) {
            if (content == null) {
                MyAutoScrollToHandler.$$$reportNull$$$0(2);
            }
            if (!this.myEnabled || !this.myProject.isOpen()) {
                return;
            }
            FileEditorManagerEx manager = FileEditorManagerEx.getInstanceEx((Project)this.myProject);
            VirtualFile currentFile = manager.getCurrentFile();
            BaseJdbcSession<?> currentSession = currentFile == null ? null : DatabaseEditorHelper.findSession(currentFile, (FileEditorManager)manager);
            BaseJdbcSession session = (BaseJdbcSession)AbstractQueryLanguageConsole.getSessionIfPresent(content);
            if (session == null || currentSession == session) {
                return;
            }
            VirtualFile virtualFile = session.getVirtualFile();
            manager.openFile(virtualFile, false);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "toolWindow";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "content";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/database/console/BaseJdbcSessionView$MyAutoScrollToHandler";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[2] = "selectContentEditor";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private static class MyAutoScrollFromHandler
    extends AutoScrollFromSourceHandler {
        private static final String PROPERTY = "database.console.AUTO_SCROLL_FROM_SOURCE";
        private boolean myEnabled;

        MyAutoScrollFromHandler(@NotNull Project project, @NotNull ToolWindowEx toolWindow) {
            if (project == null) {
                MyAutoScrollFromHandler.$$$reportNull$$$0(0);
            }
            if (toolWindow == null) {
                MyAutoScrollFromHandler.$$$reportNull$$$0(1);
            }
            super(project, toolWindow.getComponent(), (Disposable)toolWindow.getContentManager());
            this.myEnabled = PropertiesComponent.getInstance((Project)this.myProject).getBoolean(PROPERTY, true);
            this.install();
        }

        protected boolean isAutoScrollEnabled() {
            return this.myEnabled;
        }

        protected void setAutoScrollEnabled(boolean enabled) {
            this.myEnabled = enabled;
            PropertiesComponent.getInstance((Project)this.myProject).setValue(PROPERTY, enabled, true);
        }

        protected void selectElementFromEditor(@NotNull FileEditor editor) {
            BaseJdbcSessionView view;
            FileEditorManagerEx manager;
            VirtualFile virtualFile;
            if (editor == null) {
                MyAutoScrollFromHandler.$$$reportNull$$$0(2);
            }
            if ((virtualFile = (manager = FileEditorManagerEx.getInstanceEx((Project)this.myProject)).getFile(editor)) == null) {
                return;
            }
            BaseJdbcSession<?> console = DatabaseEditorHelper.findSession(virtualFile, (FileEditorManager)manager);
            BaseJdbcSessionView baseJdbcSessionView = view = console == null ? null : (BaseJdbcSessionView)console.getView();
            if (view != null && view.isToolWindowContentPresent()) {
                view.show(true, false);
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "toolWindow";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "editor";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/database/console/BaseJdbcSessionView$MyAutoScrollFromHandler";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[2] = "selectElementFromEditor";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

