/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.data.types.domain;

import com.intellij.database.data.types.ConversionPoint;
import com.intellij.database.data.types.LogicalType;
import com.intellij.database.data.types.SizeProvider;
import com.intellij.database.data.types.domain.Cardinality;
import com.intellij.database.data.types.domain.Compatibility;
import com.intellij.database.data.types.domain.PhysicalDomainType;
import com.intellij.database.datagrid.mutating.ColumnDescriptor;
import com.intellij.openapi.util.text.StringUtil;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class Domain {
    public static final Domain EMPTY = new Domain(ConversionPoint.UNKNOWN, PhysicalDomainType.UNKNOWN, ""){

        @Override
        @NotNull
        public Cardinality cardinality() {
            Cardinality cardinality = Cardinality.EMPTY;
            if (cardinality == null) {
                1.$$$reportNull$$$0(0);
            }
            return cardinality;
        }

        @Override
        @NotNull
        public Compatibility getCompatibility(@NotNull Domain domain) {
            if (domain == null) {
                1.$$$reportNull$$$0(1);
            }
            Compatibility compatibility = Compatibility.uncompatible();
            if (compatibility == null) {
                1.$$$reportNull$$$0(2);
            }
            return compatibility;
        }

        @Override
        @Nullable
        public Object trim(@NotNull Object o) {
            if (o == null) {
                1.$$$reportNull$$$0(3);
            }
            return o;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
                case 1: 
                case 3: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 2;
                    break;
                }
                case 1: 
                case 3: {
                    n2 = 3;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/database/data/types/domain/Domain$1";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "domain";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "o";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "cardinality";
                    break;
                }
                case 1: 
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/database/data/types/domain/Domain$1";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getCompatibility";
                    break;
                }
            }
            switch (n) {
                default: {
                    break;
                }
                case 1: {
                    objectArray = objectArray;
                    objectArray[2] = "getCompatibility";
                    break;
                }
                case 3: {
                    objectArray = objectArray;
                    objectArray[2] = "trim";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
                case 1: 
                case 3: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    };
    private final ConversionPoint myPoint;
    private final PhysicalDomainType myDomainType;
    private final String myName;

    protected Domain(@NotNull ConversionPoint point, @NotNull PhysicalDomainType type, @NotNull String name) {
        if (point == null) {
            Domain.$$$reportNull$$$0(0);
        }
        if (type == null) {
            Domain.$$$reportNull$$$0(1);
        }
        if (name == null) {
            Domain.$$$reportNull$$$0(2);
        }
        this.myPoint = point;
        this.myDomainType = type;
        this.myName = name;
    }

    @NotNull
    public PhysicalDomainType getDomainType() {
        PhysicalDomainType physicalDomainType = this.myDomainType;
        if (physicalDomainType == null) {
            Domain.$$$reportNull$$$0(3);
        }
        return physicalDomainType;
    }

    @NotNull
    public ConversionPoint getPoint() {
        ConversionPoint conversionPoint = this.myPoint;
        if (conversionPoint == null) {
            Domain.$$$reportNull$$$0(4);
        }
        return conversionPoint;
    }

    public boolean contains(@NotNull Domain domain) {
        if (domain == null) {
            Domain.$$$reportNull$$$0(5);
        }
        return this.getCompatibility(domain).isCanContains();
    }

    @NotNull
    public Domain narrow(@NotNull Domain domain) {
        if (domain == null) {
            Domain.$$$reportNull$$$0(6);
        }
        Domain domain2 = this;
        if (domain2 == null) {
            Domain.$$$reportNull$$$0(7);
        }
        return domain2;
    }

    @NotNull
    public Domain narrow(@NotNull SizeProvider provider) {
        if (provider == null) {
            Domain.$$$reportNull$$$0(8);
        }
        Domain domain = this;
        if (domain == null) {
            Domain.$$$reportNull$$$0(9);
        }
        return domain;
    }

    @NotNull
    public String name() {
        String string = this.simpleName();
        if (string == null) {
            Domain.$$$reportNull$$$0(10);
        }
        return string;
    }

    @NotNull
    public String simpleName() {
        String string = StringUtil.toUpperCase((String)this.myName);
        if (string == null) {
            Domain.$$$reportNull$$$0(11);
        }
        return string;
    }

    public String toString() {
        return this.myName + " " + this.getPoint() + " " + (Object)((Object)this.getDomainType());
    }

    public boolean isSuitable(@NotNull ColumnDescriptor descriptor) {
        if (descriptor == null) {
            Domain.$$$reportNull$$$0(12);
        }
        return StringUtil.equalsIgnoreCase((CharSequence)this.myName, (CharSequence)StringUtil.toLowerCase((String)descriptor.getTypeName()));
    }

    @NotNull
    public LogicalType getLogicType() {
        LogicalType logicalType = this.getPoint().getLogicalType();
        if (logicalType == null) {
            Domain.$$$reportNull$$$0(13);
        }
        return logicalType;
    }

    @NotNull
    public abstract Cardinality cardinality();

    @NotNull
    public abstract Compatibility getCompatibility(@NotNull Domain var1);

    @Nullable
    public abstract Object trim(@NotNull Object var1);

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 3: 
            case 4: 
            case 7: 
            case 9: 
            case 10: 
            case 11: 
            case 13: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 3: 
            case 4: 
            case 7: 
            case 9: 
            case 10: 
            case 11: 
            case 13: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "point";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "type";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 3: 
            case 4: 
            case 7: 
            case 9: 
            case 10: 
            case 11: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/database/data/types/domain/Domain";
                break;
            }
            case 5: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "domain";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "provider";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "descriptor";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/database/data/types/domain/Domain";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getDomainType";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getPoint";
                break;
            }
            case 7: 
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "narrow";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "name";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "simpleName";
                break;
            }
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "getLogicType";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 3: 
            case 4: 
            case 7: 
            case 9: 
            case 10: 
            case 11: 
            case 13: {
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "contains";
                break;
            }
            case 6: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "narrow";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "isSuitable";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 3: 
            case 4: 
            case 7: 
            case 9: 
            case 10: 
            case 11: 
            case 13: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

